<?php

/**
 * General Tab.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (class_exists('WAL_General_Tab')) {
	return new WAL_General_Tab();
}

/**
 * Class.
 */
class WAL_General_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id = 'general';
		$this->label = __('General', 'wallet-for-woocommerce');

		parent::__construct();
	}

	/**
	 * Get the sections.
	 * 
	 * @return array
	 */
	public function get_sections() {
		$sections = array(
			'general' => __('General', 'wallet-for-woocommerce'),
			'topup' => __('Funds Top-up', 'wallet-for-woocommerce'),
			'fund_usage' => __('Funds Usage', 'wallet-for-woocommerce'),
		);
		/**
		 * This hook is used to alter the general tab sections.
		 * 
		 * @since 1.0
		 */
		return apply_filters($this->get_plugin_slug() . '_get_sections_' . $this->get_id(), $sections);
	}

	/**
	 * Get settings for general section array.
	 * 
	 * @return array
	 */
	protected function general_section_array() {
		$section_fields = array();

		// General section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('General Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_general_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Balance Expires After', 'wallet-for-woocommerce'),
			'type' => 'number',
			'default' => '365',
			'autoload' => false,
			'custom_attributes' => array( 'min' => 1 ),
			'id' => $this->get_option_key('wallet_balance_expired_days'),
			'desc' => __('day(s) from the date of funds credited to the account.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Expiry Date Visibility', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('hide_expiry_column'),
			'desc' => __('If enabled, the expiry date will be hidden from the Wallet Dashboard.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Dashboard URL', 'wallet-for-woocommerce'),
			'id' => 'woocommerce_wal_dashboard_page_id',
			'default' => wc_get_page_id('wal_dashboard'),
			'autoload' => false,
			'type' => 'single_select_page',
			'class' => 'wc-enhanced-select-nostd',
			'args' => array(
				'exclude' =>
				array(
					wc_get_page_id('cart'),
					wc_get_page_id('checkout'),
				),
			),
			'desc_tip' => true,
			'desc' => __('Select the page where you have placed the dashboard shortcode.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Top-up Page URL', 'wallet-for-woocommerce'),
			'id' => 'woocommerce_wal_topup_page_id',
			'default' => wc_get_page_id('wal_dashboard'),
			'autoload' => false,
			'type' => 'single_select_page',
			'class' => 'wc-enhanced-select-nostd',
			'args' => array(
				'exclude' =>
				array(
					wc_get_page_id('cart'),
					wc_get_page_id('checkout'),
				),
			),
			'desc_tip' => true,
			'desc' => __('Select the page where you have placed the top-up shortcode.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_general_options',
		);
		// General section end.
		// Display section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Display Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_display_options',
		);
				$section_fields[] = array(
				'title' => __('Pagination Size', 'wallet-for-woocommerce'),
				'type' => 'number',
				'default' => '5',
				'autoload' => false,
				'custom_attributes' => array( 'min' => 1 ),
				'id' => $this->get_option_key('transaction_logs_pagination_count'),
				'desc' => __('You can set the number of entries to be displayed in each pagination for the Transaction Log[Wallet Dashboard -> Wallet Activity].', 'wallet-for-woocommerce'),
				);
				$section_fields[] = array(
				'title' => __('Pagination Range', 'wallet-for-woocommerce'),
				'type' => 'number',
				'default' => '5',
				'autoload' => false,
				'custom_attributes' => array( 'min' => 1 ),
				'id' => $this->get_option_key('transaction_logs_pagination_range'),
				'desc' => __('You can set the number of paginations to be displayed at a time in Transaction Log.', 'wallet-for-woocommerce'),
				);
				$section_fields[] = array(
				'type' => 'sectionend',
				'id' => 'wal_display_options',
				);
				// Display section end.
				// Myaccount section start.
				$section_fields[] = array(
				'type' => 'title',
				'title' => __('My Account Settings', 'wallet-for-woocommerce'),
				'id' => 'wal_myaccount_options',
				);
				$section_fields[] = array(
					'title' => __('Wallet Menu', 'wallet-for-woocommerce'),
					'type' => 'checkbox',
					'default' => 'no',
					'autoload' => false,
					'id' => $this->get_option_key('hide_wallet_myaccount_menu'),
					'desc' => __('By enabling this checkbox, you can hide the wallet menu displayed on the My Account page.', 'wallet-for-woocommerce'),
					);
					$section_fields[] = array(
					'title' => __('Display Wallet Menu on My Account Page after', 'wallet-for-woocommerce'),
					'type' => 'select',
					'default' => 'dashboard',
					'autoload' => false,
					'id' => $this->get_option_key('wallet_myaccount_menu_position'),
					'options' => wc_get_account_menu_items(),
					);
					$section_fields[] = array(
					'type' => 'sectionend',
					'id' => 'wal_myaccount_options',
					);
					// Myaccount section end.
					return $section_fields;
	}

	/**
	 * Get settings for topup section array.
	 * 
	 * @return array
	 */
	protected function topup_section_array() {
		$section_fields = array();
		$wp_user_roles = wal_get_wp_user_roles();
		$available_gateways = wal_get_wc_available_gateways();

		// Topup general section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('General Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_general_options',
		);
		$section_fields[] = array(
			'title' => __('Allow Users to Deposit Funds', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'yes',
			'autoload' => false,
			'id' => $this->get_option_key('enable_topup'),
			'desc' => __('If enabled, your customers can Top-up their wallet.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up Product', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('topup_product_id'),
			'action' => 'wal_json_search_products_and_variations',
			'class' => 'wal-topup-product-selection',
			'type' => 'wal_custom_fields',
			'list_type' => 'products',
			'wal_field' => 'ajaxmultiselect',
			'placeholder' => __('Select a Product', 'wallet-for-woocommerce'),
			'multiple' => false,
			'allow_clear' => true,
			'autoload' => false,
			'desc_tip' => true,
			'desc' => __('If you have set topup shortcode,please select that page.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Funds will be Added to Wallet when Order Status Reaches', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array( 'completed' ),
			'autoload' => false,
			'class' => 'wal_select2',
			'options' => wal_get_wc_order_statuses(false),
			'id' => $this->get_option_key('topup_order_status'),
		);
		$section_fields[] = array(
			'title' => __('Predefined Buttons for Top-up', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => '',
			'autoload' => false,
			'placeholder' => '10,100,500,1000',
			'id' => $this->get_option_key('topup_predefined_buttons'),
		);
		$section_fields[] = array(
			'title' => __('Top-up Increment Amount', 'wallet-for-woocommerce'),
			'type' => 'number',
			'default' => '',
			'autoload' => false,
			'custom_attributes' => array( 'min' => 1 ),
			'id' => $this->get_option_key('topup_amount_incrementor'),
			'desc' => __('Set the increment value for the top-up amount.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Retain Previous Cart', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('retain_cart_after_topup'),
			'desc' => __("By enabling this checkbox, products added to the cart won't be removed after top-up the funds.", 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_general_options',
		);
		// Topup general section end.
		// Topup bonus section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Top-up Bonus Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_bonus_options',
		);
		$section_fields[] = array(
			'title' => __('Top-up Bonus', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('enable_topup_bonus'),
			'desc' => __('By enabling this checkbox, you can award bonus amount to your users on top of recharging amount.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Rule Priority', 'wallet-for-woocommerce'),
			'type' => 'select',
			'default' => '1',
			'autoload' => false,
			'id' => $this->get_option_key('topup_bonus_rule_type'),
			'class' => 'wal-topup-bonus-enable',
			'options' => array(
				'1' => __('First Matched Rule', 'wallet-for-woocommerce'),
				'2' => __('Last Matched Rule', 'wallet-for-woocommerce'),
				'3' => __('Minimum Bonus Matched Rule', 'wallet-for-woocommerce'),
				'4' => __('Maximum Bonus Matched Rule', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'type' => 'wal_custom_fields',
			'wal_field' => 'topup_bonus',
			'id' => $this->get_option_key('topup_bonus_rules'),
			'default' => array(),
			'class' => 'wal-topup-bonus-enable',
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_bonus_options',
		);
		// Topup bonus section end.
		// Topup restriction section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Restriction Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_restriction_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up Applicable for', 'wallet-for-woocommerce'),
			'type' => 'select',
			'default' => '1',
			'autoload' => false,
			'id' => $this->get_option_key('topup_user_restriction_type'),
			'class' => 'wal-user-restriction-type',
			'options' => array(
				'1' => __('All Users', 'wallet-for-woocommerce'),
				'2' => __('Include Users', 'wallet-for-woocommerce'),
				'3' => __('Exclude Users', 'wallet-for-woocommerce'),
				'4' => __('Include User Roles', 'wallet-for-woocommerce'),
				'5' => __('Exclude User Roles', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('Select Users', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'ajaxmultiselect',
			'list_type' => 'customers',
			'action' => 'wal_json_search_customers',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a User', 'wallet-for-woocommerce'),
			'class' => 'wal-user-restriction-field wal-include-users-field',
			'id' => $this->get_option_key('topup_include_users'),
		);
		$section_fields[] = array(
			'title' => __('Select Users', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'ajaxmultiselect',
			'list_type' => 'customers',
			'class' => 'wal-user-restriction-field wal-exclude-users-field',
			'action' => 'wal_json_search_customers',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a User', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('topup_exclude_users'),
		);
		$section_fields[] = array(
			'title' => __('Select User Roles', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'custom_attributes' => array( 'placeholder' => __('Select a User Role', 'wallet-for-woocommerce') ),
			'class' => 'wal_select2 wal-user-restriction-field wal-include-user-roles-field',
			'id' => $this->get_option_key('topup_include_user_roles'),
			'options' => $wp_user_roles,
		);
		$section_fields[] = array(
			'title' => __('Select User Roles', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'custom_attributes' => array( 'placeholder' => __('Select a User Role', 'wallet-for-woocommerce') ),
			'class' => 'wal_select2 wal-user-restriction-field wal-exclude-user-roles-field',
			'id' => $this->get_option_key('topup_exclude_user_roles'),
			'options' => $wp_user_roles,
		);
		$section_fields[] = array(
			'title' => __('Minimum Amount for Top-up', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('topup_min_amount'),
			'desc' => __('You can set the minimum amount required for wallet top-up.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Amount for Top-up', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('topup_max_amount'),
			'desc' => __('You can set the maximum amount which the user can top-up to their wallet', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Wallet Balance Per User', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('topup_max_wallet_balance'),
			'desc' => __('You can set the maximum wallet balance that can be accumulated by a customer.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Restrict WooCommerce Coupon Usage for Top-up', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('disable_topup_product_coupon_discount'),
			'desc' => __('If enabled, users cannot get a discount when applying WooCommerce Coupon in Cart & Checkout during Top-up.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Hide Selected Payment Gateways during Wallet Top-up', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array( 'bacs', 'cheque', 'cod' ),
			'autoload' => false,
			'class' => 'wal_select2',
			'options' => $available_gateways,
			'id' => $this->get_option_key('topup_restrict_payment_gateways'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_restriction_options',
		);
		// Topup restriction section end.
		// Topup security section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Security Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_security_options',
		);
		$section_fields[] = array(
			'title' => __('Maximum No.of Top-up Per Day', 'wallet-for-woocommerce'),
			'type' => 'number',
			'default' => '',
			'autoload' => false,
			'custom_attributes' => array( 'min' => 1 ),
			'id' => $this->get_option_key('topup_count_per_day'),
			'desc' => __('You can set a maximum number of top-up can be done per day.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Top-up Amount Per Day', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('topup_max_amount_per_day'),
			'desc' => __('You can set a maximum amount that can be top-up per day.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_security_options',
		);
		// Topup security section end.
		// Topup Troubleshoot section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Troubleshoot Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_troubleshoot_options',
		);
		$section_fields[] = array(
			'title' => __('Top-up Product', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('troubleshoot_for_topup_product'),
			'desc' => __('If enabled, payment gateway(s) will be displayed in the checkout block without reloading.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_troubleshoot_options',
		);
		// Topup security section end.

		return $section_fields;
	}

	/**
	 * Get settings for fund usage section array.
	 * 
	 * @return array
	 */
	protected function fund_usage_section_array() {
		$section_fields = array();
		$wc_categories = wal_get_wc_categories();
		$wp_user_roles = wal_get_wp_user_roles();
		// partial payment section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Partial Payments Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_partial_payment_options',
		);
		$section_fields[] = array(
			'title' => __('Allow Partial Payments using Wallet', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('allow_partial_payments'),
			'desc' => __('By enabling this checkbox, your users will be able to pay partially using their wallet and the remaining amount using other payment gateways.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Allow Partial Payments', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('partial_payments_mode'),
			'default' => '1',
			'autoload' => false,
			'type' => 'select',
			'class' => 'wal-partial-payment-field',
			'options' => array(
				'1' => __('When Wallet Balance is Less than Order Total', 'wallet-for-woocommerce'),
				'2' => __('Any Time', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('Funds Usage Type', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('partial_payments_max_amount_type'),
			'default' => '1',
			'autoload' => false,
			'type' => 'select',
			'class' => 'wal-partial-payment-field',
			'options' => array(
				'1' => __('Fixed Value', 'wallet-for-woocommerce'),
				'2' => __('Percentage of Order Total', 'wallet-for-woocommerce'),
			),
			'desc_tip' => true,
			'desc' => __('When choosing <b>Fixed Value</b> - Maximum Funds Usage in Order.</br> When choosing <b>Percentage of Order Total</b> - Maximum Funds Usage (Discount) for Order in Percentage %.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Funds Usage in Order', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'class' => 'wal-partial-payment-field',
			'id' => $this->get_option_key('partial_payments_max_amount'),
			'desc' => __('You can set the maximum wallet funds that can be used in the order.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Auto Deduct Wallet balance', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'class' => 'wal-partial-payment-field',
			'id' => $this->get_option_key('auto_deduct_wallet_for_partial_payments'),
			'desc' => __('By enabling this checkbox, the wallet balance will be deducted automatically from the users account once the product is added to the cart.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Display Wallet Funds Redeem field on', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'checkboxgroup' => 'start',
			'default' => 'no',
			'autoload' => false,
			'class' => 'wal-partial-payment-field',
			'id' => $this->get_option_key('allow_partial_payments_cart_page'),
			'desc' => __('Cart Page', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => 'end',
			'default' => 'no',
			'autoload' => false,
			'class' => 'wal-partial-payment-field',
			'id' => $this->get_option_key('allow_partial_payments_checkout_page'),
			'desc' => __('Checkout Page', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_partial_payment_options',
		);
		// Partial payment section end.
		// Wallet Payment Gateway section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Wallet Payment Gateway Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_wallet_payment_gateway_options',
		);
		$section_fields[] = array(
			'title' => __('Order Status for Wallet Payment Gateway', 'wallet-for-woocommerce'),
			'type' => 'select',
			'default' => 'processing',
			'autoload' => false,
			'options' => wal_get_wc_order_statuses(false),
			'id' => $this->get_option_key('default_gateway_order_status'),
			'desc' => __('When an order is placed using Wallet Payment Gateway, it will reach the status set in this option.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Discount for using Wallet Gateway', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('apply_discount_for_wallet_gateway'),
			'desc' => __('By enabling this checkbox, you can give discounts to your users when they choose wallet payment gateway at checkout.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Discount Type', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('discount_type'),
			'default' => '1',
			'autoload' => false,
			'type' => 'select',
			'class' => 'wal-discount-field',
			'options' => array(
				'1' => __('Fixed Value', 'wallet-for-woocommerce'),
				'2' => __('Percentage of Cart Subtotal', 'wallet-for-woocommerce'),
				'3' => __('Percentage of Order Total', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('Enter the value', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'class' => 'wal-discount-field',
			'id' => $this->get_option_key('discount_value'),
			'desc' => __('You can set the discount value.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Payment Gateway Visibility at Checkout', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('hide_other_wc_payment_gateways'),
			'desc' => __('By enabling this checkbox, you can hide other payment gateways at checkout when the wallet payment gateway is visible.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Payment Gateway Visibility based on Available Funds', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('hide_wallet_payment_gateway_in_checkout'),
			'desc' => __('By enabling this checkbox, you can hide the wallet payment gateway at checkout when the user does not have enough funds to place the order.', 'wallet-for-woocommerce'),
				);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_wallet_payment_gateway_options',
		);
		// Wallet Payment Gateway section end.
		// Fund usage restriction section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Restriction Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_fund_usage_restriction_options',
		);
		$section_fields[] = array(
			'title' => __('Minimum Cart Subtotal for Wallet Usage', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_min_cart_total'),
			'desc' => __('You can set a minimum cart total required to use the wallet funds.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Cart Subtotal for Wallet Usage', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_max_cart_total'),
			'desc' => __('Wallet funds cannot be used when the cart total exceeds the value configured in this field.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Restrict Wallet Usage', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'datepicker',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_from_date'),
			'placeholder' => __('From date', 'wallet-for-woocommerce') . ' : ' . WAL_Date_Time::get_wp_date_format(),
			'class' => 'wal_datepicker',
		);
		$section_fields[] = array(
			'type' => 'wal_custom_fields',
			'wal_field' => 'datepicker',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_to_date'),
			'placeholder' => __('To date', 'wallet-for-woocommerce') . ' : ' . WAL_Date_Time::get_wp_date_format(),
			'class' => 'wal_datepicker',
		);
		$section_fields[] = array(
			'title' => __('Restrict Wallet Usage on Following Day(s)', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'checkboxgroup' => 'start',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_7'),
			'desc' => __('Sunday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => '',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_1'),
			'desc' => __('Monday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => '',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_2'),
			'desc' => __('Tuesday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => '',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_3'),
			'desc' => __('Wednesday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => '',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_4'),
			'desc' => __('Thursday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => '',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_5'),
			'desc' => __('Friday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'checkbox',
			'checkboxgroup' => 'end',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_restrict_6'),
			'desc' => __('Saturday', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Funds can be Used for Purchasing', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_product_restriction_type'),
			'type' => 'select',
			'default' => '1',
			'autoload' => false,
			'class' => 'wal-product-restriction-type',
			'options' => array(
				'1' => __('All Product(s)', 'wallet-for-woocommerce'),
				'2' => __('Only for Selected Product(s)', 'wallet-for-woocommerce'),
				'3' => __('Excluding Selected Product(s)', 'wallet-for-woocommerce'),
				'4' => __('Only for Products under Selected Categories', 'wallet-for-woocommerce'),
				'5' => __('Excluding Products under Selected Categories', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('Select Product(s)', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_include_product'),
			'action' => 'wal_json_search_products',
			'class' => 'wal-product-restriction-field wal-include-product-field',
			'type' => 'wal_custom_fields',
			'list_type' => 'products',
			'wal_field' => 'ajaxmultiselect',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a Product', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Select Product(s)', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_exclude_product'),
			'action' => 'wal_json_search_products',
			'class' => 'wal-product-restriction-field wal-exclude-product-field',
			'type' => 'wal_custom_fields',
			'list_type' => 'products',
			'wal_field' => 'ajaxmultiselect',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a Product', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Select Categories', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_include_categories'),
			'class' => 'wal-product-restriction-field wal_select2 wal-include-categories-field',
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'options' => $wc_categories,
		);
		$section_fields[] = array(
			'title' => __('Select Categories', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_exclude_categories'),
			'class' => 'wal-product-restriction-field wal_select2 wal-exclude-categories-field',
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'options' => $wc_categories,
		);
		$section_fields[] = array(
			'title' => __('Wallet Usage is applicable for', 'wallet-for-woocommerce'),
			'type' => 'select',
			'default' => '1',
			'autoload' => false,
			'class' => 'wal-user-restriction-type',
			'id' => $this->get_option_key('wallet_usage_user_restriction_type'),
			'options' => array(
				'1' => __('All Users', 'wallet-for-woocommerce'),
				'2' => __('Include Users', 'wallet-for-woocommerce'),
				'3' => __('Exclude Users', 'wallet-for-woocommerce'),
				'4' => __('Include User Roles', 'wallet-for-woocommerce'),
				'5' => __('Exclude User Roles', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('Select Users', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'ajaxmultiselect',
			'list_type' => 'customers',
			'action' => 'wal_json_search_customers',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a User', 'wallet-for-woocommerce'),
			'class' => 'wal-user-restriction-field wal-include-users-field',
			'id' => $this->get_option_key('wallet_usage_include_users'),
		);
		$section_fields[] = array(
			'title' => __('Select Users', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'ajaxmultiselect',
			'list_type' => 'customers',
			'class' => 'wal-user-restriction-field wal-exclude-users-field',
			'action' => 'wal_json_search_customers',
			'default' => array(),
			'autoload' => false,
			'placeholder' => __('Select a User', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('wallet_usage_exclude_users'),
		);
		$section_fields[] = array(
			'title' => __('Select User Roles', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'custom_attributes' => array( 'placeholder' => __('Select a User Role', 'wallet-for-woocommerce') ),
			'class' => 'wal_select2 wal-user-restriction-field wal-include-user-roles-field',
			'id' => $this->get_option_key('wallet_usage_include_user_roles'),
			'options' => $wp_user_roles,
		);
		$section_fields[] = array(
			'title' => __('Select User Roles', 'wallet-for-woocommerce'),
			'type' => 'multiselect',
			'default' => array(),
			'autoload' => false,
			'custom_attributes' => array( 'placeholder' => __('Select a User Role', 'wallet-for-woocommerce') ),
			'class' => 'wal_select2 wal-user-restriction-field wal-exclude-user-roles-field',
			'id' => $this->get_option_key('wallet_usage_exclude_user_roles'),
			'options' => $wp_user_roles,
		);
		$section_fields[] = array(
			'title' => __('Exclude Shipping Cost', 'wallet-for-woocommerce'),
			'type' => 'checkbox',
			'default' => 'no',
			'autoload' => false,
			'id' => $this->get_option_key('exclude_shipping_for_fund_usage'),
			'desc' => __('If enabled, wallet funds will not be applied to the shipping cost.', 'wallet-for-woocommerce'),
		);
		// $section_fields[] = array(
		//  'title' => __('Exclude Tax Cost', 'wallet-for-woocommerce'),
		//  'type' => 'checkbox',
		//  'default' => 'no',
		//  'autoload' => false,
		//  'id' => $this->get_option_key('exclude_tax_for_fund_usage'),
		//  'desc' => __('If enabled, wallet funds will not be applied to the tax cost.', 'wallet-for-woocommerce'),
		// );
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_fund_usage_restriction_options',
		);
		// Fund usage restriction section end.
		// Fund usage security section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Security Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_fund_usage_security_options',
		);
		$section_fields[] = array(
			'title' => __('Maximum No.of Usage Per Day', 'wallet-for-woocommerce'),
			'type' => 'number',
			'default' => '',
			'autoload' => false,
			'custom_attributes' => array( 'min' => 1 ),
			'id' => $this->get_option_key('fund_usage_count_per_day'),
			'desc' => __('You can set a maximum number of times wallet funds can be used per day.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Usage Amount Per Day', 'wallet-for-woocommerce'),
			'type' => 'wal_custom_fields',
			'wal_field' => 'price',
			'default' => '',
			'autoload' => false,
			'id' => $this->get_option_key('fund_usage_max_amount_per_day'),
			'desc' => __('You can set a maximum amount that can be used per day.', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_fund_usage_security_options',
		);
		// Fund usage security section end.

		return $section_fields;
	}
}

return new WAL_General_Tab();
