<?php

/**
 * Advanced Tab
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (class_exists('WAL_Advanced_Tab')) {
	return new WAL_Advanced_Tab();
}

/**
 * Class.
 */
class WAL_Advanced_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id = 'advanced';
		$this->label = __('Advanced', 'wallet-for-woocommerce');

		//Display the server cron information.
		add_action('woocommerce_admin_field_wal_cron_information', array( $this, 'cron_information' ));

		parent::__construct();
	}

	/**
	 * Get settings for advanced section array.
	 * 
	 * @return array
	 */
	protected function advanced_section_array() {
		$section_fields = array();

		// Trobuleshoot section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Troubleshoot', 'wallet-for-woocommerce'),
			'id' => 'wal_trobuleshoot_options',
		);
		$section_fields[] = array(
			'title' => __('Frontend Scripts Enqueued on', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('frontend_enqueue_scripts_type'),
			'type' => 'select',
			'default' => '1',
			'autoload' => false,
			'options' => array(
				'1' => __('Header', 'wallet-for-woocommerce'),
				'2' => __('Footer', 'wallet-for-woocommerce'),
			),
			'desc_tip' => true,
			'desc' => __('Choose whether the frontend scripts has to be loaded on Header/Footer', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_trobuleshoot_options',
		);
		// Trobuleshoot section end.
		// Custom CSS section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Custom CSS', 'wallet-for-woocommerce'),
			'id' => 'wal_custom_css_options',
		);
		$section_fields[] = array(
			'title' => __('Custom CSS', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => '',
			'autoload' => false,
			'custom_attributes' => array( 'rows' => 10 ),
			'id' => $this->get_option_key('custom_css'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_custom_css_options',
		);
		// Custom CSS section end.
		// Cron section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Cron Information', 'wallet-for-woocommerce'),
			'id' => 'wal_cron_options',
		);
		$section_fields[] = array(
			'type' => 'wal_cron_information',
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_server_cron_options',
		);
		// Cron section end.

		return $section_fields;
	}

	/**
	 * Display the Cron information.
	 * */
	public function cron_information() {
		$cron_info = array(
			'wallet_expiry_reminder' => array(
				'cron' => __('Wallet Expiry Reminder Cron', 'wallet-for-woocommerce'),
				'last_updated_date' => self::format_last_updated_date(get_option('wal_wallet_expiry_reminder_email_last_updated_date')),
			),
			'wallet_expired' => array(
				'cron' => __('Wallet Expired Cron', 'wallet-for-woocommerce'),
				'last_updated_date' => self::format_last_updated_date(get_option('wal_wallet_expired_wp_cron_last_updated_date')),
			),
		);

		include_once WAL_ABSPATH . 'inc/admin/menu/views/html-cron-info.php' ;
	}

	/**
	 * Format the last update date.
	 * 
	 * @return string.
	 * */
	protected function format_last_updated_date( $date ) {
		if (empty($date)) {
			return __('Cron not Triggered', 'wallet-for-woocommerce');
		}

		return WAL_Date_Time::get_wp_format_datetime_from_gmt($date, false, ' ', true);
	}
}

return new WAL_Advanced_Tab();
