<?php
/**
 * Google Fonts
 *
 * @package Fonts VC
 */

/**
 * Returns all the available Google Fonts. This is auto updated every build.
 *
 * @return array All available Google Fonts.
 */
function fvc_get_all_google_fonts() {
	return array(
		'ABeeZee' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Abel' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Abhaya Libre' => array(
			'variants' => array( 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'sinhala', 'latin-ext' ),
		),
		'Abril Fatface' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Aclonica' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Acme' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Actor' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Adamina' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Advent Pro' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'greek' ),
		),
		'Aguafina Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Akronim' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Aladin' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Aldrich' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Alef' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'hebrew' ),
		),
		'Alegreya' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Alegreya SC' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Alegreya Sans' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Alegreya Sans SC' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Alex Brush' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Alfa Slab One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Alice' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'cyrillic-ext', 'cyrillic' ),
		),
		'Alike' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Alike Angular' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Allan' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Allerta' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Allerta Stencil' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Allura' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Almendra' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Almendra Display' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Almendra SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Amarante' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Amaranth' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Amatic SC' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew', 'vietnamese', 'cyrillic' ),
		),
		'Amethysta' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Amiko' => array(
			'variants' => array( 'regular', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Amiri' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Amita' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Anaheim' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Andada' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Andika' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Angkor' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Annie Use Your Telescope' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Anonymous Pro' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'greek', 'cyrillic' ),
		),
		'Antic' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Antic Didone' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Antic Slab' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Anton' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Arapey' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Arbutus' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Arbutus Slab' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Architects Daughter' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Archivo' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Archivo Black' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Archivo Narrow' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Aref Ruqaa' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Arima Madurai' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'tamil' ),
		),
		'Arimo' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'hebrew', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Arizonia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Armata' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Arsenal' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Artifika' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Arvo' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Arya' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Asap' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Asap Condensed' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Asar' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Asset' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Assistant' => array(
			'variants' => array( '200', '300', 'regular', '600', '700', '800' ),
			'subsets' => array( 'latin', 'hebrew' ),
		),
		'Astloch' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Asul' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Athiti' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Atma' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'bengali' ),
		),
		'Atomic Age' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Aubrey' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Audiowide' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Autour One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Average' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Average Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Averia Gruesa Libre' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Averia Libre' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Averia Sans Libre' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Averia Serif Libre' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Bad Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'cyrillic' ),
		),
		'Bahiana' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Baloo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext', 'vietnamese' ),
		),
		'Baloo Bhai' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext', 'vietnamese' ),
		),
		'Baloo Bhaijaan' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Baloo Bhaina' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'oriya', 'vietnamese' ),
		),
		'Baloo Chettan' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'malayalam' ),
		),
		'Baloo Da' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'bengali' ),
		),
		'Baloo Paaji' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'gurmukhi' ),
		),
		'Baloo Tamma' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'kannada', 'latin-ext', 'vietnamese' ),
		),
		'Baloo Tammudu' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu', 'latin-ext', 'vietnamese' ),
		),
		'Baloo Thambi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'tamil' ),
		),
		'Balthazar' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bangers' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Barlow' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Barlow Condensed' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Barlow Semi Condensed' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Barrio' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Basic' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Battambang' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'khmer' ),
		),
		'Baumans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bayon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Belgrano' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bellefair' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew' ),
		),
		'Belleza' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'BenchNine' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bentham' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Berkshire Swash' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bevan' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Bigelow Rules' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bigshot One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bilbo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bilbo Swash Caps' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'BioRhyme' => array(
			'variants' => array( '200', '300', 'regular', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'BioRhyme Expanded' => array(
			'variants' => array( '200', '300', 'regular', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Biryani' => array(
			'variants' => array( '200', '300', 'regular', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Bitter' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Black Ops One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bokor' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Bonbon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Boogaloo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bowlby One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bowlby One SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Brawler' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Bree Serif' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bubblegum Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bubbler One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Buda' => array(
			'variants' => array( '300' ),
			'subsets' => array( 'latin' ),
		),
		'Buenard' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Bungee' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Bungee Hairline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Bungee Inline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Bungee Outline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Bungee Shade' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Butcherman' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Butterfly Kids' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cabin' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Cabin Condensed' => array(
			'variants' => array( 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Cabin Sketch' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Caesar Dressing' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cagliostro' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cairo' => array(
			'variants' => array( '200', '300', 'regular', '600', '700', '900' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Calligraffitti' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cambay' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Cambo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Candal' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cantarell' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Cantata One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cantora One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Capriola' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cardo' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'greek', 'greek-ext' ),
		),
		'Carme' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Carrois Gothic' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Carrois Gothic SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Carter One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Catamaran' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'tamil' ),
		),
		'Caudex' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'greek', 'greek-ext' ),
		),
		'Caveat' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Caveat Brush' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cedarville Cursive' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Ceviche One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Changa' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Changa One' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Chango' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chathura' => array(
			'variants' => array( '100', '300', 'regular', '700', '800' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Chau Philomene One' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chela One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chelsea Market' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chenla' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Cherry Cream Soda' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cherry Swash' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chewy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Chicle' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chivo' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Chonburi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Cinzel' => array(
			'variants' => array( 'regular', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cinzel Decorative' => array(
			'variants' => array( 'regular', '700', '900' ),
			'subsets' => array( 'latin' ),
		),
		'Clicker Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Coda' => array(
			'variants' => array( 'regular', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Coda Caption' => array(
			'variants' => array( '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Codystar' => array(
			'variants' => array( '300', 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Coiny' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'tamil' ),
		),
		'Combo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Comfortaa' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic' ),
		),
		'Coming Soon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Concert One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Condiment' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Content' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'khmer' ),
		),
		'Contrail One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Convergence' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cookie' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Copse' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Corben' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cormorant' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cormorant Garamond' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cormorant Infant' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cormorant SC' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cormorant Unicase' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cormorant Upright' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Courgette' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cousine' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'hebrew', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Coustard' => array(
			'variants' => array( 'regular', '900' ),
			'subsets' => array( 'latin' ),
		),
		'Covered By Your Grace' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Crafty Girls' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Creepster' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Crete Round' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Crimson Text' => array(
			'variants' => array( 'regular', 'italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Croissant One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Crushed' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Cuprum' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Cutive' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Cutive Mono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Damion' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Dancing Script' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Dangrek' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'David Libre' => array(
			'variants' => array( 'regular', '500', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew', 'vietnamese' ),
		),
		'Dawning of a New Day' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Days One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Dekko' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Delius' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Delius Swash Caps' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Delius Unicase' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Della Respira' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Denk One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Devonshire' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Dhurjati' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Didact Gothic' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic', 'greek-ext' ),
		),
		'Diplomata' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Diplomata SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Domine' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Donegal One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Doppio One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Dorsa' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Dosis' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Dr Sugiyama' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Duru Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Dynalight' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'EB Garamond' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Eagle Lake' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Eater' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Economica' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Eczar' => array(
			'variants' => array( 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'El Messiri' => array(
			'variants' => array( 'regular', '500', '600', '700' ),
			'subsets' => array( 'arabic', 'latin', 'cyrillic' ),
		),
		'Electrolize' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Elsie' => array(
			'variants' => array( 'regular', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Elsie Swash Caps' => array(
			'variants' => array( 'regular', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Emblema One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Emilys Candy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Encode Sans' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Encode Sans Condensed' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Encode Sans Expanded' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Encode Sans Semi Condensed' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Encode Sans Semi Expanded' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Engagement' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Englebert' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Enriqueta' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Erica One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Esteban' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Euphoria Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ewert' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Exo' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Exo 2' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Expletus Sans' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Fanwood Text' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Farsan' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext', 'vietnamese' ),
		),
		'Fascinate' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fascinate Inline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Faster One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fasthand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Fauna One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Faustina' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Federant' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Federo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Felipa' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Fenix' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Finger Paint' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fira Mono' => array(
			'variants' => array( 'regular', '500', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic', 'greek-ext' ),
		),
		'Fira Sans' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Fira Sans Condensed' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Fira Sans Extra Condensed' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Fjalla One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Fjord One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Flamenco' => array(
			'variants' => array( '300', 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Flavors' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fondamento' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Fontdiner Swanky' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Forum' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'Francois One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Frank Ruhl Libre' => array(
			'variants' => array( '300', 'regular', '500', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew' ),
		),
		'Freckle Face' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Fredericka the Great' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fredoka One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Freehand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Fresca' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Frijole' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Fruktur' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Fugaz One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'GFS Didot' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'greek' ),
		),
		'GFS Neohellenic' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'greek' ),
		),
		'Gabriela' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'cyrillic-ext', 'cyrillic' ),
		),
		'Gafata' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Galada' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'bengali' ),
		),
		'Galdeano' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Galindo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gentium Basic' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gentium Book Basic' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Geo' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Geostar' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Geostar Fill' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Germania One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Gidugu' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Gilda Display' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Give You Glory' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Glass Antiqua' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Glegoo' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Gloria Hallelujah' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Goblin One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Gochi Hand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Gorditas' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Goudy Bookletter 1911' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Graduate' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Grand Hotel' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gravitas One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Great Vibes' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Griffy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gruppo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gudea' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Gurajada' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Habibi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Halant' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Hammersmith One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Hanalei' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Hanalei Fill' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Handlee' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Hanuman' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'khmer' ),
		),
		'Happy Monkey' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Harmattan' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Headland One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Heebo' => array(
			'variants' => array( '100', '300', 'regular', '500', '700', '800', '900' ),
			'subsets' => array( 'latin', 'hebrew' ),
		),
		'Henny Penny' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Herr Von Muellerhoff' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Hind' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Hind Guntur' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'telugu', 'latin-ext' ),
		),
		'Hind Madurai' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'tamil' ),
		),
		'Hind Siliguri' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'bengali' ),
		),
		'Hind Vadodara' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Holtwood One SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Homemade Apple' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Homenaje' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'IBM Plex Mono' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'IBM Plex Sans' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'IBM Plex Sans Condensed' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'IBM Plex Serif' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'IM Fell DW Pica' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell DW Pica SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell Double Pica' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell Double Pica SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell English' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell English SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell French Canon' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell French Canon SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell Great Primer' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'IM Fell Great Primer SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Iceberg' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Iceland' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Imprima' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Inconsolata' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Inder' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Indie Flower' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Inika' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Inknut Antiqua' => array(
			'variants' => array( '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Irish Grover' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Istok Web' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'Italiana' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Italianno' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Itim' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Jacques Francois' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Jacques Francois Shadow' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Jaldi' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Jim Nightshade' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Jockey One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Jolly Lodger' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Jomhuria' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Josefin Sans' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Josefin Slab' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Joti One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Judson' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Julee' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Julius Sans One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Junge' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Jura' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Just Another Hand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Just Me Again Down Here' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kadwa' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari' ),
		),
		'Kalam' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Kameron' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Kanit' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Kantumruy' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'khmer' ),
		),
		'Karla' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Karma' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Katibeh' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Kaushan Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kavivanar' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'tamil' ),
		),
		'Kavoon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kdam Thmor' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Keania One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kelly Slab' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Kenia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Khand' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Khmer' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Khula' => array(
			'variants' => array( '300', 'regular', '600', '700', '800' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Kite One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Knewave' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kotta One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Koulen' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Kranky' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Kreon' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Kristi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Krona One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Kumar One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Kumar One Outline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Kurale' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'La Belle Aurore' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Laila' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Lakki Reddy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Lalezar' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Lancelot' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Lateef' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Lato' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'League Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Leckerli One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Ledger' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Lekton' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Lemon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Lemonada' => array(
			'variants' => array( '300', 'regular', '600', '700' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Libre Barcode 128' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Barcode 128 Text' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Barcode 39' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Barcode 39 Extended' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Barcode 39 Extended Text' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Barcode 39 Text' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Libre Baskerville' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Libre Franklin' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Life Savers' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Lilita One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Lily Script One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Limelight' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Linden Hill' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Lobster' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Lobster Two' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Londrina Outline' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Londrina Shadow' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Londrina Sketch' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Londrina Solid' => array(
			'variants' => array( '100', '300', 'regular', '900' ),
			'subsets' => array( 'latin' ),
		),
		'Lora' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Love Ya Like A Sister' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Loved by the King' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Lovers Quarrel' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Luckiest Guy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Lusitana' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Lustria' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Macondo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Macondo Swash Caps' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Mada' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '900' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Magra' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Maiden Orange' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Maitree' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Mako' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Mallanna' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Mandali' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Manuale' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Marcellus' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Marcellus SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Marck Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Margarine' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Marko One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Marmelad' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Martel' => array(
			'variants' => array( '200', '300', 'regular', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Martel Sans' => array(
			'variants' => array( '200', '300', 'regular', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Marvel' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Mate' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Mate SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Maven Pro' => array(
			'variants' => array( 'regular', '500', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'McLaren' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Meddon' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'MedievalSharp' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Medula One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Meera Inimai' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'tamil' ),
		),
		'Megrim' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Meie Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Merienda' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Merienda One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Merriweather' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Merriweather Sans' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Metal' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Metal Mania' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Metamorphous' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Metrophobic' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Michroma' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Milonga' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Miltonian' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Miltonian Tattoo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Mina' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'bengali' ),
		),
		'Miniver' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Miriam Libre' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew' ),
		),
		'Mirza' => array(
			'variants' => array( 'regular', '500', '600', '700' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Miss Fajardose' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mitr' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Modak' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Modern Antiqua' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mogra' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Molengo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Molle' => array(
			'variants' => array( 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Monda' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Monofett' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Monoton' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Monsieur La Doulaise' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Montaga' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Montez' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Montserrat' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Montserrat Alternates' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Montserrat Subrayada' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Moul' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Moulpali' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Mountains of Christmas' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Mouse Memoirs' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mr Bedfort' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mr Dafoe' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mr De Haviland' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mrs Saint Delafield' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mrs Sheppards' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Mukta' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Mukta Mahee' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext', 'gurmukhi' ),
		),
		'Mukta Malar' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext', 'tamil' ),
		),
		'Mukta Vaani' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Muli' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Mystery Quest' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'NTR' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Nanum Brush Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'korean' ),
		),
		'Nanum Gothic' => array(
			'variants' => array( 'regular', '700', '800' ),
			'subsets' => array( 'latin', 'korean' ),
		),
		'Nanum Gothic Coding' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'korean' ),
		),
		'Nanum Myeongjo' => array(
			'variants' => array( 'regular', '700', '800' ),
			'subsets' => array( 'latin', 'korean' ),
		),
		'Nanum Pen Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'korean' ),
		),
		'Neucha' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'cyrillic' ),
		),
		'Neuton' => array(
			'variants' => array( '200', '300', 'regular', 'italic', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'New Rocker' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'News Cycle' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Niconne' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Nixie One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nobile' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Nokora' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'khmer' ),
		),
		'Norican' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Nosifer' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Nothing You Could Do' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Noticia Text' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Noto Sans' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Noto Serif' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Nova Cut' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Flat' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Mono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'greek' ),
		),
		'Nova Oval' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Round' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Slim' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nova Square' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Numans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Nunito' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Nunito Sans' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Odor Mean Chey' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Offside' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Old Standard TT' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Oldenburg' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Oleo Script' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Oleo Script Swash Caps' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Open Sans' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Open Sans Condensed' => array(
			'variants' => array( '300', '300italic', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Oranienbaum' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'Orbitron' => array(
			'variants' => array( 'regular', '500', '700', '900' ),
			'subsets' => array( 'latin' ),
		),
		'Oregano' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Orienta' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Original Surfer' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Oswald' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Over the Rainbow' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Overlock' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Overlock SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Overpass' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Overpass Mono' => array(
			'variants' => array( '300', 'regular', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ovo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Oxygen' => array(
			'variants' => array( '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Oxygen Mono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'PT Mono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'PT Sans' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'PT Sans Caption' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'PT Sans Narrow' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'PT Serif' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'PT Serif Caption' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'Pacifico' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Padauk' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'myanmar' ),
		),
		'Palanquin' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Palanquin Dark' => array(
			'variants' => array( 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Pangolin' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Paprika' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Parisienne' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Passero One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Passion One' => array(
			'variants' => array( 'regular', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Pathway Gothic One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Patrick Hand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Patrick Hand SC' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Pattaya' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Patua One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Pavanam' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'tamil' ),
		),
		'Paytone One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Peddana' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Peralta' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Permanent Marker' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Petit Formal Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Petrona' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Philosopher' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Piedra' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Pinyon Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Pirata One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Plaster' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Play' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic' ),
		),
		'Playball' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Playfair Display' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Playfair Display SC' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Podkova' => array(
			'variants' => array( 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Poiret One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Poller One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Poly' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin' ),
		),
		'Pompiere' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Pontano Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Poppins' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Port Lligat Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Port Lligat Slab' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Pragati Narrow' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Prata' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Preahvihear' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Press Start 2P' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic' ),
		),
		'Pridi' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Princess Sofia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Prociono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Prompt' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Prosto One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Proza Libre' => array(
			'variants' => array( 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Puritan' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Purple Purse' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Quando' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Quantico' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Quattrocento' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Quattrocento Sans' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Questrial' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Quicksand' => array(
			'variants' => array( '300', 'regular', '500', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Quintessential' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Qwigley' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Racing Sans One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Radley' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rajdhani' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Rakkas' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin', 'latin-ext' ),
		),
		'Raleway' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Raleway Dots' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ramabhadra' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Ramaraja' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Rambla' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rammetto One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ranchers' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rancho' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Ranga' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Rasa' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Rationale' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Ravi Prakash' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Redressed' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Reem Kufi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Reenie Beanie' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Revalia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rhodium Libre' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Ribeye' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ribeye Marrow' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Righteous' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Risque' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Roboto' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Roboto Condensed' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Roboto Mono' => array(
			'variants' => array( '100', '100italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Roboto Slab' => array(
			'variants' => array( '100', '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Rochester' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Rock Salt' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Rokkitt' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Romanesco' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ropa Sans' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rosario' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Rosarivo' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rouge Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Rozha One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Rubik' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew', 'cyrillic' ),
		),
		'Rubik Mono One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Ruda' => array(
			'variants' => array( 'regular', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rufina' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ruge Boogie' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ruluko' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rum Raisin' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Ruslan Display' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Russo One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Ruthie' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Rye' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sacramento' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sahitya' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari' ),
		),
		'Sail' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Saira' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Saira Condensed' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Saira Extra Condensed' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Saira Semi Condensed' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Salsa' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sanchez' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sancreek' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sansita' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sarala' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Sarina' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sarpanch' => array(
			'variants' => array( 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Satisfy' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Scada' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'cyrillic' ),
		),
		'Scheherazade' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'arabic', 'latin' ),
		),
		'Schoolbell' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Scope One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Seaweed Script' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Secular One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew' ),
		),
		'Sedgwick Ave' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Sedgwick Ave Display' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Sevillana' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Seymour One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Shadows Into Light' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Shadows Into Light Two' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Shanti' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Share' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Share Tech' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Share Tech Mono' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Shojumaru' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Short Stack' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Shrikhand' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'gujarati', 'latin-ext' ),
		),
		'Siemreap' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Sigmar One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Signika' => array(
			'variants' => array( '300', 'regular', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Signika Negative' => array(
			'variants' => array( '300', 'regular', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Simonetta' => array(
			'variants' => array( 'regular', 'italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sintony' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sirin Stencil' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Six Caps' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Skranji' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Slabo 13px' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Slabo 27px' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Slackey' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Smokum' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Smythe' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sniglet' => array(
			'variants' => array( 'regular', '800' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Snippet' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Snowburst One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sofadi One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sofia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sonsie One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Sorts Mill Goudy' => array(
			'variants' => array( 'regular', 'italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Source Code Pro' => array(
			'variants' => array( '200', '300', 'regular', '500', '600', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Source Sans Pro' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Source Serif Pro' => array(
			'variants' => array( 'regular', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Space Mono' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Special Elite' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Spectral' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Spectral SC' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Spicy Rice' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Spinnaker' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Spirax' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Squada One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sree Krushnadevaraya' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Sriracha' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Stalemate' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Stalinist One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Stardos Stencil' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Stint Ultra Condensed' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Stint Ultra Expanded' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Stoke' => array(
			'variants' => array( '300', 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Strait' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sue Ellen Francisco' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Suez One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew' ),
		),
		'Sumana' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Sunshiney' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Supermercado One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Sura' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Suranna' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Suravaram' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Suwannaphum' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Swanky and Moo Moo' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Syncopate' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Tangerine' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Taprom' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'khmer' ),
		),
		'Tauri' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Taviraj' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Teko' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Telex' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Tenali Ramakrishna' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Tenor Sans' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Text Me One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'The Girl Next Door' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Tienne' => array(
			'variants' => array( 'regular', '700', '900' ),
			'subsets' => array( 'latin' ),
		),
		'Tillana' => array(
			'variants' => array( 'regular', '500', '600', '700', '800' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Timmana' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'telugu' ),
		),
		'Tinos' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'hebrew', 'vietnamese', 'cyrillic', 'greek-ext' ),
		),
		'Titan One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Titillium Web' => array(
			'variants' => array( '200', '200italic', '300', '300italic', 'regular', 'italic', '600', '600italic', '700', '700italic', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Trade Winds' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Trirong' => array(
			'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'thai', 'latin-ext', 'vietnamese' ),
		),
		'Trocchi' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Trochut' => array(
			'variants' => array( 'regular', 'italic', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Trykker' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Tulpen One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Ubuntu' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic', 'greek-ext' ),
		),
		'Ubuntu Condensed' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic', 'greek-ext' ),
		),
		'Ubuntu Mono' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'cyrillic', 'greek-ext' ),
		),
		'Ultra' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Uncial Antiqua' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Underdog' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic' ),
		),
		'Unica One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'UnifrakturCook' => array(
			'variants' => array( '700' ),
			'subsets' => array( 'latin' ),
		),
		'UnifrakturMaguntia' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Unkempt' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin' ),
		),
		'Unlock' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Unna' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'VT323' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese' ),
		),
		'Vampiro One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Varela' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Varela Round' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'hebrew', 'vietnamese' ),
		),
		'Vast Shadow' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Vesper Libre' => array(
			'variants' => array( 'regular', '500', '700', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Vibur' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Vidaloka' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Viga' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Voces' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Volkhov' => array(
			'variants' => array( 'regular', 'italic', '700', '700italic' ),
			'subsets' => array( 'latin' ),
		),
		'Vollkorn' => array(
			'variants' => array( 'regular', 'italic', '600', '600italic', '700', '700italic', '900', '900italic' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'greek', 'vietnamese', 'cyrillic' ),
		),
		'Vollkorn SC' => array(
			'variants' => array( 'regular', '600', '700', '900' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Voltaire' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Waiting for the Sunrise' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Wallpoet' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Walter Turncoat' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Warnes' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Wellfleet' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Wendy One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Wire One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Work Sans' => array(
			'variants' => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Yanone Kaffeesatz' => array(
			'variants' => array( '200', '300', 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext', 'vietnamese', 'cyrillic' ),
		),
		'Yantramanav' => array(
			'variants' => array( '100', '300', 'regular', '500', '700', '900' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Yatra One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'devanagari', 'latin-ext' ),
		),
		'Yellowtail' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Yeseva One' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin', 'latin-ext', 'cyrillic-ext', 'vietnamese', 'cyrillic' ),
		),
		'Yesteryear' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Yrsa' => array(
			'variants' => array( '300', 'regular', '500', '600', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Zeyada' => array(
			'variants' => array( 'regular' ),
			'subsets' => array( 'latin' ),
		),
		'Zilla Slab' => array(
			'variants' => array( '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
		'Zilla Slab Highlight' => array(
			'variants' => array( 'regular', '700' ),
			'subsets' => array( 'latin', 'latin-ext' ),
		),
	);
};
