<?php
/**
 * Processes the SVG files generated.
 *
 * @package Row Separators
 */

if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

if ( ! function_exists( 'gambit_row_separators_get_svg_names' ) ) {

	/**
	 * Fetches the SVG names.
	 */
	function gambit_row_separators_get_svg_names() {
		$ret = array();

		// DECOR SVG NAME START - DO NOT TOUCH THIS, GENERATED BY _DEV_processSvg.php!
		$ret[ __( 'Abstract #1', GAMBIT_ROW_SEPARATORS ) ] = 'abstract1';
		$ret[ __( 'Abstract #2', GAMBIT_ROW_SEPARATORS ) ] = 'abstract2';
		$ret[ __( 'Abstract #3', GAMBIT_ROW_SEPARATORS ) ] = 'abstract3';
		$ret[ __( 'Abstract #4', GAMBIT_ROW_SEPARATORS ) ] = 'abstract4';
		$ret[ __( 'Arrow Down (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-down-decor1';
		$ret[ __( 'Arrow Down (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-down-decor2';
		$ret[ __( 'Arrow Down (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-down-decor3';
		$ret[ __( 'Arrow Inward Small (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-inward-small1';
		$ret[ __( 'Arrow Inward Small (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-inward-small2';
		$ret[ __( 'Arrow Outward Small (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-outward-small1';
		$ret[ __( 'Arrow Outward Small (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-outward-small2';
		$ret[ __( 'Arrow Side Down (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-down-decor1';
		$ret[ __( 'Arrow Side Down (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-down-decor2';
		$ret[ __( 'Arrow Side Down (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-down-decor3';
		$ret[ __( 'Arrow Side Up (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-up-decor1';
		$ret[ __( 'Arrow Side Up (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-up-decor2';
		$ret[ __( 'Arrow Side Up (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-side-up-decor3';
		$ret[ __( 'Arrow Up (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-up-decor1';
		$ret[ __( 'Arrow Up (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-up-decor2';
		$ret[ __( 'Arrow Up (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'arrow-up-decor3';
		$ret[ __( 'Clouds #1', GAMBIT_ROW_SEPARATORS ) ] = 'clouds1';
		$ret[ __( 'Clouds #2', GAMBIT_ROW_SEPARATORS ) ] = 'clouds2';
		$ret[ __( 'Clouds #3', GAMBIT_ROW_SEPARATORS ) ] = 'clouds3';
		$ret[ __( 'Curve Inward (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-inward1';
		$ret[ __( 'Curve Inward (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-inward2';
		$ret[ __( 'Curve Outward (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-outward1';
		$ret[ __( 'Curve Outward (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-outward2';
		$ret[ __( 'Curve Side (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-side1';
		$ret[ __( 'Curve Side (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'curve-side2';
		$ret[ __( 'Dissolve Circle', GAMBIT_ROW_SEPARATORS ) ] = 'dissolve-circle';
		$ret[ __( 'Dissolve Square', GAMBIT_ROW_SEPARATORS ) ] = 'dissolve-square';
		$ret[ __( 'Envelope', GAMBIT_ROW_SEPARATORS ) ] = 'envelope';
		$ret[ __( 'Envelope Slant', GAMBIT_ROW_SEPARATORS ) ] = 'envelope-slant';
		$ret[ __( 'Fence', GAMBIT_ROW_SEPARATORS ) ] = 'fence';
		$ret[ __( 'Fence Bend', GAMBIT_ROW_SEPARATORS ) ] = 'fence-bend';
		$ret[ __( 'Film', GAMBIT_ROW_SEPARATORS ) ] = 'film';
		$ret[ __( 'Film Slant', GAMBIT_ROW_SEPARATORS ) ] = 'film-slant';
		$ret[ __( 'Gears', GAMBIT_ROW_SEPARATORS ) ] = 'gears';
		$ret[ __( 'Grass', GAMBIT_ROW_SEPARATORS ) ] = 'grass';
		$ret[ __( 'Grass Bend', GAMBIT_ROW_SEPARATORS ) ] = 'grass-bend';
		$ret[ __( 'Mountains #1', GAMBIT_ROW_SEPARATORS ) ] = 'mountains1';
		$ret[ __( 'Mountains #2', GAMBIT_ROW_SEPARATORS ) ] = 'mountains2';
		$ret[ __( 'Mountains #3', GAMBIT_ROW_SEPARATORS ) ] = 'mountains3';
		$ret[ __( 'Perforated', GAMBIT_ROW_SEPARATORS ) ] = 'perforated';
		$ret[ __( 'Perforated Slant', GAMBIT_ROW_SEPARATORS ) ] = 'perforated-slant';
		$ret[ __( 'Pine Trees', GAMBIT_ROW_SEPARATORS ) ] = 'pine-trees';
		$ret[ __( 'Pine Trees Bend', GAMBIT_ROW_SEPARATORS ) ] = 'pine-trees-bend';
		$ret[ __( 'Side-Curve Inward (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'side-curve-inward-decor1';
		$ret[ __( 'Side-Curve Inward (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'side-curve-inward-decor2';
		$ret[ __( 'Side-Curve Outward (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'side-curve-outward-decor1';
		$ret[ __( 'Side-Curve Outward (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'side-curve-outward-decor2';
		$ret[ __( 'Slant (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'slant-decor1';
		$ret[ __( 'Slant (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'slant-decor2';
		$ret[ __( 'Slant (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'slant-decor3';
		$ret[ __( 'Slime', GAMBIT_ROW_SEPARATORS ) ] = 'slime';
		$ret[ __( 'Straight', GAMBIT_ROW_SEPARATORS ) ] = 'straight';
		$ret[ __( 'Triangles Large (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'triangles-decor1';
		$ret[ __( 'Triangles Large (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'triangles-decor2';
		$ret[ __( 'Triangles Large (Decor #3)', GAMBIT_ROW_SEPARATORS ) ] = 'triangles-decor3';
		$ret[ __( 'Triangles Small (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'triangles-small-decor1';
		$ret[ __( 'Triangles Small (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'triangles-small-decor2';
		$ret[ __( 'Water Bend', GAMBIT_ROW_SEPARATORS ) ] = 'water-bend';
		$ret[ __( 'Water Wave Bend', GAMBIT_ROW_SEPARATORS ) ] = 'water-wave-bend';
		$ret[ __( 'Water Large Wave', GAMBIT_ROW_SEPARATORS ) ] = 'water-wave-large';
		$ret[ __( 'Water Wave (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'water-wave1';
		$ret[ __( 'Water Wave (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'water-wave2';
		$ret[ __( 'Water (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'water1';
		$ret[ __( 'Water (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'water2';
		$ret[ __( 'Wave Bend', GAMBIT_ROW_SEPARATORS ) ] = 'wave-bend';
		$ret[ __( 'Wave Side (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'wave-side1';
		$ret[ __( 'Wave Side (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'wave-side2';
		$ret[ __( 'Wave (Decor #1)', GAMBIT_ROW_SEPARATORS ) ] = 'wave1';
		$ret[ __( 'Wave (Decor #2)', GAMBIT_ROW_SEPARATORS ) ] = 'wave2';
		// DECOR SVG NAME END - DO NOT TOUCH THIS, GENERATED BY _DEV_processSvg.php!
		return $ret;
	}
} // End if().

if ( ! function_exists( 'gambit_row_separators_get_svgs' ) ) {

	/**
	 * Fetches the SVG files.
	 */
	function gambit_row_separators_get_svgs() {
		$ret = array();

		// DECOR SVG CODE START - DO NOT TOUCH THIS, GENERATED BY _DEV_processSvg.php!
		$ret['abstract1'] = array(
		'name' => __( 'Abstract #1', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="1280,104 798,196 360,14 -4,198 -4,204 1604,204 1604,198 "/>
<polygon class="gambit_sep_decor1" points="798,196 1280,104 1604,198 1280,98 "/>
<polygon class="gambit_sep_decor2" points="-4,198 360.612,0 798,196 360,14 "/>',
		);

		$ret['abstract2'] = array(
		'name' => __( 'Abstract #2', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="800,172 224,138 -4,20 -4,204 1604,204 1604,167 1236,10 "/>
<polygon class="gambit_sep_decor1" points="-4,0 -4,20 224,138 800,172 228,128 "/>
<polygon class="gambit_sep_decor2" points="1236,0 800,172 1236,10 1604,167 1604,141 "/>',
		);

		$ret['abstract3'] = array(
		'name' => __( 'Abstract #3', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="1488,134 1304,100 1068,152 909.935,92.044 672,198 364,142 242,32 -4,95 -4,204 1604,204 1604,0 "/>
<polygon class="gambit_sep_decor1" points="672,198 364,142 242,32 -4,95 -4,82.333 242,32 374,136 "/>
<polygon class="gambit_sep_decor1" points="894,86 672,198 909.935,92.044 "/>
<polygon class="gambit_sep_decor2" points="1068,152 1302,86 1486,126 1604,0 1488,134 1304,100 "/>',
		);

		$ret['abstract4'] = array(
		'name' => __( 'Abstract #4', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="1350,134 1164,62 1020,190 800,42 560,184 462,48 258,170 166,6 -4,112 -4,204 1604,204 1604,135 1462,0 "/>
<polygon class="gambit_sep_decor1" points="-4,112 167,0 258,158 462,48 258,170 166,6 "/>
<polygon class="gambit_sep_decor1" points="560,176 800,42 560,184 "/>
<polygon class="gambit_sep_decor1" points="1164,62 1350,122 1350,134 "/>
<polygon class="gambit_sep_decor2" points="800,42 1016,178 1164,62 1020,190 "/>
<polygon class="gambit_sep_decor2" points="1350,122 1350,134 1462,0 1604,135 1604,122 1462,0 "/>
<polygon class="gambit_sep_decor2" points="462,48 560,176 560,184 "/>',
		);

		$ret['arrow-down-decor1'] = array(
		'name' => __( 'Arrow Down (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24 800,198 1604,24 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="-4,0 800,198 1604,0 1604,11.833 800,198 -4,12 "/>
<polygon class="gambit_sep_decor2" points="-4,12 -4,24 800,198 1604,24 1604,11.833 800,198 "/>',
		);

		$ret['arrow-down-decor2'] = array(
		'name' => __( 'Arrow Down (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24 800,198 1604,24 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,24 800,198 1604,24 1604,12 800,186 -4,12 "/>
<polygon class="gambit_sep_decor1" points="-4,0 800,174 1604,0 1604,12 800,186 -4,12 "/>',
		);

		$ret['arrow-down-decor3'] = array(
		'name' => __( 'Arrow Down (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,0 800,198 1604,0 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,0 800,198 1604,0 1604,0 800,186 -4,0 "/>
<polygon class="gambit_sep_decor1" points="-4,0 800,174 1604,0 1604,0 800,186 -4,0 "/>',
		);

		$ret['arrow-inward-small1'] = array(
		'name' => __( 'Arrow Inward Small (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="886,86 800,172 714,86 -4,86 -4,204 1604,204 1604,86 "/>
<polygon class="gambit_sep_decor2" points="800,172 886,86 900,86 800,186 700,86 714,86 "/>
<polygon class="gambit_sep_decor1" points="800,162 876,86 888,86 800,174 712,86 724,86 "/>',
		);

		$ret['arrow-inward-small2'] = array(
		'name' => __( 'Arrow Inward Small (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="860,102 800,162 740,102 -4,102 -4,204 1604,204 1604,102 "/>
<polygon class="gambit_sep_decor1" points="724,86 -4,86 -4,98 736,98 "/>
<polygon class="gambit_sep_decor1" points="876,86 864,98 1604,98 1604,86 "/>
<polygon class="gambit_sep_decor2" points="736,98 -4,98 -4,110 748,110 "/>
<polygon class="gambit_sep_decor2" points="852,110 1604,110 1604,98 864,98 "/>',
		);

		$ret['arrow-outward-small1'] = array(
		'name' => __( 'Arrow Outward Small (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="888,126 800,38 712,126 -4,126 -4,244 1604,244 1604,126 "/>
<polygon class="gambit_sep_decor2" points="800,50 876,126 900,126 800,26 700,126 724,126 "/>
<polygon class="gambit_sep_decor1" points="800,50 876,126 888,126 800,38 712,126 724,126 "/>',
		);

		$ret['arrow-outward-small2'] = array(
		'name' => __( 'Arrow Outward Small (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="918,144 800,26 682,144 -4,144 -4,244 1604,244 1604,146 "/>
<polygon class="gambit_sep_decor1" points="700,126 -4,126 -4,138 688,138 "/>
<polygon class="gambit_sep_decor1" points="900,126 912,138 1604,138 1604,126 "/>
<polygon class="gambit_sep_decor2" points="688,138 -4,138 -4,150 676,150 "/>
<polygon class="gambit_sep_decor2" points="912,138 924,150 1604,150 1604,138 "/>',
		);

		$ret['arrow-side-down-decor1'] = array(
		'name' => __( 'Arrow Side Down (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24 578.9,198 1604,24 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="-4,0 578.9,198 1604,0 1604,11.833 578.9,198 -4,12 "/>
<polygon class="gambit_sep_decor2" points="-4,12 -4,24 578.9,198 1604,24 1604,11.833 578.9,198 "/>',
		);

		$ret['arrow-side-down-decor2'] = array(
		'name' => __( 'Arrow Side Down (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24 558.8,198 1604,24 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,24 558.8,198 1604,24 1604,12 558.8,186 -4,12 "/>
<polygon class="gambit_sep_decor1" points="-4,0 558.8,174 1604,0 1604,12 558.8,186 -4,12 "/>',
		);

		$ret['arrow-side-down-decor3'] = array(
		'name' => __( 'Arrow Side Down (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,0 558.8,198 1604,0 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,0 558.8,198 1604,0 1604,0 558.8,186 -4,0 "/>
<polygon class="gambit_sep_decor1" points="-4,0 558.8,174 1604,0 1604,0 558.8,186 -4,0 "/>',
		);

		$ret['arrow-side-up-decor1'] = array(
		'name' => __( 'Arrow Side Up (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,198 479.009,0 1604,198 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="-4,174 479.009,0 1604,174 1604,186.333 479.009,0 -4,186.333 "/>
<polygon class="gambit_sep_decor2" points="-4,186.333 -4,198 479.009,0 1604,198 1604,186.333 479.009,0 "/>',
		);

		$ret['arrow-side-up-decor2'] = array(
		'name' => __( 'Arrow Side Up (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,197.667 478.065,24 1604,198 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,197.667 478.065,24 1604,198 1604,186 478.065,12 -4,185.667 "/>
<polygon class="gambit_sep_decor1" points="-4,173.667 478.065,0 1604,174 1604,186 478.065,12 -4,185.667 "/>',
		);

		$ret['arrow-side-up-decor3'] = array(
		'name' => __( 'Arrow Side Up (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,198 478.233,24 1604,197.833 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,198 478.233,24 1604,197.833 1604,197.833 478.233,12 -4,198 "/>
<polygon class="gambit_sep_decor1" points="-4,198 478.233,0 1604,197.833 1604,197.833 478.233,12 -4,198 "/>',
		);

		$ret['arrow-up-decor1'] = array(
		'name' => __( 'Arrow Up (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,198 800,0 1604,198 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="-4,174 800,0 1604,174 1604,186.333 800,0 -4,186.333 "/>
<polygon class="gambit_sep_decor2" points="-4,186.333 -4,198 800,0 1604,198 1604,186.333 800,0 "/>',
		);

		$ret['arrow-up-decor2'] = array(
		'name' => __( 'Arrow Up (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,197.667 799.874,24 1604,198 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,197.667 799.874,24 1604,198 1604,186 799.874,12 -4,185.667 "/>
<polygon class="gambit_sep_decor1" points="-4,173.667 799.874,0 1604,174 1604,186 799.874,12 -4,185.667 "/>',
		);

		$ret['arrow-up-decor3'] = array(
		'name' => __( 'Arrow Up (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,198 800,24 1604,197.833 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="-4,198 800,24 1604,197.833 1604,197.833 800,12 -4,198 "/>
<polygon class="gambit_sep_decor1" points="-4,198 800,0 1604,197.833 1604,197.833 800,12 -4,198 "/>',
		);

		$ret['clouds1'] = array(
		'name' => __( 'Clouds #1', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1573.1,101.6c-4.3-2.7-9.4-3.9-14.8-3.3c-6.9,0.8-12.8,4.7-16.4,10
	c-6.8-7.6-17.1-11.9-28.1-10.6c-0.3,0-0.6,0.1-0.9,0.1c-5.5-22.7-27.2-38.3-51.1-35.5c-14.6,1.7-26.8,10-34.2,21.5
	c-6-3.7-13.3-5.5-20.9-4.6c-16.7,2-29,16.3-28.8,32.8c-0.4,0.2-0.8,0.4-1.2,0.6c-4.7-4.3-11.2-6.6-18.1-5.8
	c-6.8,0.8-12.6,4.5-16.2,9.7c0-0.3,0-0.6-0.1-0.9c-3-25.7-26.3-44.2-52.1-41.2c-25.7,3-44.2,26.3-41.2,52.1c0.4,3.1,1,6.1,1.9,8.9
	c-2.7-0.4-5.5-0.4-8.4-0.1c-8.3,1-15.6,5-20.7,10.8c-9.2-15.4-26.8-24.9-45.8-22.7c-20.1,2.3-35.7,17-40.2,35.5
	c-4.8-5.5-12.2-8.7-20-7.8c-5.1,0.6-9.7,2.9-13.2,6.2c0-0.6-0.1-1.2-0.2-1.7c-2.1-17.9-18.3-30.7-36.2-28.6
	c-5,0.6-9.7,2.3-13.7,4.9c-9.8-10.6-24.4-16.5-39.9-14.7c-25.7,3-44.2,26.3-41.2,52.1c-4.1-2.4-9.1-3.5-14.2-2.9
	c-7.4,0.9-13.6,5.2-17.1,11.2c-3.9-1-8-1.4-12.2-0.9c-4.8,0.6-9.2,2.2-13.1,4.5c-7.6-19.4-27.5-32-49.2-29.5
	c-4.7,0.6-9.2,1.8-13.3,3.6c-2-6.9-6.2-13-12-17.2c1.6-2,2.7-4.4,3-7.1c0.7-7.2-4.5-13.7-11.7-14.4c-5.1-0.5-9.8,1.9-12.4,5.9
	c-1.4-0.3-2.8-0.6-4.3-0.7c-15.7-1.6-29.9,8.2-34.5,22.6c-1.4-0.7-2.9-1.2-4.6-1.3c-7.2-0.7-13.7,4.5-14.4,11.7
	c-0.1,1.1-0.1,2.2,0.1,3.2c-10,0.1-19.3,3.4-27,8.9c-4.8-9.8-14.3-16.9-26-18.1c-15.8-1.6-30.1,8.3-34.6,23
	c-6.6-0.2-12.7,2.5-17.1,6.9c-1.3-0.6-2.7-1-4.2-1.1c-1.6-0.2-3.1,0-4.5,0.3c-7.6-9.8-19-16.5-32.3-17.9
	c-14.4-1.5-27.9,3.7-37.5,13.1c-4.4-3.2-9.7-5.3-15.6-5.9c-5.4-0.6-10.6,0.2-15.3,2.1c-2.1-3.2-5.6-5.4-9.6-5.8
	c-0.9-0.1-1.8-0.1-2.7,0c-3.6-6.1-9.9-10.5-17.4-11.3c-6.9-0.7-13.5,1.8-18.2,6.2c-3-20.8-19.8-37.7-41.7-40
	c-12-1.2-23.4,2.2-32.4,8.7c-2.1-2-4.8-3.3-7.8-3.7c-3.7-0.4-7.2,0.8-9.8,3c-4.4-3-9.5-5-15.2-5.6c-17.6-1.8-33.4,10.7-35.7,28.2
	c-6.1-4.1-13.3-6.8-21.1-7.6c-10.3-1.1-20.2,1.3-28.5,6.2c-1.9-1.6-4.3-2.6-7-2.9c-5.6-0.6-10.8,2.5-13.1,7.2
	c-3.7-5-9.4-8.4-16-9.1c-8.9-0.9-17.2,3.4-21.7,10.6c-0.6-0.1-1.2-0.2-1.8-0.3c-1.5-0.2-2.9-0.1-4.3,0.3
	c-5.3-7.3-13.5-12.4-23.2-13.4c-6-0.6-11.7,0.4-16.8,2.7c-6.8-14.4-20.7-25-37.7-26.8c-6.8-0.7-13.3,0.1-19.4,2.1
	c-4.5-10.4-14.4-18.2-26.6-19.5c-13-1.3-25.1,5.2-31.4,15.8c-3.6-3.6-8.4-6.1-13.9-6.6c-9.5-1-18.2,4-22.5,11.9
	c-5.2-7.8-13.8-13.4-23.8-14.4c-10-1-19.5,2.6-26.2,9.2C1.9,114.2-1,114-2,113.9v73.4h1604V71.6C1587,74.2,1574,86.8,1573.1,101.6z
	"/>
<path class="gambit_sep_main" d="M1590.5,28.5c-2.5-0.3-5-0.5-7.5-0.5c-27.5,0-50.5,19.5-55.8,45.5
	c-2.5-1-5.3-1.5-8.2-1.5c-12.7,0-23,10.3-23,23c0,1.9,0.2,3.8,0.7,5.5c-17.3,2-33,9.3-45.3,20.3c-10.1-16.1-28-26.9-48.4-26.9
	c-27.8,0-50.9,19.8-56,46.1c-11.5,0.8-21.7,6.6-28.5,15.1c-2.3-0.8-4.9-1.3-7.5-1.3c-2.8,0-5.4,0.5-7.8,1.4
	c-14.9-15.6-36-25.4-59.3-25.4c-25.3,0-47.9,11.4-62.9,29.4c-8.3-4.7-17.9-7.4-28.1-7.4c-9.5,0-18.4,2.3-26.2,6.4
	c-4.2-5.1-10.6-8.4-17.8-8.4c-1.6,0-3.2,0.2-4.7,0.5c-7.3-10-19-16.5-32.3-16.5c-12.2,0-23.1,5.5-30.5,14.1
	c-8.9-35.7-41.1-62.1-79.5-62.1c-21,0-40.2,7.9-54.7,21c-3.9-3.1-8.9-5-14.3-5c-6.5,0-12.4,2.7-16.6,7c-8.1-4.5-17.5-7-27.4-7
	c-30.9,0-56.1,24.6-57,55.4c-11.4-6-24.3-9.4-38-9.4c-18.1,0-34.8,5.9-48.4,15.8c-3.6-2.4-8-3.8-12.6-3.8
	c-9.9,0-18.3,6.2-21.5,14.9c-7.3-8-17.8-12.9-29.5-12.9c-15.7,0-29.3,9.1-35.8,22.2c-1-0.1-2.1-0.2-3.2-0.2c-2.6,0-5,0.4-7.3,1.2
	C585.2,173.4,570,166,553,166c-10.5,0-20.3,2.8-28.7,7.8C509.9,149.9,483.8,134,454,134c-11.9,0-23.1,2.5-33.3,7.1
	c-9.8-17.3-28.4-29.1-49.7-29.1c-22.9,0-42.7,13.5-51.7,33c-6.9-5.6-15.7-9-25.3-9c-16.7,0-31,10.2-37,24.8
	c-10.5-12.7-26.3-20.8-44-20.8c-17.6,0-33.4,8-43.9,20.6c-2.7-0.4-5.4-0.6-8.1-0.6c-6.7,0-13.1,1.2-19.1,3.3
	c0.1-0.8,0.1-1.5,0.1-2.3c0-12.7-10.3-23-23-23c-5.4,0-10.3,1.8-14.2,4.9c-10.8-10.4-24.4-17.8-39.6-21.1c3.1-5.6,4.8-12,4.8-18.8
	c0-21.5-17.5-39-39-39c-1.8,0-3.5,0.1-5.2,0.4C24.3,46.3,12.4,30.5-2,21.2V396h1604V18.8C1598,21,1592.6,24.4,1590.5,28.5z"/>',
		);

		$ret['clouds2'] = array(
		'name' => __( 'Clouds #2', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor2" d="M712.8,170.7c-4.4-30.3-32.5-51.4-62.9-47c-9.2,1.3-17.6,4.9-24.7,10c-8.9-15-26.1-23.9-44.4-21.2
	c-24.2,3.5-41,25.9-37.5,50.1c0.1,0.8,0.2,1.5,0.4,2.2c-0.7-0.1-1.4-0.2-2.1-0.3c-6.9-5.2-15.2-8.9-24.3-10.5
	c-19.8-3.3-39,4.4-51.2,18.6c-3.1-1.3-6.5-2.3-9.9-2.9c-7.6-1.3-15-0.5-21.8,1.8c-4.3-9.5-13.1-16.8-24.1-18.6
	c-11.6-1.9-22.8,2.6-29.9,11c-5.4-9-13.9-16.1-24.3-19.5c2.7-28.7-17.2-55.1-46.1-59.9c-21.6-3.6-42.3,5.8-54.2,22.4
	c-8.2-9.6-19.7-16.5-33.1-18.7c-28.5-4.7-55.5,13.1-62.8,40.5c-2.8-1.9-6-3.3-9.5-3.9c-3.1-0.5-6.2-0.4-9.1,0.3
	c-4.7-7.5-12.5-13-22-14.6c-10.4-1.7-20.4,1.7-27.5,8.4c-3.4-3.9-8.2-6.7-13.7-7.7c-10.4-1.7-20.3,3.7-24.7,12.7
	c-5.4-3.9-11.7-6.6-18.7-7.8c-8.1-1.3-16-0.4-23.2,2.4c-2.2-5.2-8.3-9.4-13.5-11.8V184h715.1C713.5,179.7,713.4,175.2,712.8,170.7
	z"/>
<path class="gambit_sep_decor1" d="M1602,57.4c-11.2,5.2-22.1,14-27.6,24.5c-2.8-0.1-5.6,0.2-8.4,0.9c-3.5,0.8-6.7,2.2-9.6,4
	c-10.5-10.6-26.1-15.6-41.6-11.9c-14.2,3.4-25.2,13.3-30.5,25.8c-6-14.4-21.6-22.7-37.2-19c-10.9,2.6-19.1,10.4-22.8,20.1
	c-13.1-14.8-33.8-22.1-54.4-17.2c-19.6,4.7-34.2,19.1-40,37c-3.4,0-6.8,0.4-10.3,1.2c-7.5,1.8-14,5.3-19.3,10.1
	c-7.6-7.1-18.5-10.4-29.4-7.8c-11.4,2.7-20,11.2-23.3,21.7c-8.4-6.2-19.1-9.4-30-8.5c-8.7-27.5-37.2-44.1-65.8-37.3
	c-21.3,5.1-36.7,21.7-41.3,41.7c-11.3-5.7-24.5-7.5-37.7-4.4c-22.6,5.4-38.7,23.9-42,45.5H1602V57.4z"/>
<path class="gambit_sep_main" d="M1576.7,52.7c-24.1,3.4-44.5,18.3-55.3,39.1c-3.2-1.2-6.7-1.8-10.4-1.8c-17.1,0-31,13.9-31,31
	c-12,2.6-22.1,10.1-28.1,20.4c-6.9-25-29.7-43.3-56.9-43.3c-12,0-23.1,3.6-32.4,9.7c-5.2-4.8-12.1-7.7-19.6-7.7
	c-10.5,0-19.7,5.6-24.8,14c-0.1,0-0.1,0-0.2,0c-16.8,0-31.3,9.6-38.4,23.7c-5.1-8.2-14.2-13.7-24.6-13.7c-16,0-29,13-29,29
	c0,6.2,1.9,11.9,5.2,16.6c-6,2-11.1,5.7-14.9,10.6c-13.1-20.6-36.2-34.2-62.4-34.2c-13.8,0-26.7,3.8-37.7,10.3
	c-4.8-10.8-15.7-18.3-28.3-18.3c-17.1,0-31,13.9-31,31c0,1,0.1,2,0.1,3c-5.5-1.3-11.2-2-17.1-2c-3.3,0-6.5,0.2-9.6,0.6
	c-8.3-22.6-30-38.6-55.4-38.6c-26.2,0-48.4,17.1-56.1,40.7c-7.2-5.5-16.2-8.7-25.9-8.7c-2.3,0-4.6,0.2-6.8,0.5
	c-6.4-25.6-29.6-44.5-57.2-44.5c-14.9,0-28.5,5.5-38.8,14.6C779,127.9,766,124,752,124c-33.9,0-62.5,22.8-71.2,54
	c-7.7-7.4-18.2-12-29.8-12c-12.2,0-23.2,5.1-31,13.3c-0.9-31.8-27-57.3-59-57.3c-14.7,0-28.2,5.4-38.5,14.4
	c-7.1-5.2-15.9-8.4-25.5-8.4c-0.8,0-1.5,0-2.3,0.1C482,105.4,457.8,90,430,90c-26.5,0-49.8,14-62.8,34.9
	c-9.6-6.9-21.4-10.9-34.2-10.9c-32.6,0-59,26.4-59,59c0,0.4,0,0.8,0,1.3c-5.7-6.3-13.9-10.3-23-10.3c-8.6,0-16.4,3.5-22,9.2
	c-6.3-15.9-21.8-27.2-40-27.2c-21.3,0-39.1,15.6-42.4,36c-8.7-5.1-18.8-8-29.6-8c-5.7,0-11.1,0.8-16.3,2.3
	c-6-31.9-32.3-56.5-65.1-59.9c0.2-1.8,0.3-3.6,0.3-5.4c0-21.4-17.6-39.1-38-42.4V396h1604V31.1C1591.4,33.8,1579.1,42,1576.7,52.7z
	"/>',
		);

		$ret['clouds3'] = array(
		'name' => __( 'Clouds #3', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1602,89.861c-11.991-11.844-31.309-17.943-49.191-14.884 c-24.201,4.139-41.873,23.743-44.642,46.939c-7.845-3.247-16.667-4.404-25.654-2.866c-10.65,1.822-19.825,7.129-26.579,14.541 c-4.445-19.281-23.225-31.968-42.975-28.59c-16.765,2.867-29.02,16.421-30.989,32.478c-8.467-4.125-18.253-5.742-28.245-4.034 c-8.168,1.397-15.466,4.847-21.474,9.72c-10.925-13.57-28.674-20.983-47.065-17.837c-26.53,4.538-44.502,29.346-40.778,55.821 c-5.233,0.955-9.943,3.121-13.894,6.161c-0.373-0.415-0.768-0.807-1.155-1.208c2.877-6.477,4.525-13.627,4.636-21.161 c0.443-29.906-23.442-54.508-53.348-54.951c-20.104-0.297-37.798,10.408-47.38,26.537c-8.403-10.334-21.144-17.019-35.504-17.232 c-19.052-0.282-35.595,10.909-43.072,27.176c-5.403-4.308-12.217-6.931-19.662-7.041c-17.861-0.264-32.554,14-32.818,31.861 c-0.019,1.316,0.049,2.612,0.183,3.889c-0.82-0.094-1.652-0.149-2.495-0.162c-5.651-0.084-10.886,1.732-15.106,4.851 c-6.765-8.693-17.262-14.356-29.133-14.532c-8.41-0.124-16.216,2.523-22.548,7.095c-5.152-24.146-26.413-42.423-52.147-42.804 c-24.549-0.363-45.513,15.672-52.484,37.969c-7.118-4.63-15.578-7.382-24.695-7.516c-10.804-0.16-20.795,3.377-28.792,9.427 c-0.839-19.769-16.977-35.681-37.012-35.977c-13.683-0.202-25.759,6.934-32.497,17.764c1.699-10.904-0.839-22.455-8.012-31.958 c-1.669-2.211-3.518-4.204-5.503-5.99c4.611-8.436,4.176-19.142-1.993-27.314c-8.395-11.121-24.216-13.332-35.337-4.937 c-8.172,6.168-11.525,16.345-9.403,25.722c-2.399,1.173-4.723,2.583-6.934,4.252c-7.432,5.61-12.479,13.203-14.976,21.484 c-4.627-1.511-9.555-2.365-14.679-2.441c-18.335-0.271-34.48,9.439-43.29,24.099c-5.752-1.789-12.248-0.89-17.422,3.016 c-2.901,2.19-5.01,5.04-6.28,8.181c-6.442-2.804-13.495-3.941-20.479-3.356c-5.186-2.097-10.831-3.306-16.76-3.393 c-9.851-0.146-19.029,2.782-26.634,7.885c-7.74-19.962-26.975-34.254-49.699-34.591c-13.641-0.202-26.168,4.669-35.812,12.852 c-4.023-1.885-8.497-2.976-13.228-3.046c-15.62-0.231-28.817,10.651-32.059,25.332c-4.323-3.949-10.048-6.397-16.363-6.49 c-6.228-0.092-11.949,2.123-16.362,5.847c-5.495-19.271-23.086-33.511-44.155-33.823c-18.02-0.267-33.793,9.731-41.777,24.578 c-9.759-11.871-24.471-19.54-41.04-19.785c-9.544-0.141-18.542,2.204-26.392,6.423c-5.744-18.872-23.142-32.732-43.924-33.039 c-15.338-0.227-29.053,6.979-37.721,18.284c-2.473-0.552-5.038-0.863-7.671-0.902c-6.921-0.102-13.427,1.68-19.045,4.859 C48.249,107.812,24.501,88.422-2,88.008V191.5h1604V89.861z"/>
<path class="gambit_sep_main" d="M1585.798,165.336c-4.467-0.867-9.077-1.336-13.798-1.336 c-19.769,0-37.672,7.972-50.683,20.87C1513.353,167.82,1496.061,156,1476,156c-10.484,0-20.21,3.233-28.248,8.747 c-4.4-2.629-9.154-4.722-14.171-6.203c-3.735-14.128-16.6-24.544-31.902-24.544c-6.196,0-11.99,1.711-16.943,4.681 C1372.384,116.791,1348.926,102,1322,102c-30.379,0-56.344,18.824-66.918,45.436C1243.926,136.649,1228.744,130,1212,130 c-24.234,0-45.206,13.912-55.403,34.177C1150.546,156.748,1141.329,152,1131,152c-14.183,0-26.274,8.949-30.94,21.508 c-7.616-9.148-18.957-15.075-31.694-15.474C1057.449,132.161,1031.846,114,1002,114c-18.298,0-34.991,6.838-47.693,18.082 C943.749,112.958,923.391,100,900,100c-19.038,0-36.063,8.588-47.436,22.093c-4.916-3.54-10.604-6.07-16.77-7.281 C833.132,77.472,802.018,48,764,48c-38.653,0-70.184,30.461-71.916,68.687C686.362,114.945,680.292,114,674,114 c-31.324,0-57.208,23.234-61.393,53.407C605.816,163.957,598.139,162,590,162c-0.8,0-1.595,0.023-2.386,0.06 c0.254-1.65,0.386-3.34,0.386-5.06c0-18.225-14.775-33-33-33c-2.322,0-4.586,0.242-6.772,0.699C536.875,112,520.374,104,502,104 c-13.607,0-26.182,4.395-36.407,11.827C463.111,100.06,449.465,88,433,88c-18.225,0-33,14.775-33,33 c0,1.703,0.129,3.376,0.378,5.01c-0.127-0.001-0.251-0.01-0.378-0.01c-22.172,0-41.996,10.029-55.203,25.791 C336.617,135.323,319.635,124,300,124c-18.813,0-35.191,10.395-43.725,25.75c-4.568-2.391-9.761-3.75-15.275-3.75 c-17.231,0-31.37,13.209-32.862,30.052C203.996,174.724,199.583,174,195,174c-5.609,0-10.961,1.085-15.873,3.038 C176.032,164.943,165.061,156,152,156c-8.917,0-16.855,4.174-21.982,10.668C124.315,164.939,118.268,164,112,164 c-20.706,0-39.028,10.16-50.289,25.756C48.774,170.597,24.858,158,0,158c-0.67,0-1.335,0.019-2,0.037V202h1604v-53.979 C1595.867,152.417,1588.936,158.384,1585.798,165.336z"/>',
		);

		$ret['curve-inward1'] = array(
		'name' => __( 'Curve Inward (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M-4,20.062V190h1608V20.062C1475.208,127.246,1160.989,170,800,170 C437.118,170,123.562,128.141-4,20.062z"/>
<path class="gambit_sep_decor2" d="M-4,20.062V196h1608V20.062C1475.208,127.246,1160.989,182,800,182 C437.118,182,123.562,128.141-4,20.062z"/>
<path class="gambit_sep_main" d="M-4,20.062V204h1608V20.062C1475.208,127.246,1160.989,194,800,194 C437.118,194,123.562,128.141-4,20.062z"/>',
		);

		$ret['curve-inward2'] = array(
		'name' => __( 'Curve Inward (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_main" d="M-4,20.062V204h1608V20.062C1475.208,127.246,1160.989,194,800,194 C437.118,194,123.562,128.141-4,20.062z"/>
<path class="gambit_sep_decor2" d="M1213.995,161.367C1387.294,142.237,1528.676,106.186,1604,43.5V20.062 C1528.676,82.748,1387.294,131.604,1213.995,161.367z"/>
<path class="gambit_sep_decor1" d="M-4,44c75.036,63.575,217.051,99.413,391.845,118.149 C213.051,132.602,71.036,83.638-4,20.062V44z"/>',
		);

		$ret['curve-outward1'] = array(
		'name' => __( 'Curve Outward (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1604,190.382C1476.438,82.304,1162.882,6,800,6 C439.011,6,124.792,81.617-4,188.8v5.2l1608-0.109V190.382z"/>
<path class="gambit_sep_decor2" d="M1604,190.977C1476.438,89.584,1162.882,18,800,18 C439.011,18,124.792,88.947-4,189.5v4.5l1608-0.109V190.977z"/>
<path class="gambit_sep_main" d="M1604,191.572C1476.438,96.864,1162.882,30,800,30 C439.011,30,124.792,96.276-4,190.2V204h1608V191.572z"/>',
		);

		$ret['curve-outward2'] = array(
		'name' => __( 'Curve Outward (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_main" d="M1604,179.938C1476.438,71.859,1162.882,6,800,6 C439.011,6,124.792,72.754-4,179.938V204h1608V179.938z"/>
<path class="gambit_sep_decor2" d="M1172.094,31.513C1366.225,62.848,1524.406,120.68,1604,191.667v-11.729 C1523.318,111.579,1365.831,60.111,1172.094,31.513z"/>
<path class="gambit_sep_decor1" d="M-4,179.938V192C94.725,105.515,309.668,37.501,567.616,14.457 C309.687,35.572,95.411,95.085-4,179.938z"/>',
		);

		$ret['curve-side1'] = array(
		'name' => __( 'Curve Side (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1604,54.605V0c-0.831,0-2.101,0-4,0C952.333,0-8,192-8,192v10.25C-8,202.25,952.333,34,1600,34C1601.895,34,1603.169,41.99,1604,54.605z"/>
<path class="gambit_sep_decor2" d="M1605.372,109.123c0.145-48.423-0.834-97.248-5.372-97.248C952.333,11.875-8,192-8,192v10.25C-8,202.25,952.333,34,1600,34C1603.999,34,1605.234,69.579,1605.372,109.123z"/>
<path class="gambit_sep_main" d="M-8,192c0,0,960.333-168.25,1608-168.25c32,0,4,200.25,4,200.25H-8V192z"/>',
		);

		$ret['curve-side2'] = array(
		'name' => __( 'Curve Side (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1604,54.615V0c-0.831,0-2.101,0-4,0C952.333,0-8,168-8,168v34.333 C-8,202.333,952.333,34,1600,34C1601.895,34,1603.169,41.994,1604,54.615z"/>
<path class="gambit_sep_decor2" d="M1605.371,109.143c0.145-48.43-0.834-97.268-5.371-97.268C952.333,11.875-8,180-8,180v14v8.333 C-8,202.333,952.333,34,1600,34C1603.998,34,1605.233,69.587,1605.371,109.143z"/>
<path class="gambit_sep_main" d="M-8,192c0,0,960.333-168.333,1608-168.333c9,0,4,180.333,4,180.333H-8V192z"/>',
		);

		$ret['dissolve-circle'] = array(
		'name' => __( 'Dissolve Circle', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<circle class="gambit_sep_decor2" cx="8" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="8" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="8" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="8" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="96" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="96" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="96" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="96" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="184" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="184" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="184" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="184" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="272" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="272" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="272" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="272" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="360" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="360" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="360" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="360" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="448" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="448" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="448" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="448" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="536" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="536" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="536" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="536" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="624" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="624" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="624" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="624" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="712" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="712" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="712" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="712" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="800" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="800" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="800" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="800" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="888" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="888" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="888" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="888" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="976" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="976" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="976" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="976" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1064" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1064" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1064" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1064" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1152" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1152" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1152" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1152" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1240" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1240" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1240" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1240" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1328" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1328" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1328" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1328" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1416" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1416" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1416" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1416" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1504" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1504" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1504" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1504" cy="16" r="2"/>
<circle class="gambit_sep_decor2" cx="1592" cy="112" r="26"/>
<circle class="gambit_sep_decor2" cx="1592" cy="64" r="14"/>
<circle class="gambit_sep_decor1" cx="1592" cy="34" r="8"/>
<circle class="gambit_sep_decor1" cx="1592" cy="16" r="2"/>
<path class="gambit_sep_main" d="M1638,192c0-25.405-20.595-46-46-46c-20.729,0-38.25,13.713-44,32.561 c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561 c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561 c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561c-5.75-18.848-23.271-32.561-44-32.561s-38.25,13.713-44,32.561 C1014.25,159.713,996.729,146,976,146s-38.25,13.713-44,32.561C926.25,159.713,908.729,146,888,146s-38.25,13.713-44,32.561 C838.25,159.713,820.729,146,800,146s-38.25,13.713-44,32.561C750.25,159.713,732.729,146,712,146s-38.25,13.713-44,32.561 C662.25,159.713,644.729,146,624,146s-38.25,13.713-44,32.561C574.25,159.713,556.729,146,536,146s-38.25,13.713-44,32.561 C486.25,159.713,468.729,146,448,146s-38.25,13.713-44,32.561C398.25,159.713,380.729,146,360,146s-38.25,13.713-44,32.561 C310.25,159.713,292.729,146,272,146s-38.25,13.713-44,32.561C222.25,159.713,204.729,146,184,146s-38.25,13.713-44,32.561 C134.25,159.713,116.729,146,96,146s-38.25,13.713-44,32.561C46.25,159.713,28.729,146,8,146c-25.405,0-46,20.595-46,46 c0,24.056,18.469,43.787,42,45.816V238h1596v-0.708C1621.589,233.504,1638,214.675,1638,192z"/>',
		);

		$ret['dissolve-square'] = array(
		'name' => __( 'Dissolve Square', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_decor2" points="488,90 452,90 450.714,126 489.286,126 "/>
<polygon class="gambit_sep_decor2" points="480.786,56 458.786,56 458,78 481.571,78 "/>
<polygon class="gambit_sep_decor1" points="474.357,34 464.357,34 464,44 474.714,44 "/>
<polygon class="gambit_sep_decor1" points="472.357,14 466.357,14 466.143,20 472.571,20 "/>
<polygon class="gambit_sep_decor2" points="548,90 512,90 510.714,126 549.286,126 "/>
<polygon class="gambit_sep_decor2" points="540.786,56 518.786,56 518,78 541.571,78 "/>
<polygon class="gambit_sep_decor1" points="534.357,34 524.357,34 524,44 534.714,44 "/>
<polygon class="gambit_sep_decor1" points="532.357,14 526.357,14 526.143,20 532.571,20 "/>
<polygon class="gambit_sep_decor2" points="608,90 572,90 570.714,126 609.286,126 "/>
<polygon class="gambit_sep_decor2" points="600.786,56 578.786,56 578,78 601.571,78 "/>
<polygon class="gambit_sep_decor1" points="594.357,34 584.357,34 584,44 594.714,44 "/>
<polygon class="gambit_sep_decor1" points="592.357,14 586.357,14 586.143,20 592.571,20 "/>
<polygon class="gambit_sep_decor2" points="668,90 632,90 630.714,126 669.286,126 "/>
<polygon class="gambit_sep_decor2" points="660.786,56 638.786,56 638,78 661.571,78 "/>
<polygon class="gambit_sep_decor1" points="654.357,34 644.357,34 644,44 654.714,44 "/>
<polygon class="gambit_sep_decor1" points="652.357,14 646.357,14 646.143,20 652.571,20 "/>
<polygon class="gambit_sep_decor2" points="728,90 692,90 690.714,126 729.286,126 "/>
<polygon class="gambit_sep_decor2" points="720.786,56 698.786,56 698,78 721.571,78 "/>
<polygon class="gambit_sep_decor1" points="714.357,34 704.357,34 704,44 714.714,44 "/>
<polygon class="gambit_sep_decor1" points="712.357,14 706.357,14 706.143,20 712.571,20 "/>
<polygon class="gambit_sep_decor2" points="788,90 752,90 750.714,126 789.286,126 "/>
<polygon class="gambit_sep_decor2" points="780.786,56 758.786,56 758,78 781.571,78 "/>
<polygon class="gambit_sep_decor1" points="774.357,34 764.357,34 764,44 774.714,44 "/>
<polygon class="gambit_sep_decor1" points="772.357,14 766.357,14 766.143,20 772.571,20 "/>
<polygon class="gambit_sep_decor2" points="128,90 92,90 90.714,126 129.286,126 "/>
<polygon class="gambit_sep_decor2" points="120.786,56 98.786,56 98,78 121.571,78 "/>
<polygon class="gambit_sep_decor1" points="114.357,34 104.357,34 104,44 114.714,44 "/>
<polygon class="gambit_sep_decor1" points="112.357,14 106.357,14 106.143,20 112.571,20 "/>
<polygon class="gambit_sep_decor2" points="188,90 152,90 150.714,126 189.286,126 "/>
<polygon class="gambit_sep_decor2" points="180.786,56 158.786,56 158,78 181.571,78 "/>
<polygon class="gambit_sep_decor1" points="174.357,34 164.357,34 164,44 174.714,44 "/>
<polygon class="gambit_sep_decor1" points="172.357,14 166.357,14 166.143,20 172.571,20 "/>
<polygon class="gambit_sep_decor2" points="248,90 212,90 210.714,126 249.286,126 "/>
<polygon class="gambit_sep_decor2" points="240.786,56 218.786,56 218,78 241.571,78 "/>
<polygon class="gambit_sep_decor1" points="234.357,34 224.357,34 224,44 234.714,44 "/>
<polygon class="gambit_sep_decor1" points="232.357,14 226.357,14 226.143,20 232.571,20 "/>
<polygon class="gambit_sep_decor2" points="308,90 272,90 270.714,126 309.286,126 "/>
<polygon class="gambit_sep_decor2" points="300.786,56 278.786,56 278,78 301.571,78 "/>
<polygon class="gambit_sep_decor1" points="294.357,34 284.357,34 284,44 294.714,44 "/>
<polygon class="gambit_sep_decor1" points="292.357,14 286.357,14 286.143,20 292.571,20 "/>
<polygon class="gambit_sep_decor2" points="368,90 332,90 330.714,126 369.286,126 "/>
<polygon class="gambit_sep_decor2" points="360.786,56 338.786,56 338,78 361.571,78 "/>
<polygon class="gambit_sep_decor1" points="354.357,34 344.357,34 344,44 354.714,44 "/>
<polygon class="gambit_sep_decor1" points="352.357,14 346.357,14 346.143,20 352.571,20 "/>
<polygon class="gambit_sep_decor2" points="428,90 392,90 390.714,126 429.286,126 "/>
<polygon class="gambit_sep_decor2" points="420.786,56 398.786,56 398,78 421.571,78 "/>
<polygon class="gambit_sep_decor1" points="414.357,34 404.357,34 404,44 414.714,44 "/>
<polygon class="gambit_sep_decor1" points="412.357,14 406.357,14 406.143,20 412.571,20 "/>
<polygon class="gambit_sep_decor2" points="8,90 -28,90 -29.286,126 9.286,126 "/>
<polygon class="gambit_sep_decor2" points="0.786,56 -21.214,56 -22,78 1.571,78 "/>
<polygon class="gambit_sep_decor1" points="-5.643,34 -15.643,34 -16,44 -5.286,44 "/>
<polygon class="gambit_sep_decor1" points="-7.643,14 -13.643,14 -13.857,20 -7.429,20 "/>
<polygon class="gambit_sep_decor2" points="68,90 32,90 30.714,126 69.286,126 "/>
<polygon class="gambit_sep_decor2" points="60.786,56 38.786,56 38,78 61.571,78 "/>
<polygon class="gambit_sep_decor1" points="54.357,34 44.357,34 44,44 54.714,44 "/>
<polygon class="gambit_sep_decor1" points="52.357,14 46.357,14 46.143,20 52.571,20 "/>
<polygon class="gambit_sep_decor2" points="1328,90 1292,90 1290.714,126 1329.286,126 "/>
<polygon class="gambit_sep_decor2" points="1320.786,56 1298.786,56 1298,78 1321.571,78 "/>
<polygon class="gambit_sep_decor1" points="1314.357,34 1304.357,34 1304,44 1314.714,44 "/>
<polygon class="gambit_sep_decor1" points="1312.357,14 1306.357,14 1306.143,20 1312.571,20 "/>
<polygon class="gambit_sep_decor2" points="1388,90 1352,90 1350.714,126 1389.286,126 "/>
<polygon class="gambit_sep_decor2" points="1380.786,56 1358.786,56 1358,78 1381.571,78 "/>
<polygon class="gambit_sep_decor1" points="1374.357,34 1364.357,34 1364,44 1374.714,44 "/>
<polygon class="gambit_sep_decor1" points="1372.357,14 1366.357,14 1366.143,20 1372.571,20 "/>
<polygon class="gambit_sep_decor2" points="1448,90 1412,90 1410.714,126 1449.286,126 "/>
<polygon class="gambit_sep_decor2" points="1440.786,56 1418.786,56 1418,78 1441.571,78 "/>
<polygon class="gambit_sep_decor1" points="1434.357,34 1424.357,34 1424,44 1434.714,44 "/>
<polygon class="gambit_sep_decor1" points="1432.357,14 1426.357,14 1426.143,20 1432.571,20 "/>
<polygon class="gambit_sep_decor2" points="1508,90 1472,90 1470.714,126 1509.286,126 "/>
<polygon class="gambit_sep_decor2" points="1500.786,56 1478.786,56 1478,78 1501.571,78 "/>
<polygon class="gambit_sep_decor1" points="1494.357,34 1484.357,34 1484,44 1494.714,44 "/>
<polygon class="gambit_sep_decor1" points="1492.357,14 1486.357,14 1486.143,20 1492.571,20 "/>
<polygon class="gambit_sep_decor2" points="1568,90 1532,90 1530.714,126 1569.286,126 "/>
<polygon class="gambit_sep_decor2" points="1560.786,56 1538.786,56 1538,78 1561.571,78 "/>
<polygon class="gambit_sep_decor1" points="1554.357,34 1544.357,34 1544,44 1554.714,44 "/>
<polygon class="gambit_sep_decor1" points="1552.357,14 1546.357,14 1546.143,20 1552.571,20 "/>
<polygon class="gambit_sep_decor2" points="1628,90 1592,90 1590.714,126 1629.286,126 "/>
<polygon class="gambit_sep_decor2" points="1620.786,56 1598.786,56 1598,78 1621.571,78 "/>
<polygon class="gambit_sep_decor1" points="1614.357,34 1604.357,34 1604,44 1614.714,44 "/>
<polygon class="gambit_sep_decor1" points="1612.357,14 1606.357,14 1606.143,20 1612.571,20 "/>
<polygon class="gambit_sep_decor2" points="968,90 932,90 930.714,126 969.286,126 "/>
<polygon class="gambit_sep_decor2" points="960.786,56 938.786,56 938,78 961.571,78 "/>
<polygon class="gambit_sep_decor1" points="954.357,34 944.357,34 944,44 954.714,44 "/>
<polygon class="gambit_sep_decor1" points="952.357,14 946.357,14 946.143,20 952.571,20 "/>
<polygon class="gambit_sep_decor2" points="1028,90 992,90 990.714,126 1029.286,126 "/>
<polygon class="gambit_sep_decor2" points="1020.786,56 998.786,56 998,78 1021.571,78 "/>
<polygon class="gambit_sep_decor1" points="1014.357,34 1004.357,34 1004,44 1014.714,44 "/>
<polygon class="gambit_sep_decor1" points="1012.357,14 1006.357,14 1006.143,20 1012.571,20 "/>
<polygon class="gambit_sep_decor2" points="1088,90 1052,90 1050.714,126 1089.286,126 "/>
<polygon class="gambit_sep_decor2" points="1080.786,56 1058.786,56 1058,78 1081.571,78 "/>
<polygon class="gambit_sep_decor1" points="1074.357,34 1064.357,34 1064,44 1074.714,44 "/>
<polygon class="gambit_sep_decor1" points="1072.357,14 1066.357,14 1066.143,20 1072.571,20 "/>
<polygon class="gambit_sep_decor2" points="1148,90 1112,90 1110.714,126 1149.286,126 "/>
<polygon class="gambit_sep_decor2" points="1140.786,56 1118.786,56 1118,78 1141.571,78 "/>
<polygon class="gambit_sep_decor1" points="1134.357,34 1124.357,34 1124,44 1134.714,44 "/>
<polygon class="gambit_sep_decor1" points="1132.357,14 1126.357,14 1126.143,20 1132.571,20 "/>
<polygon class="gambit_sep_decor2" points="1208,90 1172,90 1170.714,126 1209.286,126 "/>
<polygon class="gambit_sep_decor2" points="1200.786,56 1178.786,56 1178,78 1201.571,78 "/>
<polygon class="gambit_sep_decor1" points="1194.357,34 1184.357,34 1184,44 1194.714,44 "/>
<polygon class="gambit_sep_decor1" points="1192.357,14 1186.357,14 1186.143,20 1192.571,20 "/>
<polygon class="gambit_sep_decor2" points="1268,90 1232,90 1230.714,126 1269.286,126 "/>
<polygon class="gambit_sep_decor2" points="1260.786,56 1238.786,56 1238,78 1261.571,78 "/>
<polygon class="gambit_sep_decor1" points="1254.357,34 1244.357,34 1244,44 1254.714,44 "/>
<polygon class="gambit_sep_decor1" points="1252.357,14 1246.357,14 1246.143,20 1252.571,20 "/>
<polygon class="gambit_sep_decor2" points="848,90 812,90 810.714,126 849.286,126 "/>
<polygon class="gambit_sep_decor2" points="840.786,56 818.786,56 818,78 841.571,78 "/>
<polygon class="gambit_sep_decor1" points="834.357,34 824.357,34 824,44 834.714,44 "/>
<polygon class="gambit_sep_decor1" points="832.357,14 826.357,14 826.143,20 832.571,20 "/>
<polygon class="gambit_sep_decor2" points="908,90 872,90 870.714,126 909.286,126 "/>
<polygon class="gambit_sep_decor2" points="900.786,56 878.786,56 878,78 901.571,78 "/>
<polygon class="gambit_sep_decor1" points="894.357,34 884.357,34 884,44 894.714,44 "/>
<polygon class="gambit_sep_decor1" points="892.357,14 886.357,14 886.143,20 892.571,20 "/>
<polygon class="gambit_sep_main" points="1638,138 1582,138 1580,194 1578,138 1522,138 1520,194 1518,138 1462,138 1460,194 1458,138 1402,138 1400,194 1398,138 1342,138 1340,194 1338,138 1282,138 1280,194 1278,138 1222,138 1220,194 1218,138 1162,138 1160,194 1158,138 1102,138 1100,194 1098,138 1042,138 1040,194 1038,138 982,138 980,194 978,138 922,138 920,194 918,138 862,138 860,194 858,138 802,138 800,194 798,138 742,138 740,194 738,138 682,138 680,194 678,138 622,138 620,194 618,138 562,138 560,194 558,138 502,138 500,194 498,138 442,138 440,194 438,138 382,138 380,194 378,138 322,138 320,194 318,138 262,138 260,194 258,138 202,138 200,194 198,138 142,138 140,194 138,138 82,138 80,194 78,138 22,138 20,194 18,138 -38,138 -40,194 -40,204 1640,204 1640,194 "/>',
		);

		$ret['envelope'] = array(
		'name' => __( 'Envelope', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<rect x="-16" y="62" class="gambit_sep_main" width="1634" height="44"/>
<polygon class="gambit_sep_decor2" points="164,82 104,82 118,62 178,62 "/>
<polygon class="gambit_sep_decor1" points="284,82 224,82 238,62 298,62 "/>
<polygon class="gambit_sep_decor1" points="44,82 -16,82 -2,62 58,62 "/>
<polygon class="gambit_sep_decor2" points="404,82 344,82 358,62 418,62 "/>
<polygon class="gambit_sep_decor1" points="524,82 464,82 478,62 538,62 "/>
<polygon class="gambit_sep_decor2" points="644,82 584,82 598,62 658,62 "/>
<polygon class="gambit_sep_decor1" points="764,82 704,82 718,62 778,62 "/>
<polygon class="gambit_sep_decor2" points="884,82 824,82 838,62 898,62 "/>
<polygon class="gambit_sep_decor1" points="1004,82 944,82 958,62 1018,62 "/>
<polygon class="gambit_sep_decor2" points="1124,82 1064,82 1078,62 1138,62 "/>
<polygon class="gambit_sep_decor1" points="1244,82 1184,82 1198,62 1258,62 "/>
<polygon class="gambit_sep_decor2" points="1364,82 1304,82 1318,62 1378,62 "/>
<polygon class="gambit_sep_decor1" points="1484,82 1424,82 1438,62 1498,62 "/>
<polygon class="gambit_sep_decor2" points="1604,82 1544,82 1558,62 1618,62 "/>',
		);

		$ret['envelope-slant'] = array(
		'name' => __( 'Envelope Slant', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="1611.912,205.954 -14.224,206 -9.912,2.046 1616.224,162.165 "/>
<polygon class="gambit_sep_decor2" points="167.262,39.589 107.551,33.709 123.443,15.177 183.154,21.057 "/>
<polygon class="gambit_sep_decor1" points="286.684,51.348 226.973,45.468 242.865,26.936 302.577,32.816 "/>
<polygon class="gambit_sep_decor1" points="47.839,27.83 -11.872,21.95 4.021,3.418 63.732,9.298 "/>
<polygon class="gambit_sep_decor2" points="406.107,63.107 346.395,57.227 362.288,38.695 421.999,44.575 "/>
<polygon class="gambit_sep_decor1" points="525.529,74.866 465.818,68.986 481.71,50.454 541.422,56.334 "/>
<polygon class="gambit_sep_decor2" points="644.952,86.625 585.24,80.745 601.133,62.213 660.844,68.093 "/>
<polygon class="gambit_sep_decor1" points="764.374,98.384 704.663,92.504 720.555,73.973 780.267,79.852 "/>
<polygon class="gambit_sep_decor2" points="883.797,110.143 824.085,104.263 839.978,85.732 899.689,91.611 "/>
<polygon class="gambit_sep_decor1" points="1003.219,121.902 943.508,116.023 959.4,97.491 1019.111,103.37 "/>
<polygon class="gambit_sep_decor2" points="1122.641,133.661 1062.93,127.782 1078.823,109.25 1138.534,115.129 "/>
<polygon class="gambit_sep_decor1" points="1242.064,145.42 1182.353,139.541 1198.245,121.009 1257.956,126.888 "/>
<polygon class="gambit_sep_decor2" points="1361.486,157.179 1301.775,151.3 1317.668,132.768 1377.379,138.647 "/>
<polygon class="gambit_sep_decor1" points="1480.909,168.938 1421.198,163.059 1437.09,144.527 1496.801,150.406 "/>
<polygon class="gambit_sep_decor2" points="1600.331,180.697 1540.62,174.818 1556.513,156.286 1616.224,162.165 "/>',
		);

		$ret['fence'] = array(
		'name' => __( 'Fence', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 140,
		'svg' => '
<polygon class="gambit_sep_decor1" points="1630.3,2 1608.3,10 1608.3,126 1590,126 1590,10 1568,2 1546,10
1546,126 1524.3,126 1524.3,10 1502.3,2 1480.3,10 1480.3,126 1462,126 1462,10 1440,2 1418,10 1418,126 1396.3,126 1396.3,10
1374.3,2 1352.3,10 1352.3,126 1334,126 1334,10 1312,2 1290,10 1290,126 1268.3,126 1268.3,10 1246.3,2 1224.3,10 1224.3,126
1206,126 1206,10 1184,2 1162,10 1162,126 1140.3,126 1140.3,10 1118.3,2 1096.3,10 1096.3,126 1078,126 1078,10 1056,2 1034,10
1034,126 1012.3,126 1012.3,10 990.3,2 968.3,10 968.3,126 950,126 950,10 928,2 906,10 906,126 884.3,126 884.3,10 862.3,2
840.3,10 840.3,126 822,126 822,10 800,2 778,10 778,126 759.7,126 759.7,10 737.7,2 715.7,10 715.7,126 694,126 694,10 672,2
650,10 650,126 631.7,126 631.7,10 609.7,2 587.7,10 587.7,126 566,126 566,10 544,2 522,10 522,126 503.7,126 503.7,10 481.7,2
459.7,10 459.7,126 438,126 438,10 416,2 394,10 394,126 375.7,126 375.7,10 353.7,2 331.7,10 331.7,126 310,126 310,10 288,2
266,10 266,126 247.7,126 247.7,10 225.7,2 203.7,10 203.7,126 182,126 182,10 160,2 138,10 138,126 119.7,126 119.7,10 97.7,2
75.7,10 75.7,126 54,126 54,10 32,2 10,10 10,126 -8.3,126 -8.3,10 -30.3,2 -52.3,10 -52.3,146 1652.3,148 1652.3,10 	"/>
<rect x="-60" y="56" class="gambit_sep_decor2" width="1720" height="14"/>
<rect x="-60" y="106" class="gambit_sep_decor2" width="1720" height="14"/>
<polygon class="gambit_sep_main" points="1662.7,14 1640.7,22 1640.7,138 1622.3,138 1622.3,22 1600.3,14
1578.3,22 1578.3,138 1556.7,138 1556.7,22 1534.7,14 1512.7,22 1512.7,138 1494.3,138 1494.3,22 1472.3,14 1450.3,22 1450.3,138
1428.7,138 1428.7,22 1406.7,14 1384.7,22 1384.7,138 1366.3,138 1366.3,22 1344.3,14 1322.3,22 1322.3,138 1300.7,138 1300.7,22
1278.7,14 1256.7,22 1256.7,138 1238.3,138 1238.3,22 1216.3,14 1194.3,22 1194.3,138 1172.7,138 1172.7,22 1150.7,14 1128.7,22
1128.7,138 1110.3,138 1110.3,22 1088.3,14 1066.3,22 1066.3,138 1044.7,138 1044.7,22 1022.7,14 1000.7,22 1000.7,138 982.3,138
982.3,22 960.3,14 938.3,22 938.3,138 916.7,138 916.7,22 894.7,14 872.7,22 872.7,138 854.3,138 854.3,22 832.3,14 810.3,22
810.3,138 792,138 792,22 770,14 748,22 748,138 726.3,138 726.3,22 704.3,14 682.3,22 682.3,138 664,138 664,22 642,14 620,22
620,138 598.3,138 598.3,22 576.3,14 554.3,22 554.3,138 536,138 536,22 514,14 492,22 492,138 470.3,138 470.3,22 448.3,14
426.3,22 426.3,138 408,138 408,22 386,14 364,22 364,138 342.3,138 342.3,22 320.3,14 298.3,22 298.3,138 280,138 280,22 258,14
236,22 236,138 214.3,138 214.3,22 192.3,14 170.3,22 170.3,138 152,138 152,22 130,14 108,22 108,138 86.3,138 86.3,22 64.3,14
42.3,22 42.3,138 24,138 24,22 2,14 -20,22 -20,345.8 1684.7,345.8 1684.7,22 	"/>',
		);

		$ret['fence-bend'] = array(
		'name' => __( 'Fence Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1688.925,74.718c-7.904,1.421-15.799,2.86-23.686,4.315 c-6.026,38.194-12.053,76.388-18.079,114.583c-6.096-0.962-12.194-1.913-18.293-2.855c5.897-38.214,11.794-76.429,17.691-114.643 c-7.067-3.789-14.147-7.564-21.239-11.326c-7.884,1.513-15.759,3.042-23.625,4.589c-5.586,38.261-11.173,76.522-16.76,114.783 c-7.214-1.053-14.43-2.092-21.648-3.117c5.434-38.283,10.867-76.566,16.301-114.849c-7.109-3.702-14.231-7.391-21.365-11.066 c-7.862,1.609-15.715,3.234-23.559,4.876c-5.123,38.326-10.245,76.652-15.368,114.978c-6.113-0.817-12.226-1.624-18.34-2.42 c4.993-38.343,9.986-76.686,14.979-115.029c-7.149-3.62-14.31-7.226-21.483-10.819c-7.84,1.699-15.672,3.415-23.493,5.147 c-4.682,38.382-9.364,76.764-14.045,115.147c-7.232-0.882-14.465-1.75-21.7-2.603c4.528-38.401,9.057-76.801,13.585-115.202 c-7.19-3.533-14.391-7.052-21.604-10.557c-7.817,1.794-15.624,3.605-23.422,5.432c-4.217,38.436-8.433,76.872-12.65,115.308 c-6.126-0.672-12.253-1.334-18.38-1.985c4.087-38.45,8.173-76.9,12.26-115.35c-7.227-3.45-14.467-6.886-21.718-10.307 c-7.793,1.884-15.577,3.785-23.352,5.702c-3.775,38.482-7.55,76.964-11.324,115.446c-7.246-0.711-14.494-1.407-21.743-2.089 c3.621-38.497,7.242-76.994,10.864-115.49c-7.266-3.362-14.545-6.71-21.835-10.043c-7.768,1.978-15.526,3.973-23.275,5.984 c-3.309,38.525-6.618,77.05-9.927,115.575c-6.137-0.527-12.274-1.044-18.413-1.55c3.179-38.536,6.358-77.072,9.536-115.608 c-7.303-3.278-14.617-6.542-21.944-9.791c-7.743,2.068-15.477,4.152-23.2,6.251c-2.866,38.56-5.733,77.121-8.599,115.681 c-7.258-0.54-14.516-1.064-21.776-1.575c2.712-38.572,5.425-77.143,8.137-115.715c-7.34-3.189-14.692-6.364-22.056-9.525 c-7.716,2.161-15.422,4.339-23.118,6.532c-2.4,38.592-4.799,77.184-7.199,115.777c-6.145-0.382-12.291-0.754-18.437-1.115 c2.27-38.6,4.539-77.2,6.808-115.8c-7.375-3.105-14.762-6.195-22.16-9.271c-7.69,2.25-15.37,4.516-23.039,6.797 c-1.957,38.617-3.913,77.234-5.87,115.852c-7.266-0.368-14.533-0.722-21.8-1.061c1.803-38.625,3.605-77.249,5.408-115.874 c-7.411-3.015-14.834-6.016-22.268-9.002c-7.661,2.343-15.312,4.701-22.952,7.075c-1.49,38.638-2.979,77.276-4.469,115.914 c-6.151-0.237-12.302-0.464-18.454-0.68c1.359-38.643,2.718-77.286,4.077-115.929c-7.445-2.93-14.901-5.845-22.368-8.746 c-7.633,2.43-15.255,4.877-22.868,7.338c-1.046,38.653-2.092,77.305-3.138,115.958c-7.272-0.197-14.544-0.379-21.816-0.547 c0.892-38.656,1.784-77.313,2.675-115.969c-7.479-2.84-14.969-5.665-22.47-8.475c-7.603,2.523-15.195,5.061-22.776,7.614 c-0.579,38.662-1.157,77.325-1.736,115.987c-6.154-0.092-12.308-0.174-18.463-0.245c0.448-38.664,0.896-77.328,1.344-115.993 c-7.511-2.754-15.033-5.493-22.566-8.216c-7.573,2.61-15.135,5.235-22.687,7.875c-0.135,38.667-0.27,77.333-0.405,116 c-6.155-0.021-12.31-0.033-18.465-0.033c0.004-38.667,0.009-77.334,0.013-116c-7.542-2.668-15.095-5.32-22.659-7.957 c-7.543,2.696-15.075,5.408-22.596,8.135c0.309,38.666,0.618,77.331,0.927,115.997c-7.274,0.058-14.548,0.131-21.821,0.218 c-0.463-38.664-0.926-77.328-1.389-115.992c-7.574-2.576-15.159-5.137-22.754-7.682c-7.51,2.787-15.009,5.59-22.497,8.407 c0.776,38.659,1.553,77.318,2.329,115.977c-6.154,0.124-12.308,0.258-18.462,0.402c-0.907-38.656-1.814-77.312-2.72-115.968 c-7.604-2.489-15.218-4.963-22.843-7.42c-7.478,2.873-14.945,5.762-22.401,8.665c1.22,38.648,2.44,77.295,3.66,115.943 c-7.272,0.23-14.543,0.474-21.814,0.732c-1.374-38.642-2.748-77.285-4.122-115.927c-7.634-2.397-15.279-4.778-22.933-7.144 c-7.444,2.964-14.876,5.942-22.298,8.936c1.687,38.63,3.374,77.26,5.062,115.89c-6.151,0.269-12.302,0.548-18.452,0.837 c-1.818-38.624-3.635-77.248-5.453-115.872c-7.662-2.309-15.335-4.602-23.017-6.88c-7.41,3.049-14.809,6.113-22.197,9.191 c2.131,38.608,4.261,77.216,6.392,115.824c-7.266,0.401-14.532,0.816-21.797,1.246c-2.285-38.599-4.569-77.198-6.854-115.798 c-7.691-2.216-15.392-4.416-23.103-6.601c-7.374,3.138-14.737,6.292-22.089,9.459c2.597,38.579,5.195,77.159,7.792,115.738 c-6.145,0.414-12.29,0.838-18.434,1.272c-2.728-38.57-5.455-77.141-8.183-115.711c-7.717-2.128-15.445-4.239-23.182-6.334 c-7.34,3.223-14.667,6.461-21.984,9.713c3.04,38.547,6.081,77.094,9.121,115.641c-7.258,0.572-14.515,1.159-21.772,1.761 c-3.194-38.535-6.388-77.069-9.583-115.604c-7.744-2.034-15.499-4.052-23.263-6.053c-7.302,3.312-14.592,6.638-21.871,9.979 c3.507,38.507,7.013,77.015,10.52,115.522c-6.137,0.559-12.273,1.128-18.408,1.708c-3.637-38.495-7.273-76.991-10.91-115.486 c-7.769-1.945-15.549-3.873-23.337-5.785c-7.266,3.396-14.519,6.806-21.761,10.23c3.949,38.465,7.898,76.929,11.847,115.394 c-7.247,0.744-14.492,1.502-21.737,2.275c-4.103-38.448-8.205-76.897-12.307-115.345c-7.795-1.85-15.599-3.684-23.413-5.501 c-7.227,3.484-14.441,6.982-21.644,10.493c4.414,38.414,8.829,76.828,13.243,115.242c-6.126,0.704-12.251,1.418-18.375,2.143 c-4.544-38.399-9.088-76.798-13.633-115.196c-7.818-1.76-15.646-3.504-23.483-5.23c-7.189,3.567-14.365,7.148-21.53,10.743 c4.856,38.361,9.712,76.721,14.567,115.082c-7.232,0.915-14.463,1.845-21.693,2.79C80.858,134.52,75.849,96.179,70.84,57.838 c-7.842-1.665-15.693-3.313-23.553-4.944c-7.148,3.654-14.284,7.322-21.407,11.004c5.32,38.299,10.641,76.598,15.961,114.897 c-6.112,0.849-12.224,1.709-18.334,2.578c-5.45-38.281-10.9-76.561-16.35-114.842C-0.707,64.957-8.58,63.4-16.462,61.86 c-7.109,3.737-14.205,7.487-21.289,11.251c6.754,44.827,13.508,89.655,20.262,134.482C-10.328,206.523-7.2,200.758,0,200 c529.297-55.74,1056.5-71,1600,0c35.313,4.613,52.245,16.536,87.427,22.423c7.538-45.378,15.077-90.756,22.615-136.134 C1703.016,82.418,1695.977,78.561,1688.925,74.718z"/>
<path class="gambit_sep_decor2" d="M1661.418,139.08c-569.782-90.245-1150.218-90.245-1720,0 c-0.73-4.609-1.46-9.218-2.19-13.828c571.233-90.474,1153.147-90.474,1724.38,0C1662.878,129.862,1662.148,134.471,1661.418,139.08 z"/>
<path class="gambit_sep_decor2" d="M1661.418,189.08c-569.782-90.245-1150.218-90.245-1720,0 c-0.73-4.609-1.46-9.218-2.19-13.828c571.233-90.474,1153.147-90.474,1724.38,0C1662.878,179.862,1662.148,184.471,1661.418,189.08 z"/>
<path class="gambit_sep_main" d="M1651.697,81.181c-7.872,1.484-15.735,2.985-23.588,4.503 c-5.738,38.238-11.477,76.477-17.215,114.715c-6.086-0.913-12.172-1.816-18.26-2.709c5.609-38.258,11.218-76.515,16.827-114.773 c-7.074-3.732-14.161-7.451-21.259-11.156c-7.851,1.575-15.693,3.167-23.526,4.776c-5.298,38.302-10.596,76.604-15.894,114.906 c-7.201-0.996-14.404-1.978-21.608-2.945c5.145-38.323,10.29-76.646,15.434-114.969c-7.116-3.646-14.244-7.278-21.384-10.896 c-7.828,1.671-15.647,3.358-23.457,5.061c-4.834,38.363-9.667,76.727-14.501,115.09c-6.1-0.769-12.202-1.527-18.305-2.275 c4.704-38.379,9.408-76.759,14.111-115.138c-7.154-3.563-14.321-7.113-21.499-10.649c-7.806,1.761-15.602,3.538-23.39,5.332 c-4.392,38.416-8.785,76.833-13.177,115.249c-7.217-0.825-14.436-1.636-21.656-2.432c4.239-38.434,8.478-76.867,12.716-115.301 c-7.194-3.476-14.401-6.939-21.619-10.387c-7.781,1.855-15.553,3.727-23.316,5.615c-3.927,38.467-7.854,76.934-11.78,115.4 c-6.113-0.624-12.226-1.238-18.341-1.841c3.797-38.48,7.594-76.96,11.39-115.439c-7.231-3.393-14.475-6.772-21.73-10.137 c-7.758,1.945-15.505,3.906-23.243,5.883c-3.485,38.509-6.969,77.019-10.454,115.528c-7.23-0.654-14.462-1.294-21.694-1.919 c3.331-38.523,6.662-77.046,9.993-115.569c-7.27-3.305-14.552-6.596-21.845-9.873c-7.731,2.039-15.453,4.094-23.165,6.165 c-3.018,38.549-6.037,77.097-9.055,115.646c-6.123-0.479-12.246-0.948-18.37-1.407c2.888-38.559,5.776-77.117,8.665-115.676 c-7.306-3.221-14.623-6.428-21.952-9.621c-7.706,2.128-15.402,4.271-23.087,6.431c-2.575,38.581-5.151,77.162-7.727,115.742 c-7.24-0.483-14.482-0.952-21.724-1.407c2.422-38.591,4.843-77.182,7.265-115.772c-7.343-3.133-14.697-6.251-22.062-9.354 c-7.678,2.221-15.346,4.457-23.004,6.71c-2.109,38.609-4.218,77.218-6.326,115.827c-6.13-0.335-12.26-0.659-18.391-0.973 c1.979-38.616,3.957-77.232,5.935-115.848c-7.377-3.048-14.765-6.081-22.165-9.1c-7.651,2.309-15.292,4.633-22.922,6.973 c-1.665,38.631-3.331,77.262-4.996,115.892c-7.248-0.312-14.496-0.61-21.744-0.894c1.511-38.637,3.022-77.274,4.534-115.911 c-7.412-2.959-14.836-5.902-22.27-8.831c-7.622,2.401-15.233,4.818-22.833,7.25c-1.198,38.648-2.396,77.296-3.595,115.944 c-6.134-0.19-12.269-0.37-18.404-0.539c1.068-38.652,2.135-77.304,3.203-115.956c-7.445-2.873-14.901-5.732-22.368-8.575 c-7.593,2.488-15.175,4.992-22.747,7.512c-0.755,38.659-1.509,77.319-2.264,115.978c-7.252-0.142-14.503-0.269-21.755-0.381 c0.6-38.662,1.201-77.324,1.801-115.986c-7.479-2.783-14.968-5.551-22.469-8.304c-7.562,2.58-15.113,5.175-22.653,7.786 c-0.287,38.666-0.574,77.331-0.861,115.997c-6.137-0.046-12.273-0.081-18.41-0.106c0.156-38.666,0.313-77.333,0.47-115.999 c-7.51-2.697-15.031-5.379-22.562-8.046c-7.532,2.667-15.052,5.349-22.562,8.046c0.157,38.666,0.313,77.333,0.47,115.999 c-6.137,0.025-12.274,0.06-18.41,0.106c-0.287-38.666-0.574-77.331-0.861-115.997c-7.54-2.611-15.091-5.206-22.653-7.786 c-7.501,2.753-14.99,5.521-22.469,8.304c0.6,38.662,1.201,77.324,1.801,115.986c-7.252,0.113-14.504,0.24-21.755,0.381 c-0.755-38.659-1.509-77.319-2.264-115.978c-7.572-2.519-15.154-5.023-22.747-7.512c-7.467,2.843-14.923,5.702-22.368,8.575 c1.068,38.652,2.136,77.304,3.203,115.956c-6.135,0.169-12.27,0.349-18.404,0.539c-1.198-38.648-2.396-77.296-3.595-115.944 c-7.601-2.432-15.212-4.849-22.833-7.25c-7.435,2.929-14.858,5.873-22.27,8.831c1.511,38.637,3.023,77.274,4.534,115.911 c-7.248,0.284-14.496,0.581-21.744,0.894c-1.665-38.631-3.331-77.262-4.996-115.892c-7.63-2.34-15.271-4.665-22.922-6.973 c-7.4,3.019-14.788,6.052-22.165,9.1c1.978,38.616,3.957,77.232,5.935,115.848c-6.131,0.314-12.261,0.639-18.391,0.973 c-2.109-38.609-4.218-77.218-6.326-115.827c-7.658-2.252-15.326-4.489-23.004-6.71c-7.366,3.103-14.72,6.222-22.062,9.354 c2.422,38.591,4.843,77.182,7.265,115.772c-7.242,0.454-14.483,0.923-21.724,1.407c-2.576-38.581-5.151-77.162-7.727-115.742 c-7.686-2.16-15.382-4.303-23.087-6.431c-7.329,3.192-14.646,6.399-21.952,9.621c2.888,38.559,5.776,77.117,8.665,115.676 c-6.124,0.459-12.247,0.928-18.37,1.407c-3.018-38.549-6.037-77.097-9.055-115.646c-7.712-2.071-15.433-4.126-23.165-6.165 c-7.294,3.277-14.575,6.567-21.845,9.873c3.331,38.523,6.662,77.046,9.993,115.569c-7.232,0.625-14.464,1.265-21.694,1.919 c-3.485-38.509-6.969-77.019-10.454-115.528c-7.738-1.977-15.486-3.939-23.243-5.883c-7.255,3.365-14.499,6.744-21.73,10.137 c3.797,38.48,7.594,76.96,11.39,115.439c-6.114,0.603-12.228,1.217-18.341,1.841c-3.927-38.467-7.854-76.934-11.781-115.4 c-7.762-1.888-15.534-3.76-23.316-5.615c-7.218,3.448-14.425,6.91-21.619,10.387c4.239,38.434,8.477,76.867,12.716,115.301 c-7.22,0.796-14.438,1.607-21.655,2.432c-4.392-38.416-8.785-76.833-13.177-115.249c-7.787-1.794-15.584-3.571-23.389-5.332 c-7.179,3.536-14.345,7.085-21.499,10.649c4.704,38.379,9.408,76.759,14.112,115.138c-6.103,0.748-12.204,1.506-18.305,2.275 c-4.834-38.363-9.667-76.727-14.501-115.09c-7.81-1.704-15.629-3.391-23.457-5.061c-7.14,3.618-14.268,7.25-21.384,10.896 c5.145,38.323,10.29,76.646,15.435,114.969c-7.204,0.967-14.407,1.949-21.608,2.945C48.758,153.142,43.46,114.84,38.162,76.538 c-7.833-1.609-15.675-3.201-23.526-4.776C7.537,75.467,0.451,79.185-6.623,82.918c5.609,38.258,11.218,76.515,16.827,114.773 c-6.088,0.893-12.175,1.795-18.26,2.709c-5.738-38.238-11.477-76.477-17.215-114.715c-7.854-1.518-15.717-3.019-23.589-4.503 C-55.92,84.968-62.966,88.768-70,92.582c6.362,40.166,19.085,120.498,19.085,120.498c-8.557,36.033,1140.915-11.08,1704.667,0 c6.362-40.166,12.723-80.332,19.085-120.498C1665.803,88.768,1658.756,84.968,1651.697,81.181z"/>',
		);

		$ret['film'] = array(
		'name' => __( 'Film', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M-34,48v42h1678V48H-34z M0,76c0,1.102-0.902,2.003-2.003,2.003h-9.993 C-13.098,78.003-14,77.102-14,76V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M52,75.997 C52,77.098,51.098,78,49.997,78h-9.993C38.902,78,38,77.098,38,75.997V62.003C38,60.902,38.902,60,40.003,60h9.993 C51.098,60,52,60.902,52,62.003V75.997z M26,76c0,1.102-0.902,2.003-2.003,2.003h-9.993C12.902,78.003,12,77.102,12,76V62.007 c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M78,75.997C78,77.098,77.098,78,75.997,78h-9.993 C64.902,78,64,77.098,64,75.997V62.003C64,60.902,64.902,60,66.003,60h9.993C77.098,60,78,60.902,78,62.003V75.997z M130,75.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M104,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993C90.902,78,90,77.098,90,75.997 V62.003C90,60.902,90.902,60,92.003,60h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M156,76c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M208,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M182,76c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M234,75.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M286,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M260,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M312,75.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.997z M364,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.993z M338,75.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M390,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M442,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V61.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M416,75.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M468,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62.01c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M520,76c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M494,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.01c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M546,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V62.01c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M598,76 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V76z M572,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.01 c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M624,76c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M676,75.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.997z M650,76c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M702,75.99c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V61.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M754,75.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V61.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V75.986z M728,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V61.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M780,75.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V61.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V75.986z M832,75.983c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V61.99c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.983z M806,75.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V61.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V75.986z M858,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M910,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M884,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M936,75.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.997z M988,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V62c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.993z M962,75.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M1014,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V62c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M1066,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V61.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M1040,75.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M1092,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V61.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M1144,75.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V61.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.986z M1118,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V61.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M1170,75.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V61.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.986z M1222,75.983c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V61.99c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.983z M1196,75.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V61.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.986z M1248,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V62.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M1300,75.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M1274,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V62.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M1326,75.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.003c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.997z M1378,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V62c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.993z M1352,75.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M1404,75.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M1456,75.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V61.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V75.99z M1430,75.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V75.993z M1482,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V62.01c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M1534,76c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M1508,76.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.01c0-1.102,0.902-2.003,2.004-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V76.003z M1560,76c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.004-0.902-2.004-2.003V62.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M1612,75.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.003c0-1.102,0.902-2.003,2.004-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V75.997z M1586,76c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.004-0.902-2.004-2.003V62.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V76z M1638,76.01 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V62.017c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V76.01z"/>
<path class="gambit_sep_main" d="M-38,52v86h1678V52H-38z M-4,80c0,1.102-0.902,2.003-2.003,2.003h-9.993 C-17.098,82.003-18,81.102-18,80V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M48,79.997 C48,81.098,47.098,82,45.997,82h-9.993C34.902,82,34,81.098,34,79.997V66.003C34,64.902,34.902,64,36.003,64h9.993 C47.098,64,48,64.902,48,66.003V79.997z M22,80c0,1.102-0.902,2.003-2.003,2.003h-9.993C8.902,82.003,8,81.102,8,80V66.007 c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M74,79.997C74,81.098,73.098,82,71.997,82h-9.993 C60.902,82,60,81.098,60,79.997V66.003C60,64.902,60.902,64,62.003,64h9.993C73.098,64,74,64.902,74,66.003V79.997z M126,79.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M100,79.997C100,81.098,99.098,82,97.997,82h-9.993C86.902,82,86,81.098,86,79.997 V66.003C86,64.902,86.902,64,88.003,64h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M152,80c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M204,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M178,80c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M230,79.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M282,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M256,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M308,79.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.997z M360,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.993z M334,79.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M386,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M438,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V65.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M412,79.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M464,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66.01c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M516,80c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M490,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.01c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M542,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V66.01c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M594,80 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V80z M568,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.01 c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M620,80c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M672,79.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.997z M646,80c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66.007c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M698,79.99c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V65.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M750,79.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V65.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V79.986z M724,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V65.997c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M776,79.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V65.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V79.986z M828,79.983c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V65.99c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.983z M802,79.986c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V65.993c0-1.102,0.902-2.003,2.003-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V79.986z M854,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M906,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M880,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M932,79.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.997z M984,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003 V66c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.993z M958,79.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66.003c0-1.102,0.902-2.003,2.003-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M1010,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.003-0.902-2.003-2.003V66c0-1.102,0.902-2.003,2.003-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M1062,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V65.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M1036,79.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M1088,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V65.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M1140,79.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V65.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.986z M1114,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V65.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M1166,79.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V65.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.986z M1218,79.983c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V65.99c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.983z M1192,79.986 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V65.993c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.986z M1244,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V66.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M1296,79.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M1270,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V66.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M1322,79.997 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.003c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.997z M1374,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V66c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.993z M1348,79.997c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.003c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M1400,79.993c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M1452,79.99c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V65.997c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V79.99z M1426,79.993 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V79.993z M1478,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003 V66.01c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M1530,80c0,1.102-0.902,2.003-2.003,2.003 h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M1504,80.003c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.01c0-1.102,0.902-2.003,2.004-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V80.003z M1556,80c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.004-0.902-2.004-2.003V66.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M1608,79.997c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.003c0-1.102,0.902-2.003,2.004-2.003 h9.993c1.102,0,2.003,0.902,2.003,2.003V79.997z M1582,80c0,1.102-0.902,2.003-2.003,2.003h-9.993 c-1.102,0-2.004-0.902-2.004-2.003V66.007c0-1.102,0.902-2.003,2.004-2.003h9.993c1.102,0,2.003,0.902,2.003,2.003V80z M1634,80.01 c0,1.102-0.902,2.003-2.003,2.003h-9.993c-1.102,0-2.004-0.902-2.004-2.003V66.017c0-1.102,0.902-2.003,2.004-2.003h9.993 c1.102,0,2.003,0.902,2.003,2.003V80.01z"/>',
		);

		$ret['film-slant'] = array(
		'name' => __( 'Film Slant', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M-28.042,5.251L-28,176h1672l0.967-41.424L-28.042,5.251z M3.699,35.788 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L3.699,35.788z M55.544,39.793 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L55.544,39.793z M29.621,37.792 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L29.621,37.792z M81.467,41.797 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L81.467,41.797z M133.312,45.801 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L133.312,45.801z M107.39,43.8 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152L94.51,28.77 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L107.39,43.8z M159.235,47.811 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L159.235,47.811z M211.08,51.816 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L211.08,51.816z M185.157,49.815 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L185.157,49.815z M237.003,53.82 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L237.003,53.82z M288.848,57.824 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L288.848,57.824z M262.926,55.823 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L262.926,55.823z M314.771,59.831 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L314.771,59.831z M366.616,63.835 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L366.616,63.835z M340.694,61.835 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L340.694,61.835z M392.539,65.839 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L392.539,65.839z M444.385,69.843 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L444.385,69.843z M418.462,67.843 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L418.462,67.843z M470.306,71.861 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L470.306,71.861z M522.152,75.865 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L522.152,75.865z M496.229,73.865 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L496.229,73.865z M548.074,77.872 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L548.074,77.872z M599.92,81.877 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L599.92,81.877z M573.997,79.876 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L573.997,79.876z M625.843,83.881 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L625.843,83.881z M677.688,87.885 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L677.688,87.885z M651.765,85.884 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L651.765,85.884z M703.611,89.882 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L703.611,89.882z M755.457,93.886 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L755.457,93.886z M729.534,91.886 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L729.534,91.886z M781.38,95.89 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L781.38,95.89z M833.225,99.894 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L833.225,99.894z M807.302,97.894 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L807.302,97.894z M859.147,101.912 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L859.147,101.912z M910.992,105.916 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L910.992,105.916z M885.07,103.916 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L885.07,103.916z M936.915,107.923 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L936.915,107.923z M988.76,111.927 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L988.76,111.927z M962.838,109.927 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L962.838,109.927z M1014.683,113.931 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1014.683,113.931z M1066.529,117.936 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1066.529,117.936z M1040.606,115.935 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1040.606,115.935z M1092.451,119.939 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1092.451,119.939z M1144.297,123.944 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1144.297,123.944z M1118.374,121.943 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1118.374,121.943z M1170.22,125.948 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1170.22,125.948z M1222.065,129.952 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1222.065,129.952z M1196.142,127.951 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1196.142,127.951z M1247.987,131.969 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1247.987,131.969z M1299.833,135.974 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1299.833,135.974z M1273.91,133.973 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1273.91,133.973z M1325.755,137.981 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1325.755,137.981z M1377.6,141.985 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1377.6,141.985z M1351.677,139.985 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1351.677,139.985z M1403.523,143.989 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1403.523,143.989z M1455.369,147.993 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1455.369,147.993z M1429.446,145.993 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1429.446,145.993z M1481.29,150.011 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1481.29,150.011z M1533.136,154.015 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1533.136,154.015z M1507.213,152.014 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1507.213,152.014z M1559.059,156.019 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1559.059,156.019z M1610.904,160.023 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1610.904,160.023z M1584.981,158.023 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1584.981,158.023z M1636.826,162.04 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1636.826,162.04z"/>
<path class="gambit_sep_main" d="M-32.339,8.931L-32,208h1672l0.67-69.744L-32.339,8.931z M-0.598,39.468 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L-0.598,39.468z M51.248,43.472 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L51.248,43.472z M25.325,41.472 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L25.325,41.472z M77.171,45.476 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L77.171,45.476z M129.016,49.481 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L129.016,49.481z M103.093,47.48 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L103.093,47.48z M154.938,51.491 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L154.938,51.491z M206.784,55.496 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L206.784,55.496z M180.861,53.495 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L180.861,53.495z M232.706,57.499 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L232.706,57.499z M284.552,61.504 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L284.552,61.504z M258.629,59.503 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L258.629,59.503z M310.474,63.511 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L310.474,63.511z M362.32,67.515 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L362.32,67.515z M336.397,65.515 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L336.397,65.515z M388.243,69.519 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L388.243,69.519z M440.088,73.523 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L440.088,73.523z M414.165,71.523 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L414.165,71.523z M466.01,75.541 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L466.01,75.541z M517.856,79.545 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L517.856,79.545z M491.933,77.545 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L491.933,77.545z M543.778,81.552 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L543.778,81.552z M595.624,85.557 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L595.624,85.557z M569.701,83.556 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L569.701,83.556z M621.546,87.56 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L621.546,87.56z M673.392,91.565 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L673.392,91.565z M647.469,89.564 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L647.469,89.564z M699.315,93.562 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L699.315,93.562z M751.161,97.566 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L751.161,97.566z M725.238,95.565 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L725.238,95.565z M777.083,99.57 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L777.083,99.57z M828.929,103.574 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L828.929,103.574z M803.006,101.574 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L803.006,101.574z M854.85,105.592 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L854.85,105.592z M906.696,109.596 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L906.696,109.596z M880.773,107.595 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L880.773,107.595z M932.618,111.603 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L932.618,111.603z M984.464,115.607 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L984.464,115.607z M958.541,113.607 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L958.541,113.607z M1010.387,117.611 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1010.387,117.611z M1062.232,121.615 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1062.232,121.615z M1036.309,119.615 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1036.309,119.615z M1088.155,123.619 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1088.155,123.619z M1140.001,127.624 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1140.001,127.624z M1114.078,125.623 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1114.078,125.623z M1165.923,129.627 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1165.923,129.627z M1217.769,133.632 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1217.769,133.632z M1191.846,131.631 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1191.846,131.631z M1243.69,135.649 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1243.69,135.649z M1295.536,139.653 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.964-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1295.536,139.653z M1269.613,137.653 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1269.613,137.653z M1321.458,141.661 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1321.458,141.661z M1373.304,145.665 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1373.304,145.665z M1347.381,143.664 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1347.381,143.664z M1399.227,147.669 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1399.227,147.669z M1451.072,151.673 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1451.072,151.673z M1425.149,149.673 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1425.149,149.673z M1476.994,153.69 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1476.994,153.69z M1528.84,157.695 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1528.84,157.695z M1502.917,155.694 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1502.917,155.694z M1554.762,159.699 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1554.762,159.699z M1606.608,163.703 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1606.608,163.703z M1580.685,161.702 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1580.685,161.702z M1632.529,165.72 c-0.085,1.099-1.053,1.928-2.152,1.843l-9.963-0.77c-1.099-0.085-1.928-1.053-1.843-2.152l1.078-13.951 c0.085-1.099,1.053-1.928,2.152-1.843l9.963,0.77c1.099,0.085,1.928,1.053,1.843,2.152L1632.529,165.72z"/>',
		);

		$ret['gears'] = array(
		'name' => __( 'Gears', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor2" d="M1601.8,79c-3.6-0.9-7.4-1.6-11.1-2.1l-2.5-27.1l-18.4,0.1l-2.3,27.3c-3.7,0.5-7.3,1.3-11,2.3l-12.8-24.3
	l-17,7.1l8.3,26.2c-3.3,1.9-6.4,4-9.3,6.2l-21.1-17.5l-13,13.1l17.6,20.8c-2.3,3-4.4,6.1-6.3,9.4l-26-8l-3.8,9.3
	c-0.3-0.2-0.5-0.4-0.8-0.6l7-16.1l-17.6-9.6l-9.9,14.7c-5.9-2.4-11.9-4.2-18.1-5.5l0.3-17.9l-19.9-2.2l-3.6,17.8
	c-6.2,0.1-12.5,0.6-18.6,1.8l-6.7-17l-19.2,5.6l3.6,18.1c-5.6,2.4-11.1,5.3-16.4,8.7l-12.8-13.3l-15.6,12.5l10.3,15.4
	c-4.5,4.4-8.5,9.2-12,14.2l-10.5-4.6l4.4-7.8l-25.4-17.7l-29.4,35.2c-5.6-3-11.5-5.5-17.4-7.7l5.7-45.4l-30.3-6.6l-13.6,43.3
	c-6.4-0.6-12.9-0.8-19.3-0.5l-11.9-43.6l-30.5,5.5l4,44.7c-6.2,1.9-12.2,4.3-18.2,7.1l-27.5-35.5l-26.1,16.7L1108,190h498V70.9
	L1601.8,79z"/>
<path class="gambit_sep_decor1" d="M277.9,135.5l-29.8,7.7c-4.9-9.8-10.6-19.2-17.1-28l21.1-22.8l-23.3-25.7l-25.1,18.9
	c-8.1-7.1-16.9-13.5-26.2-19.2l11-29.7L157.3,22l-16.2,27.5c-10-3.4-20.5-6-31.2-7.7l-1.2-32L74,8l-4.4,31.7
	c-10.9,0.6-21.5,2.2-31.9,4.5l-13.3-29L-8.3,26.9l7.9,30.6C-5,59.8-9.6,62.2-14,64.7V159h300.3L277.9,135.5z"/>
<path class="gambit_sep_decor1" d="M1294.3,176c3.6,3.3,7,6.8,10.3,10.5l1.6,0c1.4-6.1,3.3-12,5.7-17.8l-9.8-6.5L1294.3,176z"/>
<path class="gambit_sep_decor1" d="M706.9,182.4l32.7-31.9l-19.6-24l-37.6,25.4c-4.6-4.5-9.6-8.6-14.8-12.4L685.5,98l-27.3-14.7l-24.7,37.5
	c-6-2.3-12.2-4.3-18.7-5.8l0.5-44.9L584.6,67l-8.5,44.1c-6.6,0.2-13.1,0.9-19.4,1.9L540,71.3l-29.7,8.9l9.1,44.3
	c-5.9,2.7-11.5,5.8-17,9.2l-31.7-32.5l-24,19.6l25.6,37.9c-4.3,4.6-8.3,9.6-12,14.8l-42.1-18.1l-14.7,27.3l20.3,13.4h290.3
	C712,191.3,709.5,186.8,706.9,182.4z"/>
<polygon class="gambit_sep_decor2" points="760.6,190.1 731.7,196 762.4,196"/>
<path class="gambit_sep_main" d="M1604,159.3l-13.4-13.4l-36.8,30.8c-12.9-10.2-26.8-19.4-41.4-27.3l14.5-46.2l-49-20.3
	l-22.6,43.2c-15.6-4.5-31.7-7.6-48.3-9.4l-4.4-48.8h-53l-4.4,48.8c-16.6,1.8-32.7,4.9-48.3,9.4L1274.2,83l-49,20.3l14.5,46.2
	c-14.6,7.9-28.5,17-41.4,27.3l-36.8-30.8l-35.7,35.7c-0.8-1.3-1.7-2.7-2.6-4l26.7-28.8l-17.8-19.7l-31.1,23.4
	c-4.2-3.6-8.6-7-13.2-10l13.5-36.4l-24-11.4l-19.6,33.2c-5.3-1.7-10.7-3.1-16.2-4.1l-1.5-38.5l-26.5-1.4l-5.4,38.1
	c-5.6,0.5-11.2,1.3-16.6,2.5l-16.1-35l-25,8.9L960,136c-4.9,2.6-9.6,5.4-14.2,8.6l-28.6-26.5L897.6,136l23.6,31.3
	c-3.5,4.2-6.7,8.6-9.7,13.2l-36.1-13.3l-15.4-9.4l-14.8,19.9c-7.5-3.5-15.3-6.4-23.5-8.6l1.7-24.9l-26.7-4.2l-6.1,24.2
	c-8.5-0.4-16.8-0.1-25,0.9l-7.9-23.5l-7.1,1.7l6.6-17.7l-42.8-20.3l-34.9,59.2c-9.4-3.1-19-5.6-28.9-7.4l-2.6-68.6L600.8,86
	l-9.6,68c-10,0.8-19.9,2.3-29.5,4.4L533,95.9l-44.6,15.9l17.3,66.9c-8.8,4.6-17.2,9.7-25.2,15.4l-50.9-47.2l-32.1,29
	c-0.8-0.9-1.6-1.8-2.4-2.7l16.4-22l-22.8-20.4l-20.2,18.9c-7.8-5.5-16.1-10.3-24.7-14.4l6.9-27.1l-28.9-10.1l-11.6,25.6
	c-9.1-2.1-18.5-3.4-28.1-3.9l-4.1-28l-30.6,1.7l-0.9,28.3c-9.5,1.6-18.7,3.9-27.5,7l-14.4-24.2L176.7,118l9.8,26.1
	c-1.3,0.8-2.7,1.7-4,2.5l-30.1,2.4c-1.8-5.6-3.9-11.1-6.4-16.3l32.8-25l-15-23.8l-37,18.9c-3.7-4.4-7.7-8.6-12-12.5l21-36l-23-16.3
	L85.7,69.9c-5-2.6-10.2-4.9-15.7-6.9l5.7-41.6l-27.4-6.3L35.3,55.1c-5.7-0.5-11.5-0.7-17.1-0.6L7.6,14L-6,16.3V396h1610V159.3z"/>',
		);

		$ret['grass'] = array(
		'name' => __( 'Grass', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M948.291,158.46c-0.181-3.785-0.192-7.576-0.028-11.362 c1.118,0.034,2.067-0.855,2.139-1.994c0.805-12.938,3.659-25.776,8.562-38.014c0.432-1.078-0.069-2.322-1.134-2.793 c0.561-1.34,1.147-2.672,1.757-3.997c-0.173-0.481-0.344-0.964-0.512-1.449c-0.782,1.664-1.526,3.34-2.231,5.029 c-1.085-0.46-2.362,0.094-2.814,1.237c-5.052,12.776-7.966,26.164-8.746,39.644c-0.07,1.206,0.819,2.237,1.95,2.29 c-0.139,3.281-0.136,6.565-0.018,9.847c-3.389-5.049-6.409-10.334-9.025-15.817c1.003-0.494,1.424-1.725,0.953-2.765 c-5.361-11.803-8.864-24.479-10.277-37.586c-0.125-1.154-1.151-2.018-2.312-1.934c-0.133-1.447-0.241-2.898-0.324-4.354 c-0.379-0.343-0.756-0.69-1.132-1.04c0.09,1.836,0.22,3.666,0.39,5.487c-1.174,0.103-2.042,1.191-1.904,2.413 c1.534,13.653,5.242,26.843,10.88,39.112c0.504,1.098,1.773,1.591,2.796,1.107c2.875,6.012,6.236,11.785,10.031,17.274 c0.825,16.167,4.764,32.211,11.829,47.206c0.294-0.138,0.587-0.276,0.881-0.415c-6.755-14.373-10.609-29.714-11.59-45.193 c7.449,10.424,16.518,19.764,27.007,27.607c0.195-0.26,0.389-0.52,0.584-0.78C965.153,179.093,955.843,169.35,948.291,158.46z"/>
<path class="gambit_sep_decor1" d="M436.724,82.648c-1.559,2.066-3.068,4.16-4.528,6.282 c-1.362-0.947-3.281-0.554-4.234,0.89c-10.656,16.138-18.545,33.737-23.518,52.081c-0.445,1.641,0.481,3.318,2.024,3.718 c-6.984,27.422-7.382,56.451-0.684,84.646l1.334-0.316c-6.619-27.976-6.198-56.772,0.754-83.965 c1.53,0.371,3.095-0.579,3.523-2.128c4.852-17.59,12.498-34.449,22.793-49.889c0.907-1.36,0.577-3.219-0.754-4.175 c1.161-1.683,2.353-3.35,3.576-4.998C436.911,84.08,436.816,83.365,436.724,82.648z"/>
<path class="gambit_sep_decor1" d="M1180.518,132.473c1.543-0.317,2.54-1.942,2.181-3.604 c-4.011-18.577-10.938-36.566-20.669-53.244c-0.87-1.493-2.746-1.987-4.137-1.114c-1.338-2.196-2.726-4.367-4.163-6.512 c-0.125,0.711-0.255,1.42-0.388,2.126c1.127,1.71,2.223,3.437,3.286,5.18c-1.361,0.884-1.778,2.723-0.95,4.128 c9.409,15.961,16.132,33.198,20.06,51.016c0.347,1.569,1.846,2.601,3.375,2.312c1.866,9.287,2.97,18.718,3.335,28.196 c-2.969-7.111-6.463-13.989-10.454-20.571c1.158-0.711,1.488-2.32,0.709-3.562c-8.706-13.878-19.602-26.423-32.386-37.082 c-1.143-0.954-2.809-0.804-3.68,0.312c-1.729-1.387-3.491-2.739-5.286-4.055c0.107,0.613,0.211,1.226,0.31,1.837 c1.416,1.055,2.811,2.133,4.185,3.233c-0.844,1.116-0.642,2.729,0.443,3.625c12.312,10.173,22.823,22.168,31.239,35.456 c0.742,1.17,2.26,1.566,3.414,0.883c4.535,7.465,8.418,15.316,11.621,23.457c0.324,17.448-1.917,35.022-6.826,52.136 c0.434,0.129,0.868,0.258,1.302,0.387c4.607-16.007,6.889-32.415,6.947-48.754c4.835,13.304,7.861,27.335,8.846,41.734 c0.389-0.023,0.779-0.046,1.168-0.069c-1.055-15.64-4.488-30.857-10.032-45.186C1183.793,153.891,1182.642,143.09,1180.518,132.473 z"/>
<path class="gambit_sep_decor1" d="M910.208,89.163c0.191-1.336,0.389-2.672,0.597-4.007 c-0.278-0.385-0.555-0.77-0.831-1.156c-0.265,1.671-0.516,3.344-0.755,5.019c-1.089-0.157-2.11,0.626-2.262,1.74 c-1.7,12.474-2.686,25.02-2.956,37.578c-0.024,1.121,0.862,2.052,1.962,2.067c-0.291,18.893,1.046,37.806,4.011,56.526 c0.329-0.052,0.659-0.104,0.988-0.156c-2.956-18.664-4.289-37.52-3.999-56.357c1.086-0.001,1.983-0.881,2.006-1.972 c0.266-12.369,1.237-24.727,2.912-37.014C912.029,90.345,911.281,89.334,910.208,89.163z"/>
<path class="gambit_sep_decor1" d="M1202.618,30.326c0.381-2.673,0.779-5.344,1.193-8.013 c-0.555-0.769-1.109-1.54-1.662-2.313c-0.53,3.343-1.033,6.689-1.51,10.037c-2.177-0.313-4.221,1.252-4.524,3.479 c-3.401,24.947-5.372,50.04-5.913,75.156c-0.049,2.243,1.725,4.103,3.924,4.135c-0.581,37.787,2.093,75.611,8.023,113.051 c0.658-0.104,1.317-0.209,1.975-0.313c-5.912-37.328-8.578-75.04-7.998-112.714c2.172-0.003,3.966-1.762,4.013-3.945 c0.533-24.739,2.474-49.455,5.824-74.027C1206.258,32.691,1204.762,30.669,1202.618,30.326z"/>
<path class="gambit_sep_decor1" d="M1567.368,32.115c1.038-2.493,2.091-4.979,3.16-7.46 c-0.345-0.883-0.689-1.769-1.031-2.655c-1.349,3.104-2.673,6.218-3.973,9.34c-2.03-0.848-4.399,0.156-5.25,2.237 c-9.533,23.303-17.719,47.105-24.526,71.287c-0.608,2.159,0.643,4.404,2.765,4.985c-5.05,18.374-9.299,36.965-12.738,55.719 c-0.093-13.651,0.404-27.296,1.494-40.896c1.558,0.099,2.925-1.079,3.061-2.643c1.53-17.715,4.069-35.348,7.612-52.812 c0.312-1.541-0.666-3.061-2.188-3.406c0.397-1.899,0.807-3.796,1.228-5.691c-0.363-0.577-0.724-1.156-1.084-1.736 c-0.535,2.372-1.051,4.748-1.549,7.128c-1.547-0.326-3.084,0.702-3.406,2.285c-3.596,17.731-6.174,35.633-7.728,53.617 c-0.139,1.606,1.046,3.022,2.622,3.147c-1.291,16.095-1.736,32.253-1.373,48.41c-2.747,16.011-4.907,32.134-6.464,48.341 c0.664,0.064,1.327,0.128,1.991,0.191c1.229-12.796,2.842-25.539,4.817-38.216c0.336,7.576,0.835,15.149,1.536,22.712 c0.477-0.044,0.954-0.088,1.431-0.133c-0.919-9.912-1.516-19.841-1.806-29.772c3.702-22.15,8.528-44.087,14.475-65.722 c2.104,0.541,4.28-0.714,4.872-2.816c6.705-23.819,14.767-47.263,24.157-70.216C1570.302,35.315,1569.359,32.983,1567.368,32.115z" />
<path class="gambit_sep_decor1" d="M138.352,55.2c0.592-2.235,1.198-4.466,1.818-6.694 c-0.395-0.71-0.789-1.421-1.181-2.133c-0.785,2.789-1.549,5.584-2.291,8.384c-1.82-0.485-3.714,0.641-4.196,2.505 c-5.393,20.872-9.585,42.012-12.564,63.315c-0.266,1.902,1.055,3.662,2.922,3.909c-4.283,32.073-5.802,64.505-4.514,96.936 l1.711-0.068c-1.284-32.334,0.23-64.669,4.501-96.647c1.847,0.215,3.549-1.1,3.808-2.952c2.934-20.983,7.063-41.805,12.375-62.364 C141.211,57.576,140.141,55.707,138.352,55.2z"/>
<path class="gambit_sep_decor1" d="M117.924,219.545c-5.912-37.328-8.578-75.04-7.998-112.714 c2.172-0.003,3.966-1.762,4.013-3.945c0.533-24.739,2.474-49.455,5.824-74.027c0.296-2.169-1.201-4.191-3.345-4.533 c0.381-2.673,0.779-5.344,1.193-8.013c-0.555-0.769-1.109-1.54-1.662-2.313c-0.529,3.343-1.033,6.689-1.51,10.037 c-2.177-0.313-4.221,1.252-4.524,3.479c-3.401,24.947-5.372,50.04-5.913,75.156c-0.049,2.243,1.725,4.103,3.924,4.135 c-0.52,33.768,1.569,67.566,6.249,101.093c-6.317-27.428-10.638-55.249-12.926-83.244c1.919-0.189,3.352-1.897,3.206-3.83 c-1.655-21.903-2.063-43.907-1.215-65.905c0.075-1.941-1.421-3.6-3.345-3.718c0.107-2.394,0.229-4.788,0.366-7.182 c-0.557-0.632-1.112-1.265-1.667-1.901c-0.181,2.999-0.338,5.998-0.472,8.998c-1.951-0.09-3.621,1.469-3.698,3.463 c-0.861,22.333-0.446,44.673,1.234,66.909c0.15,1.986,1.876,3.477,3.822,3.316c2.733,33.435,8.346,66.624,16.802,99.193 c0.573-0.149,1.146-0.297,1.718-0.446c-0.334-1.287-0.656-2.576-0.981-3.865C117.32,219.641,117.622,219.593,117.924,219.545z"/>
<path class="gambit_sep_main" d="M1604,130.551c-1.608,5.657-2.757,11.195-3.568,16.251 c-3.227-0.384-6.577-0.432-10.035-0.08l-7.999-23.16l2.092,7.594c-0.447,0.701-3.457,5.513-6.757,12.967 c-3.21-3.778-7.24-6.555-12.3-7.668c4.774,3.113,8.378,6.698,11.082,10.517c-0.445,1.078-0.89,2.199-1.33,3.362 c-4.986-4.24-10.376-7.691-15.636-8.917c5.538,2.036,10.606,5.855,15.086,10.396c-0.961,2.642-1.882,5.475-2.711,8.46 c-1.018,0.284-2.176,0.623-3.43,1.013c-1.051-0.361-2.124-0.66-3.212-0.905c-1.726-6.815-4.157-14.63-7.649-22.638 c6.974-9.798,12.602-15.749,12.602-15.749s-5.735,5.701-13.366,14.017c-3.285-7.233-7.462-14.568-12.783-21.418 c4.181,6.896,7.35,15.652,9.748,24.757c-2.517,2.793-5.166,5.8-7.841,8.934l0.463-5.089l-1.115,5.853 c-1.876,2.209-3.754,4.474-5.6,6.765c-1.596-1.651-3.307-3.282-5.12-4.88l-0.737-7.737v7.093c-3.206-2.763-6.74-5.412-10.652-7.839 c3.106,1.997,5.928,4.363,8.512,6.965c-2.516,0.793-4.889,2.274-7.103,4.26l-1.233-4.194l0.771,4.628 c-1.176,1.101-2.305,2.336-3.389,3.673c-2.625-7.899-7.744-16.903-17.181-26.845c9.974,11.349,12.284,24.22,12.012,34.461 c-0.387,0.669-0.766,1.344-1.136,2.026l-4.037-5.248c-0.054-7.506-1.173-15.93-4.196-24.831c2.904,14.839-0.86,28.266-4.897,37.437 c-2.052-1.468-4.349-2.962-6.851-4.37c-0.119-1.533-0.278-3.15-0.482-4.839c1.841-1.592,3.699-3.052,5.548-4.326 c-0.468-0.145-2.704,0.681-5.818,2.252c-1.243-8.917-3.8-19.637-8.857-30.899c3.519,10.849,2.978,23.722,1.532,33.974 c-2.704-1.048-5.551-1.916-8.512-2.498c-0.9-2.664-1.973-5.489-3.251-8.423c2.493-5.233,4.563-8.748,4.563-8.748 s-2.328,2.42-5.501,6.654c-1.523-3.297-3.31-6.706-5.398-10.153c1.735,0.015,3.49,0.266,5.265,0.864 c-1.886-0.716-3.753-1.167-5.599-1.418c-2.587-4.209-5.622-8.463-9.202-12.624c2.417,3.783,4.342,8.017,5.887,12.417 c-3.373,0.004-6.652,0.688-9.801,1.879c-1.552-5.886-3.712-11.914-6.693-17.766c2.06,5.544,3.268,12.127,3.907,18.959 c-2.16,1.036-4.248,2.285-6.251,3.691c-3.854-4.153-8.162-8.203-12.929-11.884c0.566-1.129,1.152-2.222,1.761-3.264 c-2.976,4.266-5.587,8.605-7.841,12.767c-0.148-0.138-0.287-0.28-0.436-0.418c0.147,0.14,0.282,0.292,0.428,0.434 c-7.626,14.084-11.196,26.103-11.196,26.103l-1.411-49.149l-1.516,43.173l-2.469,3.566c-1.532-4.33-3.87-10.303-6.911-16.275 l0.996-4.981l-1.484,4.028c-4.113-7.876-9.441-15.586-15.76-19.312c6.74,5.19,11.449,13.617,14.71,22.164l-3.208,8.707 c-1.475-2.039-3.129-4.015-4.961-5.829c1.736-2.734,3.566-5.287,5.467-7.523c-0.577-0.022-3.164,1.888-6.47,5.011l1.23-13.532 l-2.638,13.847c-2.69-2.235-5.723-4.063-9.112-5.217l-0.822-8.629v8.37c-2.262-0.685-4.671-1.082-7.249-1.08 c0.888-4.426,1.687-7.328,1.687-7.328s-1.903,3.458-4.086,9.142l-0.829-2.819l0.58,3.479c-1.363,3.62-2.808,8.069-3.954,13.07 c-2.007-0.056-4.054,0.154-6.127,0.643l-1.662-2.161c-1.139-3.052-2.463-6.258-4.006-9.534c0.449-0.045,0.889-0.108,1.351-0.128 c-0.482-0.014-0.935,0.01-1.407,0.01c-0.224-0.474-0.446-0.948-0.679-1.425c5.601-6.254,13.556-12.222,24.853-16.979 c-8.636,0.367-18.179,5.946-26.909,12.99c-3.263-6.027-7.312-12.097-12.338-17.666c3.893,5.466,7.073,12.51,9.644,19.907 c-1.648,1.41-3.258,2.857-4.82,4.321c-4.837,1.159-9.006,3.105-12.57,5.584c-1.562-1.102-3.203-2.166-4.923-3.181 c0.214-2.093,0.402-4.328,0.552-6.718c0.674-0.835,1.349-1.67,2.056-2.51c-0.673,0.459-1.336,0.937-1.991,1.43 c0.465-8.223,0.467-18.139-0.459-29.697c3.905-5.432,8.259-10.77,13.131-15.86c-4.723,3.759-9.191,8.294-13.361,13.204 c-0.348-3.839-0.792-7.841-1.36-12.026c0.206,4.681,0.02,9.457-0.467,14.225c-9.204,11.317-16.813,24.287-22.152,34.527 c-1.704-3.309-3.767-6.286-6.265-8.698c0.669-10.519,1.445-24.911,2.276-44.537c-0.433,11.02-3.546,26.299-7.203,40.912 c-0.428-0.233-0.861-0.459-1.308-0.663c-2.365-2.985-5.039-5.908-8.086-8.657c1.647,2.196,3.147,4.694,4.518,7.407 c-0.226-0.058-0.438-0.139-0.669-0.189c0.305,0.199,0.578,0.412,0.874,0.615c1.147,2.311,2.203,4.771,3.171,7.344 c-1.756,6.69-3.566,13.078-5.219,18.686c-0.977-0.925-1.998-1.761-3.07-2.478c0.157-8.285-0.406-19.049-2.456-32.585 c0.183,9.536-0.76,19.162-2.211,28.06c-1.212,0.272-2.661,0.653-4.277,1.132c-0.052-10.91,1.181-23.908,4.895-38.601 c0.609,3.274,1.139,6.411,1.593,9.409c-0.078-4.053-0.359-8.088-0.893-12.044c0.209-0.776,0.405-1.544,0.628-2.329 c-0.266,0.435-0.514,0.884-0.77,1.328c-1.034-7.064-2.886-13.858-5.843-20.016c2.019,7.809,3.631,15.018,4.915,21.675 c-7.164,13.377-9.772,29.916-10.63,42.617c-1.293,0.477-2.631,1.002-3.994,1.568c-1.139-7.043-2.199-15.817-2.66-25.727 c0.344-0.403,0.538-0.624,0.538-0.624s-0.195,0.138-0.55,0.402c-0.934-20.508,0.723-45.88,9.649-71.057 c-12.043,23.377-14.9,56.893-15.501,75.836c-1.138,0.999-2.383,2.132-3.709,3.399c-3.633-10.352-10.732-29.504-24.395-63.661 c7.349,18.212,12.73,50.58,15.782,72.781c-0.862,1.014-1.726,2.066-2.587,3.156c-1.587-4.052-3.622-8.68-6.262-13.912 c0.537-11.354-0.194-24.319-3.918-37.227c1.446,8.654,0.965,18.908-0.436,29.071c-2.433-4.343-5.233-9.011-8.458-14.008 c2.995,6.329,5.511,12.918,7.622,19.456c-1.201,7.13-2.77,14.057-4.348,20.183c-2.786,0.825-5.389,1.877-7.793,3.092 c-0.553-3.457-1.344-7.231-2.469-11.202c3.583-3.143,7.725-5.883,12.504-7.795c-4.572,1.345-8.896,3.735-12.854,6.616 c-2.574-8.659-6.736-18.163-13.457-27.264c6.21,8.7,9.185,19.329,10.406,29.634c-6.399,5.294-11.624,11.607-15.064,16.276 c-0.918-0.956-1.879-1.91-2.93-2.858c0.851,1.193,1.625,2.418,2.344,3.659c-0.659,0.912-1.245,1.749-1.746,2.487 c-0.627-0.146-1.254-0.272-1.878-0.369l3.236-38.829l-7.003,38.519c-0.088-0.001-0.176,0.001-0.264,0.001 c-0.787-2.351-4.411-12.398-12.232-23.747c3.338-2.074,7.16-3.405,11.548-3.598c-4.84-0.144-9.161,0.419-13.035,1.498 c-1.536-2.114-3.216-4.257-5.05-6.393c1.472,2.078,2.772,4.357,3.915,6.736c-5.446,1.701-9.961,4.452-13.693,7.781 c-3.969-2.783-8.408-5.311-13.248-7.224c3.026-2.719,5.06-4.229,5.06-4.229s-2.641,1.321-6.493,3.676 c-2.547-0.925-5.199-1.673-7.949-2.189c-0.112-0.506-0.233-1.023-0.352-1.537c0.282-0.199,0.564-0.407,0.846-0.601 c-0.172-0.053-0.503-0.018-0.964,0.093c-0.088-0.377-0.172-0.749-0.263-1.131c0.056,0.386,0.119,0.769,0.167,1.158 c-0.706,0.179-1.705,0.532-2.94,1.045c-2.18-3.853-4.899-7.167-8.28-9.552c5.079-15.072,10.655-25.221,10.655-25.221 s-6.079,10.303-12.959,23.798c-1.647-0.876-3.417-1.57-5.354-1.995c1.683,1.097,3.202,2.26,4.608,3.464 c-3.217,6.366-6.559,13.36-9.513,20.287c-2.842-1.74-6-2.669-9.494-2.314c3.308,0.945,6.044,2.402,8.302,4.226 c-3.417,2.44-6.834,5.13-10.031,8.024c-1.823-4.536-4.601-9.408-8.916-14.409c5.891-16.04,13.793-29.462,13.793-29.462 s-9.189,9.554-18.195,24.852c-3.841-3.659-8.586-7.35-14.45-10.995c5.73,3.874,9.993,8.459,13.145,13.256 c-4.459,7.88-8.755,17.132-11.747,27.301c-0.052-0.014-0.106-0.027-0.159-0.041c0.159-8.778,0.31-23.902-2.429-41.251 c0.405,0.245,0.796,0.49,1.19,0.735c-0.393-0.266-0.792-0.528-1.199-0.787c-2.206-13.948-6.293-29.314-13.753-43.96 c9.002,24.231,7.374,61.42,5.309,83.372c-2.011-0.157-4.06-0.199-6.13-0.105c-0.209-0.682-0.429-1.377-0.659-2.085l3.125-6.697 l-3.611,5.216c-1.789-5.281-4.189-11.204-7.367-17.378l0.501-2.505l-0.748,2.031c-5.407-10.395-13.041-21.473-23.829-31.412 c10.782,10.261,17.366,24.262,21.396,38.016l-5.242,14.228c-1.506-0.398-3.058-0.626-4.64-0.697l2.587-28.452l-5.424,28.476 c-1.46,0.085-2.926,0.273-4.384,0.548l-1.233-12.949c0.118-0.079,0.237-0.158,0.355-0.236c-0.118,0.064-0.242,0.123-0.359,0.188 l-1.526-16.027v16.907c-2.184,1.262-4.261,2.58-6.202,3.912l-3.778-12.844l2.326-5.003l-2.467,4.526l-0.356-1.211l0.238,1.428 l-9.068,16.637l-4.715-6.13c-0.009-0.7-0.03-1.403-0.06-2.108c2.633-6.642,5.942-12.663,10.094-16.801 c-3.967,3.413-7.507,7.214-10.636,11.093c-0.558-3.613-1.554-6.973-3.221-9.551c1.518,3.136,2.252,6.749,2.475,10.483 c-2.175,2.762-4.141,5.551-5.897,8.258c-1.334-4.477-3.748-8.704-7.931-11.5c1.309-5.231,3.121-10.361,5.633-14.77 c-6.171,8.041-10.217,16.503-12.863,23.941c-0.815-0.745-1.695-1.415-2.632-2.007c2.28-3.199,4.795-6.457,7.567-9.751 c-3.556,2.425-6.85,5.341-9.881,8.52c-0.976-0.423-2.007-0.765-3.104-1.001c1.078,0.293,2.074,0.67,2.999,1.113 c-1.174,1.236-2.308,2.511-3.401,3.814c-0.289-4.028-0.354-8.299-0.017-12.516c1.212-0.248,2.457-0.434,3.767-0.492 c-1.279-0.038-2.52-0.025-3.729,0.031c0.289-3.312,0.826-6.582,1.716-9.656c-1.336,3.336-2.433,6.613-3.343,9.791 c-1.345,0.111-2.648,0.274-3.905,0.495c6.74-14.541,16.249-30.301,29.579-44.227c-14.625,11.641-26.865,30.622-35.021,45.585 c-1.422,0.468-2.793,0.992-4.088,1.596c-0.014-2.982,0.207-6.075,0.761-9.249c-1.041,3.437-1.776,6.786-2.276,10.018 c-1.247,0.655-2.452,1.352-3.58,2.118c0.784-10.771,1.782-27.559,2.875-53.373c-0.575,14.632-5.871,36.769-10.897,54.886 c-1.771-1.763-3.673-3.066-5.7-3.672c2.171,1.217,3.943,2.837,5.406,4.728c-0.784,2.808-1.557,5.507-2.305,8.062 c-0.815,1.155-1.573,2.327-2.272,3.51c-0.472,0.2-0.946,0.405-1.423,0.617c0.375-6.229,0.338-14.268-0.596-24.28 c7.428-10.813,13.753-17.5,13.753-17.5s-6.12,6.085-14.025,14.767c-0.357-3.362-0.814-6.934-1.388-10.726 c0.081,4.228-0.059,8.473-0.368,12.666c-3.021,3.355-6.238,7.029-9.445,10.855c-3.551-10.239-9.551-19.109-19.666-21.332 c4.032,2.629,7.213,5.599,9.741,8.758c-5.96,1.843-11.493,5.428-16.323,9.556c-2.807-4.995-6.715-10.342-12.095-16.01 c5.11,5.814,8.126,12.047,9.767,18.088c-0.445,0.414-0.883,0.83-1.314,1.25c-1.338-0.258-2.724-0.353-4.175-0.206 c1.139,0.325,2.187,0.732,3.194,1.173c-6.275,6.314-10.861,12.888-12.917,16.041c-0.335-0.167-0.67-0.327-1.007-0.475l3.258-39.102 c1.119,1.089,2.181,2.166,3.193,3.233c-0.982-1.117-2.044-2.217-3.188-3.299l0.086-1.033l-0.173,0.953 c-0.545-0.513-1.085-1.028-1.669-1.532c0.57,0.533,1.114,1.062,1.658,1.59l-6.906,37.98c-0.009-0.002-0.018-0.004-0.026-0.006 c-0.3-0.954-4.903-15.193-16.557-29.845c2.518-2.842,5.568-5.267,9.259-7.113c-3.637,0.97-7.047,3.074-10.213,5.932 c-0.46-0.56-0.93-1.12-1.411-1.68c0.425,0.6,0.84,1.212,1.236,1.844c-3.826,3.498-7.291,8.093-10.367,13.121 c-2.498-1.79-5.197-3.479-8.062-4.989c-0.31-9.133-1.846-19.207-5.444-29.802c1.905,9.736,1.614,19.005,0.194,27.351 c-5.643-2.304-11.842-3.758-18.494-3.762c-1.964-9.188-5.019-19.324-9.731-29.819c3.084,9.51,3.785,20.203,3.351,30.269 c-0.394,0.055-0.781,0.087-1.178,0.153c0.396-0.055,0.784-0.073,1.176-0.113c-0.24,5.518-0.819,10.839-1.542,15.675 c-2.914,0.349-5.884,0.999-8.893,1.999c-0.901-3.188-2.007-6.645-3.351-10.292c2.316-0.904,4.822-1.478,7.555-1.598 c-2.839-0.084-5.484,0.093-7.983,0.453c-4.597-12.144-11.876-26.273-23.396-39.66c7.884,12.34,11.842,28.298,13.806,42.301 c-4.574,1.936-8.41,4.644-11.62,7.779c-0.305-0.475-0.613-0.951-0.929-1.432l1.518-7.591l-2.34,6.35 c-0.052-0.078-0.102-0.155-0.155-0.233c1.705-4.878,3.682-9.769,5.996-14.616c-2.634,4.017-4.957,8.454-7.022,13.102 c-2.145-3.144-4.493-6.395-7.066-9.687l0.109-1.202l-0.205,1.078c-7.134-9.112-15.91-18.49-26.354-26.505 c9.74,8.657,16.845,22.579,21.974,37.061c-2.328-0.916-4.675-1.407-7.024-1.529l-0.962-10.106v7.911 c-3.663-8.672-9.37-15.804-18.285-17.764c8.594,5.604,13.417,12.726,15.948,20.023c-2.207,0.193-4.407,0.677-6.584,1.409 l-1.557-5.292l0.919,5.516c-0.899,0.322-1.794,0.685-2.683,1.084c-0.485-1.725-0.984-3.495-1.498-5.311 c0.48,1.676,0.929,3.477,1.351,5.377c-2.37,1.076-4.701,2.41-6.972,3.933c-1.15-1.099-2.362-2.076-3.644-2.88 c-0.013-0.106-0.026-0.214-0.039-0.321c2.534-1.211,5.26-1.685,8.161-1.023c-2.911-0.783-5.684-0.763-8.308-0.19 c-0.685-5.302-1.74-11.242-3.308-17.786c0.836,5.763,0.782,11.843,0.228,17.718c-2.001-0.726-4.134-1.052-6.414-0.82 c2.004,0.572,3.774,1.352,5.38,2.268c-2.695,1.245-5.19,3.048-7.456,5.135c-1.501-2.013-3.101-3.926-4.817-5.711 c1.414,2.201,2.748,4.34,4.046,6.45c-2.446,2.376-4.61,5.051-6.45,7.67c-1.363-1.961-2.933-3.945-4.723-5.869 c0.948-4.568,2.245-9.248,4.009-13.105c-2.2,3.944-3.999,7.927-5.447,11.617c-1.321-1.307-2.76-2.571-4.31-3.773 c0.047-0.189,0.102-0.377,0.152-0.565c1.558-0.822,3.108-1.581,4.636-2.25c-0.364-0.194-1.881-0.016-4.152,0.507 c3.16-10.292,10.151-19.612,24.257-23.484c0.377,1.431,0.731,2.837,1.061,4.214c-0.211-1.453-0.474-2.886-0.805-4.289 c0.292-0.078,0.559-0.176,0.857-0.25c-0.315-0.028-0.618-0.016-0.929-0.032c-0.521-2.145-1.179-4.225-2.024-6.197 c0.633,2.117,1.207,4.174,1.741,6.187c-12.609-0.508-22.311,8.396-29.229,18.592l-0.777-5.991l0.426,6.518 c-1.721,2.581-3.275,5.23-4.644,7.822c-1.686,0.621-3.445,1.318-5.24,2.089c-2.64-3.224-5.593-5.97-8.735-7.42 c3.044,1.89,5.655,4.651,7.881,7.795c-2.171,0.956-4.377,2.016-6.55,3.182c-1.233-5.851-2.035-13.036-1.242-20.627 c4.286-5.879,7.726-9.785,7.726-9.785s-2.921,2.062-7.174,5.865c2.276-12.758,9.486-26.183,26.969-36.03 c-21.017,3.991-30.307,24.343-34.371,43.238c-3.301,3.495-6.808,7.622-10.128,12.312c-1.108-2.295-2.38-4.651-3.837-7.01 c0.795-6.531,1.306-14.015,1.064-21.973c1.185-0.563,2.399-1.116,3.667-1.649c-1.218,0.052-2.458,0.234-3.707,0.482 c-0.325-8.199-1.479-16.871-3.973-25.517c1.33,7.961,1.029,17.277-0.118,26.63c-3.703,1.273-7.472,3.218-11.192,5.617 c-4.187-3.388-9.047-6.371-14.689-8.662c-1.137-1.821-2.361-3.637-3.69-5.436c1.205,1.688,2.283,3.45,3.255,5.266 c-5.046-2.003-10.706-3.458-17.059-4.16c-0.291-7.356-0.961-15.501-2.175-24.444c0.349,7.935-0.43,16.156-1.862,24.112 c-2.279-0.132-4.633-0.18-7.081-0.118c2.429,0.092,4.736,0.395,6.943,0.857c-1.466,7.916-3.544,15.534-5.73,22.32 c-4.172,4.288-7.775,8.91-10.825,13.392c-0.973,0.187-1.949,0.409-2.926,0.666c-1.313-3.886-3.127-8.386-5.604-13.088 c1.217-4.146,2.778-8.151,4.794-11.688c-2.34,3.05-4.366,6.159-6.134,9.251c-3.589-6.301-8.382-12.822-14.779-18.595 c4.908,6.544,8.533,15.732,11.214,25.508c-2.801,6.082-4.642,11.845-5.849,16.652c-1.444,1.078-2.88,2.258-4.308,3.551 c-1.583-9.094-2.998-23.044,0.278-34.372c-4.521,11.289-6.381,21.934-7.078,30.128l-0.91,1.314c-2.009-1.041-4.16-1.669-6.39-1.954 c-0.757-2.629-1.404-5.501-1.837-8.562l2.081-10.407l-2.482,6.736c-0.323-4.179-0.211-8.638,0.597-13.265 c-2.181,7.2-3.036,14.025-3.134,20.152l-1.981,5.378c-0.297,0.036-0.592,0.079-0.889,0.122c-1.265-2.65-2.675-5.211-4.216-7.488 l0.408-4.488c0.465-0.334,0.93-0.651,1.394-0.955c-0.466,0.254-0.921,0.515-1.378,0.775l1.205-13.254l-2.687,14.108 c-0.422,0.251-0.833,0.505-1.246,0.76c-2.144-2.507-4.5-4.37-7.053-5.134c2.54,1.424,4.538,3.395,6.122,5.717 c-2.079,1.317-4.046,2.664-5.856,3.995l-1.338-14.047l2.691-5.789l-2.76,5.065l-0.445-4.676v5.493l-6.956,12.763l-3.521-11.97 l2.352,14.113l-5.898,10.821l-0.348-0.452c0.869-5.532,3.243-24.216-2.615-33.274c4.305,8.895,2.322,21.613,0.16,30.083 l-2.152-2.797c-0.44-7.34-2.693-16.204-10.282-20.622c1.249-1.958,2.695-3.952,4.409-5.979c-4.797,2.701-8.65,8.477-11.654,14.936 c-1.514-1.219-3.218-2.204-5.13-2.873c1.667-1.624,3.596-3.036,5.844-4.16c-2.457,0.655-4.773,2.007-6.95,3.82 c-0.292-0.08-0.578-0.169-0.878-0.234c0.29,0.079,0.558,0.179,0.837,0.269c-3.303,2.762-6.273,6.611-8.873,10.875 c-0.569-1.256-1.188-2.563-1.855-3.916c1.248-0.458,2.543-0.882,3.941-1.227c-1.555-0.136-3.058-0.1-4.516,0.071 c-1.325-2.625-2.844-5.422-4.574-8.37c-0.663-4.224-1.696-8.624-3.234-13.152c0.632,3.232,0.94,6.394,1.006,9.463 c-1.471-2.364-3.075-4.814-4.826-7.344c1.896,3.355,3.483,6.978,4.802,10.696c-0.147,4.018-0.699,7.841-1.499,11.402 c-4.27,2.306-7.985,5.816-11.162,9.799c-0.543-7.892-2.105-18.138-5.961-29.343c2.843-2.683,6.234-5.215,10.252-7.531 c1.249,1.689,2.443,3.352,3.568,4.978c-1.015-1.795-2.113-3.516-3.316-5.125c0.102-0.058,0.198-0.118,0.3-0.176 c-0.125,0.024-0.245,0.055-0.369,0.08c-1.004-1.335-2.073-2.599-3.218-3.768c1.009,1.297,1.968,2.572,2.904,3.836 c-4.252,0.902-7.952,2.57-11.161,4.819c-0.807-2.152-1.689-4.329-2.678-6.531c0.756,2.33,1.315,4.757,1.727,7.228 c-2.794,2.121-5.203,4.689-7.279,7.558c-1.754,0.855-4.086,2.155-6.733,3.831c-0.342-0.695-0.694-1.393-1.06-2.096 c0.336-8.993,1.411-18.343,3.565-27.794c-2.784,7.418-4.514,15.75-5.542,24.184c-2.904-5.067-6.443-10.244-10.781-15.285 c4.53,7.09,7.353,15.749,9.113,24.155c-3.58,2.545-7.374,5.575-10.858,8.93c-2.454-3.489-5.246-7.123-8.372-10.736 c3.812-11.994,8.931-21.905,8.931-21.905s-6.1,7.091-12.122,18.352c-1.716-1.833-3.524-3.641-5.418-5.408 c-0.691-1.278-1.386-2.562-2.108-3.893c0.629,1.15,1.255,2.393,1.879,3.676c-2.258-2.094-4.637-4.127-7.148-6.053 c4.35,3.867,8.001,9.124,11.074,15.026c-1.12,2.265-2.214,4.667-3.246,7.189c-1.879-1.248-3.889-2.401-6.042-3.438 c-0.755-6.229-1.962-13.264-3.937-20.601c4.115-2.881,8.937-5.577,14.609-7.965c-4.95,0.211-10.199,2.149-15.422,5.076 c-2.308-7.839-5.528-15.93-10.03-23.674c3.228,7.402,5.204,16.516,6.366,25.872c-4.804,3.109-9.52,6.938-13.891,10.933 c-1.429,0.283-2.791,0.646-4.108,1.06c-3.553-4.497-7.763-8.933-12.748-13.038c4.514,3.841,8.206,8.503,11.233,13.545 c-5.768,2.086-10.438,5.376-14.202,9.244c1.851-12.256,3.137-32.131-0.546-59.242c1.172,26.617-10.543,56.505-15.808,68.461 c-0.174,0.104-0.355,0.204-0.526,0.31c-0.534-3.294-1.244-6.679-2.173-10.004c2.55-2.521,5.502-4.78,8.926-6.528 c-3.301,1.31-6.372,3.295-9.181,5.621c-3.045-10.393-8.35-19.943-17.522-23.533c-2.071-2.484-4.366-4.912-6.922-7.218 c1.412,1.883,2.708,4.001,3.917,6.272c-0.052-0.012-0.1-0.032-0.153-0.043c0.073,0.047,0.136,0.099,0.209,0.147 c2.914,5.503,5.263,11.98,7.144,18.77c-1.466,0.412-3.123,0.902-4.93,1.474l-0.068-7.932l-0.724,8.186 c-2.292,0.738-4.789,1.599-7.414,2.593c-2.611-1.407-5.479-2.12-8.616-1.802c2.347,0.671,4.394,1.609,6.2,2.743 c-1.548,0.618-3.123,1.281-4.713,1.987c-1.143-1.365-2.371-2.746-3.687-4.125l0.036-0.182l-0.058,0.158 c-0.737-0.773-1.501-1.544-2.294-2.312c0.746,0.872,1.458,1.793,2.13,2.757l-2.491,6.762c-2.134,1.111-4.248,2.301-6.298,3.58 c-0.934-0.544-1.903-1.064-2.889-1.569l1.424-15.663l-2.848,14.953c-1.347-0.644-2.734-1.245-4.164-1.785 c15.266-35.057,39.53-60.7,39.53-60.7s-25.103,24.954-44.818,50.384l-0.272-2.851v3.203c-1.881,2.433-3.711,4.868-5.464,7.286 c-1.264-0.137-2.545-0.22-3.845-0.234l-1.168-3.97l0.663,3.975c-2.611,0.006-5.289,0.281-8.02,0.872 c-0.024-0.168-0.044-0.333-0.07-0.502c1.049-1.603,2.143-3.204,3.277-4.798c2.113,0.052,4.392,0.237,6.868,0.584 c-1.697-1.28-3.418-2.247-5.152-2.948c8.742-11.809,19.543-22.936,30.136-30.235c-1.944-0.602-23.659,9.642-38.581,24.254 c-1.708-4.567-4.059-9.399-7.226-14.477c5.947-17.04,14.618-31.769,14.618-31.769s-9.541,9.911-18.707,25.72 c-2.967-4.07-6.483-8.285-10.61-12.634c4.107,4.674,7.237,9.539,9.584,14.44c-4.457,7.936-8.738,17.236-11.683,27.449 c0.093-5.03,0.206-12.331-0.257-21.027c0.75-0.235,1.497-0.472,2.297-0.67c-0.792-0.069-1.57-0.093-2.337-0.081 c-0.435-7.673-1.33-16.398-3.081-25.6c1.937,1.853,3.763,3.683,5.478,5.49c-1.661-1.89-3.495-3.744-5.49-5.559 c-2.366-12.415-6.305-25.688-12.789-38.417c6.953,18.716,7.566,45.162,6.531,66.35c-3.905,1.864-7.373,4.732-10.402,8.105 c-2.749-7.088-6.542-14.988-11.743-22.938c3.589-4.352,8.369-8.433,14.674-11.984c-6.875,1.305-12.319,4.607-16.633,9.089 c-4.333-6.208-9.546-12.391-15.835-18.185c5.978,5.689,10.653,12.536,14.334,19.846c-15.356,18.041-14.908,51.741-14.739,56.984 l-0.063,0.092c-0.193-1.193-0.729-4.085-1.874-7.915c-0.247-5.896-1.138-13.658-3.596-22.018c0.839,4.307,0.86,9,0.47,13.473 c-6.749-15.487-21.94-35.794-55.125-34.943c11.391,0.433,19.95,5.792,26.337,12.914c-3.523-2.348-7.513-4.249-12.052-5.45 c5.597,1.638,10.031,4.844,13.552,8.834c-0.624,1.901-1.256,3.749-1.897,5.524c0.812-1.735,1.524-3.493,2.113-5.268 c3.573,4.127,6.185,9.057,8.09,13.967l-3.075,8.345c-1.787-2.498-3.877-5.074-6.308-7.531l1.215-13.365l-2.339,12.277 c-0.7-0.668-1.419-1.326-2.17-1.967c0.833-2.056,1.659-4.204,2.474-6.458c-0.935,1.997-1.997,3.963-3.164,5.885 c-2.099-1.727-4.397-3.317-6.893-4.7l-0.48-5.037v4.771c-2.015-1.083-4.163-2.017-6.441-2.773c0.798-1.878,1.626-3.754,2.518-5.623 c-1.132,1.726-2.205,3.533-3.228,5.396c-4.715-1.465-9.976-2.153-15.846-1.646c5.332-0.413,10.245,1.156,14.678,3.861 c-0.609,1.183-1.203,2.383-1.773,3.604l-0.384-1.305l0.26,1.562c-0.344,0.742-0.674,1.495-1.003,2.249 c-2.127,0.918-4.179,2.066-6.139,3.37c-1.323,0.035-2.655,0.134-3.995,0.303c-0.471-2.378-1.128-4.808-2.033-7.249 c0.377,2.314,0.462,4.845,0.325,7.502c-4.771,0.815-9.613,2.557-14.4,5.519l1.671-20.051l-3.915,21.531 c-0.096,0.067-0.192,0.129-0.287,0.197c-1.285-4.63-2.688-9.638-4.221-15.054c1.291,4.51,2.362,9.908,3.253,15.774 c-1.463,1.102-2.919,2.322-4.362,3.679c-2.602-5.511-6.881-13.124-13.317-20.616c8.514,12.024,10.391,31.864,10.391,31.864 s-3.749-5.701-10.344-12.009c-1.363-6.638-2.453-14.326-2.906-23.015c0.997,1.047,1.951,2.102,2.86,3.161 c-0.887-1.252-1.842-2.424-2.879-3.476c-0.131-2.603-0.199-5.303-0.205-8.08c3.423-3.088,6.903-5.88,10.36-8.262 c-0.786-0.244-4.819,1.297-10.317,4.172c0.168-8.019,0.888-16.693,2.393-26.006c-4.099,8.875-6.259,18.916-7.273,28.698 c-3.045,1.768-6.328,3.835-9.643,6.147C51.328,117.391,48.467,85.161,56.023,52c-6.46,17.214-8.45,38.337-8.597,56.974 c-2.578,2.98-7.012,8.431-11.816,15.747c-6.077-11.79-14.546-27.836-26.342-49.574c7.757,14.192,15.329,36.985,21.314,57.77 c-1.887,3.301-3.748,6.849-5.502,10.61c-2.226-3.364-4.728-6.943-7.538-10.732c-1.502-17.002-5.451-37.79-15.387-57.298 c4.888,13.155,6.643,30.127,6.893,46.412c-0.375-0.459-0.746-0.917-1.129-1.381c0.383,0.613,0.763,1.228,1.138,1.847 c0.114,8.308-0.16,16.422-0.604,23.745c-3.006,2.98-5.732,6.144-8.179,9.33c-0.667-1.983-1.424-4.061-2.273-6.207v68.192h1606 v-53.739c-0.007-0.002-0.014-0.004-0.021-0.005c-0.289-3.146-0.557-6.869-0.703-10.849c0.238-0.331,0.484-0.64,0.725-0.964v-4.495 c-0.278-0.061-0.556-0.124-0.838-0.174c-0.011-4.8,0.22-9.745,0.838-14.367V130.551z M5.319,176.842c0,0-0.619-6.568-3.473-16.374 c1.815-4.78,3.97-9.279,6.523-13.051C7.279,164.42,5.319,176.842,5.319,176.842z M18.334,161.36 c0.097-5.252,0.216-12.983-0.323-22.191c1.608,3.415,3.108,6.836,4.502,10.223C20.952,153.212,19.532,157.209,18.334,161.36z M30.002,170.112c-0.006-0.044-0.008-0.091-0.014-0.135c0.01,0.031,0.021,0.063,0.031,0.095 C30.014,170.085,30.007,170.098,30.002,170.112z M33.473,143.23c0.782,2.864,1.527,5.649,2.228,8.322 c-1.485,0.075-2.989,0.213-4.521,0.465C31.8,149.095,32.582,146.149,33.473,143.23z M33.153,192.517 c0.101-0.406,0.201-0.813,0.313-1.226c0.74-0.327,1.493-0.613,2.262-0.844c0.174,0.72,0.337,1.404,0.492,2.07H33.153z M33.496,191.181c0.379-1.38,0.831-2.799,1.355-4.254c0.282,1.103,0.545,2.161,0.791,3.168 C34.935,190.434,34.22,190.795,33.496,191.181z M35.23,160.761c-1.216-2.385-2.624-4.972-4.251-7.763 c0.065-0.326,0.131-0.652,0.201-0.979c1.558-0.214,3.086-0.288,4.581-0.241c0.566,2.159,1.103,4.24,1.611,6.234 C36.621,158.917,35.909,159.834,35.23,160.761z M40.93,173.832c0.077-0.138,0.149-0.275,0.227-0.414 c0.42,1.779,0.767,3.272,1.035,4.439C41.905,176.801,41.497,175.457,40.93,173.832z M47.298,148.132 c-1.842-3.894-4.687-9.718-9.027-18.226c3.343-8.142,6.893-15.129,9.148-19.324c-0.034,14.727,1.052,27.751,1.932,35.855 C48.66,146.993,47.976,147.558,47.298,148.132z M57.9,149.714c2.365-2.757,4.817-5.425,7.327-7.957 c-0.326,5.847-0.295,11.48-0.069,16.57c-0.932-1.129-1.898-2.224-2.905-3.271c1.027,1.597,2.014,3.164,2.978,4.714 c0.023,0.44,0.045,0.883,0.071,1.314c-1.707-1.207-3.515-2.359-5.415-3.426C59.222,155.169,58.554,152.516,57.9,149.714z M65.463,175.648c-0.91-2.536-2.036-5.859-3.256-9.865c1.391,1.471,2.677,2.957,3.855,4.415c0.273,2.528,0.559,4.691,0.814,6.438 C66.421,176.311,65.952,175.982,65.463,175.648z M90.284,176.944c0,0-0.765-2.495-2.512-6.411l3.316,1.99L90.284,176.944z M91.205,171.883l-3.644-1.822c-0.106-0.233-0.215-0.471-0.328-0.714c1.43-0.949,2.891-1.747,4.378-2.402 c0.073,0.506,0.144,1.015,0.214,1.527L91.205,171.883z M122.536,153.733l0.58,3.481c-0.556-0.089-1.115-0.166-1.677-0.235 C121.794,155.897,122.154,154.816,122.536,153.733z M124.417,169.356c-2.018-0.138-4.177-0.156-6.482-0.03 c0.018-0.073,0.035-0.146,0.053-0.219c0.801-0.484,1.639-0.933,2.5-1.358C121.816,168.246,123.128,168.783,124.417,169.356z M118.38,167.484c0.038-0.148,0.073-0.295,0.111-0.442c0.176,0.059,0.353,0.116,0.528,0.177 C118.804,167.305,118.592,167.395,118.38,167.484z M120.883,153.743c-0.436,1.008-0.859,2.025-1.27,3.051 c-1.087-0.09-2.182-0.139-3.285-0.146C117.758,155.592,119.27,154.611,120.883,153.743z M95.657,176.593 c-0.141-0.519-0.288-1.058-0.433-1.589l1.088,0.653C96.08,175.984,95.863,176.295,95.657,176.593z M94.874,173.717 c-0.235-0.861-0.481-1.755-0.726-2.649l0.437-5.244c3.597-1.126,7.306-1.51,11.028-1.34c-3.599,3.647-6.555,7.376-8.658,10.274 L94.874,173.717z M99.966,192.23c-0.046,0.038-0.081,0.068-0.117,0.099c-0.022-0.083-0.043-0.164-0.064-0.248 c0.276-0.746,0.94-2.425,2.042-4.613C101.189,189.167,100.562,190.764,99.966,192.23z M97.761,184.408 c-0.088-0.331-0.184-0.686-0.274-1.023c0.54-1.467,1.313-3.398,2.357-5.609l2.243,1.346 C100.134,181.22,98.689,183.099,97.761,184.408z M105.826,175.478c-0.925,0.817-1.785,1.632-2.574,2.428l-2.794-1.397 c1.802-3.633,4.283-7.84,7.546-11.842c0.118,0.013,0.235,0.026,0.353,0.04C107.732,168.283,106.847,171.93,105.826,175.478z M109.206,185.037c0,0,0.178-0.492,0.442-1.379l0.776,0.466C109.653,184.712,109.206,185.037,109.206,185.037z M111.794,182.178 l-1.541-0.771c0.457-1.869,0.964-4.376,1.304-7.339c0.939-0.9,1.937-1.774,3.002-2.604l0.023,0.036 C113.534,175.104,112.61,178.685,111.794,182.178z M111.83,170.939c0.071-1.136,0.114-2.315,0.116-3.537l1.601,2.491 C112.96,170.232,112.388,170.581,111.83,170.939z M114.421,169.394l-2.488-3.235c-0.006-0.296-0.016-0.596-0.027-0.896 c1.432,0.286,2.858,0.639,4.271,1.049c-0.279,0.861-0.55,1.721-0.814,2.583C115.046,169.06,114.73,169.225,114.421,169.394z M116.703,174.799l1.721,2.677c-0.947,0.846-1.849,1.629-2.693,2.347C116.026,178.162,116.352,176.486,116.703,174.799z M118.412,189.851c0,0,0.214-0.197,0.592-0.579l0.284,0.17C118.725,189.701,118.412,189.851,118.412,189.851z M117.109,172.889 c0.25-1.139,0.518-2.284,0.795-3.432c2.484,0.113,4.906,0.699,7.233,1.637c-1.866,1.891-3.694,3.64-5.407,5.204L117.109,172.889z M123.042,187.801l-1.85-0.925c0.545-0.635,1.163-1.387,1.835-2.239l1.611,2.505C124.072,187.372,123.543,187.591,123.042,187.801z M127.275,186.104l-2.695-3.503c0.706-0.954,1.454-2.005,2.24-3.164l1.072,6.431C127.682,185.948,127.48,186.025,127.275,186.104z M132.303,184.285c-0.073,0.025-0.144,0.05-0.217,0.075l-1.931-6.566c0.703-0.218,1.419-0.416,2.149-0.597V184.285z M132.303,176.547c-0.799,0.141-1.591,0.299-2.375,0.476l-0.484-1.647c0.307-0.498,0.616-1.005,0.93-1.531 c0.655,0.421,1.297,0.864,1.93,1.325V176.547z M132.303,159.548c-2.614-0.906-5.342-1.645-8.148-2.154l-1.321-4.49 c0.019-0.053,0.04-0.106,0.06-0.159c0.542-0.25,1.089-0.493,1.651-0.718c-0.529,0.156-1.054,0.329-1.575,0.515 c0.583-1.609,1.201-3.218,1.849-4.827c2.685,1.749,5.184,3.903,7.485,6.283V159.548z M133.917,160.133l-0.469-4.92 c0.916,1.004,1.804,2.033,2.65,3.086c-0.509,0.701-1.026,1.395-1.552,2.079C134.337,160.296,134.128,160.212,133.917,160.133z M137.352,182.69c-0.419,0.122-0.839,0.244-1.252,0.37l-0.5-5.253c0.785,0.687,1.543,1.393,2.28,2.112L137.352,182.69z M136.949,161.368c0.19-0.407,0.38-0.826,0.57-1.242c0.56,0.743,1.097,1.491,1.622,2.24 C138.423,162.023,137.691,161.691,136.949,161.368z M140.685,189.289l0.336-3.695c0.41-0.217,0.829-0.428,1.259-0.634 L140.685,189.289z M146.97,191.384l0.107-0.537c0.045,0.064,0.089,0.127,0.133,0.19L146.97,191.384z M155.078,172.368 c-0.873-1.654-1.931-3.513-3.206-5.49l1.857-9.287c2.323,6.559,3.44,12.865,3.96,16.917 C156.943,173.871,156.07,173.15,155.078,172.368z M185.958,156.605c1.419,0.315,2.806,0.66,4.154,1.041l-3.192,4.63 C186.541,160.515,186.208,158.614,185.958,156.605z M190.802,174.49c0,0-0.852-1.8-1.874-4.854c0.781,1.26,1.517,2.521,2.203,3.774 C190.911,174.104,190.802,174.49,190.802,174.49z M192.998,168.107c-1.531-1.596-3.24-3.214-5.135-4.823l3.016-5.432 c1.987,0.586,3.882,1.251,5.714,1.965C195.107,162.874,193.909,165.734,192.998,168.107z M197.631,157.752 c-1.983-0.477-4.009-0.853-6.069-1.129l3.087-5.56l-3.775,5.476c-1.638-0.199-3.295-0.331-4.973-0.382 c-1.151-9.832-0.224-22.141,7.614-33.075c4.052,8.961,6.719,18.44,8.448,27.262C200.339,152.794,198.895,155.307,197.631,157.752z M214.066,170.613c0,0-0.032-0.333-0.109-0.934c0.077,0.06,0.147,0.122,0.223,0.182 C214.108,170.345,214.066,170.613,214.066,170.613z M214.921,164.411c-0.674-0.356-1.356-0.707-2.05-1.049 c-0.768-3.717-1.991-8.648-3.915-14.339c1.894-3.813,4.578-7.292,8.3-10.101C216.633,149.639,215.635,158.749,214.921,164.411z M238.749,163.882c-0.106-0.77-0.185-1.555-0.24-2.352c0.727-0.879,1.558-1.695,2.506-2.432 C240.13,160.672,239.358,162.266,238.749,163.882z M238.576,154.942c0.443-5.835,1.838-12.056,3.706-18.144 c1.575,5.262,2.397,10.434,2.705,15.318C242.818,152.804,240.674,153.767,238.576,154.942z M254.632,178.891 c0.064-0.508,0.125-1.027,0.183-1.554l0.356,0.553C254.994,178.222,254.802,178.563,254.632,178.891z M255.806,176.709 l-0.582-0.757c0.318,0.024,0.634,0.037,0.952,0.07C256.046,176.254,255.933,176.478,255.806,176.709z M258.063,172.773 c-0.961,0.096-1.928,0.231-2.901,0.404c0.226-3.936,0.157-8.303-0.527-13.074c2.791-0.469,5.515-0.463,8.152-0.086l0.721,4.327 C261.542,167.213,259.706,170.036,258.063,172.773z M264.326,163.157l-0.895-3.044c0.894,0.149,1.781,0.325,2.653,0.553 C265.487,161.499,264.901,162.329,264.326,163.157z M274.897,174.484l-0.103-1.086c0.742-0.049,1.47-0.086,2.159-0.086 c-0.487,0.447-0.958,0.904-1.421,1.366C275.319,174.614,275.111,174.546,274.897,174.484z M277.125,190.428 c-0.232,0.025-0.466,0.051-0.702,0.081l-0.091-0.956c0.434-0.672,0.882-1.332,1.339-1.986L277.125,190.428z M281.033,169.912 c-0.05,0.038-0.101,0.076-0.151,0.114c-2.099-0.081-4.204,0.318-6.283,1.332l-0.064-0.675c0.667-1.786,1.367-3.547,2.086-5.292 c1.622,1.022,3.177,2.128,4.647,3.291L281.033,169.912z M282.569,190.324c-0.419-0.03-0.851-0.05-1.294-0.062l0.411-4.522 c0.726,0.439,1.431,0.873,2.095,1.296L282.569,190.324z M286.633,179.292c-0.505-0.268-1.026-0.535-1.56-0.801 c0.769-0.815,1.549-1.613,2.341-2.393c0.104,0.071,0.219,0.133,0.32,0.207L286.633,179.292z M290.571,192.131 c-0.576-0.242-1.343-0.527-2.288-0.803l0.22-1.102c0.935,0.67,1.686,1.23,2.241,1.654L290.571,192.131z M290.275,181.37 l0.407-2.033c0.733,1.048,1.319,2.198,1.782,3.424C291.796,182.318,291.064,181.853,290.275,181.37z M295.366,155.918 c0.916,1.323,1.763,2.716,2.546,4.144c-1.243,0.569-2.49,1.172-3.734,1.797L295.366,155.918z M293.335,170.702 c2.35-1.983,4.726-3.831,7.071-5.525c1.262,2.9,2.282,5.76,3.081,8.298l-2.573,3.717 C298.915,175.252,296.359,172.978,293.335,170.702z M302.044,178.312l1.767-3.786c1.4,4.629,2.026,7.945,2.026,7.945 S304.482,180.775,302.044,178.312z M311.495,178.959c0,0-2.797-6.835-9.018-15.244c1.717-1.19,3.406-2.305,5.043-3.336 c2.131,2.09,3.751,4.549,4.981,7.208L311.495,178.959z M312.982,162.149c-1.007-1.161-2.079-2.216-3.202-3.162 c1.273-0.769,2.494-1.477,3.671-2.142L312.982,162.149z M314.733,181.652l-0.065-7.685c0.462,1.944,0.783,3.918,0.986,5.88 C315.053,180.979,314.733,181.652,314.733,181.652z M314.584,164.144l-0.067-7.9c1.933-1.07,3.697-1.989,5.236-2.758 c1.307,4.882,2.389,9.891,3.271,14.784c-1.173,1.557-2.234,3.084-3.175,4.518C318.352,169.8,316.6,166.813,314.584,164.144z M322.998,179.9c-0.427-1.092-0.895-2.225-1.402-3.384c0.592-1.453,1.272-2.983,2.059-4.554c0.335,2.047,0.638,4.061,0.91,6.021 C324.006,178.636,323.481,179.278,322.998,179.9z M324.774,184.806c0.169-0.357,0.342-0.718,0.527-1.087 c0.172,1.466,0.324,2.871,0.464,4.235C325.506,187.081,325.175,186.014,324.774,184.806z M329.787,160.524 c-1.039-2.995-2.37-6.325-4.064-9.816c0.203-0.085,0.342-0.142,0.342-0.142s-0.139,0.03-0.371,0.082 c-1.945-4.002-4.367-8.207-7.373-12.347c6.966,6.656,10.248,14.564,11.491,22.199C329.804,160.507,329.795,160.515,329.787,160.524 z M379.421,147.886c0.841-0.128,1.702-0.218,2.588-0.257c-0.816-0.024-1.594,0.002-2.381,0.016 c1.896-2.164,4.078-4.293,6.573-6.356c0.503,4.97,0.796,9.948,0.945,14.72c-3.666-1.154-7.662-1.994-12.031-2.429 C376.352,151.676,377.789,149.771,379.421,147.886z M367.113,178.995c0.053-1.562,0.189-3.32,0.459-5.237 c0.088,0.01,0.172,0.012,0.26,0.022c-0.087-0.013-0.173-0.019-0.259-0.031c0.558-3.956,1.695-8.559,3.85-13.381 c2.118,5.143,3.707,10.367,4.903,15.305C373.081,176.379,369.981,177.563,367.113,178.995z M386.173,189.402 c0,0-0.38-2.524-1.53-6.631c0.689-0.185,1.38-0.346,2.073-0.483C386.444,186.728,386.173,189.402,386.173,189.402z M387.208,170.252c-1.949,0.966-3.85,2.118-5.656,3.362c-1.96-4.976-4.694-10.718-8.457-16.621c0.433-0.799,0.895-1.599,1.39-2.402 c0.089,0.025,0.18,0.046,0.269,0.072c4.574,4.543,8.724,8.886,12.496,13.031C387.24,168.564,387.226,169.417,387.208,170.252z M387.268,165.721c-3.57-4.104-7.478-7.787-11.744-10.849c4.439,1.404,8.319,3.647,11.731,6.401 C387.272,162.79,387.276,164.277,387.268,165.721z M395.55,176.808c-0.013-0.021-0.027-0.041-0.04-0.062 c-0.074-1.99-0.172-4.428-0.346-7.216c0.582,0.769,1.143,1.548,1.683,2.34C396.374,173.486,395.937,175.132,395.55,176.808z M405.517,166.255c0.247-1.255,0.525-2.51,0.83-3.762c0.798,2.203,1.584,4.458,2.353,6.745 C407.7,168.214,406.63,167.223,405.517,166.255z M428.122,178.971c-0.274,1.569-0.51,3.114-0.713,4.621 c-1.525-2.98-3.643-6.839-6.357-11.161c2.202-3.276,4.582-6.484,7.093-9.526C427.935,168.517,427.96,173.952,428.122,178.971z M433.664,156.702c0.993-1.03,1.995-2.022,3.005-2.978c-0.846,1.444-1.626,2.939-2.342,4.474 C434.109,157.701,433.893,157.205,433.664,156.702z M445.781,171.645c-0.375-0.112-0.749-0.226-1.131-0.329 c0.363,0.178,0.726,0.382,1.089,0.582c-0.441,2.72-0.929,5.199-1.4,7.345c-0.05,0.213-0.093,0.427-0.14,0.64 c-1.048,4.675-1.963,7.592-1.963,7.592s-0.625-10.177-5.68-23.771c1.772-6.024,4.962-12.064,10.285-17.556 C447.788,155.018,446.974,164.196,445.781,171.645z M454.488,189.315c0.41-2.95,1.086-5.915,2.127-8.77 c0.66,0.669,1.314,1.352,1.961,2.052C456.764,185.998,455.187,188.33,454.488,189.315z M460.441,178.843 c-0.772-0.542-1.575-1.078-2.41-1.602c1.516-3.103,3.553-5.987,6.235-8.48C463.14,172.542,461.79,175.937,460.441,178.843z M468.141,183.366c1.176-5.16,2.098-11.556,2.02-18.808c0.039-0.021,0.081-0.039,0.12-0.06c0.763,3.392,1.346,6.685,1.798,9.748 C470.574,177.367,469.261,180.481,468.141,183.366z M486.688,171.288c-0.69-0.332-1.401-0.626-2.158-0.828 c0.74,0.239,1.435,0.595,2.096,1.028c-0.266,0.869-0.519,1.722-0.756,2.554l-6.201-3.101l6.052,3.631 c-1.491,5.315-2.378,9.676-2.711,11.438c-0.086,0.062-0.17,0.126-0.255,0.188c-0.295-1.75-1.361-6.976-4.519-14.841 c1.354-5.826,3.802-11.209,7.912-15.249c1.971,0.781,3.642,1.853,5.049,3.14C489.382,163.204,487.889,167.394,486.688,171.288z M498.323,186.5c-0.028,0.092-0.052,0.175-0.078,0.262c-0.091-0.289-0.461-1.406-1.136-2.963c0.465-0.126,0.945-0.241,1.439-0.345 C498.488,184.906,498.383,185.976,498.323,186.5z M496.726,179.47l-2.68-1.34c-0.398-0.594-0.836-1.18-1.294-1.757 c-0.767-4.138-0.879-9.141,0.599-14.733c3.877,5.155,4.995,12.184,5.203,17.519C497.944,179.239,497.335,179.342,496.726,179.47z M506.375,171.051c-1.84,1.897-3.372,4.306-4.609,6.742c-1.351-5.362-3.82-12.095-8.225-16.839 c0.988-3.459,2.601-7.135,5.034-10.959c5.927,3.793,7.772,10.661,7.885,17.432l-3.744-4.867l3.751,5.834 C506.462,169.287,506.432,170.175,506.375,171.051z M508.919,180.489c-0.121-0.05-0.242-0.09-0.362-0.138 c0.227-1.805,0.485-4.713,0.4-8.085l1.682,2.616C509.993,177.25,509.367,179.187,508.919,180.489z M516.553,176.624l3.622-7.791 l0.618,3.705C518.105,174.976,516.553,176.624,516.553,176.624z M521.569,177.192l0.343,2.057 c-2.241,1.307-3.586,2.238-3.586,2.238S519.547,179.76,521.569,177.192z M521.853,187.437l-0.009-0.012 c0.108-0.089,0.541-0.442,1.263-1l0.073,0.437C522.43,187.17,521.977,187.379,521.853,187.437z M527.86,185.201 c-0.232,0.071-0.452,0.141-0.674,0.212l-0.479-1.627c0.368-0.257,0.752-0.521,1.152-0.792V185.201z M527.86,176.109 c-1.058,0.503-2.051,1.004-2.972,1.49l-0.974-3.31c1.184-1.428,2.513-2.975,3.946-4.552V176.109z M527.86,166.642 c-1.865,1.434-3.543,2.81-4.999,4.066l-1.379-4.688l6.377-13.717V166.642z M538.493,167.128c0.533,1.505,0.972,3.07,1.31,4.683 c-0.596,0.138-1.188,0.287-1.776,0.448L538.493,167.128z M537.648,160.412l-0.256,1.345c-0.186-0.239-0.378-0.462-0.567-0.692 C537.099,160.841,537.374,160.627,537.648,160.412z M533.177,183.886c-0.565,0.107-1.117,0.223-1.656,0.346l-0.324-3.4 c0.92-0.568,1.886-1.14,2.886-1.703L533.177,183.886z M530.629,174.864l-0.7-7.347c1.901-1.984,3.933-3.943,6.01-5.709 c0.387,0.607,0.751,1.233,1.085,1.883l-1.795,9.423C533.633,173.648,532.093,174.242,530.629,174.864z M536.241,191.894 l0.142-1.557c0.155-0.033,0.312-0.065,0.468-0.097L536.241,191.894z M539.449,183.188c-0.818,0.022-1.629,0.071-2.429,0.147 l0.549-6.043c0.954-0.469,1.925-0.922,2.908-1.34c0.143,1.196,0.24,2.402,0.309,3.606L539.449,183.188z M545.795,177.652 l0.521-2.607c0.274,2.54,0.652,4.874,1.077,6.965C546.908,180.609,546.377,179.147,545.795,177.652z M551.296,173.119 c1.86-0.111,3.66,0.019,5.338,0.495l-3.358,4.851C552.602,176.857,551.927,175.068,551.296,173.119z M554.566,181.362l3.196-6.849 c-0.459,7.932,0.16,12.947,0.16,12.947S556.401,185.226,554.566,181.362z M566.821,185.465c0,0-0.244-0.874-0.607-2.409 l0.984-1.107C566.894,184.176,566.821,185.465,566.821,185.465z M567.222,181.776l-1.101,0.881 c-0.341-1.469-0.768-3.451-1.196-5.81c1.165-0.732,2.349-1.37,3.548-1.932C567.859,177.672,567.469,180.005,567.222,181.776z M577.036,164.399c0.202,0.934,0.395,1.867,0.583,2.8c-0.337,0.16-0.674,0.332-1.011,0.502 C576.734,166.617,576.875,165.517,577.036,164.399z M575.72,187.461c0,0-0.283-6.399,0.421-15.05 c0.795-0.156,1.593-0.278,2.393-0.378c0.4,2.256,0.758,4.479,1.081,6.654C577.013,183.945,575.72,187.461,575.72,187.461z M590.663,172.564c0.017-0.059,0.034-0.118,0.05-0.177c0.009,0.002,0.018,0.003,0.027,0.005 C590.714,172.45,590.689,172.507,590.663,172.564z M594.687,162.921c-0.274,0.013-0.549,0.032-0.824,0.05 c1.179-3.038,2.496-5.952,3.969-8.629C596.764,157.447,595.698,160.328,594.687,162.921z M604.197,176.944 c0,0,0.068-0.19,0.178-0.527c0.056,0.023,0.112,0.046,0.168,0.069C604.318,176.781,604.197,176.944,604.197,176.944z M613.598,165.547c-2.075-0.651-4.204-1.208-6.38-1.643c1.305-8.003,2.426-19.653,1.929-34.799 c9.541,3.14,16.854,9.622,22.406,17.148c0.104,0.431,0.205,0.863,0.302,1.295C624.859,153.384,618.472,160.041,613.598,165.547z M622.885,189.402c0,0-0.209-1.147-0.326-3.107c0.229,0.153,0.459,0.307,0.685,0.459c0.161,0.581,0.316,1.158,0.458,1.726 C623.177,189.059,622.885,189.402,622.885,189.402z M633.839,175.329c-2.808-1.828-5.959-3.678-9.382-5.376 c1.506-5.218,4.107-10.979,8.469-16.636C634.081,161.038,634.187,168.683,633.839,175.329z M641.712,180.997 c-0.141-0.112-0.283-0.224-0.429-0.339c0.349-0.574,0.71-1.139,1.084-1.691C642.134,179.702,641.915,180.377,641.712,180.997z M644.323,172.571c-1.412,0.605-2.807,1.325-4.168,2.119c-0.391-5.575-1.408-12.907-3.811-20.988 c3.649,6.476,6.24,13.132,8.018,18.736C644.349,172.484,644.336,172.528,644.323,172.571z M650.102,149.343 c-1.893-2.303-3.995-4.542-6.332-6.657c2.501-1.888,5.28-3.709,8.391-5.426C651.601,141.34,650.892,145.403,650.102,149.343z M666.514,176.391c-0.634,0.541-1.251,1.09-1.839,1.655c-0.508-1.814-1.146-3.855-1.939-6.053c1.373-3.52,3.126-7.057,5.043-10.446 C667.024,167.135,666.668,172.268,666.514,176.391z M682.062,183.173c0,0-1.235-2.61-2.587-6.932 c0.429-0.375,0.861-0.747,1.296-1.116c1.04,0.972,2.002,2.05,2.897,3.191C682.599,181.297,682.062,183.173,682.062,183.173z M684.324,176.537c-0.826-0.781-1.703-1.518-2.621-2.201c1.696-1.414,3.433-2.784,5.195-4.096l0.003,0.006 C685.877,172.559,685.021,174.69,684.324,176.537z M704.796,171.024c0.191,0.379,0.381,0.76,0.567,1.147l-0.705-0.352 C704.703,171.555,704.749,171.291,704.796,171.024z M704.647,171.886l0.81,0.486c0.207,0.436,0.416,0.87,0.616,1.315 c-0.553-0.153-1.107-0.274-1.662-0.365C704.486,172.849,704.564,172.37,704.647,171.886z M698.878,183.151l-0.869-6.696 c0.882-0.02,1.721-0.001,2.522,0.053C699.372,180.557,698.878,183.151,698.878,183.151z M698.057,173.783 c0.173-3.587,0.639-7.294,1.53-10.935c1.314,1.571,2.542,3.364,3.681,5.331c-0.652,1.753-1.222,3.421-1.716,4.964 C700.385,173.194,699.218,173.399,698.057,173.783z M702.976,186.312c0,0,0.203-3.943,0.911-9.359 c1.251,0.282,2.357,0.689,3.374,1.171C704.499,182.723,702.976,186.312,702.976,186.312z M715.472,178.913 c-0.473-0.385-0.949-0.76-1.43-1.116c0.036-0.071,0.07-0.14,0.106-0.211l1.631,0.979 C715.675,178.681,715.574,178.797,715.472,178.913z M716.51,177.745l-1.942-0.971c1.23-2.355,2.647-4.792,4.243-7.091 c0.707,1.18,1.375,2.328,2.046,3.478C719.346,174.669,717.894,176.207,716.51,177.745z M724.211,169.961 c-0.794,0.722-1.575,1.457-2.342,2.203c-0.716-1.234-1.463-2.442-2.24-3.622c1.754-2.379,3.701-4.55,5.822-6.25 C725.112,164.936,724.684,167.506,724.211,169.961z M751.082,161.068c0.152,0.682,0.295,1.364,0.413,2.043 c-1.838,1.42-3.639,3.023-5.374,4.73l-1.521-5.171C746.504,161.946,748.655,161.401,751.082,161.068z M745.558,176.122 c-0.32-0.228-0.638-0.424-0.956-0.631c0.202-0.409,0.421-0.819,0.646-1.231L745.558,176.122z M734.461,171.172 c0.154,0.349,0.315,0.694,0.456,1.049c-0.305-0.012-0.605-0.002-0.907,0.002l-0.06-0.077 C734.113,171.817,734.282,171.491,734.461,171.172z M729.624,165.433c-0.047-0.571-0.093-1.14-0.148-1.73 c0.35,0.353,0.682,0.719,1.005,1.091C730.195,165.005,729.909,165.217,729.624,165.433z M731.825,185.403l-0.51-0.255 c-0.001-2.758,0.254-5.482,0.87-8.056c0.975-0.519,1.961-0.961,2.954-1.314l1.536,2.39c0.028,0.135,0.054,0.27,0.081,0.406 C734.811,181.107,733.132,183.477,731.825,185.403z M740.842,173.526c-0.206-0.082-0.414-0.182-0.619-0.256 c-1.033-1.858-2.174-3.673-3.412-5.377c1.116-1.247,2.431-2.369,3.972-3.336c0.441,2.445,0.847,5.002,1.217,7.643 C741.608,172.641,741.222,173.083,740.842,173.526z M743.146,170.929c-0.595-2.15-1.207-4.356-1.856-6.679 c0.662-0.389,1.365-0.749,2.109-1.081l1.06,6.359C744.016,169.991,743.578,170.458,743.146,170.929z M744.483,175.782 c0.374,0.162,0.744,0.354,1.112,0.563l1.518,9.111C746.311,182.471,745.43,179.232,744.483,175.782z M752.113,175.026 c-0.194,3.356-0.651,6.459-1.194,9.127l-3.802-12.925c1.296-1.883,2.859-3.764,4.742-5.607c0.119,0.997,0.197,1.982,0.254,2.961 V175.026z M754.51,160.984c-0.023-0.078-0.043-0.156-0.065-0.234c0.154-0.008,0.312-0.013,0.468-0.02 C754.778,160.814,754.644,160.899,754.51,160.984z M755.024,162.82c0.889-0.717,1.823-1.426,2.825-2.121 c1.047,0.016,2.12,0.054,3.245,0.133c0.177,0.528,0.351,1.055,0.522,1.583l-3.553,18.653 C757.591,175.539,756.691,169.089,755.024,162.82z M761.227,184.342l1.633-17.96c0.842,2.786,1.616,5.559,2.326,8.286 C763.48,178.034,762.193,181.351,761.227,184.342z M788.05,182.529c-0.482,0.252-0.955,0.511-1.422,0.775 c-0.952-2.048-2.415-5.05-4.402-8.733l3.412-7.31l-4.139,5.979c-0.68-1.237-1.414-2.537-2.202-3.896 c2.027-3.858,4.506-7.546,7.511-10.614C787.97,169.046,788.098,177.805,788.05,182.529z M804.94,178.088 c-0.67-0.013-1.336,0.004-1.998,0.039c-0.514-3.453-1.46-8.515-3.135-14.6c2.694-0.378,5.439-0.372,8.197-0.037 C807,169.506,805.832,174.596,804.94,178.088z M819.108,186.284l-0.002,0.001c0.001-0.004,0.03-0.228,0.074-0.617 c0.104,0.029,0.208,0.06,0.312,0.092C819.255,186.089,819.113,186.279,819.108,186.284z M820.856,183.758 c-0.473-0.352-0.946-0.684-1.42-0.999c0.233-3.376,0.428-9.031-0.024-16.292c2.968,1.148,5.866,2.522,8.628,4.026 C825.337,176.547,822.581,181.13,820.856,183.758z M830.922,163.289c-3.756-1.296-7.778-2.274-11.999-2.723 c-0.489-4.75-1.255-9.99-2.435-15.603c6.509,0.701,12.443,3.391,17.674,7.006C833.286,156.019,832.159,159.805,830.922,163.289z M837.532,177.78c0.09-0.395,0.18-0.789,0.267-1.195c0.053,0.037,0.105,0.074,0.157,0.11 C837.812,177.061,837.671,177.421,837.532,177.78z M841.628,168.09c-0.719-0.398-1.456-0.788-2.212-1.173 c0.387-3.198,0.657-6.594,0.743-10.18c1.686,1.522,3.277,3.103,4.755,4.703C843.748,163.643,842.649,165.873,841.628,168.09z M849.044,186.345c-0.016-0.3-0.028-0.603-0.042-0.905c1.546,1.377,2.408,2.224,2.408,2.224S850.594,187.082,849.044,186.345z M849.165,172.824c0.145-1.875,0.353-3.748,0.63-5.604c5.585,7.197,8.714,13.345,8.714,13.345S855.035,176.978,849.165,172.824z M867.423,174.598c-0.139-0.184-0.298-0.391-0.453-0.593c0.274,0.135,0.552,0.268,0.82,0.407 C867.668,174.47,867.546,174.535,867.423,174.598z M864.534,170.974c-2.977-3.547-7.317-8.178-12.787-12.584 c1.632-5.376,4.084-10.346,7.627-14.467c5.492,9.492,8.063,21.643,9.128,28.263C867.21,171.731,865.886,171.324,864.534,170.974z M868.787,176.476c0.103-0.004,0.208-0.009,0.311-0.012c0.039,0.348,0.059,0.553,0.059,0.553S869.024,176.816,868.787,176.476z M896.159,184.497c-0.793,0.504-1.539,0.994-2.243,1.469c-0.971-1.123-1.979-2.222-3.018-3.278c1.71-3.003,4.004-6.452,6.97-9.774 C897.64,177.575,896.886,181.586,896.159,184.497z M886.979,179.077c-0.464-0.383-0.933-0.751-1.405-1.107 c1.959-4.727,5.304-11.506,10.389-17.901c0.381,0.214,0.768,0.423,1.128,0.654c0.499,2.717,0.753,5.363,0.823,7.883 C893.076,172.17,889.418,176.074,886.979,179.077z M899.331,156.199c4.202-4.429,9.346-8.385,15.57-10.954 c3.538,4.431,5.752,9.238,7.043,14.054c-6.407,0.545-12.045,2.402-16.893,4.882c-1.069-1.125-2.2-2.137-3.391-3.013 C901.001,159.556,900.227,157.898,899.331,156.199z M904.764,185.983c0.104-0.826,0.196-1.691,0.273-2.586 c0.653-0.517,1.326-1.032,2.032-1.543C906.228,183.265,905.453,184.646,904.764,185.983z M905.227,179.399 c0.03-3.571-0.326-7.568-1.469-11.964c2.08,3.219,3.413,6.896,4.21,10.679C907.031,178.533,906.117,178.961,905.227,179.399z M906.268,165.536c4.378-2.937,9.594-5.168,15.741-5.982c0.106,0.405,0.222,0.81,0.315,1.215 c-3.636,4.443-7.168,9.016-10.282,13.461C910.396,171.149,908.475,168.131,906.268,165.536z M922.903,180.186 c-2.182,1.744-4.146,3.659-5.752,5.754c-0.014-0.039-0.028-0.078-0.042-0.117c1.212-3.87,2.629-7.638,4.186-11.268 c0.713-0.228,1.437-0.44,2.174-0.635C923.383,176.125,923.18,178.228,922.903,180.186z M923.493,173.129 c-0.579,0.109-1.153,0.228-1.725,0.354c0.556-1.266,1.125-2.517,1.71-3.746C923.52,170.889,923.521,172.018,923.493,173.129z M929.806,175.553c-0.321,0.183-0.64,0.37-0.958,0.559c-0.13-1.045-0.282-2.112-0.446-3.189c0.673-0.096,1.35-0.184,2.04-0.249 C930.232,173.648,930.021,174.61,929.806,175.553z M930.53,172.261c-0.739,0.039-1.473,0.103-2.205,0.174 c-0.452-2.88-1.032-5.837-1.779-8.771c0.804-1.504,1.619-2.977,2.442-4.406c0.171,0.008,0.333,0.002,0.505,0.011 c-0.168-0.013-0.33-0.013-0.497-0.024c1.613-2.799,3.249-5.438,4.862-7.913C933.114,158.691,931.904,165.8,930.53,172.261z M951.228,171.176c-0.249-0.53-0.505-1.056-0.765-1.579c0.315-0.607,0.644-1.209,0.982-1.806c0.631-0.317,1.205-0.597,1.726-0.845 C952.409,168.563,951.76,169.985,951.228,171.176z M953.901,165.402c-0.138,0.288-0.27,0.566-0.402,0.844 c-0.409,0.106-0.871,0.23-1.359,0.363c0.57-0.953,1.163-1.892,1.795-2.803C953.918,164.345,953.909,164.874,953.901,165.402z M955.003,180.407c0.036-0.124,0.074-0.253,0.111-0.378c0.095,0.526,0.194,1.038,0.295,1.536 C955.276,181.182,955.143,180.799,955.003,180.407z M966.031,170.669c-1.72,2.456-3.303,4.923-4.747,7.334 c-1.003-2.397-2.014-5.199-2.865-8.326c1.751-5.025,3.848-10.43,6.372-16.06c1.476-0.802,3.042-1.458,4.706-1.94 C967.54,158.708,966.525,165.207,966.031,170.669z M975.758,178.089c-0.833-0.001-1.66,0.035-2.48,0.106 c-0.247-1.26-0.501-2.66-0.746-4.173c1.305,0.523,2.479,1.375,3.531,2.458C975.952,177.04,975.851,177.574,975.758,178.089z M976.193,175.845c-1.116-0.786-2.335-1.421-3.664-1.843c-0.249-1.539-0.486-3.191-0.696-4.929 c1.572-2.553,3.278-5.154,5.157-7.801c0.967,0.674,1.845,1.425,2.622,2.255C977.987,168.169,976.906,172.392,976.193,175.845z M984.187,171.58c0.314,0.944,0.581,1.898,0.803,2.852l-0.98-0.49C984.062,173.173,984.119,172.39,984.187,171.58z M984.1,186.078 c-0.128-0.273-0.265-0.552-0.409-0.839c-0.002-0.107-0.003-0.208-0.005-0.324c0.299-0.014,0.598-0.017,0.898-0.02 C984.389,185.363,984.227,185.759,984.1,186.078z M983.745,179.338c0.044-1.457,0.117-3.077,0.227-4.818l1.199,0.719 c0.349,1.672,0.576,3.328,0.714,4.896C985.171,179.835,984.457,179.568,983.745,179.338z M988.122,177.263 c-0.035-0.105-0.068-0.21-0.104-0.316l0.202,0.121C988.186,177.134,988.154,177.198,988.122,177.263z M988.636,176.255 l-1.041-0.521c-0.83-2.285-1.867-4.615-3.158-6.795c0.487-4.697,1.273-9.863,2.538-14.944c4.254,3.187,6.139,8.111,6.74,13.309 C991.719,170.512,990.031,173.555,988.636,176.255z M1019.955,177.473c-1.985,0.774-3.859,1.613-5.548,2.444l-2.352-3.057 c1.919-2.281,4.166-4.806,6.589-7.247L1019.955,177.473z M1016.061,154.113l2.278,13.668c-3.219,2.304-6.012,4.564-8.257,6.513 l-2.122-2.758L1016.061,154.113z M995.746,185.662c0,0,0.278-1.464,0.486-3.78c0-0.002,0.001-0.003,0.001-0.005l0.685,0.411 C996.239,184.398,995.746,185.662,995.746,185.662z M997.428,180.651l-0.829-0.414c1.036-4.548,2.316-9.311,3.892-13.919 C999.833,171.874,998.512,177.054,997.428,180.651z M1002.18,164.308l4.274,6.648l-5.75,10.549 C1000.704,181.505,1002.258,173.283,1002.18,164.308z M1004.033,179.984l3.452-7.424l1.648,2.563 C1005.9,177.993,1004.033,179.984,1004.033,179.984z M1005.809,184.842c0.026-0.037,2.064-2.912,5.227-6.757l1.717,2.671 c-4.178,2.177-6.906,4.062-6.942,4.087L1005.809,184.842z M1009.279,190.823c0,0,0.288-0.238,0.798-0.64l0.279,0.167 C1009.674,190.636,1009.279,190.823,1009.279,190.823z M1014.062,188.968l-1.429-0.715c0.973-0.708,2.12-1.516,3.414-2.375 l1.353,2.104C1016.185,188.3,1015.06,188.638,1014.062,188.968z M1020.127,187.352l-2.111-2.744 c0.903-0.568,1.853-1.142,2.842-1.713l0.699,4.192C1021.072,187.169,1020.596,187.257,1020.127,187.352z M1026.2,186.575 c-0.109,0.005-0.22,0.006-0.328,0.012l-1.627-5.531c0.644-0.328,1.294-0.649,1.954-0.957l0.001,0.001V186.575z M1026.2,175.439 c-1.124,0.289-2.232,0.619-3.319,0.979l-2.501-8.505c1.887-1.8,3.849-3.497,5.821-4.957V175.439z M1030.979,186.706 c-0.297-0.033-0.594-0.056-0.891-0.079l-0.25-2.623c0.459,0.539,0.907,1.082,1.345,1.631L1030.979,186.706z M1031.584,183.53 c-0.625-0.467-1.264-0.93-1.923-1.391l-0.323-3.386c1.12-0.438,2.249-0.829,3.377-1.161L1031.584,183.53z M1036.259,187.339 c-0.382-0.339-0.773-0.678-1.172-1.017l0.864-9.503c1.471-0.267,2.917-0.397,4.32-0.371L1036.259,187.339z M1041.485,190.897 l2.775-13.874c1.882,0.558,3.615,1.53,5.113,3.038c-1.505-1.635-3.183-2.853-4.969-3.759l2.512-12.562 c1.166,4.361,2.091,8.668,2.812,12.79c-0.566,0.128-1.133,0.259-1.698,0.413c0.596-0.04,1.174-0.052,1.759-0.073 c0.2,1.16,0.384,2.303,0.554,3.431l-7.922,11.443C1042.114,191.452,1041.806,191.16,1041.485,190.897z M1047.7,192.517l3.329-7.134 c0.304,2.518,0.539,4.903,0.719,7.134H1047.7z M1061.407,192.517h-0.295c-0.13-0.981-0.367-2.583-0.776-4.715l1.989-2.238 C1061.93,188.834,1061.595,191.225,1061.407,192.517z M1062.482,184.24l-2.465,1.972c-0.524-2.52-1.255-5.582-2.271-9.061 c1.874,0.205,3.678,0.5,5.409,0.877C1062.927,180.308,1062.698,182.39,1062.482,184.24z M1087.911,182.578 c-0.723-0.345-1.491-0.698-2.307-1.057c0.01-2.52,0.23-5.138,0.619-7.812c2.409,0.445,4.399,1.26,6.019,2.372 C1090.588,178.191,1089.118,180.361,1087.911,182.578z M1086.838,170.11c0.81-4.149,1.963-8.367,3.311-12.496 c2.351,5.37,3.594,10.668,4.225,15.229C1091.916,171.392,1089.385,170.41,1086.838,170.11z M1104.094,180.058 c-0.036-0.277-0.076-0.56-0.117-0.843c0.166-0.239,0.328-0.478,0.496-0.716C1104.343,179.022,1104.208,179.549,1104.094,180.058z M1135.866,145.855c0.051,0.451,0.1,0.902,0.141,1.356c-0.551-0.099-1.113-0.168-1.671-0.248 C1134.847,146.585,1135.356,146.218,1135.866,145.855z M1123.86,138.949c2.391,2.394,4.315,4.941,5.86,7.573 c-2.67-0.111-5.422,0.03-8.237,0.424C1122.237,144.169,1123.038,141.496,1123.86,138.949z M1121.472,146.988 c3.005-0.304,5.909-0.171,8.701,0.331c0.028,0.05,0.058,0.1,0.085,0.15c-2.859,1.343-6.419,3.221-10.297,5.547 C1120.435,150.961,1120.94,148.948,1121.472,146.988z M1118.004,173.935c-0.373-0.468-0.759-0.934-1.157-1.399 c0.139-1.661,0.304-3.313,0.507-4.95c0.68,1.471,1.234,3.003,1.689,4.57C1118.676,172.742,1118.332,173.336,1118.004,173.935z M1120.511,192.517h-0.542c0.151-1.22,0.338-2.431,0.588-3.626c0.058,0.19,0.116,0.379,0.173,0.569 C1120.677,190.526,1120.599,191.539,1120.511,192.517z M1122.043,167.98c-0.482-0.787-0.984-1.559-1.504-2.313 c0.992,0.149,1.984,0.34,2.975,0.563C1123.008,166.805,1122.52,167.389,1122.043,167.98z M1118.414,162.85 c-0.106-0.129-0.21-0.26-0.317-0.386c0.05-0.307,0.096-0.615,0.148-0.921c4.186-4.474,8.568-8.605,12.984-12.171 c1.146,2.403,2.009,4.85,2.634,7.297c-2.236,1.737-4.489,3.646-6.631,5.699C1124.364,162.252,1121.419,162.387,1118.414,162.85z M1130.58,187.822c-0.859-2.888-2.469-7.765-4.853-12.912c1.254-2.38,2.637-4.658,4.096-6.817c1.672,0.611,3.323,1.299,4.944,2.046 C1133.578,177.173,1131.909,183.43,1130.58,187.822z M1133.523,163.023c0.426-0.542,0.854-1.075,1.282-1.596 c0.09,0.634,0.168,1.265,0.232,1.893C1134.533,163.219,1134.034,163.109,1133.523,163.023z M1133.875,148.198 c0.763,0.229,1.518,0.478,2.262,0.756c0.101,1.61,0.146,3.23,0.138,4.855C1135.569,151.87,1134.773,149.99,1133.875,148.198z M1136.783,149.215c1.565,0.618,3.086,1.336,4.56,2.141c-1.167,0.76-2.391,1.586-3.655,2.479 C1137.416,152.335,1137.114,150.794,1136.783,149.215z M1143.086,185.477c-0.489,0.038-0.981,0.081-1.485,0.139 c-0.102-3.396-0.354-7.715-0.936-12.443c1.872,1.056,3.679,2.156,5.394,3.273C1144.719,179.753,1143.76,182.866,1143.086,185.477z M1149.962,168.486c-3.287-1.616-6.878-3.076-10.721-4.166c-0.245-2.181-0.562-4.491-0.944-6.903 c1.711-1.868,3.369-3.547,4.89-5.005c4.282,2.603,8.142,5.869,11.509,9.294C1152.882,163.876,1151.319,166.167,1149.962,168.486z M1159.156,187.777c-1.098-0.45-2.428-0.915-3.978-1.316c0.203-0.891,0.437-1.851,0.701-2.868c1.63,1.313,3.013,2.491,4.113,3.46 C1159.703,187.298,1159.427,187.539,1159.156,187.777z M1168.317,181.012c-1.798-1.646-5.007-4.382-9.297-7.269 c0.459-1.196,0.954-2.401,1.491-3.61c0.255-0.275,0.529-0.547,0.797-0.82c3.665,4.731,6.262,8.988,7.604,11.344 C1168.711,180.775,1168.513,180.893,1168.317,181.012z M1178.654,176.322c-2.134-2.807-5.946-7.434-11.167-12.23 c1.691-1.196,3.532-2.362,5.579-3.477c-2.229,0.32-4.497,1.19-6.751,2.428c-0.444-0.394-0.898-0.787-1.361-1.18 c2.449-3.761,5.397-7.165,8.947-9.701c3.831,9.057,5.615,18.851,6.322,23.736C1179.696,176.028,1179.172,176.168,1178.654,176.322z M1194.816,186.143c0,0,0.475-1.685,1.507-4.361c0.517-0.006,1.033,0.006,1.549,0.035 C1195.847,184.39,1194.816,186.143,1194.816,186.143z M1199.235,192.517h-0.604c0.365-0.961,1.117-2.818,2.325-5.196 c0.298,1.112,0.558,2.196,0.788,3.248C1200.657,191.379,1199.81,192.05,1199.235,192.517z M1206.054,187.541 c-0.61-1.394-1.364-2.914-2.27-4.513c1.714,0.637,3.389,1.557,5.015,2.757C1207.823,186.386,1206.91,186.973,1206.054,187.541z M1209.402,192.517h-0.458c0.195-0.216,0.365-0.413,0.574-0.639C1209.478,192.105,1209.44,192.308,1209.402,192.517z M1210.582,184.712c-0.444,0.261-0.871,0.519-1.295,0.778c-1.556-1.686-3.13-3.134-4.714-4.371 c1.846-2.774,4.148-5.709,6.935-8.452C1211.364,177.14,1211.003,181.24,1210.582,184.712z M1200.8,178.376 c-0.592-0.826-1.233-1.661-1.915-2.503c2.598-5.399,6.556-12.081,12.172-17.92c0.377,3.821,0.526,7.573,0.513,11.148 C1207.093,172.068,1203.498,175.425,1200.8,178.376z M1217.776,185.389c0,0,0.033-0.358,0.069-0.999 c0.126-0.094,0.252-0.187,0.379-0.281C1217.939,184.938,1217.776,185.389,1217.776,185.389z M1219.567,180.08 c-0.55,0.245-1.097,0.491-1.631,0.743c0-3.055-0.181-7.475-0.921-12.777c2.186-1.536,4.597-2.888,7.228-3.985 C1222.512,170.674,1220.796,176.278,1219.567,180.08z M1233.016,157.511c0.313,1.274,0.611,2.536,0.896,3.783 c-0.478,0.035-0.957,0.069-1.426,0.118C1232.671,160.157,1232.848,158.852,1233.016,157.511z M1229.871,175.578 c0.717-3.387,1.711-8.143,2.568-13.857c0.499-0.08,1.014-0.136,1.526-0.197c0.398,1.752,0.766,3.47,1.112,5.155 C1233.23,169.475,1231.468,172.442,1229.871,175.578z M1237.418,183.893c0.043-0.795,0.137-1.606,0.254-2.424 c0.084,0.571,0.164,1.131,0.241,1.68C1237.748,183.397,1237.573,183.641,1237.418,183.893z M1242.791,166.351 c0.371-0.754,0.755-1.503,1.149-2.248c0.515,4.032,0.926,7.483,1.231,10.134c-0.077-0.001-0.155-0.006-0.233-0.007 C1244.493,172.157,1243.812,169.525,1242.791,166.351z M1245.189,175.458c-0.057-0.299-0.114-0.596-0.183-0.924 c0.066-0.001,0.133-0.001,0.199-0.002c0.033,0.291,0.065,0.569,0.095,0.839C1245.264,175.401,1245.225,175.429,1245.189,175.458z M1252.575,150.218c0.887-1.253,1.751-2.439,2.57-3.533c-0.157,7.137,0.008,11.571,0.008,11.571S1254.665,156.317,1252.575,150.218 z M1267.265,181.914c-0.512-1.922-1.531-6.018-2.615-11.817c0.941-0.698,1.889-1.38,2.841-2.042 c-0.267,6.795-0.063,11.964,0.054,14.073C1267.451,182.057,1267.359,181.983,1267.265,181.914z M1274.792,176.555 c-0.463-3.771-0.793-7.991-0.904-12.605c0.54-0.318,1.079-0.628,1.617-0.93c0.683,0.287,1.343,0.594,1.97,0.929 C1276.662,168.412,1275.739,172.651,1274.792,176.555z M1277.753,162.395c-0.265-0.07-0.538-0.113-0.807-0.168 c0.307-0.164,0.612-0.322,0.918-0.481C1277.827,161.963,1277.79,162.18,1277.753,162.395z M1280.299,185.217 c0.799-2.833,2.009-8.459,2.393-17.399c0.811,0.818,1.542,1.694,2.209,2.611C1282.888,177.154,1281.209,182.415,1280.299,185.217z M1295.206,173.089c0,0,0.318-1.779,0.857-7.596c0.284,1.244,0.553,2.488,0.811,3.731 C1295.789,171.659,1295.206,173.089,1295.206,173.089z M1299.277,190.678c-0.312-0.897-0.661-1.853-1.042-2.851 c0.318-1.365,0.681-2.843,1.092-4.429c0.272,1.916,0.515,3.778,0.733,5.582C1299.784,189.568,1299.523,190.135,1299.277,190.678z M1301.638,159.159c-1.238-2.744-2.694-5.611-4.418-8.514c0.015-0.225,0.031-0.47,0.046-0.7c2.045,2.669,3.63,5.464,4.826,8.313 C1301.94,158.559,1301.786,158.864,1301.638,159.159z M1314.781,164.435c-1.933,2.493-3.722,5.044-5.365,7.578 c-0.736-3.626-1.702-7.283-2.956-10.773c4.385-11.367,10.505-24.184,18.972-36.684 C1323.394,139.523,1318.755,154.011,1314.781,164.435z M1326.738,166.744c0.386-2.402,0.753-5.135,1.067-8.176 c1.55,1.039,3.028,2.174,4.434,3.395C1330.223,163.416,1328.385,165.019,1326.738,166.744z M1341.963,186.271 c0.036-2.979,0.375-6.842,1.428-11.168c1.841,2.844,3.467,5.746,4.888,8.588C1346.08,184.379,1343.965,185.265,1341.963,186.271z M1352.887,182.475c-0.838-1.259-1.767-2.573-2.779-3.919l4.418,2.651C1353.966,181.626,1353.422,182.05,1352.887,182.475z M1356.288,179.943l-8.385-4.192c-1.1-1.34-2.282-2.696-3.558-4.055c1.486-4.64,3.859-9.652,7.551-14.603 c2.378,7.807,4.122,15.671,5.349,22.202C1356.923,179.507,1356.604,179.723,1356.288,179.943z M1358.574,192.517 c-0.265-0.568-0.575-1.21-0.941-1.935c0.468-0.156,0.936-0.306,1.406-0.442c0.13,0.911,0.236,1.699,0.325,2.377H1358.574z M1365.246,183.106c-0.295-1.181-0.644-2.567-1.052-4.108c0.438-0.507,0.896-0.99,1.363-1.458 C1365.39,179.364,1365.28,181.221,1365.246,183.106z M1363.341,175.89c-0.79-2.784-1.762-5.932-2.963-9.316l5.373,8.358 C1364.944,175.212,1364.14,175.533,1363.341,175.89z M1366.11,172.938l-4.805-6.246c2.105-0.383,4.121-0.493,6.044-0.364 C1366.872,168.444,1366.45,170.654,1366.11,172.938z M1372.493,159.696l1.218,7.31c-0.623-0.174-1.253-0.324-1.886-0.455 C1371.972,164.21,1372.208,161.901,1372.493,159.696z M1374.537,183.893l-2.045-2.658c-0.856-4.378-0.973-9.324-0.695-14.175 c0.69,0.185,1.367,0.398,2.03,0.641l2.007,12.039C1375.291,181.127,1374.849,182.515,1374.537,183.893z M1378.214,174.721 l-1.719-5.846c1.344,0.675,2.626,1.458,3.846,2.33C1379.586,172.357,1378.873,173.532,1378.214,174.721z M1381.266,169.828 c-0.062,0.09-0.124,0.181-0.186,0.272c-1.582-0.878-3.215-1.649-4.895-2.277l-3.27-11.117c0.349-2.273,0.732-4.379,1.101-6.221 c2.627,0.086,5.032,0.631,7.249,1.51V169.828z M1382.14,152.361c3.242,1.452,6.046,3.657,8.469,6.319 c-2.286,2.307-4.764,5.066-7.097,8.086L1382.14,152.361z M1385.457,187.194l-0.907-9.521c0.262-0.708,0.533-1.413,0.813-2.12 c0.662,0.683,1.298,1.385,1.911,2.1L1385.457,187.194z M1387.841,174.679c-0.531-0.424-1.071-0.839-1.62-1.246 c0.965-2.285,2.017-4.548,3.143-6.753L1387.841,174.679z M1389.648,189.289l0.698-7.679c0.479,0.679,0.943,1.359,1.381,2.035 L1389.648,189.289z M1395.934,191.384l0.038-0.19c0.013,0.027,0.025,0.053,0.038,0.08L1395.934,191.384z M1393.247,179.52 c-0.798-0.795-1.634-1.586-2.496-2.366l1.413-15.546c0.125-0.212,0.249-0.426,0.376-0.637c1.811,2.361,3.375,4.966,4.723,7.649 L1393.247,179.52z M1399.396,186.384c-0.618-0.768-1.279-1.565-1.985-2.383l2.082-10.412c1.181,2.929,2.135,5.823,2.891,8.479 L1399.396,186.384z M1403.947,192.517h-0.025c-0.378-0.564-0.852-1.252-1.417-2.042l1.3-2.786c0.381,1.72,0.655,3.17,0.844,4.267 L1403.947,192.517z M1400.6,168.053l1.931-9.653c2.154,6.07,3.6,12.066,4.544,16.892l-1.494,2.158 C1404.328,174.62,1402.68,171.337,1400.6,168.053z M1406.992,180.857l0.784-1.68c0.658,3.981,0.893,6.516,0.893,6.516 S1408.125,183.778,1406.992,180.857z M1412.345,177.215c0,0-0.512-1.796-1.482-4.653l1.779-3.813L1412.345,177.215z M1445.921,156.81c1.42,3.147,2.689,6.416,3.83,9.716c-2.203,1.13-4.288,2.425-6.228,3.786c-0.937-2.014-1.996-4.085-3.204-6.184 C1442.034,161.65,1443.906,159.163,1445.921,156.81z M1432.897,137.546c4.007,3.623,7.424,8.414,10.332,13.807 c-2.501,1.984-4.846,4.164-7.008,6.41c-2.25-3.146-4.847-6.275-7.861-9.273C1429.683,144.686,1431.195,140.946,1432.897,137.546z M1428.325,148.588c2.782,3.043,5.09,6.482,6.997,10.121c-8.807,9.435-14.325,19.514-14.325,19.514 S1423.32,163.021,1428.325,148.588z M1429.254,183.637c0,0,3.594-8.173,9.478-17.154c0.727,1.984,1.367,3.98,1.922,5.966 C1433.699,177.931,1429.254,183.637,1429.254,183.637z M1436.733,191.469c-0.121-0.129-0.253-0.258-0.378-0.388l5.675-1.792 l-5.532,1.229c1.545-1.711,3.819-4.114,6.58-6.73c0.298,1.923,0.529,3.762,0.711,5.499 C1440.781,189.617,1438.377,190.584,1436.733,191.469z M1450.685,189.735c-0.318-0.075-0.629-0.135-0.94-0.194 c-0.42-2.281-1.167-5.609-2.439-9.568c1.504-1.283,3.101-2.559,4.755-3.788C1451.628,182.009,1451.068,186.806,1450.685,189.735z M1449.227,153.212c1.039-1.046,2.112-2.03,3.206-2.957c0.14,2.397,0.222,4.802,0.253,7.183 C1451.584,156.034,1450.431,154.622,1449.227,153.212z M1462.723,172.018c-0.346-0.574-0.705-1.158-1.074-1.751 c0.799-0.384,1.602-0.734,2.407-1.058C1463.602,170.126,1463.157,171.06,1462.723,172.018z M1458.146,163.342 c-0.455-4.831-1.22-10.105-2.473-15.562c2.983-2.042,6.117-3.524,9.359-4.116c1.857,5.533,3.118,11.293,3.971,16.748 c-0.46,0.728-0.921,1.48-1.384,2.256C1464.384,162.313,1461.205,162.601,1458.146,163.342z M1468.969,183.489 c-0.601-1.245-1.367-2.769-2.293-4.51c0.627-3.793,1.741-7.718,3.056-11.472c0.062-0.011,0.124-0.014,0.186-0.025 c0.557,5.379,0.751,10.137,0.799,13.628C1470.091,181.891,1469.508,182.684,1468.969,183.489z M1478.496,165.844 c2.262,0.853,4.378,1.82,6.345,2.881c-0.583,0.389-1.168,0.786-1.755,1.199c-1.437-1.272-2.883-2.35-4.332-3.265 C1478.67,166.391,1478.583,166.117,1478.496,165.844z M1479.203,168.154c1.26,0.459,2.486,1.095,3.673,1.92 c-0.875,0.62-1.752,1.263-2.621,1.932C1479.947,170.786,1479.597,169.499,1479.203,168.154z M1482.52,184.805 c0,0-0.141-2.3-0.832-6.175c1.077-1.372,2.204-2.71,3.351-4.027C1483.781,180.774,1482.52,184.805,1482.52,184.805z M1494.385,187.178c0,0,0.602-4.334,0.4-11.456c1.512,1.354,2.883,2.736,4.122,4.115 C1496.439,184.484,1494.385,187.178,1494.385,187.178z M1508.75,179.865l-0.125-0.063c1.041-4.821,1.831-10.652,1.82-17.196 l3.614,5.622C1511.99,172.135,1510.212,176.167,1508.75,179.865z M1525.121,176.264c-0.277,0.216-0.553,0.44-0.828,0.68 c0.164-0.027,0.306-0.034,0.468-0.058c-0.443,0.76-0.865,1.51-1.266,2.25l-0.483-0.628c0.495-5.045,0.485-11.175-1.475-18.263 c0.826-1.623,1.783-3.158,2.903-4.573l2.85,17.099C1526.527,173.953,1525.8,175.12,1525.121,176.264z M1533.883,163.341 c-1.591,2.129-3.111,4.247-4.536,6.333l-4.325-14.705c1.851-2.168,4.102-4.024,6.815-5.466c0.7,0.709,1.383,1.435,2.047,2.178 V163.341z M1558.768,164.782c-1.768,0.731-3.577,1.539-5.382,2.422l1.382-6.908c0.525-0.075,1.05-0.147,1.568-0.183 c0.678,0.383,1.323,0.793,1.936,1.229C1558.447,162.506,1558.613,163.653,1558.768,164.782z M1554.793,160.167l0.156-0.779 c0.375,0.179,0.744,0.364,1.101,0.559C1555.633,160.005,1555.213,160.087,1554.793,160.167z M1557.884,158.856 c-0.864-0.342-1.76-0.584-2.677-0.761l1.348-6.741C1557.049,153.891,1557.49,156.402,1557.884,158.856z M1534.79,152.714 c1.293,1.513,2.515,3.083,3.669,4.698c-0.972,1.223-1.931,2.449-2.872,3.676L1534.79,152.714z M1537.257,178.62l-0.113-1.188 c0.308,0.102,0.616,0.203,0.907,0.32C1537.777,178.036,1537.518,178.328,1537.257,178.62z M1537.982,173.775 c1.34-3.546,2.821-6.989,4.396-10.302c0.053,0.091,0.108,0.181,0.162,0.272l-2.086,10.952 C1539.635,174.329,1538.811,174.02,1537.982,173.775z M1542.264,189.289l0.528-5.803c0.356-0.435,0.722-0.862,1.089-1.286 c0.231,0.315,0.429,0.652,0.633,0.985L1542.264,189.289z M1543.757,172.872l0.543-5.979c0.742,1.397,1.434,2.8,2.096,4.201 C1545.498,171.667,1544.613,172.256,1543.757,172.872z M1550.44,181.933l0.149-0.744c0.169,0.465,0.337,0.929,0.498,1.387 C1550.873,182.359,1550.657,182.145,1550.44,181.933z M1552.806,160.676l-2.851,7.739c-1.535-2.263-3.247-4.588-5.163-6.929 l0.315-3.466c3.061-5.824,6.321-11.149,9.45-15.822c0.7,2.862,1.329,5.742,1.891,8.595l-2.619,7.108 c-0.909-0.085-1.836-0.109-2.795-0.011c0.869,0.248,1.693,0.536,2.485,0.852l-0.697,1.891c-0.307,0.085-0.612,0.15-0.92,0.248 C1552.206,160.795,1552.504,160.748,1552.806,160.676z M1553.09,173.333c2.073-1.69,4.16-3.237,6.192-4.63 c0.268,2.165,0.498,4.232,0.697,6.174l-1.282,1.852c-1.211-0.045-2.42-0.009-3.623,0.096 C1554.464,175.7,1553.805,174.534,1553.09,173.333z M1556.597,179.761c-0.389-0.781-0.805-1.588-1.25-2.423 c0.957-0.018,1.905,0.028,2.845,0.12L1556.597,179.761z M1560.655,189.243c-0.438-1.257-1.181-3.234-2.287-5.727l2.021-4.331 c0.384,4.364,0.587,7.765,0.686,9.722L1560.655,189.243z M1565.561,161.496c0.344,0.126,0.687,0.257,1.027,0.397 c-0.281,0.093-0.572,0.191-0.861,0.289C1565.672,161.954,1565.618,161.727,1565.561,161.496z M1570.043,168.236 c-0.104,0.058-0.209,0.102-0.313,0.161c0.102-0.056,0.208-0.095,0.311-0.15c-0.101,0.522-0.198,1.047-0.291,1.575 c-0.95-1.455-1.972-2.845-3.06-4.138l0.718-1.538l-0.906,1.309c-0.005-0.006-0.011-0.013-0.016-0.019 c-0.081-0.364-0.168-0.739-0.253-1.11c0.892-0.515,1.736-0.982,2.548-1.422c0.729,0.375,1.448,0.775,2.153,1.209 C1570.612,165.462,1570.313,166.837,1570.043,168.236z M1571.35,162.423c-0.304-0.136-0.605-0.275-0.913-0.402 c0.407-0.211,0.793-0.409,1.168-0.598C1571.518,161.753,1571.435,162.09,1571.35,162.423z M1579.132,151.232 c0.822,1.571,1.514,3.166,2.093,4.771c-0.822-0.842-1.663-1.677-2.523-2.498C1578.84,152.738,1578.984,151.981,1579.132,151.232z M1578.305,155.835c1.59,1.874,3.088,3.807,4.485,5.749c0.121,0.577,0.241,1.154,0.338,1.729c-1.938,0.411-3.897,0.974-5.87,1.678 C1577.454,161.933,1577.824,158.843,1578.305,155.835z M1578.848,182.106c-1.313-3.888-1.792-8.473-1.74-13.272 c1.653,1.506,3.208,3.117,4.659,4.776C1580.368,176.429,1579.334,179.286,1578.848,182.106z M1583.491,170.462 c-1.886-1.658-3.949-3.275-6.166-4.736c2.004-0.368,4.043-0.497,6.096-0.44c0.199,1.579,0.318,3.14,0.367,4.671 C1583.686,170.124,1583.591,170.294,1583.491,170.462z M1587.246,162.649c-0.323-0.382-0.656-0.769-0.991-1.157 c-1.473-5.166-3.498-10.138-6.262-14.313c1.927-8.475,4.161-14.986,4.508-15.978l4.33,15.725c-0.453,0.062-0.9,0.1-1.357,0.177 c0.461-0.065,0.913-0.087,1.37-0.131l3.315,12.038c-1.013,1.111-2.008,2.259-2.975,3.437 C1588.543,162.493,1587.894,162.573,1587.246,162.649z M1591.124,190.507c-0.033-0.025-0.065-0.049-0.098-0.075l0.124-0.039 C1591.14,190.433,1591.133,190.468,1591.124,190.507z M1591.232,190.048l-0.555,0.123c-0.173-0.128-0.36-0.264-0.542-0.398 c-0.033-1.469-0.097-3.147-0.204-4.985c0.688,1.114,1.302,2.158,1.845,3.114C1591.574,188.655,1591.39,189.376,1591.232,190.048z M1593.776,181.596c-0.929-1.231-2.198-2.826-3.77-4.607c0.311-0.765,0.618-1.529,0.95-2.297c1.304,2.407,2.356,4.516,3.118,6.118 C1593.975,181.072,1593.872,181.336,1593.776,181.596z M1593.097,170.044c0.443-0.913,0.882-1.827,1.35-2.734l2.091,7.593 C1596.538,174.903,1595.27,172.974,1593.097,170.044z M1598.449,170.037l-0.556-1.609c0.188,0.072,0.373,0.148,0.56,0.221 C1598.442,169.541,1598.449,170.037,1598.449,170.037z M1598.679,162.731c-0.539-0.069-1.081-0.127-1.627-0.179 c0.608-1.061,1.224-2.116,1.862-3.152C1598.817,160.592,1598.74,161.708,1598.679,162.731z M1599.745,151.511 c-1.872,1.671-3.832,3.541-5.774,5.559l-3.534-10.233c3.414-0.151,6.689,0.271,9.811,1.124 C1600.062,149.176,1599.895,150.362,1599.745,151.511z"/>',
		);

		$ret['grass-bend'] = array(
		'name' => __( 'Grass Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M472.977,87.014c1.946-3.252,4.037-6.414,6.27-9.475
	c0.912,0.648,2.195,0.433,2.885-0.476c7.836-10.327,17.323-19.435,28.183-26.909c0.956-0.658,1.229-1.972,0.603-2.953
	c1.209-0.805,2.435-1.59,3.676-2.355c0.122-0.496,0.247-0.993,0.376-1.49c-1.573,0.952-3.12,1.936-4.643,2.951
	c-0.649-0.984-2.019-1.23-3.028-0.528c-11.282,7.84-21.124,17.372-29.239,28.164c-0.726,0.966-0.557,2.316,0.355,2.986
	c-1.933,2.655-3.75,5.391-5.469,8.188c-0.025-6.081,0.388-12.154,1.246-18.168c1.109,0.144,2.141-0.647,2.325-1.774
	c2.074-12.796,6.178-25.29,12.261-36.987c0.536-1.03,0.16-2.318-0.854-2.891c0.69-1.278,1.404-2.547,2.141-3.805
	C489.942,20.997,489.82,20.5,489.7,20c-0.942,1.579-1.847,3.174-2.715,4.785c-1.035-0.564-2.36-0.139-2.922,0.954
	c-6.285,12.217-10.502,25.253-12.604,38.591c-0.188,1.193,0.595,2.306,1.715,2.47c-0.936,6.598-1.335,13.266-1.215,19.938
	c-8.267,13.917-13.874,29.457-16.297,45.856c0.321,0.048,0.642,0.095,0.963,0.143c2.336-15.709,7.624-30.616,15.38-44.047
	c0.429,12.805,2.807,25.604,7.195,37.944c0.306-0.109,0.612-0.217,0.918-0.326C475.589,113.533,473.234,100.265,472.977,87.014z"/>
<path class="gambit_sep_decor1" d="M1414.824,27.861c-2,1.643-3.958,3.325-5.875,5.045
	c-1.102-1.24-3.06-1.308-4.324-0.127c-14.142,13.191-25.937,28.45-35.072,45.116c-0.817,1.491-0.31,3.338,1.096,4.089
	c-13.218,25.021-20.41,53.147-20.509,82.126l1.371,0.005c0.124-28.748,7.284-56.642,20.417-81.449
	c1.4,0.719,3.145,0.162,3.924-1.243c8.84-15.963,20.226-30.559,33.853-43.155c1.2-1.109,1.315-2.994,0.246-4.236
	c1.523-1.364,3.073-2.705,4.648-4.02C1414.67,29.297,1414.745,28.58,1414.824,27.861z"/>
<path class="gambit_sep_decor1" d="M1347.063,82.704c1.56,0.225,3.048-0.965,3.275-2.65
	c2.534-18.835,2.126-38.107-1.364-57.098c-0.311-1.699-1.908-2.801-3.513-2.452c-0.513-2.519-1.081-5.033-1.705-7.539
	c-0.359,0.627-0.722,1.249-1.087,1.868c0.48,1.992,0.924,3.988,1.333,5.988c-1.58,0.369-2.597,1.957-2.295,3.561
	c3.431,18.208,3.903,36.703,1.548,54.797c-0.206,1.594,0.853,3.073,2.39,3.321c-1.398,9.369-3.561,18.614-6.436,27.653
	c-0.379-7.697-1.33-15.352-2.849-22.899c1.33-0.275,2.187-1.677,1.876-3.109c-3.477-16.01-9.467-31.509-17.872-45.875
	c-0.751-1.286-2.369-1.71-3.568-0.956c-1.155-1.891-2.354-3.761-3.596-5.609c-0.107,0.613-0.218,1.224-0.332,1.833
	c0.974,1.473,1.92,2.961,2.839,4.461c-1.172,0.763-1.53,2.349-0.814,3.56c8.127,13.749,13.941,28.6,17.346,43.956
	c0.301,1.352,1.594,2.24,2.912,1.99c1.731,8.561,2.718,17.264,2.967,26.009c-5.619,16.522-13.694,32.29-24.121,46.721
	c0.364,0.268,0.729,0.537,1.093,0.806c9.768-13.492,17.485-28.151,23.087-43.5c0.031,14.155-1.886,28.38-5.849,42.259
	c0.374,0.111,0.748,0.221,1.122,0.332c4.317-15.069,6.255-30.548,5.905-45.908C1342.873,103.962,1345.457,93.412,1347.063,82.704z"
	/>
<path class="gambit_sep_decor1" d="M454.494,27.168c0.268-1.323,0.545-2.645,0.83-3.965
	c-0.255-0.4-0.509-0.801-0.762-1.203c-0.362,1.653-0.711,3.308-1.047,4.966c-1.078-0.22-2.143,0.501-2.36,1.604
	c-2.427,12.353-4.144,24.82-5.148,37.341c-0.09,1.118,0.741,2.099,1.838,2.178c-1.395,18.844-1.165,37.802,0.7,56.663
	c0.332-0.033,0.663-0.066,0.995-0.098c-1.86-18.805-2.089-37.707-0.698-56.494c1.084,0.062,2.031-0.764,2.118-1.852
	c0.989-12.333,2.68-24.613,5.07-36.78C456.242,28.455,455.554,27.402,454.494,27.168z"/>
<path class="gambit_sep_decor1" d="M1391.134,15.865c1.266-2.385,2.547-4.762,3.843-7.132
	c-0.261-0.912-0.521-1.825-0.778-2.74c-1.633,2.964-3.242,5.941-4.829,8.928c-1.942-1.034-4.395-0.255-5.437,1.737
	c-11.669,22.311-22.042,45.244-31.078,68.684c-0.807,2.093,0.229,4.445,2.288,5.221c-13.376,35.345-23.702,71.831-30.836,109.06
	c0.655,0.125,1.31,0.251,1.964,0.376c7.113-37.118,17.408-73.495,30.745-108.734c2.044,0.735,4.328-0.311,5.114-2.348
	c8.9-23.088,19.118-45.677,30.611-67.653C1393.756,19.325,1393.035,16.915,1391.134,15.865z"/>
<path class="gambit_sep_decor1" d="M1532.539,68.583c-0.833-2.121-1.68-4.237-2.539-6.348
	c0.297-0.744,0.592-1.489,0.886-2.235c1.085,2.642,2.149,5.291,3.193,7.948c1.695-0.695,3.651,0.181,4.334,1.952
	c7.651,19.825,14.178,40.058,19.555,60.597c0.48,1.834-0.584,3.72-2.353,4.187c3.985,15.605,7.302,31.384,9.944,47.292
	c0.232-11.551-0.025-23.103-0.776-34.623c-1.294,0.066-2.417-0.946-2.511-2.27c-1.069-15.007-2.978-29.957-5.72-44.775
	c-0.242-1.308,0.588-2.583,1.856-2.858c-0.308-1.611-0.627-3.221-0.955-4.829c0.308-0.484,0.614-0.97,0.92-1.457
	c0.417,2.014,0.819,4.03,1.205,6.049c1.288-0.258,2.553,0.628,2.802,1.972c2.785,15.044,4.722,30.221,5.808,45.458
	c0.097,1.36-0.903,2.546-2.213,2.634c0.889,13.634,1.075,27.312,0.591,40.98c2.099,13.579,3.709,27.247,4.818,40.978
	c-0.552,0.047-1.104,0.093-1.655,0.14c-0.875-10.842-2.07-21.643-3.566-32.393c-0.365,6.407-0.865,12.81-1.533,19.202
	c-0.396-0.043-0.791-0.085-1.187-0.128c0.876-8.378,1.484-16.773,1.837-25.173c-2.822-18.785-6.581-37.402-11.272-55.776
	c-1.753,0.434-3.546-0.652-4.014-2.437c-5.297-20.23-11.725-40.159-19.261-59.687C1530.067,71.259,1530.876,69.296,1532.539,68.583
	z"/>
<path class="gambit_sep_decor1" d="M113.316,44.306c0.166-2.306,0.345-4.611,0.539-6.916
	c-0.52-0.624-1.04-1.249-1.558-1.876c-0.252,2.887-0.482,5.775-0.689,8.664c-1.879-0.137-3.53,1.322-3.656,3.243
	c-1.411,21.512-1.592,43.062-0.551,64.547c0.093,1.918,1.719,3.402,3.599,3.297c1.766,32.31,6.314,64.457,13.621,96.08l1.669-0.385
	c-7.285-31.529-11.819-63.58-13.58-95.794c1.855-0.132,3.282-1.742,3.191-3.61c-1.417-29.228-0.352-49.943,0.543-63.578
	C116.567,46.108,115.168,44.47,113.316,44.306z"/>
<path class="gambit_sep_decor1" d="M123.857,209.58c-12.762-35.574-22.406-72.129-28.853-109.251
	c2.134-0.407,3.568-2.47,3.208-4.623c-2.591-15.484-6.279-39.383-8.067-73.816c-0.113-2.186-1.96-3.894-4.131-3.831
	c-0.123-2.697-0.23-5.395-0.32-8.095C85.004,9.311,84.317,8.656,83.63,8c0.102,3.383,0.231,6.764,0.386,10.143
	c-2.198,0.098-3.914,2.016-3.797,4.261c1.306,25.144,4.043,50.165,8.19,74.942c0.37,2.212,2.459,3.71,4.626,3.331
	c5.779,33.274,14.127,66.091,24.97,98.16c-11.315-25.772-20.743-52.3-28.205-79.379c1.85-0.543,2.94-2.489,2.437-4.361
	c-5.706-21.211-10.205-42.754-13.47-64.525c-0.288-1.921-2.066-3.272-3.979-3.03c-0.341-2.372-0.667-4.747-0.979-7.125
	c-0.665-0.517-1.329-1.036-1.992-1.557c0.381,2.98,0.785,5.956,1.212,8.929c-1.933,0.275-3.284,2.118-2.988,4.091
	c3.314,22.103,7.882,43.974,13.675,65.509c0.517,1.923,2.491,3.067,4.373,2.546c8.913,32.341,20.609,63.903,34.984,94.328
	c0.535-0.253,1.07-0.506,1.605-0.758c-0.568-1.202-1.124-2.409-1.684-3.615C123.282,209.786,123.569,209.683,123.857,209.58z"/>
<path class="gambit_sep_main" d="M1621.619,132.356c-2.773,5.203-5.051,10.387-6.889,15.171
	c-3.174-1.046-6.54-1.785-10.094-2.149c-1.147-8.112-2.311-16.224-3.491-24.336c0.207,2.624,0.413,5.247,0.618,7.871
	c-0.591,0.596-4.59,4.698-9.383,11.34c-2.496-4.352-6.027-7.888-10.93-9.987c4.227,4.005,7.166,8.245,9.144,12.535
	c-0.66,0.968-1.328,1.977-1.998,3.029c-4.193-5.16-8.968-9.621-14.047-11.861c5.205,3.091,9.58,7.849,13.204,13.202
	c-1.485,2.398-2.964,4.993-4.378,7.755c-1.078,0.075-2.307,0.177-3.644,0.311c-0.986-0.563-2.007-1.069-3.053-1.525
	c-0.42-7.029-1.362-15.178-3.362-23.727c8.924-8.244,15.803-12.945,15.801-12.946c0.001,0.001-6.934,4.434-16.242,11.095
	c-1.942-7.746-4.786-15.768-8.913-23.532c2.959,7.587,4.516,16.805,5.207,26.214c-3.077,2.249-6.321,4.685-9.61,7.246
	c0.475-1.636,0.95-3.272,1.425-4.908c-0.743,1.844-1.485,3.688-2.227,5.532c-2.307,1.807-4.625,3.671-6.913,5.568
	c-1.299-1.927-2.721-3.857-4.254-5.773c0.23-2.581,0.46-5.162,0.69-7.743c-0.438,2.323-0.876,4.647-1.314,6.97
	c-2.722-3.324-5.805-6.598-9.318-9.718c2.777,2.547,5.194,5.406,7.321,8.453c-2.684,0.303-5.354,1.31-7.949,2.848
	c-0.159-1.451-0.318-2.903-0.478-4.354c-0.022,1.565-0.045,3.13-0.067,4.695c-1.387,0.862-2.751,1.865-4.085,2.978
	c-1.208-8.256-4.737-18.069-12.547-29.583c8.103,13,8.082,26.093,5.962,36.114c-0.511,0.586-1.013,1.181-1.508,1.783
	c-1.037-1.969-2.077-3.937-3.118-5.906c1.292-7.394,1.677-15.887,0.203-25.201c0.289,15.135-5.92,27.651-11.592,35.949
	c-1.8-1.815-3.845-3.699-6.112-5.534c0.15-1.53,0.273-3.151,0.363-4.851c2.132-1.238,4.26-2.341,6.348-3.26
	c-0.447-0.227-2.846,0.181-6.256,1.17c0.309-9.002-0.393-20.016-3.576-32.011c1.693,11.313-1.103,23.893-4.333,33.733
	c-2.541-1.512-5.257-2.868-8.141-3.96c-0.449-2.782-1.05-5.753-1.84-8.868c3.41-4.721,6.107-7.819,6.107-7.819
	s-2.772,1.974-6.699,5.592c-0.977-3.515-2.206-7.186-3.74-10.945c1.755,0.316,3.491,0.869,5.186,1.768
	c-1.788-1.036-3.602-1.805-5.431-2.372c-1.911-4.597-4.277-9.316-7.224-14.033c1.827,4.145,3.072,8.651,3.899,13.255
	c-3.419-0.578-6.857-0.465-10.244,0.174c-0.6-6.068-1.796-12.381-3.872-18.658c1.189,5.818,1.331,12.515,0.854,19.362
	c-2.358,0.657-4.677,1.538-6.935,2.59c-3.223-4.743-6.936-9.456-11.189-13.874c0.755-1.022,1.525-2.004,2.312-2.932
	c-3.709,3.719-7.049,7.576-9.992,11.319c-0.128-0.161-0.246-0.323-0.376-0.483c0.128,0.163,0.24,0.334,0.365,0.498
	c-9.956,12.668-15.404,23.984-15.408,23.982c2.075-16.258,4.144-32.517,6.207-48.777c-2.749,14.136-5.492,28.273-8.23,42.41
	c-1.014,1.044-2.027,2.089-3.04,3.133c-0.877-4.519-2.317-10.788-4.486-17.166c0.589-1.589,1.179-3.178,1.769-4.767
	c-0.707,1.25-1.412,2.499-2.118,3.749c-2.963-8.426-7.215-16.875-13.096-21.525c6.092,6.162,9.6,15.225,11.598,24.18
	c-1.523,2.702-3.044,5.405-4.563,8.109c-1.182-2.244-2.554-4.452-4.135-6.526c2.166-2.437,4.401-4.678,6.667-6.594
	c-0.581-0.111-3.493,1.375-7.305,3.956c1.09-4.397,2.183-8.794,3.276-13.19c-1.586,4.428-3.168,8.856-4.747,13.286
	c-2.389-2.622-5.189-4.891-8.455-6.543c0.146-2.886,0.29-5.773,0.435-8.66c-0.41,2.76-0.82,5.52-1.23,8.28
	c-2.192-1.018-4.577-1.771-7.191-2.153c1.543-4.247,2.777-6.998,2.777-6.998s-2.438,3.137-5.471,8.438
	c-0.145-0.971-0.289-1.942-0.434-2.912c0.029,1.176,0.057,2.352,0.086,3.529c-1.904,3.381-4.008,7.57-5.882,12.352
	c-2.02-0.35-4.117-0.44-6.282-0.256c-0.458-0.793-0.916-1.587-1.374-2.38c-0.719-3.185-1.607-6.551-2.711-10.016
	c0.461,0.02,0.916,0.021,1.387,0.068c-0.486-0.084-0.95-0.124-1.427-0.193c-0.161-0.502-0.319-1.003-0.489-1.508
	c6.555-5.386,15.485-10.142,27.677-13.146c-8.844-0.939-19.361,3.176-29.205,8.902c-2.47-6.435-5.745-13.024-10.111-19.248
	c3.223,5.963,5.486,13.391,7.065,21.082c-1.869,1.162-3.701,2.366-5.485,3.596c-5.062,0.465-9.551,1.815-13.494,3.78
	c-1.433-1.307-2.952-2.586-4.56-3.827c0.496-2.045,0.984-4.234,1.457-6.582c0.796-0.735,1.592-1.471,2.424-2.206
	c-0.745,0.363-1.483,0.745-2.213,1.144c1.571-8.086,2.901-17.912,3.498-29.494c4.719-4.846,9.901-9.528,15.597-13.88
	c-5.362,3.055-10.556,6.924-15.479,11.215c0.156-3.853,0.235-7.88,0.208-12.107c-0.412,4.667-1.238,9.375-2.371,14.034
	c-10.922,9.953-20.345,21.809-27.065,31.27c-1.309-3.504-3.027-6.725-5.264-9.44c2.004-10.349,4.609-24.526,7.943-43.885
	c-1.839,10.874-6.962,25.624-12.504,39.657c-0.407-0.286-0.82-0.565-1.249-0.825c-2.037-3.264-4.403-6.503-7.178-9.615
	c1.413,2.386,2.636,5.055,3.699,7.921c-0.224-0.086-0.43-0.193-0.658-0.272c0.286,0.236,0.539,0.482,0.814,0.721
	c0.885,2.439,1.653,5.014,2.319,7.69c-2.616,6.414-5.241,12.525-7.602,17.884c-0.876-1.04-1.807-1.998-2.805-2.843
	c1.17-8.203,1.919-18.957,1.47-32.648c-0.972,9.488-3.103,18.925-5.65,27.578c-1.262,0.12-2.778,0.32-4.473,0.598
	c1.256-10.838,4.057-23.593,9.635-37.715c0.227,3.326,0.388,6.506,0.488,9.538c0.412-4.032,0.616-8.073,0.548-12.067
	c0.309-0.744,0.602-1.482,0.926-2.234c-0.326,0.398-0.634,0.814-0.95,1.222c-0.203-7.141-1.284-14.117-3.59-20.598
	c1.144,8.004,1.928,15.361,2.438,22.129c-8.954,12.386-13.554,28.5-15.928,41.006c-1.368,0.318-2.785,0.678-4.232,1.077
	c-0.328-7.131-0.38-15.971,0.304-25.868c0.398-0.359,0.622-0.555,0.622-0.555c-0.001,0-0.216,0.114-0.608,0.333
	c1.446-20.477,6.046-45.492,18.298-69.384c-15.278,21.719-22.016,54.695-24.817,73.435c-1.274,0.858-2.672,1.837-4.167,2.94
	c-2.532-10.708-7.537-30.57-17.965-66.066c5.646,18.933,7.568,51.721,8.175,74.131c-0.989,0.909-1.984,1.856-2.98,2.841
	c-1.159-4.207-2.717-9.038-4.83-14.535c1.792-11.224,2.482-24.194,0.058-37.445c0.545,8.765-1.073,18.904-3.607,28.85
	c-2.012-4.589-4.373-9.541-7.144-14.863c2.394,6.622,4.257,13.452,5.7,20.186c-1.999,6.954-4.341,13.667-6.601,19.585
	c-2.916,0.515-5.668,1.279-8.234,2.229c-0.195-3.497-0.603-7.335-1.33-11.405c3.973-2.742,8.48-5.017,13.555-6.39
	c-4.804,0.831-9.46,2.738-13.788,5.18c-1.712-8.886-4.966-18.786-10.929-28.541c5.481,9.303,7.408,20.195,7.579,30.573
	c-7.057,4.586-12.995,10.329-16.946,14.624c-0.834-1.044-1.713-2.092-2.683-3.142c0.745,1.273,1.407,2.571,2.011,3.879
	c-0.759,0.84-1.434,1.614-2.016,2.298c-0.621-0.209-1.242-0.398-1.864-0.557c2.373-12.771,4.757-25.54,7.152-38.308
	c-3.668,12.536-7.313,25.077-10.936,37.622c-0.089-0.01-0.178-0.017-0.268-0.025c-0.569-2.417-3.243-12.781-10.13-24.84
	c3.597-1.741,7.622-2.689,12.113-2.442c-4.92-0.628-9.379-0.492-13.43,0.207c-1.365-2.253-2.877-4.549-4.551-6.85
	c1.308,2.21,2.423,4.604,3.361,7.082c-5.71,1.168-10.564,3.483-14.662,6.452c-3.785-3.139-8.08-6.064-12.848-8.403
	c3.323-2.438,5.533-3.756,5.533-3.756c0.001,0-2.814,1.074-6.946,3.077c-2.516-1.149-5.157-2.127-7.919-2.881
	c-0.071-0.514-0.151-1.04-0.228-1.562c0.304-0.174,0.611-0.357,0.915-0.525c-0.17-0.068-0.511-0.062-0.992,0.008
	c-0.058-0.384-0.111-0.762-0.172-1.15c0.025,0.389,0.056,0.777,0.072,1.168c-0.735,0.117-1.786,0.382-3.089,0.786
	c-1.9-4.027-4.404-7.563-7.666-10.225c6.432-14.595,13.039-24.218,13.038-24.217c0.001,0-7.14,9.731-15.28,22.606
	c-1.614-1.011-3.371-1.849-5.32-2.433c1.635,1.232,3.097,2.517,4.437,3.834c-3.81,6.077-7.782,12.774-11.335,19.441
	c-2.756-1.964-5.904-3.142-9.49-3.061c3.297,1.201,5.973,2.871,8.126,4.871c-3.669,2.158-7.352,4.571-10.82,7.209
	c-1.506-4.664-3.964-9.737-7.995-15.05c7.184-15.555,16.337-28.31,16.339-28.308c0.003,0-10.188,8.791-20.493,23.382
	c-3.655-3.935-8.242-7.965-13.994-12.017c5.598,4.271,9.63,9.157,12.498,14.175c-5.12,7.529-10.145,16.45-13.88,26.383
	c-0.052-0.018-0.106-0.034-0.159-0.052c0.767-8.746,1.982-23.823,0.373-41.324c0.399,0.273,0.781,0.545,1.168,0.817
	c-0.384-0.293-0.774-0.583-1.173-0.869c-1.301-14.07-4.45-29.691-11.217-44.812c7.729,24.793,3.484,61.788-0.054,83.551
	c-2.029-0.293-4.105-0.471-6.21-0.514c-0.167-0.694-0.345-1.402-0.533-2.124c1.202-2.159,2.406-4.317,3.611-6.475
	c-1.337,1.654-2.674,3.309-4.008,4.965c-1.475-5.388-3.535-11.456-6.386-17.822c0.223-0.822,0.445-1.645,0.668-2.467
	c-0.297,0.659-0.594,1.319-0.891,1.978c-4.861-10.721-11.994-22.262-22.521-32.817c10.503,10.876,16.383,25.271,19.629,39.253
	c-2.074,4.623-4.141,9.247-6.203,13.873c-1.504-0.491-3.066-0.813-4.666-0.98c1.441-9.415,2.888-18.829,4.341-28.242
	c-2.421,9.363-4.828,18.728-7.223,28.095c-1.487-0.003-2.985,0.098-4.481,0.287c-0.167-4.333-0.336-8.666-0.506-13
	c0.125-0.072,0.25-0.144,0.375-0.214c-0.124,0.057-0.254,0.109-0.377,0.167c-0.211-5.363-0.423-10.727-0.638-16.09
	c-0.322,5.626-0.644,11.253-0.966,16.879c-2.295,1.133-4.483,2.329-6.531,3.55c-1.043-4.346-2.089-8.692-3.14-13.037
	c0.882-1.622,1.765-3.244,2.65-4.865c-0.923,1.46-1.845,2.92-2.767,4.381c-0.099-0.41-0.198-0.82-0.298-1.229
	c0.055,0.48,0.11,0.96,0.165,1.44c-3.387,5.369-6.76,10.742-10.122,16.119c-1.491-2.124-2.983-4.247-4.479-6.37
	c0.026-0.699,0.042-1.403,0.046-2.108c3.02-6.496,6.712-12.334,11.179-16.238c-4.239,3.191-8.052,6.799-11.44,10.51
	c-0.385-3.637-1.231-7.045-2.807-9.705c1.395,3.21,1.96,6.857,1.998,10.597c-2.358,2.646-4.499,5.331-6.419,7.948
	c-1.137-4.538-3.39-8.881-7.527-11.877c1.583-5.162,3.679-10.199,6.466-14.476c-6.712,7.725-11.229,15.989-14.261,23.296
	c-0.797-0.782-1.661-1.491-2.59-2.126c2.466-3.092,5.179-6.23,8.164-9.388c-3.745,2.253-7.237,5.014-10.467,8.053
	c-0.976-0.467-2.012-0.854-3.12-1.139c1.086,0.341,2.085,0.761,3.008,1.246c-1.252,1.182-2.462,2.405-3.631,3.659
	c-0.12-4.037-0.003-8.307,0.524-12.505c1.248-0.195,2.529-0.325,3.869-0.323c-1.304-0.096-2.573-0.138-3.81-0.136
	c0.438-3.297,1.13-6.539,2.174-9.571c-1.514,3.273-2.777,6.499-3.842,9.634c-1.378,0.052-2.716,0.159-4.01,0.326
	c7.492-14.239,17.94-29.564,32.388-42.795c-15.682,10.88-29.077,29.308-38.001,43.923c-1.471,0.409-2.892,0.876-4.237,1.428
	c0.103-2.98,0.451-6.062,1.143-9.211c-1.201,3.392-2.083,6.71-2.719,9.919c-1.298,0.604-2.555,1.254-3.734,1.975
	c1.21-10.733,2.875-27.469,5.006-53.22c-1.169,14.597-7.472,36.507-13.243,54.428c-1.743-1.827-3.637-3.198-5.684-3.875
	c2.174,1.293,3.924,2.977,5.347,4.92c-0.9,2.777-1.784,5.447-2.635,7.973c-0.87,1.125-1.681,2.269-2.434,3.426
	c-0.487,0.183-0.976,0.372-1.467,0.566c0.596-6.212,0.839-14.248,0.228-24.287c7.967-10.546,14.725-16.98,14.723-16.98
	c0.001,0.001-6.522,5.839-14.908,14.239c-0.25-3.372-0.596-6.959-1.057-10.768c-0.061,4.229-0.348,8.466-0.806,12.646
	c-3.203,3.248-6.61,6.813-10.001,10.534c-3.297-10.346-9.178-19.406-19.497-21.906c4.066,2.738,7.241,5.799,9.737,9.031
	c-6.152,1.665-11.907,5.1-16.94,9.105c-2.742-5.064-6.61-10.507-12.001-16.293c5.112,5.927,8.046,12.233,9.574,18.312
	c-0.464,0.403-0.921,0.808-1.371,1.217c-1.358-0.291-2.771-0.419-4.254-0.305c1.155,0.352,2.214,0.783,3.231,1.248
	c-6.549,6.161-11.348,12.639-13.5,15.748c-0.337-0.174-0.674-0.341-1.013-0.496c1.365-13.009,2.741-26.018,4.127-39.026
	c1.126,1.113,2.191,2.213,3.206,3.302c-0.982-1.139-2.048-2.262-3.198-3.368c0.037-0.344,0.073-0.687,0.11-1.031
	c-0.066,0.316-0.132,0.633-0.198,0.949c-0.548-0.525-1.092-1.051-1.68-1.567c0.574,0.545,1.122,1.085,1.668,1.624
	c-2.626,12.608-5.229,25.219-7.81,37.832c-0.009-0.002-0.018-0.005-0.027-0.007c-0.292-0.956-4.671-15.296-16.383-30.128
	c2.62-2.804,5.786-5.179,9.603-6.959c-3.747,0.905-7.277,2.954-10.562,5.764c-0.463-0.567-0.937-1.134-1.421-1.701
	c0.427,0.606,0.843,1.225,1.24,1.862c-3.968,3.44-7.575,7.989-10.776,12.979c-2.529-1.821-5.267-3.54-8.181-5.079
	c-0.226-9.136-1.696-19.226-5.31-29.852c1.878,9.753,1.488,19.018-0.035,27.352c-5.752-2.354-12.091-3.85-18.901-3.88
	c-1.975-9.196-5.075-19.343-9.92-29.845c3.167,9.515,3.854,20.211,3.387,30.275c-0.404,0.054-0.8,0.085-1.206,0.151
	c0.406-0.055,0.803-0.071,1.204-0.11c-0.258,5.517-0.861,10.837-1.608,15.672c-2.972,0.343-6,0.991-9.067,1.992
	c-0.919-3.187-2.049-6.644-3.428-10.289c2.365-0.907,4.927-1.482,7.72-1.6c-2.902-0.086-5.606,0.092-8.16,0.455
	c-4.715-12.136-12.213-26.254-24.2-39.557c8.228,12.282,12.35,28.228,14.408,42.222c-4.664,1.953-8.566,4.684-11.816,7.841
	c-0.314-0.473-0.631-0.946-0.957-1.426c0.498-2.534,0.998-5.068,1.498-7.601c-0.783,2.122-1.565,4.244-2.345,6.367
	c-0.054-0.078-0.106-0.154-0.159-0.232c1.704-4.891,3.693-9.794,6.034-14.655c-2.674,4.032-5.019,8.485-7.092,13.149
	c-2.212-3.127-4.638-6.358-7.301-9.626c0.034-0.401,0.067-0.802,0.101-1.203c-0.067,0.36-0.134,0.72-0.2,1.08
	c-7.382-9.043-16.5-18.319-27.382-26.162c10.17,8.497,17.63,22.335,23.011,36.761c-2.385-0.892-4.786-1.355-7.185-1.448
	c-0.368-3.364-0.738-6.729-1.108-10.093c0.033,2.637,0.065,5.273,0.098,7.91c-3.846-8.624-9.795-15.682-18.976-17.487
	c8.911,5.455,13.94,12.513,16.619,19.775c-2.25,0.222-4.489,0.738-6.699,1.502c-0.555-1.756-1.111-3.512-1.668-5.268
	c0.341,1.834,0.681,3.668,1.021,5.502c-0.913,0.336-1.82,0.712-2.721,1.126c-0.522-1.718-1.059-3.479-1.613-5.286
	c0.516,1.668,1.004,3.462,1.463,5.354c-2.4,1.114-4.755,2.486-7.043,4.05c-1.191-1.079-2.443-2.033-3.765-2.814
	c-0.014-0.106-0.031-0.214-0.046-0.32c2.561-1.258,5.335-1.78,8.305-1.166c-2.982-0.734-5.811-0.666-8.477-0.044
	c-0.795-5.289-1.983-11.207-3.714-17.72c0.966,5.745,1.025,11.826,0.572,17.71c-2.055-0.687-4.239-0.97-6.559-0.69
	c2.056,0.53,3.878,1.273,5.532,2.157c-2.724,1.298-5.23,3.153-7.493,5.288c-1.571-1.98-3.243-3.857-5.033-5.602
	c1.491,2.168,2.898,4.277,4.264,6.357c-2.44,2.429-4.581,5.153-6.39,7.814c-1.43-1.929-3.074-3.874-4.942-5.754
	c0.853-4.59,2.064-9.301,3.774-13.199c-2.154,3.995-3.892,8.022-5.275,11.746c-1.378-1.273-2.874-2.501-4.484-3.661
	c0.043-0.19,0.095-0.379,0.14-0.569c1.567-0.863,3.128-1.661,4.669-2.368c-0.375-0.185-1.919,0.03-4.22,0.613
	c2.956-10.367,9.88-19.879,24.276-24.035c0.414,1.424,0.804,2.822,1.168,4.193c-0.244-1.449-0.541-2.876-0.908-4.272
	c0.298-0.084,0.57-0.187,0.875-0.267c-0.323-0.021-0.634-0.004-0.954-0.014c-0.576-2.134-1.292-4.2-2.199-6.155
	c0.692,2.104,1.322,4.149,1.909,6.151c-12.95-0.255-22.697,8.899-29.479,19.279c-0.318-1.989-0.637-3.978-0.956-5.967
	c0.204,2.168,0.407,4.336,0.611,6.503c-1.687,2.628-3.199,5.319-4.52,7.95c-1.7,0.669-3.472,1.417-5.276,2.242
	c-2.782-3.144-5.878-5.796-9.128-7.144c3.164,1.791,5.911,4.47,8.269,7.545c-2.182,1.022-4.395,2.149-6.568,3.384
	c-1.436-5.809-2.486-12.964-1.916-20.577c4.195-6.015,7.609-10.023,7.609-10.023c0.001,0-2.935,2.149-7.168,6.087
	c1.928-12.818,8.901-26.496,26.714-36.794c-21.627,4.538-30.54,25.231-34.048,44.244c-3.255,3.606-6.691,7.855-9.902,12.663
	c-1.21-2.253-2.593-4.56-4.166-6.863c0.569-6.556,0.819-14.055,0.28-21.998c1.194-0.607,2.42-1.205,3.702-1.785
	c-1.248,0.096-2.513,0.324-3.786,0.619c-0.635-8.181-2.137-16.804-5.038-25.347c1.672,7.904,1.706,17.225,0.882,26.616
	c-3.75,1.415-7.539,3.51-11.251,6.062c-4.425-3.211-9.534-5.983-15.426-8.015c-1.247-1.768-2.586-3.525-4.032-5.261
	c1.314,1.63,2.5,3.341,3.579,5.111c-5.267-1.771-11.148-2.956-17.708-3.34c-0.657-7.333-1.743-15.434-3.439-24.305
	c0.752,7.908,0.35,16.158-0.725,24.178c-2.348-0.015-4.768,0.059-7.28,0.251c2.499-0.037,4.884,0.146,7.175,0.494
	c-1.112,7.982-2.857,15.696-4.742,22.588c-4.042,4.501-7.47,9.311-10.332,13.955c-0.981,0.24-1.961,0.516-2.942,0.827
	c-1.549-3.807-3.645-8.199-6.437-12.751c1.01-4.21,2.382-8.297,4.252-11.943c-2.229,3.177-4.126,6.397-5.758,9.586
	c-4.021-6.083-9.303-12.312-16.214-17.679c5.429,6.228,9.676,15.185,12.969,24.788c-2.507,6.236-4.04,12.099-4.984,16.971
	c-1.403,1.162-2.79,2.427-4.161,3.805c-2.147-8.981-4.447-22.818-1.776-34.327c-3.948,11.547-5.18,22.29-5.383,30.512
	c-0.281,0.456-0.562,0.912-0.842,1.369c-2.103-0.912-4.328-1.402-6.61-1.543c-0.936-2.575-1.777-5.399-2.414-8.425
	c0.484-3.507,0.97-7.014,1.458-10.521c-0.701,2.294-1.402,4.589-2.1,6.884c-0.596-4.15-0.77-8.607-0.24-13.277
	c-1.768,7.328-2.195,14.195-1.898,20.317c-0.555,1.832-1.11,3.665-1.664,5.498c-0.299,0.055-0.596,0.118-0.894,0.181
	c-1.458-2.56-3.059-5.021-4.779-7.189c0.039-1.502,0.078-3.004,0.117-4.506c0.452-0.365,0.904-0.712,1.357-1.047
	c-0.458,0.285-0.904,0.576-1.352,0.866c0.116-4.435,0.232-8.871,0.351-13.306c-0.604,4.753-1.205,9.506-1.803,14.26
	c-0.413,0.279-0.814,0.561-1.218,0.844c-2.35-2.354-4.878-4.05-7.532-4.632c2.687,1.242,4.856,3.07,6.625,5.278
	c-2.028,1.457-3.936,2.938-5.685,4.392c-0.776-4.64-1.553-9.279-2.332-13.919c0.782-1.988,1.565-3.977,2.349-5.965
	c-0.825,1.749-1.648,3.498-2.47,5.247c-0.259-1.544-0.519-3.089-0.778-4.633c0.127,1.827,0.254,3.653,0.381,5.48
	c-2.071,4.408-4.134,8.818-6.189,13.23c-1.477-3.895-2.957-7.789-4.441-11.682c1.138,4.635,2.273,9.27,3.406,13.905
	c-1.741,3.741-3.476,7.483-5.205,11.226c-0.129-0.142-0.257-0.284-0.386-0.425c0.47-5.58,1.549-24.395-5.1-32.989
	c5.051,8.548,3.942,21.381,2.377,29.989c-0.796-0.876-1.593-1.752-2.39-2.628c-0.991-7.285-3.935-15.961-12.018-19.773
	c1.124-2.05,2.448-4.151,4.046-6.306c-4.698,3.065-8.184,9.13-10.733,15.81c-1.637-1.094-3.45-1.938-5.45-2.449
	c1.568-1.755,3.422-3.319,5.625-4.62c-2.454,0.85-4.708,2.386-6.779,4.37c-0.304-0.056-0.602-0.121-0.913-0.161
	c0.301,0.055,0.583,0.132,0.874,0.199c-3.142,3.024-5.851,7.107-8.14,11.575c-0.681-1.204-1.418-2.455-2.209-3.747
	c1.231-0.562,2.512-1.093,3.905-1.554c-1.592-0.006-3.118,0.156-4.586,0.45c-1.565-2.504-3.344-5.161-5.355-7.95
	c-1.031-4.152-2.456-8.447-4.413-12.825c0.921,3.165,1.502,6.289,1.83,9.342c-1.7-2.228-3.546-4.529-5.553-6.895
	c2.225,3.176,4.152,6.647,5.812,10.237c0.191,4.016-0.047,7.873-0.557,11.491c-4.142,2.668-7.609,6.494-10.478,10.746
	c-1.245-7.813-3.727-17.88-8.665-28.688c2.661-2.933,5.903-5.763,9.81-8.429c1.424,1.572,2.788,3.122,4.077,4.643
	c-1.191-1.699-2.462-3.317-3.832-4.812c0.099-0.067,0.192-0.135,0.292-0.202c-0.126,0.035-0.246,0.076-0.37,0.113
	c-1.143-1.241-2.347-2.404-3.621-3.465c1.146,1.201,2.239,2.385,3.307,3.561c-4.271,1.278-7.906,3.276-10.982,5.812
	c-1.017-2.069-2.115-4.156-3.325-6.257c0.984,2.251,1.774,4.616,2.417,7.039c-2.663,2.37-4.886,5.152-6.739,8.205
	c-1.709,1.016-3.965,2.531-6.503,4.453c-0.413-0.659-0.837-1.321-1.275-1.985c-0.501-8.986-0.281-18.398,1.05-28.014
	c-2.166,7.652-3.151,16.115-3.404,24.61c-3.438-4.764-7.545-9.573-12.471-14.157c5.323,6.606,9.026,14.951,11.611,23.149
	c-3.4,2.88-6.964,6.268-10.173,9.954c-2.83-3.229-6.023-6.565-9.563-9.842c2.68-12.323,6.954-22.7,6.955-22.699
	c0.001,0-5.558,7.667-10.557,19.491c-1.93-1.647-3.955-3.26-6.066-4.82c-0.834-1.199-1.675-2.404-2.547-3.652
	c0.759,1.078,1.524,2.249,2.291,3.46c-2.515-1.848-5.151-3.619-7.913-5.269c4.841,3.384,9.099,8.233,12.819,13.789
	c-0.911,2.369-1.78,4.872-2.571,7.488c-2.035-1.046-4.194-1.984-6.488-2.789c-1.409-6.116-3.365-12.986-6.145-20.072
	c3.902-3.306,8.555-6.497,14.12-9.459c-5.045,0.721-10.22,3.201-15.252,6.672c-3.176-7.549-7.324-15.248-12.779-22.45
	c4.109,7.003,7.094,15.852,9.266,25.031c-4.579,3.611-8.979,7.937-12.995,12.395c-1.425,0.44-2.771,0.954-4.066,1.514
	c-4.11-4.07-8.895-8-14.447-11.5c5.042,3.293,9.325,7.505,12.961,12.174c-5.64,2.724-10.019,6.532-13.399,10.812
	c0.477-12.391-0.431-32.292-7.303-58.793c4.202,26.306-4.321,57.375-8.207,69.884c-0.164,0.124-0.335,0.245-0.496,0.371
	c-0.93-3.206-2.049-6.482-3.386-9.671c2.288-2.812,5.021-5.411,8.299-7.556c-3.203,1.694-6.09,4.035-8.665,6.685
	c-4.321-9.95-10.872-18.786-20.676-21.189c-2.419-2.203-5.063-4.32-7.964-6.279c1.678,1.686,3.266,3.623,4.78,5.722
	c-0.055-0.005-0.106-0.019-0.161-0.023c0.08,0.038,0.151,0.081,0.231,0.119c3.656,5.09,6.843,11.222,9.582,17.726
	c-1.439,0.592-3.062,1.286-4.827,2.082c-0.349-2.621-0.698-5.242-1.047-7.863c0.091,2.738,0.182,5.477,0.274,8.215
	c-2.236,1.022-4.664,2.194-7.203,3.516c-2.825-1.061-5.828-1.398-8.971-0.673c2.467,0.359,4.664,1.025,6.638,1.917
	c-1.492,0.812-3.006,1.673-4.528,2.581c-1.332-1.205-2.754-2.415-4.265-3.611c0.005-0.062,0.009-0.123,0.014-0.185
	c-0.013,0.055-0.026,0.11-0.039,0.165c-0.847-0.67-1.721-1.334-2.625-1.991c0.869,0.766,1.71,1.586,2.516,2.454
	c-0.554,2.344-1.106,4.689-1.657,7.033c-2.019,1.382-4.005,2.842-5.911,4.383c-1.016-0.415-2.064-0.801-3.128-1.17
	c-0.204-5.239-0.406-10.479-0.606-15.719c-0.313,5.069-0.623,10.137-0.929,15.205c-1.448-0.457-2.932-0.866-4.451-1.208
	c10.768-36.835,32.597-65.404,32.609-65.39c-0.015-0.01-22.781,27.963-39.344,55.886c-0.219-0.93-0.438-1.859-0.657-2.789
	c0.143,1.058,0.286,2.116,0.429,3.174c-1.584,2.67-3.111,5.334-4.559,7.973c-1.299,0.039-2.608,0.135-3.926,0.302
	c-0.574-1.257-1.149-2.514-1.725-3.77c0.405,1.282,0.809,2.564,1.214,3.846c-2.644,0.37-5.318,1.018-8.001,1.99
	c-0.048-0.163-0.09-0.323-0.14-0.487c0.84-1.736,1.728-3.476,2.658-5.215c2.149-0.246,4.486-0.382,7.043-0.382
	c-1.895-1.033-3.772-1.75-5.627-2.2c7.246-12.926,16.774-25.443,26.668-34.094c-2.07-0.35-22.961,12.748-36.067,29.367
	c-2.371-4.279-5.437-8.726-9.382-13.293c3.648-17.735,10.534-33.564,10.537-33.563c0.002-0.001-8.458,11.177-15.564,28.171
	c-3.606-3.594-7.803-7.246-12.657-10.931c4.88,4.009,8.774,8.364,11.866,12.869c-3.418,8.509-6.429,18.347-7.928,28.889
	c-0.637-4.99-1.581-12.231-3.317-20.766c0.73-0.345,1.456-0.691,2.242-1.006c-0.817,0.049-1.613,0.142-2.392,0.269
	c-1.559-7.526-3.741-16.025-6.879-24.863c2.255,1.54,4.391,3.076,6.408,4.607c-1.974-1.621-4.121-3.179-6.431-4.673
	c-4.24-11.923-10.236-24.454-18.842-36.028c9.984,17.422,14.475,43.497,16.557,64.607c-3.698,2.437-6.797,5.806-9.364,9.608
	c-3.857-6.583-8.909-13.803-15.436-20.836c2.996-4.868,7.261-9.656,13.186-14.144c-6.846,2.356-11.915,6.48-15.631,11.595
	c-5.38-5.445-11.675-10.716-19.037-15.407c7.027,4.639,12.876,10.651,17.761,17.287c-12.884,20.283-7.023,53.5-6.045,58.646
	c-0.016,0.034-0.033,0.067-0.049,0.101c-0.383-1.147-1.378-3.916-3.139-7.513c-1.183-5.782-3.31-13.302-7.132-21.154
	c1.536,4.115,2.303,8.745,2.621,13.225c-9.249-14.172-28.019-31.793-61.672-25.047c11.662-1.608,21.281,2.191,28.945,8.12
	c-3.965-1.712-8.336-2.897-13.149-3.288c5.962,0.637,11.001,3.036,15.233,6.369c-0.316,1.981-0.65,3.911-1.004,5.772
	c0.534-1.85,0.962-3.705,1.265-5.556c4.308,3.46,7.762,7.882,10.492,12.406c-0.58,2.916-1.157,5.833-1.732,8.749
	c-2.214-2.163-4.748-4.35-7.613-6.359c-0.332-4.462-0.662-8.924-0.991-13.387c-0.111,4.169-0.219,8.337-0.325,12.505
	c-0.818-0.539-1.655-1.065-2.521-1.568c0.498-2.17,0.975-4.429,1.425-6.791c-0.614,2.129-1.36,4.249-2.218,6.344
	c-2.41-1.343-5.002-2.514-7.761-3.444c-0.446-1.627-0.891-3.254-1.337-4.882c0.269,1.567,0.538,3.135,0.807,4.702
	c-2.222-0.717-4.554-1.264-6.99-1.608c0.487-1.991,1.006-3.984,1.592-5.982c-0.854,1.899-1.632,3.867-2.35,5.882
	c-5.023-0.615-10.472-0.36-16.324,1.195c5.325-1.365,10.574-0.693,15.521,1.192c-0.414,1.273-0.808,2.559-1.174,3.863
	c-0.204-0.406-0.408-0.812-0.612-1.218c0.177,0.498,0.354,0.995,0.531,1.493c-0.22,0.791-0.424,1.591-0.627,2.392
	c-1.99,1.279-3.864,2.773-5.615,4.406c-1.329,0.269-2.656,0.605-3.978,1.011c-0.891-2.258-1.978-4.532-3.319-6.773
	c0.786,2.211,1.314,4.687,1.64,7.328c-4.67,1.658-9.245,4.249-13.536,8.038c-0.633-6.678-1.262-13.357-1.889-20.036
	c-0.042,7.301-0.077,14.602-0.105,21.902c-0.084,0.084-0.17,0.162-0.254,0.247c-2.122-4.319-4.436-8.988-6.961-14.031
	c2.117,4.197,4.167,9.31,6.116,14.918c-1.275,1.352-2.519,2.821-3.724,4.421c-3.609-4.94-9.295-11.637-17.17-17.785
	c10.808,10.214,16.265,29.391,16.268,29.388c-0.001,0.001-4.786-4.918-12.571-9.881c-2.589-6.269-5.106-13.619-7.168-22.072
	c1.2,0.84,2.358,1.696,3.471,2.565c-1.126-1.063-2.306-2.035-3.548-2.871c-0.613-2.534-1.18-5.174-1.699-7.902
	c2.896-3.686,5.912-7.088,8.987-10.08c-0.842-0.092-4.657,2.18-9.699,6.052c-1.309-7.913-2.181-16.576-2.36-26.017
	c-2.548,9.506-2.876,19.789-2.085,29.594c-2.755,2.32-5.691,4.984-8.606,7.896c-9.322-22.645-18.451-53.709-16.907-87.775
	c-3.432,18.187-1.428,39.319,1.969,57.644c-2.059,3.435-5.53,9.664-8.987,17.803C8.867,108.594-2.861,94.56-19.301,75.728
	c10.799,12.28,23.015,33.077,33.111,52.264c-1.267,3.617-2.455,7.471-3.487,11.513c-2.905-2.849-6.137-5.852-9.729-8.992
	c-4.887-16.355-12.999-35.934-27.118-52.947c7.665,11.853,12.839,28.121,16.351,44.025c-0.472-0.373-0.94-0.744-1.422-1.119
	c0.511,0.521,1.02,1.045,1.523,1.574c1.777,8.116,3.122,16.124,4.141,23.39c-2.433,3.539-4.539,7.201-6.354,10.83
	c-1.071-1.804-2.254-3.681-3.544-5.606c4.61,22.258,9.219,44.517,13.829,66.775c0,6.088,1606,6.088,1606,0
	c3.632-17.541,7.265-35.082,10.898-52.623c-0.007-0.003-0.013-0.007-0.02-0.01c0.348-3.141,0.834-6.842,1.493-10.77
	c0.305-0.274,0.618-0.526,0.924-0.793c0.304-1.467,0.608-2.935,0.912-4.402c-0.268-0.117-0.534-0.237-0.809-0.346
	c0.962-4.703,2.196-9.497,3.758-13.893C1621.309,133.85,1621.464,133.103,1621.619,132.356z M-2.914,176.177
	c-0.001,0.001-1.935-6.309-6.777-15.323c0.858-5.057,2.12-9.91,3.937-14.13C-3.451,163.607-2.914,176.177-2.914,176.177z
	 M7.043,158.353c-0.941-5.168-2.349-12.77-4.714-21.687c2.299,3.02,4.487,6.07,6.557,9.109
	C8.065,149.835,7.425,154.041,7.043,158.353z M20.468,164.591c-0.015-0.042-0.026-0.087-0.04-0.129
	c0.016,0.029,0.033,0.058,0.049,0.087C20.475,164.562,20.471,164.577,20.468,164.591z M18.735,137.53
	c1.345,2.654,2.635,5.238,3.859,7.721c-1.482,0.369-2.97,0.803-4.464,1.357C18.186,143.618,18.403,140.571,18.735,137.53z
	 M27.974,185.945c0.021-0.419,0.043-0.837,0.075-1.264c0.675-0.467,1.37-0.896,2.093-1.273c0.313,0.672,0.607,1.312,0.891,1.934
	C30.013,185.542,28.994,185.743,27.974,185.945z M28.057,184.566c0.111-1.429,0.286-2.91,0.528-4.44
	c0.495,1.027,0.963,2.012,1.402,2.952C29.348,183.55,28.705,184.044,28.057,184.566z M23.902,154.38
	c-1.684-2.098-3.601-4.357-5.783-6.769c0.002-0.333,0.005-0.666,0.012-1c1.528-0.521,3.052-0.898,4.568-1.149
	c0.988,2.006,1.93,3.941,2.826,5.798C24.942,152.295,24.404,153.336,23.902,154.38z M32.141,166.081
	c0.05-0.151,0.096-0.299,0.148-0.45c0.763,1.664,1.396,3.061,1.888,4.154C33.688,168.804,33.021,167.566,32.141,166.081z
	 M33.628,139.609c-2.601-3.462-6.582-8.621-12.617-16.107c1.816-8.655,4.091-16.216,5.588-20.78
	c2.771,14.464,6.351,27.037,8.777,34.821C34.786,138.224,34.203,138.912,33.628,139.609z M44.622,139.102
	c1.868-3.165,3.846-6.256,5.912-9.224c0.757,5.808,1.837,11.336,3.012,16.294c-1.149-0.932-2.325-1.823-3.536-2.659
	c1.333,1.373,2.618,2.724,3.878,4.062c0.105,0.428,0.209,0.859,0.315,1.277c-1.942-0.861-3.977-1.647-6.089-2.33
	C46.978,144.206,45.808,141.728,44.622,139.102z M57.073,163.133c-1.383-2.319-3.133-5.371-5.106-9.073
	c1.673,1.179,3.241,2.395,4.694,3.604c0.744,2.432,1.432,4.503,2.012,6.172C58.157,163.603,57.625,163.368,57.073,163.133z
	 M82.201,159.779c0,0-1.215-2.315-3.676-5.845c1.23,0.449,2.46,0.898,3.689,1.348C82.209,156.781,82.205,158.28,82.201,159.779z
	 M82.215,154.631c-1.329-0.375-2.658-0.749-3.988-1.123c-0.148-0.21-0.301-0.424-0.458-0.641c1.265-1.197,2.591-2.251,3.969-3.168
	c0.164,0.485,0.327,0.972,0.489,1.463C82.223,152.319,82.219,153.475,82.215,154.631z M110.586,131.137
	c0.394,1.109,0.789,2.218,1.183,3.327c-0.576,0.01-1.154,0.032-1.732,0.063C110.209,133.4,110.386,132.271,110.586,131.137z
	 M115.16,146.199c-2.055,0.217-4.23,0.578-6.527,1.108c0.005-0.075,0.01-0.15,0.015-0.225c0.722-0.618,1.488-1.208,2.281-1.778
	C112.352,145.56,113.765,145.86,115.16,146.199z M108.763,145.415c0.012-0.152,0.023-0.303,0.036-0.455
	c0.187,0.027,0.375,0.052,0.562,0.081C109.159,145.165,108.961,145.29,108.763,145.415z M108.919,131.438
	c-0.267,1.07-0.519,2.146-0.757,3.229c-1.112,0.104-2.226,0.249-3.341,0.437C106.081,133.811,107.439,132.578,108.919,131.438z
	 M87.528,158.453c-0.234-0.485-0.478-0.989-0.718-1.485c0.403,0.148,0.805,0.296,1.208,0.444
	C87.843,157.777,87.681,158.122,87.528,158.453z M86.229,155.766c-0.39-0.805-0.796-1.64-1.202-2.474
	c-0.166-1.746-0.332-3.493-0.498-5.239c3.417-1.765,7.084-2.815,10.861-3.318c-2.983,4.237-5.291,8.443-6.886,11.676
	C87.746,156.196,86.987,155.981,86.229,155.766z M94.624,173.061c-0.039,0.046-0.069,0.081-0.1,0.118
	c-0.036-0.078-0.072-0.154-0.108-0.232c0.143-0.784,0.509-2.556,1.226-4.907C95.303,169.826,94.959,171.511,94.624,173.061z
	 M91.029,165.762c-0.147-0.31-0.306-0.642-0.456-0.958c0.28-1.541,0.712-3.581,1.366-5.946c0.83,0.306,1.659,0.613,2.488,0.92
	C92.839,162.195,91.725,164.305,91.029,165.762z M97.536,155.519c-0.785,0.97-1.505,1.927-2.156,2.853
	c-1.017-0.291-2.034-0.581-3.051-0.872c1.165-3.901,2.914-8.49,5.499-13.014c0.121-0.009,0.241-0.016,0.362-0.024
	C98.189,148.095,97.938,151.844,97.536,155.519z M102.602,164.326c0,0,0.093-0.516,0.201-1.436c0.286,0.107,0.573,0.214,0.859,0.32
	C102.993,163.927,102.602,164.326,102.602,164.326z M104.697,161.051c-0.56-0.162-1.12-0.324-1.68-0.485
	c0.132-1.921,0.203-4.48,0.028-7.458c0.787-1.053,1.637-2.091,2.563-3.097c0.01,0.011,0.02,0.021,0.03,0.032
	C105.211,153.777,104.906,157.467,104.697,161.051z M102.774,149.978c-0.127-1.131-0.288-2.3-0.499-3.504
	c0.682,0.722,1.363,1.445,2.044,2.168C103.787,149.081,103.273,149.526,102.774,149.978z M105.11,147.997
	c-1.021-0.915-2.043-1.829-3.066-2.743c-0.058-0.291-0.12-0.583-0.183-0.877c1.492,0.026,2.988,0.121,4.482,0.275
	c-0.132,0.897-0.255,1.792-0.372,2.688C105.681,147.557,105.392,147.775,105.11,147.997z M108.341,152.916
	c0.731,0.778,1.461,1.556,2.191,2.334c-0.805,0.999-1.574,1.93-2.297,2.786C108.243,156.348,108.281,154.639,108.341,152.916z
	 M112.656,167.441c0,0,0.18-0.231,0.493-0.674c0.104,0.039,0.209,0.079,0.313,0.118
	C112.944,167.238,112.656,167.441,112.656,167.441z M108.419,150.963c0.054-1.166,0.126-2.341,0.206-3.521
	c2.518-0.327,5.055-0.175,7.557,0.343c-1.553,2.188-3.09,4.232-4.54,6.073C110.567,152.893,109.493,151.927,108.419,150.963z
	 M116.939,164.612c-0.67-0.196-1.341-0.392-2.011-0.588c0.437-0.721,0.927-1.569,1.454-2.526c0.681,0.729,1.362,1.458,2.043,2.188
	C117.897,164.01,117.404,164.318,116.939,164.612z M120.889,162.204c-1.099-0.995-2.199-1.989-3.299-2.984
	c0.544-1.063,1.115-2.228,1.707-3.507c0.724,2.05,1.448,4.101,2.171,6.151C121.27,161.979,121.081,162.091,120.889,162.204z
	 M125.621,159.543c-0.069,0.037-0.136,0.074-0.205,0.111c-1.016-2.046-2.033-4.093-3.051-6.138
	c0.669-0.336,1.355-0.656,2.057-0.959C124.821,154.885,125.221,157.214,125.621,159.543z M124.312,151.917
	c-0.779,0.277-1.547,0.57-2.305,0.879c-0.255-0.513-0.511-1.026-0.766-1.54c0.224-0.544,0.448-1.098,0.675-1.67
	c0.73,0.302,1.45,0.627,2.164,0.973C124.157,151.012,124.234,151.464,124.312,151.917z M121.437,135.162
	c-2.791-0.44-5.669-0.693-8.588-0.703c-0.7-1.397-1.401-2.795-2.103-4.192c0.01-0.056,0.023-0.112,0.033-0.167
	c0.505-0.341,1.016-0.677,1.545-0.997c-0.508,0.246-1.009,0.509-1.504,0.784c0.314-1.688,0.662-3.382,1.042-5.08
	c3.015,1.252,5.908,2.939,8.635,4.885C120.811,131.516,121.124,133.339,121.437,135.162z M123.163,135.46
	c-0.434-1.59-0.869-3.179-1.303-4.768c1.094,0.831,2.164,1.692,3.196,2.585c-0.395,0.779-0.8,1.551-1.215,2.316
	C123.614,135.548,123.39,135.502,123.163,135.46z M130.415,157.105c-0.4,0.192-0.8,0.384-1.193,0.579
	c-0.462-1.697-0.924-3.395-1.386-5.092c0.904,0.542,1.784,1.109,2.644,1.691C130.458,155.224,130.437,156.164,130.415,157.105z
	 M126.43,136.155c0.123-0.434,0.244-0.879,0.366-1.323c0.689,0.636,1.357,1.282,2.011,1.93
	C128.026,136.548,127.232,136.346,126.43,136.155z M134.861,163.044c-0.094-1.233-0.187-2.467-0.28-3.7
	c0.375-0.284,0.76-0.563,1.157-0.838C135.445,160.018,135.153,161.531,134.861,163.044z M141.505,164.048
	c0.006-0.183,0.012-0.365,0.019-0.548c0.056,0.056,0.11,0.11,0.165,0.165C141.627,163.793,141.566,163.921,141.505,164.048z
	 M146.517,143.935c-1.149-1.486-2.519-3.144-4.128-4.88c0.115-3.158,0.232-6.315,0.351-9.473c3.42,6.081,5.571,12.118,6.753,16.029
	C148.639,145.107,147.642,144.54,146.517,143.935z M175.155,123.338c1.484,0.085,2.941,0.205,4.362,0.369
	c-0.837,1.693-1.673,3.386-2.508,5.08C176.353,127.108,175.72,125.284,175.155,123.338z M182.816,140.24c0,0-1.136-1.644-2.639-4.5
	c0.982,1.121,1.919,2.251,2.803,3.381C182.867,139.842,182.816,140.24,182.816,140.24z M184.046,133.588
	c-1.79-1.336-3.764-2.666-5.928-3.954c0.734-1.948,1.47-3.896,2.207-5.844c2.1,0.265,4.118,0.625,6.079,1.043
	C185.369,128.086,184.599,131.1,184.046,133.588z M187.137,122.629c-2.078-0.161-4.185-0.215-6.311-0.162
	c0.755-1.994,1.512-3.987,2.27-5.981c-0.995,2.002-1.987,4.003-2.978,6.006c-1.687,0.062-3.384,0.195-5.089,0.413
	c-2.691-9.527-3.694-21.837,2.617-33.888c5.511,8.211,9.662,17.164,12.751,25.616C189.121,117.307,188.043,120.015,187.137,122.629
	z M205.674,132.814c0,0-0.082-0.325-0.249-0.907c0.086,0.048,0.166,0.098,0.252,0.146
	C205.677,132.543,205.674,132.814,205.674,132.814z M205.616,126.551c-0.734-0.249-1.475-0.493-2.227-0.726
	c-1.33-3.559-3.301-8.249-6.105-13.58c1.349-4.061,3.555-7.913,6.924-11.257C205.159,111.682,205.498,120.843,205.616,126.551z
	 M229.621,122.49c-0.216-0.747-0.409-1.512-0.578-2.294c0.61-0.976,1.335-1.904,2.191-2.772
	C230.56,119.111,230.006,120.802,229.621,122.49z M228.172,113.665c-0.383-5.84,0.148-12.201,1.189-18.5
	c2.347,4.98,3.911,9.982,4.91,14.773C232.169,110.933,230.132,112.196,228.172,113.665z M247.759,135.077
	c-0.006-0.513-0.016-1.035-0.03-1.565c0.145,0.166,0.29,0.332,0.435,0.498C248.031,134.364,247.884,134.728,247.759,135.077z
	 M248.641,132.751c-0.231-0.223-0.461-0.445-0.692-0.668c0.323-0.021,0.645-0.053,0.97-0.065
	C248.82,132.267,248.737,132.505,248.641,132.751z M250.375,128.536c-0.957,0.23-1.915,0.499-2.872,0.807
	c-0.316-3.93-0.989-8.246-2.34-12.874c2.761-0.86,5.521-1.236,8.243-1.23c0.44,1.396,0.88,2.791,1.319,4.187
	C253.125,122.542,251.657,125.595,250.375,128.536z M255.389,118.136c-0.44-0.964-0.88-1.928-1.321-2.892
	c0.926,0.023,1.848,0.074,2.762,0.18C256.339,116.333,255.859,117.237,255.389,118.136z M267.597,127.909
	c-0.083-0.354-0.166-0.708-0.249-1.062c0.742-0.15,1.472-0.285,2.168-0.378c-0.432,0.509-0.847,1.026-1.253,1.546
	C268.04,127.981,267.821,127.942,267.597,127.909z M271.962,143.41c-0.23,0.056-0.461,0.113-0.695,0.175
	c-0.073-0.312-0.146-0.624-0.219-0.935c0.347-0.724,0.71-1.439,1.083-2.149C272.075,141.47,272.018,142.44,271.962,143.41z
	 M273.189,122.549c-0.046,0.045-0.093,0.088-0.138,0.133c-2.132,0.202-4.207,0.882-6.171,2.169c-0.052-0.22-0.103-0.44-0.155-0.66
	c0.435-1.861,0.909-3.701,1.404-5.528c1.777,0.793,3.496,1.68,5.135,2.635C273.239,121.715,273.214,122.132,273.189,122.549z
	 M277.421,142.578c-0.425,0.026-0.862,0.063-1.31,0.111c-0.061-1.512-0.121-3.025-0.182-4.537c0.788,0.338,1.555,0.675,2.279,1.006
	C277.946,140.298,277.683,141.438,277.421,142.578z M280.071,131.102c-0.544-0.199-1.105-0.394-1.678-0.587
	c0.669-0.911,1.353-1.805,2.049-2.684c0.114,0.057,0.239,0.103,0.35,0.162C280.552,129.03,280.311,130.066,280.071,131.102z
	 M285.703,143.313c-0.611-0.164-1.418-0.346-2.404-0.496c0.026-0.374,0.052-0.747,0.079-1.121c1.028,0.541,1.855,0.998,2.467,1.346
	C285.798,143.132,285.75,143.222,285.703,143.313z M284.013,132.681c0.049-0.69,0.098-1.38,0.147-2.069
	c0.875,0.942,1.614,2.006,2.238,3.161C285.669,133.422,284.871,133.056,284.013,132.681z M285.884,106.773
	c1.099,1.192,2.136,2.463,3.111,3.778c-1.188,0.726-2.374,1.488-3.554,2.27C285.588,110.805,285.736,108.789,285.884,106.773z
	 M285.725,121.7c2.12-2.274,4.288-4.416,6.447-6.401c1.645,2.713,3.038,5.419,4.165,7.834c-0.71,1.339-1.42,2.679-2.129,4.019
	C291.945,125.485,289.074,123.561,285.725,121.7z M295.491,128.117c0.435-1.328,0.87-2.655,1.306-3.983
	c1.997,4.413,3.043,7.623,3.043,7.622C299.84,131.757,298.263,130.248,295.491,128.117z M305.109,127.556
	c-0.002,0.001-3.664-6.433-11.025-13.974c1.589-1.402,3.16-2.724,4.69-3.956c2.421,1.801,4.368,4.037,5.941,6.52
	C304.846,119.949,304.977,123.753,305.109,127.556z M304.53,110.688c-1.164-1.025-2.382-1.936-3.639-2.732
	c1.195-0.925,2.346-1.782,3.459-2.591C304.41,107.139,304.47,108.913,304.53,110.688z M308.708,129.821
	c-0.338-2.539-0.675-5.079-1.013-7.618c0.706,1.871,1.273,3.79,1.72,5.712C308.948,129.113,308.708,129.821,308.708,129.821z
	 M306.4,112.466c-0.347-2.61-0.695-5.221-1.042-7.831c1.83-1.306,3.509-2.439,4.978-3.394c1.922,4.683,3.628,9.521,5.113,14.268
	c-0.998,1.691-1.886,3.337-2.663,4.877C310.91,117.606,308.771,114.86,306.4,112.466z M316.832,127.056
	c-0.563-1.031-1.173-2.099-1.826-3.186c0.421-1.516,0.923-3.118,1.529-4.775c0.586,1.991,1.135,3.952,1.647,5.865
	C317.696,125.678,317.244,126.379,316.832,127.056z M319.216,131.708c0.127-0.375,0.258-0.754,0.4-1.144
	c0.35,1.434,0.672,2.811,0.978,4.147C320.229,133.876,319.766,132.857,319.216,131.708z M321.369,106.988
	c-1.411-2.847-3.161-5.99-5.303-9.247c0.196-0.109,0.33-0.183,0.33-0.183s-0.138,0.047-0.367,0.127
	c-2.459-3.733-5.434-7.606-9.004-11.338c7.916,5.732,12.195,13.186,14.368,20.613C321.385,106.97,321.377,106.979,321.369,106.988z
	 M370.386,88.688c0.843-0.219,1.71-0.403,2.609-0.538c-0.833,0.065-1.624,0.175-2.424,0.276c1.7-2.359,3.699-4.713,6.027-7.034
	c1.036,4.888,1.857,9.807,2.508,14.537c-3.848-0.755-8.002-1.156-12.491-1.106C367.667,92.793,368.925,90.741,370.386,88.688z
	 M361.273,120.975c-0.119-1.558-0.174-3.321-0.111-5.256c0.09,0,0.176-0.007,0.266-0.007c-0.089-0.004-0.177,0.001-0.266-0.002
	c0.13-3.994,0.775-8.697,2.438-13.73c2.71,4.877,4.884,9.896,6.625,14.674C367.019,117.711,364.014,119.231,361.273,120.975z
	 M381.629,129.24c0,0-0.648-2.47-2.242-6.43c0.676-0.258,1.357-0.492,2.043-0.702C381.621,126.552,381.629,129.24,381.629,129.24z
	 M380.664,110.086c-1.873,1.169-3.676,2.519-5.372,3.952c-2.512-4.736-5.897-10.147-10.361-15.598
	c0.353-0.842,0.737-1.689,1.153-2.542c0.093,0.015,0.188,0.026,0.281,0.041c5.141,4.011,9.814,7.88,14.073,11.598
	C380.519,108.404,380.594,109.253,380.664,110.086z M380.249,105.573c-4.051-3.699-8.412-6.938-13.079-9.511
	c4.665,0.906,8.847,2.717,12.599,5.09C379.945,102.658,380.106,104.136,380.249,105.573z M389.789,115.725
	c-0.016-0.019-0.032-0.038-0.047-0.058c-0.279-1.971-0.629-4.386-1.092-7.141c0.669,0.704,1.317,1.42,1.945,2.152
	C390.281,112.334,390.008,114.017,389.789,115.725z M398.813,104.196c0.125-1.274,0.281-2.551,0.466-3.827
	c1.031,2.11,2.053,4.274,3.06,6.472C401.223,105.922,400.039,105.045,398.813,104.196z M422.95,114.61
	c-0.129,1.589-0.221,3.149-0.283,4.668c-1.823-2.819-4.332-6.457-7.498-10.492c1.916-3.477,4.022-6.901,6.286-10.173
	C421.772,104.221,422.312,109.629,422.95,114.61z M426.482,91.909c0.914-1.12,1.842-2.203,2.782-3.25
	c-0.728,1.518-1.383,3.08-1.969,4.677C427.028,92.862,426.762,92.388,426.482,91.909z M440.157,105.658
	c-0.391-0.077-0.78-0.156-1.177-0.224c0.384,0.144,0.771,0.314,1.157,0.479c-0.202,2.75-0.473,5.263-0.755,7.443
	c-0.031,0.216-0.055,0.434-0.084,0.65c-0.638,4.752-1.294,7.742-1.295,7.742c-0.004,0.001-1.546-10.08-7.931-23.141
	c1.243-6.165,3.932-12.48,8.869-18.441C440.703,88.913,440.694,98.129,440.157,105.658z M450.537,122.471
	c0.155-2.975,0.578-5.989,1.381-8.925c0.726,0.608,1.448,1.23,2.162,1.871C452.543,118.964,451.156,121.427,450.537,122.471z
	 M455.642,111.512c-0.828-0.472-1.687-0.935-2.579-1.384c1.265-3.225,3.081-6.278,5.589-8.995
	C457.833,104.998,456.756,108.499,455.642,111.512z M463.817,115.351c0.753-5.242,1.152-11.694,0.464-18.915
	c0.038-0.024,0.079-0.046,0.117-0.07c1.059,3.315,1.927,6.547,2.64,9.56C465.774,109.165,464.707,112.38,463.817,115.351z
	 M481.612,101.767c-0.726-0.275-1.471-0.51-2.256-0.65c0.77,0.178,1.504,0.476,2.209,0.854c-0.201,0.888-0.389,1.759-0.563,2.607
	c-2.178-0.862-4.358-1.723-6.539-2.581c2.145,1.039,4.289,2.08,6.431,3.122c-1.086,5.419-1.63,9.838-1.826,11.622
	c-0.082,0.068-0.162,0.139-0.243,0.208c-0.44-1.72-1.936-6.843-5.782-14.418c0.896-5.919,2.946-11.488,6.808-15.851
	c2.07,0.617,3.856,1.551,5.388,2.721C483.704,93.49,482.52,97.788,481.612,101.767z M494.585,116.007
	c-0.021,0.094-0.039,0.178-0.058,0.267c-0.115-0.281-0.574-1.366-1.376-2.866c0.461-0.162,0.938-0.314,1.429-0.456
	C494.629,114.404,494.605,115.48,494.585,116.007z M492.428,109.122c-0.939-0.375-1.878-0.75-2.818-1.125
	c-0.45-0.56-0.938-1.11-1.448-1.649c-1.1-4.065-1.61-9.043-0.543-14.735c4.345,4.831,6.016,11.754,6.636,17.057
	C493.644,108.796,493.035,108.947,492.428,109.122z M501.57,99.983c-1.726,2.031-3.097,4.551-4.165,7.076
	c-1.776-5.242-4.794-11.765-9.646-16.145c0.735-3.528,2.091-7.32,4.281-11.324c6.338,3.318,8.725,10.031,9.347,16.772
	c-1.389-1.523-2.779-3.045-4.172-4.567c1.419,1.843,2.835,3.686,4.25,5.531C501.526,98.217,501.563,99.105,501.57,99.983z
	 M504.852,109.202c-0.126-0.041-0.251-0.072-0.377-0.11c0.095-1.817,0.142-4.737-0.194-8.093c0.633,0.827,1.267,1.655,1.899,2.483
	C505.699,105.891,505.208,107.87,504.852,109.202z M512.302,104.78c1.036-2.679,2.075-5.357,3.117-8.035
	c0.297,1.217,0.594,2.434,0.891,3.651C513.756,103.022,512.303,104.78,512.302,104.78z M517.427,104.982
	c0.164,0.676,0.329,1.351,0.493,2.027c-2.178,1.465-3.472,2.492-3.472,2.492S515.56,107.689,517.427,104.982z M518.44,115.181
	c-0.003-0.004-0.007-0.007-0.01-0.011c0.103-0.096,0.516-0.48,1.207-1.088c0.035,0.144,0.07,0.287,0.105,0.431
	C519.005,114.873,518.562,115.114,518.44,115.181z M524.359,112.524c-0.23,0.087-0.447,0.173-0.667,0.259
	c-0.199-0.53-0.398-1.06-0.597-1.589c0.355-0.282,0.725-0.573,1.111-0.871C524.257,111.056,524.308,111.79,524.359,112.524z
	 M523.729,103.453c-1.038,0.576-2.01,1.146-2.909,1.697c-0.406-1.078-0.813-2.155-1.219-3.233c1.1-1.509,2.342-3.147,3.687-4.821
	C523.434,99.215,523.582,101.334,523.729,103.453z M523.073,94.009c-1.797,1.562-3.404,3.055-4.793,4.412
	c-0.577-1.526-1.154-3.051-1.732-4.577c1.836-4.714,3.68-9.427,5.532-14.139C522.41,84.474,522.741,89.241,523.073,94.009z
	 M533.912,93.758c0.642,1.465,1.191,2.997,1.642,4.584c-0.596,0.178-1.187,0.367-1.774,0.567
	C533.824,97.193,533.868,95.476,533.912,93.758z M532.605,87.115c-0.057,0.453-0.114,0.906-0.171,1.359
	c-0.205-0.226-0.415-0.435-0.623-0.652C532.074,87.581,532.34,87.348,532.605,87.115z M529.648,110.842
	c-0.565,0.146-1.115,0.3-1.653,0.459c-0.187-1.123-0.373-2.246-0.56-3.369c0.893-0.631,1.833-1.268,2.808-1.899
	C530.044,107.636,529.846,109.239,529.648,110.842z M526.45,102.018c-0.405-2.427-0.81-4.854-1.215-7.281
	c1.796-2.112,3.729-4.208,5.723-6.112c0.435,0.579,0.847,1.179,1.23,1.804c-0.398,3.175-0.795,6.349-1.19,9.524
	C529.415,100.596,527.892,101.295,526.45,102.018z M533.287,118.622c0.013-0.521,0.026-1.042,0.038-1.563
	c0.155-0.044,0.311-0.086,0.466-0.129C533.624,117.494,533.455,118.058,533.287,118.622z M535.949,109.718
	c-0.826,0.077-1.644,0.181-2.449,0.311c0.051-2.022,0.101-4.045,0.152-6.067c0.936-0.533,1.89-1.05,2.86-1.533
	c0.224,1.184,0.402,2.38,0.551,3.577C536.691,107.244,536.32,108.481,535.949,109.718z M542.015,103.772
	c0.12-0.878,0.24-1.757,0.36-2.635c0.442,2.517,0.975,4.821,1.541,6.88C543.334,106.65,542.702,105.226,542.015,103.772z
	 M547.304,98.89c1.881-0.23,3.717-0.215,5.449,0.154c-1.036,1.684-2.07,3.369-3.103,5.054
	C548.866,102.536,548.068,100.794,547.304,98.89z M551.139,106.908c0.936-2.346,1.875-4.692,2.815-7.038
	c0.024,7.945,0.962,12.913,0.962,12.913S553.24,110.647,551.139,106.908z M563.797,110.245c0,0-0.299-0.858-0.758-2.368
	c0.31-0.388,0.621-0.776,0.931-1.165C563.794,108.954,563.797,110.245,563.797,110.245z M563.984,106.539
	c-0.354,0.315-0.709,0.63-1.063,0.946c-0.433-1.446-0.984-3.399-1.56-5.727c1.138-0.802,2.301-1.51,3.484-2.143
	C564.386,102.403,564.129,104.756,563.984,106.539z M572.938,88.611c0.259,0.921,0.508,1.841,0.752,2.761
	c-0.334,0.179-0.666,0.371-0.999,0.559C572.757,90.843,572.838,89.737,572.938,88.611z M572.917,111.712
	c0.001,0-0.654-6.372-0.433-15.05c0.798-0.201,1.602-0.37,2.409-0.516c0.533,2.23,1.022,4.429,1.471,6.581
	C574.022,108.126,572.918,111.712,572.917,111.712z M587.24,95.999c0.014-0.06,0.027-0.12,0.042-0.18
	c0.009,0.001,0.018,0.002,0.027,0.003C587.286,95.882,587.263,95.941,587.24,95.999z M590.821,86.153
	c-0.278,0.028-0.557,0.061-0.836,0.094c1.041-3.097,2.23-6.077,3.596-8.828C592.651,80.576,591.715,83.509,590.821,86.153z
	 M601.204,99.662c0,0,0.059-0.193,0.154-0.535c0.058,0.02,0.116,0.04,0.174,0.06C601.319,99.494,601.204,99.662,601.204,99.662z
	 M610.2,87.812c-2.142-0.55-4.336-1.001-6.572-1.326c0.933-8.059,1.516-19.751,0.269-34.854
	c9.952,2.659,17.745,8.802,23.745,16.076c0.125,0.426,0.247,0.853,0.364,1.28C621.104,75.126,614.896,82.077,610.2,87.812z
	 M620.728,111.205c0,0-0.263-1.136-0.47-3.089c0.239,0.143,0.479,0.285,0.714,0.428c0.189,0.573,0.372,1.143,0.541,1.703
	C621.009,110.849,620.729,111.205,620.728,111.205z M631.213,96.658c-2.928-1.705-6.211-3.415-9.766-4.955
	c1.297-5.281,3.689-11.156,7.9-16.998C630.856,82.37,631.284,90.003,631.213,96.658z M639.435,101.991
	c-0.148-0.106-0.296-0.213-0.448-0.321c0.331-0.588,0.673-1.167,1.031-1.734C639.811,100.679,639.616,101.362,639.435,101.991z
	 M641.748,93.465c-1.411,0.662-2.798,1.438-4.148,2.288c-0.625-5.554-1.957-12.839-4.747-20.809
	c3.996,6.315,6.9,12.86,8.929,18.388C641.77,93.376,641.759,93.421,641.748,93.465z M646.73,70.025
	c-2.022-2.227-4.26-4.381-6.736-6.399c2.485-1.989,5.26-3.919,8.384-5.756C647.958,61.968,647.386,66.056,646.73,70.025z
	 M664.427,96.449c-0.625,0.563-1.233,1.133-1.809,1.718c-0.578-1.795-1.297-3.813-2.18-5.981c1.272-3.567,2.933-7.163,4.772-10.617
	C664.63,87.181,664.442,92.323,664.427,96.449z M680.417,102.72c0,0-1.329-2.572-2.836-6.849c0.424-0.388,0.852-0.773,1.282-1.156
	c1.087,0.939,2.095,1.988,3.037,3.101C680.904,100.828,680.417,102.72,680.417,102.72z M682.514,96.018
	c-0.862-0.756-1.774-1.466-2.728-2.12c1.681-1.466,3.405-2.888,5.158-4.251c0.001,0.002,0.002,0.004,0.003,0.006
	C683.973,91.995,683.166,94.151,682.514,96.018z M703.165,89.945c0.203,0.374,0.406,0.75,0.604,1.133
	c-0.242-0.112-0.483-0.223-0.725-0.335C703.083,90.478,703.123,90.213,703.165,89.945z M703.034,90.81
	c0.279,0.155,0.557,0.311,0.835,0.466c0.221,0.431,0.444,0.859,0.658,1.299c-0.565-0.139-1.131-0.247-1.698-0.324
	C702.894,91.777,702.962,91.296,703.034,90.81z M697.462,102.219c-0.351-2.224-0.703-4.447-1.056-6.671
	c0.896-0.043,1.747-0.046,2.562-0.013C697.895,99.613,697.462,102.219,697.462,102.219z M696.385,92.876
	c0.082-3.59,0.458-7.309,1.273-10.972c1.379,1.536,2.675,3.297,3.883,5.235c-0.62,1.769-1.158,3.451-1.621,5.006
	C698.735,92.226,697.555,92.461,696.385,92.876z M701.695,105.273c0,0,0.108-3.946,0.692-9.379c1.277,0.25,2.41,0.631,3.453,1.088
	C703.146,101.647,701.695,105.274,701.695,105.273z M714.191,97.582c-0.489-0.374-0.98-0.739-1.476-1.084
	c0.034-0.071,0.068-0.142,0.103-0.213c0.559,0.314,1.118,0.628,1.677,0.942C714.393,97.345,714.292,97.463,714.191,97.582z
	 M715.22,96.391c-0.664-0.31-1.329-0.619-1.993-0.928c1.197-2.382,2.584-4.849,4.16-7.182c0.743,1.164,1.447,2.298,2.152,3.434
	C718.035,93.255,716.592,94.823,715.22,96.391z M722.886,88.449c-0.793,0.738-1.573,1.489-2.338,2.25
	c-0.753-1.219-1.537-2.411-2.352-3.575c1.735-2.416,3.676-4.625,5.804-6.367C723.706,83.407,723.32,85.985,722.886,88.449z
	 M750.106,79.117c0.163,0.68,0.318,1.36,0.447,2.037c-1.856,1.444-3.668,3.07-5.41,4.803c-0.54-1.716-1.081-3.432-1.622-5.148
	C745.451,80.056,747.636,79.481,750.106,79.117z M744.687,94.245c-0.328-0.224-0.654-0.415-0.981-0.617
	c0.199-0.412,0.417-0.825,0.639-1.24C744.459,93.007,744.573,93.626,744.687,94.245z M733.333,89.47
	c0.162,0.346,0.332,0.688,0.482,1.041c-0.311-0.007-0.615,0.009-0.923,0.017c-0.021-0.025-0.041-0.051-0.062-0.076
	C732.99,90.12,733.156,89.792,733.333,89.47z M728.31,83.818c-0.058-0.57-0.115-1.138-0.182-1.727
	c0.363,0.346,0.708,0.706,1.044,1.072C728.883,83.38,728.596,83.596,728.31,83.818z M730.902,103.744
	c-0.174-0.082-0.348-0.164-0.521-0.246c-0.05-2.758,0.161-5.486,0.741-8.07c0.981-0.536,1.975-0.995,2.977-1.365
	c0.534,0.788,1.067,1.576,1.6,2.364c0.031,0.135,0.059,0.269,0.089,0.404C733.855,99.397,732.192,101.795,730.902,103.744z
	 M739.858,91.719c-0.211-0.079-0.423-0.176-0.633-0.246c-1.079-1.841-2.267-3.638-3.556-5.322c1.115-1.266,2.437-2.409,3.992-3.4
	c0.487,2.438,0.938,4.988,1.354,7.623C740.623,90.822,740.237,91.27,739.858,91.719z M742.161,89.087
	c-0.637-2.141-1.293-4.337-1.989-6.65c0.669-0.399,1.38-0.77,2.133-1.113c0.391,2.114,0.781,4.229,1.171,6.343
	C743.032,88.137,742.593,88.61,742.161,89.087z M743.59,93.92c0.381,0.156,0.761,0.344,1.137,0.547
	c0.557,3.03,1.112,6.059,1.667,9.089C745.54,100.582,744.602,97.356,743.59,93.92z M751.331,93.06
	c-0.155,3.358-0.581,6.467-1.097,9.142c-1.339-4.292-2.683-8.583-4.03-12.873c1.292-1.901,2.858-3.803,4.752-5.67
	c0.134,0.995,0.225,1.98,0.296,2.958C751.278,88.764,751.304,90.912,751.331,93.06z M753.6,78.99
	c-0.024-0.077-0.045-0.156-0.07-0.233c0.157-0.01,0.318-0.017,0.477-0.026C753.872,78.816,753.736,78.903,753.6,78.99z
	 M754.146,80.82c0.897-0.727,1.841-1.447,2.856-2.154c1.068,0.005,2.162,0.031,3.31,0.098c0.185,0.526,0.368,1.052,0.548,1.578
	c-1.145,6.229-2.284,12.459-3.418,18.69C756.903,93.508,755.918,87.068,754.146,80.82z M760.685,102.271
	c0.491-5.992,0.985-11.983,1.481-17.975c0.884,2.777,1.697,5.543,2.444,8.263C762.907,95.942,761.634,99.271,760.685,102.271z
	 M787.867,100.277c-0.488,0.254-0.967,0.514-1.439,0.78c-0.973-2.044-2.468-5.041-4.505-8.714c1.144-2.442,2.29-4.884,3.438-7.325
	c-1.397,1.998-2.792,3.998-4.184,5.998c-0.698-1.233-1.45-2.53-2.26-3.884c2.042-3.869,4.549-7.569,7.604-10.649
	C787.744,86.794,787.9,95.552,787.867,100.277z M805,95.816c-0.68-0.014-1.356,0.003-2.029,0.038
	c-0.52-3.454-1.479-8.516-3.188-14.601c2.745-0.379,5.543-0.371,8.352-0.031C807.103,87.236,805.909,92.326,805,95.816z
	 M819.347,104.053c-0.001,0-0.002,0.001-0.002,0.001c0-0.004,0.032-0.228,0.078-0.617c0.105,0.03,0.21,0.061,0.315,0.093
	C819.496,103.858,819.351,104.047,819.347,104.053z M821.13,101.535c-0.478-0.355-0.956-0.688-1.435-1.006
	c0.252-3.375,0.478-9.029,0.051-16.292c3.017,1.162,5.958,2.553,8.758,4.077C825.714,94.348,822.891,98.915,821.13,101.535z
	 M831.49,81.131c-3.817-1.325-7.912-2.329-12.215-2.797c-0.477-4.752-1.235-9.996-2.421-15.613
	c6.661,0.727,12.718,3.458,18.033,7.117C833.958,73.88,832.777,77.657,831.49,81.131z M838.091,95.679
	c0.095-0.394,0.19-0.787,0.283-1.192c0.053,0.037,0.106,0.075,0.159,0.112C838.382,94.962,838.236,95.321,838.091,95.679z
	 M842.349,86.03c-0.727-0.405-1.474-0.803-2.24-1.195c0.425-3.194,0.734-6.587,0.857-10.172c1.706,1.539,3.311,3.137,4.8,4.754
	C844.555,81.605,843.411,83.824,842.349,86.03z M849.675,104.368c-0.013-0.3-0.021-0.604-0.031-0.906
	c1.55,1.396,2.411,2.254,2.411,2.254S851.236,105.125,849.675,104.368z M849.962,90.849c0.171-1.873,0.405-3.743,0.71-5.595
	c5.596,7.267,8.675,13.464,8.676,13.464C859.348,98.718,855.878,95.077,849.962,90.849z M868.492,92.893
	c-0.138-0.187-0.297-0.396-0.451-0.6c0.276,0.14,0.556,0.277,0.826,0.421C868.742,92.769,868.617,92.833,868.492,92.893z
	 M865.614,89.221c-2.97-3.595-7.318-8.294-12.841-12.772c1.735-5.354,4.307-10.29,7.995-14.358
	c5.483,9.575,7.892,21.771,8.861,28.409C868.323,90.023,866.983,89.593,865.614,89.221z M869.845,94.794
	c0.105-0.002,0.212-0.006,0.316-0.007c0.034,0.348,0.05,0.554,0.05,0.554S870.08,95.138,869.845,94.794z M897.447,103.388
	c-0.816,0.485-1.583,0.956-2.307,1.414c-0.957-1.146-1.954-2.269-2.983-3.348c1.802-2.963,4.211-6.356,7.307-9.604
	C899.117,96.505,898.255,100.496,897.447,103.388z M888.262,97.756c-0.463-0.393-0.931-0.772-1.402-1.137
	c2.089-4.683,5.637-11.387,10.977-17.655c0.384,0.223,0.772,0.442,1.134,0.682c0.443,2.729,0.636,5.38,0.645,7.901
	C894.606,90.987,890.802,94.808,888.262,97.756z M901.368,75.178c4.398-4.32,9.762-8.138,16.206-10.521
	c3.492,4.534,5.606,9.408,6.775,14.262c-6.549,0.344-12.352,2.04-17.354,4.388c-1.059-1.153-2.185-2.195-3.377-3.102
	C902.987,78.576,902.24,76.899,901.368,75.178z M906.128,105.094c0.127-0.823,0.244-1.685,0.345-2.578
	c0.675-0.499,1.372-0.996,2.102-1.487C907.683,102.416,906.861,103.775,906.128,105.094z M906.771,98.524
	c0.125-3.569-0.13-7.574-1.179-11.999c2.033,3.273,3.289,6.985,3.994,10.789C908.625,97.708,907.685,98.111,906.771,98.524z
	 M908.198,84.695c4.535-2.817,9.918-4.898,16.21-5.519c0.095,0.408,0.202,0.817,0.284,1.224c-3.844,4.327-7.571,8.793-10.86,13.147
	C912.246,90.419,910.375,87.348,908.198,84.695z M924.68,99.826c-2.267,1.675-4.316,3.529-6.004,5.575
	c-0.012-0.039-0.026-0.079-0.039-0.118c1.341-3.832,2.892-7.555,4.584-11.135c0.731-0.205,1.473-0.395,2.228-0.567
	C925.294,95.782,925.022,97.877,924.68,99.826z M925.498,92.792c-0.592,0.091-1.179,0.192-1.764,0.299
	c0.604-1.248,1.221-2.48,1.854-3.691C925.596,90.553,925.561,91.682,925.498,92.792z M931.834,95.418
	c-0.332,0.173-0.661,0.348-0.991,0.527c-0.098-1.049-0.218-2.12-0.35-3.202c0.687-0.074,1.378-0.139,2.081-0.181
	C932.33,93.528,932.083,94.483,931.834,95.418z M932.677,92.153c-0.752,0.015-1.501,0.054-2.247,0.101
	c-0.366-2.893-0.861-5.867-1.528-8.824c0.867-1.477,1.744-2.922,2.63-4.324c0.174,0.013,0.34,0.013,0.515,0.028
	c-0.171-0.019-0.335-0.024-0.506-0.041c1.736-2.744,3.494-5.326,5.225-7.745C935.757,78.677,934.286,85.74,932.677,92.153z
	 M953.753,91.815c-0.233-0.54-0.472-1.075-0.718-1.607c0.343-0.594,0.701-1.183,1.067-1.767c0.654-0.292,1.25-0.55,1.788-0.777
	C955.053,89.25,954.338,90.646,953.753,91.815z M956.694,86.151c-0.152,0.282-0.297,0.555-0.441,0.827
	c-0.421,0.09-0.895,0.196-1.396,0.31c0.617-0.93,1.257-1.845,1.936-2.73C956.752,85.095,956.723,85.623,956.694,86.151z
	 M957.229,101.187c0.041-0.123,0.086-0.25,0.127-0.373c0.077,0.529,0.156,1.045,0.239,1.547
	C957.475,101.973,957.356,101.585,957.229,101.187z M968.819,91.911c-1.851,2.38-3.561,4.78-5.123,7.129
	c-0.92-2.437-1.834-5.278-2.574-8.437c1.981-4.95,4.336-10.264,7.146-15.782c1.54-0.739,3.167-1.326,4.886-1.735
	C970.856,80.025,969.551,86.476,968.819,91.911z M978.377,99.75c-0.844-0.039-1.685-0.04-2.521-0.005
	c-0.196-1.27-0.393-2.68-0.576-4.202c1.302,0.58,2.457,1.484,3.477,2.613C978.62,98.711,978.495,99.241,978.377,99.75z
	 M978.918,97.528c-1.098-0.836-2.308-1.524-3.639-2.005c-0.186-1.549-0.356-3.21-0.493-4.955c1.709-2.481,3.56-5.004,5.592-7.562
	c0.954,0.717,1.816,1.508,2.568,2.373C981.082,89.941,979.795,94.112,978.918,97.528z M987.23,93.637
	c0.275,0.958,0.503,1.923,0.683,2.887c-0.324-0.179-0.648-0.357-0.973-0.536C987.029,95.223,987.123,94.443,987.23,93.637z
	 M986.468,108.116c-0.117-0.279-0.243-0.563-0.375-0.857c0.004-0.107,0.007-0.208,0.01-0.324c0.304,0,0.607,0.011,0.91,0.022
	C986.794,107.415,986.612,107.803,986.468,108.116z M986.421,101.366c0.113-1.453,0.261-3.068,0.454-4.803
	c0.395,0.258,0.789,0.517,1.184,0.775c0.277,1.687,0.428,3.351,0.495,4.924C987.844,101.93,987.132,101.629,986.421,101.366z
	 M990.958,99.502c-0.03-0.107-0.059-0.213-0.09-0.32c0.066,0.044,0.133,0.087,0.199,0.131
	C991.029,99.376,990.994,99.438,990.958,99.502z M991.528,98.52c-0.344-0.19-0.688-0.38-1.032-0.57
	c-0.735-2.322-1.677-4.699-2.889-6.938c0.714-4.669,1.755-9.792,3.286-14.806c4.191,3.389,5.87,8.402,6.227,13.624
	C994.933,92.934,993.072,95.891,991.528,98.52z M1023.239,101.378c-2.055,0.661-4.003,1.395-5.759,2.131
	c-0.74-1.061-1.48-2.121-2.22-3.182c2.069-2.173,4.487-4.571,7.084-6.872C1022.643,96.096,1022.942,98.737,1023.239,101.378z
	 M1020.565,77.835c0.526,4.592,1.049,9.183,1.57,13.775c-3.4,2.119-6.358,4.224-8.74,6.049c-0.669-0.956-1.339-1.912-2.009-2.868
	C1014.434,89.136,1017.493,83.484,1020.565,77.835z M998.279,108.266c0,0,0.354-1.448,0.68-3.751c0-0.002,0.001-0.003,0.001-0.005
	c0.224,0.148,0.449,0.296,0.673,0.445C998.84,107.028,998.279,108.267,998.279,108.266z M1000.231,103.346
	c-0.273-0.152-0.546-0.304-0.82-0.456c1.276-4.49,2.814-9.182,4.65-13.703C1003.11,94.703,1001.509,99.808,1000.231,103.346z
	 M1005.882,87.268c1.337,2.287,2.671,4.575,4.003,6.864c-2.131,3.41-4.256,6.822-6.377,10.235
	C1003.507,104.366,1005.502,96.235,1005.882,87.268z M1006.96,103.02c1.294-2.411,2.59-4.822,3.888-7.232
	c0.513,0.883,1.026,1.765,1.538,2.648C1008.954,101.128,1006.961,103.02,1006.96,103.02z M1008.508,107.964
	c0.029-0.035,2.24-2.8,5.652-6.469c0.533,0.92,1.066,1.84,1.598,2.761c-4.351,1.946-7.21,3.687-7.248,3.709
	C1008.51,107.965,1008.509,107.965,1008.508,107.964z M1011.705,114.121c0,0,0.303-0.222,0.841-0.596
	c0.091,0.061,0.182,0.121,0.273,0.182C1012.115,113.956,1011.705,114.121,1011.705,114.121z M1016.641,112.528
	c-0.469-0.264-0.938-0.528-1.407-0.792c1.022-0.654,2.226-1.398,3.583-2.185c0.418,0.725,0.836,1.451,1.254,2.176
	C1018.824,111.978,1017.669,112.253,1016.641,112.528z M1022.864,111.251c-0.661-0.953-1.323-1.906-1.984-2.858
	c0.946-0.517,1.939-1.037,2.973-1.55c0.158,1.408,0.316,2.817,0.473,4.225C1023.83,111.122,1023.344,111.183,1022.864,111.251z
	 M1029.052,110.822c-0.111-0.001-0.223-0.007-0.333-0.007c-0.443-1.872-0.888-3.744-1.333-5.616c0.67-0.29,1.348-0.573,2.035-0.842
	c0,0,0,0.001,0,0.001C1029.299,106.513,1029.176,108.668,1029.052,110.822z M1029.689,99.705c-1.158,0.224-2.299,0.489-3.423,0.786
	c-0.686-2.878-1.374-5.756-2.064-8.634c2.018-1.69,4.11-3.272,6.201-4.614C1030.164,91.397,1029.927,95.551,1029.689,99.705z
	 M1033.881,111.233c-0.298-0.051-0.598-0.091-0.897-0.131c-0.034-0.878-0.067-1.756-0.1-2.634c0.433,0.565,0.856,1.134,1.267,1.707
	C1034.06,110.528,1033.97,110.881,1033.881,111.233z M1034.679,108.099c-0.605-0.503-1.226-1.004-1.867-1.502
	c-0.043-1.133-0.087-2.266-0.13-3.399c1.161-0.371,2.329-0.695,3.491-0.958C1035.674,104.192,1035.176,106.145,1034.679,108.099z
	 M1039.184,112.181c-0.367-0.362-0.742-0.724-1.125-1.086c0.479-3.145,0.96-6.29,1.441-9.434c1.508-0.178,2.982-0.219,4.404-0.107
	C1042.327,105.096,1040.754,108.638,1039.184,112.181z M1044.254,116.052c1.217-4.559,2.437-9.117,3.66-13.675
	c1.874,0.675,3.57,1.755,4.993,3.356c-1.422-1.728-3.047-3.05-4.802-4.066c1.108-4.127,2.219-8.253,3.332-12.379
	c0.915,4.427,1.582,8.784,2.054,12.945c-0.583,0.091-1.165,0.186-1.748,0.304c0.606-0.002,1.194,0.023,1.788,0.039
	c0.13,1.171,0.244,2.324,0.345,3.46c-2.917,3.637-5.826,7.277-8.728,10.921C1044.855,116.644,1044.56,116.335,1044.254,116.052z
	 M1050.432,118.058c1.27-2.303,2.542-4.606,3.815-6.907c0.148,2.532,0.233,4.928,0.273,7.166
	C1053.158,118.229,1051.795,118.143,1050.432,118.058z M1064.276,118.95c-0.1-0.007-0.199-0.013-0.298-0.02
	c-0.066-0.987-0.2-2.602-0.474-4.757c0.72-0.7,1.44-1.4,2.16-2.1C1065.047,115.31,1064.551,117.673,1064.276,118.95z
	 M1065.911,110.764c-0.875,0.601-1.75,1.202-2.625,1.803c-0.365-2.55-0.904-5.654-1.706-9.193c1.886,0.329,3.696,0.744,5.426,1.237
	C1066.622,106.87,1066.253,108.932,1065.911,110.764z M1091.761,110.9c-0.706-0.397-1.458-0.806-2.258-1.224
	c0.192-2.513,0.605-5.108,1.192-7.746c2.411,0.622,4.37,1.582,5.93,2.814C1094.793,106.723,1093.145,108.778,1091.761,110.9z
	 M1091.58,98.385c1.123-4.078,2.602-8.2,4.278-12.216c2,5.532,2.868,10.909,3.169,15.505
	C1096.641,100.041,1094.145,98.873,1091.58,98.385z M1108.331,109.617c-0.015-0.279-0.035-0.564-0.053-0.85
	c0.186-0.225,0.369-0.451,0.557-0.675C1108.664,108.603,1108.487,109.118,1108.331,109.617z M1143.398,78.148
	c0.014,0.454,0.026,0.908,0.029,1.364c-0.553-0.147-1.122-0.264-1.684-0.392C1142.296,78.786,1142.847,78.465,1143.398,78.148z
	 M1131.708,70.239c2.249,2.587,4.003,5.289,5.36,8.043c-2.716-0.339-5.536-0.43-8.441-0.272
	C1129.622,75.305,1130.659,72.709,1131.708,70.239z M1128.612,78.051c3.092-0.053,6.045,0.325,8.852,1.064
	c0.023,0.052,0.051,0.104,0.074,0.157c-3.029,1.094-6.815,2.664-10.956,4.662C1127.232,81.925,1127.911,79.961,1128.612,78.051z
	 M1122.906,104.624c-0.341-0.497-0.695-0.993-1.061-1.489c0.274-1.644,0.573-3.278,0.911-4.893
	c0.573,1.521,1.011,3.095,1.346,4.693C1123.683,103.49,1123.286,104.054,1122.906,104.624z M1123.942,123.351
	c-0.182-0.015-0.365-0.03-0.547-0.044c0.252-1.203,0.538-2.395,0.887-3.565c0.044,0.194,0.087,0.387,0.129,0.581
	C1124.271,121.38,1124.109,122.384,1123.942,123.351z M1127.486,99.022c-0.426-0.824-0.873-1.635-1.34-2.43
	c0.996,0.231,1.988,0.503,2.976,0.808C1128.562,97.93,1128.019,98.472,1127.486,99.022z M1124.215,93.609
	c-0.097-0.137-0.193-0.276-0.291-0.411c0.076-0.301,0.148-0.606,0.225-0.906c4.617-4.116,9.419-7.866,14.223-11.04
	c0.967,2.493,1.64,5.005,2.07,7.498c-2.423,1.538-4.874,3.248-7.222,5.113C1130.312,93.505,1127.306,93.394,1124.215,93.609z
	 M1134.493,119.511c-0.626-2.951-1.847-7.947-3.838-13.276c1.468-2.267,3.059-4.42,4.72-6.448c1.646,0.751,3.264,1.578,4.846,2.462
	C1138.418,109.155,1136.203,115.247,1134.493,119.511z M1139.558,95.051c0.48-0.503,0.959-0.998,1.439-1.48
	c0.038,0.64,0.064,1.275,0.075,1.907C1140.569,95.333,1140.07,95.181,1139.558,95.051z M1141.167,80.31
	c0.76,0.294,1.508,0.608,2.243,0.949c-0.033,1.613-0.126,3.231-0.272,4.849C1142.585,84.115,1141.932,82.173,1141.167,80.31z
	 M1144.047,81.575c1.544,0.752,3.032,1.601,4.465,2.533c-1.254,0.655-2.573,1.369-3.937,2.149
	C1144.426,84.739,1144.25,83.177,1144.047,81.575z M1147.328,118.255c-0.497-0.005-0.998-0.005-1.513,0.008
	c0.191-3.392,0.309-7.718,0.126-12.479c1.806,1.216,3.542,2.472,5.18,3.737C1149.476,112.696,1148.236,115.713,1147.328,118.255z
	 M1155.779,101.942c-3.193-1.906-6.711-3.68-10.522-5.103c-0.062-2.194-0.186-4.524-0.369-6.96
	c1.901-1.711,3.733-3.238,5.411-4.556c4.137,2.973,7.776,6.576,10.891,10.295C1159.153,97.614,1157.362,99.755,1155.779,101.942z
	 M1163.355,121.993c-1.069-0.549-2.368-1.134-3.898-1.675c0.285-0.869,0.609-1.803,0.966-2.793
	c1.529,1.457,2.819,2.757,3.842,3.824C1163.952,121.566,1163.65,121.781,1163.355,121.993z M1173.234,116.112
	c-1.665-1.809-4.658-4.836-8.742-8.107c0.573-1.148,1.184-2.303,1.84-3.457c0.283-0.25,0.587-0.495,0.884-0.742
	c3.285,5.052,5.516,9.537,6.653,12.009C1173.655,115.913,1173.444,116.012,1173.234,116.112z M1184.134,112.435
	c-1.891-3.001-5.311-7.978-10.168-13.249c1.829-1.031,3.809-2.016,5.993-2.928c-2.297,0.104-4.682,0.754-7.086,1.773
	c-0.414-0.434-0.84-0.868-1.273-1.303c2.835-3.515,6.152-6.623,10.008-8.804c3.044,9.387,3.909,19.311,4.155,24.242
	C1185.218,112.244,1184.674,112.332,1184.134,112.435z M1199.51,123.814c0,0,0.648-1.628,1.958-4.186
	c0.524,0.047,1.044,0.111,1.562,0.193C1200.726,122.174,1199.51,123.814,1199.51,123.814z M1203.327,130.606
	c-0.203-0.021-0.406-0.041-0.609-0.062c0.463-0.919,1.411-2.69,2.87-4.931c0.189,1.136,0.34,2.242,0.465,3.312
	C1204.876,129.619,1203.953,130.2,1203.327,130.606z M1210.708,126.359c-0.471-1.45-1.078-3.041-1.829-4.725
	c1.666,0.812,3.263,1.902,4.779,3.265C1212.612,125.395,1211.631,125.884,1210.708,126.359z M1213.571,131.659
	c-0.154-0.016-0.307-0.032-0.461-0.048c0.219-0.194,0.411-0.373,0.645-0.575C1213.69,131.257,1213.631,131.455,1213.571,131.659z
	 M1215.57,124.02c-0.476,0.213-0.933,0.425-1.388,0.637c-1.397-1.841-2.837-3.445-4.311-4.841c2.148-2.568,4.78-5.246,7.886-7.679
	C1217.147,116.571,1216.356,120.611,1215.57,124.02z M1206.337,116.698c-0.515-0.883-1.079-1.779-1.684-2.687
	c3.174-5.105,7.864-11.344,14.178-16.555c-0.014,3.84-0.255,7.587-0.639,11.142C1213.346,111.075,1209.364,114.04,1206.337,116.698
	z M1222.76,125.458c0.001,0,0.072-0.353,0.175-0.986c0.136-0.08,0.274-0.159,0.412-0.239
	C1222.972,125.027,1222.76,125.458,1222.76,125.458z M1225.131,120.371c-0.582,0.185-1.16,0.37-1.727,0.564
	c0.323-3.038,0.608-7.453,0.417-12.805c2.377-1.292,4.966-2.375,7.753-3.178C1229.108,111.338,1226.776,116.723,1225.131,120.371z
	 M1241.189,99.411c0.177,1.301,0.343,2.589,0.495,3.86c-0.489-0.018-0.979-0.039-1.46-0.042
	C1240.55,102.003,1240.873,100.725,1241.189,99.411z M1236.03,117.02c1.094-3.287,2.618-7.905,4.113-13.489
	c0.516-0.024,1.044-0.021,1.57-0.025c0.212,1.786,0.396,3.535,0.561,5.248C1240.095,111.327,1237.986,114.08,1236.03,117.02z
	 M1242.742,126.127c0.131-0.785,0.317-1.581,0.525-2.38c0.022,0.577,0.04,1.142,0.057,1.696
	C1243.131,125.671,1242.926,125.894,1242.742,126.127z M1250.128,109.302c0.461-0.707,0.934-1.407,1.417-2.103
	c0.069,4.066,0.098,7.541,0.107,10.211c-0.078-0.01-0.156-0.024-0.235-0.033C1251.201,115.266,1250.808,112.573,1250.128,109.302z
	 M1251.532,118.626c-0.024-0.304-0.048-0.605-0.081-0.939c0.067,0.006,0.134,0.015,0.202,0.021c0.001,0.293,0,0.573,0.002,0.845
	C1251.615,118.578,1251.573,118.601,1251.532,118.626z M1261.889,94.405c1.046-1.141,2.061-2.217,3.021-3.207
	c-0.98,7.071-1.324,11.495-1.324,11.495C1263.584,102.692,1263.316,100.709,1261.889,94.405z M1273.084,127.628
	c-0.289-1.97-0.834-6.16-1.25-12.048c1.034-0.58,2.075-1.144,3.117-1.686c-1.073,6.715-1.478,11.873-1.609,13.981
	C1273.256,127.793,1273.171,127.708,1273.084,127.628z M1281.321,123.219c-0.015-3.8,0.156-8.03,0.598-12.624
	c0.585-0.249,1.168-0.492,1.75-0.725c0.659,0.369,1.29,0.755,1.885,1.164C1284.19,115.364,1282.747,119.459,1281.321,123.219z
	 M1286.022,109.526c-0.26-0.102-0.532-0.179-0.798-0.266c0.33-0.125,0.659-0.244,0.989-0.364
	C1286.15,109.106,1286.086,109.316,1286.022,109.526z M1285.831,132.494c1.149-2.713,3.055-8.148,4.536-16.973
	c0.722,0.913,1.352,1.874,1.916,2.867C1289.421,124.81,1287.089,129.825,1285.831,132.494z M1302.37,122.327
	c0,0,0.542-1.725,1.818-7.427c0.132,1.27,0.248,2.539,0.352,3.806C1303.137,120.983,1302.369,122.327,1302.37,122.327z
	 M1304.263,140.298c-0.201-0.93-0.431-1.923-0.689-2.962c0.493-1.314,1.044-2.733,1.658-4.254c0.033,1.935,0.041,3.814,0.033,5.631
	C1304.913,139.261,1304.579,139.79,1304.263,140.298z M1310.636,109.336c-0.907-2.882-2.023-5.914-3.409-9.017
	c0.043-0.221,0.09-0.463,0.135-0.688c1.742,2.911,2.998,5.889,3.848,8.871C1311.018,108.78,1310.823,109.063,1310.636,109.336z
	 M1323.271,116.293c-2.282,2.215-4.42,4.508-6.406,6.806c-0.277-3.693-0.784-7.446-1.607-11.071
	c5.898-10.7,13.778-22.6,24.09-33.83C1335.273,92.752,1328.647,106.485,1323.271,116.293z M1335.065,120.189
	c0.711-2.328,1.446-4.987,2.17-7.958c1.432,1.241,2.777,2.568,4.036,3.971C1339.034,117.365,1336.959,118.703,1335.065,120.189z
	 M1347.784,141.63c0.444-2.946,1.315-6.725,2.971-10.863c1.466,3.074,2.703,6.178,3.74,9.192
	C1352.186,140.331,1349.935,140.912,1347.784,141.63z M1359.302,139.407c-0.667-1.366-1.42-2.799-2.253-4.275
	c1.361,1.083,2.721,2.168,4.08,3.252C1360.507,138.719,1359.899,139.062,1359.302,139.407z M1363.08,137.384
	c-2.619-1.783-5.24-3.564-7.865-5.342c-0.924-1.482-1.929-2.992-3.03-4.516c2.139-4.387,5.229-9.018,9.66-13.394
	c1.32,8.071,1.975,16.106,2.291,22.747C1363.781,137.044,1363.43,137.212,1363.08,137.384z M1363.608,150.16
	c-0.187-0.6-0.407-1.281-0.672-2.05c0.492-0.087,0.983-0.169,1.475-0.236c0.002,0.92-0.002,1.716-0.01,2.399
	C1364.137,150.236,1363.872,150.198,1363.608,150.16z M1371.65,141.807c-0.127-1.211-0.281-2.634-0.473-4.219
	c0.514-0.439,1.044-0.85,1.582-1.245C1372.33,138.125,1371.952,139.947,1371.65,141.807z M1370.761,134.388
	c-0.399-2.87-0.933-6.127-1.667-9.651c1.415,3.017,2.826,6.034,4.233,9.053C1372.473,133.949,1371.617,134.15,1370.761,134.388z
	 M1373.974,131.87c-1.318-2.294-2.638-4.588-3.96-6.881c2.182-0.075,4.234,0.11,6.159,0.52
	C1375.387,127.532,1374.643,129.658,1373.974,131.87z M1382.328,119.702c0.058,2.471,0.116,4.942,0.173,7.414
	c-0.604-0.264-1.217-0.506-1.839-0.729C1381.149,124.092,1381.721,121.843,1382.328,119.702z M1380.882,143.946
	c-0.557-0.977-1.114-1.954-1.672-2.931c-0.227-4.458,0.367-9.369,1.349-14.129c0.67,0.285,1.323,0.596,1.957,0.935
	c0.094,4.069,0.185,8.139,0.274,12.208C1382.043,141.321,1381.397,142.629,1380.882,143.946z M1385.92,135.417
	c-0.293-2.013-0.587-4.026-0.881-6.039c1.258,0.868,2.438,1.833,3.541,2.878C1387.65,133.283,1386.759,134.339,1385.92,135.417z
	 M1389.715,131.033c-0.076,0.08-0.151,0.16-0.228,0.241c-1.467-1.105-3.003-2.112-4.607-2.983
	c-0.561-3.828-1.125-7.656-1.692-11.484c0.683-2.197,1.376-4.225,2.018-5.991c2.652,0.476,5.011,1.375,7.129,2.578
	C1391.462,119.274,1390.589,125.153,1389.715,131.033z M1393.166,113.887c3.073,1.925,5.585,4.532,7.638,7.534
	c-2.657,1.932-5.571,4.284-8.372,6.921C1392.678,123.523,1392.923,118.705,1393.166,113.887z M1391.374,148.838
	c0.166-3.184,0.331-6.368,0.496-9.553c0.369-0.66,0.745-1.317,1.132-1.975c0.567,0.775,1.103,1.565,1.613,2.366
	C1393.533,142.729,1392.453,145.783,1391.374,148.838z M1395.628,136.82c-0.472-0.5-0.954-0.992-1.447-1.477
	c1.31-2.114,2.709-4.193,4.174-6.202C1397.445,131.7,1396.536,134.26,1395.628,136.82z M1395.271,151.542
	c0.615-2.496,1.231-4.992,1.847-7.488c0.38,0.744,0.745,1.487,1.085,2.222C1397.224,148.031,1396.247,149.786,1395.271,151.542z
	 M1401.265,154.569c0.022-0.061,0.044-0.122,0.067-0.182c0.008,0.029,0.018,0.056,0.027,0.085
	C1401.328,154.504,1401.296,154.537,1401.265,154.569z M1400.349,142.429c-0.684-0.908-1.407-1.817-2.159-2.719
	c1.248-5.052,2.498-10.104,3.75-15.156c0.158-0.191,0.317-0.383,0.475-0.572c1.477,2.612,2.664,5.428,3.62,8.287
	C1404.136,135.654,1402.24,139.041,1400.349,142.429z M1405.495,150.157c-0.504-0.854-1.048-1.743-1.634-2.661
	c1.222-3.324,2.445-6.648,3.67-9.971c0.746,3.077,1.267,6.085,1.621,8.828C1407.932,147.62,1406.713,148.888,1405.495,150.157z
	 M1409.13,156.921c-0.008-0.001-0.017-0.003-0.025-0.004c-0.293-0.616-0.663-1.37-1.11-2.237c0.576-0.851,1.152-1.701,1.729-2.552
	c0.12,1.759,0.172,3.234,0.195,4.347C1409.655,156.624,1409.392,156.773,1409.13,156.921z M1409.487,132.224
	c1.138-3.081,2.277-6.161,3.417-9.241c1.254,6.334,1.794,12.486,2.004,17.403c-0.612,0.633-1.223,1.266-1.834,1.899
	C1412.247,139.294,1411.087,135.792,1409.487,132.224z M1413.972,145.872c0.349-0.512,0.697-1.025,1.046-1.537
	c0.051,4.036-0.104,6.578-0.104,6.578S1414.663,148.935,1413.972,145.872z M1419.917,143.113c0,0-0.236-1.855-0.773-4.831
	c0.794-1.162,1.588-2.325,2.383-3.486C1420.99,137.568,1420.454,140.341,1419.917,143.113z M1457.014,128.418
	c0.921,3.342,1.666,6.78,2.274,10.226c-2.406,0.745-4.718,1.676-6.892,2.696c-0.616-2.143-1.348-4.361-2.226-6.633
	C1452.3,132.546,1454.595,130.403,1457.014,128.418z M1446.934,107.248c3.49,4.235,6.182,9.531,8.248,15.337
	c-2.852,1.541-5.576,3.304-8.122,5.165c-1.768-3.476-3.895-6.99-6.472-10.441C1442.532,113.769,1444.661,110.324,1446.934,107.248z
	 M1440.537,117.4c2.335,3.458,4.12,7.231,5.463,11.136c-10.413,7.866-17.535,16.947-17.536,16.945
	C1428.467,145.482,1433.177,130.836,1440.537,117.4z M1435.906,152.154c0.001,0.001,4.902-7.492,12.284-15.385
	c0.413,2.077,0.735,4.154,0.972,6.205C1441.274,147.236,1435.906,152.155,1435.906,152.154z M1442.156,161.101
	c-0.102-0.147-0.212-0.296-0.316-0.444c1.991-0.281,3.983-0.56,5.976-0.838c-1.915,0.101-3.829,0.203-5.743,0.306
	c1.824-1.436,4.491-3.435,7.686-5.561c-0.014,1.947-0.08,3.799-0.181,5.544C1446.51,159.935,1443.945,160.497,1442.156,161.101z
	 M1456.415,161.694c-0.307-0.127-0.608-0.238-0.91-0.348c-0.046-2.32-0.249-5.727-0.879-9.845c1.72-1.016,3.536-2.007,5.4-2.941
	C1458.632,154.231,1457.28,158.869,1456.415,161.694z M1460.944,125.423c1.222-0.857,2.469-1.647,3.729-2.377
	c-0.252,2.388-0.566,4.774-0.928,7.127C1462.864,128.603,1461.929,127.016,1460.944,125.423z M1471.44,146.256
	c-0.252-0.625-0.515-1.262-0.788-1.91c0.869-0.242,1.735-0.451,2.6-0.632C1472.641,144.54,1472.036,145.385,1471.44,146.256z
	 M1468.278,136.921c0.344-4.841,0.449-10.172,0.084-15.766c3.358-1.507,6.78-2.431,10.164-2.455
	c0.95,5.775,1.254,11.671,1.192,17.195c-0.587,0.638-1.179,1.299-1.776,1.985C1474.739,136.97,1471.485,136.711,1468.278,136.921z
	 M1475.784,158.633c-0.392-1.33-0.905-2.964-1.541-4.839c1.268-3.631,3.05-7.309,5.009-10.781c0.065-0.001,0.125,0.007,0.191,0.007
	c-0.35,5.397-0.961,10.121-1.504,13.569C1477.181,157.251,1476.46,157.933,1475.784,158.633z M1488.361,142.899
	c2.132,1.237,4.095,2.561,5.89,3.954c-0.653,0.28-1.311,0.568-1.973,0.872c-1.226-1.506-2.496-2.822-3.798-3.978
	C1488.442,143.468,1488.401,143.183,1488.361,142.899z M1488.676,145.299c1.189,0.673,2.315,1.515,3.365,2.537
	c-0.987,0.456-1.98,0.936-2.968,1.443C1488.974,148.022,1488.841,146.693,1488.676,145.299z M1489.145,162.283
	c0,0,0.255-2.291,0.229-6.228c1.316-1.162,2.681-2.282,4.06-3.377C1491.102,158.533,1489.145,162.283,1489.145,162.283z
	 M1500.616,166.717c0,0,1.362-4.16,2.41-11.207c1.281,1.604,2.412,3.21,3.412,4.79
	C1503.143,164.432,1500.616,166.718,1500.616,166.717z M1516.301,162.111c-0.038-0.028-0.077-0.056-0.115-0.084
	c1.906-4.553,3.746-10.145,4.909-16.585c0.877,2.065,1.751,4.129,2.624,6.195C1520.937,155.098,1518.429,158.739,1516.301,162.111z
	 M1533.367,161.59c-0.318,0.16-0.635,0.329-0.955,0.514c0.169,0.004,0.313,0.024,0.48,0.03c-0.583,0.665-1.143,1.324-1.68,1.976
	c-0.123-0.236-0.246-0.471-0.37-0.707c1.416-4.868,2.531-10.896,1.848-18.231c1.128-1.441,2.371-2.772,3.759-3.953
	c-0.085,5.782-0.174,11.563-0.267,17.344C1535.201,159.581,1534.256,160.591,1533.367,161.59z M1544.546,150.537
	c-1.995,1.791-3.913,3.585-5.729,5.368c-0.546-5.089-1.096-10.178-1.653-15.268c2.263-1.784,4.874-3.184,7.879-4.087
	c0.576,0.83,1.131,1.672,1.662,2.529C1545.985,142.898,1545.266,146.717,1544.546,150.537z M1569.285,156.748
	c-1.915,0.371-3.887,0.811-5.867,1.327c0.9-2.171,1.802-4.342,2.703-6.513c0.542,0.029,1.084,0.06,1.612,0.127
	c0.609,0.509,1.18,1.037,1.712,1.586C1569.399,154.452,1569.345,155.61,1569.285,156.748z M1566.172,151.441
	c0.102-0.245,0.203-0.49,0.305-0.734c0.344,0.249,0.679,0.503,1.001,0.764C1567.048,151.446,1566.609,151.444,1566.172,151.441z
	 M1569.531,150.759c-0.804-0.505-1.66-0.918-2.547-1.271c0.88-2.118,1.762-4.236,2.643-6.353
	C1569.638,145.721,1569.604,148.272,1569.531,150.759z M1547.429,140.265c1.024,1.732,1.962,3.508,2.824,5.315
	c-1.207,1.015-2.401,2.037-3.575,3.065C1546.929,145.852,1547.179,143.059,1547.429,140.265z M1545.096,166.189
	c0.036-0.396,0.072-0.792,0.108-1.189c0.29,0.159,0.579,0.316,0.849,0.486C1545.725,165.714,1545.412,165.952,1545.096,166.189z
	 M1546.724,161.567c2.004-3.23,4.134-6.329,6.339-9.281c0.036,0.1,0.076,0.199,0.112,0.298c-1.383,3.453-2.765,6.906-4.144,10.359
	C1548.279,162.426,1547.509,161.966,1546.724,161.567z M1548.112,177.623c0.538-1.867,1.076-3.733,1.615-5.6
	c0.438-0.36,0.884-0.708,1.33-1.055c0.172,0.353,0.307,0.722,0.448,1.088C1550.373,173.912,1549.242,175.767,1548.112,177.623z
	 M1552.684,161.783c0.556-1.923,1.112-3.845,1.668-5.768c0.483,1.515,0.914,3.026,1.314,4.529
	C1554.658,160.933,1553.66,161.342,1552.684,161.783z M1557.671,171.966c0.097-0.234,0.193-0.468,0.29-0.702
	c0.082,0.49,0.161,0.977,0.235,1.458C1558.023,172.468,1557.848,172.216,1557.671,171.966z M1564.076,151.554
	c-1.446,2.348-2.89,4.696-4.333,7.045c-1.112-2.519-2.393-5.133-3.881-7.801c0.323-1.115,0.646-2.229,0.969-3.344
	c4.176-5.13,8.473-9.725,12.523-13.7c0.162,2.947,0.247,5.897,0.269,8.808c-1.332,2.155-2.663,4.31-3.992,6.466
	c-0.899-0.26-1.827-0.464-2.81-0.555c0.827,0.412,1.603,0.856,2.339,1.32c-0.354,0.573-0.707,1.147-1.06,1.721
	c-0.325,0.024-0.643,0.028-0.972,0.064C1563.449,151.553,1563.759,151.565,1564.076,151.554z M1561.956,164.035
	c2.399-1.257,4.788-2.368,7.094-3.338c-0.146,2.178-0.311,4.251-0.484,6.196c-0.547,0.522-1.093,1.045-1.64,1.567
	c-1.203-0.281-2.421-0.481-3.647-0.612C1562.883,166.626,1562.444,165.353,1561.956,164.035z M1564.244,171.027
	c-0.241-0.842-0.503-1.716-0.79-2.622c0.962,0.168,1.902,0.398,2.826,0.672C1565.602,169.727,1564.923,170.377,1564.244,171.027z
	 M1566.485,181.125c-0.196-1.319-0.559-3.405-1.187-6.067c0.95-1.286,1.901-2.571,2.852-3.856
	c-0.453,4.358-0.904,7.735-1.181,9.676C1566.807,180.96,1566.646,181.042,1566.485,181.125z M1576.742,154.862
	c0.322,0.191,0.642,0.388,0.955,0.593c-0.302,0.035-0.611,0.074-0.921,0.113C1576.765,155.333,1576.755,155.099,1576.742,154.862z
	 M1579.936,162.362c-0.117,0.036-0.23,0.059-0.345,0.096c0.114-0.035,0.227-0.052,0.341-0.085
	c-0.202,0.492-0.402,0.988-0.598,1.487c-0.669-1.616-1.427-3.182-2.268-4.666c0.339-0.456,0.679-0.912,1.018-1.367
	c-0.388,0.368-0.776,0.736-1.163,1.105c-0.004-0.007-0.008-0.015-0.012-0.022c-0.011-0.373-0.026-0.758-0.039-1.14
	c0.995-0.329,1.933-0.62,2.834-0.89c0.66,0.513,1.304,1.048,1.927,1.614C1581.047,159.755,1580.477,161.043,1579.936,162.362z
	 M1582.379,156.921c-0.278-0.194-0.555-0.39-0.839-0.577c0.45-0.126,0.876-0.243,1.29-0.354
	C1582.679,156.297,1582.529,156.611,1582.379,156.921z M1592.394,147.506c0.519,1.706,0.901,3.41,1.168,5.1
	c-0.661-0.992-1.341-1.98-2.047-2.958C1591.805,148.924,1592.098,148.211,1592.394,147.506z M1590.658,151.853
	c1.231,2.158,2.356,4.356,3.376,6.542c0.008,0.59,0.014,1.18-0.002,1.763c-2.027,0.011-4.104,0.169-6.223,0.463
	C1588.605,157.662,1589.584,154.706,1590.658,151.853z M1586.041,177.722c-0.548-4.075-0.13-8.667,0.863-13.363
	c1.361,1.808,2.604,3.7,3.729,5.62C1588.677,172.46,1587.082,175.054,1586.041,177.722z M1592.982,167.239
	c-1.562-2.006-3.313-4.008-5.25-5.885c2.084,0.041,4.155,0.326,6.204,0.797c-0.113,1.588-0.302,3.143-0.555,4.653
	C1593.244,166.948,1593.116,167.095,1592.982,167.239z M1598.297,160.343c-0.249-0.44-0.505-0.887-0.765-1.336
	c-0.453-5.363-1.508-10.648-3.472-15.301c3.609-7.919,7.158-13.846,7.706-14.747c0.423,5.433,0.841,10.865,1.252,16.297
	c-0.468-0.032-0.928-0.086-1.402-0.104c0.478,0.031,0.938,0.101,1.406,0.152c0.315,4.159,0.627,8.317,0.935,12.475
	c-1.239,0.881-2.467,1.802-3.673,2.76C1599.63,160.454,1598.963,160.4,1598.297,160.343z M1596.629,188.431
	c-0.028-0.031-0.054-0.061-0.083-0.093c0.044-0.004,0.088-0.009,0.131-0.013C1596.66,188.362,1596.646,188.394,1596.629,188.431z
	 M1596.829,188.003c-0.193,0.003-0.385,0.005-0.578,0.008c-0.147-0.161-0.305-0.332-0.461-0.5c0.259-1.446,0.53-3.103,0.79-4.926
	c0.464,1.231,0.869,2.379,1.22,3.426C1597.449,186.708,1597.122,187.377,1596.829,188.003z M1601.058,180.24
	c-0.682-1.396-1.63-3.218-2.847-5.283c0.463-0.687,0.922-1.372,1.409-2.058c0.825,2.624,1.454,4.906,1.895,6.631
	C1601.361,179.767,1601.205,180.005,1601.058,180.24z M1602.69,168.783c0.626-0.804,1.249-1.61,1.9-2.403
	c0.191,2.623,0.382,5.245,0.57,7.868C1605.16,174.248,1604.282,172.098,1602.69,168.783z M1608.053,169.874
	c-0.077-0.564-0.155-1.127-0.233-1.691c0.172,0.109,0.345,0.222,0.517,0.332C1608.146,169.388,1608.053,169.874,1608.053,169.874z
	 M1609.754,162.765c-0.526-0.179-1.06-0.348-1.596-0.511c0.824-0.914,1.654-1.82,2.503-2.704
	C1610.325,160.699,1610.022,161.776,1609.754,162.765z M1613.088,151.996c-2.222,1.249-4.568,2.676-6.924,4.255
	c-0.501-3.584-1.005-7.168-1.512-10.752c3.47,0.552,6.685,1.642,9.658,3.125C1613.877,149.775,1613.472,150.902,1613.088,151.996z"
	/>',
		);

		$ret['mountains1'] = array(
		'name' => __( 'Mountains #1', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_decor1" points="-4,22 28,64 72,32 200,88 274,62 354,128 526,92 568,132 616,102 674,132 916,132 966,94 1016,128 1046,104 1092,148 1274,120 1304,76 1344,116 1426,68 1502,68 1554,26 1604,62 1604,192 -4,194 "/>
<polygon class="gambit_sep_main" points="1350,134 1164,62 1020,190 800,42 560,184 462,48 258,170 166,6 -4,114 -4,206 1604,204 1604,135 1462,0 "/>
<polygon class="gambit_sep_decor2" points="-4,114 167,0 258,158 462,48 258,170 166,6 "/>
<polygon class="gambit_sep_decor2" points="560,176 800,42 560,184 "/>
<polygon class="gambit_sep_decor2" points="1164,62 1350,134 1462,0 1604,135 1604,144.5 1462,6 1352,150 "/>',
		);

		$ret['mountains2'] = array(
		'name' => __( 'Mountains #2', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,188.586 174,76 292,124 402,60 536,108 752,8 882,66 990,32 1210,116 1380,64 1536,150 1604,115.09 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="174,76 174,78 -4,198 -4,188.586 "/>
<polygon class="gambit_sep_decor1" points="292,124 302,138 402,64 402,60 "/>
<polygon class="gambit_sep_decor1" points="536,108 544,120 752,12 752,8 "/>
<polygon class="gambit_sep_decor1" points="882,66 890,78 990,36 990,32 "/>
<polygon class="gambit_sep_decor1" points="1210,116 1222,130 1380,68 1380,64 "/>
<polygon class="gambit_sep_decor1" points="1536,150 1546,164 1604,124 1604,115.09 "/>
<polygon class="gambit_sep_decor2" points="174,76 292,124 282,140 174,78 "/>
<polygon class="gambit_sep_decor2" points="402,60 536,108 528,120 402,64 "/>
<polygon class="gambit_sep_decor2" points="752,8 882,66 874,80 752,12 "/>
<polygon class="gambit_sep_decor2" points="990,32 990,36 1192,130 1210,116 "/>
<polygon class="gambit_sep_decor2" points="1380,64 1536,150 1526,168 1380,68 "/>',
		);

		$ret['mountains3'] = array(
		'name' => __( 'Mountains #3', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_decor1" points="1597.241,172 1590,142 1532,106 1454,114 1292,106 1246,84 1238,90 1228,86 1204,96 1156,76 1110,88 946,58 900,42 818,54 672,84 524,60 396,102 328,94 296,102 272,90 130,134 40,120 -4,132 -4,172 "/>
<polygon class="gambit_sep_main" points="-4,188.586 174,76 292,124 402,60 536,108 752,8 882,66 990,32 1210,116 1380,64 1536,150 1604,115.09 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor2" points="174,76 174,78 -4,198 -4,188.586 "/>
<polygon class="gambit_sep_decor2" points="292,124 302,138 402,64 402,60 "/>
<polygon class="gambit_sep_decor2" points="536,108 544,120 752,12 752,8 "/>
<polygon class="gambit_sep_decor2" points="882,66 890,78 990,36 990,32 "/>
<polygon class="gambit_sep_decor2" points="1210,116 1222,130 1380,68 1380,64 "/>
<polygon class="gambit_sep_decor2" points="1536,150 1546,164 1604,124 1604,115.09 "/>',
		);

		$ret['perforated'] = array(
		'name' => __( 'Perforated', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor2" d="M-42,56v40h1662V56H-42z M-25,84c-5,0-9-4-9-9c0-5,4-9,9-9c5,0,9,4,9,9
C-16,80-20,84-25,84z M11,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C20,80,16,84,11,84z M47,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C56,80,52,84,47,84z M83,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C92,80,88,84,83,84z M119,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C128,80,124,84,119,84z M155,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C164,80,160,84,155,84z M191,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C200,80,196,84,191,84z M227,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C236,80,232,84,227,84z M263,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C272,80,268,84,263,84z M299,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C308,80,304,84,299,84z M335,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C344,80,340,84,335,84z M371,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C380,80,376,84,371,84z M407,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C416,80,412,84,407,84z M443,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C452,80,448,84,443,84z M479,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C488,80,484,84,479,84z M515,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C524,80,520,84,515,84z M551,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C560,80,556,84,551,84z M587,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C596,80,592,84,587,84z M623,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C632,80,628,84,623,84z M659,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C668,80,664,84,659,84z M695,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C704,80,700,84,695,84z M731,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C740,80,736,84,731,84z M767,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C776,80,772,84,767,84z M803,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C812,80,808,84,803,84z M839,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C848,80,844,84,839,84z M875,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C884,80,880,84,875,84z M911,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C920,80,916,84,911,84z M947,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C956,80,952,84,947,84z M983,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C992,80,988,84,983,84z M1019,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1028,80,1024,84,1019,84z M1055,84c-5,0-9-4-9-9c0-5,4-9,9-9
s9,4,9,9C1064,80,1060,84,1055,84z M1091,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1100,80,1096,84,1091,84z M1127,84c-5,0-9-4-9-9
c0-5,4-9,9-9s9,4,9,9C1136,80,1132,84,1127,84z M1163,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1172,80,1168,84,1163,84z M1199,84
c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1208,80,1204,84,1199,84z M1235,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1244,80,1240,84,1235,84z
 M1271,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1280,80,1276,84,1271,84z M1307,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C1316,80,1312,84,1307,84z M1343,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1352,80,1348,84,1343,84z M1379,84c-5,0-9-4-9-9c0-5,4-9,9-9
s9,4,9,9C1388,80,1384,84,1379,84z M1415,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1424,80,1420,84,1415,84z M1451,84c-5,0-9-4-9-9
c0-5,4-9,9-9s9,4,9,9C1460,80,1456,84,1451,84z M1487,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1496,80,1492,84,1487,84z M1523,84
c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1532,80,1528,84,1523,84z M1559,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1568,80,1564,84,1559,84z
 M1595,84c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1604,80,1600,84,1595,84z"/>
<path class="gambit_sep_main" d="M-38,60v159.5h1662V60H-38z M-21,88c-5,0-9-4-9-9c0-5,4-9,9-9c5,0,9,4,9,9
C-12,84-16,88-21,88z M15,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C24,84,20,88,15,88z M51,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C60,84,56,88,51,88z M87,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C96,84,92,88,87,88z M123,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C132,84,128,88,123,88z M159,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C168,84,164,88,159,88z M195,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C204,84,200,88,195,88z M231,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C240,84,236,88,231,88z M267,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C276,84,272,88,267,88z M303,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C312,84,308,88,303,88z M339,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C348,84,344,88,339,88z M375,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C384,84,380,88,375,88z M411,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C420,84,416,88,411,88z M447,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C456,84,452,88,447,88z M483,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C492,84,488,88,483,88z M519,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C528,84,524,88,519,88z M555,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C564,84,560,88,555,88z M591,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C600,84,596,88,591,88z M627,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C636,84,632,88,627,88z M663,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C672,84,668,88,663,88z M699,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C708,84,704,88,699,88z M735,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C744,84,740,88,735,88z M771,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C780,84,776,88,771,88z M807,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C816,84,812,88,807,88z M843,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C852,84,848,88,843,88z M879,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C888,84,884,88,879,88z M915,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C924,84,920,88,915,88z M951,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C960,84,956,88,951,88z M987,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C996,84,992,88,987,88z M1023,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1032,84,1028,88,1023,88z M1059,88c-5,0-9-4-9-9c0-5,4-9,9-9
s9,4,9,9C1068,84,1064,88,1059,88z M1095,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1104,84,1100,88,1095,88z M1131,88c-5,0-9-4-9-9
c0-5,4-9,9-9s9,4,9,9C1140,84,1136,88,1131,88z M1167,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1176,84,1172,88,1167,88z M1203,88
c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1212,84,1208,88,1203,88z M1239,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1248,84,1244,88,1239,88z
 M1275,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1284,84,1280,88,1275,88z M1311,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9
C1320,84,1316,88,1311,88z M1347,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1356,84,1352,88,1347,88z M1383,88c-5,0-9-4-9-9c0-5,4-9,9-9
s9,4,9,9C1392,84,1388,88,1383,88z M1419,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1428,84,1424,88,1419,88z M1455,88c-5,0-9-4-9-9
c0-5,4-9,9-9s9,4,9,9C1464,84,1460,88,1455,88z M1491,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1500,84,1496,88,1491,88z M1527,88
c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1536,84,1532,88,1527,88z M1563,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1572,84,1568,88,1563,88z
 M1599,88c-5,0-9-4-9-9c0-5,4-9,9-9s9,4,9,9C1608,84,1604,88,1599,88z"/>'
		);

		$ret['perforated-slant'] = array(
		'name' => __( 'Perforated Slant', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor2" d="M-34.665,3.744l-7.672,85.657L1616.948,194l3.761-41.998L-34.665,3.744z M-10.463,24.987 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C-13.674,15.664-10.02,20.036-10.463,24.987z M25.393,28.199c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C22.183,18.875,25.836,23.248,25.393,28.199z M61.25,31.41c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C58.039,22.086,61.693,26.459,61.25,31.41z M97.106,34.621c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C93.896,25.298,97.549,29.671,97.106,34.621z M132.963,37.833c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C129.752,28.509,133.406,32.882,132.963,37.833z M168.819,41.044c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C165.608,31.721,169.262,36.093,168.819,41.044z M204.675,44.255c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C201.465,34.932,205.119,39.305,204.675,44.255z M240.532,47.467c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767s4.816-8.605,9.767-8.161S240.975,42.516,240.532,47.467z M276.388,50.678 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C273.178,41.355,276.832,45.727,276.388,50.678z M312.245,53.89c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161S312.688,48.939,312.245,53.89z M348.101,57.101 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C344.891,47.777,348.545,52.15,348.101,57.101z M383.958,60.312c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C380.747,50.989,384.401,55.362,383.958,60.312z M419.814,63.524c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C416.604,54.2,420.258,58.573,419.814,63.524z M455.671,66.735c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C452.46,57.411,456.114,61.784,455.671,66.735z M491.527,69.946c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C488.317,60.623,491.971,64.996,491.527,69.946z M527.384,73.158c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C524.173,63.834,527.827,68.207,527.384,73.158z M563.24,76.369c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767s4.816-8.605,9.767-8.161 C560.03,67.046,563.684,71.418,563.24,76.369z M599.097,79.581c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C595.886,70.257,599.54,74.63,599.097,79.581z M634.953,82.792c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 S635.397,77.841,634.953,82.792z M670.81,86.003c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161C667.599,76.68,671.253,81.053,670.81,86.003z M706.666,89.215 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C703.456,79.891,707.11,84.264,706.666,89.215z M742.523,92.426c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C739.312,83.102,742.966,87.475,742.523,92.426z M778.379,95.637c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C775.169,86.314,778.823,90.687,778.379,95.637z M814.236,98.849c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C811.025,89.525,814.679,93.898,814.236,98.849z M850.092,102.06c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C846.882,92.737,850.535,97.109,850.092,102.06z M885.949,105.272c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C882.738,95.948,886.392,100.321,885.949,105.272z M921.805,108.483c-0.443,4.951-4.816,8.605-9.767,8.161s-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C918.595,99.159,922.248,103.532,921.805,108.483z M957.661,111.694c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767s4.816-8.605,9.767-8.161S958.105,106.744,957.661,111.694z M993.518,114.906 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C990.307,105.582,993.961,109.955,993.518,114.906z M1029.375,118.117c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1026.164,108.793,1029.818,113.166,1029.375,118.117z M1065.231,121.328c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161C1062.021,112.005,1065.674,116.378,1065.231,121.328z M1101.087,124.54 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C1097.877,115.216,1101.531,119.589,1101.087,124.54z M1136.944,127.751c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1133.733,118.428,1137.387,122.8,1136.944,127.751z M1172.8,130.962c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C1169.59,121.639,1173.244,126.012,1172.8,130.962z M1208.657,134.174c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1205.446,124.85,1209.1,129.223,1208.657,134.174z M1244.513,137.385c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161C1241.303,128.062,1244.957,132.434,1244.513,137.385z M1280.37,140.597 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C1277.159,131.273,1280.813,135.646,1280.37,140.597z M1316.226,143.808c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767s4.816-8.605,9.767-8.161S1316.67,138.857,1316.226,143.808z M1352.083,147.019 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767s4.816-8.605,9.767-8.161 S1352.526,142.069,1352.083,147.019z M1387.939,150.231c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1384.729,140.907,1388.383,145.28,1387.939,150.231z M1423.796,153.442c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161C1420.585,144.119,1424.239,148.491,1423.796,153.442z M1459.652,156.653 c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C1456.442,147.33,1460.096,151.703,1459.652,156.653z M1495.509,159.865c-0.443,4.951-4.816,8.605-9.767,8.161 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1492.298,150.541,1495.952,154.914,1495.509,159.865z M1531.365,163.076c-0.443,4.951-4.816,8.605-9.767,8.161c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161C1528.155,153.753,1531.809,158.125,1531.365,163.076z M1567.222,166.288 c-0.443,4.951-4.816,8.605-9.767,8.161s-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 C1564.011,156.964,1567.665,161.337,1567.222,166.288z M1603.078,169.499c-0.443,4.951-4.816,8.605-9.767,8.161 s-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161C1599.868,160.175,1603.521,164.548,1603.078,169.499z"/>
<path class="gambit_sep_main" d="M-31.038,8.085L-38.709,214l1655.374,28l7.672-85.657L-31.038,8.085z M-16.603,37.489c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C-7.28,34.279-11.652,37.933-16.603,37.489z M19.253,40.701c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767C28.577,37.49,24.204,41.144,19.253,40.701z M55.11,43.912 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767 C64.433,40.702,60.061,44.356,55.11,43.912z M90.966,47.124c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C100.29,43.913,95.917,47.567,90.966,47.124z M126.823,50.335c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C136.146,47.124,131.774,50.778,126.823,50.335z M162.679,53.546c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C172.003,50.336,167.63,53.99,162.679,53.546z M198.536,56.758c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C207.859,53.547,203.486,57.201,198.536,56.758z M234.392,59.969c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C243.716,56.758,239.343,60.412,234.392,59.969z M270.249,63.18c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C279.572,59.97,275.199,63.624,270.249,63.18z M306.105,66.392c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C315.429,63.181,311.056,66.835,306.105,66.392z M341.962,69.603c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C351.285,66.393,346.912,70.047,341.962,69.603z M377.818,72.814c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C387.142,69.604,382.769,73.258,377.818,72.814z M413.675,76.026c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C422.998,72.815,418.625,76.469,413.675,76.026z M449.531,79.237c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C458.855,76.027,454.482,79.681,449.531,79.237z M485.388,82.449c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C494.711,79.238,490.338,82.892,485.388,82.449z M521.244,85.66c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C530.568,82.449,526.195,86.103,521.244,85.66z M557.101,88.871c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C566.424,85.661,562.051,89.315,557.101,88.871z M592.957,92.083c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C602.281,88.872,597.908,92.526,592.957,92.083z M628.813,95.294c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C638.137,92.084,633.764,95.737,628.813,95.294z M664.67,98.505c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767C673.994,95.295,669.621,98.949,664.67,98.505z M700.526,101.717 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C709.85,98.506,705.477,102.16,700.526,101.717z M736.383,104.928c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C745.706,101.718,741.334,105.372,736.383,104.928z M772.239,108.14c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C781.563,104.929,777.19,108.583,772.239,108.14z M808.096,111.351c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C817.419,108.14,813.047,111.794,808.096,111.351z M843.952,114.562c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767 C853.276,111.352,848.903,115.006,843.952,114.562z M879.809,117.774c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C889.132,114.563,884.76,118.217,879.809,117.774z M915.665,120.985c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C924.989,117.774,920.616,121.428,915.665,120.985z M951.522,124.196c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C960.845,120.986,956.473,124.64,951.522,124.196z M987.378,127.408c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C996.702,124.197,992.329,127.851,987.378,127.408z M1023.235,130.619c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767C1032.558,127.409,1028.186,131.063,1023.235,130.619z M1059.091,133.831c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161s8.605,4.816,8.161,9.767 C1068.415,130.62,1064.042,134.274,1059.091,133.831z M1094.948,137.042c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1104.271,133.831,1099.898,137.485,1094.948,137.042z M1130.804,140.253c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 c4.951,0.443,8.605,4.816,8.161,9.767C1140.128,137.043,1135.755,140.697,1130.804,140.253z M1166.661,143.465 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C1175.984,140.254,1171.611,143.908,1166.661,143.465z M1202.517,146.676c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1211.841,143.465,1207.468,147.119,1202.517,146.676z M1238.374,149.887c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 c4.951,0.443,8.605,4.816,8.161,9.767C1247.697,146.677,1243.324,150.331,1238.374,149.887z M1274.23,153.099 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C1283.554,149.888,1279.181,153.542,1274.23,153.099z M1310.087,156.31c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1319.41,153.1,1315.037,156.754,1310.087,156.31z M1345.943,159.522c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 c4.951,0.443,8.605,4.816,8.161,9.767C1355.267,156.311,1350.894,159.965,1345.943,159.522z M1381.8,162.733 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C1391.123,159.522,1386.75,163.176,1381.8,162.733z M1417.656,165.944c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1426.98,162.734,1422.607,166.388,1417.656,165.944z M1453.512,169.156c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161 c4.951,0.443,8.605,4.816,8.161,9.767C1462.836,165.945,1458.463,169.599,1453.512,169.156z M1489.369,172.367 c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C1498.693,169.156,1494.32,172.81,1489.369,172.367z M1525.225,175.578c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1534.549,172.368,1530.176,176.022,1525.225,175.578z M1561.082,178.79c-4.951-0.443-8.605-4.816-8.161-9.767c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767 C1570.406,175.579,1566.033,179.233,1561.082,178.79z M1596.938,182.001c-4.951-0.443-8.605-4.816-8.161-9.767 c0.443-4.951,4.816-8.605,9.767-8.161c4.951,0.443,8.605,4.816,8.161,9.767C1606.262,178.791,1601.889,182.445,1596.938,182.001z" />',
		);

		$ret['pine-trees'] = array(
		'name' => __( 'Pine Trees', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1604,40c-3.7-6.4-7.2-14.5-10-25c-5.8,21.6-14.7,33.5-21.5,39.9
c-5.2-7-10.6-17.2-14.5-31.9c-6.3,23.6-16.4,35.6-23.3,41.4c-3.2-7.4-6.1-15.8-8.7-25.4c-7.2,26.9-17.5,44.4-26.8,55.6
c-3.4-6.2-6.6-13.9-9.2-23.6c-3.6,13.7-8.6,23.4-13.4,30.4c-4.4-4.7-9.2-11.1-13.8-20.1h20.1c0,0-20.6-7.7-30.9-46.3
c-3.3,12.4-7.7,21.6-12.1,28.4c-9.1-11.2-19-28.4-25.9-54.4c-10.9,41-29.1,60.1-40,68.3c-4.4-6.8-8.7-15.9-12-28.3
c-6.3,23.6-16.4,35.6-23.3,41.4c-9.3-11.1-19.6-28.6-26.7-55.4c-6.2,23.4-14.9,39.7-23.2,50.9c-5.9-7-12.3-18-16.8-34.9
c-6,22.5-15.5,34.5-22.3,40.6c-2.9-3.9-6-8.6-8.9-14.3h20.1c0,0-20.6-7.7-30.9-46.3c-6.6,25-17.6,37-24.5,42.4
c-9.5-11.1-20.2-28.8-27.5-56.4c-13.6,51.1-38.6,68.2-46.6,72.5c-7.7-11.1-15.6-26.7-21.4-48.5c-7.7,29-19,47-28.9,58
c-4.8-6.9-9.5-16.6-13.1-30c-4.8,18.2-12,29.5-18.1,36.4c-9.1-11.2-18.9-28.4-25.9-54.4c-4.8,18.1-11,31.9-17.4,42.4
C999.6,88,988.7,76,982,51c-4.3,16-10.3,26.6-15.9,33.7c-9.2-5.4-32.3-23.3-45.1-71.7c-7.9,29.9-19.8,48.1-29.8,59
c-4.1-6.6-8.1-15.4-11.2-27c-10.3,38.6-30.9,46.3-30.9,46.3h20.1c-8.1,15.9-17.2,24.1-22.6,27.9c-7-7.4-14.9-17.9-22.4-32.5h32
c0,0-32.8-12.2-49.1-73.7c-7,26.2-16.9,43.4-26,54.6c-4-6.6-7.9-15.3-11-26.6c-2.2,8.3-4.9,15.2-7.8,20.9
C753.1,50.7,743,33.4,736,7c-11.7,44-31.8,62.8-42.3,69.9c-6.1-6.9-13-18.1-17.7-35.9c-6.3,23.6-16.4,35.6-23.3,41.4
c-7.5-11-15.1-26.3-20.7-47.4c-6.2,23.5-14.9,39.7-23.2,50.9c-3.3-6.1-6.3-13.6-8.8-22.9c-9.2,34.6-26.7,44.3-30.2,46h-0.6
c-6.3-10.5-12.4-24.1-17.2-42c-3.9,14.7-8.7,26.5-13.8,36.1c-6.9-5.5-17.6-17.5-24.2-42.1c-3.3,12.4-7.6,21.6-12,28.4
c-7.3-10.9-14.5-25.9-20-46.4c-5.6,21.2-13.2,36.6-20.8,47.6c-6.4-6.8-14.1-18.3-19.2-37.6c-7,26.5-18.9,38.4-25.7,43.3
c-9.7-11-20.7-28.9-28.3-57.3c-5,18.9-11.6,33.2-18.3,43.8c-6.1-6.9-13-18.1-17.7-35.8c-2.9,11.1-6.7,19.6-10.7,26.1
C330.3,64,314.1,44.8,304,7c-16.4,61.5-49.1,73.7-49.1,73.7h32c-10.5,20.5-21.8,32.8-30.4,40.1c-5.2-7-10.5-17.2-14.4-31.8
c-1.1,4.3-2.4,8.1-3.7,11.7c-6.7-4.6-19-16.5-26.3-43.7c-10.3,38.6-30.9,46.3-30.9,46.3h20.1c-1,2-2.1,3.9-3.2,5.7h-35.3
c-6.5-4.4-19.3-16.1-26.7-44c-7.1,26.7-19.1,38.6-25.9,43.4c-5.1-7-10.3-17.1-14.1-31.4c-2.5,9.5-5.7,17.2-9,23.3
C78.1,89.1,68.7,72.2,62,47c-3.8,14.1-8.4,25.7-13.3,35.1C42,75.6,33.5,63.8,28,43c-1.9,7-4.1,13-6.4,18.1C12.6,49.9,2.9,32.8-4,7
c-0.6,2.4-1.3,4.7-2,7v171h1610V40z"/>
<path class="gambit_sep_decor2" d="M91.5,156.1h15.1c0,0-13-5.1-24.2-26.9h17.5c0,0-17.9-6.7-26.9-40.3
c-8.9,33.6-26.9,40.3-26.9,40.3h17.5c-11.1,21.8-24.2,26.9-24.2,26.9h15.1C40.4,177.7,26,183,26,183h94
C120,183,105.6,177.7,91.5,156.1z"/>
<path class="gambit_sep_decor2" d="M371.3,157.9h14.1c0,0-12.2-4.7-22.6-25.1h16.4c0,0-16.8-6.3-25.1-37.7
c-8.4,31.5-25.1,37.7-25.1,37.7h16.4c-10.4,20.4-22.6,25.1-22.6,25.1h14.1C323.5,178,310,183,310,183h88
C398,183,384.5,178,371.3,157.9z"/>
<path class="gambit_sep_decor2" d="M715.6,148.7h19.3c0,0-16.6-6.5-30.9-34.3h22.3c0,0-22.9-8.5-34.3-51.4
c-11.4,42.9-34.3,51.4-34.3,51.4H680c-14.2,27.8-30.9,34.3-30.9,34.3h19.3C650.4,176.2,632,183,632,183h120
C752,183,733.6,176.2,715.6,148.7z"/>
<path class="gambit_sep_decor2" d="M995.8,152.7h17c0,0-14.7-5.7-27.3-30.3h19.7c0,0-20.2-7.5-30.3-45.4
c-10.1,37.9-30.3,45.4-30.3,45.4h19.7c-12.6,24.6-27.3,30.3-27.3,30.3h17C938.2,177,922,183,922,183h106
C1028,183,1011.8,177,995.8,152.7z"/>
<path class="gambit_sep_decor2" d="M1220.6,151.6h17.7c0,0-15.3-5.9-28.3-31.4h20.4c0,0-21-7.8-31.4-47.1
c-10.5,39.3-31.4,47.1-31.4,47.1h20.4c-13,25.5-28.3,31.4-28.3,31.4h17.7c-16.6,25.2-33.4,31.4-33.4,31.4h110
C1254,183,1237.2,176.8,1220.6,151.6z"/>
<path class="gambit_sep_decor2" d="M1352.9,161.3h12.2c0,0-10.5-4.1-19.5-21.7h14.1c0,0-14.5-5.4-21.7-32.6
c-7.2,27.2-21.7,32.6-21.7,32.6h14.1c-9,17.6-19.5,21.7-19.5,21.7h12.2c-11.4,17.4-23.1,21.7-23.1,21.7h76
C1376,183,1364.4,178.7,1352.9,161.3z"/>
<path class="gambit_sep_decor2" d="M1587.2,152.1h17.4c0,0-15-5.8-27.8-30.9h20.1c0,0-20.6-7.7-30.9-46.3
c-10.3,38.6-30.9,46.3-30.9,46.3h20.1c-12.8,25-27.8,30.9-27.8,30.9h17.4c-16.3,24.7-32.8,30.9-32.8,30.9h104h4
C1620,183,1603.5,176.9,1587.2,152.1z"/>
<path class="gambit_sep_main" d="M1474,179c0,0-17.1-6.3-34-32h18c0,0-15.5-6-28.8-32h20.8c0,0-21.3-8-32-48
c-10.7,40-32,48-32,48h20.8c-13.3,26-28.8,32-28.8,32h18c-16.9,25.7-34,32-34,32h-32c0,0-18.7-6.9-37-34.9h19.6
c0,0-16.9-6.6-31.4-34.9h22.7c0,0-23.3-8.7-34.9-52.3c-11.6,43.6-34.9,52.3-34.9,52.3h22.7c-14.5,28.3-31.4,34.9-31.4,34.9h19.6
c-18.4,28-37,34.9-37,34.9h-32c0,0-13.2-4.9-26.1-24.6h13.8c0,0-11.9-4.6-22.1-24.6h16c0,0-16.4-6.1-24.6-36.9
c-8.2,30.7-24.6,36.9-24.6,36.9h16c-10.2,19.9-22.1,24.6-22.1,24.6h13.8c-12.9,19.7-26.1,24.6-26.1,24.6H930c0,0-21.4-7.9-42.5-40
H910c0,0-19.4-7.5-36-40h26c0,0-26.7-10-40-60c-13.3,50-40,60-40,60h26c-16.6,32.5-36,40-36,40h22.5c-21.1,32.1-42.5,40-42.5,40
H652c0,0-20.5-7.6-40.7-38.3h21.5c0,0-18.6-7.2-34.5-38.3h24.9c0,0-25.5-9.5-38.3-57.4c-12.7,47.9-38.3,57.4-38.3,57.4h24.9
c-15.9,31.1-34.5,38.3-34.5,38.3h21.5C538.5,171.4,518,179,518,179h-38c0,0-16.8-6.2-33.4-31.4h17.7c0,0-15.3-5.9-28.3-31.4h20.4
c0,0-21-7.8-31.4-47.1c-10.5,39.3-31.4,47.1-31.4,47.1H414c-13,25.5-28.3,31.4-28.3,31.4h17.7C386.8,172.8,370,179,370,179H250
c0,0-21.4-7.9-42.5-40H230c0,0-19.4-7.5-36-40h26c0,0-26.7-10-40-60c-13.3,50-40,60-40,60h26c-16.6,32.5-36,40-36,40h22.5
c-21.1,32.1-42.5,40-42.5,40H-4v70.5h1608V179H1474z"/>
		');

		$ret['pine-trees-bend'] = array(
		'name' => __( 'Pine Trees Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1615.6,58.4c-8.6,20.7-19.2,31.4-26.8,36.8c-4.4-7.6-8.7-18.4-10.9-33.4
c-9.2,22.6-20.9,33.4-28.6,38.3c-2.4-7.7-4.4-16.4-6-26.2c-10.4,25.9-22.8,42.1-33.4,52.2c-2.8-6.5-5.2-14.5-6.8-24.4
c-5.2,13.2-11.2,22.4-16.8,28.8c-3.9-5.1-8.1-12.1-11.9-21.5c6.8,0.7,13.6,1.4,20.4,2.1c0,0-20-9.9-26.6-49.3
c-4.6,12-10,20.7-15.2,27c-8.1-12.1-16.5-30.2-21.1-56.8c-15.1,39.7-35.4,57-47.2,64.2c-3.8-7.1-7.4-16.7-9.7-29.2
c-8.5,22.9-19.8,34-27.3,39.2c-8.5-11.9-17.5-30.1-22.7-57.5c-8.3,22.9-18.3,38.4-27.6,48.9c-5.4-7.4-11.2-18.9-14.5-36.1
c-7.8,22-18.2,33.2-25.7,38.8c-2.7-4.1-5.5-9-8-14.9c6.8,0.5,13.6,1,20.4,1.4c0,0-20.4-9.2-28.3-48.4
c-8.5,24.4-20.4,35.7-27.8,40.6c-9-11.7-18.8-30-24.7-58c-17,50.2-43.2,65.9-51.6,69.7c-7.3-11.5-14.5-27.5-19.4-49.5
c-9.3,28.5-21.7,46-32.1,56.5c-4.5-7.1-9-17-12.1-30.5c-5.7,18-13.4,29-19.9,35.6c-8.8-11.5-18.2-29.1-24.3-55.3
c-5.6,17.9-12.4,31.5-19.2,41.8c-6.8-5.6-17.6-18-23.7-43.2c-4.8,15.8-11.2,26.3-17.1,33.2c-9.3-5.7-32.3-24.1-44.6-72.7
c-8.8,29.7-21.1,47.7-31.5,58.5C889,58.6,885,49.8,882,38.2c-11,38.5-32,46-32,46c6.8,0.1,13.6,0.1,20.4,0.2
c-8.5,15.8-17.6,23.9-23.2,27.7c-7.1-7.5-15-18-22.5-32.6c10.8,0,21.7,0.1,32.5,0.2c0,0-33.2-12.5-49.9-74
c-7.2,26.2-17.4,43.4-26.7,54.6c-4.1-6.6-8.2-15.2-11.3-26.6c-2.2,8.3-4.9,15.2-7.8,20.9C752,43.5,741.6,26.3,734.1,0
c-11.6,44.1-31.9,63.1-42.4,70.4c-6.3-6.8-13.5-17.9-18.7-35.6c-6,23.7-16,36-23,41.9c-7.9-10.8-16-25.9-22.3-46.9
c-5.8,23.6-14.1,40.1-22.2,51.6c-3.5-5.9-6.9-13.4-9.7-22.6c-8.3,34.8-25.7,45.2-29.2,47c-0.2,0-0.4,0-0.6,0
c-6.8-10.2-13.5-23.7-19.1-41.3c-3.4,14.8-7.9,26.9-12.7,36.6c-7.3-5.2-18.6-16.8-26.4-41C505,72.7,501,82,496.8,89
c-7.9-10.6-16-25.2-22.6-45.3c-4.7,21.5-11.7,37.2-18.8,48.6c-6.9-6.4-15.3-17.5-21.6-36.4c-5.7,26.8-17.1,39.4-23.7,44.7
c-10.5-10.4-22.8-27.6-32.4-55.4c-3.9,19.2-9.7,33.9-15.8,45c-6.6-6.5-14.4-17.2-20.5-34.5c-2.2,11.3-5.5,20-9,26.8
c-11.9-8.4-29.9-26.2-43.1-63.1c-12.1,62.6-44.2,77.5-44.3,77.6c10.8-0.9,21.7-1.8,32.5-2.7c-9,21.2-19.4,34.5-27.5,42.5
c-5.8-6.5-12.1-16.2-17.3-30.4c-0.8,4.3-1.7,8.3-2.8,12c-7.2-4-20.7-14.7-30.6-41.1c-6.9,39.4-27,49-27,49
c6.8-0.7,13.5-1.3,20.3-1.9c-0.9,2.1-1.8,4.1-2.7,6c-11.9,1.1-23.8,2.3-35.7,3.5c-7-3.7-21.1-14.1-31.6-41
c-4.5,27.3-15.4,40.4-21.7,45.9c-5.9-6.4-12.3-15.8-17.7-29.7c-1.5,9.8-3.9,17.7-6.6,24.2C66.7,123,55.2,107.3,45.5,83.1
c-2.2,14.5-5.6,26.5-9.5,36.4c-7.5-5.7-17.5-16.3-25.7-36.3C9.3,90.4,7.8,96.6,6,101.9c-10.5-10-22.5-25.7-32.8-50.4
c-0.4,2.5-0.7,4.9-1.2,7.2c7.3,57.9,10.2,77.5,17.5,135.4l1619.5-1.6c6.2-49.3,7.4-58.7,13.6-108
C1619.7,77.7,1617.1,69.1,1615.6,58.4z"/>
<path class="gambit_sep_decor2" d="M85.8,155c5.1-0.6,10.1-1.1,15.2-1.7c0,0-13.6-3.6-27.3-24c5.9-0.7,11.7-1.3,17.6-1.9
c0,0-18.8-4.7-31.6-37c-5.3,34.4-22.6,43.1-22.6,43.1c5.9-0.7,11.7-1.4,17.6-2C46,154.4,33.5,161,33.5,161
c5.1-0.6,10.1-1.2,15.2-1.8c-11.7,23-25.4,30-25.5,30l94.1-10.6C117.3,178.6,102.4,174.9,85.8,155z"/>
<path class="gambit_sep_decor2" d="M367.5,131.9c4.7-0.3,9.5-0.6,14.2-0.9c0,0-12.6-3.9-24.5-23.6c5.5-0.4,11-0.7,16.5-1.1
c0,0-17.3-5.1-28-35.9c-6.3,32-22.8,39.4-22.8,39.4c5.5-0.4,11-0.8,16.5-1.2c-9.1,21.1-21,26.7-21,26.7c4.7-0.4,9.5-0.7,14.2-1
c-11.9,21.1-25,27.1-25,27.1l88.3-6.1C396,155.3,382.2,151.1,367.5,131.9z"/>
<path class="gambit_sep_decor2" d="M714.6,108.9c6.5-0.1,13-0.2,19.5-0.2c0,0-16.8-6.3-31.7-33.9c7.5-0.1,15.1-0.2,22.6-0.3
c0,0-23.3-8.2-35.7-50.9c-11,43.1-33.9,52.1-33.9,52.1c7.5-0.2,15.1-0.3,22.6-0.5c-13.9,28.1-30.5,34.9-30.5,34.9
c6.5-0.2,13-0.3,19.5-0.4c-17.7,27.9-35.9,35.1-35.9,35.1l120.6-2.1C751.7,142.8,733.3,136.1,714.6,108.9z"/>
<path class="gambit_sep_decor2" d="M997.7,115.2c5.7,0.2,11.5,0.3,17.2,0.5c0,0-14.6-6.2-26.7-31.1c6.7,0.2,13.3,0.4,20,0.6
c0,0-20.2-8.2-29.5-46.3c-11.3,37.6-31.9,44.7-31.9,44.7c6.7,0.1,13.3,0.3,20,0.5c-13.4,24.3-28.3,29.6-28.3,29.7
c5.7,0.1,11.5,0.2,17.2,0.4c-16.7,23.9-33,29.6-33,29.6l106.5,2.8C1029.2,146.5,1013.1,139.9,997.7,115.2z"/>
<path class="gambit_sep_decor2" d="M1224.6,124.7c5.9,0.4,11.9,0.8,17.8,1.2c0,0-15-6.9-26.6-33.2c6.9,0.4,13.8,0.9,20.7,1.3
c0,0-20.7-9.2-29-49.1c-13.1,38.6-34.7,45.2-34.7,45.2c6.9,0.4,13.8,0.8,20.7,1.2c-14.7,24.7-30.4,29.7-30.4,29.7
c5.9,0.3,11.9,0.7,17.8,1c-18.1,24.2-35.3,29.5-35.3,29.5l110.4,6.7C1256.1,158.3,1239.7,150.9,1224.6,124.7z"/>
<path class="gambit_sep_decor2" d="M1357.2,144.3c4.1,0.3,8.2,0.7,12.3,1.1c0,0-10.2-5-17.9-23.3c4.8,0.4,9.5,0.8,14.3,1.2
c0,0-14.1-6.6-19.2-34.3c-9.6,26.5-24.6,30.7-24.6,30.7c4.8,0.4,9.5,0.8,14.3,1.1c-10.5,16.8-21.4,20.1-21.4,20.1
c4.1,0.3,8.2,0.6,12.3,1c-12.9,16.4-24.9,19.8-24.9,19.8l76.2,6.3C1378.5,168,1367.2,162.7,1357.2,144.3z"/>
<path class="gambit_sep_decor2" d="M1593.7,159.5c5.8,0.7,11.6,1.4,17.4,2.1c0,0-14.3-7.6-24.2-34c6.8,0.8,13.5,1.6,20.3,2.5
c0,0-19.8-10.2-25.7-49.7c-15,37.1-36.6,42.4-36.6,42.4c6.8,0.8,13.5,1.5,20.3,2.3c-15.8,23.4-31.5,27.5-31.5,27.5
c5.8,0.7,11.6,1.3,17.4,2c-19.1,22.7-36.3,27-36.3,27l104,12.2c1.3,0.2,2.7,0.3,4,0.5C1622.7,194.2,1607,186,1593.7,159.5z"/>
<path class="gambit_sep_main" d="M1475.4,177c0,0-16.4-8.1-30.8-35.3c6,0.6,12.1,1.2,18.1,1.8
c0,0-15-7.6-25.8-34.8c7,0.7,14,1.4,21,2.1c0,0-20.7-10.1-27.7-51c-14.7,38.8-36.9,44.7-37,44.7c7,0.6,14,1.3,21,2
c-15.9,24.6-32,29.2-32,29.2c6,0.5,12.1,1.1,18.1,1.7c-19.3,24-37,28.8-37,28.8c-10.7-0.9-21.3-1.9-32-2.7c0,0-18.1-8.4-34.4-37.7
c6.6,0.5,13.2,1,19.7,1.6c0,0-16.5-7.9-29-37.2c7.6,0.6,15.3,1.2,22.9,1.8c0,0-22.8-10.5-31.5-54.8c-15,42.6-39.1,49.6-39.1,49.7
c7.7,0.5,15.3,1.1,23,1.6c-16.7,27.2-34.1,32.6-34.1,32.6c6.6,0.4,13.2,0.9,19.7,1.3c-20.4,26.6-39.5,32.3-39.5,32.3
c-10.7-0.7-21.4-1.3-32.1-2c0,0-12.9-5.6-24.8-26c4.6,0.3,9.3,0.5,13.9,0.8c0,0-11.7-5.3-20.9-25.8c5.4,0.3,10.8,0.6,16.1,0.9
c0,0-16.2-7-22.9-38.1c-9.9,30.3-26.7,35.6-26.7,35.6c5.4,0.3,10.8,0.5,16.1,0.8c-11.3,19.4-23.5,23.4-23.5,23.4
c4.6,0.2,9.3,0.4,13.9,0.7c-14,19-27.4,23.3-27.4,23.3c-53.5-2.4-107-4.2-160.5-5.3c0,0-21.3-8.4-42.1-40.7
c7.6,0.1,15.1,0.2,22.7,0.4c0,0-19.4-7.9-35.9-40.5c8.8,0.1,17.6,0.2,26.4,0.4c0,0-26.9-10.4-40.1-60.5
c-14.1,49.9-41.2,59.7-41.2,59.7c8.8,0,17.6,0.1,26.4,0.1c-17.1,32.3-36.6,39.8-36.7,39.8c7.6,0,15.1,0,22.7,0.1
c-21.4,32-42.8,39.9-42.9,39.9c-46.2,0.1-92.3,0.6-138.5,1.7c0,0-20.7-7.1-41.9-37.2c7.2-0.2,14.5-0.4,21.7-0.6
c0,0-18.9-6.7-36-37.3c8.4-0.3,16.8-0.5,25.3-0.7c0,0-26.1-8.8-40.8-56.2c-11.5,48.3-36.9,58.8-36.9,58.8c8.4-0.3,16.8-0.7,25.3-1
c-15,31.6-33.4,39.6-33.4,39.6c7.2-0.3,14.5-0.6,21.7-0.9c-19.2,31.4-39.3,39.9-39.4,39.9c-12.7,0.6-25.4,1.2-38.1,1.8
c0,0-17.2-5.4-35.2-29.6c5.9-0.3,11.9-0.6,17.8-1c0,0-15.6-5.1-30.3-29.8c6.9-0.4,13.8-0.8,20.7-1.1c0,0-21.6-6.7-34.6-45.3
c-8.4,39.9-29,49-29,49c6.9-0.4,13.8-0.9,20.7-1.3c-11.7,26.3-26.6,33.2-26.6,33.2c5.9-0.4,11.9-0.8,17.8-1.1
c-15.1,26.2-31.5,33.5-31.5,33.5c-40.1,2.7-80.1,5.8-120.2,9.2c0,0-22.1-6.1-46.2-36c7.5-0.7,15.1-1.4,22.6-2.1
c0,0-20.2-5.8-40-36.5c8.8-0.8,17.6-1.6,26.3-2.4c0,0-27.9-7.4-46.3-55.9C156.2,83.3,130.3,96,130.3,96c8.8-0.9,17.6-1.8,26.3-2.7
c-13.6,34-32.3,43.5-32.3,43.5c7.5-0.8,15.1-1.6,22.6-2.3c-17.9,34.1-38.4,44.2-38.4,44.3c-38,4.1-75.9,7.6-113.8,12.3
c0.4,3.3,0.8,7.6,1.3,10.9c0,13.3,1608,13.3,1608,0c0.4-3.3,0.8-7.6,1.3-10.9C1562,185.6,1518.8,181.6,1475.4,177z"/>'
		);

		$ret['side-curve-inward-decor1'] = array(
		'name' => __( 'Side-Curve Inward (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1600,19V3c-1.3,0,2.5,32.5-16,55c-16.4,20-44.2,24.3-64.2,25H-4v15.7L1519.8,99C1519.8,99,1600,99,1600,19z"/>
<path class="gambit_sep_decor2" d="M1590,37.5c-14.7,22.1-45.8,27.5-70.2,28.5H-4v17h1523.8c20-0.7,47.8-5,64.2-25c18.5-22.5,14.7-55,16-55v-5
C1599.1-2,1601.6,20,1590,37.5z"/>
<path class="gambit_sep_decor2" d="M1604,119.3"/>
<path class="gambit_sep_main" d="M1604,239l-1638.3,9.3L-4,98.7L1519.8,99c0,0,80.2,0,80.2-80V-9.7h6.7L1604,239z"/>',
		);

		$ret['side-curve-inward-decor2'] = array(
		'name' => __( 'Side-Curve Inward (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1599.9,20.5c-3,73-140.6,77.3-156.5,77.5l43.1,0C1495.4,97.9,1597.6,94.7,1599.9,20.5z"/>
<path class="gambit_sep_decor1" d="M1600,38L1600,38c0,0.8,0,1.6-0.1,2.5c0-0.2,0-0.4,0-0.6C1600,39.2,1600,38.6,1600,38z"/>
<path class="gambit_sep_decor2" d="M1486.6,98l33.4,0c0,0,78.7,0,80-78.1c0,0.2,0,0.4,0,0.6C1597.6,94.7,1495.4,97.9,1486.6,98z"/>
<rect class="gambit_sep_decor2" x="1600" y="37.9" width="4" height="0.1"/>
<path class="gambit_sep_decor2"  d="M1600,39.9c0-0.6,0-1.2,0-1.9C1600,38.6,1600,39.2,1600,39.9z"/>
<path class="gambit_sep_decor2" d="M1778,110"/>
<path class="gambit_sep_main" d="M1604,17.9h-4V18c0,80-80,80-80,80L-4,97.7V244l1714,18L1604,17.9z"/>',
		);

		$ret['side-curve-outward-decor1'] = array(
		'name' => __( 'Side-Curve Outward (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1501,0H-12v60l1612,39C1600,2,1501,0,1501,0z"/>
<path class="gambit_sep_decor2" d="M1501,12H-12v48l1612,39.475v-0.238C1600,13.762,1501,12,1501,12z"/>
<path class="gambit_sep_main" d="M1600,99.475C1600,25.525,1501,24,1501,24H-12l1,77h1611V99.475z"/>',
		);

		$ret['side-curve-outward-decor2'] = array(
		'name' => __( 'Side-Curve Outward (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_main" d="M1600,99c0-97-99-99-99-99H-12l1,106h1611V99z"/>
<path class="gambit_sep_decor2" d="M1600,99c0-97-99-99-99-99h-145C1356,0,1600,2,1600,99z"/>
<path class="gambit_sep_decor1" d="M1599.96,96.491C1598.256,1.982,1501,0,1501,0h-66 C1435,0,1597.138,1.967,1599.96,96.491z"/>',
		);

		$ret['slant-decor1'] = array(
		'name' => __( 'Slant (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24.167 1604,198 1604,214 -4,214 "/>
<polygon class="gambit_sep_decor1" points="-4,12 1604,198 -4,24.167 "/>
<polygon class="gambit_sep_decor2" points="-4,0 1604,198 -4,12 "/>',
		);

		$ret['slant-decor2'] = array(
		'name' => __( 'Slant (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,24.167 1604,198 1604,204 -4,204 "/>
<polygon class="gambit_sep_decor1" points="1604,198 1604,186 -4,12 -4,24.167 "/>
<polygon class="gambit_sep_decor2" points="1604,186 1604,174 -4,0 -4,12 "/>',
		);

		$ret['slant-decor3'] = array(
		'name' => __( 'Slant (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<polygon class="gambit_sep_main" points="-4,0 1604,198 1604,204 -4,204 	"/>
<polygon class="gambit_sep_decor1" points="1604,198 1604,186 -4,0 -4,0 	"/>
<polygon class="gambit_sep_decor2" points="1604,186 1604,174 -4,0 -4,0 	"/>',
		);

		$ret['slime'] = array(
		'name' => __( 'Slime', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1603.651,104.694c-2.417,0-4.377,2.248-4.377,5.021 c0,1.144,0.373,2.762,0.883,4.443c1.374,4.526,2.429,12.118,2.366,16.848c-0.373,28.046-16.49,20.869-16.49,9.998 c0-5.499,4.124-7.332,4.124-15.082c0-6.096-4.309-11.038-9.623-11.038c-3.501,0-6.44,2.213-8.249,5.35 c-1.124,1.95-3.219,2.823-5.499,3.046c-0.156,0.015-0.471,0.037-0.472,0.037c-0.281-0.061-0.578-0.122-0.903-0.184 c-4.658-0.897-5.955-4.226-6.082-7.346c-0.119-2.923,0.805-5.788,2.44-8.214c2.751-4.079,8.316-13.308,8.316-21.203 c0-14.98-10.586-27.123-23.646-27.123s-23.646,12.143-23.646,27.123c0,17.173,15.122,26.337,15.122,38.137 c0,7.905-5.643,4.124-10.998,4.124c-5.041,0-14.358,7.253-14.357-3.417c0-5.839,6.109-11.538,6.109-17.278 c0-4.515-3.191-8.175-7.127-8.175c-3.936,0-7.127,3.66-7.127,8.175c0,5.909,6.109,10.76,6.109,17.278 c0,19.341-14.854,17.165-14.854,9.427c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021s-4.377,2.248-4.377,5.021 c0,3.629,3.752,6.609,3.752,10.612c0,10.373-12.869,9.743-12.869-0.511c0-3.952,4.124-5.229,4.124-12.979 c0-6.096-4.308-11.038-9.623-11.038c-5.315,0-9.623,4.942-9.623,11.038c0,7.979,4.124,8.302,4.124,17.103 c0,8.478-2.807,2.749-6.874,2.749c-4.64,0-5.155,4.124-9.623,4.124c-4.21,0,0-4.958,0-9.896c0-10.479-7.406-18.973-16.541-18.973 c-9.135,0-17.62,8.55-16.541,18.973c0.67,6.474,4.318,8.657,4.212,18.145c-0.075,6.804-12.373,6.014-12.373,1.375 c0-5.589,4.124-9.951,4.124-15.486c0-4.355-3.078-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.23,4.124,9.884,4.124,15.486c0,5.155-9.623,4.276-9.623,0c0-3.867-3.738-8.248-8.248-8.248 c-8.936,0-19.639-4.468-19.639-15.319c0-5.632,5.892-11.129,5.892-16.664c0-4.355-3.077-7.885-6.874-7.885 c-3.796,0-6.874,3.53-6.874,7.885c0,5.699,5.892,10.378,5.892,16.664c0,18.67-22.629,14.202-22.629-1.249 c0-10.737,11.134-21.268,11.086-31.82c-0.038-8.301-5.936-15.004-13.173-14.971c-7.237,0.033-13.073,6.79-13.035,15.091 c0.05,10.865,11.511,19.733,11.378,31.717c0,7.701-11.139,6.686-11.138,0.094c0-6.096-4.308-11.038-9.623-11.038 c-5.315,0-9.623,4.942-9.623,11.038c0,2.642-0.37,4.96-1.084,6.856v-0.946c-0.176-0.04,0.013,0.003-0.163-0.037 c-1.96,2.992-9.958,2.483-9.957-2.524c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021 c-2.417,0-4.377,2.248-4.377,5.021c0,3.629,3.752,6.609,3.752,10.612c0,14.955-13.965,9.306-13.713-10.977 c0.184-14.777,15.46-29.202,15.46-43.728c0-11.426-8.075-20.689-18.037-20.689s-18.037,9.263-18.037,20.689 c0,14.955,14.946,27.24,15.46,43.728c0.683,21.911-11.789,28.121-16.505,24.214c-4.678-3.875-8.551,6.167-10.016-4.321 c-0.779-5.578,5.892-11.129,5.892-16.664c0-4.355-3.078-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.699,5.892,10.378,5.892,16.664c0,10.249-10.188,2.946-16.89,2.946c-6.358,0-21.624,18.387-21.624,4.635 c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021s-4.377,2.248-4.377,5.021c0,3.629,1.881,6.154,1.881,10.101 c0,3.957-13.136,13.876-13.136-19.591c0-9.308,20.215-18.394,20.215-27.543c0-7.197-5.087-13.032-11.361-13.032 c-6.275,0-11.361,5.834-11.361,13.032c0,9.42-0.942,17.155-0.739,27.543c0.265,13.528-2.951,20.965-11.113,20.965 c-4.468,0-6.874-2.177-6.874-5.499c0-3.093,4.124-6.015,4.124-11.604c0-6.096-4.308-11.038-9.623-11.038 c-5.315,0-9.623,4.942-9.623,11.038c0,5.512,5.499,9.84,5.499,15.729c0,12.029-12.373,11.857-12.373-4.124 c0-7.046,0.124-10.307,1.375-13.747c0.926-2.549,1.375-4.802,1.375-6.543c0-2.773-1.96-5.021-4.377-5.021s-4.377,2.248-4.377,5.021 c0,1.144,0.373,2.762,0.883,4.443c1.374,4.526,2.429,12.118,2.366,16.848c-0.082,6.181-0.93,10.647-2.201,13.744h-13.627 c-0.42-1.157-0.662-2.423-0.662-3.746c0-5.499,4.124-7.332,4.124-15.082c0-6.096-4.309-11.038-9.623-11.038 c-3.501,0-6.44,2.213-8.249,5.35c-1.124,1.95-3.219,2.823-5.499,3.046c-0.156,0.015-0.471,0.037-0.472,0.037 c-0.281-0.061-0.578-0.122-0.903-0.184c-4.658-0.897-5.955-4.226-6.082-7.346c-0.119-2.923,0.805-5.788,2.44-8.214 c2.751-4.079,8.316-13.308,8.316-21.203c0-14.98-10.587-27.123-23.646-27.123c-13.059,0-23.646,12.143-23.646,27.123 c0,17.173,15.122,26.337,15.122,38.137c0,7.905-5.643,4.124-10.998,4.124c-5.041,0-14.358,7.253-14.357-3.417 c0-5.839,6.109-11.538,6.109-17.278c0-4.515-3.191-8.175-7.127-8.175c-3.936,0-7.127,3.66-7.127,8.175 c0,5.909,6.109,10.76,6.109,17.278c0,19.341-14.854,17.165-14.854,9.427c0-3.586,3.752-7.087,3.752-10.612 c0-2.773-1.96-5.021-4.377-5.021s-4.377,2.248-4.377,5.021c0,3.629,3.752,6.609,3.752,10.612c0,10.373-12.869,9.743-12.869-0.511 c0-3.952,4.124-5.229,4.124-12.979c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038c0,7.979,4.124,8.302,4.124,17.103 c0,8.478-2.807,2.749-6.874,2.749c-4.64,0-5.155,4.124-9.623,4.124c-4.21,0,0-4.958,0-9.896c0-10.479-7.406-18.973-16.541-18.973 c-9.135,0-17.62,8.55-16.541,18.973c0.67,6.474,4.318,8.657,4.212,18.145c-0.016,1.465-0.601,2.575-1.505,3.373h-9.929 c-0.582-0.546-0.938-1.216-0.938-1.999c0-5.589,4.124-9.951,4.124-15.486c0-4.355-3.077-7.885-6.874-7.885 c-3.796,0-6.874,3.53-6.874,7.885c0,5.23,4.124,9.884,4.124,15.486c0,0.813-0.24,1.475-0.644,1.999h-8.119 c-0.532-0.541-0.86-1.211-0.86-1.999c0-3.867-3.738-8.248-8.248-8.248c-8.936,0-19.639-4.468-19.639-15.319 c0-5.632,5.892-11.129,5.892-16.664c0-4.355-3.078-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.699,5.892,10.378,5.892,16.664c0,18.67-22.629,14.202-22.629-1.249c0-10.737,11.134-21.268,11.086-31.82 c-0.038-8.301-5.936-15.004-13.173-14.971c-7.237,0.033-13.073,6.79-13.035,15.091c0.05,10.865,11.511,19.733,11.378,31.717 c0,7.701-11.139,6.686-11.138,0.094c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038 c0,7.423-2.886,12.332-8.248,12.332c-6.645,0-9.05,6.874-12.373,6.874c-3.322,0-8.248-5.499-8.248-11.589 c0-6.09,6.874-11.497,6.874-17.24c0-5.627-3.674-10.261-8.418-10.943v-3.908c-0.176-0.04,0.013,0.003-0.163-0.037 c-1.96,2.992-9.958,2.483-9.957-2.524c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021 c-2.417,0-4.377,2.248-4.377,5.021c0,3.629,3.752,6.609,3.752,10.612c0,14.955-13.965,9.306-13.713-10.977 c0.184-14.777,15.46-29.202,15.46-43.728c0-11.426-8.075-20.689-18.037-20.689c-9.961,0-18.037,9.263-18.037,20.689 c0,14.955,14.946,27.24,15.46,43.728c0.683,21.911-11.789,28.121-16.505,24.214c-4.678-3.875-8.551,6.167-10.016-4.321 c-0.779-5.578,5.892-11.129,5.892-16.664c0-4.355-3.078-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.699,5.892,10.378,5.892,16.664c0,10.249-10.188,2.946-16.89,2.946c-6.358,0-21.624,18.387-21.624,4.635 c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021c-2.417,0-4.377,2.248-4.377,5.021 c0,3.629,1.881,6.154,1.881,10.101c0,3.957-13.136,13.876-13.136-19.591c0-9.308,9.738-18.394,9.738-27.543 c0-7.197-5.086-13.032-11.361-13.032c-6.274,0-11.361,5.834-11.361,13.032c0,9.42,9.534,17.155,9.738,27.543 c0.265,13.528-2.951,20.965-11.113,20.965c-4.468,0-6.874-2.177-6.874-5.499c0-3.093,4.124-6.015,4.124-11.604 c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038c0,5.512,5.499,9.84,5.499,15.729 c0,12.029-12.373,11.857-12.373-4.124c0-7.046,0.124-10.307,1.375-13.747c0.926-2.549,1.375-4.802,1.375-6.543 c0-2.773-1.96-5.021-4.377-5.021s-4.377,2.248-4.377,5.021c0,1.144,0.372,2.762,0.883,4.443c1.374,4.526,2.429,12.118,2.366,16.848 c-0.373,28.046-16.49,20.869-16.49,9.998c0-5.499,4.124-7.332,4.124-15.082c0-6.096-4.308-11.038-9.623-11.038 c-3.501,0-6.44,2.213-8.249,5.35c-1.124,1.95-3.219,2.823-5.499,3.046c-0.156,0.015-0.471,0.037-0.471,0.037 c-0.281-0.061-0.578-0.122-0.903-0.184c-4.658-0.897-5.955-4.226-6.082-7.346c-0.119-2.923,0.805-5.788,2.44-8.214 c2.751-4.079,8.316-13.308,8.316-21.203c0-14.98-10.586-27.123-23.646-27.123c-13.059,0-23.646,12.143-23.646,27.123 c0,17.173,15.122,26.337,15.122,38.137c0,7.905-5.643,4.124-10.998,4.124c-5.041,0-14.358,7.253-14.357-3.417 c0-5.839,6.109-11.538,6.109-17.278c0-4.515-3.191-8.175-7.127-8.175s-7.127,3.66-7.127,8.175c0,5.909,6.109,10.76,6.109,17.278 c0,19.341-14.854,17.165-14.854,9.427c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021 c-2.417,0-4.377,2.248-4.377,5.021c0,3.629,3.752,6.609,3.752,10.612c0,10.373-12.869,9.743-12.869-0.511 c0-3.952,4.124-5.229,4.124-12.979c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038c0,7.979,4.124,8.302,4.124,17.103 c0,8.478-2.807,2.749-6.874,2.749c-4.64,0-5.155,4.124-9.623,4.124c-4.21,0,0-4.958,0-9.896c0-10.479-7.406-18.973-16.541-18.973 c-9.135,0-17.62,8.55-16.541,18.973c0.67,6.474,4.318,8.657,4.212,18.145c-0.076,6.804-12.373,6.014-12.373,1.375 c0-5.589,4.124-9.951,4.124-15.486c0-4.355-3.077-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.23,4.124,9.884,4.124,15.486c0,5.155-9.623,4.276-9.623,0c0-3.867-3.738-8.248-8.248-8.248 c-8.936,0-19.639-4.468-19.639-15.319c0-5.632,5.892-11.129,5.892-16.664c0-4.355-3.078-7.885-6.874-7.885 c-3.796,0-6.874,3.53-6.874,7.885c0,5.699,5.892,10.378,5.892,16.664c0,18.67-22.629,14.202-22.629-1.249 c0-10.737,11.134-21.268,11.086-31.82c-0.038-8.301-5.936-15.004-13.173-14.971c-7.237,0.033-13.073,6.79-13.035,15.091 c0.05,10.865,11.511,19.733,11.378,31.717c0,7.701-11.139,6.686-11.138,0.094c0-6.096-4.308-11.038-9.623-11.038 s-9.623,4.942-9.623,11.038c0,7.423-2.886,12.332-8.248,12.332c-6.645,0-9.05,6.874-12.373,6.874 c-3.322,0-8.248-5.499-8.248-11.589c0-6.09,6.874-11.497,6.874-17.24c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038 c0,7.427,6.874,11.559,6.874,19.206c0,6.272-7.733,13.747-12.373,13.747c-5.505,0-14.355-8.42-14.355-18.047 c0-20.293,21.229-29.501,21.229-49.446c0-15.69-11.089-28.41-24.767-28.41S288.351,70.31,288.351,86 c0,20.535,21.229,26.795,21.229,49.446c0,2.961-1.681,9.799-6.063,9.799c-4.124,0-6.501-5.055-6.501-8.304 c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021c-2.417,0-4.377,2.248-4.377,5.021 c0,3.629,3.752,6.609,3.752,10.612c0,7.96-4.563,13.803-8.745,13.803c-4.812,0-4.583,5.499-9.623,5.499 c-2.921,0-4.124-7.142-4.124-10.667c0-2.773-1.96-5.021-4.377-5.021c-2.417,0-3.986,1.941-6.621,1.941 c-2.406,0-4.167-1.155-4.167-6.01c0-11.867,12.415-23.451,12.415-35.115c0-9.176-6.485-16.614-14.484-16.614 s-14.484,7.438-14.484,16.614c0,12.009,12.415,21.868,12.415,35.115c0,1.838-0.164,3.503-0.462,5.009 c-2.498,12.631-21.109,11.747-21.854-1.107c-0.01-0.176-0.016-0.348-0.016-0.514c0-5.632,5.892-11.129,5.892-16.664 c0-4.354-3.077-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885c0,5.699,5.892,10.378,5.892,16.664 c0,2.7-1.078,5.865-2.311,8.835c-0.003,0.008-0.007,0.015-0.013,0.022c-1.455,1.771-5.791,6.139-13.191,6.139 c-9.28,0-11.685-4.812-16.497,0c-4.598,4.598-6.368-6.072-6.368-8.727c0-2.773-1.96-5.021-4.377-5.021 c-2.411,0-7.127-0.516-7.127-2.749c0-6.244,4.124-7.341,4.124-15.082c0-6.096-4.308-11.038-9.623-11.038s-9.623,4.942-9.623,11.038 c0,1.65,0.43,3.053,0.916,4.799c3.724,9.252-3.587,14.407-7.789,14.407c-5.499,0-10.016-6.96-10.016-16.693 c0-5.632,5.892-11.129,5.892-16.664c0-4.355-3.078-7.885-6.874-7.885c-3.796,0-6.874,3.53-6.874,7.885 c0,5.699,5.892,10.378,5.892,16.664c0,3.596-1.08,5.695-3.142,5.695c-2.635,0-3.537-4.124-6.874-4.124 c-3.727,0-3.845,8.248-8.248,8.248c-3.731,0-4.652-10.396-4.652-15.397c0-15.391,16.101-30.413,16.101-45.541 c0-11.9-8.41-21.547-18.785-21.547c-10.374,0-18.784,9.647-18.784,21.547c0,15.575,16.101,28.361,16.101,45.541 c0,38.653-20.722,28.114-20.722,22.215c0-3.586,3.752-7.087,3.752-10.612c0-2.773-1.96-5.021-4.377-5.021 c-2.417,0-4.377,2.248-4.377,5.021c0,3.544,3.736,6.801,3.736,10.334s-3.829,7.207-10.61,7.207c-8.764,0-9.28-8.248-13.747-8.248 c-4.468,0-4.296-4.124-6.874-4.124c-1.905,0-2.387,2.75-4.124,2.75c-1.677,0-2.749-4.132-2.749-7.521 c0-7.885,8.248-15.58,8.248-23.33c0-6.096-4.309-11.038-9.623-11.038s-9.623,4.942-9.623,11.038c0,7.979,8.248,14.529,8.248,23.33 c0,8.122-5.155,18.519-12.373,18.519c-7.303,0-10.12-8.764-10.12-15.178c0-3.586,3.752-7.087,3.752-10.612 c0-2.773-1.96-5.021-4.377-5.021c-2.417,0-4.377,2.248-4.377,5.021c0,3.629,3.752,6.609,3.752,10.612 c0,3.45-2.033,9.679-9.251,9.679c-10.568,0-13.747-10.762-13.747-28.87c0-9.723,5.499-20.823,5.499-30.38 c0-7.518-5.313-13.612-11.867-13.612c-3.94,0-7.421,2.211-9.579,5.601V196h1612v-91.266 C1603.883,104.723,1603.771,104.694,1603.651,104.694z"/>
<path class="gambit_sep_decor2" d="M1606,168.175c-0.689,0.631-1.631,0.943-2.635,1.041 c-0.092,0.009-0.278,0.022-0.278,0.022c-0.166-0.036-0.341-0.072-0.532-0.109c-2.744-0.529-3.508-2.49-3.583-4.327 c-0.07-1.722,0.474-3.409,1.437-4.838c1.62-2.403,4.899-7.839,4.899-12.489c0-8.824-6.236-15.976-13.928-15.976 c-7.692,0-13.928,7.153-13.928,15.976c0,10.115,8.907,15.514,8.907,22.464c0,4.656-3.324,2.429-6.478,2.429 c-2.969,0-8.457,4.272-8.457-2.013c0-3.439,3.598-6.797,3.598-10.177c0-2.659-1.879-4.815-4.198-4.815s-4.198,2.156-4.198,4.815 c0,3.481,3.598,6.338,3.598,10.177c0,11.393-8.749,10.111-8.749,5.553c0-2.112,2.21-4.174,2.21-6.251 c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251c0,6.11-7.58,5.739-7.58-0.301 c0-2.328,2.429-3.08,2.429-7.645c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.668,2.911-5.668,6.502c0,4.7,2.429,4.89,2.429,10.075 c0,4.994-1.653,1.62-4.049,1.62c-2.733,0-3.037,2.429-5.668,2.429c-2.48,0,0-2.921,0-5.829c0-6.172-4.362-11.176-9.743-11.176 c-5.381,0-10.379,5.036-9.743,11.176c0.395,3.814,2.543,5.099,2.481,10.688c-0.01,0.863-0.354,1.517-0.886,1.987h-5.849 c-0.343-0.321-0.553-0.716-0.553-1.177c0-3.292,2.429-5.861,2.429-9.122c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.081,2.429,5.822,2.429,9.122c0,0.479-0.142,0.869-0.379,1.177h-4.782 c-0.314-0.318-0.507-0.714-0.507-1.177c0-2.278-2.202-4.859-4.859-4.859c-5.264,0-11.568-2.632-11.568-9.023 c0-3.317,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644s-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816 c0,10.997-13.33,8.365-13.33-0.736c0-6.324,6.559-12.527,6.53-18.744c-0.023-4.89-3.497-8.838-7.76-8.818 c-4.263,0.02-7.701,4-7.678,8.889c0.029,6.4,6.781,11.624,6.702,18.683c0,4.536-6.562,3.938-6.561,0.055 c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502c0,4.373-1.7,7.264-4.859,7.264c-3.914,0-5.331,4.049-7.288,4.049 c-1.957,0-4.859-3.239-4.859-6.826s4.049-6.772,4.049-10.155c0-3.315-2.164-6.044-4.959-6.446v-2.302 c-0.104-0.024,0.008,0.002-0.096-0.022c-1.155,1.762-5.865,1.463-5.865-1.487c0-2.112,2.21-4.174,2.21-6.251 c0-1.633-1.154-2.957-2.578-2.957c-1.424,0-2.578,1.324-2.578,2.957c0,2.138,2.21,3.893,2.21,6.251 c0,8.809-8.226,5.482-8.078-6.466c0.108-8.704,9.107-17.201,9.107-25.757c0-6.731-4.757-12.187-10.624-12.187 s-10.624,5.456-10.624,12.187c0,8.809,8.804,16.045,9.107,25.757c0.402,12.906-6.944,16.564-9.722,14.263 c-2.756-2.283-5.037,3.633-5.9-2.545c-0.459-3.286,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644 s-4.049,2.079-4.049,4.644c0,3.357,3.471,6.113,3.471,9.816c0,6.037-6.001,1.735-9.949,1.735c-3.745,0-12.737,10.831-12.737,2.73 c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,1.108,3.625,1.108,5.95 c0,2.331-7.738,8.174-7.738-11.54c0-5.483,5.736-10.835,5.736-16.224c0-4.239-2.996-7.676-6.692-7.676 c-3.696,0-6.692,3.437-6.692,7.676c0,5.549,5.616,10.105,5.736,16.224c0.156,7.968-1.739,12.349-6.546,12.349 c-2.632,0-4.049-1.282-4.049-3.239c0-1.822,2.429-3.543,2.429-6.835c0-3.591-2.538-6.502-5.668-6.502 c-3.131,0-5.668,2.911-5.668,6.502c0,3.247,3.239,5.796,3.239,9.265c0,7.086-7.288,6.984-7.288-2.429 c0-4.15,0.073-6.071,0.81-8.098c0.546-1.501,0.81-2.829,0.81-3.854c0-1.633-1.154-2.958-2.578-2.958 c-1.424,0-2.578,1.324-2.578,2.958c0,0.674,0.219,1.627,0.52,2.617c0.809,2.666,1.431,7.138,1.394,9.924 c-0.22,16.52-9.714,12.293-9.714,5.889c0-3.239,2.429-4.319,2.429-8.884c0-3.591-2.538-6.502-5.668-6.502 c-2.062,0-3.793,1.304-4.859,3.151c-0.662,1.148-1.896,1.663-3.239,1.794c-0.092,0.009-0.278,0.022-0.278,0.022 c-0.166-0.036-0.341-0.072-0.532-0.109c-2.744-0.529-3.508-2.49-3.583-4.327c-0.07-1.722,0.474-3.409,1.437-4.838 c1.62-2.403,4.899-7.839,4.899-12.489c0-8.824-6.236-15.977-13.928-15.977s-13.928,7.153-13.928,15.977 c0,10.115,8.908,15.514,8.908,22.464c0,4.656-3.324,2.429-6.478,2.429c-2.969,0-8.457,4.272-8.457-2.013 c0-3.439,3.598-6.797,3.598-10.177c0-2.659-1.88-4.815-4.198-4.815c-2.318,0-4.198,2.156-4.198,4.815 c0,3.481,3.598,6.338,3.598,10.177c0,11.393-8.749,10.111-8.749,5.553c0-2.112,2.21-4.174,2.21-6.251 c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251c0,6.11-7.58,5.739-7.58-0.301 c0-2.328,2.429-3.08,2.429-7.645c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502c0,4.7,2.429,4.89,2.429,10.075 c0,4.994-1.653,1.62-4.049,1.62c-2.733,0-3.037,2.429-5.668,2.429c-2.48,0,0-2.921,0-5.829c0-6.172-4.362-11.176-9.743-11.176 s-10.379,5.036-9.743,11.176c0.395,3.813,2.543,5.099,2.481,10.688c-0.044,4.008-7.288,3.543-7.288,0.81 c0-3.292,2.429-5.861,2.429-9.122c0-2.565-1.813-4.644-4.049-4.644s-4.049,2.079-4.049,4.644c0,3.081,2.429,5.822,2.429,9.122 c0,3.037-5.668,2.518-5.668,0c0-2.278-2.202-4.859-4.859-4.859c-5.264,0-11.568-2.632-11.568-9.023 c0-3.317,3.471-6.555,3.471-9.816c0-2.565-1.813-4.644-4.049-4.644s-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816 c0,10.997-13.329,8.365-13.329-0.736c0-6.324,6.558-12.527,6.53-18.744c-0.022-4.89-3.497-8.838-7.76-8.818s-7.7,4-7.678,8.889 c0.03,6.4,6.781,11.624,6.702,18.683c0,4.536-6.562,3.938-6.561,0.056c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502 c0,4.373-1.7,7.264-4.859,7.264c-3.914,0-5.331,4.049-7.288,4.049c-1.957,0-4.859-3.239-4.859-6.826 c0-3.587,4.049-6.772,4.049-10.155c0-3.591-2.538-6.502-5.668-6.502c-3.13,0-5.668,2.911-5.668,6.502 c0,4.375,4.049,6.809,4.049,11.313c0,3.695-4.555,8.098-7.288,8.098c-3.242,0-8.456-4.96-8.456-10.631 c0-11.953,12.505-23.62,12.505-35.369c0-9.242-6.532-16.734-14.589-16.734s-14.589,7.492-14.589,16.734 c0,12.096,12.505,22.026,12.505,35.369c0,1.744-0.99,5.772-3.571,5.772c-2.429,0-3.83-2.977-3.83-4.891 c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,4.689-2.688,8.13-5.151,8.13c-2.834,0-2.699,3.239-5.668,3.239c-1.721,0-2.429-4.207-2.429-6.284 c0-1.633-1.154-2.958-2.578-2.958s-2.348,1.143-3.9,1.143c-1.417,0-2.454-0.681-2.454-3.54c0-6.99,7.313-13.813,7.313-20.684 c0-5.405-3.82-9.786-8.532-9.786c-4.712,0-8.532,4.382-8.532,9.786c0,7.074,7.313,12.881,7.313,20.684 c0,1.082-0.097,2.063-0.272,2.95c-1.472,7.44-12.434,6.919-12.873-0.652c-0.006-0.104-0.009-0.205-0.009-0.303 c0-3.317,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816 c0,1.59-0.635,3.455-1.361,5.204c-0.002,0.005-0.004,0.009-0.008,0.013c-0.857,1.043-3.411,3.616-7.77,3.616 c-5.466,0-6.883-2.834-9.717,0c-2.708,2.709-3.751-3.577-3.751-5.14c0-1.633-1.154-2.958-2.578-2.958 c-1.42,0-4.198-0.304-4.198-1.62c0-3.678,2.429-4.324,2.429-8.884c0-3.591-2.538-6.502-5.668-6.502 c-3.131,0-5.669,2.911-5.669,6.502c0,0.972,0.253,1.798,0.539,2.827c2.194,5.45-2.113,8.486-4.588,8.486 c-3.239,0-5.9-4.1-5.9-9.833c0-3.317,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644s-4.049,2.079-4.049,4.644 c0,3.357,3.47,6.113,3.47,9.816c0,2.118-0.636,3.355-1.851,3.355c-1.552,0-2.083-2.429-4.049-2.429 c-2.195,0-2.265,4.859-4.859,4.859c-2.198,0-2.74-6.124-2.74-9.07c0-9.066,9.484-17.914,9.484-26.825 c0-7.01-4.954-12.692-11.065-12.692s-11.065,5.682-11.065,12.692c0,9.174,9.484,16.706,9.484,26.825 c0,22.768-12.206,16.56-12.206,13.086c0-2.113,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958 c-1.424,0-2.578,1.324-2.578,2.958c0,2.088,2.201,4.006,2.201,6.087c0,2.081-2.255,4.245-6.25,4.245 c-5.162,0-5.466-4.859-8.098-4.859c-2.632,0-2.531-2.429-4.049-2.429c-1.122,0-1.406,1.62-2.429,1.62 c-0.988,0-1.62-2.434-1.62-4.43c0-4.644,4.859-9.177,4.859-13.742c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502 c0,4.7,4.859,8.558,4.859,13.742c0,4.784-3.037,10.908-7.288,10.908c-4.302,0-5.961-5.162-5.961-8.94 c0-2.113,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,2.032-1.198,5.701-5.449,5.701c-6.225,0-8.098-6.339-8.098-17.005c0-5.727,3.239-12.266,3.239-17.895 c0-4.428-3.13-8.018-6.99-8.018c-2.321,0-4.371,1.302-5.642,3.299v16.166c-0.747,0.518-1.252,1.45-1.252,2.524 c0,0.674,0.219,1.627,0.52,2.617c0.272,0.897,0.52,2.005,0.732,3.177v12.823c-2.19,9.121-9.051,5.258-9.051-0.187 c0-3.239,2.429-4.319,2.429-8.884c0-3.591-2.538-6.502-5.669-6.502c-2.062,0-3.794,1.303-4.859,3.151 c-0.662,1.148-1.896,1.663-3.239,1.794c-0.092,0.009-0.278,0.022-0.278,0.022c-0.166-0.036-0.341-0.072-0.532-0.109 c-2.744-0.529-3.508-2.49-3.583-4.327c-0.07-1.722,0.474-3.409,1.437-4.838c1.62-2.403,4.899-7.839,4.899-12.489 c0-8.824-6.236-15.977-13.928-15.977s-13.928,7.153-13.928,15.977c0,10.115,8.908,15.514,8.908,22.464 c0,4.656-3.324,2.429-6.478,2.429c-2.969,0-8.457,4.272-8.457-2.013c0-3.439,3.598-6.797,3.598-10.177 c0-2.659-1.879-4.815-4.198-4.815c-2.318,0-4.198,2.156-4.198,4.815c0,3.481,3.598,6.338,3.598,10.177 c0,11.393-8.749,10.111-8.749,5.553c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.957-2.578-2.957 c-1.424,0-2.578,1.324-2.578,2.957c0,2.138,2.21,3.893,2.21,6.251c0,6.11-7.58,5.739-7.58-0.301c0-2.328,2.429-3.08,2.429-7.645 c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502c0,4.7,2.429,4.89,2.429,10.075c0,4.994-1.653,1.62-4.049,1.62 c-2.733,0-3.037,2.429-5.669,2.429c-2.48,0,0-2.921,0-5.829c0-6.172-4.362-11.176-9.743-11.176c-5.381,0-10.379,5.037-9.743,11.176 c0.395,3.814,2.543,5.099,2.481,10.688c-0.044,4.008-7.288,3.543-7.288,0.81c0-3.292,2.429-5.861,2.429-9.122 c0-2.565-1.813-4.644-4.049-4.644c-2.236,0-4.049,2.079-4.049,4.644c0,3.081,2.429,5.822,2.429,9.122c0,3.037-5.669,2.518-5.669,0 c0-2.278-2.202-4.859-4.859-4.859c-5.264,0-11.568-2.632-11.568-9.023c0-3.317,3.47-6.555,3.47-9.816 c0-2.565-1.813-4.644-4.049-4.644c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816 c0,10.997-13.329,8.365-13.329-0.736c0-6.324,6.559-12.527,6.53-18.744c-0.023-4.89-3.497-8.838-7.76-8.818 c-4.263,0.02-7.701,4-7.678,8.889c0.029,6.4,6.781,11.624,6.702,18.683c0,4.536-6.562,3.939-6.561,0.056 c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.669,2.911-5.669,6.502c0,1.556-0.218,2.922-0.638,4.038V167.7 c-0.104-0.024,0.008,0.002-0.096-0.022c-1.155,1.762-5.866,1.463-5.865-1.487c0-2.112,2.21-4.174,2.21-6.251 c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,8.809-8.226,5.482-8.077-6.466c0.108-8.704,9.107-17.201,9.107-25.757c0-6.731-4.757-12.187-10.624-12.187 s-10.624,5.456-10.624,12.187c0,8.809,8.804,16.045,9.107,25.757c0.402,12.906-6.944,16.564-9.722,14.263 c-2.755-2.283-5.037,3.633-5.9-2.545c-0.459-3.286,3.471-6.555,3.471-9.816c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.471,6.113,3.471,9.816c0,6.037-6.001,1.735-9.949,1.735 c-3.745,0-12.737,10.831-12.737,2.73c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958 c0,2.138,1.108,3.625,1.108,5.95c0,2.331-7.738,8.174-7.738-11.54c0-5.483,5.736-10.835,5.736-16.224 c0-4.239-2.996-7.676-6.692-7.676c-3.696,0-6.692,3.437-6.692,7.676c0,5.549,5.616,10.105,5.736,16.224 c0.156,7.968-1.738,12.349-6.546,12.349c-2.632,0-4.049-1.282-4.049-3.239c0-1.822,2.429-3.543,2.429-6.836 c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.669,2.911-5.669,6.502c0,3.247,3.239,5.796,3.239,9.265 c0,7.086-7.288,6.984-7.288-2.429c0-4.15,0.073-6.071,0.81-8.098c0.546-1.501,0.81-2.829,0.81-3.854 c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958c0,0.674,0.219,1.627,0.52,2.617c0.809,2.666,1.431,7.138,1.394,9.924 c-0.048,3.641-0.548,6.272-1.297,8.096h-8.027c-0.247-0.681-0.39-1.427-0.39-2.207c0-3.239,2.429-4.319,2.429-8.884 c0-3.591-2.538-6.502-5.669-6.502c-2.062,0-3.794,1.303-4.859,3.151c-0.662,1.148-1.896,1.663-3.239,1.794 c-0.092,0.009-0.278,0.022-0.278,0.022c-0.166-0.036-0.341-0.072-0.532-0.109c-2.744-0.529-3.508-2.49-3.583-4.327 c-0.07-1.722,0.474-3.409,1.437-4.838c1.62-2.403,4.899-7.839,4.899-12.489c0-8.824-6.236-15.976-13.928-15.976 c-7.692,0-13.928,7.153-13.928,15.976c0,10.115,8.908,15.514,8.908,22.464c0,4.656-3.324,2.429-6.478,2.429 c-2.969,0-8.457,4.272-8.457-2.013c0-3.439,3.598-6.797,3.598-10.177c0-2.659-1.879-4.815-4.198-4.815 c-2.318,0-4.198,2.156-4.198,4.815c0,3.481,3.598,6.338,3.598,10.177c0,11.393-8.749,10.111-8.749,5.553 c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,6.11-7.58,5.739-7.58-0.301c0-2.328,2.429-3.08,2.429-7.645c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.668,2.911-5.668,6.502 c0,4.7,2.429,4.89,2.429,10.075c0,4.994-1.653,1.62-4.049,1.62c-2.733,0-3.037,2.429-5.668,2.429c-2.48,0,0-2.921,0-5.829 c0-6.172-4.362-11.176-9.743-11.176c-5.381,0-10.379,5.036-9.743,11.176c0.395,3.814,2.543,5.099,2.481,10.688 c-0.01,0.863-0.354,1.517-0.886,1.987h-5.849c-0.343-0.321-0.553-0.716-0.553-1.177c0-3.292,2.429-5.861,2.429-9.122 c0-2.565-1.813-4.644-4.049-4.644c-2.236,0-4.049,2.079-4.049,4.644c0,3.081,2.429,5.822,2.429,9.122 c0,0.479-0.142,0.869-0.379,1.177h-4.783c-0.314-0.318-0.507-0.714-0.507-1.177c0-2.278-2.202-4.859-4.859-4.859 c-5.264,0-11.568-2.632-11.568-9.023c0-3.317,3.471-6.555,3.471-9.816c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816c0,10.997-13.329,8.365-13.329-0.736 c0-6.324,6.559-12.527,6.53-18.744c-0.023-4.89-3.497-8.838-7.76-8.818c-4.263,0.02-7.701,4-7.678,8.889 c0.029,6.4,6.781,11.624,6.702,18.683c0,4.536-6.562,3.938-6.561,0.055c0-3.591-2.538-6.502-5.668-6.502 c-3.131,0-5.668,2.911-5.668,6.502c0,4.373-1.7,7.264-4.859,7.264c-3.914,0-5.331,4.049-7.288,4.049 c-1.957,0-4.859-3.239-4.859-6.826s4.049-6.772,4.049-10.155c0-3.315-2.164-6.044-4.959-6.446v-2.302 c-0.104-0.024,0.008,0.002-0.096-0.022c-1.155,1.762-5.865,1.463-5.865-1.487c0-2.112,2.21-4.174,2.21-6.251 c0-1.633-1.154-2.957-2.578-2.957c-1.424,0-2.578,1.324-2.578,2.957c0,2.138,2.21,3.893,2.21,6.251 c0,8.809-8.226,5.482-8.077-6.466c0.108-8.704,9.107-17.201,9.107-25.757c0-6.731-4.757-12.187-10.624-12.187 s-10.624,5.456-10.624,12.187c0,8.809,8.804,16.045,9.107,25.757c0.402,12.906-6.944,16.564-9.722,14.263 c-2.755-2.283-5.037,3.633-5.9-2.545c-0.459-3.286,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.471,6.113,3.471,9.816c0,6.037-6.001,1.735-9.949,1.735 c-3.745,0-12.737,10.831-12.737,2.73c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958 c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,1.108,3.625,1.108,5.95c0,2.331-7.738,8.174-7.738-11.54 c0-5.483,5.736-10.835,5.736-16.224c0-4.239-2.996-7.676-6.692-7.676c-3.696,0-6.692,3.437-6.692,7.676 c0,5.549,5.616,10.105,5.736,16.224c0.156,7.968-1.739,12.349-6.546,12.349c-2.632,0-4.049-1.282-4.049-3.239 c0-1.822,2.429-3.543,2.429-6.835c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.668,2.911-5.668,6.502 c0,3.247,3.239,5.796,3.239,9.265c0,7.086-7.288,6.984-7.288-2.429c0-4.15,0.073-6.071,0.81-8.098 c0.546-1.501,0.81-2.829,0.81-3.854c0-1.633-1.154-2.958-2.578-2.958s-2.578,1.324-2.578,2.958c0,0.674,0.219,1.627,0.52,2.617 c0.809,2.666,1.431,7.138,1.394,9.924c-0.22,16.52-9.714,12.293-9.714,5.889c0-3.239,2.429-4.319,2.429-8.884 c0-3.591-2.538-6.502-5.668-6.502c-2.062,0-3.794,1.304-4.859,3.151c-0.662,1.148-1.896,1.663-3.239,1.794 c-0.092,0.009-0.278,0.022-0.278,0.022c-0.166-0.036-0.341-0.072-0.532-0.109c-2.744-0.529-3.508-2.49-3.583-4.327 c-0.07-1.722,0.474-3.409,1.437-4.838c1.62-2.403,4.898-7.839,4.898-12.489c0-8.824-6.236-15.977-13.928-15.977 c-7.692,0-13.928,7.153-13.928,15.977c0,10.115,8.908,15.514,8.908,22.464c0,4.656-3.324,2.429-6.478,2.429 c-2.969,0-8.457,4.272-8.457-2.013c0-3.439,3.598-6.797,3.598-10.177c0-2.659-1.879-4.815-4.198-4.815 c-2.318,0-4.198,2.156-4.198,4.815c0,3.481,3.598,6.338,3.598,10.177c0,11.393-8.749,10.111-8.749,5.553 c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,6.11-7.58,5.739-7.58-0.301c0-2.328,2.429-3.08,2.429-7.645c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.668,2.911-5.668,6.502 c0,4.7,2.429,4.89,2.429,10.075c0,4.994-1.653,1.62-4.049,1.62c-2.733,0-3.037,2.429-5.668,2.429c-2.48,0,0-2.921,0-5.829 c0-6.172-4.362-11.176-9.743-11.176c-5.381,0-10.379,5.036-9.743,11.176c0.395,3.813,2.543,5.099,2.481,10.688 c-0.044,4.008-7.288,3.543-7.288,0.81c0-3.292,2.429-5.861,2.429-9.122c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.081,2.429,5.822,2.429,9.122c0,3.037-5.668,2.518-5.668,0c0-2.278-2.202-4.859-4.859-4.859 c-5.264,0-11.568-2.632-11.568-9.023c0-3.317,3.471-6.555,3.471-9.816c0-2.565-1.813-4.644-4.049-4.644 c-2.236,0-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816c0,10.997-13.329,8.365-13.329-0.736 c0-6.324,6.559-12.527,6.53-18.744c-0.023-4.89-3.497-8.838-7.759-8.818c-4.263,0.02-7.701,4-7.678,8.889 c0.029,6.4,6.781,11.624,6.702,18.683c0,4.536-6.562,3.938-6.561,0.056c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502 c0,4.373-1.7,7.264-4.859,7.264c-3.914,0-5.331,4.049-7.288,4.049c-1.957,0-4.859-3.239-4.859-6.826 c0-3.587,4.049-6.772,4.049-10.155c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.668,2.911-5.668,6.502 c0,4.375,4.049,6.809,4.049,11.313c0,3.695-4.555,8.098-7.288,8.098c-3.242,0-8.456-4.96-8.456-10.631 c0-11.953,12.505-23.62,12.505-35.369c0-9.242-6.532-16.734-14.589-16.734s-14.589,7.492-14.589,16.734 c0,12.096,12.505,22.026,12.505,35.369c0,1.744-0.99,5.772-3.571,5.772c-2.429,0-3.83-2.977-3.83-4.891 c0-2.112,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,4.689-2.688,8.13-5.151,8.13c-2.834,0-2.699,3.239-5.668,3.239c-1.721,0-2.429-4.207-2.429-6.284 c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.348,1.143-3.9,1.143c-1.417,0-2.454-0.681-2.454-3.54 c0-6.99,7.313-13.813,7.313-20.684c0-5.405-3.82-9.786-8.532-9.786c-4.712,0-8.532,4.382-8.532,9.786 c0,7.074,7.313,12.881,7.313,20.684c0,1.082-0.097,2.063-0.272,2.95c-1.471,7.44-12.434,6.919-12.873-0.652 c-0.006-0.104-0.009-0.205-0.009-0.303c0-3.317,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644s-4.049,2.079-4.049,4.644 c0,3.357,3.47,6.113,3.47,9.816c0,1.59-0.635,3.455-1.361,5.204c-0.002,0.005-0.004,0.009-0.008,0.013 c-0.857,1.043-3.411,3.616-7.77,3.616c-5.466,0-6.883-2.834-9.717,0c-2.709,2.709-3.751-3.577-3.751-5.14 c0-1.633-1.154-2.958-2.578-2.958c-1.42,0-4.198-0.304-4.198-1.62c0-3.678,2.429-4.324,2.429-8.884 c0-3.591-2.538-6.502-5.668-6.502c-3.131,0-5.669,2.911-5.669,6.502c0,0.972,0.253,1.798,0.539,2.827 c2.194,5.45-2.113,8.486-4.588,8.486c-3.239,0-5.9-4.1-5.9-9.833c0-3.317,3.47-6.555,3.47-9.816c0-2.565-1.813-4.644-4.049-4.644 s-4.049,2.079-4.049,4.644c0,3.357,3.47,6.113,3.47,9.816c0,2.118-0.636,3.355-1.851,3.355c-1.552,0-2.083-2.429-4.049-2.429 c-2.195,0-2.265,4.859-4.859,4.859c-2.198,0-2.74-6.124-2.74-9.07c0-9.066,9.484-17.914,9.484-26.825 c0-7.01-4.954-12.692-11.065-12.692s-11.065,5.682-11.065,12.692c0,9.174,9.484,16.706,9.484,26.825 c0,22.768-12.206,16.56-12.206,13.086c0-2.113,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958 c-1.424,0-2.578,1.324-2.578,2.958c0,2.088,2.201,4.006,2.201,6.087c0,2.081-2.255,4.245-6.25,4.245 c-5.162,0-5.466-4.859-8.098-4.859c-2.632,0-2.531-2.429-4.049-2.429c-1.122,0-1.406,1.62-2.429,1.62 c-0.988,0-1.62-2.434-1.62-4.43c0-4.644,4.859-9.177,4.859-13.742c0-3.591-2.538-6.502-5.668-6.502s-5.668,2.911-5.668,6.502 c0,4.7,4.859,8.558,4.859,13.742c0,4.784-3.037,10.908-7.288,10.908c-4.302,0-5.961-5.162-5.961-8.94 c0-2.113,2.21-4.174,2.21-6.251c0-1.633-1.154-2.958-2.578-2.958c-1.424,0-2.578,1.324-2.578,2.958c0,2.138,2.21,3.893,2.21,6.251 c0,2.032-1.198,5.701-5.449,5.701c-6.225,0-8.098-6.339-8.098-17.005c0-5.727,3.239-12.266,3.239-17.895 c0-4.428-3.13-8.018-6.99-8.018c-2.321,0-4.371,1.302-5.643,3.299V196h1612V168.175z"/>
<path class="gambit_sep_main" d="M6,206h1599.875c0.069,0,0.125-0.056,0.125-0.125V128c0,0-0.75-20-8-20 s-9.25,16-18,16c-7.33,0,12.816-47.409,12.816-66.914c0-19.897-14.062-36.027-31.408-36.027S1530,37.189,1530,57.086 c0,25.294,26.921,50.411,26.921,76.145c0,10.634-2.74,21.54-6.47,31.9c-1.881,5.224-6.765,8.84-12.317,8.87 c-0.045,0-0.089,0-0.134,0c-4.083,0-10,9-10,0c0-12.771,12-22.333,12-33.941c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059 c0,11.274,12,22.471,12,33.941c0,12.75-12.75,18-24,18c-8.237,0-23.458-5.667-23.458-22.081c0-5.824,5.458-10.158,5.458-15.438 c0-4.034-2.851-7.305-6.368-7.305c-12.132,0,2.368-20.486,2.368-35.294c0-12.67-8.954-22.941-20-22.941s-20,10.271-20,22.941 c0,7.608,4.223,15.737,7.862,22.802S1440.994,148,1436,148c-1.635,0-3.01-0.497-4.132-1.193c-2.156-1.336-3.519-3.616-4.056-6.094 c-0.689-3.18-3.195-5.536-6.18-5.536c-3.382,0-5.382,6.824-7.632,6.824c-2.305,0-5.167-5.417-6-12.059 c-1.583-12.614-12-24.02-12-36.882c0-12.804,12-22.333,12-33.941c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059 c0,11.274,12,22.471,12,33.941c0,0.535-0.024,1.056-0.047,1.577c-0.166,3.026-0.79,6.085-1.672,9.083 C1385.111,119.437,1370,128.393,1370,140c0,11.764-11.85,14.717-20,12c-9-3-14,7.19-14,16.059c0,7.754-4.8,17.941-12,17.941 c-6.639,0-8.903-6.875-8.903-10.081c0-5.824,5.458-10.158,5.458-15.438c0-4.034-2.851-7.305-6.368-7.305 c-3.517,0-6.368,3.27-6.368,7.305c0,5.128,5.458,10.221,5.458,15.438c0,1.581-0.778,6.081-5.278,6.081 c-8.333,0-13.607-13.333-13.607-30.713c0-19.521,18.295-34.049,18.295-51.746c0-13.522-9.556-24.483-21.344-24.483 S1270,86.02,1270,99.542c0,7.855,7.986,17.833,7.986,23.606c0,5.359-1.312,8.853-5.986,8.853c-5,0-3.75,8-16,8 c-8.833,0-16.333-7.667-16.333-16.109c0-7.769-5.491-14.068-12.264-14.068c-5.706,0-10.875-11.185-10.875-22.021 c0-10.937-7.729-19.803-17.264-19.803c-9.535,0-17.264,8.866-17.264,19.803c0,13.903,8,30.052,8,44.197c0,26.343-4.625,42-20,42 c-10.5,0-13.458-9.061-13.458-14.081c0-5.824,5.458-10.158,5.458-15.438c0-4.034-2.851-7.305-6.368-7.305 c-3.517,0-6.368,3.27-6.368,7.305c0,5.128,5.458,10.221,5.458,15.438c0,9.331-4.097,22.081-14.722,22.081 c-10.5,0-18-15.125-18-26.941c0-12.804,12-22.333,12-33.941c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059 c0,11.274,12,22.471,12,33.941c0,4.93-1.56,10.941-4,10.941c-2.528,0-3.228-4-6-4c-3.75,0-3.5,6-10,6s-7.25,12-20,12 c-9.865,0-15.436-5.345-15.436-10.485s5.436-9.878,5.436-15.034c0-4.034-2.851-7.305-6.368-7.305c-3.517,0-6.368,3.27-6.368,7.305 c0,5.128,5.458,10.221,5.458,15.438c0,8.581-30.146,23.914-30.146-32.319c0-24.993,23.424-43.595,23.424-66.253 C1054,54.034,1041.765,40,1026.672,40c-15.093,0-27.328,14.034-27.328,31.347c0,22.008,23.424,43.863,23.424,66.253 c0,7.276-1.34,22.4-6.768,22.4c-6.406,0-6.578-12-12-12c-4.854,0-6.167,6-10,6c-3,0-4.571-3.054-4.571-8.286 c0-9.146,8.571-15.952,8.571-24.244c0-6.335-4.477-11.471-10-11.471s-10,5.135-10,11.471c0,8.053,8.571,16.05,8.571,24.244 C986.571,159.875,980,170,972,170c-6.113,0-16.75-7.5-11.332-20.959c0.707-2.541,1.332-4.581,1.332-6.982 c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059c0,11.262,6,12.858,6,21.941c0,3.25-6.86,4-10.368,4 c-3.517,0-6.368,3.27-6.368,7.304c0,3.862-2.574,19.385-9.264,12.696c-7-7-10.5,0-24,0c-10.765,0-17.075-6.355-19.191-8.931 c-0.008-0.01-0.014-0.02-0.019-0.031c-1.793-4.32-3.362-8.925-3.362-12.853c0-9.146,8.571-15.952,8.571-24.244 c0-6.335-4.477-11.471-10-11.471s-10,5.136-10,11.471c0,8.053,8.571,16.05,8.571,24.244c0,0.242-0.008,0.492-0.023,0.748 c-1.084,18.701-28.16,19.987-31.794,1.611c-0.433-2.191-0.672-4.614-0.672-7.287c0-19.272,18.062-33.615,18.062-51.086 c0-13.349-9.434-24.171-21.072-24.171S808,96.822,808,110.171c0,16.97,18.062,33.821,18.062,51.086 c0,7.062-2.562,8.743-6.062,8.743c-3.833,0-6.115-2.824-9.632-2.824c-3.517,0-6.368,3.27-6.368,7.305c0,5.128-1.75,15.519-6,15.519 c-7.333,0-7-8-14-8c-6.083,0-12.722-8.5-12.722-20.081c0-5.824,5.458-10.158,5.458-15.438c0-4.034-2.851-7.305-6.368-7.305 s-6.368,3.27-6.368,7.305c0,5.128,5.458,10.221,5.458,15.438C769.458,166.647,766,174,760,174c-6.375,0-8.821-9.948-8.821-14.255 c0-32.954,30.885-57.48,30.885-87.355c0-22.826-16.132-41.331-36.032-41.331c-19.9,0-36.032,18.504-36.032,41.331 c0,29.017,30.885,57.833,30.885,87.355C740.885,173.75,728.008,186,720,186c-6.75,0-18-10.875-18-20c0-11.125,10-17.136,10-27.941 c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059c0,8.355,10,16.221,10,25.081S686.833,180,682,180s-8.333-10-18-10 c-7.801,0-12-7.141-12-17.941c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059c0.002,9.59-16.203,11.066-16.203-0.137 c-0.194-17.434,16.48-30.336,16.553-46.142c0.056-12.077-8.434-21.907-18.963-21.955c-10.529-0.048-19.109,9.703-19.164,21.78 c-0.071,15.352,16.128,30.673,16.128,46.293c0,22.478-32.921,28.978-32.921,1.818c0-9.146,8.571-15.952,8.571-24.244 c0-6.335-4.477-11.471-10-11.471s-10,5.135-10,11.471c0,8.053,8.571,16.05,8.571,24.244C566.571,169.5,551,176,538,176 c-6.562,0-12,6.375-12,12c0,6.22-14,7.5-14,0c0-8.15,6-14.921,6-22.529c0-6.335-4.477-11.471-10-11.471s-10,5.135-10,11.471 c0,8.053,6,14.398,6,22.529c0,6.75-17.89,7.899-18-2c-0.153-13.803,5.153-16.979,6.128-26.397 c1.57-15.164-10.774-27.603-24.064-27.603C454.774,132,444,144.358,444,159.603c0,7.184,6.125,14.397,0,14.397c-6.5,0-7.25-6-14-6 c-5.917,0-10,8.333-10-4c0-12.804,6-13.275,6-24.882c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059 c0,11.274,6,13.132,6,18.882c0,14.917-18.722,15.833-18.722,0.743c0-5.824,5.458-10.159,5.458-15.438 c0-4.034-2.851-7.304-6.368-7.304S378,139.27,378,143.304c0,5.128,5.458,10.221,5.458,15.438c0,11.257-21.609,14.424-21.609-13.714 c0-9.482,8.887-16.539,8.887-25.136c0-6.568-4.642-11.893-10.368-11.893c-5.726,0-10.368,5.325-10.368,11.893 c0,8.35,8.886,16.641,8.887,25.136C358.888,160.552,345.333,150,338,150c-7.791,0-16,5.5-16-6c0-17.167,22-30.499,22-55.482 c0-21.793-15.401-39.459-34.4-39.459c-18.999,0-34.4,17.666-34.4,39.459c0,11.485,8.097,24.911,12.098,30.846 c2.379,3.528,3.723,7.697,3.55,11.949c-0.185,4.538-2.072,9.381-8.849,10.687c-0.472,0.091-0.905,0.18-1.313,0.268 c0,0-0.459-0.031-0.686-0.053c-3.317-0.324-6.365-1.595-8-4.431c-2.631-4.564-6.907-7.784-12-7.784c-7.732,0-14,7.19-14,16.059 c0,11.274,6,13.941,6,21.941c0,15.815-23.448,26.256-23.99-14.546c-0.092-6.88,1.443-17.926,3.442-24.51 c0.742-2.445,1.284-4.8,1.284-6.463c0-4.034-2.851-7.305-6.368-7.305s-6.368,3.27-6.368,7.305c0,2.533,0.652,5.811,2,9.519 c1.819,5.006,2,9.75,2,20c0,23.25-18,23.5-18,6c0-8.566,8-14.863,8-22.882c0-8.869-6.268-16.059-14-16.059s-14,7.19-14,16.059 c0,8.132,6,12.382,6,16.882c0,4.833-3.5,8-10,8c-11.873,0-16.552-10.821-16.167-30.501C166.129,114.386,180,103.133,180,89.429 c0-10.471-7.4-18.959-16.528-18.959s-16.528,8.488-16.528,18.959c0,13.31,14.167,26.528,14.167,40.07 C161.111,178.188,142,163.757,142,158c0-5.743,2.736-9.416,2.736-14.696c0-4.034-2.851-7.304-6.368-7.304 c-3.517,0-6.368,3.27-6.368,7.304c0,5.128,5.458,10.221,5.458,15.438C137.458,178.75,115.25,152,106,152 c-9.75,0-24.571,10.625-24.571-4.286c0-9.146,8.571-15.952,8.571-24.244C90,117.135,85.523,112,80,112s-10,5.135-10,11.471 c0,8.053,9.705,16.129,8.571,24.244C76.44,162.972,70.806,148.362,64,154c-6.861,5.684-25.004-3.351-24.011-35.227 C40.736,94.787,62.48,76.914,62.48,55.158c0-16.623-11.748-30.099-26.24-30.099C21.748,25.059,10,38.534,10,55.158 c0,21.132,22.224,42.118,22.491,63.615c0.367,29.509-19.95,37.727-19.95,15.97c0-5.824,5.458-10.159,5.458-15.438 c0-4.034-2.851-7.304-6.368-7.304c-3.517,0-6.368,3.27-6.368,7.304c0,5.128,5.458,10.221,5.458,15.438 c0.002,7.285-11.633,8.024-14.485,3.672c-0.257,0.059,0.019-0.004-0.237,0.054v64.682C-4,204.728-2.721,206-1.144,206H6L6,206z"/>
		',
		);

		$ret['straight'] = array(
		'name' => __( 'Straight', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 38,
		'svg' => '
<rect x="-4" class="gambit_sep_decor1" width="1608" height="18"/>
<rect x="-4" y="12" class="gambit_sep_decor2" width="1608" height="18"/>
<rect x="-4" y="24" class="gambit_sep_main" width="1608" height="16"/>',
		);

		$ret['triangles-decor1'] = array(
		'name' => __( 'Triangles Large (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<polygon class="gambit_sep_main" points="-40,97.667 19.833,37.833 80,98 140,38 200,98 260,38 320,98 380,38 440,98 500,38 560,98 620,38 680,98 740,38 800,98 860,38 920,98 980,38 1040,98 1100,38 1160,98 1220,38 1280.333,98.333 1340.333,38.333 1400,98 1460,38 1520,98 1578,40 1636,98 1636,104 -40,104 "/>
<polygon class="gambit_sep_decor2" points="-40,97.667 19.833,37.833 80,98 140,38 200,98 260,38 320,98 380,38 440,98 500,38 560,98 620,38 680,98 740,38 800,98 860,38 920,98 980,38 1040,98 1100,38 1160,98 1220,38 1280.333,98.333 1340.333,38.333 1400,98 1460,38 1520,98 1578,40 1636,98 1636,86 1578,28 1520,86 1460,26 1400,86 1340,26 1280,86 1220,26 1160,86 1100,26 1040,86 980,26 920,86 860,26 800,86 740,26 680,86 620,26 560,86 500,26 440,86 380,26 320,86 260,26 200,86 140,26 80,86 20,26 -40,86 "/>
<polygon class="gambit_sep_decor1" points="-40,86 20,26 80,86 140,26 200,86 260,26 320,86 380,26 440,86 500,26 560,86 620,26 680,86 740,26 800,86 860,26 920,86 980,26 1040,86 1100,26 1160,86 1220,26 1280,86 1340,26 1400,86 1460,26 1520,86 1578,28 1636,86 1636,74 1578,16 1520,74 1460,14 1400,74 1340,14 1280,74 1220,14 1160,74 1100,14 1040,74 980,14 920,74 860,14 800,74 740,14 680,74 620,14 560,74 500,14 440,74 380,14 320,74 260,14 200,74 140,14 80,74 20,14 -40,74 "/>',
		);

		$ret['triangles-decor2'] = array(
		'name' => __( 'Triangles Large (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<polygon class="gambit_sep_main" points="-40,63.667 19.833,3.833 80,64 140,4 200,64 260,4 320,64 380,4 440,64 500,4 560,64 620,4 680,64 740,4 800,64 860,4 920,64 980,4 1040,64 1100,4 1160,64 1220,4 1280.333,64.333 1340.333,4.333 1400,64 1460,4 1520,64 1578,6 1636,64 1636,104 -40,104 "/>
<polygon class="gambit_sep_decor1" points="-40,86 20,26 80,86 140,26 200,76 260,4 200,64 140,4 80,64 19.833,3.833 -40,63.667 "/>
<polygon class="gambit_sep_decor2" points="1159,69 1220,8 1281,73 1340,14 1399,73 1460,12 1521,73 1578,16 1634,72 1636,73.333 1636,64 1578,6 1520,64 1460,4 1400,64 1340.333,4.333 1280.333,64.333 1220,4 1160,64 1100,4 1040,64 1100,10 "/>',
		);

		$ret['triangles-decor3'] = array(
		'name' => __( 'Triangles Large (Decor #3)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<polygon class="gambit_sep_decor1" points="1616,54.3 1615,55.3 1597.8,38 1580.6,55.3 1563.3,38 1546.1,55.3 1528.9,38 1511.6,55.3
1494.4,38 1477.2,55.3 1459.9,38 1443,55 1426.6,38.6 1410,55.3 1392.7,38 1375.5,55.3 1358.4,38.1 1341.1,55.4 1323.8,38
1306.6,55.3 1289.4,38 1272.1,55.3 1254.9,38 1237.7,55.3 1220.4,38 1203.2,55.3 1186,38 1168.8,55.3 1151.5,38 1134.3,55.3
1117.1,38 1099.8,55.3 1082.6,38 1065.4,55.3 1048.1,38 1030.9,55.3 1013.7,38 996.5,55.3 979.2,38 962,55.2 962,55.3 945.3,38.6
928.7,55.3 911.5,38 894.2,55.3 877.1,38.1 859.9,55.4 842.5,38 825.3,55.3 808.1,38 790.9,55.3 773.6,38 756.4,55.3 739.2,38
721.9,55.3 704.7,38 687.5,55.3 670.2,38 653,55.3 635.8,38 618.6,55.3 601.3,38 584.1,55.3 566.9,38 549.6,55.3 532.4,38
515.2,55.3 497.9,38 481,55 464.6,38.6 448,55.3 430.7,38 413.5,55.3 396.4,38.1 379.1,55.4 361.8,38 344.6,55.3 327.4,38
310.1,55.3 292.9,38 275.7,55.3 258.4,38 241.2,55.3 224,38 206.8,55.3 189.5,38 172.3,55.3 155.1,38 137.8,55.3 120.6,38
103.4,55.3 86.1,38 68.9,55.3 51.7,38 34.5,55.3 17.2,38 0,55.2 0,98 480.7,98 481.3,98 962,98 1442.7,98 1443.3,98 1616,98"/>
<polygon class="gambit_sep_main" points="-40,97.7 19.8,37.8 80,98 140,38 200,98 260,38 320,98 380,38 440,98
500,38 560,98 620,38 680,98 740,38 800,98 860,38 920,98 980,38 1040,98 1100,38 1160,98 1220,38 1280.3,98.3 1340.3,38.3
1400,98 1460,38 1520,98 1578,40 1636,98 1636,259 -40,259 	"/>
<polygon class="gambit_sep_decor2" points="-40,97.7 19.8,37.8 80,98 140,38 200,98 260,38 320,98 380,38 440,98
500,38 560,98 620,38 680,98 740,38 800,98 860,38 920,98 980,38 1040,98 1100,38 1160,98 1220,38 1280.3,98.3 1340.3,38.3
1400,98 1460,38 1520,98 1578,40 1636,98 1636,86 1578,28 1520,86 1460,26 1400,86 1340,26 1280,86 1220,26 1160,86 1100,26
1040,86 980,26 920,86 860,26 800,86 740,26 680,86 620,26 560,86 500,26 440,86 380,26 320,86 260,26 200,86 140,26 80,86 20,26
-40,86 	"/>',
		);

		$ret['triangles-small-decor1'] = array(
		'name' => __( 'Triangles Small (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<polygon class="gambit_sep_main" points="1610.9,67.9 1581.9,97 1551.8,66.9 1521.7,97 1491.8,67.1 1461.7,97.2 1431.5,66.9
1401.4,97 1371.4,66.9 1341.3,97 1311.2,66.9 1281.1,97 1251.1,66.9 1221,97 1190.9,66.9 1160.9,97 1130.8,66.9 1100.7,97
1070.6,66.9 1040.6,97 1010.5,66.9 980.4,97 950.4,66.9 920.3,97 890.2,66.9 860.1,97 830,66.8 800,96.8 800,97 770.9,67.9
741.9,97 711.8,66.9 681.7,97 651.8,67.1 621.7,97.2 591.5,66.9 561.4,97 531.4,66.9 501.3,97 471.2,66.9 441.1,97 411.1,66.9
381,97 350.9,66.9 320.9,97 290.8,66.9 260.7,97 230.6,66.9 200.6,97 170.5,66.9 140.4,97 110.4,66.9 80.3,97 50.2,66.9 20.1,97
-10,66.8 -40,96.8 -40,224 1640,224 1640,97 	"/>
<polygon class="gambit_sep_decor2" points="1610.9,61.9 1581.9,91 1551.8,60.9 1521.7,91 1491.6,60.9 1461.6,91
1431.5,60.9 1401.4,91 1371.4,60.9 1341.3,91 1311.2,60.9 1281.1,91 1251.1,60.9 1221,91 1190.9,60.9 1160.9,91 1130.8,60.9
1100.7,91 1070.6,60.9 1040.6,91 1010.5,60.9 980.4,91 950.4,60.9 920.3,91 890.2,60.9 860.1,91 830.1,60.9 800,91 770.9,61.9
741.9,91 711.8,60.9 681.7,91 651.6,60.9 621.6,91 591.5,60.9 561.4,91 531.4,60.9 501.3,91 471.2,60.9 441.1,91 411.1,60.9
381,91 350.9,60.9 320.9,91 290.8,60.9 260.7,91 230.6,60.9 200.6,91 170.5,60.9 140.4,91 110.4,60.9 80.3,91 50.2,60.9 20.1,91
-9.9,60.9 -40,91 -40,96.8 -10,66.8 20.1,97 50.2,66.9 80.3,97 110.4,66.9 140.4,97 170.5,66.9 200.6,97 230.6,66.9 260.7,97
290.8,66.9 320.9,97 350.9,66.9 381,97 411.1,66.9 441.1,97 471.2,66.9 501.3,97 531.4,66.9 561.4,97 591.5,66.9 621.7,97.2
651.8,67.1 681.7,97 711.8,66.9 741.9,97 770.9,67.9 800,97 800,96.8 830,66.8 860.1,97 890.2,66.9 920.3,97 950.4,66.9 980.4,97
1010.5,66.9 1040.6,97 1070.6,66.9 1100.7,97 1130.8,66.9 1160.9,97 1190.9,66.9 1221,97 1251.1,66.9 1281.1,97 1311.2,66.9
1341.3,97 1371.4,66.9 1401.4,97 1431.5,66.9 1461.7,97.2 1491.8,67.1 1521.7,97 1551.8,66.9 1581.9,97 1610.9,67.9 1640,97
1640,91"/>
<polygon class="gambit_sep_decor1" points="1610.9,55.9 1581.9,85 1551.8,54.9 1521.7,85 1491.6,54.9 1461.6,85
1431.5,54.9 1401.4,85 1371.4,54.9 1341.3,85 1311.2,54.9 1281.1,85 1251.1,54.9 1221,85 1190.9,54.9 1160.9,85 1130.8,54.9
1100.7,85 1070.6,54.9 1040.6,85 1010.5,54.9 980.4,85 950.4,54.9 920.3,85 890.2,54.9 860.1,85 830.1,54.9 800,85 770.9,55.9
741.9,85 711.8,54.9 681.7,85 651.6,54.9 621.6,85 591.5,54.9 561.4,85 531.4,54.9 501.3,85 471.2,54.9 441.1,85 411.1,54.9
381,85 350.9,54.9 320.9,85 290.8,54.9 260.7,85 230.6,54.9 200.6,85 170.5,54.9 140.4,85 110.4,54.9 80.3,85 50.2,54.9 20.1,85
-9.9,54.9 -40,85 -40,91 -9.9,60.9 20.1,91 50.2,60.9 80.3,91 110.4,60.9 140.4,91 170.5,60.9 200.6,91 230.6,60.9 260.7,91
290.8,60.9 320.9,91 350.9,60.9 381,91 411.1,60.9 441.1,91 471.2,60.9 501.3,91 531.4,60.9 561.4,91 591.5,60.9 621.6,91
651.6,60.9 681.7,91 711.8,60.9 741.9,91 770.9,61.9 800,91 830.1,60.9 860.1,91 890.2,60.9 920.3,91 950.4,60.9 980.4,91
1010.5,60.9 1040.6,91 1070.6,60.9 1100.7,91 1130.8,60.9 1160.9,91 1190.9,60.9 1221,91 1251.1,60.9 1281.1,91 1311.2,60.9
1341.3,91 1371.4,60.9 1401.4,91 1431.5,60.9 1461.6,91 1491.6,60.9 1521.7,91 1551.8,60.9 1581.9,91 1610.9,61.9 1640,91 1640,85"/>'
		);

		$ret['triangles-small-decor2'] = array(
		'name' => __( 'Triangles Small (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<polygon class="gambit_sep_main" points="1612,58 1582,84 1552,54 1521.857,84 1491.814,53.928 1461.742,84 1431.504,53.928 1401.432,84 1371.36,52.926 1341.289,82.998 1311.217,52.926 1281.146,82.998 1251.074,52.926 1221.002,82.998 1190.931,52.926 1160.859,82.998 1130.788,52.926 1100.716,82.998 1070.644,52.926 1040.573,82.998 1010.501,52.926 980.43,82.998 950.358,52.926 920.286,82.998 890.215,52.926 860.143,82.998 829.988,52.842 800,82.831 800,82.998 770.931,53.928 741.862,82.998 711.79,52.926 681.718,82.998 651.814,53.093 621.742,83.165 591.504,52.926 561.432,82.998 531.36,52.926 501.289,82.998 471.217,52.926 441.146,82.998 411.074,52.926 381.002,82.998 350.931,52.926 320.859,84 290.788,53.928 260.716,84 230.644,53.928 200.573,84 170.501,53.928 140.43,84 110.358,53.928 80.286,84 50.215,54 20.143,84 -10.012,53.916 -40,82.831 -40,102 800,102 1640,102 1640,86 "/>
<polygon class="gambit_sep_decor1" points="20,92 50,62 79,91 110,60 140,90 170,60 199,89 231,57 260,86 291,55 321,85 352.002,53.998 350.931,52.926 320.859,82.998 290.788,52.926 260.716,82.998 230.644,52.926 200.573,82.998 170.501,52.926 140.43,82.998 110.358,52.926 80.286,82.998 50.215,52.926 20.143,82.998 -10.012,52.842 -40,82.831 -40,92 -10,62 "/>
<polygon class="gambit_sep_decor2" points="1610.931,53.928 1581.862,82.998 1551.79,52.926 1521.718,82.998 1491.814,53.093 1461.742,83.165 1431.504,52.926 1401.432,82.998 1371.36,52.926 1370.143,54.143 1401,85 1431,55 1461,85 1491,55 1522,86 1551,57 1583,89 1611,61 1640,90 1640,82.998 "/>',
		);

		$ret['water-bend'] = array(
		'name' => __( 'Water Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1632.733,159.72c-36.963-7.414-64.016-29.423-60.322-49.861 c-3.816,20.415-36.934,31.361-74.065,25.15c-37.129-6.23-64.827-27.365-61.782-47.909c-3.167,20.526-35.884,32.521-73.151,27.495 c-37.264-5.045-65.59-25.289-63.196-45.92c-2.516,20.616-34.805,33.645-72.18,29.804c-37.373-3.86-66.301-23.197-64.562-43.892 c-1.863,20.685-33.701,34.731-71.155,32.075c-37.454-2.675-66.965-21.087-65.879-41.827c-1.207,20.733-32.571,35.779-70.077,34.309 c-37.505-1.49-67.577-18.96-67.147-39.724c-0.552,20.761-31.415,36.791-68.945,36.506c-37.529-0.304-68.138-16.815-68.364-37.583 c0.104,20.768-30.237,37.765-67.761,38.666c-37.525,0.882-68.648-14.654-69.53-35.404c0.76,20.755-29.036,38.702-66.527,40.789 c-37.492,2.068-69.106-12.475-70.644-33.187c1.416,20.72-27.813,39.601-65.242,42.875c-37.431,3.254-69.512-10.279-71.704-30.932 c2.07,20.665-26.568,40.463-63.908,44.923c-37.341,4.441-69.866-8.066-72.71-28.639c2.723,20.589-25.304,41.288-62.525,46.935 c-37.224,5.628-70.167-5.836-73.662-26.308c3.374,20.493-24.02,42.075-61.095,48.909c-26.783,4.924-51.531,0.86-64.858-9.414 C-55.364,152.1-50.893,181.457-48,196c557.892-75.029,1152.295-72.395,1730,12c3.121-14.495,12.61-42.181,15.73-56.676 C1684.244,161.388,1659.435,165.063,1632.733,159.72z"/>
<path class="gambit_sep_decor2" d="M1628.946,161.993c-3.237,12.388-21.511,18.387-40.897,13.648 c-19.385-4.746-32.794-18.498-29.882-30.966c-2.964,12.456-21.112,18.853-40.602,14.539c-19.489-4.321-33.205-17.776-30.564-30.305 c-2.69,12.518-20.698,19.31-40.285,15.423c-19.585-3.894-33.596-17.047-31.231-29.63c-2.415,12.574-20.276,19.757-39.948,16.299 c-19.672-3.466-33.97-16.31-31.883-28.942c-2.139,12.623-19.841,20.195-39.59,17.166c-19.747-3.036-34.328-15.565-32.52-28.24 c-1.86,12.667-19.396,20.623-39.21,18.024c-19.813-2.605-34.67-14.814-33.141-27.525c-1.58,12.705-18.941,21.04-38.811,18.874 c-19.869-2.173-34.993-14.056-33.746-26.797c-1.299,12.736-18.475,21.447-38.392,19.714c-19.916-1.741-35.301-13.292-34.335-26.057 c-1.018,12.761-18,21.844-37.953,20.544c-19.953-1.307-35.59-12.521-34.907-25.305c-0.735,12.78-17.516,22.23-37.495,21.364 c-19.98-0.873-35.862-11.745-35.461-24.54c-0.453,12.793-17.022,22.606-37.018,22.174c-14.441-0.317-26.825-5.887-32.586-13.772 c-5.953,7.745-18.47,13.017-32.915,12.988c-20.001-0.046-36.329-10.252-36.468-23.053c0.087,12.801-16.059,23.29-36.058,23.685 c-19.999,0.388-36.548-9.46-36.97-22.255c0.369,12.796-15.541,23.633-35.527,24.462c-19.987,0.823-36.748-8.664-37.454-21.446 c0.653,12.785-15.016,23.965-34.978,25.229c-19.963,1.257-36.931-7.863-37.919-20.626c0.935,12.767-14.483,24.285-34.412,25.983 c-19.931,1.691-37.094-7.058-38.364-19.796c1.217,12.744-13.942,24.594-33.829,26.725c-19.888,2.124-37.239-6.248-38.79-18.956 c1.499,12.714-13.396,24.892-33.23,27.455c-19.835,2.556-37.365-5.436-39.196-18.107c1.779,12.678-12.843,25.177-32.614,28.172 c-19.772,2.988-37.472-4.62-39.582-17.248c2.058,12.636-12.284,25.451-31.982,28.877c-19.699,3.419-37.56-3.801-39.947-16.38 c2.336,12.588-11.719,25.713-31.334,29.568c-19.617,3.848-37.628-2.98-40.292-15.504c2.612,12.534-11.149,25.963-30.672,30.246 c-19.524,4.276-37.678-2.156-40.615-14.619c2.886,12.474-10.575,26.201-29.995,30.91c-19.422,4.703-37.708-1.331-40.917-13.726 c3.159,12.408-9.996,26.427-29.303,31.561l1713.01,1.778C1638.864,188.437,1625.76,174.395,1628.946,161.993z"/>
<path class="gambit_sep_decor2" d="M24,196.198C289.033,135.265,554.741,120.663,830,124 c257.6,3.04,520.31,16.335,771.546,71.999"/>
<path class="gambit_sep_main" d="M1554.578,183.609c-34.181-6.578-57.238-38.745-51.409-72.496 c-6.029,33.715-38.679,56.091-73.006,50.626c-34.325-5.484-58.355-36.899-53.598-70.817c-4.957,33.89-36.847,57.294-71.291,52.923 c-34.442-4.389-59.428-35.025-55.746-69.077c-3.882,34.03-34.985,58.434-69.521,55.159c-34.534-3.294-60.456-33.123-57.853-67.274 c-2.804,34.135-33.099,59.513-67.699,57.333c-34.599-2.199-61.437-31.193-59.915-65.41c-1.724,34.207-31.186,60.531-65.826,59.445 c-34.639-1.104-62.373-29.236-61.932-63.483c-0.642,34.244-29.251,61.486-63.903,61.495c-34.652-0.009-63.261-27.251-63.903-61.495 c0.44,34.247-27.293,62.379-61.932,63.483c-34.64,1.085-64.103-25.238-65.826-59.445c1.522,34.216-25.315,63.211-59.915,65.41 c-34.6,2.18-64.895-23.198-67.699-57.333c2.603,34.151-23.319,63.98-57.852,67.274c-34.535,3.275-65.639-21.13-69.521-55.159 c3.681,34.052-21.303,64.688-55.746,69.077c-34.444,4.37-66.333-19.034-71.291-52.923c4.757,33.918-19.273,65.334-53.598,70.817 c-34.327,5.465-66.977-16.91-73.006-50.626c5.829,33.751-17.227,65.918-51.409,72.496c-24.713,4.744-48.87-5.064-63.18-23.457 C-7.04,184.101-2.081,208.051,2.879,232c265.822-16.171,531.64-24.282,797.454-24.333c267.51-0.052,535.026,8.059,802.546,24.333 c4.96-23.949,9.919-47.899,14.879-71.848C1603.448,178.545,1579.29,188.353,1554.578,183.609z"/>',
		);

		$ret['water-wave-bend'] = array(
		'name' => __( 'Water Wave Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M1657.6,155.7c1.5-4.4,5.7-0.5,5.7-0.5c0,0-0.4-4.3-6-6.2c-8.2-2.7-17.4,7.7-31.6,3.3
c-5.5-1.8-13.5-6.7-12.1-11c1.4-4.4,5.7-0.6,5.7-0.6c0,0-0.5-4.3-6.1-6.1c-8.3-2.6-17.4,8.1-31.8,3.7c-5.5-1.7-13.9-6.4-12.6-10.9
c1.3-4.4,5.7-0.7,5.7-0.7c0,0-0.5-4.3-6.2-6c-8.4-2.5-17.2,8.4-31.7,4.3c-5.5-1.6-14-6.2-12.8-10.6c1.2-4.4,5.7-0.8,5.7-0.8
c0,0-0.6-4.3-6.3-5.9c-8.4-2.3-17.1,8.7-31.6,4.9c-5.5-1.5-14.1-6-12.9-10.4c1.2-4.5,5.7-0.9,5.7-0.9c0,0-0.7-4.3-6.4-5.7
c-8.4-2.2-16.9,9-31.5,5.4c-5.5-1.4-14.2-5.7-13.1-10.2c1.1-4.5,5.6-1,5.6-1c0,0-0.8-4.3-6.4-5.6c-8.4-2-16.7,9.3-31.3,6
c-5.6-1.3-14.3-5.5-13.3-9.9c1-4.5,5.6-1.1,5.6-1.1c0,0-0.8-4.2-6.5-5.5c-8.5-1.9-16.5,9.6-31.2,6.5c-5.6-1.2-14.3-5.2-13.4-9.7
c0.9-4.5,5.6-1.1,5.6-1.1c0,0-0.9-4.2-6.6-5.4c-8.5-1.7-16.4,9.9-31.1,7c-5.6-1.1-14.4-5-13.6-9.5c0.9-4.5,5.6-1.2,5.6-1.2
c0,0-1-4.2-6.7-5.3c-8.5-1.6-16.2,10.2-30.9,7.6c-5.6-1-14.5-4.7-13.7-9.2c0.8-4.5,5.5-1.3,5.5-1.3c0,0-1-4.2-6.8-5.2
c-8.5-1.4-16,10.5-30.8,8.1c-5.6-0.9-14.5-4.5-13.9-9c0.7-4.6,5.5-1.4,5.5-1.4c0,0-1.1-4.2-6.9-5c-8.5-1.3-15.8,10.7-30.6,8.6
c-5.6-0.8-14.6-4.2-14-8.8c0.6-4.6,5.5-1.5,5.5-1.5c0,0-1.2-4.2-7-4.9c-8.5-1.1-15.5,10.9-30.2,9.2c-5.7-0.8-14.4-4-13.8-8.5
c0.5-4.6,5.5-1.6,5.5-1.6c0,0-1.3-4.1-7-4.8c-8.6-1-15.4,11.3-30.3,9.7c-5.7-0.6-14.7-3.7-14.3-8.3c0.5-4.6,5.4-1.7,5.4-1.7
c0,0-1.3-4.1-7.1-4.7c-8.6-0.8-15.2,11.5-30.1,10.2c-5.7-0.5-14.8-3.4-14.4-8c0.4-4.6,5.4-1.8,5.4-1.8c0,0-1.4-4.1-7.2-4.6
c-8.6-0.7-15,11.8-29.9,10.7c-5.7-0.4-14.8-3.2-14.5-7.8c0.3-4.6,5.4-1.9,5.4-1.9c0,0-1.5-4.1-7.3-4.4c-8.5-0.5-14.6,11.7-29,11.2
c-5.7-0.5-14.1-3.1-13.9-7.5c0.2-4.6,5.3-2,5.3-2c0,0-1.5-4-7.3-4.3c-8.6-0.4-14.6,12.3-29.5,11.7c-5.7-0.2-14.9-2.7-14.8-7.3
c0.1-4.6,5.3-2.1,5.3-2.1c0,0-1.6-4-7.4-4.2c-8.6-0.3-14.4,12.5-29.3,12.2c-5.7-0.1-15-2.4-14.9-7c0.1-4.6,5.3-2.2,5.3-2.2
c0,0-1.7-4-7.5-4.1c-8.6-0.1-14.2,12.8-29.1,12.7c-5.7,0-15-2.2-15-6.8c0-4.6,5.2-2.3,5.2-2.3c0,0-1.7-4-7.5-3.9
c-8.6,0-13.9,13-28.8,13.2c-5.7,0.1-15.1-1.9-15.1-6.5c-0.1-4.6,5.2-2.4,5.2-2.4c0,0-1.8-3.9-7.6-3.8
c-8.6,0.2-13.7,13.3-28.6,13.7c-5.7,0.2-15.1-1.7-15.3-6.3c-0.2-4.6,5.1-2.4,5.1-2.4c0,0-1.9-3.9-7.7-3.7
c-8.6,0.3-13.5,13.5-28.4,14.2c-5.7,0.3-15.1-1.4-15.4-6c-0.2-4.6,5.1-2.5,5.1-2.5c0,0-1.9-3.9-7.7-3.5
c-8.6,0.5-13.2,13.6-27.9,14.7c-5.7,0.3-14.8-1.2-15.2-5.8c-0.3-4.6,5.1-2.6,5-2.6c0,0-2-3.8-7.8-3.4c-8.6,0.6-13,13.9-27.9,15.2
c-5.7,0.5-15.2-0.9-15.6-5.5c-0.4-4.6,5-2.7,5-2.7c0,0-2.1-3.8-7.9-3.3c-8.6,0.8-12.8,14.2-27.6,15.6c-5.7,0.6-15.2-0.6-15.7-5.2
c-0.5-4.6,5-2.8,5-2.8c0,0-2.1-3.8-7.9-3.1C503,25,499,38.5,484.2,40.2c-5.7,0.7-15.2-0.4-15.8-4.9c-0.6-4.6,4.9-2.9,4.9-2.9
c0,0-2.2-3.7-8-3c-8.6,1.1-12.3,14.6-27.1,16.6c-5.6,0.8-15.2-0.1-15.9-4.7c-0.6-4.6,4.9-3,4.9-3c0,0-2.3-3.7-8-2.9
c-8.6,1.2-12.1,14.8-26.9,17c-5.6,0.8-15.2,0.2-15.9-4.4c-0.7-4.6,4.8-3,4.8-3c0,0-2.3-3.6-8.1-2.7c-8.5,1.4-11.8,15-26.6,17.5
c-5.6,0.9-15.2,0.4-16-4.1c-0.8-4.5,4.8-3.1,4.8-3.1c0,0-2.4-3.6-8.1-2.6c-8.5,1.5-11.6,15.2-26.3,18c-5.6,1-15.2,0.7-16.1-3.8
c-0.9-4.5,4.7-3.2,4.7-3.2c0,0-2.5-3.6-8.2-2.4c-8.5,1.7-11.3,15.4-26,18.4c-5.6,1.1-15.2,1-16.2-3.5c-1-4.5,4.7-3.3,4.7-3.3
c0,0-2.5-3.5-8.2-2.3c-8.5,1.8-11.1,15.6-25.7,18.9c-5.6,1.2-15.2,1.2-16.3-3.3c-1-4.5,4.6-3.4,4.6-3.4c0,0-2.6-3.5-8.3-2.2
c-8.5,2-10.8,15.8-25.4,19.3c-5.6,1.3-15.2,1.5-16.3-3c-1.1-4.5,4.6-3.4,4.6-3.4c0,0-2.6-3.4-8.3-2c-8.4,2.1-10.5,15.8-24.8,19.7
c-5.6,1.4-14.9,1.6-16.1-2.8c-1.2-4.5,4.5-3.5,4.5-3.5c0,0-2.7-3.4-8.4-1.9c-8.4,2.2-10.3,16.2-24.8,20.2
c-5.5,1.5-15.2,2-16.5-2.4c-1.3-4.4,4.5-3.6,4.5-3.6c0,0-2.8-3.3-8.4-1.7c-8.4,2.4-10,16.4-24.5,20.6c-5.5,1.6-15.2,2.3-16.5-2.1
c-1.3-4.4,4.4-3.7,4.4-3.7c0,0-2.8-3.3-8.4-1.6c-8.3,2.5-9.8,16.5-24.1,21.1c-5.5,1.7-15.1,2.6-16.6-1.8c-1.4-4.4,4.3-3.8,4.3-3.8
c0,0-2.9-3.2-8.5-1.4c-8.3,2.7-9.5,16.7-23.8,21.5l1725.4,3.9C1661.4,163.1,1656.5,159.2,1657.6,155.7z"/>
<path class="gambit_sep_decor1" d="M1666.2,165.5c1.3,0.6,2.5,1.2,3.7,1.6c8.5,2.9,15.3,0.4,21.2-1.5L1666.2,165.5z"/>
<path class="gambit_sep_decor2" d="M1594.2,156.7c2.4-7.2,9.4-0.8,9.4-0.8c0,0-0.7-7.1-9.8-10.1c-13.6-4.4-28.6,13-52,5.7
c-8.9-2.8-22.6-10.6-20.5-17.8c2.2-7.2,9.3-1.1,9.3-1.1c0,0-0.9-7-10.1-9.8c-13.7-4-28.1,13.8-51.7,7.3c-9-2.5-22.9-9.9-21-17.2
c1.9-7.3,9.3-1.4,9.3-1.3c0,0-1.1-7-10.3-9.4c-13.8-3.6-27.7,14.7-51.4,8.9c-9-2.2-23.1-9.2-21.4-16.5c1.7-7.3,9.2-1.6,9.2-1.6
c0,0-1.3-7-10.6-9.1c-13.8-3.2-27.2,15.5-51,10.4c-9.1-1.9-23.4-8.5-21.9-15.8c1.5-7.4,9.1-1.9,9.1-1.9c0,0-1.5-6.9-10.9-8.8
c-13.9-2.8-26.6,16.3-50.6,12c-9.1-1.7-23.6-7.8-22.3-15.2c1.3-7.4,9.1-2.2,9.1-2.2c0,0-1.7-6.9-11.1-8.5
c-14-2.3-26.1,17.1-50.2,13.5c-9.2-1.4-23.8-7-22.7-14.5c1-7.5,9-2.5,9-2.5c0,0-1.9-6.8-11.3-8.1c-13.9-1.9-25.4,17.7-49.3,15
c-9.2-1.2-23.4-6.4-22.6-13.8c0.8-7.5,8.9-2.7,8.9-2.7c0,0-2.1-6.8-11.6-7.8c-14.1-1.5-25,18.7-49.2,16.4
c-9.2-0.8-24.1-5.6-23.5-13.1c0.6-7.5,8.8-3,8.8-3c0,0-2.3-6.7-11.8-7.4c-14.1-1.1-24.4,19.4-48.6,17.9
c-9.2-0.6-24.3-4.9-23.9-12.4c0.4-7.5,8.7-3.3,8.7-3.2c0,0-2.5-6.6-12-7.1c-14.1-0.7-23.8,20.1-48.1,19.4
c-9.2-0.3-24.4-4.2-24.2-11.7c0.2-7.5,8.6-3.5,8.6-3.5c0,0-2.7-6.5-12.2-6.7c-14.1-0.2-23.2,20.8-47.5,20.8
c-9.2,0-24.5-3.4-24.6-11c-0.1-7.5,8.5-3.8,8.5-3.8c0,0-2.9-6.5-12.4-6.4c-14.1,0.2-22.6,21.5-46.8,22.2
c-9.2,0.3-24.6-2.7-24.9-10.2c-0.3-7.5,8.4-4,8.4-4c0,0-3.1-6.4-12.6-6c-14.1,0.6-21.9,22.2-46.2,23.6c-9.2,0.5-24.7-2-25.2-9.5
c-0.5-7.5,8.3-4.3,8.3-4.3c0,0-3.3-6.3-12.7-5.6c-14.1,1-21.3,22.8-45.4,25c-9.2,0.8-24.7-1.2-25.5-8.7c-0.7-7.5,8.1-4.5,8.1-4.5
c0,0-3.5-6.2-12.9-5.2c-14.1,1.5-20.6,23.4-44.7,26.3c-9.2,1.1-24.8-0.5-25.8-7.9c-1-7.5,8-4.8,8-4.7c0,0-3.6-6.1-13.1-4.8
c-14,1.9-19.9,24.1-43.9,27.6c-9.2,1.4-24.8,0.3-26-7.2c-1.2-7.4,7.9-5,7.9-5c0,0-3.8-6-13.2-4.4c-14,2.3-19.2,24.6-43.2,29
c-9.1,1.6-24.8,1-26.2-6.4c-1.4-7.4,7.7-5.2,7.7-5.2c0,0-4-5.8-13.4-4c-13.8,2.7-18.4,24.9-41.9,30.2c-9.2,1.8-24.3,1.5-26-5.7
c-1.6-7.4,7.6-5.5,7.6-5.5c0,0-4.2-5.7-13.5-3.6c-13.9,3.1-17.7,25.8-41.5,31.5c-9.1,2.2-24.8,2.5-26.7-4.8
c-1.9-7.3,7.4-5.7,7.4-5.7c0,0-4.4-5.6-13.6-3.2c-13.8,3.6-17,26.3-40.6,32.8c-9,2.5-24.7,3.3-26.8-4c-2.1-7.3,7.3-5.9,7.3-5.9
c0,0-4.5-5.4-13.7-2.8c-13.7,4-16.2,26.8-39.7,34c-8.9,2.7-24.7,4-27-3.1c-2.3-7.2,7.1-6.1,7.1-6.1c0,0-4.7-5.3-13.8-2.4
c-11.1,3.6-14.4,19.6-28,29.6l1612.9,1.6C1598.6,167.2,1592.5,161.7,1594.2,156.7z"/>
<path class="gambit_sep_main" d="M1689.4,200.8c-19.3-6.7-48.9-24.3-44-39.9c5-15.6,20.4-1.8,20.4-1.8
c0,0-1.6-15.3-21.8-21.7c-30-9.4-62,28.7-113.3,14.4c-19.6-5.5-50-21.3-46-37.1c4-15.8,20.2-3,20.2-3c0,0-2.5-15.2-22.9-20.3
c-30.4-7.5-59.9,32.4-111.8,21.3c-19.8-4.3-51-18.2-48-34.2c3.1-16.1,19.9-4.3,19.9-4.3c0,0-3.4-15-24-18.9
c-30.7-5.7-57.7,36-110,28c-20-3.1-51.9-15.1-49.8-31.2c2.1-16.2,19.6-5.5,19.6-5.4c0,0-4.3-14.8-25-17.4
c-30.9-3.8-55.3,39.4-107.9,34.6c-20.1-1.9-52.6-11.9-51.5-28.2c1.1-16.3,19.2-6.6,19.2-6.6c0,0-5.1-14.5-26-15.9
c-31.1-2-52.8,42.7-105.6,41c-20.1-0.7-53.2-8.8-53.1-25.1c0.2-16.4,18.8-7.8,18.8-7.7c0,0-6-14.2-26.9-14.3
C788.7,6.7,769.7,52.6,716.9,54c-20.1,0.5-53.6-5.6-54.5-21.8c-0.8-16.3,18.3-8.9,18.3-8.9c0,0-6.8-13.8-27.7-12.7
c-30.9,1.8-47.2,48.1-99,53.2c-20.2,1.5-52.9-2.8-54.6-18.7c-1.8-16.3,17.7-9.9,17.7-9.9c0,0-7.6-13.3-28.4-11
c-31,3.6-44.4,51.4-96.8,59.1c-20,2.9-54.1,0.9-56.9-15.2c-2.7-16.1,17.2-11,17.1-11c0,0-8.4-12.9-29.1-9.3
c-30.7,5.5-41.4,54-93.3,64.8c-19.8,4.1-54.1,4.1-57.8-11.7c-3.7-15.9,16.5-12,16.5-12c0,0-9.2-12.3-29.7-7.5
c-30.5,7.3-38.2,56.4-89.6,70.4c-19.6,5.3-53.9,7.4-58.6-8.2c-4.7-15.7,15.8-13,15.8-13c0,0-10-11.7-30.2-5.7
c-30.1,9.2-35,58.7-85.6,75.8c3.5,10.1,6.9,20.2,10.4,30.3c0,2.7,1758,2.7,1758,0C1682.5,221,1685.9,210.9,1689.4,200.8z"/>',
		);

		$ret['water-wave-large'] = array(
		'name' => __( 'Water Large Wave', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor2" d="M-16,129.803C28.268,129.803,43.874,86,74.839,86 c26.605,0,15.874,35.884-0.894,27.723c8.831,0,8.943-12.52,0.894-12.52c-12.967,0-9.167,38.455,26.829,38.455s1.409,0,1.409,0 v16.097H-16V129.803z"/>
<path class="gambit_sep_decor1" d="M-114,123.448C-17.538,133.448,16.468,38,83.943,38 c57.974,0,34.59,78.192-1.949,60.41c19.244,0,19.487-27.282,1.949-27.282c-28.256,0-19.974,83.795,58.462,83.795s3.071,0,3.071,0 V180H-114V123.448z"/>
<path class="gambit_sep_decor1" d="M158,172.749C238.596,172.749,267.01,93,323.386,93 c48.439,0,28.901,65.332-1.628,50.474c16.079,0,16.282-22.795,1.628-22.795c-23.609,0-16.689,70.013,48.846,70.013s2.566,0,2.566,0 L158,192V172.749z"/>
<path class="gambit_sep_decor2" d="M156,160.626c53.515,0,72.381-52.953,109.815-52.953 c32.163,0,19.19,43.38-1.081,33.514c10.676,0,10.811-15.136,1.081-15.136c-15.676,0-11.081,46.488,32.433,46.488s1.704,0,1.704,0 V192H156V160.626z"/>
<path class="gambit_sep_decor2" d="M-108.04,114.107c68.046,0,92.035-67.331,139.634-67.331 c40.897,0,24.4,55.159-1.375,42.615c13.575,0,13.747-19.245,1.375-19.245c-19.933,0-14.09,59.111,41.24,59.111s2.166,0,2.166,0V154 h-183.04V114.107z"/>
<path class="gambit_sep_main" d="M-4,142.333C121.654,142.333,165.952,18,253.846,18 c75.519,0,45.058,101.856-2.538,78.692c25.067,0,25.385-35.538,2.538-35.538c-36.808,0-26.019,109.154,76.154,109.154 s1276,0,1276,0V216H-4V142.333z"/>',
		);

		$ret['water-wave1'] = array(
		'name' => __( 'Water Wave (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M740,60c0-16.3,18-8,18-8s-6-14-26-14c-29.5,0-48.1,45.4-99.1,46C613.2,83.7,582,76,582,60
c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h318C772.3,84,740,76.3,740,60z"/>
<path class="gambit_sep_decor1" d="M422,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160C454.3,84,422,76.3,422,60z"
/>
<path class="gambit_sep_decor1" d="M102,60c0-16.3,18-8,18-8s-6-14-26-14C64.3,38,45.7,84-6,84h160C134.3,84,102,76.3,102,60z"/>
<path class="gambit_sep_decor1" d="M900,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160C932.3,84,900,76.3,900,60z"
/>
<path class="gambit_sep_decor1" d="M262,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160C294.3,84,262,76.3,262,60z"
/>
<path class="gambit_sep_decor1" d="M1540,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160
C1572.3,84,1540,76.3,1540,60z"/>
<path class="gambit_sep_decor1" d="M1380,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160
C1412.3,84,1380,76.3,1380,60z"/>
<path class="gambit_sep_decor1" d="M1060,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160
C1092.3,84,1060,76.3,1060,60z"/>
<path class="gambit_sep_decor1" d="M1700,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160
C1732.3,84,1700,76.3,1700,60z"/>
<path class="gambit_sep_decor1" d="M1220,60c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46h160
C1252.3,84,1220,76.3,1220,60z"/>
<path class="gambit_sep_decor2" d="M1679,72c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14
c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24
c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46
c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14
c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.5,0-48.1,45.4-99.1,46C540.2,71.7,509,64,509,48
c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46
c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14c-29.7,0-48.3,46-100,46c-19.7,0-52-7.7-52-24c0-16.3,18-8,18-8s-6-14-26-14
C-8.7,26-27.3,72-79,72v18h1758V72z"/>
<path class="gambit_sep_main" d="M1678,80c-0.5,0-1,0-1.6,0c-33.5-0.1-58.4-15.8-58.4-34c0-9.3,8-12,8-12
s-3.4-2-8-2c-25.5,0.5-45.9,47.5-101.1,48c-32.7-0.6-56.9-16.1-56.9-34c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48
c-33.5-0.1-58.4-15.8-58.4-34c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48c-33.5-0.1-58.4-15.8-58.4-34c0-9.3,8-12,8-12
s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48C1005,79.9,980,64.2,980,46c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48
C845,79.9,820,64.2,820,46c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48C685,79.9,660,64.2,660,46c0-9.3,8-12,8-12
s-3.4-2-8-2c-25.5,0.5-45.9,47.5-101.1,48C526.2,79.4,502,63.9,502,46c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48
C367,79.9,342,64.2,342,46c0-9.3,8-12,8-12s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48C207,79.9,182,64.2,182,46c0-9.3,8-12,8-12
s-3.4-2-8-2c-25.6,0.5-46,47.7-101.6,48C47,79.9,22,64.2,22,46c0-9.3,8-12,8-12s-3.4-2-8-2C-3.6,32.5-24.1,80-80,80v206h1758V80z"
/>',
		);

		$ret['water-wave2'] = array(
		'name' => __( 'Water Wave (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1680,42.638c-4.701,3.724-10.081,8.336-18.769,8.336 c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1649.949,38,1644.308,38 c-8.317,0-13.57,12.816-27.944,12.971c-5.569-0.076-14.364-2.241-14.364-6.766c0-4.607,5.077-2.256,5.077-2.256 S1605.385,38,1599.744,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S1560.256,38,1554.615,38c-8.368,0-13.633,12.974-28.205,12.974 c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1515.128,38,1509.487,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1470,38,1464.359,38 c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S1424.872,38,1419.231,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S1379.744,38,1374.103,38c-8.368,0-13.632,12.974-28.205,12.974 c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1334.615,38,1328.974,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S1289.487,38,1283.846,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S1244.359,38,1238.718,38c-8.368,0-13.633,12.974-28.205,12.974 c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1199.231,38,1193.59,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S1154.103,38,1148.462,38c-8.317,0-13.57,12.816-27.944,12.971c-5.569-0.076-14.364-2.241-14.364-6.766 c0-4.607,5.077-2.256,5.077-2.256S1109.538,38,1103.897,38c-8.368,0-13.633,12.974-28.205,12.974 c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S1064.41,38,1058.769,38 c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S1019.282,38,1013.641,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S974.154,38,968.513,38c-8.244,0-13.482,12.584-27.57,12.957 c-5.58-0.18-13.917-2.345-13.917-6.752c0-4.607,5.077-2.256,5.077-2.256S930.41,38,924.769,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S885.282,38,879.641,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S840.154,38,834.513,38 c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S795.026,38,789.385,38 c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S749.897,38,744.256,38 c-8.367,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S704.769,38,699.128,38 c-8.367,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256S659.641,38,654,38 c-8.317,0-13.571,12.816-27.944,12.971c-5.569-0.076-14.364-2.241-14.364-6.766c0-4.607,5.077-2.256,5.077-2.256 S615.077,38,609.436,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S569.949,38,564.308,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S524.82,38,519.179,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S479.692,38,474.051,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S434.564,38,428.923,38c-8.367,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S389.436,38,383.795,38c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S344.308,38,338.667,38c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S299.179,38,293.538,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S254.051,38,248.41,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S208.923,38,203.282,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769c0-4.607,5.077-2.256,5.077-2.256 S163.795,38,158.154,38c-8.317,0-13.57,12.816-27.944,12.971c-5.569-0.076-14.364-2.241-14.364-6.766 c0-4.607,5.077-2.256,5.077-2.256S119.231,38,113.59,38c-8.368,0-13.632,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S74.103,38,68.462,38c-8.368,0-13.633,12.974-28.205,12.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S28.974,38,23.333,38C14.966,38,9.701,50.974-4.872,50.974c-5.547,0-14.667-2.162-14.667-6.769 c0-4.607,5.077-2.256,5.077-2.256S-16.154,38-21.795,38C-30.162,38-35.427,50.974-50,50.974V78h1730V42.638z"/>
<path class="gambit_sep_decor2" d="M1585.385,54.154c0-7.538,8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692S1443.231,44,1434,44 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462 c-13.61,0-22.206,20.972-45.727,21.225c-9.113-0.124-23.504-3.667-23.504-11.071c0-7.538,8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077S930,50.462,930,50.462 S927.231,44,918,44c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462C830.462,44,821.846,65.231,798,65.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462C756.615,44,748,65.231,724.154,65.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 S558,44,548.769,44c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077s8.308-3.692,8.308-3.692 s-2.769-6.462-12-6.462c-13.61,0-22.206,20.972-45.726,21.225C272.391,65.101,258,61.558,258,54.154 c0-7.538,8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462C240.615,44,232,65.231,208.154,65.231c-9.077,0-24-3.539-24-11.077 s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077 s8.308-3.692,8.308-3.692s-2.769-6.462-12-6.462c-13.692,0-22.308,21.231-46.154,21.231c-9.077,0-24-3.539-24-11.077 s8.308-3.692,8.308-3.692S42,44,32.769,44c-13.692,0-22.308,21.231-46.154,21.231V80h1622.769V65.231 C1600.308,65.231,1585.385,61.692,1585.385,54.154z"/>
<path class="gambit_sep_main" d="M1679,76c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14 c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46 c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24 c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14 c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46 c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14c-29.488,0-48.113,45.439-99.074,45.987C540.18,75.718,509,68.042,509,52 c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14 c-29.667,0-48.333,46-100,46c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14c-29.667,0-48.333,46-100,46 c-19.667,0-52-7.667-52-24c0-16.333,18-8,18-8s-6-14-26-14C-8.667,30-27.333,76-79,76v32h1758V76z"/>',
		);

		$ret['water1'] = array(
		'name' => __( 'Water (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1544,62c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62C31.3,62,8,47.5-2,26.6v12C8,59.5,31.3,74,56,74c34.2,0,62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62c34.2,0,62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62c24.7,0,48-14.5,58-35.4v-12C1592,47.5,1568.7,62,1544,62z"/>
<path class="gambit_sep_decor2" d="M1544,74c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62C31.3,74,8,59.5-2,38.6v12.2C8,71.7,31.3,86.2,56,86.2c34.2,0,62-27.8,62-62c0,34.2,27.8,62,62,62
s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62c34.2,0,62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62s62-27.8,62-62
c0,34.2,27.8,62,62,62s62-27.8,62-62c0,34.2,27.8,62,62,62c24.7,0,48-14.5,58-35.4V38.6C1592,59.5,1568.7,74,1544,74z"/>
<path class="gambit_sep_main" d="M1544,86.2c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62
s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62c-34.2,0-62-27.8-62-62c0,34.2-27.8,62-62,62
s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62c0,34.2-27.8,62-62,62s-62-27.8-62-62
c0,34.2-27.8,62-62,62c-24.7,0-48-14.5-58-35.4V227h1604V50.8C1592,71.7,1568.7,86.2,1544,86.2z"/>',
		);

		$ret['water2'] = array(
		'name' => __( 'Water (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1639.17,72.963c-37.195,0-67.348-16.829-67.348-37.588 c0,20.759-30.152,37.588-67.348,37.588s-67.348-16.829-67.348-37.588c0,20.759-30.152,37.588-67.347,37.588 s-67.348-16.829-67.348-37.588c0,20.759-30.152,37.588-67.348,37.588c-37.195,0-67.347-16.829-67.347-37.588 c0,20.759-30.152,37.588-67.348,37.588c-37.195,0-67.348-16.829-67.348-37.588c0,20.759-30.153,37.588-67.347,37.588 c-37.195,0-67.348-16.829-67.348-37.588c0,20.759-30.152,37.588-67.347,37.588s-67.348-16.829-67.348-37.588 c0,20.759-30.152,37.588-67.347,37.588c-37.195,0-67.348-16.829-67.348-37.588c0,20.759-30.152,37.588-67.347,37.588 c-37.195,0-67.348-16.829-67.348-37.588c0,20.759-30.152,37.588-67.347,37.588s-67.348-16.829-67.348-37.588 c0,20.759-30.153,37.588-67.348,37.588s-67.348-16.829-67.348-37.588c0,20.759-30.153,37.588-67.348,37.588 S90.177,56.134,90.177,35.375c0,20.759-30.153,37.588-67.347,37.588c-26.841,0-50.008-8.765-60.83-21.444V96h1738V51.518 C1689.178,64.198,1666.01,72.963,1639.17,72.963z"/>
<path class="gambit_sep_decor2" d="M1793.87,79.798c-19.646,0-35.573-10.375-35.573-23.173 c0,12.798-15.926,23.173-35.573,23.173s-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173 s-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173c-19.646,0-35.572-10.375-35.572-23.173 c0,12.798-15.926,23.173-35.573,23.173c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173 s-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173s-35.573-10.375-35.573-23.173 c0,12.798-15.926,23.173-35.573,23.173s-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.573,23.173 s-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173c-19.646,0-35.573-10.375-35.573-23.173 c0,12.798-15.926,23.173-35.572,23.173c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173 c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173c-14.177,0-26.414-5.404-32.13-13.22 c-5.716,7.817-17.953,13.22-32.13,13.22c-19.646,0-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173 s-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.573,23.173c-19.646,0-35.572-10.375-35.572-23.173 c0,12.798-15.926,23.173-35.573,23.173s-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.573,23.173 c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173c-19.646,0-35.573-10.375-35.573-23.173 c0,12.798-15.926,23.173-35.573,23.173s-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173 c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173c-19.646,0-35.573-10.375-35.573-23.173 c0,12.798-15.926,23.173-35.572,23.173c-19.646,0-35.573-10.375-35.573-23.173c0,12.798-15.926,23.173-35.572,23.173 c-19.646,0-35.572-10.375-35.572-23.173c0,12.798-15.926,23.173-35.572,23.173c-19.646,0-35.572-10.375-35.572-23.173 c0,12.798-15.926,23.173-35.572,23.173c-14.177,0-26.414-5.404-32.13-13.22V94h918h918V66.577 C1820.284,74.394,1808.047,79.798,1793.87,79.798z"/>
<path class="gambit_sep_main" d="M1544,86.167c-34.242,0-62-27.758-62-62c0,34.242-27.758,62-62,62 s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62 c-34.242,0-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62 c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62 c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62s-62-27.758-62-62c0,34.242-27.758,62-62,62 c-24.709,0-48.037-14.458-58-35.372v73.372h1604V50.794C1592.037,71.709,1568.709,86.167,1544,86.167z"/>',
		);

		$ret['wave-bend'] = array(
		'name' => __( 'Wave Bend', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M-285.2,195.8c684.4-108.4,1381.6-108.4,2066,0c2.7-17.4,5.3-34.9,8-52.3
c0,0.1,0-0.3-88.2-13.4c-88.2-12.4-81.1-70.8-170.4-81.6c-89.3-10.1-96.2,48.3-184.6,40c-88.4-7.6-84.2-66.3-174.3-72.4
c-90.1-5.3-93.5,53.4-182,49.8C901,63.1,901.6,4.2,811.6,3c-90.1-0.5-90.7,58.3-179,59.5c-88.3,1.9-91.1-56.9-180.9-53.3
c-89.8,4.3-87,63.1-175.6,69c-88.6,6.7-94.2-51.9-183.7-43.5C3,43.9,8.7,102.5-79.5,113.1c-88.1,11.4-96.5-46.8-186-33.5
c-14.5,2.2-26.4,5.7-36.5,9.9C-296.4,124.9-290.8,160.3-285.2,195.8z"/>
<path class="gambit_sep_decor2" d="M1649.9,118.7c0,0,0,0-19.6-2.4c-19.6-2.4-18.2-15.3-37.8-17.6
c-19.6-2.3-21.3,10.6-40.9,8.4c-19.6-2.2-18.3-15.1-38-17.2c-19.8-2.1-21.2,10.9-40.7,8.9c-19.6-1.9-18.5-14.9-38.2-16.7
c-19.7-1.8-21.1,11.1-40.6,9.4c-19.5-1.7-18.7-14.7-38.4-16.3c-19.7-1.6-20.8,11.4-40.5,9.9c-19.7-1.5-18.9-14.4-38.6-15.8
c-19.7-1.3-20.7,11.6-40.4,10.4c-19.6-1.2-18.9-14.2-38.7-15.4c-19.8-1.1-20.5,11.9-40.2,10.8c-19.7-1-19.1-14-38.9-14.9
c-19.8-0.9-20.2,12-40.1,11.2c0,0-14.2-0.4-22.3-0.7c-19.7-0.7-19.4-13.7-39.1-14.3c-19.7-0.6-20.3,12.4-39.9,11.9
c-19.7-0.5-19.5-13.5-39.3-13.8c-19.8-0.3-20.1,12.7-39.8,12.4c-19.6-0.2-19.7-13.2-39.5-13.4c-19.8-0.1-20,12.9-39.6,12.9
c-19.6,0-19.8-13-39.6-12.9c-19.8,0.1-19.8,13.1-39.5,13.3c-19.7,0.2-20-12.8-39.8-12.4c-19.7,0.4-19.7,13.4-39.3,13.8
c-19.7,0.5-20.1-12.5-39.9-12c-19.8,0.6-19.4,13.6-39.1,14.3c-19.8,0.7-20.3-12.3-40.1-11.5c-19.8,0.8-19.1,13.7-39,14.6
c0,0-12.1,0.7-25.7,1.4c-19.7,1-20.5-12-40.2-10.9c-19.7,1.1-19.1,14.1-38.8,15.3c-19.6,1.3-20.6-11.7-40.4-10.4
c-19.8,1.4-19,14.4-38.6,15.8c-19.6,1.5-20.7-11.5-40.5-9.9c-19.8,1.6-18.9,14.6-38.4,16.3c-19.5,1.7-20.9-11.2-40.6-9.4
c-19.7,1.8-18.6,14.8-38.2,16.7c-19.6,2-21.1-11-40.7-8.9c-19.7,2.1-18.4,15-38,17.2c-19.6,2.2-21.1-10.7-40.9-8.4
c-19.7,2.3-18.2,15.2-37.8,17.6c-19.7,2.4-21.3-10.5-41-8c-19.7,2.6-17.9,15.3-37.6,18c-2.2,0.3-4.4,0.7-6.5,1
c0.5,3.9,4.9,34.1,5.4,38c573.5-77.9,1152.2-76.3,1726-4C1650.5,157.1,1649.4,122.6,1649.9,118.7z"/>
<path class="gambit_sep_main" d="M-70.2,140c60.6-7.8,55.5-47.1,116.3-54.2c60.8-6.7,65,33,125.5,27.1
c60.5-5.6,57-45.4,118-50.3c61.1-4.5,64,35.4,124.3,31.7c60.3-3.4,58.9-43.3,119.7-45.9c60.8-2.3,62.5,37.7,123,36.2
c60.4-1.2,60.3-41.2,121.2-41.6c61-0.1,61.4,40,121.5,40.7c60.1,1,61.6-38.9,122.7-37.1c61,2.2,59.8,42.2,120,45.1
c60.2,3.2,62.9-36.7,124-32.6c61.1,4.4,58.1,44.3,118.3,49.4c60.1,5.4,64.5-34.3,125.2-28.1c60.6,6.6,56.4,46.4,116.5,53.7
c60.1,7.6,60.1,7.8,60.1,7.8c-0.3,2.7-8.7,236.5-6,236.6c-589.7-26.8-1179.4-3.9-1768,10c2.7-0.1-1.9-242.8-2.3-245.4
C-83.6,142-76.9,141-70.2,140z"/>',
		);

		$ret['wave-side1'] = array(
		'name' => __( 'Wave Side (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_main" d="M-8,95.3C-8,95.3,189,2,398,2s604,184.7,800,184.7s412-91.4,412-91.4V271H-8V95.3
z"/>
<path class="gambit_sep_decor1" d="M802.9,94.3C653.5,48.2,502.5,2,398,2C189,2-8,95.3-8,95.3v11.4
c0,0,197-93.3,406-93.3C502.5,13.4,653.5,53.9,802.9,94.3z"/>
<path class="gambit_sep_decor2" d="M1610,95.3c0,0-216,80-412,80c-98,0-245.8-40.5-395.1-80.9
c149.4,46.2,297.1,92.3,395.1,92.3C1394,186.7,1610,95.3,1610,95.3z"/>',
		);

		$ret['wave-side2'] = array(
		'name' => __( 'Wave Side (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 200,
		'svg' => '
<path class="gambit_sep_decor1" d="M-8,89.2C-8,89.2,189,3,398,3s604,170.7,800,170.7c0,0-184,8.3-348-38.7
S-8,108-8,108V89.2z"/>
<path class="gambit_sep_decor2" d="M-8,89.2c0,0,197-75.7,406-75.7s604,160.1,800,160.1c0,0-120,10.3-319-37.7
S-8,108-8,108V89.2z"/>
<path class="gambit_sep_main" d="M-8,89.2c0,0,197-65.1,406-65.1s604,149.6,800,149.6s412-84.5,412-84.5V287H-8
V89.2z"/>',
		);

		$ret['wave1'] = array(
		'name' => __( 'Wave (Decor #1)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M-40,71.627C20.307,71.627,20.058,32,80,32s60.003,40,120,40s59.948-40,120-40s60.313,40,120,40s60.258-40,120-40s60.202,40,120,40s60.147-40,120-40s60.513,40,120,40s60.036-40,120-40c59.964,0,60.402,40,120,40s59.925-40,120-40s60.291,40,120,40s60.235-40,120-40s60.18,40,120,40s59.82,0,59.82,0l0.18,26H-60V72L-40,71.627z"/>
<path class="gambit_sep_decor2" d="M-40,83.627C20.307,83.627,20.058,44,80,44s60.003,40,120,40s59.948-40,120-40s60.313,40,120,40s60.258-40,120-40s60.202,40,120,40s60.147-40,120-40s60.513,40,120,40s60.036-40,120-40c59.964,0,60.402,40,120,40s59.925-40,120-40s60.291,40,120,40s60.235-40,120-40s60.18,40,120,40s59.82,0,59.82,0l0.18,14H-60V84L-40,83.627z"/>
<path class="gambit_sep_main" d="M-40,95.627C20.307,95.627,20.058,56,80,56s60.003,40,120,40s59.948-40,120-40s60.313,40,120,40s60.258-40,120-40s60.202,40,120,40s60.147-40,120-40s60.513,40,120,40s60.036-40,120-40c59.964,0,60.402,40,120,40s59.925-40,120-40s60.291,40,120,40s60.235-40,120-40s60.18,40,120,40s59.82,0,59.82,0l0.18,138H-60V96L-40,95.627z"/>',
		);

		$ret['wave2'] = array(
		'name' => __( 'Wave (Decor #2)', GAMBIT_ROW_SEPARATORS ),
		'width' => 1600,
		'height' => 100,
		'svg' => '
<path class="gambit_sep_decor1" d="M1040,56c0.5,0,1,0,1.6,0c-16.6-8.9-36.4-15.7-66.4-15.7c-56,0-76.8,23.7-106.9,41C881.1,89.3,895.6,96,920,96
C979.5,96,980,56,1040,56z"/>
<path class="gambit_sep_decor1" d="M1699.8,96l0,10H1946l-0.3-6.9c0,0,0,0-88,0s-88.6-58.8-176.5-58.8c-51.4,0-73,20.1-99.6,36.8
c14.5,9.6,29.6,18.9,58.4,18.9C1699.8,96,1699.8,96,1699.8,96z"/>
<path class="gambit_sep_decor1" d="M1400,96c19.5,0,32.7-4.3,43.7-10c-35.2-17.3-54.1-45.7-115.5-45.7c-32.3,0-52.8,7.9-70.2,17.8
c6.4-1.3,13.6-2.1,22-2.1C1340.1,56,1340.3,96,1400,96z"/>
<path class="gambit_sep_decor1" d="M320,56c6.6,0,12.4,0.5,17.7,1.3c-17-9.6-37.3-17-68.5-17c-60.4,0-79.5,27.8-114,45.2
c11.2,6,24.6,10.5,44.8,10.5C260,96,259.9,56,320,56z"/>
<path class="gambit_sep_decor1" d="M680,96c23.7,0,38.1-6.3,50.5-13.9C699.6,64.8,679,40.3,622.2,40.3c-30,0-49.8,6.8-66.3,15.8
c1.3,0,2.7-0.1,4.1-0.1C619.7,56,620.2,96,680,96z"/>
<path class="gambit_sep_decor1" d="M-40,95.6c28.3,0,43.3-8.7,57.4-18C-9.6,60.8-31,40.2-83.2,40.2c-14.3,0-26.3,1.6-36.8,4.2V106h60V96L-40,95.6
z"/>
<path class="gambit_sep_decor2" d="M504,73.4c-2.6-0.8-5.7-1.4-9.6-1.4c-19.4,0-19.6,13-39,13c-19.4,0-19.5-13-39-13c-14,0-18,6.7-26.3,10.4
C402.4,89.9,416.7,96,440,96C472.5,96,487.5,84.2,504,73.4z"/>
<path class="gambit_sep_decor2" d="M1205.4,85c-0.2,0-0.4,0-0.6,0c-19.5,0-19.5-13-39-13s-19.4,12.9-39,12.9c0,0-5.9,0-12.3,0.1
c11.4,6.3,24.9,11,45.5,11C1180.6,96,1194.1,91.2,1205.4,85z"/>
<path class="gambit_sep_decor2" d="M1447.4,83.9c-2.4,0.7-5.2,1.1-8.6,1.1c-19.3,0-19.6-13-39-13s-19.6,13-39,13c-3,0-5.5-0.3-7.7-0.8
c11.6,6.6,25.4,11.8,46.9,11.8C1421.8,96,1435.7,90.7,1447.4,83.9z"/>
<path class="gambit_sep_decor2" d="M985.8,72c-17.6,0.8-18.3,13-37,13c-19.4,0-19.5-13-39-13c-18.2,0-19.6,11.4-35.5,12.8
c11.4,6.3,25,11.2,45.7,11.2C953.7,96,968.5,83.2,985.8,72z"/>
<path class="gambit_sep_decor2" d="M743.8,73.5c-10.3,3.4-13.6,11.5-29,11.5c-19.4,0-19.5-13-39-13s-19.5,13-39,13c-0.9,0-1.7,0-2.5-0.1
c11.4,6.3,25,11.1,45.7,11.1C712.4,96,727.3,84.2,743.8,73.5z"/>
<path class="gambit_sep_decor2" d="M265.5,72.3c-1.5-0.2-3.2-0.3-5.1-0.3c-19.4,0-19.6,13-39,13c-19.4,0-19.6-13-39-13
c-15.9,0-18.9,8.7-30.1,11.9C164.1,90.6,178,96,200,96C233.7,96,248.4,83.4,265.5,72.3z"/>
<path class="gambit_sep_decor2" d="M1692.3,96V85c0,0,0,0-19.5,0s-19.6-13-39-13s-19.6,13-39,13c-0.1,0-0.2,0-0.4,0c11.4,6.2,24.9,11,45.6,11
C1669.9,96,1684.8,96,1692.3,96z"/>
<path class="gambit_sep_decor2" d="M25.5,72C6,72,6.1,84.9-13.5,84.9L-20,85v8.9C0.7,90.1,12.6,80.6,25.9,72C25.8,72,25.7,72,25.5,72z"/>
<path class="gambit_sep_main" d="M-40,95.6C20.3,95.6,20.1,56,80,56s60,40,120,40s59.9-40,120-40s60.3,40,120,40s60.3-40,120-40
s60.2,40,120,40s60.1-40,120-40s60.5,40,120,40s60-40,120-40s60.4,40,120,40s59.9-40,120-40s60.3,40,120,40s60.2-40,120-40
s60.2,40,120,40s59.8,0,59.8,0l0.2,143H-60V96L-40,95.6z"/>
',
		);
		// DECOR SVG CODE END - DO NOT TOUCH THIS, GENERATED BY _DEV_processSvg.php!
		foreach ( $ret as $key => $data ) {
			// $ret[ $key ]['svg'] = preg_replace( "/(id=('|\")[^'\"]+('|\"))/", "", $data['svg'] );
			$ret[ $key ]['svg'] = preg_replace( "/(class=('|\")gambit_sep_main('|\"))/", '$1 style="{main}"', $ret[ $key ]['svg'] );
			$ret[ $key ]['svg'] = preg_replace( "/(class=('|\")gambit_sep_decor1('|\"))/", '$1 style="{decor1}"', $ret[ $key ]['svg'] );
			$ret[ $key ]['svg'] = preg_replace( "/(class=('|\")gambit_sep_decor2('|\"))/", '$1 style="{decor2}"', $ret[ $key ]['svg'] );
		}

		$ret['custom'] = array(
			'name' => __( 'Custom SVG', GAMBIT_ROW_SEPARATORS ),
			'width' => 1600,
			'height' => 200,
			'svg' => '',
		);

		return $ret;
	}
}
