// tipsy, facebook style tooltips for jquery

// version 1.0.0a

// (c) 2008-2010 jason frame [jason@onehackoranother.com]

// released under the MIT license

var user_action = "";

(function ($) {


    function maybeCall(thing, ctx) {

        return (typeof thing == 'function') ? (thing.call(ctx)) : thing;

    };


    function isElementInDOM(ele) {

        while (ele = ele.parentNode) {

            if (ele == document) return true;

        }

        return false;

    };


    function Tipsy(element, options) {

        this.$element = $(element);

        this.options = options;

        this.enabled = true;

        this.fixTitle();

    };


    Tipsy.prototype = {

        show: function () {

            var title = this.getTitle();

            if (title && this.enabled) {

                var $tip = this.tip();


                $tip.find('.tipsy-inner')[this.options.html ? 'html' : 'text'](title);

                $tip[0].className = 'tipsy'; // reset classname in case of dynamic gravity

                $tip.remove().css({top: 0, left: 0, visibility: 'hidden', display: 'block'}).prependTo(document.body);


                var pos = $.extend({}, this.$element.offset(), {

                    width: this.$element[0].offsetWidth,

                    height: this.$element[0].offsetHeight

                });


                var actualWidth = $tip[0].offsetWidth,

                    actualHeight = $tip[0].offsetHeight,

                    gravity = maybeCall(this.options.gravity, this.$element[0]);


                var tp;

                switch (gravity.charAt(0)) {

                    case 'n':

                        tp = {
                            top: pos.top + pos.height + this.options.offset,
                            left: pos.left + pos.width / 2 - actualWidth / 2
                        };

                        break;

                    case 's':

                        tp = {
                            top: pos.top - actualHeight - this.options.offset,
                            left: pos.left + pos.width / 2 - actualWidth / 2
                        };

                        break;

                    case 'e':

                        tp = {
                            top: pos.top + pos.height / 2 - actualHeight / 2,
                            left: pos.left - actualWidth - this.options.offset
                        };

                        break;

                    case 'w':

                        tp = {
                            top: pos.top + pos.height / 2 - actualHeight / 2,
                            left: pos.left + pos.width + this.options.offset
                        };

                        break;

                }


                if (gravity.length == 2) {

                    if (gravity.charAt(1) == 'w') {

                        tp.left = pos.left + pos.width / 2 - 15;

                    } else {

                        tp.left = pos.left + pos.width / 2 - actualWidth + 15;

                    }

                }


                $tip.css(tp).addClass('tipsy-' + gravity);

                $tip.find('.tipsy-arrow')[0].className = 'tipsy-arrow tipsy-arrow-' + gravity.charAt(0);

                if (this.options.className) {

                    $tip.addClass(maybeCall(this.options.className, this.$element[0]));

                }


                if (this.options.fade) {

                    $tip.stop().css({
                        opacity: 0,
                        display: 'block',
                        visibility: 'visible'
                    }).animate({opacity: this.options.opacity});

                } else {

                    $tip.css({visibility: 'visible', opacity: this.options.opacity});

                }

            }

        },


        hide: function () {

            if (this.options.fade) {

                this.tip().stop().fadeOut(function () {
                    $(this).remove();
                });

            } else {

                this.tip().remove();

            }

        },


        fixTitle: function () {

            var $e = this.$element;

            if ($e.attr('title') || typeof($e.attr('original-title')) != 'string') {

                $e.attr('original-title', $e.attr('title') || '').removeAttr('title');

            }

        },


        getTitle: function () {

            var title, $e = this.$element, o = this.options;

            this.fixTitle();

            var title, o = this.options;

            if (typeof o.title == 'string') {

                title = $e.attr(o.title == 'title' ? 'original-title' : o.title);

            } else if (typeof o.title == 'function') {

                title = o.title.call($e[0]);

            }

            title = ('' + title).replace(/(^\s*|\s*$)/, "");

            return title || o.fallback;

        },


        tip: function () {

            if (!this.$tip) {

                this.$tip = $('<div class="tipsy"></div>').html('<div class="tipsy-arrow"></div><div class="tipsy-inner"></div>');

                this.$tip.data('tipsy-pointee', this.$element[0]);

            }

            return this.$tip;

        },


        validate: function () {

            if (!this.$element[0].parentNode) {

                this.hide();

                this.$element = null;

                this.options = null;

            }

        },


        enable: function () {
            this.enabled = true;
        },

        disable: function () {
            this.enabled = false;
        },

        toggleEnabled: function () {
            this.enabled = !this.enabled;
        }

    };


    $.fn.tipsy = function (options) {


        if (options === true) {

            return this.data('tipsy');

        } else if (typeof options == 'string') {

            var tipsy = this.data('tipsy');

            if (tipsy) tipsy[options]();

            return this;

        }


        options = $.extend({}, $.fn.tipsy.defaults, options);


        function get(ele) {

            var tipsy = $.data(ele, 'tipsy');

            if (!tipsy) {

                tipsy = new Tipsy(ele, $.fn.tipsy.elementOptions(ele, options));

                $.data(ele, 'tipsy', tipsy);

            }

            return tipsy;

        }


        function enter() {

            var tipsy = get(this);

            tipsy.hoverState = 'in';

            if (options.delayIn == 0) {

                tipsy.show();

            } else {

                tipsy.fixTitle();

                setTimeout(function () {
                    if (tipsy.hoverState == 'in') tipsy.show();
                }, options.delayIn);

            }

        };


        function leave() {

            var tipsy = get(this);

            tipsy.hoverState = 'out';

            if (options.delayOut == 0) {

                tipsy.hide();

            } else {

                setTimeout(function () {
                    if (tipsy.hoverState == 'out') tipsy.hide();
                }, options.delayOut);

            }

        };


        if (!options.live) this.each(function () {
            get(this);
        });


        if (options.trigger != 'manual') {

            var binder = options.live ? 'live' : 'bind',

                eventIn = options.trigger == 'hover' ? 'mouseenter' : 'focus',

                eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur';

            this[binder](eventIn, enter)[binder](eventOut, leave);

        }


        return this;


    };


    $.fn.tipsy.defaults = {

        className: null,

        delayIn: 0,

        delayOut: 0,

        fade: false,

        fallback: '',

        gravity: 'n',

        html: false,

        live: false,

        offset: 0,

        opacity: 0.8,

        title: 'title',

        trigger: 'hover'

    };


    $.fn.tipsy.revalidate = function () {

        $('.tipsy').each(function () {

            var pointee = $.data(this, 'tipsy-pointee');

            if (!pointee || !isElementInDOM(pointee)) {

                $(this).remove();

            }

        });

    };


    // Overwrite this method to provide options on a per-element basis.

    // For example, you could store the gravity in a 'tipsy-gravity' attribute:

    // return $.extend({}, options, {gravity: $(ele).attr('tipsy-gravity') || 'n' });

    // (remember - do not modify 'options' in place!)

    $.fn.tipsy.elementOptions = function (ele, options) {

        return $.metadata ? $.extend({}, options, $(ele).metadata()) : options;

    };


    $.fn.tipsy.autoNS = function () {

        return $(this).offset().top > ($(document).scrollTop() + $(window).height() / 2) ? 's' : 'n';

    };


    $.fn.tipsy.autoWE = function () {

        return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'e' : 'w';

    };


    /**

     * yields a closure of the supplied parameters, producing a function that takes

     * no arguments and is suitable for use as an autogravity function like so:

     *

     * @param margin (int) - distance from the viewable region edge that an

     *        element should be before setting its tooltip's gravity to be away

     *        from that edge.

     * @param prefer (string, e.g. 'n', 'sw', 'w') - the direction to prefer

     *        if there are no viewable region edges effecting the tooltip's

     *        gravity. It will try to vary from this minimally, for example,

     *        if 'sw' is preferred and an element is near the right viewable

     *        region edge, but not the top edge, it will set the gravity for

     *        that element's tooltip to be 'se', preserving the southern

     *        component.

     */

    $.fn.tipsy.autoBounds = function (margin, prefer) {

        return function () {

            var dir = {ns: prefer[0], ew: (prefer.length > 1 ? prefer[1] : false)},

                boundTop = $(document).scrollTop() + margin,

                boundLeft = $(document).scrollLeft() + margin,

                $this = $(this);


            if ($this.offset().top < boundTop) dir.ns = 'n';

            if ($this.offset().left < boundLeft) dir.ew = 'w';

            if ($(window).width() + $(document).scrollLeft() - $this.offset().left < margin) dir.ew = 'e';

            if ($(window).height() + $(document).scrollTop() - $this.offset().top < margin) dir.ns = 's';


            return dir.ns + (dir.ew ? dir.ew : '');

        }

    };


})(jQuery);


/* Chosen v1.4.2 | (c) 2011-2015 by Harvest | MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md */

(function () {
    var a, AbstractChosen, Chosen, SelectParser, b, c = {}.hasOwnProperty, d = function (a, b) {
        function d() {
            this.constructor = a
        }

        for (var e in b)c.call(b, e) && (a[e] = b[e]);
        return d.prototype = b.prototype, a.prototype = new d, a.__super__ = b.prototype, a
    };
    SelectParser = function () {
        function SelectParser() {
            this.options_index = 0, this.parsed = []
        }

        return SelectParser.prototype.add_node = function (a) {
            return "OPTGROUP" === a.nodeName.toUpperCase() ? this.add_group(a) : this.add_option(a)
        }, SelectParser.prototype.add_group = function (a) {
            var b, c, d, e, f, g;
            for (b = this.parsed.length, this.parsed.push({
                array_index: b,
                group: !0,
                label: this.escapeExpression(a.label),
                title: a.title ? a.title : void 0,
                children: 0,
                disabled: a.disabled,
                classes: a.className
            }), f = a.childNodes, g = [], d = 0, e = f.length; e > d; d++)c = f[d], g.push(this.add_option(c, b, a.disabled));
            return g
        }, SelectParser.prototype.add_option = function (a, b, c) {
            return "OPTION" === a.nodeName.toUpperCase() ? ("" !== a.text ? (null != b && (this.parsed[b].children += 1), this.parsed.push({
                array_index: this.parsed.length,
                options_index: this.options_index,
                value: a.value,
                text: a.text,
                html: a.innerHTML,
                title: a.title ? a.title : void 0,
                selected: a.selected,
                disabled: c === !0 ? c : a.disabled,
                group_array_index: b,
                group_label: null != b ? this.parsed[b].label : null,
                classes: a.className,
                style: a.style.cssText
            })) : this.parsed.push({
                array_index: this.parsed.length,
                options_index: this.options_index,
                empty: !0
            }), this.options_index += 1) : void 0
        }, SelectParser.prototype.escapeExpression = function (a) {
            var b, c;
            return null == a || a === !1 ? "" : /[\&\<\>\"\'\`]/.test(a) ? (b = {
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#x27;",
                "`": "&#x60;"
            }, c = /&(?!\w+;)|[\<\>\"\'\`]/g, a.replace(c, function (a) {
                return b[a] || "&amp;"
            })) : a
        }, SelectParser
    }(), SelectParser.select_to_array = function (a) {
        var b, c, d, e, f;
        for (c = new SelectParser, f = a.childNodes, d = 0, e = f.length; e > d; d++)b = f[d], c.add_node(b);
        return c.parsed
    }, AbstractChosen = function () {
        function AbstractChosen(a, b) {
            this.form_field = a, this.options = null != b ? b : {}, AbstractChosen.browser_is_supported() && (this.is_multiple = this.form_field.multiple, this.set_default_text(), this.set_default_values(), this.setup(), this.set_up_html(), this.register_observers(), this.on_ready())
        }

        return AbstractChosen.prototype.set_default_values = function () {
            var a = this;
            return this.click_test_action = function (b) {
                return a.test_active_click(b)
            }, this.activate_action = function (b) {
                return a.activate_field(b)
            }, this.active_field = !1, this.mouse_on_container = !1, this.results_showing = !1, this.result_highlighted = null, this.allow_single_deselect = null != this.options.allow_single_deselect && null != this.form_field.options[0] && "" === this.form_field.options[0].text ? this.options.allow_single_deselect : !1, this.disable_search_threshold = this.options.disable_search_threshold || 0, this.disable_search = this.options.disable_search || !1, this.enable_split_word_search = null != this.options.enable_split_word_search ? this.options.enable_split_word_search : !0, this.group_search = null != this.options.group_search ? this.options.group_search : !0, this.search_contains = this.options.search_contains || !1, this.single_backstroke_delete = null != this.options.single_backstroke_delete ? this.options.single_backstroke_delete : !0, this.max_selected_options = this.options.max_selected_options || 1 / 0, this.inherit_select_classes = this.options.inherit_select_classes || !1, this.display_selected_options = null != this.options.display_selected_options ? this.options.display_selected_options : !0, this.display_disabled_options = null != this.options.display_disabled_options ? this.options.display_disabled_options : !0, this.include_group_label_in_selected = this.options.include_group_label_in_selected || !1
        }, AbstractChosen.prototype.set_default_text = function () {
            return this.default_text = this.form_field.getAttribute("data-placeholder") ? this.form_field.getAttribute("data-placeholder") : this.is_multiple ? this.options.placeholder_text_multiple || this.options.placeholder_text || AbstractChosen.default_multiple_text : this.options.placeholder_text_single || this.options.placeholder_text || AbstractChosen.default_single_text, this.results_none_found = this.form_field.getAttribute("data-no_results_text") || this.options.no_results_text || AbstractChosen.default_no_result_text
        }, AbstractChosen.prototype.choice_label = function (a) {
            return this.include_group_label_in_selected && null != a.group_label ? "<b class='group-name'>" + a.group_label + "</b>" + a.html : a.html
        }, AbstractChosen.prototype.mouse_enter = function () {
            return this.mouse_on_container = !0
        }, AbstractChosen.prototype.mouse_leave = function () {
            return this.mouse_on_container = !1
        }, AbstractChosen.prototype.input_focus = function () {
            var a = this;
            if (this.is_multiple) {
                if (!this.active_field)return setTimeout(function () {
                    return a.container_mousedown()
                }, 50)
            } else if (!this.active_field)return this.activate_field()
        }, AbstractChosen.prototype.input_blur = function () {
            var a = this;
            return this.mouse_on_container ? void 0 : (this.active_field = !1, setTimeout(function () {
                return a.blur_test()
            }, 100))
        }, AbstractChosen.prototype.results_option_build = function (a) {
            var b, c, d, e, f;
            for (b = "", f = this.results_data, d = 0, e = f.length; e > d; d++)c = f[d], b += c.group ? this.result_add_group(c) : this.result_add_option(c), (null != a ? a.first : void 0) && (c.selected && this.is_multiple ? this.choice_build(c) : c.selected && !this.is_multiple && this.single_set_selected_text(this.choice_label(c)));
            return b
        }, AbstractChosen.prototype.result_add_option = function (a) {
            var b, c;
            return a.search_match ? this.include_option_in_results(a) ? (b = [], a.disabled || a.selected && this.is_multiple || b.push("active-result"), !a.disabled || a.selected && this.is_multiple || b.push("disabled-result"), a.selected && b.push("result-selected"), null != a.group_array_index && b.push("group-option"), "" !== a.classes && b.push(a.classes), c = document.createElement("li"), c.className = b.join(" "), c.style.cssText = a.style, c.setAttribute("data-option-array-index", a.array_index), c.innerHTML = a.search_text, a.title && (c.title = a.title), this.outerHTML(c)) : "" : ""
        }, AbstractChosen.prototype.result_add_group = function (a) {
            var b, c;
            return a.search_match || a.group_match ? a.active_options > 0 ? (b = [], b.push("group-result"), a.classes && b.push(a.classes), c = document.createElement("li"), c.className = b.join(" "), c.innerHTML = a.search_text, a.title && (c.title = a.title), this.outerHTML(c)) : "" : ""
        }, AbstractChosen.prototype.results_update_field = function () {
            return this.set_default_text(), this.is_multiple || this.results_reset_cleanup(), this.result_clear_highlight(), this.results_build(), this.results_showing ? this.winnow_results() : void 0
        }, AbstractChosen.prototype.reset_single_select_options = function () {
            var a, b, c, d, e;
            for (d = this.results_data, e = [], b = 0, c = d.length; c > b; b++)a = d[b], a.selected ? e.push(a.selected = !1) : e.push(void 0);
            return e
        }, AbstractChosen.prototype.results_toggle = function () {
            return this.results_showing ? this.results_hide() : this.results_show()
        }, AbstractChosen.prototype.results_search = function () {
            return this.results_showing ? this.winnow_results() : this.results_show()
        }, AbstractChosen.prototype.winnow_results = function () {
            var a, b, c, d, e, f, g, h, i, j, k, l;
            for (this.no_results_clear(), d = 0, f = this.get_search_text(), a = f.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&"), i = new RegExp(a, "i"), c = this.get_search_regex(a), l = this.results_data, j = 0, k = l.length; k > j; j++)b = l[j], b.search_match = !1, e = null, this.include_option_in_results(b) && (b.group && (b.group_match = !1, b.active_options = 0), null != b.group_array_index && this.results_data[b.group_array_index] && (e = this.results_data[b.group_array_index], 0 === e.active_options && e.search_match && (d += 1), e.active_options += 1), b.search_text = b.group ? b.label : b.html, (!b.group || this.group_search) && (b.search_match = this.search_string_match(b.search_text, c), b.search_match && !b.group && (d += 1), b.search_match ? (f.length && (g = b.search_text.search(i), h = b.search_text.substr(0, g + f.length) + "</em>" + b.search_text.substr(g + f.length), b.search_text = h.substr(0, g) + "<em>" + h.substr(g)), null != e && (e.group_match = !0)) : null != b.group_array_index && this.results_data[b.group_array_index].search_match && (b.search_match = !0)));
            return this.result_clear_highlight(), 1 > d && f.length ? (this.update_results_content(""), this.no_results(f)) : (this.update_results_content(this.results_option_build()), this.winnow_results_set_highlight())
        }, AbstractChosen.prototype.get_search_regex = function (a) {
            var b;
            return b = this.search_contains ? "" : "^", new RegExp(b + a, "i")
        }, AbstractChosen.prototype.search_string_match = function (a, b) {
            var c, d, e, f;
            if (b.test(a))return !0;
            if (this.enable_split_word_search && (a.indexOf(" ") >= 0 || 0 === a.indexOf("[")) && (d = a.replace(/\[|\]/g, "").split(" "), d.length))for (e = 0, f = d.length; f > e; e++)if (c = d[e], b.test(c))return !0
        }, AbstractChosen.prototype.choices_count = function () {
            var a, b, c, d;
            if (null != this.selected_option_count)return this.selected_option_count;
            for (this.selected_option_count = 0, d = this.form_field.options, b = 0, c = d.length; c > b; b++)a = d[b], a.selected && (this.selected_option_count += 1);
            return this.selected_option_count
        }, AbstractChosen.prototype.choices_click = function (a) {
            return a.preventDefault(), this.results_showing || this.is_disabled ? void 0 : this.results_show()
        }, AbstractChosen.prototype.keyup_checker = function (a) {
            var b, c;
            switch (b = null != (c = a.which) ? c : a.keyCode, this.search_field_scale(), b) {
                case 8:
                    if (this.is_multiple && this.backstroke_length < 1 && this.choices_count() > 0)return this.keydown_backstroke();
                    if (!this.pending_backstroke)return this.result_clear_highlight(), this.results_search();
                    break;
                case 13:
                    if (a.preventDefault(), this.results_showing)return this.result_select(a);
                    break;
                case 27:
                    return this.results_showing && this.results_hide(), !0;
                case 9:
                case 38:
                case 40:
                case 16:
                case 91:
                case 17:
                    break;
                default:
                    return this.results_search()
            }
        }, AbstractChosen.prototype.clipboard_event_checker = function () {
            var a = this;
            return setTimeout(function () {
                return a.results_search()
            }, 50)
        }, AbstractChosen.prototype.container_width = function () {
            return null != this.options.width ? this.options.width : "" + this.form_field.offsetWidth + "px"
        }, AbstractChosen.prototype.include_option_in_results = function (a) {
            return this.is_multiple && !this.display_selected_options && a.selected ? !1 : !this.display_disabled_options && a.disabled ? !1 : a.empty ? !1 : !0
        }, AbstractChosen.prototype.search_results_touchstart = function (a) {
            return this.touch_started = !0, this.search_results_mouseover(a)
        }, AbstractChosen.prototype.search_results_touchmove = function (a) {
            return this.touch_started = !1, this.search_results_mouseout(a)
        }, AbstractChosen.prototype.search_results_touchend = function (a) {
            return this.touch_started ? this.search_results_mouseup(a) : void 0
        }, AbstractChosen.prototype.outerHTML = function (a) {
            var b;
            return a.outerHTML ? a.outerHTML : (b = document.createElement("div"), b.appendChild(a), b.innerHTML)
        }, AbstractChosen.browser_is_supported = function () {
            return "Microsoft Internet Explorer" === window.navigator.appName ? document.documentMode >= 8 : /iP(od|hone)/i.test(window.navigator.userAgent) ? !1 : /Android/i.test(window.navigator.userAgent) && /Mobile/i.test(window.navigator.userAgent) ? !1 : !0
        }, AbstractChosen.default_multiple_text = "Select Some Options", AbstractChosen.default_single_text = "Select an Option", AbstractChosen.default_no_result_text = "No results match", AbstractChosen
    }(), a = jQuery, a.fn.extend({
        chosen: function (b) {
            return AbstractChosen.browser_is_supported() ? this.each(function () {
                var c, d;
                c = a(this), d = c.data("chosen"), "destroy" === b && d instanceof Chosen ? d.destroy() : d instanceof Chosen || c.data("chosen", new Chosen(this, b))
            }) : this
        }
    }), Chosen = function (c) {
        function Chosen() {
            return b = Chosen.__super__.constructor.apply(this, arguments)
        }

        return d(Chosen, c), Chosen.prototype.setup = function () {
            return this.form_field_jq = a(this.form_field), this.current_selectedIndex = this.form_field.selectedIndex, this.is_rtl = this.form_field_jq.hasClass("chosen-rtl")
        }, Chosen.prototype.set_up_html = function () {
            var b, c;
            return b = ["chosen-container"], b.push("chosen-container-" + (this.is_multiple ? "multi" : "single")), this.inherit_select_classes && this.form_field.className && b.push(this.form_field.className), this.is_rtl && b.push("chosen-rtl"), c = {
                "class": b.join(" "),
                style: "width: " + this.container_width() + ";",
                title: this.form_field.title
            }, this.form_field.id.length && (c.id = this.form_field.id.replace(/[^\w]/g, "_") + "_chosen"), this.container = a("<div />", c), this.is_multiple ? this.container.html('<ul class="chosen-choices"><li class="search-field"><input type="text" value="' + this.default_text + '" class="default" autocomplete="off" style="width:25px;" /></li></ul><div class="chosen-drop"><ul class="chosen-results"></ul></div>') : this.container.html('<a class="chosen-single chosen-default" tabindex="-1"><span>' + this.default_text + '</span><div><b></b></div></a><div class="chosen-drop"><div class="chosen-search"><input type="text" autocomplete="off" /></div><ul class="chosen-results"></ul></div>'), this.form_field_jq.hide().after(this.container), this.dropdown = this.container.find("div.chosen-drop").first(), this.search_field = this.container.find("input").first(), this.search_results = this.container.find("ul.chosen-results").first(), this.search_field_scale(), this.search_no_results = this.container.find("li.no-results").first(), this.is_multiple ? (this.search_choices = this.container.find("ul.chosen-choices").first(), this.search_container = this.container.find("li.search-field").first()) : (this.search_container = this.container.find("div.chosen-search").first(), this.selected_item = this.container.find(".chosen-single").first()), this.results_build(), this.set_tab_index(), this.set_label_behavior()
        }, Chosen.prototype.on_ready = function () {
            return this.form_field_jq.trigger("chosen:ready", {chosen: this})
        }, Chosen.prototype.register_observers = function () {
            var a = this;
            return this.container.bind("touchstart.chosen", function (b) {
                return a.container_mousedown(b), b.preventDefault()
            }), this.container.bind("touchend.chosen", function (b) {
                return a.container_mouseup(b), b.preventDefault()
            }), this.container.bind("mousedown.chosen", function (b) {
                a.container_mousedown(b)
            }), this.container.bind("mouseup.chosen", function (b) {
                a.container_mouseup(b)
            }), this.container.bind("mouseenter.chosen", function (b) {
                a.mouse_enter(b)
            }), this.container.bind("mouseleave.chosen", function (b) {
                a.mouse_leave(b)
            }), this.search_results.bind("mouseup.chosen", function (b) {
                a.search_results_mouseup(b)
            }), this.search_results.bind("mouseover.chosen", function (b) {
                a.search_results_mouseover(b)
            }), this.search_results.bind("mouseout.chosen", function (b) {
                a.search_results_mouseout(b)
            }), this.search_results.bind("mousewheel.chosen DOMMouseScroll.chosen", function (b) {
                a.search_results_mousewheel(b)
            }), this.search_results.bind("touchstart.chosen", function (b) {
                a.search_results_touchstart(b)
            }), this.search_results.bind("touchmove.chosen", function (b) {
                a.search_results_touchmove(b)
            }), this.search_results.bind("touchend.chosen", function (b) {
                a.search_results_touchend(b)
            }), this.form_field_jq.bind("chosen:updated.chosen", function (b) {
                a.results_update_field(b)
            }), this.form_field_jq.bind("chosen:activate.chosen", function (b) {
                a.activate_field(b)
            }), this.form_field_jq.bind("chosen:open.chosen", function (b) {
                a.container_mousedown(b)
            }), this.form_field_jq.bind("chosen:close.chosen", function (b) {
                a.input_blur(b)
            }), this.search_field.bind("blur.chosen", function (b) {
                a.input_blur(b)
            }), this.search_field.bind("keyup.chosen", function (b) {
                a.keyup_checker(b)
            }), this.search_field.bind("keydown.chosen", function (b) {
                a.keydown_checker(b)
            }), this.search_field.bind("focus.chosen", function (b) {
                a.input_focus(b)
            }), this.search_field.bind("cut.chosen", function (b) {
                a.clipboard_event_checker(b)
            }), this.search_field.bind("paste.chosen", function (b) {
                a.clipboard_event_checker(b)
            }), this.is_multiple ? this.search_choices.bind("click.chosen", function (b) {
                a.choices_click(b)
            }) : this.container.bind("click.chosen", function (a) {
                a.preventDefault()
            })
        }, Chosen.prototype.destroy = function () {
            return a(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action), this.search_field[0].tabIndex && (this.form_field_jq[0].tabIndex = this.search_field[0].tabIndex), this.container.remove(), this.form_field_jq.removeData("chosen"), this.form_field_jq.show()
        }, Chosen.prototype.search_field_disabled = function () {
            return this.is_disabled = this.form_field_jq[0].disabled, this.is_disabled ? (this.container.addClass("chosen-disabled"), this.search_field[0].disabled = !0, this.is_multiple || this.selected_item.unbind("focus.chosen", this.activate_action), this.close_field()) : (this.container.removeClass("chosen-disabled"), this.search_field[0].disabled = !1, this.is_multiple ? void 0 : this.selected_item.bind("focus.chosen", this.activate_action))
        }, Chosen.prototype.container_mousedown = function (b) {
            return this.is_disabled || (b && "mousedown" === b.type && !this.results_showing && b.preventDefault(), null != b && a(b.target).hasClass("search-choice-close")) ? void 0 : (this.active_field ? this.is_multiple || !b || a(b.target)[0] !== this.selected_item[0] && !a(b.target).parents("a.chosen-single").length || (b.preventDefault(), this.results_toggle()) : (this.is_multiple && this.search_field.val(""), a(this.container[0].ownerDocument).bind("click.chosen", this.click_test_action), this.results_show()), this.activate_field())
        }, Chosen.prototype.container_mouseup = function (a) {
            return "ABBR" !== a.target.nodeName || this.is_disabled ? void 0 : this.results_reset(a)
        }, Chosen.prototype.search_results_mousewheel = function (a) {
            var b;
            return a.originalEvent && (b = a.originalEvent.deltaY || -a.originalEvent.wheelDelta || a.originalEvent.detail), null != b ? (a.preventDefault(), "DOMMouseScroll" === a.type && (b = 40 * b), this.search_results.scrollTop(b + this.search_results.scrollTop())) : void 0
        }, Chosen.prototype.blur_test = function () {
            return !this.active_field && this.container.hasClass("chosen-container-active") ? this.close_field() : void 0
        }, Chosen.prototype.close_field = function () {
            return a(this.container[0].ownerDocument).unbind("click.chosen", this.click_test_action), this.active_field = !1, this.results_hide(), this.container.removeClass("chosen-container-active"), this.clear_backstroke(), this.show_search_field_default(), this.search_field_scale()
        }, Chosen.prototype.activate_field = function () {
            return this.container.addClass("chosen-container-active"), this.active_field = !0, this.search_field.val(this.search_field.val()), this.search_field.focus()
        }, Chosen.prototype.test_active_click = function (b) {
            var c;
            return c = a(b.target).closest(".chosen-container"), c.length && this.container[0] === c[0] ? this.active_field = !0 : this.close_field()
        }, Chosen.prototype.results_build = function () {
            return this.parsing = !0, this.selected_option_count = null, this.results_data = SelectParser.select_to_array(this.form_field), this.is_multiple ? this.search_choices.find("li.search-choice").remove() : this.is_multiple || (this.single_set_selected_text(), this.disable_search || this.form_field.options.length <= this.disable_search_threshold ? (this.search_field[0].readOnly = !0, this.container.addClass("chosen-container-single-nosearch")) : (this.search_field[0].readOnly = !1, this.container.removeClass("chosen-container-single-nosearch"))), this.update_results_content(this.results_option_build({first: !0})), this.search_field_disabled(), this.show_search_field_default(), this.search_field_scale(), this.parsing = !1
        }, Chosen.prototype.result_do_highlight = function (a) {
            var b, c, d, e, f;
            if (a.length) {
                if (this.result_clear_highlight(), this.result_highlight = a, this.result_highlight.addClass("highlighted"), d = parseInt(this.search_results.css("maxHeight"), 10), f = this.search_results.scrollTop(), e = d + f, c = this.result_highlight.position().top + this.search_results.scrollTop(), b = c + this.result_highlight.outerHeight(), b >= e)return this.search_results.scrollTop(b - d > 0 ? b - d : 0);
                if (f > c)return this.search_results.scrollTop(c)
            }
        }, Chosen.prototype.result_clear_highlight = function () {
            return this.result_highlight && this.result_highlight.removeClass("highlighted"), this.result_highlight = null
        }, Chosen.prototype.results_show = function () {
            return this.is_multiple && this.max_selected_options <= this.choices_count() ? (this.form_field_jq.trigger("chosen:maxselected", {chosen: this}), !1) : (this.container.addClass("chosen-with-drop"), this.results_showing = !0, this.search_field.focus(), this.search_field.val(this.search_field.val()), this.winnow_results(), this.form_field_jq.trigger("chosen:showing_dropdown", {chosen: this}))
        }, Chosen.prototype.update_results_content = function (a) {
            return this.search_results.html(a)
        }, Chosen.prototype.results_hide = function () {
            return this.results_showing && (this.result_clear_highlight(), this.container.removeClass("chosen-with-drop"), this.form_field_jq.trigger("chosen:hiding_dropdown", {chosen: this})), this.results_showing = !1
        }, Chosen.prototype.set_tab_index = function () {
            var a;
            return this.form_field.tabIndex ? (a = this.form_field.tabIndex, this.form_field.tabIndex = -1, this.search_field[0].tabIndex = a) : void 0
        }, Chosen.prototype.set_label_behavior = function () {
            var b = this;
            return this.form_field_label = this.form_field_jq.parents("label"), !this.form_field_label.length && this.form_field.id.length && (this.form_field_label = a("label[for='" + this.form_field.id + "']")), this.form_field_label.length > 0 ? this.form_field_label.bind("click.chosen", function (a) {
                return b.is_multiple ? b.container_mousedown(a) : b.activate_field()
            }) : void 0
        }, Chosen.prototype.show_search_field_default = function () {
            return this.is_multiple && this.choices_count() < 1 && !this.active_field ? (this.search_field.val(this.default_text), this.search_field.addClass("default")) : (this.search_field.val(""), this.search_field.removeClass("default"))
        }, Chosen.prototype.search_results_mouseup = function (b) {
            var c;
            return c = a(b.target).hasClass("active-result") ? a(b.target) : a(b.target).parents(".active-result").first(), c.length ? (this.result_highlight = c, this.result_select(b), this.search_field.focus()) : void 0
        }, Chosen.prototype.search_results_mouseover = function (b) {
            var c;
            return c = a(b.target).hasClass("active-result") ? a(b.target) : a(b.target).parents(".active-result").first(), c ? this.result_do_highlight(c) : void 0
        }, Chosen.prototype.search_results_mouseout = function (b) {
            return a(b.target).hasClass("active-result") ? this.result_clear_highlight() : void 0
        }, Chosen.prototype.choice_build = function (b) {
            var c, d, e = this;
            return c = a("<li />", {"class": "search-choice"}).html("<span>" + this.choice_label(b) + "</span>"), b.disabled ? c.addClass("search-choice-disabled") : (d = a("<a />", {
                "class": "search-choice-close",
                "data-option-array-index": b.array_index
            }), d.bind("click.chosen", function (a) {
                return e.choice_destroy_link_click(a)
            }), c.append(d)), this.search_container.before(c)
        }, Chosen.prototype.choice_destroy_link_click = function (b) {
            return b.preventDefault(), b.stopPropagation(), this.is_disabled ? void 0 : this.choice_destroy(a(b.target))
        }, Chosen.prototype.choice_destroy = function (a) {
            return this.result_deselect(a[0].getAttribute("data-option-array-index")) ? (this.show_search_field_default(), this.is_multiple && this.choices_count() > 0 && this.search_field.val().length < 1 && this.results_hide(), a.parents("li").first().remove(), this.search_field_scale()) : void 0
        }, Chosen.prototype.results_reset = function () {
            return this.reset_single_select_options(), this.form_field.options[0].selected = !0, this.single_set_selected_text(), this.show_search_field_default(), this.results_reset_cleanup(), this.form_field_jq.trigger("change"), this.active_field ? this.results_hide() : void 0
        }, Chosen.prototype.results_reset_cleanup = function () {
            return this.current_selectedIndex = this.form_field.selectedIndex, this.selected_item.find("abbr").remove()
        }, Chosen.prototype.result_select = function (a) {
            var b, c;
            return this.result_highlight ? (b = this.result_highlight, this.result_clear_highlight(), this.is_multiple && this.max_selected_options <= this.choices_count() ? (this.form_field_jq.trigger("chosen:maxselected", {chosen: this}), !1) : (this.is_multiple ? b.removeClass("active-result") : this.reset_single_select_options(), b.addClass("result-selected"), c = this.results_data[b[0].getAttribute("data-option-array-index")], c.selected = !0, this.form_field.options[c.options_index].selected = !0, this.selected_option_count = null, this.is_multiple ? this.choice_build(c) : this.single_set_selected_text(this.choice_label(c)), (a.metaKey || a.ctrlKey) && this.is_multiple || this.results_hide(), this.search_field.val(""), (this.is_multiple || this.form_field.selectedIndex !== this.current_selectedIndex) && this.form_field_jq.trigger("change", {selected: this.form_field.options[c.options_index].value}), this.current_selectedIndex = this.form_field.selectedIndex, a.preventDefault(), this.search_field_scale())) : void 0
        }, Chosen.prototype.single_set_selected_text = function (a) {
            return null == a && (a = this.default_text), a === this.default_text ? this.selected_item.addClass("chosen-default") : (this.single_deselect_control_build(), this.selected_item.removeClass("chosen-default")), this.selected_item.find("span").html(a)
        }, Chosen.prototype.result_deselect = function (a) {
            var b;
            return b = this.results_data[a], this.form_field.options[b.options_index].disabled ? !1 : (b.selected = !1, this.form_field.options[b.options_index].selected = !1, this.selected_option_count = null, this.result_clear_highlight(), this.results_showing && this.winnow_results(), this.form_field_jq.trigger("change", {deselected: this.form_field.options[b.options_index].value}), this.search_field_scale(), !0)
        }, Chosen.prototype.single_deselect_control_build = function () {
            return this.allow_single_deselect ? (this.selected_item.find("abbr").length || this.selected_item.find("span").first().after('<abbr class="search-choice-close"></abbr>'), this.selected_item.addClass("chosen-single-with-deselect")) : void 0
        }, Chosen.prototype.get_search_text = function () {
            return a("<div/>").text(a.trim(this.search_field.val())).html()
        }, Chosen.prototype.winnow_results_set_highlight = function () {
            var a, b;
            return b = this.is_multiple ? [] : this.search_results.find(".result-selected.active-result"), a = b.length ? b.first() : this.search_results.find(".active-result").first(), null != a ? this.result_do_highlight(a) : void 0
        }, Chosen.prototype.no_results = function (b) {
            var c;
            return c = a('<li class="no-results">' + this.results_none_found + ' "<span></span>"</li>'), c.find("span").first().html(b), this.search_results.append(c), this.form_field_jq.trigger("chosen:no_results", {chosen: this})
        }, Chosen.prototype.no_results_clear = function () {
            return this.search_results.find(".no-results").remove()
        }, Chosen.prototype.keydown_arrow = function () {
            var a;
            return this.results_showing && this.result_highlight ? (a = this.result_highlight.nextAll("li.active-result").first()) ? this.result_do_highlight(a) : void 0 : this.results_show()
        }, Chosen.prototype.keyup_arrow = function () {
            var a;
            return this.results_showing || this.is_multiple ? this.result_highlight ? (a = this.result_highlight.prevAll("li.active-result"), a.length ? this.result_do_highlight(a.first()) : (this.choices_count() > 0 && this.results_hide(), this.result_clear_highlight())) : void 0 : this.results_show()
        }, Chosen.prototype.keydown_backstroke = function () {
            var a;
            return this.pending_backstroke ? (this.choice_destroy(this.pending_backstroke.find("a").first()), this.clear_backstroke()) : (a = this.search_container.siblings("li.search-choice").last(), a.length && !a.hasClass("search-choice-disabled") ? (this.pending_backstroke = a, this.single_backstroke_delete ? this.keydown_backstroke() : this.pending_backstroke.addClass("search-choice-focus")) : void 0)
        }, Chosen.prototype.clear_backstroke = function () {
            return this.pending_backstroke && this.pending_backstroke.removeClass("search-choice-focus"), this.pending_backstroke = null
        }, Chosen.prototype.keydown_checker = function (a) {
            var b, c;
            switch (b = null != (c = a.which) ? c : a.keyCode, this.search_field_scale(), 8 !== b && this.pending_backstroke && this.clear_backstroke(), b) {
                case 8:
                    this.backstroke_length = this.search_field.val().length;
                    break;
                case 9:
                    this.results_showing && !this.is_multiple && this.result_select(a), this.mouse_on_container = !1;
                    break;
                case 13:
                    this.results_showing && a.preventDefault();
                    break;
                case 32:
                    this.disable_search && a.preventDefault();
                    break;
                case 38:
                    a.preventDefault(), this.keyup_arrow();
                    break;
                case 40:
                    a.preventDefault(), this.keydown_arrow()
            }
        }, Chosen.prototype.search_field_scale = function () {
            var b, c, d, e, f, g, h, i, j;
            if (this.is_multiple) {
                for (d = 0, h = 0, f = "position:absolute; left: -1000px; top: -1000px; display:none;", g = ["font-size", "font-style", "font-weight", "font-family", "line-height", "text-transform", "letter-spacing"], i = 0, j = g.length; j > i; i++)e = g[i], f += e + ":" + this.search_field.css(e) + ";";
                return b = a("<div />", {style: f}), b.text(this.search_field.val()), a("body").append(b), h = b.width() + 25, b.remove(), c = this.container.outerWidth(), h > c - 10 && (h = c - 10), this.search_field.css({width: h + "px"})
            }
        }, Chosen
    }(AbstractChosen)
}).call(this);

/*

 * Isotope PACKAGED v3.0.0

 *

 * Licensed GPLv3 for open source use

 * or Isotope Commercial License for commercial use

 *

 * http://isotope.metafizzy.co

 * Copyright 2016 Metafizzy

 */


!function (t, e) {
    "use strict";
    "function" == typeof define && define.amd ? define("jquery-bridget/jquery-bridget", ["jquery"], function (i) {
        e(t, i)
    }) : "object" == typeof module && module.exports ? module.exports = e(t, require("jquery")) : t.jQueryBridget = e(t, t.jQuery)
}(window, function (t, e) {
    "use strict";
    function i(i, r, a) {
        function u(t, e, n) {
            var o, r = "$()." + i + '("' + e + '")';
            return t.each(function (t, u) {
                var h = a.data(u, i);
                if (!h)return void s(i + " not initialized. Cannot call methods, i.e. " + r);
                var d = h[e];
                if (!d || "_" == e.charAt(0))return void s(r + " is not a valid method");
                var l = d.apply(h, n);
                o = void 0 === o ? l : o
            }), void 0 !== o ? o : t
        }

        function h(t, e) {
            t.each(function (t, n) {
                var o = a.data(n, i);
                o ? (o.option(e), o._init()) : (o = new r(n, e), a.data(n, i, o))
            })
        }

        a = a || e || t.jQuery, a && (r.prototype.option || (r.prototype.option = function (t) {
            a.isPlainObject(t) && (this.options = a.extend(!0, this.options, t))
        }), a.fn[i] = function (t) {
            if ("string" == typeof t) {
                var e = o.call(arguments, 1);
                return u(this, t, e)
            }
            return h(this, t), this
        }, n(a))
    }

    function n(t) {
        !t || t && t.bridget || (t.bridget = i)
    }

    var o = Array.prototype.slice, r = t.console, s = "undefined" == typeof r ? function () {
    } : function (t) {
        r.error(t)
    };
    return n(e || t.jQuery), i
}), function (t, e) {
    "function" == typeof define && define.amd ? define("ev-emitter/ev-emitter", e) : "object" == typeof module && module.exports ? module.exports = e() : t.EvEmitter = e()
}(this, function () {
    function t() {
    }

    var e = t.prototype;
    return e.on = function (t, e) {
        if (t && e) {
            var i = this._events = this._events || {}, n = i[t] = i[t] || [];
            return -1 == n.indexOf(e) && n.push(e), this
        }
    }, e.once = function (t, e) {
        if (t && e) {
            this.on(t, e);
            var i = this._onceEvents = this._onceEvents || {}, n = i[t] = i[t] || {};
            return n[e] = !0, this
        }
    }, e.off = function (t, e) {
        var i = this._events && this._events[t];
        if (i && i.length) {
            var n = i.indexOf(e);
            return -1 != n && i.splice(n, 1), this
        }
    }, e.emitEvent = function (t, e) {
        var i = this._events && this._events[t];
        if (i && i.length) {
            var n = 0, o = i[n];
            e = e || [];
            for (var r = this._onceEvents && this._onceEvents[t]; o;) {
                var s = r && r[o];
                s && (this.off(t, o), delete r[o]), o.apply(this, e), n += s ? 0 : 1, o = i[n]
            }
            return this
        }
    }, t
}), function (t, e) {
    "use strict";
    "function" == typeof define && define.amd ? define("get-size/get-size", [], function () {
        return e()
    }) : "object" == typeof module && module.exports ? module.exports = e() : t.getSize = e()
}(window, function () {
    "use strict";
    function t(t) {
        var e = parseFloat(t), i = -1 == t.indexOf("%") && !isNaN(e);
        return i && e
    }

    function e() {
    }

    function i() {
        for (var t = {width: 0, height: 0, innerWidth: 0, innerHeight: 0, outerWidth: 0, outerHeight: 0},
                 e = 0; h > e; e++) {
            var i = u[e];
            t[i] = 0
        }
        return t
    }

    function n(t) {
        var e = getComputedStyle(t);
        return e || a("Style returned " + e + ". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"), e
    }

    function o() {
        if (!d) {
            d = !0;
            var e = document.createElement("div");
            e.style.width = "200px", e.style.padding = "1px 2px 3px 4px", e.style.borderStyle = "solid", e.style.borderWidth = "1px 2px 3px 4px", e.style.boxSizing = "border-box";
            var i = document.body || document.documentElement;
            i.appendChild(e);
            var o = n(e);
            r.isBoxSizeOuter = s = 200 == t(o.width), i.removeChild(e)
        }
    }

    function r(e) {
        if (o(), "string" == typeof e && (e = document.querySelector(e)), e && "object" == typeof e && e.nodeType) {
            var r = n(e);
            if ("none" == r.display)return i();
            var a = {};
            a.width = e.offsetWidth, a.height = e.offsetHeight;
            for (var d = a.isBorderBox = "border-box" == r.boxSizing, l = 0; h > l; l++) {
                var f = u[l], c = r[f], m = parseFloat(c);
                a[f] = isNaN(m) ? 0 : m
            }
            var p = a.paddingLeft + a.paddingRight, y = a.paddingTop + a.paddingBottom,
                g = a.marginLeft + a.marginRight, v = a.marginTop + a.marginBottom,
                _ = a.borderLeftWidth + a.borderRightWidth, I = a.borderTopWidth + a.borderBottomWidth, z = d && s,
                x = t(r.width);
            x !== !1 && (a.width = x + (z ? 0 : p + _));
            var S = t(r.height);
            return S !== !1 && (a.height = S + (z ? 0 : y + I)), a.innerWidth = a.width - (p + _), a.innerHeight = a.height - (y + I), a.outerWidth = a.width + g, a.outerHeight = a.height + v, a
        }
    }

    var s, a = "undefined" == typeof console ? e : function (t) {
            console.error(t)
        },
        u = ["paddingLeft", "paddingRight", "paddingTop", "paddingBottom", "marginLeft", "marginRight", "marginTop", "marginBottom", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"],
        h = u.length, d = !1;
    return r
}), function (t, e) {
    "use strict";
    "function" == typeof define && define.amd ? define("desandro-matches-selector/matches-selector", e) : "object" == typeof module && module.exports ? module.exports = e() : t.matchesSelector = e()
}(window, function () {
    "use strict";
    var t = function () {
        var t = Element.prototype;
        if (t.matches)return "matches";
        if (t.matchesSelector)return "matchesSelector";
        for (var e = ["webkit", "moz", "ms", "o"], i = 0; i < e.length; i++) {
            var n = e[i], o = n + "MatchesSelector";
            if (t[o])return o
        }
    }();
    return function (e, i) {
        return e[t](i)
    }
}), function (t, e) {
    "function" == typeof define && define.amd ? define("fizzy-ui-utils/utils", ["desandro-matches-selector/matches-selector"], function (i) {
        return e(t, i)
    }) : "object" == typeof module && module.exports ? module.exports = e(t, require("desandro-matches-selector")) : t.fizzyUIUtils = e(t, t.matchesSelector)
}(window, function (t, e) {
    var i = {};
    i.extend = function (t, e) {
        for (var i in e)t[i] = e[i];
        return t
    }, i.modulo = function (t, e) {
        return (t % e + e) % e
    }, i.makeArray = function (t) {
        var e = [];
        if (Array.isArray(t)) e = t; else if (t && "number" == typeof t.length)for (var i = 0; i < t.length; i++)e.push(t[i]); else e.push(t);
        return e
    }, i.removeFrom = function (t, e) {
        var i = t.indexOf(e);
        -1 != i && t.splice(i, 1)
    }, i.getParent = function (t, i) {
        for (; t != document.body;)if (t = t.parentNode, e(t, i))return t
    }, i.getQueryElement = function (t) {
        return "string" == typeof t ? document.querySelector(t) : t
    }, i.handleEvent = function (t) {
        var e = "on" + t.type;
        this[e] && this[e](t)
    }, i.filterFindElements = function (t, n) {
        t = i.makeArray(t);
        var o = [];
        return t.forEach(function (t) {
            if (t instanceof HTMLElement) {
                if (!n)return void o.push(t);
                e(t, n) && o.push(t);
                for (var i = t.querySelectorAll(n), r = 0; r < i.length; r++)o.push(i[r])
            }
        }), o
    }, i.debounceMethod = function (t, e, i) {
        var n = t.prototype[e], o = e + "Timeout";
        t.prototype[e] = function () {
            var t = this[o];
            t && clearTimeout(t);
            var e = arguments, r = this;
            this[o] = setTimeout(function () {
                n.apply(r, e), delete r[o]
            }, i || 100)
        }
    }, i.docReady = function (t) {
        "complete" == document.readyState ? t() : document.addEventListener("DOMContentLoaded", t)
    }, i.toDashed = function (t) {
        return t.replace(/(.)([A-Z])/g, function (t, e, i) {
            return e + "-" + i
        }).toLowerCase()
    };
    var n = t.console;
    return i.htmlInit = function (e, o) {
        i.docReady(function () {
            var r = i.toDashed(o), s = "data-" + r, a = document.querySelectorAll("[" + s + "]"),
                u = document.querySelectorAll(".js-" + r), h = i.makeArray(a).concat(i.makeArray(u)),
                d = s + "-options", l = t.jQuery;
            h.forEach(function (t) {
                var i, r = t.getAttribute(s) || t.getAttribute(d);
                try {
                    i = r && JSON.parse(r)
                } catch (a) {
                    return void(n && n.error("Error parsing " + s + " on " + t.className + ": " + a))
                }
                var u = new e(t, i);
                l && l.data(t, o, u)
            })
        })
    }, i
}), function (t, e) {
    "function" == typeof define && define.amd ? define("outlayer/item", ["ev-emitter/ev-emitter", "get-size/get-size"], e) : "object" == typeof module && module.exports ? module.exports = e(require("ev-emitter"), require("get-size")) : (t.Outlayer = {}, t.Outlayer.Item = e(t.EvEmitter, t.getSize))
}(window, function (t, e) {
    "use strict";
    function i(t) {
        for (var e in t)return !1;
        return e = null, !0
    }

    function n(t, e) {
        t && (this.element = t, this.layout = e, this.position = {x: 0, y: 0}, this._create())
    }

    function o(t) {
        return t.replace(/([A-Z])/g, function (t) {
            return "-" + t.toLowerCase()
        })
    }

    var r = document.documentElement.style, s = "string" == typeof r.transition ? "transition" : "WebkitTransition",
        a = "string" == typeof r.transform ? "transform" : "WebkitTransform",
        u = {WebkitTransition: "webkitTransitionEnd", transition: "transitionend"}[s], h = {
            transform: a,
            transition: s,
            transitionDuration: s + "Duration",
            transitionProperty: s + "Property",
            transitionDelay: s + "Delay"
        }, d = n.prototype = Object.create(t.prototype);
    d.constructor = n, d._create = function () {
        this._transn = {ingProperties: {}, clean: {}, onEnd: {}}, this.css({position: "absolute"})
    }, d.handleEvent = function (t) {
        var e = "on" + t.type;
        this[e] && this[e](t)
    }, d.getSize = function () {
        this.size = e(this.element)
    }, d.css = function (t) {
        var e = this.element.style;
        for (var i in t) {
            var n = h[i] || i;
            e[n] = t[i]
        }
    }, d.getPosition = function () {
        var t = getComputedStyle(this.element), e = this.layout._getOption("originLeft"),
            i = this.layout._getOption("originTop"), n = t[e ? "left" : "right"], o = t[i ? "top" : "bottom"],
            r = this.layout.size, s = -1 != n.indexOf("%") ? parseFloat(n) / 100 * r.width : parseInt(n, 10),
            a = -1 != o.indexOf("%") ? parseFloat(o) / 100 * r.height : parseInt(o, 10);
        s = isNaN(s) ? 0 : s, a = isNaN(a) ? 0 : a, s -= e ? r.paddingLeft : r.paddingRight, a -= i ? r.paddingTop : r.paddingBottom, this.position.x = s, this.position.y = a
    }, d.layoutPosition = function () {
        var t = this.layout.size, e = {}, i = this.layout._getOption("originLeft"),
            n = this.layout._getOption("originTop"), o = i ? "paddingLeft" : "paddingRight", r = i ? "left" : "right",
            s = i ? "right" : "left", a = this.position.x + t[o];
        e[r] = this.getXValue(a), e[s] = "";
        var u = n ? "paddingTop" : "paddingBottom", h = n ? "top" : "bottom", d = n ? "bottom" : "top",
            l = this.position.y + t[u];
        e[h] = this.getYValue(l), e[d] = "", this.css(e), this.emitEvent("layout", [this])
    }, d.getXValue = function (t) {
        var e = this.layout._getOption("horizontal");
        return this.layout.options.percentPosition && !e ? t / this.layout.size.width * 100 + "%" : t + "px"
    }, d.getYValue = function (t) {
        var e = this.layout._getOption("horizontal");
        return this.layout.options.percentPosition && e ? t / this.layout.size.height * 100 + "%" : t + "px"
    }, d._transitionTo = function (t, e) {
        this.getPosition();
        var i = this.position.x, n = this.position.y, o = parseInt(t, 10), r = parseInt(e, 10),
            s = o === this.position.x && r === this.position.y;
        if (this.setPosition(t, e), s && !this.isTransitioning)return void this.layoutPosition();
        var a = t - i, u = e - n, h = {};
        h.transform = this.getTranslate(a, u), this.transition({
            to: h,
            onTransitionEnd: {transform: this.layoutPosition},
            isCleaning: !0
        })
    }, d.getTranslate = function (t, e) {
        var i = this.layout._getOption("originLeft"), n = this.layout._getOption("originTop");
        return t = i ? t : -t, e = n ? e : -e, "translate3d(" + t + "px, " + e + "px, 0)"
    }, d.goTo = function (t, e) {
        this.setPosition(t, e), this.layoutPosition()
    }, d.moveTo = d._transitionTo, d.setPosition = function (t, e) {
        this.position.x = parseInt(t, 10), this.position.y = parseInt(e, 10)
    }, d._nonTransition = function (t) {
        this.css(t.to), t.isCleaning && this._removeStyles(t.to);
        for (var e in t.onTransitionEnd)t.onTransitionEnd[e].call(this)
    }, d.transition = function (t) {
        if (!parseFloat(this.layout.options.transitionDuration))return void this._nonTransition(t);
        var e = this._transn;
        for (var i in t.onTransitionEnd)e.onEnd[i] = t.onTransitionEnd[i];
        for (i in t.to)e.ingProperties[i] = !0, t.isCleaning && (e.clean[i] = !0);
        if (t.from) {
            this.css(t.from);
            var n = this.element.offsetHeight;
            n = null
        }
        this.enableTransition(t.to), this.css(t.to), this.isTransitioning = !0
    };
    var l = "opacity," + o(a);
    d.enableTransition = function () {
        if (!this.isTransitioning) {
            var t = this.layout.options.transitionDuration;
            t = "number" == typeof t ? t + "ms" : t, this.css({
                transitionProperty: l,
                transitionDuration: t,
                transitionDelay: this.staggerDelay || 0
            }), this.element.addEventListener(u, this, !1)
        }
    }, d.onwebkitTransitionEnd = function (t) {
        this.ontransitionend(t)
    }, d.onotransitionend = function (t) {
        this.ontransitionend(t)
    };
    var f = {"-webkit-transform": "transform"};
    d.ontransitionend = function (t) {
        if (t.target === this.element) {
            var e = this._transn, n = f[t.propertyName] || t.propertyName;
            if (delete e.ingProperties[n], i(e.ingProperties) && this.disableTransition(), n in e.clean && (this.element.style[t.propertyName] = "", delete e.clean[n]), n in e.onEnd) {
                var o = e.onEnd[n];
                o.call(this), delete e.onEnd[n]
            }
            this.emitEvent("transitionEnd", [this])
        }
    }, d.disableTransition = function () {
        this.removeTransitionStyles(), this.element.removeEventListener(u, this, !1), this.isTransitioning = !1
    }, d._removeStyles = function (t) {
        var e = {};
        for (var i in t)e[i] = "";
        this.css(e)
    };
    var c = {transitionProperty: "", transitionDuration: "", transitionDelay: ""};
    return d.removeTransitionStyles = function () {
        this.css(c)
    }, d.stagger = function (t) {
        t = isNaN(t) ? 0 : t, this.staggerDelay = t + "ms"
    }, d.removeElem = function () {
        this.element.parentNode.removeChild(this.element), this.css({display: ""}), this.emitEvent("remove", [this])
    }, d.remove = function () {
        return s && parseFloat(this.layout.options.transitionDuration) ? (this.once("transitionEnd", function () {
            this.removeElem()
        }), void this.hide()) : void this.removeElem()
    }, d.reveal = function () {
        delete this.isHidden, this.css({display: ""});
        var t = this.layout.options, e = {}, i = this.getHideRevealTransitionEndProperty("visibleStyle");
        e[i] = this.onRevealTransitionEnd, this.transition({
            from: t.hiddenStyle,
            to: t.visibleStyle,
            isCleaning: !0,
            onTransitionEnd: e
        })
    }, d.onRevealTransitionEnd = function () {
        this.isHidden || this.emitEvent("reveal")
    }, d.getHideRevealTransitionEndProperty = function (t) {
        var e = this.layout.options[t];
        if (e.opacity)return "opacity";
        for (var i in e)return i
    }, d.hide = function () {
        this.isHidden = !0, this.css({display: ""});
        var t = this.layout.options, e = {}, i = this.getHideRevealTransitionEndProperty("hiddenStyle");
        e[i] = this.onHideTransitionEnd, this.transition({
            from: t.visibleStyle,
            to: t.hiddenStyle,
            isCleaning: !0,
            onTransitionEnd: e
        })
    }, d.onHideTransitionEnd = function () {
        this.isHidden && (this.css({display: "none"}), this.emitEvent("hide"))
    }, d.destroy = function () {
        this.css({position: "", left: "", right: "", top: "", bottom: "", transition: "", transform: ""})
    }, n
}), function (t, e) {
    "use strict";
    "function" == typeof define && define.amd ? define("outlayer/outlayer", ["ev-emitter/ev-emitter", "get-size/get-size", "fizzy-ui-utils/utils", "./item"], function (i, n, o, r) {
        return e(t, i, n, o, r)
    }) : "object" == typeof module && module.exports ? module.exports = e(t, require("ev-emitter"), require("get-size"), require("fizzy-ui-utils"), require("./item")) : t.Outlayer = e(t, t.EvEmitter, t.getSize, t.fizzyUIUtils, t.Outlayer.Item)
}(window, function (t, e, i, n, o) {
    "use strict";
    function r(t, e) {
        var i = n.getQueryElement(t);
        if (!i)return void(u && u.error("Bad element for " + this.constructor.namespace + ": " + (i || t)));
        this.element = i, h && (this.$element = h(this.element)), this.options = n.extend({}, this.constructor.defaults), this.option(e);
        var o = ++l;
        this.element.outlayerGUID = o, f[o] = this, this._create();
        var r = this._getOption("initLayout");
        r && this.layout()
    }

    function s(t) {
        function e() {
            t.apply(this, arguments)
        }

        return e.prototype = Object.create(t.prototype), e.prototype.constructor = e, e
    }

    function a(t) {
        if ("number" == typeof t)return t;
        var e = t.match(/(^\d*\.?\d*)(\w*)/), i = e && e[1], n = e && e[2];
        if (!i.length)return 0;
        i = parseFloat(i);
        var o = m[n] || 1;
        return i * o
    }

    var u = t.console, h = t.jQuery, d = function () {
    }, l = 0, f = {};
    r.namespace = "outlayer", r.Item = o, r.defaults = {
        containerStyle: {position: "relative"},
        initLayout: !0,
        originLeft: !0,
        originTop: !0,
        resize: !0,
        resizeContainer: !0,
        transitionDuration: "0.4s",
        hiddenStyle: {opacity: 0, transform: "scale(0.001)"},
        visibleStyle: {opacity: 1, transform: "scale(1)"}
    };
    var c = r.prototype;
    n.extend(c, e.prototype), c.option = function (t) {
        n.extend(this.options, t)
    }, c._getOption = function (t) {
        var e = this.constructor.compatOptions[t];
        return e && void 0 !== this.options[e] ? this.options[e] : this.options[t]
    }, r.compatOptions = {
        initLayout: "isInitLayout",
        horizontal: "isHorizontal",
        layoutInstant: "isLayoutInstant",
        originLeft: "isOriginLeft",
        originTop: "isOriginTop",
        resize: "isResizeBound",
        resizeContainer: "isResizingContainer"
    }, c._create = function () {
        this.reloadItems(), this.stamps = [], this.stamp(this.options.stamp), n.extend(this.element.style, this.options.containerStyle);
        var t = this._getOption("resize");
        t && this.bindResize()
    }, c.reloadItems = function () {
        this.items = this._itemize(this.element.children)
    }, c._itemize = function (t) {
        for (var e = this._filterFindItemElements(t), i = this.constructor.Item, n = [], o = 0; o < e.length; o++) {
            var r = e[o], s = new i(r, this);
            n.push(s)
        }
        return n
    }, c._filterFindItemElements = function (t) {
        return n.filterFindElements(t, this.options.itemSelector)
    }, c.getItemElements = function () {
        return this.items.map(function (t) {
            return t.element
        })
    }, c.layout = function () {
        this._resetLayout(), this._manageStamps();
        var t = this._getOption("layoutInstant"), e = void 0 !== t ? t : !this._isLayoutInited;
        this.layoutItems(this.items, e), this._isLayoutInited = !0
    }, c._init = c.layout, c._resetLayout = function () {
        this.getSize()
    }, c.getSize = function () {
        this.size = i(this.element)
    }, c._getMeasurement = function (t, e) {
        var n, o = this.options[t];
        o ? ("string" == typeof o ? n = this.element.querySelector(o) : o instanceof HTMLElement && (n = o), this[t] = n ? i(n)[e] : o) : this[t] = 0
    }, c.layoutItems = function (t, e) {
        t = this._getItemsForLayout(t), this._layoutItems(t, e), this._postLayout()
    }, c._getItemsForLayout = function (t) {
        return t.filter(function (t) {
            return !t.isIgnored
        })
    }, c._layoutItems = function (t, e) {
        if (this._emitCompleteOnItems("layout", t), t && t.length) {
            var i = [];
            t.forEach(function (t) {
                var n = this._getItemLayoutPosition(t);
                n.item = t, n.isInstant = e || t.isLayoutInstant, i.push(n)
            }, this), this._processLayoutQueue(i)
        }
    }, c._getItemLayoutPosition = function () {
        return {x: 0, y: 0}
    }, c._processLayoutQueue = function (t) {
        this.updateStagger(), t.forEach(function (t, e) {
            this._positionItem(t.item, t.x, t.y, t.isInstant, e)
        }, this)
    }, c.updateStagger = function () {
        var t = this.options.stagger;
        return null === t || void 0 === t ? void(this.stagger = 0) : (this.stagger = a(t), this.stagger)
    }, c._positionItem = function (t, e, i, n, o) {
        n ? t.goTo(e, i) : (t.stagger(o * this.stagger), t.moveTo(e, i))
    }, c._postLayout = function () {
        this.resizeContainer()
    }, c.resizeContainer = function () {
        var t = this._getOption("resizeContainer");
        if (t) {
            var e = this._getContainerSize();
            e && (this._setContainerMeasure(e.width, !0), this._setContainerMeasure(e.height, !1))
        }
    }, c._getContainerSize = d, c._setContainerMeasure = function (t, e) {
        if (void 0 !== t) {
            var i = this.size;
            i.isBorderBox && (t += e ? i.paddingLeft + i.paddingRight + i.borderLeftWidth + i.borderRightWidth : i.paddingBottom + i.paddingTop + i.borderTopWidth + i.borderBottomWidth), t = Math.max(t, 0), this.element.style[e ? "width" : "height"] = t + "px"
        }
    }, c._emitCompleteOnItems = function (t, e) {
        function i() {
            o.dispatchEvent(t + "Complete", null, [e])
        }

        function n() {
            s++, s == r && i()
        }

        var o = this, r = e.length;
        if (!e || !r)return void i();
        var s = 0;
        e.forEach(function (e) {
            e.once(t, n)
        })
    }, c.dispatchEvent = function (t, e, i) {
        var n = e ? [e].concat(i) : i;
        if (this.emitEvent(t, n), h)if (this.$element = this.$element || h(this.element), e) {
            var o = h.Event(e);
            o.type = t, this.$element.trigger(o, i)
        } else this.$element.trigger(t, i)
    }, c.ignore = function (t) {
        var e = this.getItem(t);
        e && (e.isIgnored = !0)
    }, c.unignore = function (t) {
        var e = this.getItem(t);
        e && delete e.isIgnored
    }, c.stamp = function (t) {
        t = this._find(t), t && (this.stamps = this.stamps.concat(t), t.forEach(this.ignore, this))
    }, c.unstamp = function (t) {
        t = this._find(t), t && t.forEach(function (t) {
            n.removeFrom(this.stamps, t), this.unignore(t)
        }, this)
    }, c._find = function (t) {
        return t ? ("string" == typeof t && (t = this.element.querySelectorAll(t)), t = n.makeArray(t)) : void 0
    }, c._manageStamps = function () {
        this.stamps && this.stamps.length && (this._getBoundingRect(), this.stamps.forEach(this._manageStamp, this))
    }, c._getBoundingRect = function () {
        var t = this.element.getBoundingClientRect(), e = this.size;
        this._boundingRect = {
            left: t.left + e.paddingLeft + e.borderLeftWidth,
            top: t.top + e.paddingTop + e.borderTopWidth,
            right: t.right - (e.paddingRight + e.borderRightWidth),
            bottom: t.bottom - (e.paddingBottom + e.borderBottomWidth)
        }
    }, c._manageStamp = d, c._getElementOffset = function (t) {
        var e = t.getBoundingClientRect(), n = this._boundingRect, o = i(t), r = {
            left: e.left - n.left - o.marginLeft,
            top: e.top - n.top - o.marginTop,
            right: n.right - e.right - o.marginRight,
            bottom: n.bottom - e.bottom - o.marginBottom
        };
        return r
    }, c.handleEvent = n.handleEvent, c.bindResize = function () {
        t.addEventListener("resize", this), this.isResizeBound = !0
    }, c.unbindResize = function () {
        t.removeEventListener("resize", this), this.isResizeBound = !1
    }, c.onresize = function () {
        this.resize()
    }, n.debounceMethod(r, "onresize", 100), c.resize = function () {
        this.isResizeBound && this.needsResizeLayout() && this.layout()
    }, c.needsResizeLayout = function () {
        var t = i(this.element), e = this.size && t;
        return e && t.innerWidth !== this.size.innerWidth
    }, c.addItems = function (t) {
        var e = this._itemize(t);
        return e.length && (this.items = this.items.concat(e)), e
    }, c.appended = function (t) {
        var e = this.addItems(t);
        e.length && (this.layoutItems(e, !0), this.reveal(e))
    }, c.prepended = function (t) {
        var e = this._itemize(t);
        if (e.length) {
            var i = this.items.slice(0);
            this.items = e.concat(i), this._resetLayout(), this._manageStamps(), this.layoutItems(e, !0), this.reveal(e), this.layoutItems(i)
        }
    }, c.reveal = function (t) {
        if (this._emitCompleteOnItems("reveal", t), t && t.length) {
            var e = this.updateStagger();
            t.forEach(function (t, i) {
                t.stagger(i * e), t.reveal()
            })
        }
    }, c.hide = function (t) {
        if (this._emitCompleteOnItems("hide", t), t && t.length) {
            var e = this.updateStagger();
            t.forEach(function (t, i) {
                t.stagger(i * e), t.hide()
            })
        }
    }, c.revealItemElements = function (t) {
        var e = this.getItems(t);
        this.reveal(e)
    }, c.hideItemElements = function (t) {
        var e = this.getItems(t);
        this.hide(e)
    }, c.getItem = function (t) {
        for (var e = 0; e < this.items.length; e++) {
            var i = this.items[e];
            if (i.element == t)return i
        }
    }, c.getItems = function (t) {
        t = n.makeArray(t);
        var e = [];
        return t.forEach(function (t) {
            var i = this.getItem(t);
            i && e.push(i)
        }, this), e
    }, c.remove = function (t) {
        var e = this.getItems(t);
        this._emitCompleteOnItems("remove", e), e && e.length && e.forEach(function (t) {
            t.remove(), n.removeFrom(this.items, t)
        }, this)
    }, c.destroy = function () {
        var t = this.element.style;
        t.height = "", t.position = "", t.width = "", this.items.forEach(function (t) {
            t.destroy()
        }), this.unbindResize();
        var e = this.element.outlayerGUID;
        delete f[e], delete this.element.outlayerGUID, h && h.removeData(this.element, this.constructor.namespace)
    }, r.data = function (t) {
        t = n.getQueryElement(t);
        var e = t && t.outlayerGUID;
        return e && f[e]
    }, r.create = function (t, e) {
        var i = s(r);
        return i.defaults = n.extend({}, r.defaults), n.extend(i.defaults, e), i.compatOptions = n.extend({}, r.compatOptions), i.namespace = t, i.data = r.data, i.Item = s(o), n.htmlInit(i, t), h && h.bridget && h.bridget(t, i), i
    };
    var m = {ms: 1, s: 1e3};
    return r.Item = o, r
}), function (t, e) {
    "function" == typeof define && define.amd ? define("isotope/item", ["outlayer/outlayer"], e) : "object" == typeof module && module.exports ? module.exports = e(require("outlayer")) : (t.Isotope = t.Isotope || {}, t.Isotope.Item = e(t.Outlayer))
}(window, function (t) {
    "use strict";
    function e() {
        t.Item.apply(this, arguments)
    }

    var i = e.prototype = Object.create(t.Item.prototype), n = i._create;
    i._create = function () {
        this.id = this.layout.itemGUID++, n.call(this), this.sortData = {}
    }, i.updateSortData = function () {
        if (!this.isIgnored) {
            this.sortData.id = this.id, this.sortData["original-order"] = this.id, this.sortData.random = Math.random();
            var t = this.layout.options.getSortData, e = this.layout._sorters;
            for (var i in t) {
                var n = e[i];
                this.sortData[i] = n(this.element, this)
            }
        }
    };
    var o = i.destroy;
    return i.destroy = function () {
        o.apply(this, arguments), this.css({display: ""})
    }, e
}), function (t, e) {
    "function" == typeof define && define.amd ? define("isotope/layout-mode", ["get-size/get-size", "outlayer/outlayer"], e) : "object" == typeof module && module.exports ? module.exports = e(require("get-size"), require("outlayer")) : (t.Isotope = t.Isotope || {}, t.Isotope.LayoutMode = e(t.getSize, t.Outlayer))
}(window, function (t, e) {
    "use strict";
    function i(t) {
        this.isotope = t, t && (this.options = t.options[this.namespace], this.element = t.element, this.items = t.filteredItems, this.size = t.size)
    }

    var n = i.prototype,
        o = ["_resetLayout", "_getItemLayoutPosition", "_manageStamp", "_getContainerSize", "_getElementOffset", "needsResizeLayout", "_getOption"];
    return o.forEach(function (t) {
        n[t] = function () {
            return e.prototype[t].apply(this.isotope, arguments)
        }
    }), n.needsVerticalResizeLayout = function () {
        var e = t(this.isotope.element), i = this.isotope.size && e;
        return i && e.innerHeight != this.isotope.size.innerHeight
    }, n._getMeasurement = function () {
        this.isotope._getMeasurement.apply(this, arguments)
    }, n.getColumnWidth = function () {
        this.getSegmentSize("column", "Width")
    }, n.getRowHeight = function () {
        this.getSegmentSize("row", "Height")
    }, n.getSegmentSize = function (t, e) {
        var i = t + e, n = "outer" + e;
        if (this._getMeasurement(i, n), !this[i]) {
            var o = this.getFirstItemSize();
            this[i] = o && o[n] || this.isotope.size["inner" + e]
        }
    }, n.getFirstItemSize = function () {
        var e = this.isotope.filteredItems[0];
        return e && e.element && t(e.element)
    }, n.layout = function () {
        this.isotope.layout.apply(this.isotope, arguments)
    }, n.getSize = function () {
        this.isotope.getSize(), this.size = this.isotope.size
    }, i.modes = {}, i.create = function (t, e) {
        function o() {
            i.apply(this, arguments)
        }

        return o.prototype = Object.create(n), o.prototype.constructor = o, e && (o.options = e), o.prototype.namespace = t, i.modes[t] = o, o
    }, i
}), function (t, e) {
    "function" == typeof define && define.amd ? define("masonry/masonry", ["outlayer/outlayer", "get-size/get-size"], e) : "object" == typeof module && module.exports ? module.exports = e(require("outlayer"), require("get-size")) : t.Masonry = e(t.Outlayer, t.getSize)
}(window, function (t, e) {
    var i = t.create("masonry");
    return i.compatOptions.fitWidth = "isFitWidth", i.prototype._resetLayout = function () {
        this.getSize(), this._getMeasurement("columnWidth", "outerWidth"), this._getMeasurement("gutter", "outerWidth"), this.measureColumns(), this.colYs = [];
        for (var t = 0; t < this.cols; t++)this.colYs.push(0);
        this.maxY = 0
    }, i.prototype.measureColumns = function () {
        if (this.getContainerWidth(), !this.columnWidth) {
            var t = this.items[0], i = t && t.element;
            this.columnWidth = i && e(i).outerWidth || this.containerWidth
        }
        var n = this.columnWidth += this.gutter, o = this.containerWidth + this.gutter, r = o / n, s = n - o % n,
            a = s && 1 > s ? "round" : "floor";
        r = Math[a](r), this.cols = Math.max(r, 1)
    }, i.prototype.getContainerWidth = function () {
        var t = this._getOption("fitWidth"), i = t ? this.element.parentNode : this.element, n = e(i);
        this.containerWidth = n && n.innerWidth
    }, i.prototype._getItemLayoutPosition = function (t) {
        t.getSize();
        var e = t.size.outerWidth % this.columnWidth, i = e && 1 > e ? "round" : "ceil",
            n = Math[i](t.size.outerWidth / this.columnWidth);
        n = Math.min(n, this.cols);
        for (var o = this._getColGroup(n), r = Math.min.apply(Math, o), s = o.indexOf(r),
                 a = {x: this.columnWidth * s, y: r}, u = r + t.size.outerHeight, h = this.cols + 1 - o.length,
                 d = 0; h > d; d++)this.colYs[s + d] = u;
        return a
    }, i.prototype._getColGroup = function (t) {
        if (2 > t)return this.colYs;
        for (var e = [], i = this.cols + 1 - t, n = 0; i > n; n++) {
            var o = this.colYs.slice(n, n + t);
            e[n] = Math.max.apply(Math, o)
        }
        return e
    }, i.prototype._manageStamp = function (t) {
        var i = e(t), n = this._getElementOffset(t), o = this._getOption("originLeft"), r = o ? n.left : n.right,
            s = r + i.outerWidth, a = Math.floor(r / this.columnWidth);
        a = Math.max(0, a);
        var u = Math.floor(s / this.columnWidth);
        u -= s % this.columnWidth ? 0 : 1, u = Math.min(this.cols - 1, u);
        for (var h = this._getOption("originTop"), d = (h ? n.top : n.bottom) + i.outerHeight,
                 l = a; u >= l; l++)this.colYs[l] = Math.max(d, this.colYs[l])
    }, i.prototype._getContainerSize = function () {
        this.maxY = Math.max.apply(Math, this.colYs);
        var t = {height: this.maxY};
        return this._getOption("fitWidth") && (t.width = this._getContainerFitWidth()), t
    }, i.prototype._getContainerFitWidth = function () {
        for (var t = 0, e = this.cols; --e && 0 === this.colYs[e];)t++;
        return (this.cols - t) * this.columnWidth - this.gutter
    }, i.prototype.needsResizeLayout = function () {
        var t = this.containerWidth;
        return this.getContainerWidth(), t != this.containerWidth
    }, i
}), function (t, e) {
    "function" == typeof define && define.amd ? define("isotope/layout-modes/masonry", ["../layout-mode", "masonry/masonry"], e) : "object" == typeof module && module.exports ? module.exports = e(require("../layout-mode"), require("masonry-layout")) : e(t.Isotope.LayoutMode, t.Masonry)
}(window, function (t, e) {
    "use strict";
    var i = t.create("masonry"), n = i.prototype, o = {_getElementOffset: !0, layout: !0, _getMeasurement: !0};
    for (var r in e.prototype)o[r] || (n[r] = e.prototype[r]);
    var s = n.measureColumns;
    n.measureColumns = function () {
        this.items = this.isotope.filteredItems, s.call(this)
    };
    var a = n._getOption;
    return n._getOption = function (t) {
        return "fitWidth" == t ? void 0 !== this.options.isFitWidth ? this.options.isFitWidth : this.options.fitWidth : a.apply(this.isotope, arguments)
    }, i
}), function (t, e) {
    "function" == typeof define && define.amd ? define("isotope/layout-modes/fit-rows", ["../layout-mode"], e) : "object" == typeof exports ? module.exports = e(require("../layout-mode")) : e(t.Isotope.LayoutMode)
}(window, function (t) {
    "use strict";
    var e = t.create("fitRows"), i = e.prototype;
    return i._resetLayout = function () {
        this.x = 0, this.y = 0, this.maxY = 0, this._getMeasurement("gutter", "outerWidth")
    }, i._getItemLayoutPosition = function (t) {
        t.getSize();
        var e = t.size.outerWidth + this.gutter, i = this.isotope.size.innerWidth + this.gutter;
        0 !== this.x && e + this.x > i && (this.x = 0, this.y = this.maxY);
        var n = {x: this.x, y: this.y};
        return this.maxY = Math.max(this.maxY, this.y + t.size.outerHeight), this.x += e, n
    }, i._getContainerSize = function () {
        return {height: this.maxY}
    }, e
}), function (t, e) {
    "function" == typeof define && define.amd ? define("isotope/layout-modes/vertical", ["../layout-mode"], e) : "object" == typeof module && module.exports ? module.exports = e(require("../layout-mode")) : e(t.Isotope.LayoutMode)
}(window, function (t) {
    "use strict";
    var e = t.create("vertical", {horizontalAlignment: 0}), i = e.prototype;
    return i._resetLayout = function () {
        this.y = 0
    }, i._getItemLayoutPosition = function (t) {
        t.getSize();
        var e = (this.isotope.size.innerWidth - t.size.outerWidth) * this.options.horizontalAlignment, i = this.y;
        return this.y += t.size.outerHeight, {x: e, y: i}
    }, i._getContainerSize = function () {
        return {height: this.y}
    }, e
}), function (t, e) {
    "function" == typeof define && define.amd ? define(["outlayer/outlayer", "get-size/get-size", "desandro-matches-selector/matches-selector", "fizzy-ui-utils/utils", "./item", "./layout-mode", "./layout-modes/masonry", "./layout-modes/fit-rows", "./layout-modes/vertical"], function (i, n, o, r, s, a) {
        return e(t, i, n, o, r, s, a)
    }) : "object" == typeof module && module.exports ? module.exports = e(t, require("outlayer"), require("get-size"), require("desandro-matches-selector"), require("fizzy-ui-utils"), require("./item"), require("./layout-mode"), require("./layout-modes/masonry"), require("./layout-modes/fit-rows"), require("./layout-modes/vertical")) : t.Isotope = e(t, t.Outlayer, t.getSize, t.matchesSelector, t.fizzyUIUtils, t.Isotope.Item, t.Isotope.LayoutMode)
}(window, function (t, e, i, n, o, r, s) {
    function a(t, e) {
        return function (i, n) {
            for (var o = 0; o < t.length; o++) {
                var r = t[o], s = i.sortData[r], a = n.sortData[r];
                if (s > a || a > s) {
                    var u = void 0 !== e[r] ? e[r] : e, h = u ? 1 : -1;
                    return (s > a ? 1 : -1) * h
                }
            }
            return 0
        }
    }

    var u = t.jQuery, h = String.prototype.trim ? function (t) {
        return t.trim()
    } : function (t) {
        return t.replace(/^\s+|\s+$/g, "")
    }, d = e.create("isotope", {layoutMode: "masonry", isJQueryFiltering: !0, sortAscending: !0});
    d.Item = r, d.LayoutMode = s;
    var l = d.prototype;
    l._create = function () {
        this.itemGUID = 0, this._sorters = {}, this._getSorters(), e.prototype._create.call(this), this.modes = {}, this.filteredItems = this.items, this.sortHistory = ["original-order"];
        for (var t in s.modes)this._initLayoutMode(t)
    }, l.reloadItems = function () {
        this.itemGUID = 0, e.prototype.reloadItems.call(this)
    }, l._itemize = function () {
        for (var t = e.prototype._itemize.apply(this, arguments), i = 0; i < t.length; i++) {
            var n = t[i];
            n.id = this.itemGUID++
        }
        return this._updateItemsSortData(t), t
    }, l._initLayoutMode = function (t) {
        var e = s.modes[t], i = this.options[t] || {};
        this.options[t] = e.options ? o.extend(e.options, i) : i, this.modes[t] = new e(this)
    }, l.layout = function () {
        return !this._isLayoutInited && this._getOption("initLayout") ? void this.arrange() : void this._layout()
    }, l._layout = function () {
        var t = this._getIsInstant();
        this._resetLayout(), this._manageStamps(), this.layoutItems(this.filteredItems, t), this._isLayoutInited = !0
    }, l.arrange = function (t) {
        this.option(t), this._getIsInstant();
        var e = this._filter(this.items);
        this.filteredItems = e.matches, this._bindArrangeComplete(), this._isInstant ? this._noTransition(this._hideReveal, [e]) : this._hideReveal(e), this._sort(), this._layout()
    }, l._init = l.arrange, l._hideReveal = function (t) {
        this.reveal(t.needReveal), this.hide(t.needHide)
    }, l._getIsInstant = function () {
        var t = this._getOption("layoutInstant"), e = void 0 !== t ? t : !this._isLayoutInited;
        return this._isInstant = e, e
    }, l._bindArrangeComplete = function () {
        function t() {
            e && i && n && o.dispatchEvent("arrangeComplete", null, [o.filteredItems])
        }

        var e, i, n, o = this;
        this.once("layoutComplete", function () {
            e = !0, t()
        }), this.once("hideComplete", function () {
            i = !0, t()
        }), this.once("revealComplete", function () {
            n = !0, t()
        })
    }, l._filter = function (t) {
        var e = this.options.filter;
        e = e || "*";
        for (var i = [], n = [], o = [], r = this._getFilterTest(e), s = 0; s < t.length; s++) {
            var a = t[s];
            if (!a.isIgnored) {
                var u = r(a);
                u && i.push(a), u && a.isHidden ? n.push(a) : u || a.isHidden || o.push(a)
            }
        }
        return {matches: i, needReveal: n, needHide: o}
    }, l._getFilterTest = function (t) {
        return u && this.options.isJQueryFiltering ? function (e) {
            return u(e.element).is(t)
        } : "function" == typeof t ? function (e) {
            return t(e.element)
        } : function (e) {
            return n(e.element, t)
        }
    }, l.updateSortData = function (t) {
        var e;
        t ? (t = o.makeArray(t), e = this.getItems(t)) : e = this.items, this._getSorters(), this._updateItemsSortData(e)
    }, l._getSorters = function () {
        var t = this.options.getSortData;
        for (var e in t) {
            var i = t[e];
            this._sorters[e] = f(i)
        }
    }, l._updateItemsSortData = function (t) {
        for (var e = t && t.length, i = 0; e && e > i; i++) {
            var n = t[i];
            n.updateSortData()
        }
    };
    var f = function () {
        function t(t) {
            if ("string" != typeof t)return t;
            var i = h(t).split(" "), n = i[0], o = n.match(/^\[(.+)\]$/), r = o && o[1], s = e(r, n),
                a = d.sortDataParsers[i[1]];
            return t = a ? function (t) {
                return t && a(s(t))
            } : function (t) {
                return t && s(t)
            }
        }

        function e(t, e) {
            return t ? function (e) {
                return e.getAttribute(t)
            } : function (t) {
                var i = t.querySelector(e);

                return i && i.textContent
            }
        }

        return t
    }();
    d.sortDataParsers = {
        parseInt: function (t) {
            return parseInt(t, 10)
        }, parseFloat: function (t) {
            return parseFloat(t)
        }
    }, l._sort = function () {
        var t = this.options.sortBy;
        if (t) {
            var e = [].concat.apply(t, this.sortHistory), i = a(e, this.options.sortAscending);
            this.filteredItems.sort(i), t != this.sortHistory[0] && this.sortHistory.unshift(t)
        }
    }, l._mode = function () {
        var t = this.options.layoutMode, e = this.modes[t];
        if (!e)throw new Error("No layout mode: " + t);
        return e.options = this.options[t], e
    }, l._resetLayout = function () {
        e.prototype._resetLayout.call(this), this._mode()._resetLayout()
    }, l._getItemLayoutPosition = function (t) {
        return this._mode()._getItemLayoutPosition(t)
    }, l._manageStamp = function (t) {
        this._mode()._manageStamp(t)
    }, l._getContainerSize = function () {
        return this._mode()._getContainerSize()
    }, l.needsResizeLayout = function () {
        return this._mode().needsResizeLayout()
    }, l.appended = function (t) {
        var e = this.addItems(t);
        if (e.length) {
            var i = this._filterRevealAdded(e);
            this.filteredItems = this.filteredItems.concat(i)
        }
    }, l.prepended = function (t) {
        var e = this._itemize(t);
        if (e.length) {
            this._resetLayout(), this._manageStamps();
            var i = this._filterRevealAdded(e);
            this.layoutItems(this.filteredItems), this.filteredItems = i.concat(this.filteredItems), this.items = e.concat(this.items)
        }
    }, l._filterRevealAdded = function (t) {
        var e = this._filter(t);
        return this.hide(e.needHide), this.reveal(e.matches), this.layoutItems(e.matches, !0), e.matches
    }, l.insert = function (t) {
        var e = this.addItems(t);
        if (e.length) {
            var i, n, o = e.length;
            for (i = 0; o > i; i++)n = e[i], this.element.appendChild(n.element);
            var r = this._filter(e).matches;
            for (i = 0; o > i; i++)e[i].isLayoutInstant = !0;
            for (this.arrange(), i = 0; o > i; i++)delete e[i].isLayoutInstant;
            this.reveal(r)
        }
    };
    var c = l.remove;
    return l.remove = function (t) {
        t = o.makeArray(t);
        var e = this.getItems(t);
        c.call(this, t);
        for (var i = e && e.length, n = 0; i && i > n; n++) {
            var r = e[n];
            o.removeFrom(this.filteredItems, r)
        }
    }, l.shuffle = function () {
        for (var t = 0; t < this.items.length; t++) {
            var e = this.items[t];
            e.sortData.random = Math.random()
        }
        this.options.sortBy = "random", this._sort(), this._layout()
    }, l._noTransition = function (t, e) {
        var i = this.options.transitionDuration;
        this.options.transitionDuration = 0;
        var n = t.apply(this, e);
        return this.options.transitionDuration = i, n
    }, l.getFilteredItemElements = function () {
        return this.filteredItems.map(function (t) {
            return t.element
        })
    }, d
});


/*!

 * jQuery Upload File Plugin

 * version: 1.9

 * @requires jQuery v1.5 or later & form plugin

 * Copyright (c) 2013 Ravishanker Kusuma

 * http://hayageek.com/

 */

(function (a) {
    a.fn.uploadFile = function (b) {
        var c = a.extend({
            url: "",
            method: "POST",
            enctype: "multipart/form-data",
            formData: null,
            returnType: null,
            allowedTypes: "*",
            fileName: "userpro_file",
            multiple: false,
            autoSubmit: true,
            showCancel: false,
            showAbort: false,
            showDone: false,
            showStatusAfterSuccess: true,
            buttonCss: false,
            buttonClass: false,
            onSubmit: function (e) {
            },
            onSuccess: function (f, e) {
            },
            onError: function (f, e) {
            },
            uploadButtonClass: "ajax-file-upload"
        }, b);
        var d = "ajax-file-upload-" + a(this).attr("id");
        this.formGroup = d;
        a(this).click(function () {
            a.fn.uploadFile.createAjaxForm(this, d, c)
        });
        this.startUpload = function () {
            a("." + this.formGroup).each(function (f, e) {
                a(this).submit()
            })
        };
        a(this).addClass(c.uploadButtonClass);
        return this
    };
    a.fn.uploadFile.createAjaxForm = function (g, l, o) {
        var d = a("<form style='display:none;' class='" + l + "' method='" + o.method + "' action='" + o.url + "' enctype='" + o.enctype + "'></form>");
        var c = "<input type='file' name='" + o.fileName + "'/>";
        if (o.multiple) {
            if (o.fileName.indexOf("[]") != o.fileName.length - 2) {
                o.fileName += "[]"
            }
            c = "<input type='file' name='" + o.fileName + "' multiple/>"
        }
        var h = a(c).appendTo(d);
        var k = a("<div class='ajax-file-upload-statusbar'></div>");
        var b = a("").appendTo(k);
        var n = a("<div class='ajax-file-upload-progress'>").appendTo(k).hide();
        var j = a("<div class='ajax-file-upload-bar'></div>").appendTo(n);
        var f = a("").appendTo(k).hide();
        var m = a("<div class='ajax-file-upload-red'>Cancel</div>").appendTo(k).hide();
        var e = a("").appendTo(k).hide();
        a(h).change(function () {
            var v = o.allowedTypes.toLowerCase().split(",");
            var r = "";
            var q = [];
            if (this.files) {
                for (i = 0; i < this.files.length; i++) {
                    var t = this.files[i].name;
                    q.push(t);
                    var u = t.split(".").pop().toLowerCase();
                    if (o.allowedTypes != "*" && jQuery.inArray(u, v) < 0) {
                        alert("File type is not allowed. Allowed only: " + o.allowedTypes);
                        a(d).remove();
                        return
                    }
                    r += t;
                    if (this.files.length != 0) {
                        r += ""
                    }
                }
            } else {
                var t = a(this).val();
                q.push(t);
                var u = t.split(".").pop().toLowerCase();
                if (o.allowedTypes != "*" && jQuery.inArray(u, v) < 0) {
                    alert("File type is not allowed. Allowed only: " + o.allowedTypes);
                    a(d).remove();
                    return
                }
                r = t
            }
            a("body").append(d);
            a(g).after(k);
            a(b).html(r);
            var s = null;
            var p = {
                forceSync: false, data: o.formData, dataType: o.returnType, beforeSend: function (x, w) {
                    o.onSubmit.call(this, q);
                    a(n).show();
                    a(m).hide();
                    a(e).hide();
                    if (o.showAbort) {
                        a(f).show();
                        a(f).click(function () {
                            x.abort()
                        })
                    }
                }, uploadProgress: function (A, w, z, y) {
                    var x = y + "%";
                    a(j).width(x)
                }, success: function (x, w, y) {
                    a(f).hide();
                    o.onSuccess.call(this, q, x, y);
                    if (o.showStatusAfterSuccess) {
                        if (o.showDone) {
                            a(e).show();
                            a(e).click(function () {
                                a(k).hide("slow")
                            })
                        } else {
                            a(e).hide()
                        }
                        a(j).width("100%")
                    } else {
                        a(k).hide("slow")
                    }
                    a(d).remove()
                }, error: function (y, w, x) {
                    if (y.statusText == "abort") {
                        a(k).hide("slow")
                    } else {
                        o.onError.call(this, q, w, x);
                        a(n).hide();
                        a(k).append("<font color='red'>ERROR: " + x + "</font>")
                    }
                    a(f).hide();
                    a(d).remove()
                }
            };
            if (o.autoSubmit) {
                a(d).ajaxSubmit(p)
            } else {
                if (o.showCancel) {
                    a(m).show();
                    a(m).click(function () {
                        a(d).remove();
                        a(k).remove()
                    })
                }
                a(d).ajaxForm(p)
            }
        });
        a(h).click()
    };
    if (a.fn.ajaxForm == undefined) {

        /*!

         * jQuery Form Plugin

         * version: 3.40.0-2013.08.13

         * @requires jQuery v1.5 or later

         * Copyright (c) 2013 M. Alsup

         * Examples and documentation at: http://malsup.com/jquery/form/

         * Project repository: https://github.com/malsup/form

         * Dual licensed under the MIT and GPL licenses.

         * https://github.com/malsup/form#copyright-and-license

         */

        ;
        (function (g) {
            var d = {};
            d.fileapi = g("<input type='file'/>").get(0).files !== undefined;
            d.formdata = window.FormData !== undefined;
            var f = !!g.fn.prop;
            g.fn.attr2 = function () {
                if (!f) {
                    return this.attr.apply(this, arguments)
                }
                var h = this.prop.apply(this, arguments);
                if ((h && h.jquery) || typeof h === "string") {
                    return h
                }
                return this.attr.apply(this, arguments)
            };
            g.fn.ajaxSubmit = function (m) {
                if (!this.length) {
                    e("ajaxSubmit: skipping submit process - no element selected");
                    return this
                }
                var l, E, o, r = this;
                if (typeof m == "function") {
                    m = {success: m}
                } else {
                    if (m === undefined) {
                        m = {}
                    }
                }
                l = m.type || this.attr2("method");
                E = m.url || this.attr2("action");
                o = (typeof E === "string") ? g.trim(E) : "";
                o = o || window.location.href || "";
                if (o) {
                    o = (o.match(/^([^#]+)/) || [])[1]
                }
                m = g.extend(true, {
                    url: o,
                    success: g.ajaxSettings.success,
                    type: l || g.ajaxSettings.type,
                    iframeSrc: /^https/i.test(window.location.href || "") ? "javascript:false" : "about:blank"
                }, m);
                var w = {};
                this.trigger("form-pre-serialize", [this, m, w]);
                if (w.veto) {
                    e("ajaxSubmit: submit vetoed via form-pre-serialize trigger");
                    return this
                }
                if (m.beforeSerialize && m.beforeSerialize(this, m) === false) {
                    e("ajaxSubmit: submit aborted via beforeSerialize callback");
                    return this
                }
                var p = m.traditional;
                if (p === undefined) {
                    p = g.ajaxSettings.traditional
                }
                var u = [];
                var G, H = this.formToArray(m.semantic, u);
                if (m.data) {
                    m.extraData = m.data;
                    G = g.param(m.data, p)
                }
                if (m.beforeSubmit && m.beforeSubmit(H, this, m) === false) {
                    e("ajaxSubmit: submit aborted via beforeSubmit callback");
                    return this
                }
                this.trigger("form-submit-validate", [H, this, m, w]);
                if (w.veto) {
                    e("ajaxSubmit: submit vetoed via form-submit-validate trigger");
                    return this
                }
                var A = g.param(H, p);
                if (G) {
                    A = (A ? (A + "&" + G) : G)
                }
                if (m.type.toUpperCase() == "GET") {
                    m.url += (m.url.indexOf("?") >= 0 ? "&" : "?") + A;
                    m.data = null
                } else {
                    m.data = A
                }
                var J = [];
                if (m.resetForm) {
                    J.push(function () {
                        r.resetForm()
                    })
                }
                if (m.clearForm) {
                    J.push(function () {
                        r.clearForm(m.includeHidden)
                    })
                }
                if (!m.dataType && m.target) {
                    var n = m.success || function () {
                        };
                    J.push(function (q) {
                        var k = m.replaceTarget ? "replaceWith" : "html";
                        g(m.target)[k](q).each(n, arguments)
                    })
                } else {
                    if (m.success) {
                        J.push(m.success)
                    }
                }
                m.success = function (M, q, N) {
                    var L = m.context || this;
                    for (var K = 0, k = J.length; K < k; K++) {
                        J[K].apply(L, [M, q, N || r, r])
                    }
                };
                if (m.error) {
                    var B = m.error;
                    m.error = function (L, k, q) {
                        var K = m.context || this;
                        B.apply(K, [L, k, q, r])
                    }
                }
                if (m.complete) {
                    var j = m.complete;
                    m.complete = function (K, k) {
                        var q = m.context || this;
                        j.apply(q, [K, k, r])
                    }
                }
                var F = g('input[type=file]:enabled:not([value=""])', this);
                var s = F.length > 0;
                var D = "multipart/form-data";
                var z = (r.attr("enctype") == D || r.attr("encoding") == D);
                var y = d.fileapi && d.formdata;
                e("fileAPI :" + y);
                var t = (s || z) && !y;
                var x;
                if (m.iframe !== false && (m.iframe || t)) {
                    if (m.closeKeepAlive) {
                        g.get(m.closeKeepAlive, function () {
                            x = I(H)
                        })
                    } else {
                        x = I(H)
                    }
                } else {
                    if ((s || z) && y) {
                        x = v(H)
                    } else {
                        x = g.ajax(m)
                    }
                }
                r.removeData("jqxhr").data("jqxhr", x);
                for (var C = 0; C < u.length; C++) {
                    u[C] = null
                }
                this.trigger("form-submit-notify", [this, m]);
                return this;
                function h(M) {
                    var N = g.param(M, m.traditional).split("&");
                    var q = N.length;
                    var k = [];
                    var L, K;
                    for (L = 0; L < q; L++) {
                        N[L] = N[L].replace(/\+/g, " ");
                        K = N[L].split("=");
                        k.push([decodeURIComponent(K[0]), decodeURIComponent(K[1])])
                    }
                    return k
                }

                function v(q) {
                    var k = new FormData();
                    for (var K = 0; K < q.length; K++) {
                        k.append(q[K].name, q[K].value)
                    }
                    if (m.extraData) {
                        var N = h(m.extraData);
                        for (K = 0; K < N.length; K++) {
                            if (N[K]) {
                                k.append(N[K][0], N[K][1])
                            }
                        }
                    }
                    m.data = null;
                    var M = g.extend(true, {}, g.ajaxSettings, m, {
                        contentType: false,
                        processData: false,
                        cache: false,
                        type: l || "POST"
                    });
                    if (m.uploadProgress) {
                        M.xhr = function () {
                            var O = g.ajaxSettings.xhr();
                            if (O.upload) {
                                O.upload.addEventListener("progress", function (S) {
                                    var R = 0;
                                    var P = S.loaded || S.position;
                                    var Q = S.total;
                                    if (S.lengthComputable) {
                                        R = Math.ceil(P / Q * 100)
                                    }
                                    m.uploadProgress(S, P, Q, R)
                                }, false)
                            }
                            return O
                        }
                    }
                    M.data = null;
                    var L = M.beforeSend;
                    M.beforeSend = function (P, O) {
                        O.data = k;
                        if (L) {
                            L.call(this, P, O)
                        }
                    };
                    return g.ajax(M)
                }

                function I(ah) {
                    var N = r[0], M, ad, X, af, aa, P, S, Q, R, ab, ae, V;
                    var ak = g.Deferred();
                    ak.abort = function (al) {
                        Q.abort(al)
                    };
                    if (ah) {
                        for (ad = 0; ad < u.length; ad++) {
                            M = g(u[ad]);
                            if (f) {
                                M.prop("disabled", false)
                            } else {
                                M.removeAttr("disabled")
                            }
                        }
                    }
                    X = g.extend(true, {}, g.ajaxSettings, m);
                    X.context = X.context || X;
                    aa = "jqFormIO" + (new Date().getTime());
                    if (X.iframeTarget) {
                        P = g(X.iframeTarget);
                        ab = P.attr2("name");
                        if (!ab) {
                            P.attr2("name", aa)
                        } else {
                            aa = ab
                        }
                    } else {
                        P = g('<iframe name="' + aa + '" src="' + X.iframeSrc + '" />');
                        P.css({position: "absolute", top: "-1000px", left: "-1000px"})
                    }
                    S = P[0];
                    Q = {
                        aborted: 0,
                        responseText: null,
                        responseXML: null,
                        status: 0,
                        statusText: "n/a",
                        getAllResponseHeaders: function () {
                        },
                        getResponseHeader: function () {
                        },
                        setRequestHeader: function () {
                        },
                        abort: function (al) {
                            var am = (al === "timeout" ? "timeout" : "aborted");
                            e("aborting upload... " + am);
                            this.aborted = 1;
                            try {
                                if (S.contentWindow.document.execCommand) {
                                    S.contentWindow.document.execCommand("Stop")
                                }
                            } catch (an) {
                            }
                            P.attr("src", X.iframeSrc);
                            Q.error = am;
                            if (X.error) {
                                X.error.call(X.context, Q, am, al)
                            }
                            if (af) {
                                g.event.trigger("ajaxError", [Q, X, am])
                            }
                            if (X.complete) {
                                X.complete.call(X.context, Q, am)
                            }
                        }
                    };
                    af = X.global;
                    if (af && 0 === g.active++) {
                        g.event.trigger("ajaxStart")
                    }
                    if (af) {
                        g.event.trigger("ajaxSend", [Q, X])
                    }
                    if (X.beforeSend && X.beforeSend.call(X.context, Q, X) === false) {
                        if (X.global) {
                            g.active--
                        }
                        ak.reject();
                        return ak
                    }
                    if (Q.aborted) {
                        ak.reject();
                        return ak
                    }
                    R = N.clk;
                    if (R) {
                        ab = R.name;
                        if (ab && !R.disabled) {
                            X.extraData = X.extraData || {};
                            X.extraData[ab] = R.value;
                            if (R.type == "image") {
                                X.extraData[ab + ".x"] = N.clk_x;
                                X.extraData[ab + ".y"] = N.clk_y
                            }
                        }
                    }
                    var W = 1;
                    var T = 2;

                    function U(an) {
                        var am = null;
                        try {
                            if (an.contentWindow) {
                                am = an.contentWindow.document
                            }
                        } catch (al) {
                            e("cannot get iframe.contentWindow document: " + al)
                        }
                        if (am) {
                            return am
                        }
                        try {
                            am = an.contentDocument ? an.contentDocument : an.document
                        } catch (al) {
                            e("cannot get iframe.contentDocument: " + al);
                            am = an.document
                        }
                        return am
                    }

                    var L = g("meta[name=csrf-token]").attr("content");
                    var K = g("meta[name=csrf-param]").attr("content");
                    if (K && L) {
                        X.extraData = X.extraData || {};
                        X.extraData[K] = L
                    }
                    function ac() {
                        var an = r.attr2("target"), al = r.attr2("action");
                        N.setAttribute("target", aa);
                        if (!l) {
                            N.setAttribute("method", "POST")
                        }
                        if (al != X.url) {
                            N.setAttribute("action", X.url)
                        }
                        if (!X.skipEncodingOverride && (!l || /post/i.test(l))) {
                            r.attr({encoding: "multipart/form-data", enctype: "multipart/form-data"})
                        }
                        if (X.timeout) {
                            V = setTimeout(function () {
                                ae = true;
                                Z(W)
                            }, X.timeout)
                        }
                        function ao() {
                            try {
                                var at = U(S).readyState;
                                e("state = " + at);
                                if (at && at.toLowerCase() == "uninitialized") {
                                    setTimeout(ao, 50)
                                }
                            } catch (au) {
                                e("Server abort: ", au, " (", au.name, ")");
                                Z(T);
                                if (V) {
                                    clearTimeout(V)
                                }
                                V = undefined
                            }
                        }

                        var am = [];
                        try {
                            if (X.extraData) {
                                for (var ar in X.extraData) {
                                    if (X.extraData.hasOwnProperty(ar)) {
                                        if (g.isPlainObject(X.extraData[ar]) && X.extraData[ar].hasOwnProperty("name") && X.extraData[ar].hasOwnProperty("value")) {
                                            am.push(g('<input type="hidden" name="' + X.extraData[ar].name + '">').val(X.extraData[ar].value).appendTo(N)[0])
                                        } else {
                                            am.push(g('<input type="hidden" name="' + ar + '">').val(X.extraData[ar]).appendTo(N)[0])
                                        }
                                    }
                                }
                            }
                            if (!X.iframeTarget) {
                                P.appendTo("body");
                                if (S.attachEvent) {
                                    S.attachEvent("onload", Z)
                                } else {
                                    S.addEventListener("load", Z, false)
                                }
                            }
                            setTimeout(ao, 15);
                            try {
                                N.submit()
                            } catch (ap) {
                                var aq = document.createElement("form").submit;
                                aq.apply(N)
                            }
                        } finally {
                            N.setAttribute("action", al);
                            if (an) {
                                N.setAttribute("target", an)
                            } else {
                                r.removeAttr("target")
                            }
                            g(am).remove()
                        }
                    }

                    if (X.forceSync) {
                        ac()
                    } else {
                        setTimeout(ac, 10)
                    }
                    var ai, aj, ag = 50, O;

                    function Z(ar) {
                        if (Q.aborted || O) {
                            return
                        }
                        aj = U(S);
                        if (!aj) {
                            e("cannot access response document");
                            ar = T
                        }
                        if (ar === W && Q) {
                            Q.abort("timeout");
                            ak.reject(Q, "timeout");
                            return
                        } else {
                            if (ar == T && Q) {
                                Q.abort("server abort");
                                ak.reject(Q, "error", "server abort");
                                return
                            }
                        }
                        if (!aj || aj.location.href == X.iframeSrc) {
                            if (!ae) {
                                return
                            }
                        }
                        if (S.detachEvent) {
                            S.detachEvent("onload", Z)
                        } else {
                            S.removeEventListener("load", Z, false)
                        }
                        var ap = "success", au;
                        try {
                            if (ae) {
                                throw"timeout"
                            }
                            var ao = X.dataType == "xml" || aj.XMLDocument || g.isXMLDoc(aj);
                            e("isXml=" + ao);
                            if (!ao && window.opera && (aj.body === null || !aj.body.innerHTML)) {
                                if (--ag) {
                                    e("requeing onLoad callback, DOM not available");
                                    setTimeout(Z, 250);
                                    return
                                }
                            }
                            var av = aj.body ? aj.body : aj.documentElement;
                            Q.responseText = av ? av.innerHTML : null;
                            Q.responseXML = aj.XMLDocument ? aj.XMLDocument : aj;
                            if (ao) {
                                X.dataType = "xml"
                            }
                            Q.getResponseHeader = function (ay) {
                                var ax = {"content-type": X.dataType};
                                return ax[ay.toLowerCase()]
                            };
                            if (av) {
                                Q.status = Number(av.getAttribute("status")) || Q.status;
                                Q.statusText = av.getAttribute("statusText") || Q.statusText
                            }
                            var al = (X.dataType || "").toLowerCase();
                            var at = /(json|script|text)/.test(al);
                            if (at || X.textarea) {
                                var aq = aj.getElementsByTagName("textarea")[0];
                                if (aq) {
                                    Q.responseText = aq.value;
                                    Q.status = Number(aq.getAttribute("status")) || Q.status;
                                    Q.statusText = aq.getAttribute("statusText") || Q.statusText
                                } else {
                                    if (at) {
                                        var am = aj.getElementsByTagName("pre")[0];
                                        var aw = aj.getElementsByTagName("body")[0];
                                        if (am) {
                                            Q.responseText = am.textContent ? am.textContent : am.innerText
                                        } else {
                                            if (aw) {
                                                Q.responseText = aw.textContent ? aw.textContent : aw.innerText
                                            }
                                        }
                                    }
                                }
                            } else {
                                if (al == "xml" && !Q.responseXML && Q.responseText) {
                                    Q.responseXML = Y(Q.responseText)
                                }
                            }
                            try {
                                ai = k(Q, al, X)
                            } catch (an) {
                                ap = "parsererror";
                                Q.error = au = (an || ap)
                            }
                        } catch (an) {
                            e("error caught: ", an);
                            ap = "error";
                            Q.error = au = (an || ap)
                        }
                        if (Q.aborted) {
                            e("upload aborted");
                            ap = null
                        }
                        if (Q.status) {
                            ap = (Q.status >= 200 && Q.status < 300 || Q.status === 304) ? "success" : "error"
                        }
                        if (ap === "success") {
                            if (X.success) {
                                X.success.call(X.context, ai, "success", Q)
                            }
                            ak.resolve(Q.responseText, "success", Q);
                            if (af) {
                                g.event.trigger("ajaxSuccess", [Q, X])
                            }
                        } else {
                            if (ap) {
                                if (au === undefined) {
                                    au = Q.statusText
                                }
                                if (X.error) {
                                    X.error.call(X.context, Q, ap, au)
                                }
                                ak.reject(Q, "error", au);
                                if (af) {
                                    g.event.trigger("ajaxError", [Q, X, au])
                                }
                            }
                        }
                        if (af) {
                            g.event.trigger("ajaxComplete", [Q, X])
                        }
                        if (af && !--g.active) {
                            g.event.trigger("ajaxStop")
                        }
                        if (X.complete) {
                            X.complete.call(X.context, Q, ap)
                        }
                        O = true;
                        if (X.timeout) {
                            clearTimeout(V)
                        }
                        setTimeout(function () {
                            if (!X.iframeTarget) {
                                P.remove()
                            }
                            Q.responseXML = null
                        }, 100)
                    }

                    var Y = g.parseXML || function (al, am) {
                            if (window.ActiveXObject) {
                                am = new ActiveXObject("Microsoft.XMLDOM");
                                am.async = "false";
                                am.loadXML(al)
                            } else {
                                am = (new DOMParser()).parseFromString(al, "text/xml")
                            }
                            return (am && am.documentElement && am.documentElement.nodeName != "parsererror") ? am : null
                        };
                    var q = g.parseJSON || function (al) {
                            return window["eval"]("(" + al + ")")
                        };
                    var k = function (aq, ao, an) {
                        var am = aq.getResponseHeader("content-type") || "",
                            al = ao === "xml" || !ao && am.indexOf("xml") >= 0,
                            ap = al ? aq.responseXML : aq.responseText;
                        if (al && ap.documentElement.nodeName === "parsererror") {
                            if (g.error) {
                                g.error("parsererror")
                            }
                        }
                        if (an && an.dataFilter) {
                            ap = an.dataFilter(ap, ao)
                        }
                        if (typeof ap === "string") {
                            if (ao === "json" || !ao && am.indexOf("json") >= 0) {
                                ap = q(ap)
                            } else {
                                if (ao === "script" || !ao && am.indexOf("javascript") >= 0) {
                                    g.globalEval(ap)
                                }
                            }
                        }
                        return ap
                    };
                    return ak
                }
            };
            g.fn.ajaxForm = function (h) {
                h = h || {};
                h.delegation = h.delegation && g.isFunction(g.fn.on);
                if (!h.delegation && this.length === 0) {
                    var j = {s: this.selector, c: this.context};
                    if (!g.isReady && j.s) {
                        e("DOM not ready, queuing ajaxForm");
                        g(function () {
                            g(j.s, j.c).ajaxForm(h)
                        });
                        return this
                    }
                    e("terminating; zero elements found by selector" + (g.isReady ? "" : " (DOM not ready)"));
                    return this
                }
                if (h.delegation) {
                    g(document).off("submit.form-plugin", this.selector, c).off("click.form-plugin", this.selector, b).on("submit.form-plugin", this.selector, h, c).on("click.form-plugin", this.selector, h, b);
                    return this
                }
                return this.ajaxFormUnbind().bind("submit.form-plugin", h, c).bind("click.form-plugin", h, b)
            };
            function c(j) {
                var h = j.data;
                if (!j.isDefaultPrevented()) {
                    j.preventDefault();
                    g(this).ajaxSubmit(h)
                }
            }

            function b(m) {
                var l = m.target;
                var j = g(l);
                if (!(j.is("[type=submit],[type=image]"))) {
                    var h = j.closest("[type=submit]");
                    if (h.length === 0) {
                        return
                    }
                    l = h[0]
                }
                var k = this;
                k.clk = l;
                if (l.type == "image") {
                    if (m.offsetX !== undefined) {
                        k.clk_x = m.offsetX;
                        k.clk_y = m.offsetY
                    } else {
                        if (typeof g.fn.offset == "function") {
                            var n = j.offset();
                            k.clk_x = m.pageX - n.left;
                            k.clk_y = m.pageY - n.top
                        } else {
                            k.clk_x = m.pageX - l.offsetLeft;
                            k.clk_y = m.pageY - l.offsetTop
                        }
                    }
                }
                setTimeout(function () {
                    k.clk = k.clk_x = k.clk_y = null
                }, 100)
            }

            g.fn.ajaxFormUnbind = function () {
                return this.unbind("submit.form-plugin click.form-plugin")
            };
            g.fn.formToArray = function (y, h) {
                var x = [];
                if (this.length === 0) {
                    return x
                }
                var m = this[0];
                var q = y ? m.getElementsByTagName("*") : m.elements;
                if (!q) {
                    return x
                }
                var s, r, p, z, o, u, l;
                for (s = 0, u = q.length; s < u; s++) {
                    o = q[s];
                    p = o.name;
                    if (!p || o.disabled) {
                        continue
                    }
                    if (y && m.clk && o.type == "image") {
                        if (m.clk == o) {
                            x.push({name: p, value: g(o).val(), type: o.type});
                            x.push({name: p + ".x", value: m.clk_x}, {name: p + ".y", value: m.clk_y})
                        }
                        continue
                    }
                    z = g.fieldValue(o, true);
                    if (z && z.constructor == Array) {
                        if (h) {
                            h.push(o)
                        }
                        for (r = 0, l = z.length; r < l; r++) {
                            x.push({name: p, value: z[r]})
                        }
                    } else {
                        if (d.fileapi && o.type == "file") {
                            if (h) {
                                h.push(o)
                            }
                            var k = o.files;
                            if (k.length) {
                                for (r = 0; r < k.length; r++) {
                                    x.push({name: p, value: k[r], type: o.type})
                                }
                            } else {
                                x.push({name: p, value: "", type: o.type})
                            }
                        } else {
                            if (z !== null && typeof z != "undefined") {
                                if (h) {
                                    h.push(o)
                                }
                                x.push({name: p, value: z, type: o.type, required: o.required})
                            }
                        }
                    }
                }
                if (!y && m.clk) {
                    var t = g(m.clk), w = t[0];
                    p = w.name;
                    if (p && !w.disabled && w.type == "image") {
                        x.push({name: p, value: t.val()});
                        x.push({name: p + ".x", value: m.clk_x}, {name: p + ".y", value: m.clk_y})
                    }
                }
                return x
            };
            g.fn.formSerialize = function (h) {
                return g.param(this.formToArray(h))
            };
            g.fn.fieldSerialize = function (j) {
                var h = [];
                this.each(function () {
                    var o = this.name;
                    if (!o) {
                        return
                    }
                    var l = g.fieldValue(this, j);
                    if (l && l.constructor == Array) {
                        for (var m = 0, k = l.length; m < k; m++) {
                            h.push({name: o, value: l[m]})
                        }
                    } else {
                        if (l !== null && typeof l != "undefined") {
                            h.push({name: this.name, value: l})
                        }
                    }
                });
                return g.param(h)
            };
            g.fn.fieldValue = function (n) {
                for (var m = [], k = 0, h = this.length; k < h; k++) {
                    var l = this[k];
                    var j = g.fieldValue(l, n);
                    if (j === null || typeof j == "undefined" || (j.constructor == Array && !j.length)) {
                        continue
                    }
                    if (j.constructor == Array) {
                        g.merge(m, j)
                    } else {
                        m.push(j)
                    }
                }
                return m
            };
            g.fieldValue = function (h, p) {
                var k = h.name, w = h.type, x = h.tagName.toLowerCase();
                if (p === undefined) {
                    p = true
                }
                if (p && (!k || h.disabled || w == "reset" || w == "button" || (w == "checkbox" || w == "radio") && !h.checked || (w == "submit" || w == "image") && h.form && h.form.clk != h || x == "select" && h.selectedIndex == -1)) {
                    return null
                }
                if (x == "select") {
                    var q = h.selectedIndex;
                    if (q < 0) {
                        return null
                    }
                    var s = [], j = h.options;
                    var m = (w == "select-one");
                    var r = (m ? q + 1 : j.length);
                    for (var l = (m ? q : 0); l < r; l++) {
                        var o = j[l];
                        if (o.selected) {
                            var u = o.value;
                            if (!u) {
                                u = (o.attributes && o.attributes.value && !(o.attributes.value.specified)) ? o.text : o.value
                            }
                            if (m) {
                                return u
                            }
                            s.push(u)
                        }
                    }
                    return s
                }
                return g(h).val()
            };
            g.fn.clearForm = function (h) {
                return this.each(function () {
                    g("input,select,textarea", this).clearFields(h)
                })
            };
            g.fn.clearFields = g.fn.clearInputs = function (h) {
                var j = /^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;
                return this.each(function () {
                    var l = this.type, k = this.tagName.toLowerCase();
                    if (j.test(l) || k == "textarea") {
                        this.value = ""
                    } else {
                        if (l == "checkbox" || l == "radio") {
                            this.checked = false
                        } else {
                            if (k == "select") {
                                this.selectedIndex = -1
                            } else {
                                if (l == "file") {
                                    if (/MSIE/.test(navigator.userAgent)) {
                                        g(this).replaceWith(g(this).clone(true))
                                    } else {
                                        g(this).val("")
                                    }
                                } else {
                                    if (h) {
                                        if ((h === true && /hidden/.test(l)) || (typeof h == "string" && g(this).is(h))) {
                                            this.value = ""
                                        }
                                    }
                                }
                            }
                        }
                    }
                })
            };
            g.fn.resetForm = function () {
                return this.each(function () {
                    if (typeof this.reset == "function" || (typeof this.reset == "object" && !this.reset.nodeType)) {
                        this.reset()
                    }
                })
            };
            g.fn.enable = function (h) {
                if (h === undefined) {
                    h = true
                }
                return this.each(function () {
                    this.disabled = !h
                })
            };
            g.fn.selected = function (h) {
                if (h === undefined) {
                    h = true
                }
                return this.each(function () {
                    var j = this.type;
                    if (j == "checkbox" || j == "radio") {
                        this.checked = h
                    } else {
                        if (this.tagName.toLowerCase() == "option") {
                            var k = g(this).parent("select");
                            if (h && k[0] && k[0].type == "select-one") {
                                k.find("option").selected(false)
                            }
                            this.selected = h
                        }
                    }
                })
            };
            g.fn.ajaxSubmit.debug = false;
            function e() {
                if (!g.fn.ajaxSubmit.debug) {
                    return
                }
                var h = "[jquery.form] " + Array.prototype.join.call(arguments, "");
                if (window.console && window.console.log) {
                    window.console.log(h)
                } else {
                    if (window.opera && window.opera.postError) {
                        window.opera.postError(h)
                    }
                }
            }
        })((typeof(jQuery) != "undefined") ? jQuery : window.Zepto)
    }
}(jQuery));


/*********

 ********

 ************ change shortcod content dynamically

 ********

 ***********/

function userpro_shortcode_template(method, container, shortcode, up_username, force_redirect_uri, post_id) {

    str = 'action=userpro_shortcode_template&shortcode=' + shortcode;

    if (up_username) {

        str = str + '&up_username=' + up_username;

    }

    if (post_id) {

        str = str + '&post_id=' + post_id;

    }

    if (force_redirect_uri) {

        str = str + '&force_redirect_uri=1';

    }

    if (container.find('form').length > 0) {

        var form = container.find('form');

        userpro_init_load(form);

    }

    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        dataType: 'JSON',

        type: 'POST',

        error: function (xhr, status, error) {

            userpro_end_load(form);


            alert("Error in jQuery.ajax while submitting a form:" + error);

        },

        success: function (data) {

            if (method == 'insert') { // overlay

                jQuery(container).html(data.response);

            }

            if (method == 'update') { // update

                jQuery(container).replaceWith(data.response);

                userpro_end_load(form);

            }


            userpro_responsive();

            userpro_chosen();

            userpro_fluid_videos();

            userpro_ajax_picupload();

            if (typeof(userpro_media_manager) == 'function') {

                userpro_media_manager();

            }

            jQuery('.userpro form').each(function () {

                userpro_collapse(jQuery(this));

            });

            userpro_overlay_center('.userpro-overlay-inner');

            if (typeof myMap == 'function') {

                myMap();

            }

        }

    });

}


/*********

 ********

 ************ fluid videos

 ********

 ***********/

function userpro_fluid_videos() {

    var $allVideos = jQuery(".userpro iframe, .userpro object, .userpro embed"),

        $fluidEl = jQuery(".userpro-input");

    $allVideos.each(function () {

        jQuery(this)

        // jQuery .data does not work on object/embed elements

            .attr('data-aspectRatio', this.height / this.width)

            .removeAttr('height')

            .removeAttr('width');

    });

    var newWidth = $fluidEl.width();

    $allVideos.each(function () {

        var $el = jQuery(this);

        $el

            .width(jQuery(this).parents('.userpro-input').width())

            .height(jQuery(this).parents('.userpro-input').width() * $el.attr('data-aspectRatio'));


    });

}


/*********

 ********

 ************ ajax picture upload

 ********

 ***********/

function userpro_ajax_picupload() {

    jQuery(".userpro-pic-upload").each(function () {

        var allowed = jQuery(this).data('allowed_extensions');

        var filetype = jQuery(this).data('filetype');

        var form = jQuery(this).parents('.userpro').find('form');

        var user_id = jQuery( 'input[id^="user_id-"]' ).val();


        jQuery(this).uploadFile({

            url: userpro_ajax_url + '?action=userpro_ajax_fileupload&user_id='+user_id,

            allowedTypes: allowed,

            onSubmit: function (files) {

                jQuery('.userpro-webcam-pic-upload').hide();

                var statusbar = jQuery('.ajax-file-upload-statusbar:visible');

                statusbar.parents('.userpro-input').find('.red').hide();

                if (statusbar.parents('.userpro-input').find('img.default').length) {

                    statusbar.parents('.userpro-input').find('img.default').show();

                    statusbar.parents('.userpro-input').find('img.modified').remove();

                }

            },

            onSuccess: function (files, data, xhr) {

                var statusbar = jQuery('.ajax-file-upload-statusbar:visible');

                data = jQuery.parseJSON(data);

                if (data.status == 2) {

                    alert('File size exceeds allowed file size limit.');

                    statusbar.hide();

                    return;

                }

                if (data.status == 0) {

                    alert('Invalid file type.');

                    statusbar.hide();

                    return;

                }

                var src = data.target_file_uri;

                if (statusbar.parents('.userpro-input').find('img.default').length) {

                    var width = statusbar.parents('.userpro-input').find('img.default').attr('width');

                    var height = statusbar.parents('.userpro-input').find('img.default').attr('height');

                } else if (statusbar.parents('.userpro-input').find('img.modified').length) {

                    var width = statusbar.parents('.userpro-input').find('img.modified').attr('width');

                    var height = statusbar.parents('.userpro-input').find('img.modified').attr('height');

                } else if (statusbar.parents('.userpro-input').find('img.avatar').length) {

                    var width = statusbar.parents('.userpro-input').find('img.avatar').attr('width');

                    var height = statusbar.parents('.userpro-input').find('img.avatar').attr('height');

                }


                str = 'action=userpro_crop_picupload&filetype=' + filetype + '&width=' + width + '&height=' + height + '&src=' + src;

                jQuery.ajax({

                    url: userpro_ajax_url,

                    data: str,

                    dataType: 'JSON',

                    type: 'POST',

                    success: function (data) {

                        statusbar.prev().after("<input type='button' value='" + statusbar.parents('.userpro-input').find('.userpro-pic').data('remove_text') + "' class='userpro-button red' style='display:none' />");

                        statusbar.prev().fadeIn(function () {

                            if (filetype == 'picture') {

                                statusbar.parents('.userpro-input').find('.userpro_post_feature_img').remove();

                                statusbar.parents('.userpro-input').find('img').attr('src', data.response);

                                statusbar.parents('.userpro-input').find('img').removeClass('no_feature');

                                jQuery('.userpro-webcam-pic-upload').show();


                            } else if (filetype == 'file') {


                                statusbar.parents('.userpro-input').find('.userpro-file-input').remove();

                                statusbar.parents('.userpro-input').prepend(data.response);


                            }

                            statusbar.hide();

                        });

                        statusbar.parents('.userpro-input').find('input:hidden').val(src);

                        statusbar.parents('.userpro-input').find('.userpro-pic-none').hide();


                        // re-validate

                        form.find('input').each(function () {

                            jQuery(this).trigger('blur');

                        });


                    }

                });


            }

        });

    });

}


/*********

 ********

 ************ password strength meter

 ********

 ***********/

function userpro_password_strength_meter(element) {

    var meter = element.parents('.userpro').find(".userpro-field[data-key^='passwordstrength']");

    var meter_data = meter.find('span.strength-text').data();

    var meter_text = meter.find('span.strength-text');

    var password = element.val();

    var LOWER = /[a-z]/,

        UPPER = /[A-Z]/,

        DIGIT = /[0-9]/,

        DIGITS = /[0-9].*[0-9]/,

        SPECIAL = /[^a-zA-Z0-9]/,

        SAME = /^(.)\1+$/;

    var lower = LOWER.test(password),

        upper = UPPER.test(password.substring(0, 1).toLowerCase() + password.substring(1)),

        digit = DIGIT.test(password),

        digits = DIGITS.test(password),

        special = SPECIAL.test(password);

    if (meter.length > 0) {

        if (password.length < 8) {

            meter.find('.strength-plain').removeClass('fill');

            meter_text.html(meter_data['too_short']);

            return 0;

        } else if (SAME.test(password)) {

            meter.find('.strength-plain').removeClass('fill');

            meter.find('.strength-plain:eq(0)').addClass('fill');

            meter_text.html(meter_data['very_weak']);

            return 1;

        } else if (lower && upper && digit && special) {

            meter.find('.strength-plain').removeClass('fill');

            meter.find('.strength-plain').addClass('fill');

            meter_text.html(meter_data['very_strong']);

            return 5;

        } else if (lower && upper && digit || lower && digits || upper && digits || special) {

            meter.find('.strength-plain').removeClass('fill');

            meter.find('.strength-plain:eq(0),.strength-plain:eq(1),.strength-plain:eq(2),.strength-plain:eq(3)').addClass('fill');

            meter_text.html(meter_data['strong']);

            return 4;

        } else if (lower && upper || lower && digit || upper && digit) {

            meter.find('.strength-plain').removeClass('fill');

            meter.find('.strength-plain:eq(0),.strength-plain:eq(1),.strength-plain:eq(2)').addClass('fill');

            meter_text.html(meter_data['good']);

            return 3;

        } else {

            meter.find('.strength-plain').removeClass('fill');

            meter.find('.strength-plain:eq(0),.strength-plain:eq(1)').addClass('fill');

            meter_text.html(meter_data['weak']);

            return 2;

        }

    }

}


/*********

 ********

 ************ setup chosen dropdowns

 ********

 ***********/

function userpro_chosen() {


    jQuery(".userpro select, .emd-filters select").removeClass("chzn-done").css('display', 'inline').data('chosen', null);

    jQuery('.userpro, .emd-filters').find("*[class*=chzn], .chosen-container").remove();

    jQuery(".chosen-select").chosen({

        disable_search_threshold: 10,

        width: '100%'

    });

    jQuery(".chosen-select-compact").chosen({

        disable_search: 1,

        width: '100%'

    });


    /**

     Tooltips

     **/

    jQuery('.userpro-tip-fade').tipsy({

        offset: 2,

        fade: true,

        opacity: 1

    });


    jQuery('span.userpro-tip, .userpro-tip').tipsy({

        offset: 5,

        fade: true,

        opacity: 1,

    });


    jQuery('.userpro-profile-badge').tipsy({

        offset: 3,

        fade: true,

        opacity: 1,

    });


    jQuery('.userpro-profile-badge-right').tipsy({

        offset: 3,

        fade: true,

        opacity: 1,

        gravity: 'w',

    });


}


/*********

 ********

 ************ userpro responsiveness

 ********

 ***********/

function userpro_responsive() {



    /* Tweaking compact head/profile */

    jQuery('.userpro-is-responsive').each(function () {


        var upro = jQuery(this);

        if (upro.width() <= 400) {

            upro.addClass('userpro-centered-c').removeClass('userpro-head');

            upro.find('*').addClass('userpro-force-center');

            upro.find('.userpro-profile-name').addClass('small');

        } else {

            upro.removeClass('userpro-centered-c').addClass('userpro-head');

            upro.find('*').removeClass('userpro-force-center');

            upro.find('.userpro-profile-name').removeClass('small');

        }


    });


    /* General form responsiveness */

    jQuery('.userpro').each(function () {


        var upro = jQuery(this);


        if (upro.width() <= 400 && upro.width() > 0 && upro.data('layout') == 'float') {

            upro.removeClass('userpro-float');

        } else if (upro.data('layout') == 'float') {

            upro.addClass('userpro-float');

        }


        if (upro.width() <= 400 && upro.width() > 0) {

            if (upro.find('.userpro-label').hasClass('iconed')) {

                upro.find('.userpro-field-icon').hide();

                upro.find('.userpro-label').removeClass('iconed');

            }

            upro.find('.userpro-submit').find('input').addClass('fullwidth-block');

            upro.find('.userpro-social-connect').addClass('fullwidth-block-social');

        } else {

            upro.find('.userpro-submit').find('input').removeClass('fullwidth-block');

            upro.find('.userpro-social-connect').removeClass('fullwidth-block-social');

        }


    });


    /* Elegant member dir */

    jQuery('.userpro-users-v2').each(function () {


        var elem = jQuery(this);

        if (elem.width() <= 700) {

            elem.find('.userpro-awsm').css({'width': '40%', 'margin-left': '15px', 'margin-right': '15px'});

        }

        if (elem.width() <= 560) {

            elem.find('.userpro-awsm').css({'width': '100%', 'margin-left': 0, 'margin-right': 0});

        }

        if (elem.width() > 700) {

            elem.find('.userpro-awsm').css({'width': '25%', 'margin-left': '15px', 'margin-right': '15px'});

        }


        equalHeight(jQuery(this).find('.userpro-awsm-bio'));

        equalHeight(jQuery(this).find('.userpro-awsm span.userpro-badges'));

        equalHeight(jQuery(this).find('.userpro-awsm-social'));


    });


    /* User posts */

    jQuery('.userpro-post-wrap').each(function () {


        var elem = jQuery(this);

        if (elem.width() <= 700) {

            elem.find('.userpro-post:not(.userpro-post-compact)').css({
                'width': '40%',
            });

        }

        if (elem.width() <= 400) {

            elem.find('.userpro-post:not(.userpro-post-compact)').css({
                'width': '100%',
            });

        }

        if (elem.width() > 700) {

            elem.find('.userpro-post:not(.userpro-post-compact)').css({
                'width': '25%',
            });

        }


    });


    if (typeof dateformat !== 'undefined') {

        /**

         Datepicker

         **/



        jQuery('input[data-fieldtype=datepicker]').datepicker({

            dateFormat: dateformat,

            changeMonth: true,

            changeYear: true,

            showOtherMonths: true,

            selectOtherMonths: true,

            dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],

            yearRange: 'c-65:c+1'

        });

    }

}


/*********

 ********

 ************ equal heights

 ********

 ***********/

function equalHeight(group) {

    tallest = 0;

    group.each(function () {

        jQuery(this).height('auto');

        thisHeight = jQuery(this).height();

        if (thisHeight > tallest) {

            tallest = thisHeight;

        }

    });

    group.height(tallest);

}


/*********

 ********

 ************ center the overlay popup

 ********

 ***********/

function userpro_overlay_center(container) {

    if (container.length) {

        jQuery(container).animate({

            'top': jQuery(window).innerHeight() / 2,

            'margin-top': '-' + jQuery(container).find('.userpro').innerHeight() / 2 + 'px'

        });

    }

}


/*********

 ********

 ************ collapse and maximize field groups

 ********

 ***********/

function userpro_collapse(form) {

    form.find('.userpro-section').each(function () {

        if (jQuery(this).next('div.userpro-field:not(.userpro-submit)').length == 0) {

            jQuery(this).hide();

        } else {


        }

    });

    form.find('.userpro-collapsible-1.userpro-collapsed-1').each(function () {

        jQuery(this).nextUntil('div.userpro-column').hide();

        if (jQuery(this).find('span').length == 0) jQuery(this).prepend('<span><i class="userpro-icon-angle-right"></i></span>');

    });

    form.find('.userpro-collapsible-1.userpro-collapsed-0').each(function () {


        jQuery(this).nextUntil('div.userpro-column').show();

        if (jQuery(this).find('span').length == 0) jQuery(this).prepend('<span><i class="userpro-icon-angle-down"></i></span>');

    });

}


/*********

 ********

 ************ side validate element with value and ajax check

 ********

 ***********/

function userpro_side_validate(element, input_value, ajaxcheck) {

    str = 'action=userpro_side_validate&input_value=' + input_value.replace(/&/g, "%26") + '&ajaxcheck=' + ajaxcheck + '&element=' + element;

    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        dataType: 'JSON',

        type: 'POST',

        success: function (data) {

            var parent = element.parents('.userpro-input');

            if (data && data.error) {

                userpro_client_error(element, parent, data.error);

            } else {

                userpro_client_valid(element, parent);

            }

            userpro_overlay_center('.userpro-overlay-inner');

        },

        error: function (request, status, error) {

            alert('Error for the validation :' + error);

        }

    });

}


/*********

 ********

 ************ return an error to client side

 ********

 ***********/

function userpro_client_error(element, parent, error) {

    if (element.data('custom-error')) {

        error = element.data('custom-error');

    }


    if (element.attr('type')) {


        if (element.attr('type') == 'hidden') {


            parent.find('.icon-ok').remove();

            if (parent.find('.userpro-warning').length == 0) {

                element.addClass('warning').removeClass('ok');

                parent.append('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');

                parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

            } else {

                parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error);

                parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

            }


        } else {


            parent.find('.icon-ok').remove();

            if (parent.find('.userpro-warning').length == 0) {

                element.addClass('warning').removeClass('ok');

                element.after('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');

                parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

            } else {

                parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error);

                parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

            }


        }


    } else {



        // select

        if (parent.find('.userpro-warning').length == 0) {

            parent.find('.chosen-container').after('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');

            parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

        } else {

            parent.find('.userpro-warning').html('<i class="userpro-icon-caret-up"></i>' + error);

            parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

        }


    }

    userpro_overlay_center('.userpro-overlay-inner');

}


/*********

 ********

 ************ return an error to client side / radio

 ********

 ***********/

function userpro_client_error_irregular(element, parent, error) {

    if (element != '' && element.data('custom-error')) {

        error = element.data('custom-error');

    }


    if (parent.find('.userpro-warning').length == 0) {

        parent.append('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + error + '</div>');

        parent.find('.userpro-warning').css({'top': '0px', 'opacity': '1'});

    }


    userpro_overlay_center('.userpro-overlay-inner');


}


/*********

 ********

 ************ return a valid field callback

 ********

 ***********/



function userpro_client_valid(element, parent) {


    if (element.attr('type')) {


        if (element.attr('type') == 'radio' || element.attr('type') == 'checkbox') {


            parent.find('.userpro-warning').remove();

            element.removeClass('warning').addClass('ok');


        } else {


            parent.find('.userpro-warning').remove();

            element.removeClass('warning').addClass('ok');

            if (parent.find('.icon-ok').length == 0) {

                if (element.val() != '') {

                    parent.append('<div class="icon-ok"><i class="userpro-icon-ok"></i></div>');

                } else {

                    parent.find('.icon-ok').remove();

                }

            }


        }


    } else {


        parent.find('.userpro-warning').remove();


    }

    userpro_overlay_center('.userpro-overlay-inner');

}


/*********

 ********

 ************ clear form

 ********

 ***********/

function userpro_clear_form(form) {

    form.find('.userpro-warning').remove();

    form.find('input,select,textarea,recaptcha').removeClass('warning').addClass('ok');

}


/*********

 ********

 ************ clear inputs

 ********

 ***********/

function userpro_clear_input(element) {

    element.parents('.userpro-input').find('.userpro-warning').remove();

    element.removeClass('warning');

}


/*********

 ********

 ************ init loading on shortcode

 ********

 ***********/

function userpro_init_load(form) {

    //form.parents('.userpro').find('.userpro-message-ajax').hide();

    form.find('input[type=submit],input[type=button]').attr('disabled', 'disabled');

    form.parents('.userpro').find('img.userpro-loading').show().addClass('inline');

}


/*********

 ********

 ************ end loading on shortcode

 ********

 ***********/

function userpro_end_load(form) {

    jQuery('.tipsy').remove();

    form.find('input[type=submit],input[type=button]').removeAttr('disabled');

    form.parents('.userpro').find('img.userpro-loading').hide().removeClass('inline');

}


/*********

 ********

 ************ result modal / confirmation

 ********

 ***********/

function userpro_overlay_confirmation(message) {


    if (jQuery('.userpro-modal-inner').length) {

        jQuery('.userpro-modal-inner').remove();

    }

    jQuery('body').append('<div class="userpro-modal-inner"><i class="userpro-icon-ok"></i><i class="userpro-icon-remove"></i>' + message + '</div>');

    jQuery('.userpro-modal-inner').css({

        'margin-top': '-' + jQuery('.userpro-modal-inner').innerHeight() / 2 + 'px',

        'opacity': 1

    });


}


/* Custom JS starts here */

jQuery(document).ready(function () {


    /**

     Modal Close

     **/

    jQuery(document).on('click', function () {

        if (jQuery('.userpro-modal-inner').length > 0) {

            jQuery('.userpro-modal-inner').remove();

        }

    });


    jQuery(document).on('click', 'div.userpro-modal-inner i.userpro-icon-remove', function (e) {

        jQuery('.userpro-modal-inner').remove();

    });


    /**

     Remove status

     **/

    jQuery(document).on('click', '.userpro-bar-success i, .userpro-bar-failed i', function (e) {

        jQuery(this).parent().slideToggle('fast');

    });


    /**

     Icons

     **/

    jQuery(document).on('mouseenter', '.userpro-field', function (e) {

        if (jQuery(this).find('.userpro-field-icon').length) {

            jQuery(this).find('.userpro-field-icon').addClass('icon-active');

        }

    });


    jQuery(document).on('mouseleave', '.userpro-field', function (e) {

        if (jQuery(this).find('.userpro-field-icon').length) {

            jQuery(this).find('.userpro-field-icon').removeClass('icon-active');

        }

    });


    /**

     toggle notice

     **/

    jQuery(document).on('click', 'a.userpro-alert-close', function (e) {

        jQuery(this).parents('.userpro-alert').slideUp(200);

    });


    /**

     fade for online

     users list

     **/

    jQuery(document).on('mouseenter', '.userpro-online-i', function (e) {

        jQuery(this).find('.userpro-online-i-thumb').fadeTo('fast', 0.7);

    })


    jQuery(document).on('mouseleave', '.userpro-online-i', function (e) {

        jQuery(this).find('.userpro-online-i-thumb').fadeTo('fast', 1);

    });


    /**

     fade for posts by user

     **/

    jQuery(document).on('mouseenter', '.userpro-post:not(.userpro-post-compact)', function (e) {

        jQuery(this).find('span.shadowed').stop().animate({'height': '100%'}, function () {

            jQuery(this).parent().find('span.iconed').fadeIn('slow');

        });

    })


    jQuery(document).on('mouseleave', '.userpro-post:not(.userpro-post-compact)', function (e) {

        jQuery(this).find('span.iconed').hide();

        jQuery(this).find('span.shadowed').stop().animate({'height': '0'}, 200);

    });


    jQuery(document).on('click', '.userpro-alert-edit', function (e) {

        jQuery('.userpro-alert-input').fadeIn();

    });


    /**

     save notice

     **/

    jQuery(document).on('click', '.userpro-alert input[type=button]', function (e) {

        var parent = jQuery(this).parents('.userpro-alert');

        var content = jQuery(this).parents('.userpro-alert').find('.userpro-alert-content');

        var value = jQuery(this).parents('.userpro-alert').find('input[type=text]').val();

        var user_id = jQuery(this).parents('.userpro-alert').data('user_id');

        jQuery.ajax({

            url: userpro_ajax_url,

            data: 'action=userpro_save_userdata&field=userpro_alert&value=' + value + '&user_id=' + user_id,

            dataType: 'JSON',

            type: 'POST',

            success: function (data) {

                if (content.length == 0) {

                    jQuery(this).parents('.userpro-alert').prepend('<div class="userpro-alert-content">' + data.res + '</div>');

                } else {

                    content.html(data.res);

                }

                jQuery(this).parents('.userpro-alert').find('.userpro-alert-input').fadeOut();

            }

        });

    });


    /**

     facebook login trigger

     **/

    jQuery(document).on('click', '.userpro-social-facebook', function (e) {

        Login(jQuery(this));

    });


    /**

     denies click behaviours

     #, redirection, etc.

     **/

    jQuery(document).on('click', "*[class^='popup-'], a[href='#']", function (e) {

        e.preventDefault();

        return false;

    });


    /**

     remove and fade overlay

     when clicking outside overlay

     **/

    jQuery(document).on('click', '.userpro-overlay, a.userpro-close-popup', function (e) {

        jQuery('.userpro-overlay').fadeOut(function () {
            jQuery('.userpro-overlay').remove()
        });

        jQuery('.userpro-overlay-inner').fadeOut(function () {
            jQuery('.userpro-overlay-inner').remove()
        });

    });


    /**

     denies submission of form

     **/

    jQuery(document).on('submit', '.userpro form:not(.userpro-search-form)', function (e) {

        e.preventDefault();

        return false;

    });


    /**

     Animation on users list with images only

     **/

    jQuery(document).on('mouseenter', '.userpro-user', function (e) {

        if (jQuery(this).data('pic_size') > 100) {

            jQuery(this).find('span').animate({top: 0}, 200);

        } else {

            jQuery(this).find('a.userpro-user-img').fadeTo('fast', 0.70);

        }

        jQuery(this).find('.userpro-user-link').css({opacity: 1});

    })


    jQuery(document).on('mouseleave', '.userpro-user', function (e) {

        if (jQuery(this).data('pic_size') > 100) {

            jQuery(this).find('span').animate({top: '-' + jQuery(this).parents('.userpro').data('memberlist_pic_size') + 'px'}, 50);

        } else {

            jQuery(this).find('a.userpro-user-img').fadeTo(1, 1);

        }

        jQuery(this).find('.userpro-user-link').css({opacity: 0});

    });


    /**

     load templates easily via data-template attribute

     any anchor or input with data-template

     **/

    jQuery(document).on('click', 'a,input', function (e) {


        if (jQuery(this).data('template')) {

            form_data = jQuery(this).parents('.userpro').data();

            var id = jQuery('.userpro').length;

            shortcode = '[userpro id=' + id;

            jQuery.each(form_data, function (key, value) {

                shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';

            });

            shortcode = shortcode + ']';

            shortcode = shortcode.replace(/(template=)"(.*?)"/, 'template="' + jQuery(this).data('template') + '"');

            if (jQuery(this).data('up_username')) {

                up_username = jQuery(this).data('up_username');

            } else {

                up_username = 0;

            }

            if (jQuery(this).data('force_redirect_uri')) {

                force_redirect_uri = jQuery(this).data('force_redirect_uri');

            } else {

                force_redirect_uri = 0;

            }

            post_id = jQuery(this).parents('.userpro').data('post_id');

            userpro_shortcode_template('update', jQuery(this).parents('.userpro'), shortcode, up_username, force_redirect_uri, post_id);

        }

    });


    /** Clear search form

     **/

    jQuery('.userpro-clear-search').click(function () {

        var search = jQuery(this).parents('.userpro-search-form');

        search.find('input[type=text]').val('');

        search.find('select').val('');

        search.trigger('submit');

    });


    jQuery(document).ajaxComplete(function () {


        var form = jQuery(this);


        check_condition();


        jQuery('div.userpro-input input[type="text"], div.userpro-input input[type="password"]').change(function () {


            check_condition();

        });

        jQuery('input:radio').click(function () {

            check_condition();

        });

        jQuery('input:checkbox').click(function () {

            check_condition();

        });

        jQuery('select').change(function () {

            check_condition();

        });


    });


    jQuery(document).ready(function () {

        var form = jQuery('.userpro');

        check_condition(form, true);

        jQuery('div.userpro-input input[type="text"], textarea, div.userpro-input input[type="password"]').change(function () {


            check_condition();

        });

        jQuery('input:radio').click(function () {

            check_condition(form, false);

        });

        jQuery('input:checkbox').click(function () {

            check_condition(form, false);

        });

        jQuery('select').change(function () {

            check_condition(form, false);

        });

    });


    function check_condition(form, onload) {

        var form = jQuery('.userpro');


        form.find('.userpro-field').each(function () {


            var condition_fields = jQuery(this).find('input[type=text], input[type=password], select, textarea, input[type=checkbox], input[type=radio], [data-filetype="file"]').data("condition_fields");


            var add_condition = jQuery(this).find('input[type=text], input[type=password], select, textarea, input[type=checkbox], input[type=radio],[data-filetype="file"]').data("add_condition");


            var conditional = jQuery(this).find('input[type=text], select, input[type=password], textarea, input[type=checkbox], input[type=radio],[data-filetype="file"]').data("condition_rule");


            if (typeof conditional != 'undefined' && conditional != '') {


                var val = jQuery("input[id^=" + condition_fields + "], select[id^=" + condition_fields + "], textarea[id^=" + condition_fields + "], input[type=radio][name^=" + condition_fields + "]:checked, input[type=checkbox][name^=" + condition_fields + "]:checked ").val();


                var conditional_val = jQuery(this).find('input[type=text], input[type=password], textarea, select, input[type=checkbox], input[type=radio],[data-filetype="file"]').data("condition_value");


                if (conditional == 'empty') {


                    if (val == '' || val.length == 1) {

                        if (add_condition == 'hide')

                            jQuery(this).hide();

                        else

                            jQuery(this).show();

                        if (!onload)

                            jQuery(this).addClass('has_condition');

                    }

                    else {

                        if (add_condition == 'hide')

                            jQuery(this).show();

                        else

                            jQuery(this).hide();

                        if (!onload)

                            jQuery(this).removeClass('has_condition');

                    }

                }

                if (conditional == "Not_empty") {

                    if (val != '') {

                        if (add_condition == 'hide')

                            jQuery(this).hide();

                        else

                            jQuery(this).show();

                        if (!onload)

                            jQuery(this).removeClass('has_condition');


                    }

                    else {

                        if (add_condition == 'hide')

                            jQuery(this).show();

                        else

                            jQuery(this).hide();

                        if (!onload)

                            jQuery(this).addClass('has_condition');

                    }


                }


                if (conditional == "not_equal") {


                    if (val != conditional_val) {

                        if (add_condition == 'hide')

                            jQuery(this).hide();

                        else

                            jQuery(this).show();

                        jQuery(this).removeClass('has_condition');

                    }

                    else {

                        if (add_condition == 'hide')

                            jQuery(this).show();

                        else

                            jQuery(this).hide();

                        if (!onload)

                            jQuery(this).addClass('has_condition');

                    }

                }

                if (conditional == "equal_to") {


                    if (conditional_val == val) {

                        if (add_condition == 'hide')

                            jQuery(this).hide();

                        else

                            jQuery(this).show();

                        if (!onload)

                            jQuery(this).removeClass('has_condition');

                    }

                    else {

                        if (add_condition == 'hide')

                            jQuery(this).show();

                        else

                            jQuery(this).hide();

                        if (!onload)

                            jQuery(this).addClass('has_condition');

                    }

                }


                if (jQuery(this).prevAll('.userpro-section:first').hasClass('userpro-collapsed-1')) {

                    jQuery(this).prevAll('.userpro-section:first').nextUntil('div.userpro-column').hide();

                }

            }


        });


    }


    /**

     the hard part

     processing forms via ajax

     **/

    jQuery(document).on('submit', '.userpro form:not(.userpro-search-form)', function (e) {

        var form = jQuery(this);


        // Trigger validation client side

        if (form.data('action') != 'login' &&

            form.data('action') != 'reset' &&

            form.data('action') != 'resend' &&

            form.data('action') != 'delete') {



            // re-validate

            form.find('input,textarea').each(function () {

                if (!(jQuery(this).parents('.userpro-field').css('display') == 'none')) {

                    jQuery(this).trigger('blur');

                }

            });


            form.find('select').each(function () {

                jQuery(this).trigger('change');

            });


            form.find('select[data-required=1],textarea[data-required=1]').each(function () {

                if (!jQuery(this).val()) {

                    userpro_client_error_irregular(jQuery(this), jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text'));

                } else {

                    userpro_client_valid(jQuery(this).find("select"), jQuery(this).parents('.userpro-input'));

                }

            });


            form.find('.userpro-radio-wrap[data-required=1]').each(function () {

                if (!jQuery(this).find("input:radio").is(":checked")) {

                    userpro_client_error_irregular('', jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text'));

                } else {

                    userpro_client_valid(jQuery(this).find("input:radio"), jQuery(this).parents('.userpro-input'));

                }

            });


            form.find('.userpro-checkbox-wrap[data-required=1]').each(function () {

                if (!jQuery(this).find("input:checkbox").is(":checked")) {

                    userpro_client_error_irregular('', jQuery(this).parents('.userpro-input'), jQuery(this).parents('.userpro').data('required_text'));

                } else {

                    userpro_client_valid(jQuery(this).find("input:checkbox"), jQuery(this).parents('.userpro-input'));

                }

            });


            form.find('.userpro-maxwidth[data-required=1]').each(function () {

                if (!jQuery(this).find("input:checkbox").is(":checked")) {

                    userpro_client_error_irregular('', jQuery(this).find('.userpro-input'), jQuery(this).data('required_msg'));

                } else {

                    userpro_client_valid(jQuery(this).find("input:checkbox"), jQuery(this).find('.userpro-input'));

                }

            });


            if (form.find('.userpro-warning').length > 0 || form.find('.warning').length > 0) {

                form.find('.userpro-section').each(function () {

                    jQuery(this).find('.userpro-section-warning').remove();

                    if (jQuery(this).nextUntil('div.userpro-column').find('.userpro-warning').length > 0) {

                        jQuery(this).css({'display': 'block'});

                        jQuery(this).append('<ins class="userpro-section-warning">' + userpro_frontend_publisher_data.correction_text +'</ins>');

                        jQuery(this).find('.userpro-section-warning').fadeIn();

                    }

                });

                form.find('.userpro-warning:first').parents('.userpro-input').find('input').focus();

                return false;

            } else {

                form.find('.userpro-section').each(function () {

                    jQuery(this).find('.userpro-section-warning').remove();

                });

            }


            // Done

        } else {


            userpro_clear_form(form);


        }


        // start load

        userpro_init_load(form);


        // form data and shortcode

        form_data = jQuery(this).parents('.userpro').data();

        shortcode = '[userpro';

        jQuery.each(form_data, function (key, value) {

            shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';

        });

        shortcode = shortcode + ']';


        // username

        if (jQuery(this).parents('.userpro').find('.userpro-profile-img-btn a').data('up_username')) {

            up_username = jQuery(this).parents('.userpro').find('.userpro-profile-img-btn a').data('up_username');

        } else {

            up_username = 0;

        }


        jQuery.ajax({

            url: userpro_ajax_url,

            data: form.serialize() + "&action=userpro_process_form&template=" + form_data['template'] + "&group=" + form_data[form_data['template'] + '_group'] + "&shortcode=" + encodeURIComponent(shortcode) + '&up_username=' + up_username + '&user_action=' + user_action,

            dataType: 'JSON',

            type: 'POST',

            error: function (xhr, status, error) {

                userpro_end_load(form);

                if (xhr.status == 200) {

                    location.reload();

                } else {

                    alert("Error in jQuery.ajax while submitting a form: " + error);

                }


                /*if(form_data['template'] == 'login'){

                 if(xhr.status == 200){

                 location.reload();

                 }

                 else{

                 alert("Login failed as the error in jQuery.ajax : "+xhr.status + ' '+error);

                 }

                 }

                 else if(form_data['template'] == 'register'){

                 alert("Registration failed as the error in jQuery.ajax : "+xhr.status + ' '+error);

                 }

                 else if(form_data['template'] == 'edit'){

                 alert("Edit form submission failed as the error in jQuery.ajax : "+xhr.status + ' '+error);

                 }

                 else{*/


                //}

            },

            success: function (data) {

                if (data && typeof(data.paypal_form) != null) {

                    jQuery('body').append(data.paypal_form);

                    jQuery('#paypalform').submit();

                }

                userpro_end_load(form);


                /* server-side error */

                if (data && data.error) {


                    var i = 0;

                    jQuery.each(data.error, function (key, value) {

                        i++;

                        if (key == 'antispam' || key == 'user_email') {

                            element = form.find('.userpro-field[data-key="' + key + '"]').find('input[type=text]');

                        }

                        else {

                            element = form.find('.userpro-field[data-key="' + key + '"]').find('input');

                        }

                        parent = element.parents('.userpro-input');

                        if (element.attr('type') == 'radio' || element.attr('type') == 'checkbox') {

                            userpro_client_error_irregular(element, element.parents('.userpro-input'), value);

                        } else {

                            if (i == 1) element.focus();

                            userpro_client_error(element, element.parents('.userpro-input'), value);

                        }


                        if (key == 'userpro_editor') {

                            if (form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').length) {

                                form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').html(value);

                                form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').css({
                                    'top': '0px',
                                    'opacity': '1'
                                });

                            } else {

                                form.find('.userpro-field-editor .userpro-input').append('<div class="userpro-warning"><i class="userpro-icon-caret-up"></i>' + value + '</div>');

                                form.find('.userpro-field-editor .userpro-input').find('.userpro-warning').css({
                                    'top': '0px',
                                    'opacity': '1'
                                });

                            }

                        }


                    });


                }


                /* custom message */

                if (data && data.custom_message && data.custom_message != '') {

                    form.parents('.userpro').find('.userpro-body').find('.userpro-message').remove();

                    form.parents('.userpro').find('.userpro-body').prepend(data.custom_message);

                }


                /* redirect after form */

                if (data && data.redirect_uri && data.redirect_uri != '') {

                    if (data.redirect_uri == 'refresh' && data.paypal_form == null) {

                        document.location.href = jQuery(location).attr('href');

                    } else {

                        document.location.href = data.redirect_uri;

                    }

                }


                /* show modal confirmation */

                if (form_data['template'] == 'publish' && data.modal_msg) {

                    fbpost();

                    userpro_overlay_confirmation(data.modal_msg);

                    if (user_action == "draft") {

                        var url = window.location.href;

                        var publish_page = url.substring(0, url.indexOf('?'));

                        window.location = publish_page;

                    }

                    else {

                        jQuery("#publish_form").find('input:text, input:password, input:file, select, textarea').val('');

                        jQuery("#publish_form .userpro-button.red").trigger("click");

                        jQuery(".userpro-warning").hide();


                    }

                    userpro_overlay_confirmation(data.modal_msg);


                    user_action = "";

                    if (data.post_id != '') {

                        jQuery('#post_id').val(data.post_id);

                    }

                }


                /* display template */

                if (data && data.template && data.template != '') {

                    form.parents('.userpro').replaceWith(data.template);


                    /* show modal confirmation */

                    if (form_data['template'] == 'edit') {

                        userpro_overlay_confirmation(form.parents('.userpro').data('modal_profile_saved'));

                    }


                }


                /* clear publish form (stop spam) */

                if (data !== null) {
                    if (!data.error && form_data['template'] == 'publish') {

                        form.find('input,textarea').not('input[type=submit],input[type=hidden],input[type=button]').val('');

                        form.find('div.userpro-pic-post_featured_image img').addClass('no_feature');

                        form.find('.userpro-button.red').remove();

                        form.find('.icon-ok').remove();

                    }
                }


                /* reinitialise */

                userpro_responsive();

                userpro_chosen();

                userpro_fluid_videos();

                userpro_ajax_picupload();

                if (typeof(userpro_media_manager) == 'function') {

                    userpro_media_manager();

                }

                jQuery('.userpro form').each(function () {

                    userpro_collapse(jQuery(this));

                });

                userpro_overlay_center('.userpro-overlay-inner');

                if (form_data['template'] == 'edit') {

                    if (typeof myMap == 'function') {

                        myMap();

                    }

                }

            }

        });

    });


    /**

     registration fields blur validation

     **/

    jQuery(document).on('blur', '.userpro[data-template=publish] textarea, .userpro[data-template=publish] input, .userpro[data-template=register] input, .userpro[data-template=edit] input, .userpro[data-template=change] input', function (e) {


        var element = jQuery(this);

        var parent = element.parents('.userpro-input');

        var required = element.data('required');

        var ajaxcheck = element.data('ajaxcheck');

        var original_elem = element.parents('.userpro').find('input[type=password]:first');

        var original = element.parents('.userpro').find('input[type=password]:first').val();


        if (required == 1) {


            if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text'));

            } else if (ajaxcheck) {

                userpro_side_validate(element, element.val(), ajaxcheck);

            } else {

                userpro_client_valid(element, element.parents('.userpro-input'));

            }


            if (jQuery(this).attr('type') == 'password') { // only if field is password

                if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {

                    userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text'));

                } else if (element.val().length < 8) {

                    userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short'));

                } else if (userpro_password_strength_meter(element) < 3) {

                    userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong'));

                }

                else if (original != element.val()) {

                    userpro_client_error(element, element.parents('.userpro-input'), jQuery(this).parents('.userpro').data('passwords_do_not_match'));

                }

                else {

                    userpro_client_valid(element, element.parents('.userpro-input'));

                }

            }


        } else if (element.attr('type') == 'password' && original_elem && original && original_elem.parents('.userpro-input').find('.userpro-warning').length == 0) {

            if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text'));

            } else if (element.val().length < 8) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short'));

            } else if (userpro_password_strength_meter(element) < 3) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong'));

            } else if (original != element.val()) {

                userpro_client_error(element, element.parents('.userpro-input'), jQuery(this).parents('.userpro').data('passwords_do_not_match'));

            } else {

                userpro_client_valid(element, element.parents('.userpro-input'));

            }

        } else if (( element.attr('type') == 'password' && original ) || ( element.attr('type') == 'password' && element.parents('.userpro').data('template') == 'change' )) {

            if (element.val().replace(/^\s+|\s+$/g, "").length == 0) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text'));

            } else if (element.val().length < 8) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_too_short'));

            } else if (userpro_password_strength_meter(element) < 3) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('password_not_strong'));

            } else if (original != element.val()) {

                userpro_client_error(element, element.parents('.userpro-input'), jQuery(this).parents('.userpro').data('passwords_do_not_match'));

            } else {

                userpro_client_valid(element, element.parents('.userpro-input'));

            }

        } else if (element.attr('type') == 'password' && original == '' && element.val() == '') {

            userpro_clear_input(element);

        } else if (ajaxcheck && element.val()) {

            userpro_side_validate(element, element.val(), ajaxcheck);

        } else if (ajaxcheck && !element.val()) {

            userpro_clear_input(element);

        } else if (element.val() && element.data('type') == 'securityqa') {

            userpro_clear_input(element);

        } else if (!ajaxcheck && element.attr('type') == 'text') {

            userpro_clear_input(element);


        }

        //** commented by kajal as validation fails for hidden field

        else if (element.val() && element.data('sitekey') != '') {            //userpro_clear_input(element);

        }


    });


    /**

     select dropdowns live change

     validation to which fields are

     required

     **/

    jQuery(document).on('change', '.userpro[data-template=register] select', function (e) {

        var element = jQuery(this);

        var parent = element.parents('.userpro-input');

        var required = element.data('required');

        if (required == 1) {

            if (element.val() == 0) {

                userpro_client_error(element, element.parents('.userpro-input'), element.parents('.userpro').data('required_text'));

            } else {

                userpro_client_valid(element, element.parents('.userpro-input'));

            }

        }

    });


    /**

     activate password strength in

     registration mode

     **/

    jQuery(document).on('keyup keydown', '.userpro[data-template=register] input[type=password][data-required=1]', function (e) {

        userpro_password_strength_meter(jQuery(this));

    });


    /**

     activate password strength in

     edit mode

     **/

    jQuery(document).on('keyup keydown', '.userpro[data-template=edit] input[type=password]:first', function (e) {

        userpro_password_strength_meter(jQuery(this));

    });


    /**

     activate password strength in

     password change mode

     **/

    jQuery(document).on('keyup keydown', '.userpro[data-template=change] input[type=password]:first', function (e) {

        userpro_password_strength_meter(jQuery(this));

    });


    /**

     collapse / un-collapse work

     on field sections is done here

     **/

    jQuery(document).on('click', '.userpro-collapsible-1', function (e) {


        if (jQuery(this).nextUntil('div.userpro-column').not('.has_condition').is(':hidden')) {


            jQuery(this).nextUntil('div.userpro-column').not('.has_condition').show();


            jQuery(this).removeClass('userpro-collapsed-1').addClass('userpro-collapsed-0');

            jQuery(this).find('span').html('<i class="userpro-icon-angle-down"></i>');


            if (jQuery(this).parents('.userpro').data('keep_one_section_open') == 1) {


                jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).nextUntil('div.userpro-column').hide();

                jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).find('span').html('<i class="userpro-icon-angle-right"></i>');

                jQuery('.userpro-collapsible-1.userpro-collapsed-0').not(this).removeClass('userpro-collapsed-0').addClass('userpro-collapsed-1');

            }


        } else {


            jQuery(this).nextUntil('div.userpro-column').hide();

            jQuery(this).find('span').html('<i class="userpro-icon-angle-right"></i>');

            jQuery(this).removeClass('userpro-collapsed-0').addClass('userpro-collapsed-1');

        }


        userpro_overlay_center('.userpro-overlay-inner');

        //check_condition();

    });

    jQuery(document).on('click', '.userpro-collapsible-1', function (e) {

        //check_condition();

    });

    /**

     instant popups with automatic template recognition

     popup-register as example

     **/

    jQuery(document).on('click', "*[class^='popup-'],*[class^='popup-'] a", function (e) {


        var up_username = '';

        if (jQuery(this).data('up_username')) {

            up_username = jQuery(this).data('up_username');

        }

        if (/popup/.test(jQuery(this).attr("class")) == false) {

            var template = jQuery(this).parents('li').attr('class').split('-')[1].match(/\w*/);

        } else {

            var template = jQuery(this).attr('class').split('-')[1].match(/\w*/);

        }

        var id = jQuery('.userpro').length;

        shortcode = '[userpro id=' + id + ' template=' + template + '';

        jQuery.each(jQuery(this).data(), function (key, value) {

            shortcode = shortcode + ' ' + key + '=' + '"' + value + '"';

        });

        shortcode = shortcode + ']';

        if (jQuery('body').find('.userpro-overlay').length == 0) {

            jQuery('body').append('<div class="userpro-overlay"/><div class="userpro-overlay-inner"/>');

        }

        userpro_shortcode_template('insert', jQuery('.userpro-overlay-inner'), shortcode, up_username);


        if (template == 'request_verify') {

            jQuery('.popup-request_verify').remove();

        }


    });


    /**

     auto change avatar based on gender

     **/

    jQuery(document).on('change', "input[name^='gender']", function (e) {

        this_form = jQuery(this).parents('.userpro');

        if (this_form.find("*[data-key=profilepicture]").find('input:hidden').val() == '') {

            this_form.find("*[data-key=profilepicture]").find('img').attr('src', jQuery(this).parents('.userpro').data('default_avatar_' + jQuery(this).val().toLowerCase()));

        }

    });


    /**

     smart resizing, responsive, recalculation stuff

     is done here



     **/

    /*jQuery(window).smartresize(function(){

     userpro_overlay_center('.userpro-overlay-inner');

     userpro_responsive();

     userpro_fluid_videos();

     });*/

    userpro_responsive();

    setTimeout(function () {

        userpro_fluid_videos();

    }, 3000);

    userpro_chosen();

    userpro_ajax_picupload();

    if (typeof(userpro_media_manager) == 'function') {

        userpro_media_manager();

    }

    jQuery('.userpro form').each(function () {

        userpro_collapse(jQuery(this));

    });


    /**

     cancel an upload

     **/

    jQuery(document).on('click', '.userpro form:not(.userpro-search-form) .userpro-input .userpro-button.red', function (e) {

        jQuery(this).parents('.userpro-input').find('.userpro-pic-none').show();

        if (jQuery(this).parents('.userpro-input').find('img.default').length) {

            jQuery(this).parents('.userpro-input').find('img.default').show();

            jQuery(this).parents('.userpro-input').find('img.modified').remove();

        } else {


            if (jQuery(this).parents('.userpro').find('div.userpro-pic-post_featured_image').length) {

                jQuery(this).parents('.userpro-input').find('img.modified').addClass('no_feature').attr('src', jQuery(this).parents('.userpro-input').data('placeholder'));

            } else {

                jQuery(this).parents('.userpro-input').find('img.modified').attr('src', '');

            }


        }

        if (jQuery(this).parents('.userpro-input').find('.userpro-file-input').length) {

            jQuery(this).parents('.userpro-input').find('.userpro-file-input').remove();

        }

        jQuery(this).parents('.userpro-input').find('input:hidden').val('');

        jQuery(this).fadeOut();


        // re-validate

        jQuery(this).parents('.userpro-input').find('input:hidden').each(function () {

            jQuery(this).trigger('blur');

        });


    });


    /**

     custom radio buttons

     **/

    jQuery(document).on('click', '.userpro input[type=radio]', function (e) {

        var field = jQuery(this).parents('.userpro-input');

        field.find('span').removeClass('checked');

        jQuery(this).parents('label').find('span').addClass('checked');

    });


    /**

     custom checkbox buttons

     **/

    jQuery(document).on('change', '.userpro input[type=checkbox]', function (e) {

        if (jQuery(this).is(':checked')) {

            jQuery(this).parents('label').find('span').addClass('checked');

        } else {

            jQuery(this).parents('label').find('span').removeClass('checked');

        }

    });


    /**

     if accidently clicked on error message

     **/

    jQuery(document).on('click', '.userpro-warning', function (e) {

        jQuery(this).parents('.userpro-input').find('input').focus();

    });


});

/**

 * Facebook autopost function

 * Added By Rahul

 */

function fbpost() {

    var message = jQuery("#fb-post-data").data('message');

    var name = jQuery("#fb-post-data").data('name');

    var caption = jQuery("#fb-post-data").data('caption');

    var desc = jQuery('#fb-post-data').data('description');

    var link = jQuery('#fb-post-data').data('link');

    var fbappid = jQuery('#fb-post-data').data('fbappid');

    window.fbAsyncInit = function () {

        FB.init({

            appId: fbappid,

            xfbml: true,

            version: 'v2.2'

        });

        FB.getLoginStatus(function (response) {

            if (response.status === 'connected') {

                var uid = response.authResponse.userID;

                var accessToken = response.authResponse.accessToken;

                FB.api('/me/feed', 'post', {
                    message: message,
                    caption: caption,
                    link: link,
                    name: name,
                    description: desc
                }, function (response) {
                });


            } else if (response.status === 'not_authorized') {

                // the user is logged in to Facebook,

                // but has not authenticated your app

            } else {

                // the user isn't logged in to Facebook.

            }

        });


    };

    (function (d, s, id) {

        var js, fjs = d.getElementsByTagName(s)[0];

        if (d.getElementById(id)) {
            return;
        }

        js = d.createElement(s);
        js.id = id;

        js.src = "//connect.facebook.net/en_US/sdk.js";

        fjs.parentNode.insertBefore(js, fjs);

    }(document, 'script', 'facebook-jssdk'));

}

jQuery(function () {

    jQuery('#inviteuser').submit(function (e) {

        e.preventDefault();

        var emails = jQuery('#useremail').val();

        var data = {

            'action': 'userpro_user_invite',

            'emails': emails,

        };


        jQuery.post(userpro_ajax_url, data, function (response) {


            jQuery('#useremail').val('');

            if (response == "Not a valid email address") {

                alert("Plese enter valid email address");

            }

            else {

                jQuery('#invite_success_msg').html("Invitation mail sent Successfully!");

            }

        });

    });

});


function userpro_show_user_badges(user_id) {


    str = 'action=userpro_display_user_badges&user_id=' + user_id;

    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        type: 'POST',

        success: function (data) {


            jQuery('.display_badges').remove();

            jQuery('.badges').html(data);


        },

        error: function (data) {
            alert(data);


            alert(data.error);

        }

    });


}

function userpro_delete_userpost(post_id, elm) {


    str = 'action=userpro_delete_post&post_id=' + post_id;

    var retVal = confirm("Are you sure you want to delete the post?");

    if (retVal == true) {

        jQuery.ajax({

            url: userpro_ajax_url,

            data: str,

            type: 'POST',

            success: function (data) {


                if (data == "You do not have permission to delete this post")

                    alert("You do not have permission to delete this post");

                else

                    jQuery(elm).parent().parent().remove();


            },

            error: function (data) {
                alert(data);


                alert(data.error);

            }

        });

    }

}


jQuery("#user_list").change(function () {


    var user_id = jQuery(this).val();


    posts_by_users_call(user_id);


});


function posts_by_users_call(user_id) {


    str = 'action=userpro_post_sort&user_id=' + user_id;


    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        type: 'POST',

        success: function (data) {



            //jQuery('.post_by_users').remove();

            jQuery('.post_by_users').html(stripslashes(data));

            jQuery('.userpro-post-wrap').each(function () {

                var elem = jQuery(this);


                if (elem.width() <= 700) {

                    elem.find('.userpro-post:not(.userpro-post-compact)').css({
                        'width': '40%',
                        'margin-left': '10px',
                        'margin-right': '10px'
                    });

                }

                if (elem.width() <= 400) {

                    elem.find('.userpro-post:not(.userpro-post-compact)').css({
                        'width': '100%',
                        'margin-left': 0,
                        'margin-right': 0
                    });

                }

                if (elem.width() > 700) {

                    elem.find('.userpro-post:not(.userpro-post-compact)').css({
                        'width': '25%',
                        'margin-left': '10px',
                        'margin-right': '10px'
                    });

                }

            });

            jQuery("#user_list").change(function () {


                var user_id = jQuery(this).val();

                posts_by_users_call(user_id);


            });


        },

        error: function (data) {
            alert(data);


            alert(data.error);

        }

    });


}


function up_initialize_webcam(elm) {

    var up_key = jQuery(elm).parents(".userpro-field").data("key").trim();

    var up_data = "<div class='up-capture-photo' id='up-capture-photo' onclick=up_capture_image('" + up_key + "')>Take Photo</div>";

    if (jQuery('body').find('.userpro-overlay').length == 0) {

        jQuery('body').append('<div class="userpro-overlay"/><div class="userpro-overlay-inner"/>');

    }

    jQuery('.userpro-overlay-inner').html("<div class='userpro'><div class='userpro-centered'  style='height:400px;'><div id='up-webcam-pic' style='width:400px;height:300px'></div></div></div>");

    userpro_overlay_center('.userpro-overlay-inner');

    jQuery('#up-webcam-pic').show();

    Webcam.attach('#up-webcam-pic');

    jQuery('#up-webcam-pic').after(up_data);


}


function up_capture_image(elm) {

    var elem = jQuery('div[data-key="' + elm + '"]').find('.userpro-webcam-pic-upload');

    Webcam.snap(function (data_uri) {

        elem.parent().find('.userpro-pic img').attr('src', data_uri);

        jQuery('.userpro-overlay').remove();

        jQuery('.userpro-overlay-inner').remove();

        var url = userpro_ajax_url + "?action=userpro_ajax_fileupload&webcam=true";

        Webcam.upload(data_uri, url, function (code, text) {


            var obj = jQuery.parseJSON(text);

            //var elem = jQuery('.userpro-webcam-pic-upload');

            var src = obj.target_file_uri;

            var filetype = 'picture';

            if (elem.parent().find('img.default').length) {

                var width = elem.parent().find('img.default').attr('width');

                var height = elem.parent().find('img.default').attr('height');

            } else if (elem.parent().find('img.modified').length) {

                var width = elem.parent().find('img.modified').attr('width');

                var height = elem.parent().find('img.modified').attr('height');

            } else if (elem.parent().find('img.avatar').length) {

                var width = elem.parent().find('img.avatar').attr('width');

                var height = elem.parent().find('img.avatar').attr('height');

            }

            str = 'action=userpro_crop_picupload&filetype=' + filetype + '&width=' + width + '&height=' + height + '&src=' + src;

            jQuery.ajax({

                url: userpro_ajax_url,

                data: str,

                dataType: 'JSON',

                type: 'POST',

                success: function (data) {

                    elem.prev().after("<input type='button' value='" + elem.parent().find('.userpro-pic').data('remove_text') + "' class='userpro-button red' style='display:none' />");

                    elem.prev().fadeIn(function () {

                        elem.parent().find('.userpro-file-input').remove();

                    });

                    elem.parent().find('input:hidden').val(src);

                    elem.parent().find('.userpro-pic-none').hide();


                    // re-validate


                }

            });

        });


    });

}


/*function call on click of save as draft button start*/

function save_post_as_draft(elem) {

    user_action = 'draft';

    jQuery(elem).closest('form').submit();

}

/*function call on click of save as draft button end*/



/*fuction for connect user added by Yogesh */

function userpro_connect_user(userid, username) {


    var str = 'action=userpro_connect_user&user_id=' + userid;

    var retVal = confirm("Are you sure you want to connect with " + username + " ?");

    if (retVal == true) {

        jQuery.ajax({

            url: userpro_ajax_url,

            data: str,

            type: 'POST',

            dataType: 'JSON',

            success: function (data) {


                userpro_overlay_confirmation(data.modal_msg);


            },

            error: function (data) {
                alert(data);

                alert(data.error);

            }

        });

    }


}

function userpro_reject_request(user) {

    var str = 'action=userpro_reject_user_request&user_id=' + user;


    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        type: 'POST',

        dataType: 'JSON',

        success: function (data) {


            jQuery('#' + user).hide();

        },

        error: function (data) {
            alert(data);

            alert(data.error);

        }

    });


}


function userpro_accept_request(user) {


    var str = 'action=userpro_accept_user_request&user_id=' + user;


    jQuery.ajax({

        url: userpro_ajax_url,

        data: str,

        type: 'POST',

        dataType: 'JSON',

        success: function (data) {


            jQuery('#button-' + user).hide();

            jQuery('#button-rej-' + user).hide();

            jQuery('.userpro-sc-action-remove').show();

        },

        error: function (data) {
            alert(data);

            alert(data.error);

        }

    });


}


function userpro_remove_connection(user) {


    var str = 'action=userpro_remove_connection&user_id=' + user;

    var retVal = confirm("Are you sure you want to remove the connection ?");

    if (retVal == true) {

        jQuery.ajax({

            url: userpro_ajax_url,

            data: str,

            type: 'POST',

            dataType: 'JSON',

            success: function (data) {

                location.reload();

            },

            error: function (data) {
                alert(data);

                alert(data.error);

            }

        });

    }


}


jQuery(document).ready(function () {


    jQuery('.userpro_title_connect').tipsy({


        offset: 2,

        fade: true,

        opacity: 1


    });


    userpro_limit_post_categories();

});


jQuery(document).ajaxComplete(function () {

    userpro_limit_post_categories();

});


function userpro_limit_post_categories() {

    jQuery("select[name^='post_categories']").chosen('destroy');

    jQuery("select[name^='post_categories']").chosen({

        max_selected_options: userpro_frontend_publisher_data.userpro_limit_categories,

        disable_search_threshold: 10,

        width: '100%'


    });

}


function stripslashes(str) {

    return (str + '').replace(/\\(.?)/g, function (s, n1) {

        switch (n1) {

            case '\\':

                return '\\';

            case '0':

                return '\u0000';

            case '':

                return '';

            default:

                return n1;

        }

    });

}