<?php
namespace Indeed\Ihc;
/*
 * @since 7.4
 */

class Updates
{

    private $optionName = 'ihc_plugin_current_version';

    public function __construct()
    {
        add_action( 'init', array( $this, 'check' ) );
    }

    public function check()
    {
        $currentVersion = indeed_get_plugin_version( IHC_PATH . 'indeed-membership-pro.php' );
        $versionValueInDatabase = get_option( $this->optionName );
        if ( !$versionValueInDatabase ){
            $versionValueInDatabase = '7.3';
        }

        if ( version_compare( $currentVersion, $versionValueInDatabase )==1 ){
            $this->updateRegisterFields();
            update_option( $this->optionName, $currentVersion );
        }
    }

    public function updateRegisterFields()
    {
        $data = get_option( 'ihc_user_fields' );
        if ( !$data ){
            return false;
        }
        foreach ( $data as $fieldData ){
            if ( !isset( $fieldData['display_on_modal'] ) ){
                $fieldData['display_on_modal'] = 0;
            }
        }
        update_option( 'ihc_user_fields', $data );
    }


}
