<?php
if ( ! defined('ABSPATH' ) ) exit;

class W3DEV_BAN_USER_CLASS {

    protected static $instance = NULL;

    public static function get_instance() {

        // create an object
        NULL === self::$instance and self::$instance = new self;

        return self::$instance; // return the object
    }

    private function __construct() {
 
            $this->is_admin = W3DEV_IS_ADMIN;
            DEFINE( 'W3DEV_BAN_USERS_VERSION_ID', $this->version_id() );

    }

    public function default_options($set = 'settings') {

        $settings = array( 
            'change_posts_status'                   => 0,
            'post_status'                           => '',
            'display_message'                       => 0,
            'custom_message'                        => __('You have been banned from this part of the website', 'ban-users'),
            'force_logout'                          => 1,
            'custom_logout'                         => 0,
            'custom_logout_url'                     => '',
            'unban_date'                            => 0,
            'ban_email'                             => 1,
            'ban_email_default'                     => 1,
            'users_tbl_row_highlighted'             => 1,
            'users_tbl_data_column'                 => 1,
            'banned_login_message'                  => __('This user account has been banned', 'ban-users'),
            'ban_email_default_message'             => __("You have breached our site's terms of use.", 'ban-users'),
            'date_format'                           => 'd-m-Y',
            'frontend_banned_notification'          => 0,
            'frontend_notification_force_logout'    => 0,
            'frontend_notification_hide'            => 0,
            'warn_user'                             => 1,
            'warn_user_reason'                      => 1,
            'accessibility'                         => 0,
            'denied_login_message'                  => 'Access to our site is denied',
            'denied_bad_bot_message'                => 'Access to our site is denied'
        );

        if ( W3DEV_BAN_USERS_PREMIUM_VERSION ) {
                $settings['notification_emails'] = null;
                $settings['send_notification_new_post'] = 0;
        }

        // get email templates
        // --
        $ban_email_body             = include 'templates/emails/ban-user.tpl.php';
        $unban_email_body           = include 'templates/emails/unban-user.tpl.php';
        $warn_email_body            = include 'templates/emails/warn-user.tpl.php';
        $admin_login_body           = include 'templates/emails/admin-login.tpl.php';
        $new_ip_login_email_body    = include 'templates/emails/new-ip-login.tpl.php';


        $notification_templates = array(
            'user_notification'                 => array(
                'subject_title'                 => __('Your account has been suspended.', 'ban-users'),
                'body'                          => $ban_email_body, 
                'unban_subject_title'           => __('Your account has been reinstated.', 'ban-users'),
                'unban_body'                    => $unban_email_body,
                'unban_indefinite_date_tag'     => __('No date specified', 'ban-users'),
                'warn_subject_title'            => __('Your account is at risk of being banned.'),
                'warn_body'                     => $warn_email_body,
                'warn_body_reason'              => true,
                'admin_login_subjet_title'      => __('Administrator login', 'ban-users'),
                'admin_login_body'              => $admin_login_body,
                'new_ip_login_subject_title'    => __('Account accessed from new IP address', 'ban-users'),
                'new_ip_login_body'             => $new_ip_login_email_body,


                ),
            'admin_notification' => array(),
            'team_notification' => array()
            );

        if ( W3DEV_BAN_USERS_PREMIUM_VERSION ) {
            $registration_ban_options = array(
                'enable_reg_ban_by_email'       => 1,
                'enable_login_ban_by_email'     => 1, 
                'enable_reg_ban_by_ip'          => 1,
                'enable_login_ban_by_ip'        => 1
                );
        }

                $data = $settings;
                switch ($set) {
                    case 'user_notification':
                            $data = $notification_templates;
                            break;
                    
                    case 'registration_ban_options':
                            $data = $registration_ban_options;
                            break;

                    default:
                            $data = $settings;
                            break;
                }

                return $data;
        }


        // append and prepends email header and footer to email body
        // --
        public function email_builder($body=false) {

            if (empty($body)) return null;

            // get email templates
            // --
            $email_header   = include 'templates/emails/header.tpl.php';
            $email_footer   = include 'templates/emails/footer.tpl.php';

            $body = $email_header.$body.$email_footer;
            return $body;

        }



        // return the version id of the plugin
        // --
        public function version_id() {
                return ( W3DEV_DEBUG_MODE === '1' ) ? time() : W3DEV_BAN_USERS_PLUGIN_VERSION ;
        }

        // return the user's IP Address
        // --
        public function get_ip_address() {

                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }
                return $ip;

        }

        // return the user's agent
        // --
        public function get_user_agent() {

                return $_SERVER['HTTP_USER_AGENT'];

        }

        // return the user's geodata
        // --
        public function get_geodata() {

            $settings   = $this->get_options('settings');
            $ip_address = $this->get_ip_address();
            $api        = $settings['ip_api'];

            if ( ! function_exists( 'file_get_contents_request_method' )) { 
            function file_get_contents_request_method($api,$ip_address) {

                if (!ini_get('allow_url_fopen')) return false;
                if (empty($api)) return false;
                if (empty($ip_address)) return false;

                switch ($api) {
                    case 'ip-api.com':
                        $api_url = 'http://ip-api.com/php/';
                        $query = @unserialize(file_get_contents($api_url.$ip_address));
                        break;
                    
                    case 'w3-ip.com':
                        $api_key = get_option('w3dev_api_key_w3_ip');
                        $api_key = !empty($api_key) ? $api_key : '0';
                        $api_url = "http://w3-ip.com/api/$api_key/";
                        $query = json_decode(file_get_contents($api_url.$ip_address), true);
                        break;

                    default:
                        $api_url = 'http://ip-api.com/php/';
                        $query = @unserialize(file_get_contents($api_url.$ip_address));
                        break;

                }
                return $query;

            }}

            if ( ! function_exists( 'curl_request_method' )) { 
            function curl_request_method($api,$ip_address) {

                if (empty($api)) return false;
                if (empty($ip_address)) return false;
               
                switch ($api) {
                    case 'ip-api.com':
                        $api_url = 'http://ip-api.com/php/';
                        break;
                    
                    case 'w3-ip.com':
                        $api_key = get_option('w3dev_api_key_w3_ip');
                        $api_key = !empty($api_key) ? $api_key : '0';
                        $api_url = "http://w3-ip.com/api/$api_key/";
                        break;

                    default:
                        $api_url = 'http://ip-api.com/php/';
                        break;

                }

                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $api_url . $ip_address);  
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                if ($api == 'w3-ip.com') {
                    $query = json_decode(curl_exec($curl), true);
                } else {
                    $query = unserialize(curl_exec($curl));

                }
                curl_close($curl);
                return $query;

            }}

            $api_results = false;
            if (!empty($ip_address) && !empty($api)) {
                if ( empty($settings['ip_api_request_method']) ) {
                    if (!$api_results = file_get_contents_request_method($api,$ip_address)) {
                        $api_results = curl_request_method($api,$ip_address);
                    }
                } elseif ($settings['ip_api_request_method'] == 'file_get_contents') {
                    $api_results = file_get_contents_request_method($api,$ip_address);
                } elseif ($settings['ip_api_request_method'] == 'curl') {
                    $api_results = curl_request_method($api,$ip_address);
                }
            }

            // record event { get geodata }
            // --
            $this->log_event(array('category' => 'api', 'action' => 'geodata'));

            $geodata = ( !empty($api_results['status']) && $api_results['status'] == 'success' ) ? json_encode($api_results) : null;
            return $geodata;


        }


        // return the full url of the plugin directory
        // --
        public function plugin_folder() {
                $plugin_folder = basename(dirname(__FILE__));
                return WP_PLUGIN_URL.'/'.$plugin_folder;
        }

    public function ban_user( $user_id, $message="%%reason%%", $date = 'Indefinent', $ban_duration = false, $hide_avatar = false) {

        // if not in admin then return false
        // --
        if ($this->is_admin == false) { return false; }
        
        $default_settings           = $this->default_options('settings');
        $default_user_notification  = $this->default_options('user_notification');

        $settings = get_option('w3dev_ban_user_options', $default_settings);

        if (!empty($settings['change_posts_status'])) {
            if (!empty($settings['post_status'])) {
                $args = array('author' => $user_id);
                $user_posts = get_posts( $args );
                if (!empty($user_posts)) {
                    foreach ($user_posts as $a_post) {
                        $post = array( 'ID' => $a_post->ID, 'post_status' => $settings['post_status'] );
                        wp_update_post($post);
                    }
                }
            }
        }

        if (!empty($settings['on_ban_change_user_role'])) {
            if (!empty($settings['set_banned_user_role'])) {
                $args = array('ID' => $user_id,'role' => $settings['set_banned_user_role']);
                wp_update_user( $args );
            }
        }
        
        if (!empty($settings['scramble_banned_users_password'])) {
            $scrambled_password = wp_generate_password();
            wp_set_password( $scrambled_password, $user_id );
        }

        if (!empty($settings['set_spammer_option'])) {
            function w3dev_set_spammer_option( $id, $pref, $value, $deprecated = null ) {

                global $wpdb;
                $wpdb->update( $wpdb->users, array( sanitize_key( $pref ) => $value ), array( 'ID' => $id ) );
                $user = new WP_User( $id );
                clean_user_cache( $user );

            }
            w3dev_set_spammer_option( $user_id, 'user_status', 1 );
        }

        // here we check to see if a ban duration has been selected
        // and if so then we set the date accordingly
        // --
        if (!empty($ban_duration)) {

            $now = date("Y-m-d H:i:s");

            switch ($ban_duration) {
                case 'indefinately':
                    $date = null;
                    break;

                case '1 day':
                    $date = date('Y-m-d H:i:s', strtotime($now . ' +1 day'));
                    break;

                case '1 week':
                    $date = date('Y-m-d H:i:s', strtotime($now . ' +1 week'));
                    break;

                case '2 weeks':
                    $date = date('Y-m-d H:i:s', strtotime($now . ' +2 weeks'));
                    break;

                case '1 month':
                    $date = date('Y-m-d H:i:s', strtotime($now . ' +1 month'));
                    break;

                case 'date picker':
                    $date = $date;
                    break;
                                
                default:
                    $date = null;
                    break;
            }

        }
        
        // Remove previous unban (if any)
        // Set new unban schedule (if defined)
        // --
        wp_unschedule_event(  wp_next_scheduled('w3dev_unban_user', array( intval($user_id) )), 'w3dev_unban_user', array( intval($user_id) ));
        if ($date != null) {
            if ( $settings['date_format'] == "m-d-Y") $date = str_replace('-', '/', $date); // Converts to be assumed as American.
            wp_schedule_single_event( strtotime($date), 'w3dev_unban_user', array( intval($user_id)) );
        }

        // Update hide avatar status
        update_user_option( $user_id, 'w3dev_hide_avatar', $hide_avatar, FALSE );

        // Update status
        //
        if ( ! $this->is_user_banned( $user_id ) ) {

            global $wpdb;

            // set the user to banned
            // --
            update_user_option( $user_id, 'w3dev_user_banned', TRUE, FALSE );
            update_user_option( $user_id, 'w3dev_user_banned_date', date('d-m-Y'), FALSE );

            // record event { banning a user }
            // --
            $this->log_event(array('category' => 'user', 'action' => 'banned', 'label' => $user_id));

            // if ban reason (passed as paramater = message)
            // has been supplied then store with the userdata.
            // --
            if (!empty($message)) {
                $message = strip_tags($message);
                update_user_option( $user_id, 'w3dev_user_banned_reason', $message, FALSE );
                
            } elseif (!empty($settings['ban_email_default_message'])) {
                
                // Store the message as a variable for manipulation
                // Find if tags exist to be modified
                // --
                $body = $settings['ban_email_default_message'];
                $find_reason_tag            = strpos( $body, '%%reason%%' );
                $find_unban_date_tag        = strpos( $body, '%%unban_date%%' );

                // Determine if the message sent as a parameter is empty
                // Replaces the empty message with a generic one
                // --
                if ( empty($message) ) { $message = $settings['ban_email_default_message']; }
                if ( $find_reason_tag !== false ) { $body = str_replace('%%reason%%', $message, $body); }
                if ( $find_unban_date_tag !== false ) { $body = str_replace('%%unban_date%%', (!empty($date) ? date($settings['date_format'], strtotime($date)) : $ban_user_email_notification['unban_indefinite_date_tag']), $body); }

                update_user_option( $user_id, 'w3dev_user_banned_reason', $body, FALSE );
            }

            // email should be sent
            // -- 
            if ( $settings['ban_email'] ) {

                // let's grab the users email address from the db
                // and pass it through php filter to sanitise it
                // --
                $user_info  = get_userdata($user_id);
                $user_email = $user_info->user_email;
                $user_email = filter_var($user_email, FILTER_SANITIZE_EMAIL);
        
                if (!empty($user_email)) {
        
                    // let's get the plugin template options
                    // --
                    $email_templates = get_option('w3dev_ban_user_email_templates', $default_user_notification);

                    // next we need to get the template and replace the reason tag 
                    // %%reason%% with the text provided in the options or popup window
                    // --
                    $ban_user_email_notification        = $email_templates['user_notification'];
                    $subject_title                      = !empty( $ban_user_email_notification['subject_title'] ) ? $ban_user_email_notification['subject_title'] : $default_user_notification['user_notification']['subject_title'];
                    $body                               = !empty( $ban_user_email_notification['body'] ) ? $ban_user_email_notification['body'] : $default_user_notification['user_notification']['body'];
                    $find_reason_tag                    = strpos( $body, '%%reason%%' );
                    $find_unban_date_tag                = strpos( $body, '%%unban_date%%' );
        
                    // Determine if the message sent as a parameter is empty
                    // Replaces the empty message with a generic one
                    // --
                    if ( empty($message) ) { $message = $settings['ban_email_default_message']; }
                    if ( $find_reason_tag !== false ) { $body = str_replace('%%reason%%', $message, $body); }
                    if ( $find_unban_date_tag !== false ) { $body = str_replace('%%unban_date%%', (!empty($date) ? date($settings['date_format'], strtotime($date)) : $ban_user_email_notification['unban_indefinite_date_tag']), $body); }

                    $user = get_user_by( 'ID', $user_id );
                    if (!empty($user)) {
                        $body = str_replace('%%username%%', $user->user_login, $body);
                        $body = str_replace('%%first_name%%', $user->first_name, $body);
                        $body = str_replace('%%last_name%%', $user->last_name, $body);
                    }
        
                    // define headers
                    // --
                    $headers = array();
                    $headers[] = "Content-Type: text/html; charset=utf-8\r\n";

                    // include bcc and cc if applicable
                    // --
                    if (!empty($ban_user_email_notification['ban_cc_field'])) { $headers[] = 'Cc: '.$ban_user_email_notification['ban_cc_field']; }
                    if (!empty($ban_user_email_notification['ban_bcc_field'])) { $headers[] = 'Bcc: '.$ban_user_email_notification['ban_bcc_field']; }

                    // finally, a quick check to ensure the email is valid
                    // before sending using wp_mail
                    // --
                    if (!filter_var($user_email, FILTER_VALIDATE_EMAIL) === false) {
                        wp_mail( $user_email, $subject_title, $body, $headers );            
                    }

                }

            }

        }
    }


    public function unban_user( $user_id ) {

        $settings       = $this->get_options('settings');
        $notifications  = $this->get_options('notifications','user_notification');

        // Update status
        if ( $this->is_user_banned( $user_id ) ) {

            wp_unschedule_event(  wp_next_scheduled('w3dev_unban_user', array( intval($user_id) )), 'w3dev_unban_user', array( intval($user_id) ));
            update_user_option( $user_id, 'w3dev_user_banned', FALSE, FALSE );
            update_user_option( $user_id, 'w3dev_user_unbanned_date', date('d-m-Y'), FALSE );
            update_user_option( $user_id, 'w3dev_hide_avatar', FALSE, FALSE);

            // unban user's last known ip address
            // --
            if (!empty($settings['always_unban_ipaddress'])) {
                if ($last_known_ip_address = $this->get_last_known_ip_address($user_id)) {
                    if ($is_ip_address_banned = $this->is_ip_address_banned($last_known_ip_address)) {
                        $this->delete_banned_ip_address($last_known_ip_address);
                    }
                }
            }

            if (!empty($settings['on_unban_change_user_role'])) {
                if (!empty($settings['set_unbanned_user_role'])) {
                    $args = array('ID' => $user_id,'role' => $settings['set_unbanned_user_role']);
                    wp_update_user( $args );
                }
            }

            if (!empty($settings['unset_spammer_option'])) {
                function w3dev_unset_spammer_option( $id, $pref, $value, $deprecated = null ) {

                    global $wpdb;
                    $wpdb->update( $wpdb->users, array( sanitize_key( $pref ) => $value ), array( 'ID' => $id ) );
                    $user = new WP_User( $id );
                    clean_user_cache( $user );

                }
                w3dev_unset_spammer_option( $user_id, 'user_status', 0 );
            }

            // record event { unban a user }
            // --
            $this->log_event(array('category' => 'user', 'action' => 'unban', 'label' => $user_id));

            global $wpdb;

            // email should be sent
            // -- 
            if( $settings['ban_email'] ) {

                // let's grab the users email address from the db
                // and pass it through php filter to sanitise it
                // --
                $user_info  = get_userdata($user_id);
                $user_email = $user_info->user_email;
                $user_email = filter_var($user_email, FILTER_SANITIZE_EMAIL);
        
                if (!empty($user_email)) {
        
                    // next we need to get the template and replace the reason tag 
                    // %%reason%% with the text provided in the options or popup window
                    // --
                    $unban_subject_title = 
                        !empty( $notifications['unban_subject_title'] ) ? 
                        $notifications['unban_subject_title'] : 
                        $notifications['_defaults']['user_notification']['unban_subject_title'] ;
        
                    // Determine if the message sent as a parameter is empty
                    // Replaces the empty message with a generic one
                    // --
                    $message = 
                        !empty($notifications['unban_body']) ? 
                        $notifications['unban_body'] : 
                        $notifications['_defaults']['user_notification']['unban_body'] ;


                    $message = str_replace('%%username%%', $user_info->user_login, $message);
                    $message = str_replace('%%first_name%%', $user_info->first_name, $message);
                    $message = str_replace('%%last_name%%', $user_info->last_name, $message);

                    // define headers
                    // --
                    $headers = array();
                    $headers[] = "Content-Type: text/html; charset=utf-8\r\n";

                    // include bcc and cc if applicable
                    // --
                    if (!empty($notifications['unban_cc_field'])) { $headers[] = 'Cc: '.$notifications['unban_cc_field']; }
                    if (!empty($notifications['unban_bcc_field'])) { $headers[] = 'Bcc: '.$notifications['unban_bcc_field']; }

                    // finally, a quick check to ensure the email is valid
                    // before sending using wp_mail
                    // --
                    if (!filter_var($user_email, FILTER_VALIDATE_EMAIL) === false) {
                        wp_mail( $user_email, $unban_subject_title, $message, $headers );           
                    }

                }

            }

        }

    }


    public function send_admin_login($user) {
    
        $settings       = $this->get_options('settings');
        $notifications  = $this->get_options('notifications','user_notification');
                                        
        $admin_login_subject_title = 
            !empty( $notifications['admin_login_subject_title'] ) ? 
            $notifications['admin_login_subject_title'] : 
            $notifications['_defaults']['user_notification']['admin_login_subject_title'] ;
            
        $admin_login_body = 
            !empty( $notifications['admin_login_body'] ) ? 
            $notifications['admin_login_body'] : 
            $notifications['_defaults']['user_notification']['admin_login_body'] ;
            
        if (!empty($user)) {
            $admin_login_body = str_replace('%%username%%', $user->user_login, $admin_login_body );
            $admin_login_body = str_replace('%%first_name%%', $user->first_name, $admin_login_body );
            $admin_login_body = str_replace('%%last_name%%', $user->last_name, $admin_login_body );
        }

        $headers = array();
        $headers[] = "Content-Type: text/html; charset=utf-8\r\n";

        // get the site's admin email address
        // --
        $admin_email = get_bloginfo( "admin_email");
        if( !empty( $admin_email) ) {
            $t = wp_mail( get_bloginfo( "admin_email"), $admin_login_subject_title, $this->email_builder($admin_login_body), $headers );  
        }

    }


    public function send_notification_new_ip_address($email_address,$new_ip_address) {

        $email_tpl = $this->get_options('notifications','user_notification');

            $new_ip_login_subject_title = 
                    !empty( $email_tpl['new_ip_login_subject_title'] ) ? 
                    $email_tpl['new_ip_login_subject_title'] : 
                    $email_tpl['_defaults']['user_notification']['new_ip_login_subject_title'];
            
            $new_ip_login_body = 
                    !empty( $email_tpl['new_ip_login_body'] ) ? 
                    $email_tpl['new_ip_login_body'] : 
                    $email_tpl['_defaults']['user_notification']['new_ip_login_body'] ;

            $find_ip_address_tag = strpos( $new_ip_login_body, '%%ip_address%%' );

            if ( $find_ip_address_tag !== false ) {
                    $new_ip_login_body = str_replace('%%ip_address%%', $new_ip_address, $new_ip_login_body);
            }

            if (!filter_var($email_address, FILTER_VALIDATE_EMAIL) === false) {
                    wp_mail( $email_address, $new_ip_login_subject_title, $this->email_builder($new_ip_login_body), "Content-Type: text/html; charset=utf-8\r\n" );                
            }

    }

    public function ban_tag_edit( $message, $user_id, $ban_info = null) {

	if ( $user_id != true )
		$user_id = get_current_user_id();

        // Get date settings
        // --
        $settings       = $this->get_options('settings');
        $notifications  = $this->get_options('notifications','user_notification');

        // Determine if tags exist
        // --
        $find_reason_tag            = strpos( $message, '%%reason%%' );
        $find_unban_date_tag        = strpos( $message, '%%unban_date%%' );

        $unban_indefinite_date_tag = 
            !empty($notifications['unban_indefinite_date_tag']) ? 
            $notifications['unban_indefinite_date_tag'] :
            $notifications['_defaults']['user_notification']['unban_indefinite_date_tag'] ;

        // Determine if the message sent as a parameter is empty
        // Replaces the empty message with a generic one
        // --
        if ( $find_reason_tag !== false ) { 
            $reason = (!empty($ban_info["reason"])) ? $ban_info["reason"] : get_user_option( 'w3dev_user_banned_reason', $user_id);
            $message = str_replace('%%reason%%', $reason, $message );
        }

        if ( $find_unban_date_tag !== false ) { 
            $date = (!empty($ban_info["date"])) ? $ban_info["date"] : wp_next_scheduled('w3dev_unban_user', array( intval($user_id) ));
            $message = str_replace('%%unban_date%%', (!empty($date) ? date($settings['date_format'], $date) : $unban_indefinite_date_tag), $message);
        }			
        return $message;
    }

    public function is_user_banned( $user_id ) {
        return get_user_option( 'w3dev_user_banned', $user_id);
    }
    
    public function is_hide_avatar($user_id) {
        return get_user_option( 'w3dev_hide_avatar', $user_id);
    }

    // purpose of this function is to load and include files
    // that are included in the extensions folder
    public function load_extensions() {

        $directory = '/path/to/my/extensions';
        $scanned_directory = array_diff(scandir($directory), array('..', '.'));

        if (!empty($scanned_directory)) {
            foreach ($scanned_directory as $file) {
                include_once($directory.'/'.file);
            }
        }

    }


    public function get_options($option,$array_key=false) {

            $options = false;

            if ($option == 'settings') {

                    $defaults = $this->default_options('settings');

                    if (!empty($array_key)) {
                            $arr = get_option('w3dev_ban_user_options', $defaults);
                            $options = $arr[$array_key];
                    } else {
                            $options = get_option('w3dev_ban_user_options', $defaults);
                    }
                    
                    $options['_defaults'] = $defaults;

            } elseif ($option == 'notifications') {

                $defaults = $this->default_options('user_notification');

                if (!empty($array_key)) {
                        $arr = get_option('w3dev_ban_user_email_templates', $defaults);
                        $options = $arr[$array_key];
                } else {
                        $options = get_option('w3dev_ban_user_email_templates', $defaults);
                }
                
                $options['_defaults'] = $defaults;

            } elseif ($option == 'registration') {

                $defaults = $this->default_options('registration_ban_options');

                if (!empty($array_key)) {
                        $arr = get_option('w3dev_ban_user_registration_options', $defaults);
                        $options = $arr[$array_key];
                } else {
                        $options = get_option('w3dev_ban_user_registration_options', $defaults);
                }
                
                $options['_defaults'] = $defaults;

        }

        return $options;

    }

    // rename from stat to event...
    public function log_event($args=false) {

        if (empty($args)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_ubu_events';
        if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {
            $wpdb->insert( 
                $db_table_name, 
                array( 
                    'category'      => (isset($args['category']) ? $args['category'] : 0),
                    'action'        => (isset($args['action']) ? $args['action'] : 0),
                    'label'         => (isset($args['label']) ? $args['label'] : null),
                    'value'         => (isset($args['value']) ? $args['value'] : null),
                    'user_id'       => (isset($args['user_id']) ? $args['user_id'] : null),
                    'date_created'  => date('Y-m-d H:i:s')
                )
            );
            $record_id = $wpdb->insert_id;
            return $record_id;
        }

        // EVENTS
        // --
        /*
        
        login | success
        login | failed
        login | denied | user/ip/email/ccode/useragent/spam
        login | password reset

        register | success
        register | denied | username/ip/email/ccode/useragent/spam

        notification | warn user

        user | banned
        user | unbanned

        api | geodata
        */



    }

    public function get_shared_accounts($user_id=null) {

        if (empty($user_id)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_login_details';

        // get list of ips associated with the user_id
        // --
        $results = $wpdb->get_results($wpdb->prepare("
            SELECT user_login, device, geodata, user_id, ip_address, ".$db_table_name.".date_time 
            FROM $db_table_name
            LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
            WHERE user_id = %d
            GROUP BY ip_address
            ORDER BY date_time DESC
            ", $user_id
            ));

        // next get array of user_ids where ip_address in array
        // --
        if (!empty($results)) {
            $ips = array();
            foreach($results as $row) { $ips[] = $row->ip_address; }

            if (!empty($ips)) {
                $sql = $wpdb->prepare("
                SELECT user_login, device, geodata, user_id, ip_address, ".$db_table_name.".date_time 
                FROM $db_table_name
                LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
                WHERE ip_address IN (%s) 
                GROUP BY user_id
                ORDER BY date_time DESC
                ", implode(",",$ips)
                );
                $results = $wpdb->get_results($sql);
            } else {
                return false;
            }

        }

        return $results;

    }


    public function get_user_history($user_id=null) {

        if (empty($user_id)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_login_details';

        // get list of ips associated with the user_id
        // --
        $results = $wpdb->get_results($wpdb->prepare("
            SELECT user_login, device, geodata, user_id, ip_address, ".$db_table_name.".date_time 
            FROM $db_table_name
            LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
            WHERE user_id = %d
            ORDER BY date_time DESC
            LIMIT 8
            ", $user_id
            ));

        return $results;

    }


    public function get_device_icon($data=null) {

        if (empty($data)) return null;

        switch (strtolower($data)) {
            case 'desktop':
                $device = '<span style="color:#333;margin-right: 3px;"><i class="fa fa-desktop" aria-hidden="true"></i></span> ';
                break;
            
            case 'mobile':
                $device = '<span style="color:#333;margin-right: 3px;"><i class="fa fa-mobile" aria-hidden="true"></i></span> ';
                break;

            case 'tablet':
                $device = '<span style="color:#333;margin-right: 3px;"><i class="fa fa-tablet" aria-hidden="true"></i></span> ';
                break;

            default:
                $device = '<span style="color:#999;margin-right: 3px;">('.ucfirst($data).')</span>';
                break;
        }

        return $device;

    }

    public function get_country_flag($data=null) {

        if (empty($data)) return null;

        $geodata = json_decode($data, true);
        
        $data = array();
        if (!empty($geodata['countryCode']) && !empty($geodata['country'])) {
            $data['image'] = '<span style="position:relative; bottom:-3px; margin-right: 5px;" src="blank.gif" class="flag flag-'.strtolower($geodata['countryCode']).'" alt="'.$geodata['country'].'"></span>';
            $data['country_name'] = $geodata['country']; 
        } elseif (!empty($geodata['country_code']) && !empty($geodata['country_name'])) {
            $data['image'] = '<span style="position:relative; bottom:-3px; margin-right: 5px;" src="blank.gif" class="flag flag-'.strtolower($geodata['country_code']).'" alt="'.$geodata['country_name'].'" /></span>';
            $data['country_name'] = $geodata['country_name'];
        }

        return $data;

    }

    public function get_last_known_ip_address($user_id=null) {

        if (empty($user_id)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_login_details';

        // get list of ips associated with the user_id
        // --
        $results = $wpdb->get_results($wpdb->prepare("
            SELECT ip_address, ".$db_table_name.".date_time 
            FROM $db_table_name
            LEFT JOIN ".$wpdb->prefix."users ON ".$wpdb->prefix."users.ID = ".$db_table_name.".user_id
            WHERE user_id = %d 
            AND ip_address IS NOT NULL
            ORDER BY date_time DESC
            LIMIT 1
            ", $user_id
            ));

        return (!empty($results[0]->ip_address)) ? long2ip($results[0]->ip_address) : false;

    }

    public function delete_banned_ip_address($ip_address=null) {

        if (empty($ip_address)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
        $wpdb->delete( $db_table_name, array('ip_address' => ip2long($ip_address)) );

        return true;

    }

    public function is_ip_address_banned($ip_address=null) {

       if (empty($ip_address)) return false;

        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';

        $is_ip_banned = $wpdb->get_results( $wpdb->prepare("
            SELECT * FROM ".$db_table_name."
            WHERE ip_address = %d", ip2long($ip_address))
        );

        return (!empty($is_ip_banned)) ? true : false;

    }

    public function is_domain_forbidden($email_address) {
        global $wpdb;
        $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';

        $db_wildcard_email = $wpdb->get_results( $wpdb->prepare("
           SELECT * 
           FROM ".$db_table_name."
           WHERE email_address
           LIKE %s", '%*%')
        );

        for ($index = 0; $index < sizeof($db_wildcard_email); $index++) {
            $db = get_object_vars($db_wildcard_email[$index]);
            $is_email_banned =
                        ( !empty(preg_match("/". preg_replace("/\*/", "\\\S+", $db["email_address"]) ."/",
                        $email_address)) ) ? $db_wildcard_email[$index] : 0;

            if(!empty($is_email_banned))
                return true;
        }

        return false;
    }

    public function display_label($type) {

        $html = null;
        switch ($type) {
            case 'new':
                $html = '<span style="position: relative;top:-1px;" class="bs-label label-success">'.__('NEW', 'ban-users').'</span>';
                break;
            
            case 'updated':
                $html = '<span style="position: relative;top:-1px;" class="bs-label label-warning">'.__('UPDATED', 'ban-users').'</span>';
                break;
        }
        
        echo $html;

    }

}

?>
