<?php
if ( ! defined('ABSPATH' ) ) exit;

function w3dev_ban_user_options_partial()
{

    global $wpdb;
    $db_table_name = $wpdb->prefix . 'w3dev_login_details';
    if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {

        // only alert on 2nd ip, so skip first insert/record
        // --
        $results = $wpdb->get_results( "SELECT count(id) as count, DATE_FORMAT(date_time, '%Y/%m/%d') as date_time2 FROM ".$db_table_name." GROUP BY date_time2 ORDER BY date_time2 ASC");
        
        foreach($results as $row) {
            //echo long2ip($row->ip_address)." ";
            $logins[] = $row->count;
            $dates[] = date('d-m-Y', strtotime($row->date_time2));
        }

    }

    ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.min.js" integrity="sha256-SiHXR50l06UwJvHhFY4e5vzwq75vEHH+8fFNpkXePr0=" crossorigin="anonymous"></script>

    <?php

    global $wp_roles;
    $roles = $wp_roles->get_names();

    $w3dev_ban_user_class       = W3DEV_BAN_USER_CLASS::get_instance();
    $settings                   = $w3dev_ban_user_class->get_options('settings');
    $notifications              = $w3dev_ban_user_class->get_options('notifications');
    $registration_ban_options   = $w3dev_ban_user_class->get_options('registration');
    $email_template             = $notifications['user_notification'];
    //delete_option('w3dev_api_key_w3_ip');f
    $w3dev_api_key_w3_ip        = get_option('w3dev_api_key_w3_ip');

    // note to self, need to move into class
    // --
    $w3dev_ban_css_scipts_options = get_option('w3dev_ban_css_scipts_options');
    $w3dev_banned_word_options = get_option('w3dev_banned_word_options');

    $inc_header_css = !empty($w3dev_ban_css_scipts_options['inc_header_css']) ? 1 : 0;
    $inc_footer_js  = !empty($w3dev_ban_css_scipts_options['inc_footer_js']) ? 1 : 0;

    // set default values
    // --
    $default_ban_subject_title              = isset( $notifications['_defaults']['user_notification']['subject_title'] ) ? $notifications['_defaults']['user_notification']['subject_title'] : null;
    $default_ban_body                       = isset( $notifications['_defaults']['user_notification']['body'] ) ? $notifications['_defaults']['user_notification']['body'] : null;
    $default_unban_subject_title            = isset( $notifications['_defaults']['user_notification']['unban_subject_title'] ) ? $notifications['_defaults']['user_notification']['unban_subject_title'] : null;
    $default_unban_body                     = isset( $notifications['_defaults']['user_notification']['unban_body'] ) ? $notifications['_defaults']['user_notification']['unban_body'] : null;
    $default_unban_indefinite_date_tag      = isset( $notifications['_defaults']['user_notification']['unban_indefinite_date_tag'] ) ? $notifications['_defaults']['user_notification']['unban_indefinite_date_tag'] : null;
    $default_warn_subject_title             = isset( $notifications['_defaults']['user_notification']['warn_subject_title'] ) ? $notifications['_defaults']['user_notification']['warn_subject_title'] : null ;
    $default_warn_body                      = isset( $notifications['_defaults']['user_notification']['warn_body'] ) ? $notifications['_defaults']['user_notification']['warn_body'] : null ;

    // set saved values
    // --
    $ban_subject_title              = !empty( $email_template['subject_title'] ) ? $email_template['subject_title'] : $default_ban_subject_title;
    $ban_body                       = !empty( $email_template['body'] ) ? $email_template['body'] : $default_ban_body;
    $ban_cc_field                   = !empty( $email_template['ban_cc_field'] ) ? $email_template['ban_cc_field'] : null;
    $ban_bcc_field                  = !empty( $email_template['ban_bcc_field'] ) ? $email_template['ban_bcc_field'] : null;

    $unban_subject_title            = !empty( $email_template['unban_subject_title'] ) ? $email_template['unban_subject_title'] : $default_unban_subject_title;
    $unban_body                     = !empty( $email_template['unban_body'] ) ? $email_template['unban_body'] : $default_unban_body;
    $unban_indefinite_date_tag      = !empty( $email_template['unban_indefinite_date_tag'] ) ? $email_template['unban_indefinite_date_tag'] : $default_unban_indefinite_date_tag;
    $unban_cc_field                 = !empty( $email_template['unban_cc_field'] ) ? $email_template['unban_cc_field'] : null;
    $unban_bcc_field                = !empty( $email_template['unban_bcc_field'] ) ? $email_template['unban_bcc_field'] : null;

    $warn_subject_title             = !empty( $email_template['warn_subject_title'] ) ? $email_template['warn_subject_title'] : $default_warn_subject_title;
    $warn_body                      = !empty( $email_template['warn_body'] ) ? $email_template['warn_body'] : $default_warn_body ;
    $warn_cc_field                  = !empty( $email_template['warn_cc_field'] ) ? $email_template['warn_cc_field'] : null;
    $warn_bcc_field                 = !empty( $email_template['warn_bcc_field'] ) ? $email_template['warn_bcc_field'] : null;

    $admin_login_subject_title      = !empty( $email_template['admin_login_subject_title'] ) ? $email_template['admin_login_subject_title'] : null;
    $admin_login_body               = !empty( $email_template['admin_login_body'] ) ? $email_template['admin_login_body'] : null;

    ?>

    <div id="ban-user-container">

        <div style="position:relative;background-image: url(https://ps.w.org/ban-users/assets/banner-772x250.png?rev=1455118); background-size: cover; background-position: center center; background-repeat: no-repeat;height: 200px;margin-left:-20px;margin-right: -20px;margin-top: -20px;margin-bottom: 20px;padding: 30px;">
            
            <div style="position:absolute;bottom: 30px;">
                <h1 style="letter-spacing:2px;margin-bottom:0;background-color:#111;background-color:rgba(0,0,0,0.8);display:inline-block;padding: 12px 20px;line-height:1em;color:#fff;border-radius: 4px;"><span style="color: #e5a238">Ultimate</span> BAN Users - <span style="letter-spacing:0;color:#e5a238;font-weight:300;">v<?php echo W3DEV_BAN_USERS_PLUGIN_VERSION; ?></span></h1> 
            </div>

        </div>

<!--
        <div class="cf" id="w3dev-widgts" style="margin-top: 20px;display:block">
            <div class="w3dev-info-widgt" style="margin-bottom: 20px;">
                <div class="w3dev-inner-widgt">
                    <h3>Failed logins past 24 hours</h3>
                    <span class="count error">323 <i class="fa fa-chevron-circle-up" aria-hidden="true"></i></span>
                </div>
            </div>
            <div class="w3dev-info-widgt" style="margin-bottom: 20px;">
                <div class="w3dev-inner-widgt">
                    <h3>Successful logins past 24 hours</h3>
                    <span class="count success">1023 <i class="fa fa-chevron-circle-down" aria-hidden="true"></i></span>
                </div>
            </div>
            <div class="w3dev-info-widgt" style="margin-bottom: 20px;">
                <div class="w3dev-inner-widgt">
                    <h3>Total banned stats</h3>
                    <span class="count success">10<span style="font-size: .5em;color:#777">Users</span>, 12<span style="font-size: .5em;color:#777">IPs</span>, 20<span style="font-size: .5em;color:#777">Emails</span></span>
                </div>
            </div>
        </div>

        <style>
            #w3dev-widgts { margin-bottom: 30px; }
            .w3dev-info-widgt { background-color: #f9f9f9; float: left; border: 1px solid #dedede; margin-right: 10px; }
            .w3dev-info-widgt .w3dev-inner-widgt { padding: 10px; border-left: 5px solid #dedede; }
            .w3dev-info-widgt h3 { font-size: 14px!important; }
            .w3dev-info-widgt span.count { font-size: 34px!important; }
            .w3dev-info-widgt span.count.error { color: #d9534f; }
            .w3dev-info-widgt span.count.success { color: #5cb85c; }
            .w3dev-info-widgt i.fa { font-size: 22px; }
        </style>
-->

        <ul id="w3dev-tabs">
            <li><a class="active" data-tab="options" href="javascript:void(0)">Options</a></li>
            <li><a data-tab="email-template" href="javascript:void(0)">Email Templates</a></li>
            <?php if (W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
                <li><a data-tab="registration-ban" href="javascript:void(0)">Registration Bans</a></li>
            <?php } ?>
            <li><a data-tab="faqs" href="javascript:void(0)">FAQs</a></li>
            <?php if (!W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
                <li class="go-pro"><a data-tab="go-pro" href="javascript:void(0)"><span>Go Pro!</span></a></li>
            <?php } ?>
        </ul>
        <div class="w3dev-tab active" id="tab-options">

            <form style="padding-top: 15px;">

                <div id="w3dev-js-scrollto-section" class="w3dev-quick-links" style="margin-bottom:10px;">
                    <a href="#w3dev-accessibility-section"><i class="fa fa-4x fa-low-vision" aria-hidden="true"></i></a>
                    <a href="#w3dev-api-section"><i class="fa fa-4x fa-key" aria-hidden="true"></i></a>
                    <a href="#w3dev-general-section"><i class="fa fa-4x fa-cog" aria-hidden="true"></i></a>
                    <a href="#w3dev-ban-options-section"><i class="fa fa-4x fa-ban" aria-hidden="true"></i></a>
                    <a href="#w3dev-default-messages-section"><i class="fa fa-4x fa-bullhorn" aria-hidden="true"></i></a>
                    <a href="#w3dev-ipgeo-section"><i class="fa fa-4x fa-map-marker" aria-hidden="true"></i></a>
                    <a href="#w3dev-notification-section"><i class="fa fa-4x fa-flag" aria-hidden="true"></i></a>
                    <a href="#w3dev-users-table-section"><i class="fa fa-4x fa-table" aria-hidden="true"></i></a>
                    <a href="#w3dev-warn-options-section"><i class="fa fa-4x fa-exclamation-triangle" aria-hidden="true"></i></a>
                    <a href="#w3dev-security-section"><i class="fa fa-4x fa-shield" aria-hidden="true"></i></a>
                    <a href="#w3dev-banned-keywords-section"><i class="fa fa-4x fa-file-text-o" aria-hidden="true"></i></a>

                    <a href="#w3dev-3rdparty-section"><i class="fa fa-4x fa-plug" aria-hidden="true"></i></a>
                    <a href="#w3dev-css-scripts-section"><i class="fa fa-4x fa-code" aria-hidden="true"></i></a>
                    <a href="#w3dev-shortcodes-section"><i class="fa fa-4x fa-wordpress" aria-hidden="true"></i></a>
                    <a href="#w3dev-conflict-section"><i class="fa fa-4x fa-bug" aria-hidden="true"></i></a>
                </div>

                <style>
                    .w3dev-quick-links a {
                        margin-right: 10px;
                        border: 1px solid #ccc;
                        display: inline-block;
                        padding: 10px;
                        border-radius: 4px;
                        margin-bottom: 15px;
                        text-align: center;
                        width: 74px;
                    }
                    .w3dev-quick-links a:hover {
                        color:#8a6d3b;
                        background-color: #f9f9f9;
                    }
                    .w3dev-settings-section {
                        position: relative;
                    }
                    .w3dev-back-to-top {
                        position: absolute;
                        right: 10px;
                        bottom: 8px;
                        text-decoration: none;
                        color: #ccc;
                    }
                    .w3dev-back-to-top:hover {
                        color: #347ab7;
                    }
/**
 * For modern browsers
 * 1. The space content is one way to avoid an Opera bug when the
 *    contenteditable attribute is included anywhere else in the document.
 *    Otherwise it causes space to appear at the top and bottom of elements
 *    that are clearfixed.
 * 2. The use of `table` rather than `block` is only necessary if using
 *    `:before` to contain the top-margins of child elements.
 */
.cf:before,
.cf:after {
    content: " "; /* 1 */
    display: table; /* 2 */
}

.cf:after {
    clear: both;
}

/**
 * For IE 6/7 only
 * Include this rule to trigger hasLayout and contain floats.
 */
.cf {
    *zoom: 1;
}

                </style>

                <div class="cf">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Failed logins</h3>
                            <canvas id="myChart" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Successful logins</h3>
                            <canvas id="myChart2" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart2");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>

                <div class="cf">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Banned users</h3>
                            <canvas id="myChart3" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart3");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">User warnings</h3>
                            <canvas id="myChart4" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart4");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>

                <div class="cf">
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-right: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Registrations</h3>
                            <canvas id="myChart5" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart5");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                    <div style="float:left;width: 50%;margin-bottom: 30px;">
                        <div style="border: 1px solid #ddd;padding: 30px;margin-left: 15px;">
                            <h3 style="background-color: #f9f9f9;border-bottom:1px solid #ddd; padding: 20px;margin: -30px -30px 30px -30px">Spam preventions</h3>
                            <canvas id="myChart6" width="400" height="200" style="height:200px"></canvas>
                            <script>
                            var ctx = document.getElementById("myChart6");
                            var myChart = new Chart(ctx, {
                                type: 'line',
                                data: {
                                    labels: ["<?php echo implode('","',$dates); ?>"],
                                    datasets: [{
                                        label: '# of Logins',
                                        data: ["<?php echo implode('","',$logins); ?>"],
                                        borderColor: '#337ab7',
                                        backgroundColor: '#f9f9f9'
                                    }]
                                },
                                options: {
                                    scales: {
                                        yAxes: [{
                                            ticks: {
                                                beginAtZero:true
                                            }
                                        }]
                                    },
                                    legend: {
                                        display: false
                                    }
                                }
                            });
                            </script>
                        </div>
                    </div>
                </div>

                <div id="w3dev-accessibility-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-low-vision" aria-hidden="true"></i> Accessibility Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div class="mb-10">
                        <input type="checkbox" name="input-enable-accessibility" id="input-enable-accessibility" value="1" <?php echo (!empty($settings['enable_accessibility'])) ? 'checked' : null; ?> /> Optimise plugin for accessibility / screen readers (i.e. displays text links instead of icons)
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-api-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-key" aria-hidden="true"></i> Free API Key <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <p><strong>Why do I need an API Key?</strong> We've introduced an API Key in order to deliver enhanced services, such as our new W3-IP Lookup API.</p>
                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Your API Key: 
                        <?php if (empty($w3dev_api_key_w3_ip)) { ?><a href="javascript:void(0);" id="w3dev-get-api-key">Click here to get your free API Key</a><?php } ?>
                        </label>
                        <input readonly type="text" class="form-control" name="input-api-key" id="input-api-key" value="<?php echo !empty($w3dev_api_key_w3_ip) ? $w3dev_api_key_w3_ip : null; ?>" placeholder="" />
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

               <div id="w3dev-general-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-cog" aria-hidden="true"></i> General Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div id="js-custom-logout" style="margin-bottom: 10px;">
                        <input type="checkbox" name="input-custom-logout" id="input-custom-logout" value="1" <?php echo (!empty($settings['custom_logout'])) ? 'checked' : null; ?> /> Set custom redirection url after logout (i.e. to a notification page, or back to the site's login url). Especially important if your WordPress setup doesn't use wp-login.php
                    </div>
                    <div id="js-custom-logout-url" style="margin-bottom:10px; <?php echo (!empty($settings['custom_logout'])) ? null : 'display:none;' ?>">
                        <input class="form-control" type="text" name="input-custom-logout-url" id="input-custom-logout-url" value="<?php echo esc_url(stripslashes($settings['custom_logout_url'])); ?>" placeholder="Custom logout URL" /> <span class="help-block" style="color:#999">(i.e. http://mywebsite.com or relative so /about-us)</span>
                    </div>

                    <div id="js-banned-login-message" style="margin-bottom: 10px; padding-top: 10px;">
                        <label style="margin-bottom:5px;display:block;">Set Date Format:</label>
                        <select name="input-date-format" id="input-date-format">
                            <option value="d-m-Y" <?php echo (empty($settings['date_format']) || $settings['date_format'] == 'd-m-Y') ? 'selected="selected"' : null; ?>>DD-MM-YYYY</option>
                            <option value="m-d-Y" <?php echo (!empty($settings['date_format']) && $settings['date_format'] == 'm-d-Y') ? 'selected="selected"' : null; ?>>MM-DD-YYYY</option>
                        </select>
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-ban-options-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-ban" aria-hidden="true"></i> Ban &amp; Unban Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div class="mb-10">
                        <input type="checkbox" name="input-change-status" id="input-change-status" value="1" <?php echo (!empty($settings['change_posts_status'])) ? 'checked' : null; ?> /> Change the user's posts status when banned (i.e. select draft to hide posts from showing on blog)
                    </div>
                    <div id="js-post-status" style="margin-bottom:10px; padding-left: 30px; <?php echo (empty($settings['change_posts_status'])) ? 'display:none;' : null; ?>">
                    <?php
                    $all_statuses = get_post_stati();
                    echo '<select id="input-post-status" name="input-post-status">';
                    echo '<option>Select status</option>';
                    foreach ($all_statuses as $key => $status) {
                        echo '<option '.($settings['post_status'] == $key ? 'selected="selected"' : null).' value="' . $key . '">'.$status.'</option>';
                    }
                    echo '</select>';
                    ?>
                    </div>

                    <div id="js-force-logout" class="mb-10">
                        <input type="radio" name="input-logged-in-options" id="input-force-logout" value="1" <?php echo (!empty($settings['force_logout'])) ? 'checked' : null; ?> /> If already logged in when banned, force logout.
                    </div>
                    <div id="js-display-message" class="mb-10">
                        <input type="radio" name="input-logged-in-options" id="input-display-message" value="1" <?php echo (!empty($settings['display_message'])) ? 'checked' : null; ?> /> If already logged in when banned, display message to user.
                    </div>
                    
                    <div id="js-display-message-extras" style="<?php echo (empty($settings['display_message'])) ? 'display:none;' : null; ?>">

                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" disabled="disabled" value="1" checked="checked" /> Display message in back end of website
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-banned-notification" id="input-frontend-banned-notification" value="1" <?php echo (!empty($settings['frontend_banned_notification'])) ? 'checked' : null; ?> /> Display message on front end of website in a dialog box
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-notification-force-logout" id="input-frontend-notification-force-logout" value="1" <?php echo (!empty($settings['frontend_notification_force_logout'])) ? 'checked' : null; ?> /> Force logout and redirect (after diplaying message in dialog box; when applicable)
                        </div>
                        <div style="margin-bottom: 10px; padding-left: 30px;">
                            <input type="checkbox" name="input-frontend-notification-hide" id="input-frontend-notification-hide" value="1" <?php echo (!empty($settings['frontend_notification_force_logout'])) ? 'disabled' : null; ?> <?php echo (!empty($settings['frontend_notification_hide'])) ? 'checked' : null; ?> /> Only show diaglog box once (uses cookie - set to 30days)
                        </div>

                    </div>
                    <div id="js-ban-email" class="mb-10">
                        <input type="checkbox" name="input-ban-email" id="input-ban-email" value="1" <?php echo (!empty($settings['ban_email'])) ? 'checked' : null; ?> /> Enable email notifications when banning or unbanning users
                    </div>
                    <div id="js-ban-email-default" class="mb-10">
                        <input type="checkbox" name="input-ban-email-default" id="input-ban-email-default" value="1" <?php echo (!empty($settings['ban_email_default'])) ? 'checked' : null; ?> /> Include option for custom message in email, and option to set ban duration when banning a user (i.e. date picker, day, week, month etc..)
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

               <div id="w3dev-default-messages-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-bullhorn" aria-hidden="true"></i> Default Messages <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div id="js-ban-email-message" style="margin-bottom:10px; <?php echo (!empty($settings['ban_email_default'] )) ? 'display:none;' : null; ?>">
                        <label style="margin-bottom:5px;display:block;">Default reason for banning a user:</label>
                        <input type="text" class="form-control" name="input-ban-email-message" id="input-ban-email-message" value="<?php echo $settings['ban_email_default_message']; ?>" placeholder="Generic reason for ban" />
                    </div>
                    <div id="js-banned-login-message" class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when a banned user attempts to login: <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span><br />
                        <span style="font-style: italic; color:#999"><strong>Note:</strong> following tags can be used if required: %%reason%% and %%unban_date%%</span></label>
                        <input class="form-control" type="text" name="input-banned-login-message" id="input-banned-login-message" value="<?php echo esc_html(stripslashes($settings['banned_login_message'])); ?>" placeholder="This user account has been banned" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display when user has been banned, whilst logged in, and attempts to access restricted content: <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span><br />
                        <span style="font-style: italic; color:#999"><strong>Note:</strong> following tags can be used if required: %%reason%% and %%unban_date%%</span></label>
                        <input class="form-control" type="text" name="input-custom-message" id="input-custom-message" value="<?php echo esc_html(stripslashes($settings['custom_message'])); ?>" placeholder="Message to banned user" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display if login/registration denied (see Spam Prevention setting): <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span></label>
                        <?php $denied_login_message = !empty($settings['denied_login_message']) ? esc_html(stripslashes($settings['denied_login_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-denied-login-message" id="input-denied-login-message" value="<?php echo $denied_login_message; ?>" placeholder="Access to our site is denied" />
                    </div>

                    <div class="mb-10">
                        <label style="margin-bottom:5px;display:block;">Message to display to Bad Bots if not redirected: <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span></label>
                        <?php $denied_bad_bot_message = !empty($settings['denied_bad_bot_message']) ? esc_html(stripslashes($settings['denied_bad_bot_message'])) : null; ?>
                        <input class="form-control" type="text" name="input-denied-bad_bot-message" id="input-denied-bad_bot-message" value="<?php echo $denied_bad_bot_message; ?>" placeholder="Access to our site is denied" />
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>


                <div id="w3dev-ipgeo-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-map-marker" aria-hidden="true"></i> IP/Geodata Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div class="mb-10">
                        <input type="checkbox" name="input-capture-login-geoip-data" id="input-capture-login-geoip-data" value="1" <?php echo (!empty($settings['capture_login_geoip_data'])) ? 'checked' : null; ?> /> Capture IP/Geodata during user login
                    </div>
                    <div class="mb-10" style="margin-bottom: 20px;">
                        <input type="checkbox" name="input-users-tbl-geoip-data-column" id="input-users-tbl-geoip-data-column" value="1" <?php echo (!empty($settings['users_tbl_geoip_data_column'])) ? 'checked' : null; ?> /> Display IP/Geodata column in users table
                    </div>
                    <div class="mb-10" style="">
                        <label style="margin-bottom:5px;display:block;">Select preferred IP/Geodata API:</label>
                        <select name="input-ip-api" id="input-ip-api">
                            <option <?php echo (empty($settings['ip_api']) || (!empty($settings['ip_api']) && $settings['ip_api'] == 'ip-api.com')) ? 'selected="selected"' : null; ?> value="ip-api.com">ip-api.com</option>
                            <option <?php echo (!empty($settings['ip_api']) && $settings['ip_api'] == 'w3-ip.com') ? 'selected="selected"' : null; ?> value="w3-ip.com">w3-ip.com</option>
                        </select>
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>


                <div id="w3dev-notification-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-flag" aria-hidden="true"></i> Notification Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div id="js-send-notification-new-post" class="mb-10">
                        <input type="checkbox" name="input-send-notification-new-post" id="input-send-notification-new-post" value="1" <?php echo (!empty($settings['send_notification_new_post'])) ? 'checked' : null; ?> /> Send admin(s) an email notification when user publishes first post.
                    </div>
                    <div id="js-notification-email-addresses" class="mb-10">
                        <p style="margin:0;padding:0 0 10px 0;">Email addresss(es) to receive notification when user publishes first post:</p>
                        <select name="input-notification-emails" id="input-notification-emails" style="width:100%;" class="select2-email-tags" multiple="">
                            <?php 
                            if (!empty($settings['notification_emails'])) { 
                                $notification_emails = explode(',', $settings['notification_emails']);
                                foreach($notification_emails as $notification_email) { ?>
                                    <option value="<?php echo $notification_email; ?>" selected="selected"><?php echo $notification_email; ?></option>
                            <?php }} ?>
                        </select>

                        <!--
                        <textarea style="width: 350px;height: 60px;" name="input-notification-emails" id="input-notification-emails" placeholder="Comma seperated list of email addresses"><?php echo !empty($settings['notification_emails']) ? $settings['notification_emails'] : null; ?></textarea>-->

                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-users-table-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-table" aria-hidden="true"></i> Users Table Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div class="mb-10">
                        <input type="checkbox" name="input-users-tbl-data-column" id="input-users-tbl-data-column" value="1" <?php echo (!empty($settings['users_tbl_data_column'])) ? 'checked' : null; ?> /> Display banned column in users table showing login status
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-users-tbl-row-highlighted" id="input-users-tbl-row-highlighted" value="1" <?php echo (!empty($settings['users_tbl_row_highlighted'])) ? 'checked' : null; ?> /> Highlight banned users in users table using red background colour
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-warn-options-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-exclamation-triangle" aria-hidden="true"></i> Warn Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div id="js-warn-user" class="mb-10">
                        <input type="checkbox" name="input-warn-user" id="input-warn-user" value="1" <?php echo (!empty($settings['warn_user'])) ? 'checked' : null; ?> /> Enable warn user feature
                    </div>
                    <div id="js-warn-user-reason" style="margin-bottom: 10px; <?php echo (!empty($settings['warn_user'])) ? null : 'display:none;'; ?>">
                        <input type="checkbox" name="input-warn-user-reason" id="input-warn-user-reason" value="1" <?php echo (!empty($settings['warn_user_reason'])) ? 'checked' : null; ?> /> Include option for custom message in email when warning a user
                    </div> 
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-security-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-shield" aria-hidden="true"></i> Security Settings <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <div class="mb-10">
                        <input type="radio" name="input-security-priv-rights" value="0" <?php echo (empty($settings['security']['priv_rights'])) ? 'checked' : null; ?> /> Default
                    </div>
                    <!--
                    <div class="mb-10">
                        <input type="radio" name="input-security-priv-rights" value=">" <?php echo (!empty($settings['security']['priv_rights']) && $settings['security']['priv_rights'] == '>') ? 'checked' : null; ?> /> Restrict Ban User privilage rights to staff in a higher WordPress role
                    </div>
                    <div class="mb-10">
                        <input type="radio" name="input-security-priv-rights" value=">=" <?php echo (!empty($settings['security']['priv_rights']) && $settings['security']['priv_rights'] == '>=') ? 'checked' : null; ?> /> Restrict Ban User privilage rights to staff in the same or a higher WordPress role
                    </div>
                    -->
                    <div class="mb-10">
                        <input type="radio" name="input-security-priv-rights" value="==" <?php echo (!empty($settings['security']['priv_rights']) && $settings['security']['priv_rights'] == '==') ? 'checked' : null; ?> /> Restrict Ban User administrative rights to users in the following WordPress role
                    </div>
                    <div class="mb-10" style="padding-left: 30px;">
                        <select name="input-security-priv-roles" id="input-security-priv-roles">
                            <option>Please select</option>
                            <?php
                            $priv_role = !empty($settings['security']['priv_roles']) ? $settings['security']['priv_roles'] : 0;
                            $roles = get_editable_roles();

                            if (!empty($roles)) {
                                foreach ($roles as $key => $value) {
                                    echo '<option '.($priv_role == $key ? 'selected' : null).' value="'.$key.'">'.ucfirst($key).'</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">ACCOUNT SECURITY <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span></h4>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-auto-notify-new-ip" value="1" <?php echo !empty($settings['security']['auto_notify_new_ip']) ? 'checked' : null; ?> /> Enable automated notifications for successful user logins when accessed from a new IP Address
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-auto-notify-admin-login" value="1" <?php echo !empty($settings['security']['auto_notify_admin_login']) ? 'checked' : null; ?> /> Enable automated notifications for administrator logins
                    </div>
                    <div class="mb-10">
                        <input type="checkbox"  id="input-security-hide-wp-login-messages" name="input-security-hide-wp-login-messages" value="1" <?php echo !empty($settings['security']['hide_wp_login_messages']) ? 'checked' : null; ?> /> Hide WordPress login error messages
                    </div>
                    <div class="mb-10" style="padding-left:30px;" id="js-security-ambiguous-error-messages" style="<?php echo !empty($settings['security']['hide_wp_login_messages']) ? null : 'display:none' ?>" >
                        <label style="margin-bottom:5px;display:block;">Generic login error message (Optional):</label>
                        <input class="form-control" type="text" name="input-security-ambiguous-error-messages" value="<?php echo !empty($settings['security']['ambiguous_error_messages']) ? $settings['security']['ambiguous_error_messages'] : ""; ?>" placeholder="Login failed, please try again" /> 
                   </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">SPAM PREVENTION <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span></h4>
                    </div>

                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-reg-no-useragent" value="1" <?php echo !empty($settings['security']['deny_reg_no_useragent']) ? 'checked' : null; ?> /> Deny user registration if user agent can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-reg-no-ipaddress" value="1" <?php echo !empty($settings['security']['deny_reg_no_ipaddress']) ? 'checked' : null; ?> /> Deny user registration if IP Address can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-login-no-useragent" value="1" <?php echo !empty($settings['security']['deny_login_no_useragent']) ? 'checked' : null; ?> /> Deny login if user agent can't be determined
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-security-deny-login-no-ipaddress" value="1" <?php echo !empty($settings['security']['deny_login_no_ipaddress']) ? 'checked' : null; ?> /> Deny login if IP Address can't be determined
                    </div>

                    <div style="display:none;border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">BOT MANAGEMENT <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span></h4>
                    </div>
                    <div class="mb-10" style="display:none;">
                        <input type="checkbox" name="input-security-block-bad-bot" id="input-security-block-bad-bot" value="1" <?php echo !empty($settings['security']['block_bad_bot']) ? 'checked' : null; ?> /> Block Bad Bots
                    </div>
                    <div id="js-redirect-bad-bot" style="margin-bottom:10px; <?php echo (!empty($settings['security']['block_bad_bot'])) ? null : 'display:none' ?>">
                        <input class="form-control" type="text" name="input-security-redirect-bad-bot" id="input-security-redirect-bad-bot" value="<?php echo !empty($settings['security']['redirect_bad_bot']) ? esc_url(stripslashes($settings['security']['redirect_bad_bot'])) : null; ?>" placeholder="Redirect Bad Bots to this URL or leave blank to show default message" /> <span class="help-block" style="color:#999">(i.e. http://w3detect.com/im-a-bad-bot )</span>
                    </div>
                    <!--
                    <div class="mb-10">
                        <input type="checkbox" name="" value="1" /> Deny user registration if known BOT
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name=" value="1" /> Deny login if known BOT
                    </div>
                    -->
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>


                <div id="w3dev-banned-keywords-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-file-text-o" aria-hidden="true"></i> Banned Keywords / Phrases <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                        <div class="mb-10">
                            <input type="checkbox" name="input-banned-keywords" id="input-banned-keywords" value="1" <?php echo !empty($w3dev_banned_word_options['banned_keywords']) ? 'checked' : null; ?> /> Enable Banned Keywords / Phrases
                        </div>
                        <div id="js-banned-words-email" style="margin-bottom: 10px; <?php echo !empty($w3dev_banned_word_options['banned_keywords']) ? null : 'display:none;'; ?>">
                            <input type="checkbox" name="input-banned-content-email" id="input-banned-content-email" value="1" <?php echo !empty($w3dev_banned_word_options['banned_content_email']) ? 'checked' : null; ?> /> Send email notification to user warning them about banned content<br />
                        </div>
                        <div id="js-banned-words-and-phrases" style="margin-bottom: 10px; <?php echo !empty($w3dev_banned_word_options['banned_keywords']) ? null : 'display:none;'; ?>">
                            <select name="input-banned-words-and-phrases" id="input-banned-words-and-phrases" style="width:100%;" class="select2-phrases-tags" multiple="">
                                <?php 
                                if (!empty($w3dev_banned_word_options['banned_list'])) { 
                                    $banned_words_and_phrases = explode('/;', $w3dev_banned_word_options['banned_list']);
                                    foreach($banned_words_and_phrases as $banned_words_and_phrases ) { ?>
                                        <option value="<?php echo $banned_words_and_phrases; ?>" selected="selected"><?php echo $banned_words_and_phrases; ?></option>
                                <?php }} ?>
                        </select>
                        </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>
                </div>

                <div id="w3dev-3rdparty-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-plug" aria-hidden="true"></i> 3rd Party Plugin Support <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <p>There are a number of awesome plugins available which extend the membership capabilities of WordPress. If you use any of the following plugins please tick the checkboxes below to enable support for them.</p>

                    <div class="mb-10">
                        <input type="checkbox" name="input-ext-ultimate-member" id="input-ext-ultimate-member" value="1" <?php echo (!empty($settings['extensions']['ultimate_member'])) ? 'checked' : null; ?> /> Ultimate Member Plugin
                    </div>
                    <div class="mb-10">
                        <input disabled type="checkbox" name="input-ext-ultimate-member" id="input-ext-buddypress" value="1" /> BuddyPress Plugin (Coming Soon)
                    </div>
                    <div class="mb-10">
                        <input disabled type="checkbox" name="input-ext-s2member" id="input-ext-s2member" value="1" /> s2member Plugin (Coming Soon)
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="w3dev-css-scripts-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i> CSS / Scripts <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span> <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <p>Use the following text editors below to insert css and/or javascript into the header and footer of your website.</p>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <p style="padding-bottom: 0;margin-bottom: 0"><input <?php echo !empty($inc_header_css) ? 'checked' : null; ?> type="checkbox" name="input-include-header-css" id="input-include-header-css" value="1" /> <strong>Include Header CSS</strong></p>
                        <p style="padding-top: 5px;margin-top: 0">CSS entered below will be wrapped in &#60;style&#62; &#60;/style&#62; Tag and inserted into Head of document</p>
                    </div>
                    <div class="mb-10">
                        <pre id="editor-css"></pre>
                    </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <p style="padding-bottom: 0;margin-bottom: 0"><input <?php echo !empty($inc_footer_js) ? 'checked' : null; ?> type="checkbox" name="input-include-footer-js" id="input-include-footer-js" value="1" /> <strong>Include Footer JS</strong></p>
                        <p style="padding-top: 5px;margin-top: 0">JS entered below will be wrapped in &#60;script&#62; &#60;&#47;script&#62;<span> Tag and inserted into Foot of document</p>
                    </div>
                    <div class="mb-10">
                        <pre id="editor-js"></pre>
                    </div>
                    </div>

<style type="text/css" media="screen">
    #editor-css,#editor-js { 
        display: block;
        height: 200px;
    }
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.2.6/ace.js" integrity="sha256-xrr4HH5eSY+cFz4SH7ja/LaAi9qcEdjMpeMP49/iOLs=" crossorigin="anonymous"></script>
<script>
    var editor_css = ace.edit("editor-css");
    editor_css.setTheme("ace/theme/monokai");
    editor_css.getSession().setMode("ace/mode/css");
    <?php 
    $sample = "#some_example_css {
    color: #fff;
}";
    $html = !empty($w3dev_ban_css_scipts_options['editor_css']) ? $w3dev_ban_css_scipts_options['editor_css'] : $sample; 
    ?>
    editor_css.setValue(`<?php echo $html; ?>`);

    var editor_js = ace.edit("editor-js");
    editor_js.setTheme("ace/theme/monokai");
    editor_js.getSession().setMode("ace/mode/javascript");
    <?php 
    $sample = "(function($) {
    
    // some example jquery
    
})( jQuery );";
    $html = !empty($w3dev_ban_css_scipts_options['editor_js']) ? $w3dev_ban_css_scipts_options['editor_js'] : $sample; 
    ?>
    editor_js.setValue(`<?php echo $html; ?>`);
</script>

                <a class="w3dev-back-to-top" href="body">Back to Top</a>
                </div>


               <div id="w3dev-shortcodes-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-wordpress" aria-hidden="true"></i> Plugin Shortcodes <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">

                    <div class="mb-10">
                        <code>[w3dev-is-user-banned user_id="0"]</code> <?php _e('Check if user is banned (by user id); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-is-user-banned email="me@myaddress.com"]</code> <?php _e('Check if user is banned (by email address); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-is-user-banned username="myusername"]</code> <?php _e('Check if user is banned (by username); if banned shortcode will output message', 'ban-users'); ?>
                        <?php //do_shortcode( '[w3dev-is-user-banned user_id="7"]' ); ?>
                    </div>
                    <div class="mb-10">
                        <code>[w3dev-get-user-ip user_id="0"]</code> Get user's last known ip address;
                        <?php //do_shortcode( '[w3dev-get-user-ip user_id="7"]' ); ?>
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>


                <div id="w3dev-conflict-section" class="w3dev-settings-section">
                    <h3><i class="w3dev-icon fa fa-2x fa-bug" aria-hidden="true"></i> Conflict Management <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                    <div class="w3dev-content">
                    <p class="mb-20">If you want to manually load any of the libraries required by this plugin then simply check the correspnding tick box(es) below to disable them from autoloading. But remember, the plugin won't function correctly if these libraries aren't all available. So I recommend you keep all tick boxes below unchecked unless you know what you are doing.</p>

                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-fa" id="input-autoload-fa" value="1" <?php echo (!empty($settings['disable_autoload']['fa'])) ? 'checked' : null; ?> /> Disable js/css autoload Font Awesome (ver 4.7.0) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-jq-confirm" id="input-autoload-jq-confirm" value="1" <?php echo (!empty($settings['disable_autoload']['jq_confirm'])) ? 'checked' : null; ?> /> Disable js/css autoload jQuery Confirm (ver 3.0.1)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-datatables" id="input-autoload-datatables" value="1" <?php echo (!empty($settings['disable_autoload']['datatables'])) ? 'checked' : null; ?> /> Disable js/css autoload DataTables (ver 1.10.12)
                    </div> 
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-notify" id="input-autoload-notify" value="1" <?php echo (!empty($settings['disable_autoload']['notify'])) ? 'checked' : null; ?> /> Disable js/css autoload Notify (ver 0.4.1)
                    </div> 
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-selectric" id="input-autoload-selectric" value="1" <?php echo (!empty($settings['disable_autoload']['selectric'])) ? 'checked' : null; ?> /> Disable js/css autoload Selectric (ver 1.11.0)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-flatpickr" id="input-autoload-flatpickr" value="1" <?php echo (!empty($settings['disable_autoload']['flatpickr'])) ? 'checked' : null; ?> /> Disable js/css autoload Flatpickr (ver 2.1.1) <span style="position: relative;top:-1px;" class="bs-label label-warning">UPDATED</span>
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-alertify" id="input-autoload-alertify" value="1" <?php echo (!empty($settings['disable_autoload']['alertify'])) ? 'checked' : null; ?> /> Disable js/css autoload Alertify (ver 1.8.0)
                    </div>
                    <div class="mb-10">
                        <input type="checkbox" name="input-autoload-select2" id="input-autoload-select2" value="1" <?php echo (!empty($settings['disable_autoload']['select2'])) ? 'checked' : null; ?> /> Disable js/css autoload Select2 (ver 4.0.3)
                    </div>

                    <div style="border-bottom: 1px solid #ddd;margin-bottom: 15px;padding-top: 15px;">
                        <h4 style="padding:0;margin:0;padding-bottom: 5px;">DEBUGGING</h4>
                    </div>

                    <div class="mb-10">
                        <input type="checkbox" name="input-debug-php" id="input-debug-php" value="1" <?php echo (!empty($settings['debug']['php'])) ? 'checked' : null; ?> /> Enable debug (PHP: display_errors, display_startup_errors, error_reporting) <span style="position: relative;top:-1px;" class="bs-label label-success">NEW</span>
                    </div>
                    </div>
                    <a class="w3dev-back-to-top" href="body">Back to Top</a>

                </div>

                <div id="form-actions" style="margin-bottom: 10px;">
                    <a id="w3dev-save-ban-user-settings" class="btn btn-success" href="javascript:void(0)">Save Options</a>
                </div>
            </form>

            <style>
                .w3dev-settings-section { border:1px solid #ddd; padding: 20px; padding-top: 0; padding-bottom: 30px; margin-bottom: 30px; }
                .w3dev-settings-section h3 { 
                    margin-left: -20px;margin-right: -20px;padding: 20px!important;border-bottom: 1px solid #ddd;
                    background-color: #f9f9f9; margin-bottom: 20px;
                }
                .w3dev-settings-section h3 i.w3dev-icon { color:#8a6d3b;float:left;position:relative;top:-9px;margin-right: 10px; }
                .mb-10 { margin-bottom: 10px; }
                .mb-20 { margin-bottom: 20px; }
            </style>

        </div>
        <div class="w3dev-tab hidden" id="tab-email-template">

            <div style="margin-top: 15px;" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-cog" aria-hidden="true"></i> Email Options: <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <form>
                    <div id="js-banned-login-message" style="margin-bottom: 30px;">
                        <label style="margin-bottom:10px;display:block;">Default message to show if user banned indefinitely and %%unban_date%% tag included in 'BAN User email template':</label>
                        <input class="form-control" type="text" name="input-unban-indefinite-date-tag" id="input-unban-indefinite-date-tag" value="<?php echo $unban_indefinite_date_tag; ?>" />
                    </div>
                </form>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i> BAN User email template: <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>
                
                <div class="w3dev-content">
                <p>If user email notification is enabled, then this email template will be used when notifying users that they have been banned.</p>

<style>
    .tpl-tags {
        color: #ce4844;
        border: 2px solid #ddd;padding: 5px 12px;
        border-radius: 24px;
        margin-bottom: 10px;
        display: inline-block;
        margin-left: 0px;
        margin-right: 5px;
    }
</style>

                 <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-ban-user-subject-title" name="input-ban-user-subject-title" size="30" value="<?php echo $ban_subject_title ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-ban-user-cc-field" id="input-ban-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($ban_cc_field)) { 
                            $ban_user_cc = explode(',', $ban_cc_field);
                            foreach($ban_user_cc as $ban_user_cc) { ?>
                                 <option value="<?php echo $ban_user_cc; ?>" selected="selected"><?php echo $ban_user_cc; ?></option>
                        <?php }} ?>
                    </select>        
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-ban-user-bcc-field" id="input-ban-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($ban_bcc_field)) { 
                            $ban_user_bcc = explode(',', $ban_bcc_field);
                            foreach($ban_user_bcc as $ban_user_bcc) { ?>
                                 <option value="<?php echo $ban_user_bcc; ?>" selected="selected"><?php echo $ban_user_bcc; ?></option>
                        <?php }} ?>
                    </select>        

                <?php 
                wp_editor( $ban_body, 'ban_editor', $settings = array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    )); ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%reason%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%unban_date%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('UnBAN User email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <p><?php _e('If user email notification is enabled, then this email template will be used when notifying users that they have been unbanned.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-unban-user-subject-title" name="input-unban-user-subject-title" size="30" value="<?php echo $unban_subject_title ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-unban-user-cc-field" id="input-unban-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($unban_cc_field)) { 
                            $unban_user_cc = explode(',', $unban_cc_field);
                            foreach($unban_user_cc as $unban_user_cc) { ?>
                                 <option value="<?php echo $unban_user_cc; ?>" selected="selected"><?php echo $unban_user_cc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-unban-user-bcc-field" id="input-unban-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($unban_bcc_field)) { 
                            $unban_user_bcc = explode(',', $unban_bcc_field);
                            foreach($unban_user_bcc as $unban_user_bcc) { ?>
                                 <option value="<?php echo $unban_user_bcc; ?>" selected="selected"><?php echo $unban_user_bcc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>

                <?php   
                wp_editor( $unban_body, 'unban_editor', $settings = array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('Warn User email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <p><?php _e('This template will be used when sending a warning to users for a possible future ban.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-warn-user-subject-title" name="input-warn-user-subject-title" size="30" value="<?php echo $warn_subject_title; ?>"/>
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Cc:', 'ban-users'); ?></label>
                    <select name="input-warn-user-cc-field" id="input-warn-user-cc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($warn_cc_field)) { 
                            $warn_user_cc = explode(',', $warn_cc_field);
                            foreach($warn_user_cc as $warn_user_cc) { ?>
                                 <option value="<?php echo $warn_user_cc; ?>" selected="selected"><?php echo $warn_user_cc; ?></option>
                        <?php }} ?>
                    </select>  
                </p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Bcc:', 'ban-users'); ?></label>
                    <select name="input-warn-user-bcc-field" id="input-warn-user-bcc-field" style="width:100%;" class="select2-email-tags" multiple="">
                        <?php 
                        if (!empty($warn_bcc_field)) { 
                            $warn_user_bcc = explode(',', $warn_bcc_field);
                            foreach($warn_user_bcc as $warn_user_bcc) { ?>
                                 <option value="<?php echo $warn_user_bcc; ?>" selected="selected"><?php echo $warn_user_bcc; ?></option>
                        <?php }} ?>
                    </select>     
                </p>

                <?php   
                wp_editor( $warn_body, 'warn_editor', $settings = array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%reason%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>'; 
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section">

                <h3><i class="w3dev-icon fa fa-2x fa-code" aria-hidden="true"></i><?php _e('Admin Login email template:', 'ban-users'); ?><a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <p><?php _e('Alert the site about admin login.', 'ban-users'); ?></p>
                <p>
                    <label style="margin-bottom:5px;display:block;font-size:1.2em;"><?php _e('Subject Title:', 'ban-users'); ?></label>
                    <input class="form-control" type="text" id="input-admin-login-subject-title" name="input-admin-login-subject-title" size="30" value="<?php echo $admin_login_subject_title; ?>"/>
                </p>

                <?php   
                wp_editor( $admin_login_body, 'admin_login_editor', $settings = array(
                    'textarea_name'     => 'post_content', 
                    'teeny'             => true,
                    'media_buttons'     => false,
                    'quicktags'         => false,
                    'editor_height'     => 350
                    ));
                ?>
                <p>
                    <span style="color:#ce4844;display:block;margin-bottom:6px;font-weight: bold;"><?php _e('Template TAGS:', 'ban-users'); ?></span>
                    <?php 
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%username%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%first_name%% </span>';
                    echo '<span class="tpl-tags" style="color:#ce4844"> %%last_name%% </span>';
                    //echo '<span class="tpl-tags" style="color:#ce4844"> %%ip_address%% </span>';
                    ?>
                </p>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <a id="w3dev-save-ban-email-template" class="btn btn-success" href="javascript:void(0)">Save Template</a>

        </div>

        <div class="w3dev-tab hidden" id="tab-registration-ban">

           <div style="margin-top: 15px;" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-cog" aria-hidden="true"></i> Set Registration Options <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>
        
                <div class="w3dev-content">
                <div class="mb-10">
                    <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Block users registering with a banned Email Address
                </div>
                <div class="mb-10">
                    <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-login-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_login_ban_by_email']) ? 'checked' : null; ?> /> Prevent users logging in if Email Address has been banned
                </div>
                <div class="mb-10">
                    <input type="checkbox" name="input-enable-reg-ban-by-ip" id="input-enable-reg-ban-by-ip" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_ip']) ? 'checked' : null; ?> /> Block users registering with a banned IP Address
                </div>
                <div class="mb-20">
                    <input type="checkbox" name="input-enable-login-ban-by-ip" id="input-enable-login-ban-by-ip" value="1" <?php echo !empty($registration_ban_options['enable_login_ban_by_ip']) ? 'checked' : null; ?> /> Prevent users logging in if IP Address has been banned
                </div>
                <!--
                <div style="margin-bottom: 10px;display:none;">
                    <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Share banned IP Addresses with remote BAN Users database (BETA)
                </div>
                <div style="margin-bottom: 30px;display:none;">
                    <input type="checkbox" name="input-enable-reg-ban-by-email" id="input-enable-reg-ban-by-email" value="1" <?php echo !empty($registration_ban_options['enable_reg_ban_by_email']) ? 'checked' : null; ?> /> Share banned Email Addresses with remote BAN Users database (BETA)
                </div>
                -->
                <div>
                    <a id="w3dev-save-registration-ban-options" class="btn btn-success" href="javascript:void(0)">Save Registration Options</a>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>

            <div style="margin-top: 15px;" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-envelope-o" aria-hidden="true"></i> BAN Email Address <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-email-address" id="input-ban-email-address" placeholder="e.g. example@ban.com" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-email-address" id="btn-ban-email-address" />
                </div>

                <div style="margin-bottom: 20px;">
                <table id="w3dev-table-banned-emails" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned Email Address</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                global $wpdb;
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_emails = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE email_address IS NOT NULL OR
                        email_address != '' 
                        ORDER BY email_address ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_emails) && is_array($banned_emails) )
                    foreach ($banned_emails as $banned_email)
                        echo '<tr id="row-'.$banned_email->id.'">
                                <td class="banned-email-address">'.$banned_email->email_address.'</td>
                                <td>'.date('d-m-Y', strtotime($banned_email->date_time)).'</td>
                                <td><a data-id="'.$banned_email->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>

            </div>
            
            <div style="margin-top: 15px;" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-map-marker" aria-hidden="true"></i> BAN IP Address <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-ip-address" id="input-ban-ip-address" placeholder="e.g. 10.10.10.10" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-ip-address" id="btn-ban-ip-address" />
                </div>

                <div style="margin-bottom: 60px;">
                <table id="w3dev-table-banned-ip-addresses" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned IP Address</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_ips = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE ip_address IS NOT NULL OR
                        ip_address != 0 
                        ORDER BY email_address ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_ips) && is_array($banned_ips) )
                    foreach ($banned_ips as $banned_ip)
                        echo '<tr id="row-'.$banned_ip->id.'">
                                <td>'.long2ip($banned_ip->ip_address).'</td>
                                <td>'.date('d-m-Y', strtotime($banned_email->date_time)).'</td>
                                <td><a data-id="'.$banned_ip->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>
                
            </div>

            <div style="margin-top: 15px;display:none;" class="w3dev-settings-section">
                <h3><i class="w3dev-icon fa fa-2x fa-globe" aria-hidden="true"></i> BAN Country <a class="w3dev-toggle-content" style="float:right"><i class="fa fa-caret-down" aria-hidden="true"></i></a></h3>

                <div class="w3dev-content">
                <div class="input-group" style="margin-bottom: 10px;">
                    <input type="text" name="input-ban-ip-address" id="input-ban-ip-address" placeholder="e.g. 10.10.10.10" value="" />
                    <input class="btn btn-danger" type="submit" value="Add" name="btn-ban-ip-address" id="btn-ban-ip-address" />
                </div>

                <div style="margin-bottom: 60px;">
                <table id="w3dev-table-banned-ip-addresses" class="data-table w3dev-compact-table" style="border:0;">
                <thead>
                <tr>
                    <th>Banned Country</th>
                    <th>Date Banned</th>
                    <th>Remove </th>
                </tr>
                </thead>
                
                <?php
                $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
                
                if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) != $db_table_name ) { ?>

                    <div style="margin-bottom: 25px;"><p><span style="color:#d8534f"><strong>ERROR: The required WordPress Table '<?php echo $db_table_name; ?>' does not exist.</strong></span><br />
                    Please deactivate and reactive this plugin and ensure your Wordpress database user has sufficient rights to create tables.</p></div>
                
                <?php
                } else {

                    $banned_ips = $wpdb->get_results( "
                        SELECT * FROM $db_table_name
                        WHERE ip_address IS NOT NULL OR
                        ip_address != 0 
                        ORDER BY email_address ASC");

                } ?>

                <tbody>
                <?php
                if ( !empty($banned_ips) && is_array($banned_ips) )
                    foreach ($banned_ips as $banned_ip)
                        echo '<tr id="row-'.$banned_ip->id.'">
                                <td>'.long2ip($banned_ip->ip_address).'</td>
                                <td>'.date('d-m-Y', strtotime($banned_email->date_time)).'</td>
                                <td><a data-id="'.$banned_ip->id.'" href="javascript:void(0)" class="no-underline text-danger remove"><i class="fa fa-times" aria-hidden="true"></a></i>
                                </td>
                            </tr>';
                ?>
                </tbody>
                </table>
                </div>
                </div>
                <a class="w3dev-back-to-top" href="body">Back to Top</a>
                
            </div>

            <style>
            table.dataTable {
                margin-bottom: 10px;
            }
            table.dataTable thead th, 
            table.dataTable thead td,
            table.dataTable tbody th, 
            table.dataTable tbody td {
                padding: 8px 0!important;
                text-align: left;
            }
            .dataTables_info { color: #aaa!important; }

            .w3dev-compact-table { border-collapse: collapse; }
            .w3dev-compact-table tr th,
            .w3dev-compact-table tr td {
                border-bottom: 1px solid #ccc;
            }
            .action-group { margin-top: 30px; padding-top: 20px; border-top: 1px solid #ddd; }
            .action-group.reversed { border-top: 0; margin-top:0; padding-top:0; margin-bottom: 30px; padding-bottom: 30px; border-bottom: 1px solid #ddd; }
            </style>

        </div>

        <div class="w3dev-tab hidden" id="tab-faqs">

            <p><span class="text-primary " style="font-weight: bold; font-size: 1.4em;">FAQs</span></p>

            <ul>
                <li class="question"><span>Q.</span> What does this plugin do?</li>
                <li class="answer"><span>A.</span> The BAN User plugin enables WordPress administrators to disable (aka BAN, suspend..) specific user accounts. Banning a user prevents them from being able to login to their WordPress account until an administrator reinstates their access. You can prevent a user from logging in indefinately, or until a specified date. There are a number of configurable options, including sending the user an email notification to inform them they have been banned from the website. There is also an email template for notifying a user when their login access has been reinstated (aka unbanned).</li>
                <li class="question"><span>Q.</span> I simply want the ability to BAN users and prevent them from logging in. What basic options do I need to set?</li>
                <li class="answer"><span>A.</span> The plugin by default allows you to BAN and UnBAN user accounts, and to force users to logout when banned. It also comes pre-configured with the email notification templates. Other options are available from the Plugin's option settings.</li>
                <li class="question"><span>Q.</span> When banning or unbanning users I want to send them a custom email notification.</li>
                <li class="answer"><span>A.</span> This feature is enabled by default. To customise the emails simply click on the 'Email Templates' tab and then edit the subject titles and email body. There are currently two email templates. The 'BAN user notification template', and the 'UnBAN user notification template'. Both of which have a configurable subject title. If you have enabled the 'Require unique reason for ban' option then you will need to include the tag '%%reason%%' within the body of the 'BAN user notification template'. This tag will then be replaced with the text you enter when banning a user.</li>
                <li class="question"><span>Q.</span> I want to clearly highlight users who have been banned in the users table. </li>
                <li class="answer"><span>A.</span> By default banned users are highlighted in the users table by a red circle in the BANned column. Users who have been banned are also highlighted by a red row. You can disable these display options by editing the plugin options (click the Options tab).</li>
                <li class="question"><span>Q.</span> When banning a user, I want to include the reason why they have been banned in their email notification.</li>
                <li class="answer"><span>A.</span> To include the reason for banning the user in the notification email, ensure the option 'Require unique reason for ban' has been checked. Also make sure you have included the tag '%%reason%%' within the body of the 'BAN user notification template'. This tag will then be replaced with the text you enter when banning a user.</li>
                <li class="question"><span>Q.</span> When a user has been banned from the site whilst still logged in, I want them to see a message.</li>
                <li class="answer"><span>A.</span> To display a message to logged in users when banned, first uncheck the plugin option 'If already logged in when banned, force logout'. This will then reveal another option called 'If already logged in when banned, display message to user'. Make sure this option is checked. A text input will then appear allowing you to set a short message (e.g. You have been banned from the website).</li>
                <li class="question"><span>Q.</span> When a user has been banned from the site whilst still logged in, I want to redirect them to the default WP login page</li>
                <li class="answer"><span>A.</span> To automatically log a banned user out and redirect them to the default login page you will need to ensure the plugin's option 'If already logged in when banned, display message to user' has been unchecked. You will then see another option called 'If already logged in when banned, force logout'. Simply check this to enable this feature.</li>
                <li class="question"><span>Q.</span> When a user has been banned from the site whilst still logged in, I want to redirect them to a custom url.</li>
                <li class="answer"><span>A.</span> To automatically log a banned user out and redirect them to a custom url you will need to ensure the plugin's option 'If already logged in when banned, display message to user' has been unchecked. You will then see another option called 'If already logged in when banned, force logout'. Simply check this to enable this feature. To then set a custom url instead of redirecting banned users to the login page, click the 'Set custom logout URL' and enter a valid url in the text field that appears.</li>
                <li class="question"><span>Q.</span> When banning a user I want to change all their posts to a different status (i.e. to hide all their published content).</li>
                <li class="answer"><span>A.</span> Often the reason for banning a user from your website is they've posted content that breaches the site's policy. The BAN User plugin allows you to change the user's posts to a different status (i.e. draft) when banning them. To enable this feature click the 'Change user's posts statuses when banning user (i.e. to hide posts from showing on blog)' checkbox on the options tab. A dropdown list will then appear allowing you to select the preferred status you wish to use. </li>
                <li class="question"><span>Q.</span> I only want to BAN a user for a week.</li>
                <li class="answer"><span>A.</span> The BAN User plugin allows you to specify how long you want to BAN the user for. The date is set using a datepicker which is available on the users table and appears as a calendar icon when hovering over the username. To enable the datepicker you must first ensure the plugin's option 'Allow user to be unbanned automatically when a date is reached.' has been checked.</li>
                <li class="question"><span>Q.</span> I want to BAN a user from logging on during certain hours of the day.</li>
                <li class="answer"><span>A.</span> Unfortunately this feature isn't currently available, but in plan for a future release of the plugin.</li>
                <li class="question"><span>Q.</span> I want the system to automatically reinstate users' login access when their banned period has expired.</li>
                <li class="answer"><span>A.</span> Once a banned user's banned date has elapsed they will automatically be able to log back in to the system. No administrative action is required.</li>
                <li class="question"><span>Q.</span> I want to customise the BANned and UnBANed email templates.</li>
                <li class="answer"><span>A.</span> From the plugin's option's page click on the 'Email Templates' tab. You should then see two sections for each corresponding email template. One for the 'BAN User email notification template' and another for the 'UnBAN User email notification template'. Within each section is the subject title and the message body. Important, please make sure you include the tag %%reason%% within the message body of the ban user template if you've enabled the option 'Require unique reason for ban'.</li>
                <li class="question"><span>Q.</span> I want to ban a user how do I do this?</li>
                <li class="answer"><span>A.</span> There are two ways (and places!) in which you can ban a user (i.e. disable their account). Either by accessing the user's Profile page, or using the WordPress admin Users page. To BAN a user from their profile page, simply scroll to the bottom of their profile and tick the Ban User checkbox. To BAN a user from the Users page, navigate to the Users page and then find the corresponding user you wish to BAN. Once found hover your mouse over their username and some text links should appear below their username. To disable their account click the link 'Ban'. After a brief moment the link should change to 'Unban' and depending on the options you've set for the plugin the users row should go red and the BANned column should now display a red circle.</li>
                <li class="question"><span>Q.</span> I want to unban a user how do I do this?</li>
                <li class="answer"><span>A.</span> There are two ways (and places!) in which you can unban a user (i.e. reinstate their account). Either by accessing the user's Profile page, or using the WordPress admin Users page. To UnBAN a user from their profile page, simply scroll of the bottom of their profile and untick the Ban User checkbox. To UnBAN a user from the Users page, navigate to the Users page and then find the corresponding user you wish to UnBAN. Once found hover your mouse over their username and some text links should appear below their username. To reinstate their account click the link 'Unban'. After a brief moment the link should change to 'Ban' and depending on the options you've set for the plugin the users row should return to white and the BANned column should now display a green circle.</li>
                <li class="question"><span>Q.</span> I need further assistance, how can I request support?</li>
                <li class="answer"><span>A.</span> We're here to help you, so if you have any questions or comments please do get in touch using the contact form on our envato profile page: <a href="https://codecanyon.net/user/webxmedia">https://codecanyon.net/user/webxmedia</a></li>
                <li class="question"><span>Q.</span> Can I request changes or enhancements to the plugin?</li>
                <li class="answer"><span>A.</span> We welcome any feedback and are always looking at new ways to enhance our plugins. To get in touch please contact us using our envato profile page: <a href="https://codecanyon.net/user/webxmedia">https://codecanyon.net/user/webxmedia</a></li>
            </ul>

            <style>
                li.answer { padding-bottom: 10px; }
                li.question { text-decoration: underline; }
                li.question span { font-weight: bold; color: #f0ad4e; }
                li.answer span { font-weight: bold; color: #5cb85c; }
            </style>

        </div>
        <?php if (!W3DEV_BAN_USERS_PREMIUM_VERSION) { ?>
            <div class="w3dev-tab hidden" id="tab-go-pro">

            <p><span class="text-primary " style="font-weight: bold; font-size: 1.4em;">The Ultimate BAN Users WordPress Plugin</span></p>

                <p><strong>The Ultimate BAN Users WordPress Plugin is the last plugin youll ever need for managing access to your WordPress site and removing users content. Ban existing users, deny registrations based on banned ips/emails. Catpure IP/Geodata and much, much more</strong>.</p>

                <p><a href="https://codecanyon.net/item/wp-ultimate-ban-users/17508338" target='_blank' rel="nofollow">Buy Premium Version</a></p>

                <p><span style="font-size:1.2em;font-weight:bold;text-decoration:underline">Ultimate BAN Users Features:</span></p>
                <ul>
                    <li>
                    <strong>Ban existing WordPress users</strong> from logging in</li>
                    <li>Ban users indefinately or until a specified date</li>
                    <li>
                    <strong>Deny visitors from registering</strong> based on email and/or ip address</li>
                    <li>Change the status of Ban users posts (i.e. to draft)</li>
                    <li>Capture unqiue reason for banning users</li>
                    <li>Send <strong>custom email notifications</strong>
                    </li>
                    <li>Force banned users to logout, or redirect them</li>
                    <li>
                    <strong>Capture IP/Geodata</strong> during logins</li>
                    <li>Display IP/Geodata/banned details on users table</li>
                    <li>Easily manage banned users/ips/emails</li>
                    <li>Clearly <strong>highlight banned users</strong> in users table</li>
                    <li>Send notifications when users publish first post</li>
                </ul>

            </div>
        <?php } ?>
    </div>

    <?php
}

add_action( 'edit_user_profile', 'w3dev_edit_user_profile' );
function w3dev_edit_user_profile( $user ) {

    if (!current_user_can( 'edit_users')) { return; }
    if (get_current_user_id() == $user->ID ) { return; } // Do not show on user's own edit screen
    
    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

    $date = wp_next_scheduled('w3dev_unban_user', array( $user->ID ));  

    ?>
    <table class="form-table">
        <tr>
            <th scope="row">Ban User</th>
            <td>
            <label for="input-w3dev-ban-user">
                <input type="checkbox" name="input-w3dev-ban-user" id="input-w3dev-ban-user" <?php
                    checked( $w3dev_ban_user_class->is_user_banned( $user->ID ), TRUE )?> value="1">
                    Ban this user</label>
                <input name="w3dev-ban-reason" type="hidden" id="w3dev-ban-reason" value="">
                <input name="w3dev-ban-checked" type="hidden" id="w3dev-ban-checked" value="<?php echo (($settings['ban_email'] && $settings['ban_email_default']) ? "1" : "0") ?>"  />
            </td>
        </tr>
        <tr id="js-w3dev-unban-date" <?php if(!$w3dev_ban_user_class->is_user_banned( $user->ID )) echo 'style="display:none"'?> >
            <th scope="row">Unban Date</th>
            <td>
                <label for="input-w3dev-user-unban-date">
                    <input type="text" name="input-w3dev-user-unban-date" id="input-w3dev-user-unban-date" class="datepicker" data-date-format="<?php if (!empty($settings['date_format'])) echo $settings['date_format']; ?>" value="<?php echo ($date ? date($settings['date_format'], $date) : "Indefinent"); ?>" />
                </label>
            </td>
        </tr>
    </table>
    <?php
}

add_action( 'edit_user_profile_update', 'w3dev_edit_user_profile_update' ); 
function w3dev_edit_user_profile_update( $user_id ) {

    if (!current_user_can( 'edit_users')) { return; }    // Is admin
    if (get_current_user_id() == $user_id ) { return; } // Do not show on user's own edit screen

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (empty($_POST['input-w3dev-ban-user'])) {
        $w3dev_ban_user_class->unban_user(floatval($user_id)); // Unlock
    } else {
        $message = $_POST['w3dev-ban-reason'];
        $date = $_POST['input-w3dev-user-unban-date'];

        $w3dev_ban_user_class->ban_user(floatval($user_id), $message, $date);// Lock
    }
    
}
