<?php

function w3dev_banned_words_phrases( $new_status, $old_status, $post ){
    
    $post_title 	= get_the_title( $post->ID );
    $post_content 	= get_post_field('post_content', $post->ID );

    // Move into class
    $w3dev_banned_word_options = get_option('w3dev_banned_word_options');

    // Array to string
    // Inject string into regex
    $w3dev_exempt_roles = !empty ($w3dev_banned_word_options['banned_content_level']) ? $w3dev_banned_word_options['banned_content_level'] : array();
    //$w3dev_exempt_roles = explode('|', $w3dev_exempt_roles );
    //print_r($w3dev_exempt_roles);exit;
    $w3dev_exempt_roles = !empty($w3dev_exempt_roles) ? array_intersect(wp_get_current_user()->roles, $w3dev_exempt_roles) : false;

    if( $new_status == 'publish' && empty($w3dev_exempt_roles)) {
        // Add restricted words or phrases separated by a semicolon
        // --
        $restricted_words = !empty($w3dev_banned_word_options['banned_words_and_phrases']) ? $w3dev_banned_word_options['banned_words_and_phrases'] : null;
        $restricted_words = "/(?i)\b(".$restricted_words.")\b(?-i)/";

        $count = $temp_count = 0;
        $restricted_matches = array();

        if ( !empty($w3dev_banned_word_options['banned_content_title']) ) {

            preg_replace_callback($restricted_words, 
                function($matches) use ( &$restricted_matches) { $restricted_matches = $matches; }
            , $post_title, -1, $count);

        }

        if ( !empty($w3dev_banned_word_options['banned_content']) ) {

            preg_replace_callback($restricted_words, 
                function($matches) use ( &$restricted_matches) { $restricted_matches = array_merge($matches, $restricted_matches); }
            , $post_content, -1, $temp_count);

        }

        $count += $temp_count;

        if( $count >=  $w3dev_banned_word_options['banned_content_occurances'] ) {
             $restricted_matches = array_map('strtolower', $restricted_matches );
             $restricted_matches = array_unique($restricted_matches);
             $restricted_matches = implode('<br/>', $restricted_matches);

             remove_action( 'transition_post_status', 'w3dev_banned_words_phrases', 10 );
             wp_update_post(array('ID' => $post->ID, 'post_status' => 'draft'));
             add_action( 'transition_post_status', 'w3dev_banned_words_phrases', 10, 3 );

             return wp_die( __('Error: You have enter a set of forbidden words in the post or title: <br/>'.$restricted_matches) );
         }
    }
}
add_action( 'transition_post_status', 'w3dev_banned_words_phrases', 10, 3 );


function w3dev_notify_new_post( $new_status, $old_status, $post ){

	// $post_title = get_the_title( $post->ID );
	// $post_content = get_post_field('post_content', $post->ID );

	// Add restricted words or phrases separated by a semicolon
    // --
	/*
	$restricted_words = "word1/;word2/;word3";
	$restricted_words = explode("/;", $restricted_words);
	foreach($restricted_words as $restricted_word) {
		if (stristr( $post_title, $restricted_word) || stristr( $post_content, $restricted_word) ) {
			wp_die( __('Error: You have used a forbidden word "'. $restricted_word .'" in post title or content') );
		}
	}
	*/

    if ( 'publish' !== $new_status or 'publish' === $old_status ) { return; }
    if ( 'post' !== $post->post_type ) { return; } // restrict the filter to a specific post type

    // do something awesome
    // --
    $user_id  	= $post->post_author;
    $num_posts  = count_user_posts( $user_id );

    // if this is the users first post (aka article) then
    // send notification to webmaster for review
    // --
    if ($num_posts == 1) { // This is users first post

		$post_title = get_the_title( $post->ID );
		$post_url 	= get_permalink( $post->ID );
		$subject 	= 'User published first post';

		$user_info = get_userdata($user_id);

		$message 	= "
			<p>Dear Webmaster,<br /><br />
			A new user has published their first post.</p>
			<p>Please review the content below and take action where necessary.</p>
			";

		$message 	.= '
		<h4>User details:</h4>
		<p>
		<ul>
			<li>Username: ' . $user_info->user_login . '</li>
			<li>Email Address: ' . $user_info->user_email . '</li>
			<li>User roles: ' . implode(', ', $user_info->roles) . '</li>
			<li>User ID: ' . $user_info->ID . '</li>
		</ul>
		';

		$message 	.= '
		<h4>Post details:</h4>
		<p>
		<ul>
			<li>Title: ' . $post_title . '</li>
			<li>Link: ' . $post_url . '</li>
		</ul>
		' . $post->post_content;

		// check to see if email moderation is enabled, if so include file
		// --
		$w3dev_ban_user_class 	= W3DEV_BAN_USER_CLASS::get_instance();
		$default_settings 		= $w3dev_ban_user_class->default_options('settings');
		$settings 				= get_option('w3dev_ban_user_options', $default_settings);
		
		// email send disabled on staging
		// --
		if (!empty($settings['notification_emails'])) {
			$recipients = explode(',', $settings['notification_emails']);
			foreach ($recipients as $recipient) {
				if (filter_var($recipient, FILTER_VALIDATE_EMAIL)) {
					wp_mail($recipient, $subject, $message, "Content-Type: text/html; charset=utf-8\r\n" );
				}
			}
		}

    }

}
add_action( 'transition_post_status', 'w3dev_notify_new_post', 10, 3 );


/*
if (is_admin()) {

	// get_user_role
	// --
	global $current_user;

	$user_roles = $current_user->roles;
	$user_role 	= array_shift($user_roles);

	if ($user_role =='publisher' || current_user_can('administrator')) {

		global $pagenow;

		if ($pagenow == 'users.php') {

			$private_token = sha1('123');

	    	// user listing page
	    	// --
			$userid 	= !empty($_GET['u']) ? $_GET['u'] : false;
			$token 		= !empty($_GET['token']) ? $_GET['token'] : false;
			$action 	= !empty($_GET['action']) ? $_GET['action'] : false;

			if (!empty($userid) && !empty($token) && !empty($action)) {
				if ($token == $private_token) {

					if ($action == 'ban') { 

						rc_ban_user($userid);

						function ban_admin_notice__success($userid) { ?>

						    <div class="notice notice-success is-dismissible">
						        <p><?php echo "The user has been banned."; ?></p>
						    </div>
						    <?php
						}
						add_action( 'admin_notices', 'ban_admin_notice__success' );

					}

				} else {

					function ban_admin_notice__error() {
						$class = 'notice notice-error';
						$message = __( 'Oops! Something went wrong. Please try again.', 'sample-text-domain' );

						printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message ); 
					}
					add_action( 'admin_notices', 'ban_admin_notice__error' );

				}
			}

	    }
	}
}
*/
