<?php 

add_filter( 'comments_array' , 'w3dev_filter_comments_by_role_frontend' , 10, 2 );
function w3dev_filter_comments_by_role_frontend( $comments, $post_id ){

    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

    if (!empty($settings['hide_banned_users_comments'])) {

        // go over each comments for the current post
        // --
        foreach( $comments as $key => $comment ){

            // Remove comment from comment array if user account is banned
            // --
            if ( get_user_option( 'w3dev_user_banned', $comment->user_id, FALSE ) ) {

                unset( $comments[$key] );

                // for future reference...
                // $comment_author = new WP_User( $comment->user_id ); // for each comment get the author user object
                // here we say unset the current comment if the role of the comment author is not the same as the role of the logged in user
                // if( $comment_author->roles[0] != $current_user->roles[0] ){ unset( $comments[$key] ); }

            }

        }

    }

    return $comments; // Return the filtered $comments array 

}

add_filter( 'allow_password_reset', 'w3dev_deny_password_reset', 10, 2 );
function w3dev_deny_password_reset( $allow, $user_id ) {

    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

    if (!empty($settings['disable_password_reset_banned_users'])) {

        // WP_User object
        if (!empty($user_id)) {
            if ($w3dev_ban_user_class->is_user_banned($user_id)) { 
                $allow = false;
            }
        }

    }
    return $allow;
}

add_action( 'admin_menu', 'w3dev_ban_user_menu' );
function w3dev_ban_user_menu() {
	add_options_page( 
		'Ultimate BAN User', 
		'Ultimate BAN User', 
		'manage_options', 
		'ban_user_page.php', 
		'w3dev_ban_user_options_partial', 
		'dashicons-businessman', 6
		);

}

add_action( 'admin_bar_menu', 'w3dev_banuser_toolbar_link', 999 );
function w3dev_banuser_toolbar_link( $wp_admin_bar ) {
    if( current_user_can( 'level_5' ) ){ // Set the permission level or capability here for which user tier can see the link.

        $args = array(
            'id' => 'w3dev-ubu', // Set the ID of your custom link
            'title' => '<span class="ab-icon"></span><span class="ab-label">'.__( 'UBU Settings', 'banusers' ).'</span>', // Set the title of your link
            'href' =>  admin_url( 'options-general.php?page=ban_user_page.php'), // Define the destination of your link
            'meta' => array(
                'target' => '_self', // Change to _blank for launching in a new window
                'class' => '', // Add a class to your link
                'title' => 'UBU' // Add a title to your link
            )
        );
        $wp_admin_bar->add_node($args);
 
    }
}


add_filter( 'wp_authenticate_user', 'w3dev_authenticatation_is_user_banned', 10, 2 );
function w3dev_authenticatation_is_user_banned( $user, $password ) {

	if (is_wp_error($user) || empty($user->ID)) { return $user; }
	
	global $wpdb;
	$w3dev_ban_user_class       = W3DEV_BAN_USER_CLASS::get_instance();
	$settings                   = $w3dev_ban_user_class->get_options('settings');
	$registration_ban_options   = $w3dev_ban_user_class->get_options('registration');
	$ip_address                 = $w3dev_ban_user_class->get_ip_address();
	$user_agent                 = $w3dev_ban_user_class->get_user_agent();

	$banned_login_message       = !empty($settings['banned_login_message']) ? $settings['banned_login_message'] :  $settings['_defaults']['banned_login_message'];
    $banned_login_message       = $w3dev_ban_user_class->ban_tag_edit($banned_login_message, $user->ID);
	$denied_login_message       = !empty($settings['denied_login_message']) ? $settings['denied_login_message'] :  $settings['_defaults']['denied_login_message'];

	// Return error if user agent and/or ip address can't be determined (where applicable)
	// --
   	if (!empty($settings['security']['deny_login_no_useragent']) || 
   		!empty($settings['security']['deny_login_no_ipaddress'])) {

   		//$ip_address = null;

   		if (empty($ip_address) || empty($user_agent)) {

			$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'denied', 'label' => 'spam'));

			return new WP_Error(
				'w3dev_user_banned',
				__( '<strong>ERROR</strong>: '.stripslashes($denied_login_message), 'w3dev' )
			);

   		}

   	}

	// Return error if user account is banned
	// --
	if ( get_user_option( 'w3dev_user_banned', $user->ID, FALSE ) ) {

		$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'denied', 'label' => 'user', 'user_id' => $user->ID));

		return new WP_Error(
			'w3dev_user_banned',
			__( '<strong>ERROR</strong>: '.stripslashes($banned_login_message), 'w3dev' )
		);
	}

      // Geo Data setting into database
      {
		// if database table exists, record login details
		// --
		$db_table_name = $wpdb->prefix . 'w3dev_login_details';
        if ( $wpdb->get_var( "SHOW TABLES LIKE '$db_table_name'" ) == $db_table_name ) {

            if( !empty($settings['capture_login_geoip_data']))
                $geodata = $w3dev_ban_user_class->get_geodata();
            else {
                $geodata = null;
                $ip_address = NULL;
            }

            // need to check if the user has successfully logged in before using this ip
			// if not, then send out automated notification (if enabled), of course need to check ip exists
			// -- 
			if (!empty($settings['security']['auto_notify_new_ip']) && !empty($ip_address)) {

				// only alert on 2nd ip, so skip first insert/record
			    // --
			    $user_record_found = $wpdb->get_results( $wpdb->prepare("
			        SELECT * FROM ".$db_table_name."
			        WHERE user_id = %d LIMIT 1", $user->ID) );

			    if (!empty($user_record_found)) {

				    $known_ip_address = $wpdb->get_results( $wpdb->prepare("
				        SELECT * FROM ".$db_table_name."
				        WHERE ip_address = %d
				        AND user_id = ".$user->ID, ip2long($ip_address)) );

				    if (empty($known_ip_address)) {
				    	if (!filter_var($user->user_email, FILTER_VALIDATE_EMAIL) === false) {
							$w3dev_ban_user_class->send_notification_new_ip_address($user->user_email,$ip_address);
						}
					}

			    }

			}

			$device = null;
			if (empty($settings['device_detection']['disabled'])) {

				// MOVE INTO CLASS !!!!!
				// --
				$detect = new \w3dev\Mobile_Detect;
				$device = 'desktop';

				if ( $detect->isMobile() ) { $device = 'mobile'; } // Any mobile device (phones or tablets).
				if ( $detect->isTablet() ) { $device = 'tablet'; } // Any tablet device.

			}

			// MOVE INTO CLASS !!!!!
			// --
			$wpdb->insert( 
			    $db_table_name, 
			    array( 
			        'user_id'   	=> (int) $user->ID,
			        'ip_address'    => ip2long($ip_address),
			        'user_agent' 	=> $user_agent,
			        'geodata'   	=> $geodata,
			        'device'		=> $device,
			        'date_time'     => date('Y-m-d H:i:s')
			    )
			);
			$record_id = $wpdb->insert_id;
		}
	 }
	   
    if (!empty($registration_ban_options['enable_login_ban_by_email'])) {

    	// check if users email address has been banned
    	// --
    	global $wpdb;
	    $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';

    	$users_data = get_userdata( $user->ID ); 
    	if (!empty($users_data->user_email)) {
            $ban_detail = null;

		    $is_email_banned = $wpdb->get_results( $wpdb->prepare("
		        SELECT * FROM ".$db_table_name."
		        WHERE email_address = %s", $users_data->user_email)
		    );

            if (!empty($is_email_banned)) {
                $ban_detail["reason"] = "as a result of your email";
                $ban_detail["date"] = strtotime(get_object_vars($is_email_banned[0])["date_time"]);
            } else if($w3dev_ban_user_class->is_domain_forbidden($users_data->user_email)) {
                $ban_detail["reason"] = "as part of a group email ban";
                $ban_detail["date"] = strtotime(get_object_vars($is_email_banned)["date_time"]);
                $is_email_banned = true;
            }

            if (!empty($is_email_banned)) {

		    	$user_id = !empty($user->ID) ? (int) $user->ID : 0; 
				$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'denied', 'label' => 'email', 'user_id' => $user_id));
                $banned_login_message = $w3dev_ban_user_class->ban_tag_edit("You have been banned %%reason%% from
                %%unban_date%%", $user->ID,$ban_detail);

				return new WP_Error(
					'w3dev_user_banned',
					__( '<strong>ERROR</strong>: '.$banned_login_message, 'w3dev' )
				);
		    }
		}
	} 

	if (!empty($registration_ban_options['enable_login_ban_by_ip'])) {

	    // check if users ip address has been banned
	    // --
		if (!empty($ip_address)) {
			$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
		    $is_ip_banned = $wpdb->get_results( $wpdb->prepare("
		        SELECT * FROM ".$db_table_name."
		        WHERE ip_address = %d", ip2long($ip_address))
		    );

		    if (!empty($is_ip_banned)) {

				$user_id = !empty($user->ID) ? (int) $user->ID : 0; 
				$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'denied', 'label' => 'ip', 'user_id' => $user_id));

				return new WP_Error(
					'w3dev_user_banned',
					__( '<strong>ERROR</strong>: '.$banned_login_message, 'w3dev' )
				);
	    	}
		}
	}

	if (!empty($registration_ban_options['enable_login_ban_by_countrycode'])) {

		if (!empty($geodata)) {

			$geodata = json_decode($geodata);
			if (!empty($geodata)) {

				$countrycode = !empty($geodata->country_code) ? $geodata->country_code : (!empty($geodata->countryCode) ? $geodata->countryCode : false);
				$countrycode = !empty($countrycode) ? strtolower($countrycode) : false;

			    // check if users country code has been banned
			    // --
				if (!empty($countrycode)) {
					$db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
				    $is_countrycode_banned = $wpdb->get_results( $wpdb->prepare("
				        SELECT * FROM ".$db_table_name."
				        WHERE geodata = %s", "countrycode:$countrycode")
				    );

					if (!user_can( $user->ID, 'manage_options' )) {
				    if (!empty($is_countrycode_banned)) {

						$user_id = !empty($user->ID) ? (int) $user->ID : 0; 
						$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'denied', 'label' => 'ccode', 'user_id' => $user_id));

						return new WP_Error(
							'w3dev_user_banned',
							__( '<strong>ERROR</strong>: '.$banned_login_message, 'w3dev' )
						);
			    	}
			    	}
				}

			}

		}

	}

    if ( !empty( $settings['security']['disable_non_admin_logins']) && !in_array('administrator', $user->roles ) ) {
    	$message = !empty($settings['non_admin_role_restriction_message']) ? esc_html(stripslashes($settings['non_admin_role_restriction_message'])) : null;
		return new WP_Error(
			'w3dev_user_banned',
			__( '<strong>ERROR</strong>: '.$message, 'w3dev' )
		);
    }

    $today = strtolower(date('D'));
    if (in_array('administrator', $user->roles ) && !empty($settings['restrict']['admin'][$today]['enabled'])) {
    	$restrict_start_time 	= !empty($settings['restrict']['admin'][$today]['start']) ? $settings['restrict']['admin'][$today]['start'] : false;
    	$restrict_end_time 		= !empty($settings['restrict']['admin'][$today]['end']) ? $settings['restrict']['admin'][$today]['end'] : false;
    
    	$restrict_time_now 		= date('H:i');
    	$restrict_start_time 	= date('H:i', strtotime($restrict_start_time));
    	$restrict_end_time 		= date('H:i', strtotime($restrict_end_time));
    	
    	function isBetween($from, $till, $input) {
		    $f = DateTime::createFromFormat('!H:i', $from);
		    $t = DateTime::createFromFormat('!H:i', $till);
		    $i = DateTime::createFromFormat('!H:i', $input);
		    if ($f > $t) $t->modify('+1 day');
		    return ($f <= $i && $i <= $t) || ($f <= $i->modify('+1 day') && $i <= $t);
		}

		$access_token = isBetween($restrict_start_time, $restrict_end_time, $restrict_time_now);

	    if (empty($access_token)) {
	    	$message = !empty($settings['admin_restricted_hours_message']) ? esc_html(stripslashes($settings['admin_restricted_hours_message'])) : null;
			return new WP_Error(
				'w3dev_user_banned',
				__( '<strong>ERROR</strong>: '.$message, 'w3dev' )
			);
	    }

    }

	$user_id = !empty($user->ID) ? (int) $user->ID : 0; 
	$w3dev_ban_user_class->log_event(array('category' => 'login', 'action' => 'success', 'user_id' => $user_id));

	return $user;
}


add_action( 'wp_login', 'w3dev_admin_login_check', 10, 2);
function w3dev_admin_login_check($user_login, $user) {

    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
    $settings             = $w3dev_ban_user_class->get_options('settings');

    if ( in_array('administrator', $user->roles ) && !empty( $settings['security']['auto_notify_admin_login']) ) {
        $w3dev_ban_user_class->send_admin_login( $user );
    }

}

add_action( 'admin_init', 'w3dev_check_if_banned_user', 1 );
function w3dev_check_if_banned_user() {

	$user = get_user_by( 'ID', get_current_user_id() );
	
	if (is_wp_error($user) || empty($user->ID)) { return $user; }

	$w3dev_ban_user_class 	= W3DEV_BAN_USER_CLASS::get_instance();
	$settings               = $w3dev_ban_user_class->get_options('settings');

	// Return error if user account is banned
	if ( get_user_option( 'w3dev_user_banned', $user->ID, FALSE ) ) {
		if (!empty($settings['display_message'])) {
                wp_die( __( stripslashes( $w3dev_ban_user_class->ban_tag_edit($settings['custom_message'], $user->ID) ) ) );
		} else if (!empty($settings['force_logout'])) {
			if (!empty($settings['custom_logout'])) {
				header('Location: '.$settings['custom_logout_url']);
			} else {
				wp_logout();
				header('Location: /wp-login.php');
			}
		}
	}
}


function w3dev_ban_users_init_function() {

    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

	// check if user is logged in
	// check if public banned message is checked
	// check if current user is banned
	// --
	if ( is_user_logged_in() ) {

		$current_user = wp_get_current_user();
		if (!empty($current_user->ID) && $w3dev_ban_user_class->is_user_banned($current_user->ID)) {

			// only do this part on front end
			// --
			if ( ! is_admin() ) {

				if (!empty($settings['frontend_notification_force_logout']) || !empty($settings['force_logout'])) { 

				    wp_clear_auth_cookie();
				    wp_logout();

					if (!empty($settings['force_logout'])) {
						$logout_url = (!empty($settings['custom_logout'])) ? $settings['custom_logout_url'] : "/wp-login.php";
						header('Location: '.$logout_url);
						exit;
					}

				}

				// display message to user on front end if options set
				// --
				if (!empty($settings['display_message']) && !empty($settings['frontend_banned_notification'])) {

					$show_dialog = true;
					if (!empty($settings['frontend_notification_hide'])) {

						if (isset($_COOKIE['w3dev_bu_hide_notification'])) { 
							$show_dialog = false; 
						} else {
							setcookie('w3dev_bu_hide_notification', 1, time() + (86400 * 30), "/");
						}

					} else {
						if (isset($_COOKIE['w3dev_bu_hide_notification'])) { 
							setcookie('w3dev_bu_hide_notification', "", time() - 3600);
						}
					}

					// show dialog if it's not been seen before or should be show everytime
					// --
					if ($show_dialog) {
						function w3dev_ban_user_script() {

						    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
						    $settings               = $w3dev_ban_user_class->get_options('settings');
							$custom_message 		= !empty($settings['custom_message']) ? $settings['custom_message'] : $settings['_defaults']['custom_message'];
                            $custom_message         = $w3dev_ban_user_class->ban_tag_edit($custom_message, $current_user->ID);

							?>
							<script type="text/javascript">
							alertify.alert('Important Notification', '<?php echo $custom_message; ?>', function(){ 

								<?php
								if (!empty($settings['frontend_notification_force_logout'])) { 

									$logout_url = (!empty($settings['custom_logout'])) ? $settings['custom_logout_url'] : "/wp-login.php";
									echo 'window.location.href = "'.$logout_url.'";';

								}
								?>

							});
							</script>

						<?php
						}
						add_action('wp_footer', 'w3dev_ban_user_script');
					
					}

				} elseif ( !empty( $settings['frontend_notification_force_logout'] ) ) {
					$logout_url = (!empty($settings['custom_logout'])) ? $settings['custom_logout_url'] : "/wp-login.php";
					header('Location: '.$logout_url);
					exit;
				}

			}

		}

	}

	if (!empty($settings['security']['disable_registrations'])) {

		add_filter( 'register', 'w3dev_disable_registration_link' );
		function w3dev_disable_registration_link( $registration_url ) {
			return __( 'Registration is disabled', 'w3dev' );
		}

		if ( isset( $_GET['action'] ) && $_GET['action'] == 'register' ) {
			ob_start();
			wp_redirect( wp_login_url() );
			ob_clean();
		}

	}

	if (!empty($settings['security']['disable_comments'])) {

		// Disable support for comments and trackbacks in post types
		function w3dev_disable_comments_post_types_support() {
		    $post_types = get_post_types();
		    foreach ($post_types as $post_type) {
		        if(post_type_supports($post_type, 'comments')) {
		            remove_post_type_support($post_type, 'comments');
		            remove_post_type_support($post_type, 'trackbacks');
		        }
		    }
		}
		add_action('admin_init', 'w3dev_disable_comments_post_types_support');

		// Close comments on the front-end
		function w3dev_disable_comments_status() {
		    return false;
		}
		add_filter('comments_open', 'w3dev_disable_comments_status', 20, 2);
		add_filter('pings_open', 'w3dev_disable_comments_status', 20, 2);

		// Hide existing comments
		function w3dev_disable_comments_hide_existing_comments($comments) {
		    $comments = array();
		    return $comments;
		}
		add_filter('comments_array', 'w3dev_disable_comments_hide_existing_comments', 10, 2);


	}

	$w3dev_ban_css_scipts_options = get_option('w3dev_ban_css_scipts_options'); 
	$inc_header_css = !empty($w3dev_ban_css_scipts_options['inc_header_css']) ? 1 : 0;
	$inc_footer_js  = !empty($w3dev_ban_css_scipts_options['inc_footer_js']) ? 1 : 0;

	if (!empty($inc_header_css)) {
		function w3dev_ban_user_extra_css() {

			$w3dev_ban_css_scipts_options = get_option('w3dev_ban_css_scipts_options'); 
			if (!empty($w3dev_ban_css_scipts_options['editor_css'])) { 
				?><style><?php echo stripslashes($w3dev_ban_css_scipts_options['editor_css']); ?></style><?php
			}

		}
		add_action('wp_head', 'w3dev_ban_user_extra_css');
	}

	if (!empty($inc_footer_js)) {
		function w3dev_ban_user_extra_js() {

			$w3dev_ban_css_scipts_options = get_option('w3dev_ban_css_scipts_options'); 
			if (!empty($w3dev_ban_css_scipts_options['editor_js'])) { 
				?><script type="text/javascript"><?php echo stripslashes($w3dev_ban_css_scipts_options['editor_js']); ?></script><?php
			}

		}
		add_action('wp_footer', 'w3dev_ban_user_extra_js');
	}

}
add_action('init', 'w3dev_ban_users_init_function');

add_filter( 'registration_errors', 'registration_ban', 10, 3);
function registration_ban($errors, $sanitized_user_login, $user_email) {

    global $wpdb;

	$w3dev_ban_user_class 		= W3DEV_BAN_USER_CLASS::get_instance();
	$settings               	= $w3dev_ban_user_class->get_options('settings');
    $registration_ban_options 	= $w3dev_ban_user_class->get_options('registration');
    $banned_username_options  	= get_option('w3dev_banned_username_options');

    $ip_address 				= $w3dev_ban_user_class->get_ip_address();
    $user_agent 				= $w3dev_ban_user_class->get_user_agent();
    $geodata 					= $w3dev_ban_user_class->get_geodata();
	$denied_login_message 		= !empty($settings['denied_login_message']) ? $settings['denied_login_message'] :  $settings['_defaults']['denied_login_message'];

	// Return error if user agent and/or ip address can't be determined (where applicable)
	// --
   	if (!empty($settings['security']['deny_reg_no_useragent']) || 
   		!empty($settings['security']['deny_reg_no_ipaddress'])) {

   		if (empty($ip_address) || empty($user_agent)) {

			$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'denied', 'label' => 'spam'));

   			$errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: '.$denied_login_message) );
   		}

   	}

    if (empty($registration_ban_options['enable_reg_ban_by_ip']) && empty($registration_ban_options['enable_reg_ban_by_email'])) { 
    	return $errors;
    }

    // check if users email address has been banned
    // --
    $db_table_name = $wpdb->prefix . 'w3dev_banned_logins';
    
    if (!empty($registration_ban_options['enable_reg_ban_by_email'])) {
	    $is_email_banned = $wpdb->get_results( $wpdb->prepare("
	        SELECT * FROM ".$db_table_name."
	        WHERE email_address = %s", $user_email)
	    );

	    if (!empty($is_email_banned)) {

			$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'denied', 'label' => 'email'));

	    	$errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: The Email Address has been banned from registration.') );
        } elseif($w3dev_ban_user_class->is_domain_forbidden($user_email)) {
            $errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: The Email Address domain is forbidden.') );
        }
	}   

	if (!empty($registration_ban_options['enable_reg_ban_by_ip'])) {

	    // check if users ip address has been banned
	    // --
		if (!empty($ip_address)) {
		    $is_ip_banned = $wpdb->get_results( $wpdb->prepare("
		        SELECT * FROM ".$db_table_name."
		        WHERE ip_address = %d", ip2long($ip_address))
		    );

		    if (!empty($is_ip_banned)) {

				$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'denied', 'label' => 'ip'));

		    	$errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: Your IP Address has been banned from registration.') );
		    }
		}
	}

	if (!empty($registration_ban_options['enable_reg_ban_by_countrycode'])) {

		if (!empty($geodata)) {

			$geodata = json_decode($geodata);
			if (!empty($geodata)) {

				$countrycode = !empty($geodata->country_code) ? $geodata->country_code : (!empty($geodata->countryCode) ? $geodata->countryCode : false);

			    // check if users ip address has been banned
			    // --
				if (!empty($countrycode)) {
				    $is_countrycode_banned = $wpdb->get_results( $wpdb->prepare("
				        SELECT * FROM ".$db_table_name."
				        WHERE geodata = %d", "countrycode:$countrycode")
				    );

				    if (!empty($is_countrycode_banned)) {

						$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'denied', 'label' => 'ccode'));

				    	$errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: Your Country has been banned from registration.') );
				    }
				}
			}
		}
	}

	if (!empty($banned_username_options['banned_usernames'])) {

		$banned_usernames = explode('|', $banned_username_options['banned_usernames']);
		if (in_array($sanitized_user_login, $banned_usernames)) {

			$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'denied', 'label' => 'username'));

			$errors->add( 'Registration_Ban', __('<strong>ERROR</strong>: This username is not allowed.') );


		}

	}

	// capture successfull registration
	// --
	$w3dev_ban_user_class->log_event(array('category' => 'register', 'action' => 'success'));

    return $errors;

}

add_filter('get_avatar', 'w3dev_ban_avatar_image', 1, 5);
function w3dev_ban_avatar_image($avatar, $id_or_email, $size, $default, $alt)
{ 
    $w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();

    if (is_numeric($id_or_email))
    {        
        $user_id = $id_or_email;
    
    } else if (is_string($id_or_email) && filter_var($id_or_email, FILTER_VALIDATE_EMAIL)) {

        $user_id = get_user_by("email", $id_or_email);
        
        if (!empty($user_id->get("ID")))
        { 
        	$user_id = $user_id->get("ID");
    	
    	} else if (!empty($user_id->ID)) {

        	$user_id = $user_id->ID;

    	}
    
    } else if (is_object($id_or_email) && !empty($id_or_email->user_id)) {

        $user_id = $id_or_email->user_id;
    }

    if (empty($user_id) || 
        !$w3dev_ban_user_class->is_user_banned($user_id) ||
        !$w3dev_ban_user_class->is_hide_avatar($user_id))
    {
        return $avatar;
    }

    $default = '<img alt="" class="avatar avatar-32 photo" src="" srcset="" width="32" height="32">';
    return $default;
    
}
