<?php
if ( ! defined('ABSPATH' ) ) exit;

add_action( 'admin_enqueue_scripts', 'w3dev_ban_users_css' );
function w3dev_ban_users_css() {

    $w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
    $settings               = $w3dev_ban_user_class->get_options('settings');

	if (empty($settings['disable_autoload']['flatpickr']))
	{
		wp_register_style('w3dev-jquery-datepicker-css', "https://cdnjs.cloudflare.com/ajax/libs/flatpickr/2.1.1/flatpickr.min.css", array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-jquery-datepicker-css');
		wp_register_style('w3dev-jquery-datepicker-flat-css', "//cdnjs.cloudflare.com/ajax/libs/flatpickr/2.1.1/themes/base16_flat.css", array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-jquery-datepicker-flat-css');
		wp_register_style('w3dev-jquery-datepicker-red-css', "//cdnjs.cloudflare.com/ajax/libs/flatpickr/2.1.1/themes/material_red.css", array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-jquery-datepicker-red-css');
	}

	if (empty($settings['disable_autoload']['fa']))
	{
		wp_register_style('w3dev-font-awesome', '//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css', array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-font-awesome');
	}

	wp_register_style('w3dev-mini-bs-helper-css', plugins_url('../css/mini-bs-v3-helper.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
	wp_enqueue_style('w3dev-mini-bs-helper-css');

	wp_register_style('w3dev-ban-users-css', plugins_url('../css/style.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
	wp_enqueue_style('w3dev-ban-users-css');

	wp_register_style('w3dev-balloon-css', plugins_url('../css/balloon.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
	wp_enqueue_style('w3dev-balloon-css');

	if (empty($settings['disable_autoload']['faanimation']))
	{
		wp_register_style('w3dev-faa-css', plugins_url('../lib/font-awesome-animation/src/font-awesome-animation.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-faa-css');
	}

	if ( W3DEV_BAN_USERS_PREMIUM_VERSION ) {

		wp_register_style('w3dev-flags-css', plugins_url('../css/flags.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('w3dev-flags-css');

		if (empty($settings['disable_autoload']['datatables']))
		{
			wp_register_style('w3dev-dataTables-css', "//cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css", array(), W3DEV_BAN_USERS_VERSION_ID);
			wp_enqueue_style('w3dev-dataTables-css');
		}

		if (empty($settings['disable_autoload']['select2']))
		{
			wp_register_style('w3dev-select2-css', "//cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css", array(), W3DEV_BAN_USERS_VERSION_ID);
			wp_enqueue_style('w3dev-select2-css');
		}

	}

	if (empty($settings['disable_autoload']['jq_confirm']))
	{
		wp_register_style('jquery-confirm-css', '//cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css', array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('jquery-confirm-css');
	}

	if (empty($settings['disable_autoload']['selectric']))
	{
		wp_register_style('jquery-selectric-css', plugins_url('../lib/jQuery-Selectric/public/selectric.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
		wp_enqueue_style('jquery-selectric-css');
	}

	wp_register_style('jquery-timepicker', plugins_url('../lib/jonthornton-jquery-timepicker/jquery.timepicker.css', __FILE__), array(), W3DEV_BAN_USERS_VERSION_ID);
	wp_enqueue_style('jquery-timepicker');

	wp_register_style('w3dev-animate', "//cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css", array(), W3DEV_BAN_USERS_VERSION_ID);
	wp_enqueue_style('w3dev-animate');

    if (empty($settings['disable_autoload']['sumoselect'])) {
        wp_register_style('jquery-sumoselect-css', '//cdnjs.cloudflare.com/ajax/libs/jquery.sumoselect/3.0.2/sumoselect.min.css', array(), W3DEV_BAN_USERS_VERSION_ID);
        wp_enqueue_style('jquery-sumoselect-css');
    }

}


add_action( 'admin_enqueue_scripts', 'w3dev_ban_users_js' );
function w3dev_ban_users_js($hook) {

    $w3dev_ban_user_class    = W3DEV_BAN_USER_CLASS::get_instance();
    $settings                = $w3dev_ban_user_class->get_options('settings');

	wp_register_script('w3dev-ban-users-js', plugins_url('../javascript/app.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
	wp_enqueue_script('w3dev-ban-users-js');

    $default_ban_reason     = isset($settings['default_ban_reason']) ? $settings['default_ban_reason'] : '';
    $default_warn_reason    = isset($settings['default_warn_reason']) ? $settings['default_warn_reason'] : '';

    $localize_script_data = array(
        'default_ban_reason'  => $default_ban_reason,
        'default_warn_reason' => $default_warn_reason
    );
    wp_localize_script( 'w3dev-ban-users-js', 'php_vars', $localize_script_data );

	if ( W3DEV_BAN_USERS_PREMIUM_VERSION ) {

		wp_register_script('w3dev-ultimate-ban-users-js', plugins_url('../javascript/ultimate-app.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
		wp_enqueue_script('w3dev-ultimate-ban-users-js');

		if (empty($settings['disable_autoload']['notify'])) {
		    //wp_register_script('w3dev-notifyjs-js', '//cdnjs.cloudflare.com/ajax/libs/notify/0.4.2/notify.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
		    wp_register_script('w3dev-notifyjs-js', plugins_url('../lib/notifyjs/dist/notify.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
		    wp_enqueue_script('w3dev-notifyjs-js');
		}

		if ($hook == 'settings_page_ban_user_page')
		{
		    if (empty($settings['disable_autoload']['datatables'])) {
		        wp_register_script('w3dev-datatables-js', '//cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
	                wp_enqueue_script('w3dev-datatables-js');
		    }

		    if (empty($settings['disable_autoload']['select2'])) {
		        wp_register_script('w3dev-select2-js', '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
	                wp_enqueue_script('w3dev-select2-js');
		    }

		    wp_register_script('w3dev-ban-user-tagging-js', plugins_url('../javascript/tagging.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
	            wp_enqueue_script('w3dev-ban-user-tagging-js');

		    if (empty($settings['disable_autoload']['chartjs'])) {
				wp_register_script('w3dev-chartjs', '//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.3/Chart.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
		        wp_enqueue_script('w3dev-chartjs');
		    }

		}



	}

	if (empty($settings['disable_autoload']['momentjs'])) {
		wp_register_script('w3dev-momentjs-js', '//cdnjs.cloudflare.com/ajax/libs/moment.js/2.23.0/moment-with-locales.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
		wp_enqueue_script('w3dev-momentjs-js');
	}

    if (empty($settings['disable_autoload']['flatpickr'])) {
		wp_register_script('w3dev-jquery-datepicker-js', '//cdnjs.cloudflare.com/ajax/libs/flatpickr/2.1.1/flatpickr.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
        wp_enqueue_script('w3dev-jquery-datepicker-js');
    }

    if (empty($settings['disable_autoload']['jq_confirm'])) {
		wp_register_script('w3dev-jquery-confirm-js', '//cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
        wp_enqueue_script('w3dev-jquery-confirm-js');
    }

    if (empty($settings['disable_autoload']['selectric'])) {
		wp_register_script('w3dev-jquery-selectric-js', plugins_url('../lib/jQuery-Selectric/public/jquery.selectric.min.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
        wp_enqueue_script('w3dev-jquery-selectric-js');
    }

    if (empty($settings['disable_autoload']['jq_mask'])) {
		wp_register_script('w3dev-jquery-mask-js', '//cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.11/jquery.mask.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
        wp_enqueue_script('w3dev-jquery-mask-js');
    }

    if (empty($settings['disable_autoload']['sumoselect'])) {
        wp_register_script('w3dev-jquery-sumoselect-js', '//cdnjs.cloudflare.com/ajax/libs/jquery.sumoselect/3.0.2/jquery.sumoselect.min.js', array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
        wp_enqueue_script('w3dev-jquery-sumoselect-js');
    }

	wp_register_script('w3dev-timepicker', plugins_url('../lib/jonthornton-jquery-timepicker/jquery.timepicker.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
    wp_enqueue_script('w3dev-timepicker');

	wp_register_script('w3dev-datepair', plugins_url('../lib/jonthornton-Datepair-js/src/Datepair.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
    wp_enqueue_script('w3dev-datepair');

	wp_register_script('w3dev-datepairjq', plugins_url('../lib/jonthornton-Datepair-js/src/jquery.datepair.js', __FILE__), array('jquery'), W3DEV_BAN_USERS_VERSION_ID, false);
    wp_enqueue_script('w3dev-datepairjq');

}
