<?php
/*
 * Plugin Name: Ultimate Ban Users | Shared By Themes24x7.com
 * Plugin URI: http://webxmedia.co.uk
 * Description: Ban a user from logging into their wordpress account.
 * Version: 1.5.3
 * Author: پرشین اسکریپت
 * Author URI: http://www.persianscript.ir
 * License: GPLv2
 */

if ( ! defined('ABSPATH' ) ) exit;
if ( !defined('W3DEV_DEBUG_MODE') ) { 

	$settings 	= get_option('w3dev_ban_user_options');
	$debug 		= !empty($settings['debug']['php']) ? 1 : 0;
	DEFINE('W3DEV_DEBUG_MODE', $debug);
}

DEFINE( 'W3DEV_BAN_USERS_PLUGIN_VERSION', '1.5.3' );
DEFINE( 'W3DEV_BAN_USERS_PREMIUM_VERSION', TRUE );
DEFINE( 'W3DEV_BAN_USERS_PLUGIN_FILE', __FILE__ );
DEFINE( 'W3DEV_BAN_USERS_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
DEFINE( 'W3DEV_BAN_USERS_PLUGIN_NAME', ( W3DEV_BAN_USERS_PREMIUM_VERSION ? 'Ultimate BAN Users' : 'BAN Users' ) );

if ( !defined('W3DEV_IS_ADMIN') ) { DEFINE( 'W3DEV_IS_ADMIN', is_admin() ? true : false ); }
if ( W3DEV_DEBUG_MODE ) { ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL); }

include_once('w3dev-ban-users-class.php');
$w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
$settings               = $w3dev_ban_user_class->get_options('settings');

if ( W3DEV_BAN_USERS_PREMIUM_VERSION ) {
	include_once( 'include/plugin-activation.php' );
	include_once( 'include/mobidetect-2.8.26/Mobile_Detect.php' );
	include_once( 'include/ultimate-ajax.php' );
	
	if ( !empty( $settings['send_notification_new_post'] ) ) { // check to see if email moderation is enabled
		include_once('include/moderation.php');
	}
}

include_once( 'include/admin-enqueue-script.php' );
include_once( 'include/public-enqueue-script.php' );
include_once( 'include/crons.php' );
include_once( 'include/ajax.php' );
include_once( 'include/settings-page.php' );
include_once( 'include/view.php' );
include_once( 'include/functions.php' );
include_once( 'include/shortcodes.php' );

if ( !empty( $settings['extensions']['ultimate_member'] ) || !isset( $settings['extensions']['ultimate_member'] ) ) {
	include_once( 'include/plugins/ultimate-member.php' );
}

function w3dev_plugin_add_settings_link( $links ) {
    $settings_link = '<a href="options-general.php?page=ban_user_page.php">' . __( 'Settings' ) . '</a>';
    array_push( $links, $settings_link );
    if ( !W3DEV_BAN_USERS_PREMIUM_VERSION ) {
    	$buyLink = "<a target='_blank' href='https://codecanyon.net/item/wp-ultimate-ban-users/17508338'><b style='color:red'>Go <i>Pro</i>!</b></a>";
		array_unshift($links, $buyLink);
    }
  	return $links;
}
$plugin = plugin_basename( __FILE__ );
add_filter( "plugin_action_links_$plugin", 'w3dev_plugin_add_settings_link' );

if ( !empty($settings['security']['hide_wp_login_messages']) ) {
    function ambiguous_error($errors) { 
    	$w3dev_ban_user_class   = W3DEV_BAN_USER_CLASS::get_instance();
		$settings               = $w3dev_ban_user_class->get_options('settings');
    	return !empty( $settings['security']['ambiguous_error_messages'] ) ? $settings['security']['ambiguous_error_messages'] : "";
    }
    add_filter('login_errors', 'ambiguous_error', 100);
}

?>
