<?php

if ( ! defined('ABSPATH' ) ) exit;

add_filter('user_row_actions', 'w3dev_ban_user_action_links', 10, 2);
function w3dev_ban_user_action_links($actions, $user_object) {

	if ( get_current_user_id() != $user_object->ID ) {

		$w3dev_ban_user_class 	= W3DEV_BAN_USER_CLASS::get_instance();
	    $settings 				= $w3dev_ban_user_class->get_options('settings');
	    $notifications 			= $w3dev_ban_user_class->get_options('notifications');
	    $priv_rights 			= !empty($settings['security']['priv_rights']) ? $settings['security']['priv_rights'] : 0; // >=, >, = or 0
	    $priv_roles 			= !empty($settings['security']['priv_roles']) ? $settings['security']['priv_roles'] : 0; // i.e. author

	    $current_user = wp_get_current_user();
	    $roles = $current_user->roles;
	    $role = array_shift( $roles );

	    // if current user doesn't belong to this restricted group, then return
	    // --
	    if (!empty($priv_rights) && $priv_rights == '==') {
	    	if (!empty($priv_roles) && $priv_roles !== $role) { return $actions; }
	    }

        $warn = $date = null;

    	$accessibility = !empty( $settings['enable_accessibility'] ) ? 1 : 0;

        if (empty($accessibility)) {

	        $date = '
		        <a style="color:#337ab7" class="cgc_ub_edit_badges icon-warn-user " href="'.get_edit_user_link( $user_object->ID ).'"  aria-label="Edit">
					<span class="fa-stack fa-lg" aria-hidden="true">
					  <i class="fa fa-square fa-stack-2x" aria-hidden="true"></i>
					  <i class="fa fa-pencil fa-stack-1x fa-inverse" aria-hidden="true"></i>
					</span>
		        </a>
		        <style>.row-actions .edit { display:none; }</style>';

        }

        if ( $is_user_banned = $w3dev_ban_user_class->is_user_banned( $user_object->ID ) ) {
	        $text_label = '<span class="banned-user '.(!empty($settings['users_tbl_row_highlighted']) ? 'row-highlight' : null).'">UnBan User</span>';
	        $label = '<span class="banned-user '.(!empty($settings['users_tbl_row_highlighted']) ? 'row-highlight' : null).'"></span>';
	        $icon_ban_class = 'active';
        } else {
        	$text_label = '<span>Ban User</span>';
        	$label = '<span></span>';
        	$icon_ban_class = null;
        }

        if ( !empty( $settings['warn_user'] ) ) {

        	$allow_reason = 
        		!empty( $notifications['user_notification']['warn_body_reason'] ) ? 
        		$notifications['user_notification']['warn_body_reason'] : 
        		$notifications['_defaults']['user_notification']['warn_body_reason'] ;

			if (!empty($accessibility)) {

	        	$date .='
		         <a class="w3dev-accessibility cgc_ub_edit_badges warn-ban-user '.(!empty($icon_ban_class) ? 'hide' : null).'" href="javascript:void(0)" data-user-id="' . $user_object->ID .'" data-allow-reason="'.( (!empty($allow_reason) && !empty( $settings['warn_user_reason'] )) ? "1" : "0") .'">Warn user</a>';

			} else {

		        $date .='
		        <a class="cgc_ub_edit_badges icon-warn-user warn-ban-user '.(!empty($icon_ban_class) ? 'hide' : null).'" href="javascript:void(0)" data-user-id="' . $user_object->ID .'" data-allow-reason="'.( (!empty($allow_reason) && !empty( $settings['warn_user_reason'] )) ? "1" : "0") .'" aria-label="Warn user">
				<span class="fa-stack fa-lg" aria-hidden="true">
				  <i class="fa fa-square fa-stack-2x" aria-hidden="true"></i>
				  <i class="fa fa-exclamation-triangle fa-stack-1x fa-inverse" aria-hidden="true"></i>
				</span>
		        </a>
	        	';

        	}
        	
    	}

    	if (!empty($accessibility)) {

			$date .= '
	         | <a class="w3dev-accessibility cgc_ub_edit_badges toggle-ban-user ' . $icon_ban_class . '" data-user-id="'.$user_object->ID.'" data-ban-email="'.(($settings['ban_email_default']) ? "1" : "0") .'" href="javascript:void(0)">'.$text_label.'</a>
			';

    	} else {

		$date .= '
        <a class="cgc_ub_edit_badges icon-ban-user toggle-ban-user ' . $icon_ban_class . '" data-user-id="'.$user_object->ID.'" data-ban-email="'.(($settings['ban_email_default']) ? "1" : "0") .'" href="javascript:void(0)">
			<span class="fa-stack fa-lg" aria-hidden="true">
			  <i class="fa fa-square fa-stack-2x" aria-hidden="true"></i>
			  <i class="fa fa-ban fa-stack-1x fa-inverse" aria-hidden="true"></i>
		</span>
		' . __( $label, 'w3dev' ) . '
			<span class="sr-only">Ban user</span>
        </a>
		';

    	}

    	/*
       	if (!empty($ip_address)) {
			global $wpdb;
			$db_table_name = $wpdb->prefix . 'w3dev_login_details';
			$results = $wpdb->get_results( $wpdb->prepare("
				SELECT user_id, ip_address FROM $db_table_name
				WHERE user_id = %d
				GROUP BY ip_address
				", $user_object->ID
				) );

			if (!empty($results) && count($results) > 1) {

				$multiuser_list = null;
				foreach($results as $row) {
					$multiuser_list .= long2ip($row->ip_address).", ";
				}
				$multiuser_list = rtrim($multiuser_list,", ");
		        $date .='
		        <a class="cgc_ub_edit_badges icon-multi-user multi-user '.(!empty($icon_ban_class) ? 'hide' : null).'" href="javascript:void(0)" data-textarea-content="'.$multiuser_list.'" data-user-id="' . $user_object->ID .'" aria-label="Shared ccount">
				<span class="fa-stack fa-lg" aria-hidden="true">
				  <i class="fa fa-square fa-stack-2x" aria-hidden="true"></i>
				  <i class="fa fa-user-plus fa-stack-1x fa-inverse" aria-hidden="true"></i>
				</span>
		        </a>';

	        }

		}
		*/

        $actions['edit_badges'] = $date;
    }

	return $actions;

}

if (!empty($settings['users_tbl_data_column']) || !empty($settings['users_tbl_geoip_data_column'])) {

	add_filter('manage_users_columns', 'w3dev_ban_user_column');
	function w3dev_ban_user_column($columns) {

		$w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
		$settings = $w3dev_ban_user_class->get_options('settings');

	    if (!empty($settings['users_tbl_data_column']) && !empty($settings['users_tbl_last_seen'])) { $columns['banned'] = 'Last Seen'; }
	    if (!empty($settings['users_tbl_geoip_data_column'])) { $columns['geodata'] = 'User Insights'; } //'IP/Geodata'; }
	    return $columns;
	}

	add_action('manage_users_custom_column',  'w3dev_show_ban_user_column_content', 10, 3);
	function w3dev_show_ban_user_column_content($value, $column_name, $user_id) {
	    
		$w3dev_ban_user_class = W3DEV_BAN_USER_CLASS::get_instance();
		$settings = $w3dev_ban_user_class->get_options('settings');
		$is_user_banned = $w3dev_ban_user_class->is_user_banned( $user_id );

		include_once( plugin_dir_path( __FILE__ ) . '../lib/browser-php/lib/Browser.php');
		
		global $wpdb;
		$db_table_name = $wpdb->prefix . 'w3dev_login_details';

		if (!empty($settings['users_tbl_geoip_data_column'])) {
			if ( 'geodata' == $column_name ) {

				$results = $wpdb->get_results( $wpdb->prepare("
					SELECT ip_address, user_agent, device, geodata FROM $db_table_name
					WHERE user_id = %d
					ORDER BY id DESC
					LIMIT 1
					", $user_id
					) );

					$device = null;
					if (!empty($results[0]->device)) {

						switch (strtolower($results[0]->device)) {
							case 'desktop':
								$device_label = '<i class="fa fa-desktop" aria-hidden="true"></i>';
								break;
							
							case 'mobile':
								$device_label = '<i class="fa fa-mobile" aria-hidden="true"></i>';
								break;

							case 'tablet':
								$device_label = '<i class="fa fa-tablet" aria-hidden="true"></i>';
								break;

							default:
								$device_label = '('.ucfirst($results[0]->device).')';
								break;
						}

						$device = '<span data-balloon="Show device information" data-balloon-pos="up" data-user-id="'.$user_id.'" class="users-info-btn  js-w3dev-device-info">' . $device_label . '</span> ';
						
					}

					$ip_address = !empty($results[0]->ip_address) ? long2ip($results[0]->ip_address) : '--';
					$geodata 	= !empty($results[0]->geodata) ? json_decode($results[0]->geodata, true) : null;

					$getbrowser = $browser = null;
					if (!empty($results[0]->user_agent)) {
						$browser = new Browser($results[0]->user_agent);
						$getbrowser = strtolower($browser->getBrowser());
						if (!empty($getbrowser)) {
							$browser = '<img style="position:relative; bottom:-2px; margin-right: 5px;" src="https://cdnjs.cloudflare.com/ajax/libs/browser-logos/42.8.0/'.$getbrowser.'/'.$getbrowser.'_16x16.png" />';
						}
					}
					$img = $country_name = null;
					if (!empty($geodata['countryCode']) && !empty($geodata['country'])) {
						$img = '<span style="position:relative; bottom:-3px; margin-right: 5px;" src="blank.gif" class="flag flag-'.strtolower($geodata['countryCode']).'" alt="'.$geodata['country'].'"></span>';
						$country_name = $geodata['country']; 
					} elseif (!empty($geodata['country_code']) && !empty($geodata['country_name'])) {
						$img = '<span style="position:relative; bottom:-3px; margin-right: 5px;" src="blank.gif" class="flag flag-'.strtolower($geodata['country_code']).'" alt="'.$geodata['country_name'].'" /></span>';
						$country_name = $geodata['country_name'];
					}
					

					$shared_account = null;
			       	if (!empty($ip_address)) {

						$shared_accounts = $w3dev_ban_user_class->get_shared_accounts($user_id);
						if (!empty($shared_accounts) && count($shared_accounts) > 1) {

					        $shared_account = '<span data-balloon="Show shared accounts" data-balloon-pos="up" data-user-id="'.$user_id.'" class="users-shared-btn js-w3dev-shared-accounts"><i class="fa fa-user-plus" aria-hidden="true"></i></span>';

				        }

					}

					$banned_modal = '<span data-balloon="Show banned history" data-balloon-pos="up" style="'.($is_user_banned ? null : 'color:#cccccc').'" data-user-id="'.$user_id.'" class="users-info-btn js-w3dev-banned-history"><i class="fa fa-ban" aria-hidden="true"></i></span>';
					
					$info_modal = null;
					if ($w3dev_ban_user_class->get_user_history($user_id)) {
						$info_modal = '<span data-balloon="Show login history" data-balloon-pos="up" data-user-id="'.$user_id.'" class="users-info-btn js-w3dev-user-history"><i class="fa fa-history" aria-hidden="true"></i></span>';
					}

				return '<span>' . $banned_modal . $info_modal . $shared_account . $device . $browser . $img . '</span>';
			}
		}
	    
	    if (!empty($settings['users_tbl_data_column'])) {
			if ( 'banned' == $column_name ) {

				$results = $wpdb->get_results( $wpdb->prepare("
					SELECT date_time FROM $db_table_name
					WHERE user_id = %d
					ORDER BY id DESC
					LIMIT 1
					", $user_id
					) );

				$last_seen = !empty($results[0]->date_time) ? '<span class="w3dev-mjs-from-now">'.date('d-m-Y H:i:s ', strtotime($results[0]->date_time)).'</span>' : '--';

				/*
				if ($w3dev_ban_user_class->is_user_banned($user_id)) {

					$banned_reason 	= get_user_option( 'w3dev_user_banned_reason',  $user_id );
					$banned_date 	= get_user_option( 'w3dev_user_banned_date',  $user_id );

					$balloon_attr 	= null;

					if (!empty($banned_reason)) {

						$str_length = strlen($banned_reason);
						if ($str_length < 20) {
							$balloon_length = 'medium';
						} elseif ($str_length < 60) {
							$balloon_length = 'medium';
						} elseif ($str_length < 100) {
							$balloon_length = 'large';
						} else {
							$balloon_length = 'xlarge';
						}

						// prepend date banned to tooltip reason if date exists
						// --
						$banned_reason = !empty($banned_date) ? 'Banned: '.date($settings['date_format'], strtotime($banned_date)).' - '.$banned_reason : $banned_reason;
						$balloon_attr = 'data-balloon="'.$banned_reason.'" data-balloon-length="'.$balloon_length.'" data-balloon-pos="up"';

					} elseif (!empty($banned_date)) {

						$balloon_attr = 'data-balloon="Banned: '.date($settings['date_format'], strtotime($banned_date)).'" data-balloon-length="medium" data-balloon-pos="up"';

					}

					return '<span '.$balloon_attr.' class="w3dev-banned-status active"><i class="fa fa-ban fa-lg" aria-hidden="true"></i></span>&nbsp;'.$last_seen;
					exit;
				}
				*/
				
				$unbanned_date = get_user_option( 'w3dev_user_unbanned_date',  $user_id );
				$balloon_attr = null;
				if (!empty($unbanned_date)) {

					$balloon_attr = 'data-balloon="Reinstated: '.date($settings['date_format'], strtotime($unbanned_date)).'" data-balloon-length="medium" data-balloon-pos="up"';

				}

				// return '<span '.$balloon_attr.' class="w3dev-banned-status"><i class="fa fa-ban fa-lg" aria-hidden="true"></i></span>&nbsp;'.$last_seen;
				return $last_seen; 

				exit;
			}
		}
	    return $value;
	}
	
}

