<?php

//Prevent direct access to this file
if ( ! defined( 'WPINC' ) ) {
    die();
}

/**
 * Enqueue the Gutenberg block assets for the backend.
 *
 * 'wp-blocks': includes block type registration and related functions.
 * 'wp-element': includes the WordPress Element abstraction for describing the structure of your blocks.
 */
function dauc_editor_assets() {

    $shared = Dauc_Shared::get_instance();

    //Styles -----------------------------------------------------------------------------------------------------------

    //Block
    wp_enqueue_style(
        'dauc-editor-css',
        plugins_url( 'dist/editor.css', dirname( __FILE__ ) ),
        array( 'wp-edit-blocks' )//Dependency to include the CSS after it.
    );

    //Scripts ----------------------------------------------------------------------------------------------------------

    //Block
    wp_enqueue_script(
        'dauc-editor-js', // Handle.
        plugins_url( '/dist/blocks.build.js', dirname( __FILE__ ) ), //We register the block here.
        array( 'wp-blocks', 'wp-element' ), // Dependencies.
        false,
        true //Enqueue the script in the footer.
    );

    /*
     * Pass the objectL10n object to the javascript file with the 'dauc-editor-js' handle.
     */
    wp_localize_script( 'dauc-editor-js', 'daucObjectL10n', array(
        'selectPlaceholder'  => __('Select...', 'dauc'),
        'selectNoOptionsMessage' => __('No options', 'dauc'),
        'chartKeyword' => __('chart', 'dauc'),
        'graphKeyword' => __('graph', 'dauc'),
        'diagramKeyword' => __('diagram', 'dauc')
    ) );

}
add_action( 'enqueue_block_editor_assets', 'dauc_editor_assets' );

/**
 * Enqueue the Gutenberg block assets for both frontend and backend.
 */
function dauc_style_assets() {

    //Not used with this block.
    return;

    //Styles -----------------------------------------------------------------------------------------------------------
    wp_enqueue_style(
        'dauc-style-css',
        plugins_url( 'dist/style.css', dirname( __FILE__ ) ),
        array( 'wp-blocks' )//Dependency to include the CSS after it
    );

}
add_action( 'enqueue_block_assets', 'dauc_style_assets' );

/**
 * Dynamic Block Server Component
 *
 * For more info:
 *
 * https://wordpress.org/gutenberg/handbook/blocks/creating-dynamic-blocks/
 */
function dauc_select_chart_render($attributes) {

    if(isset($attributes['chartId'])){
        $public = Dauc_Public::get_instance();
        return $public->display_uberchart(array('id' => $attributes['chartId']));
    }

}
register_block_type( 'dauc/select-chart', array(
    'render_callback' => 'dauc_select_chart_render',
) );