var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
///<reference path="../../common/decorators.ts"/>
var TotalCore;
(function (TotalCore) {
    var Modules;
    (function (Modules) {
        var Providers;
        (function (Providers) {
            var Service = TotalCore.Common.Service;
            var RepositoryService = /** @class */ (function () {
                function RepositoryService($resource, prefix, $sce, ajaxEndpoint) {
                    this.prefix = prefix;
                    this.$sce = $sce;
                    this.cached = {};
                    this.resource = $resource(ajaxEndpoint, {}, {
                        list: { method: 'GET', isArray: true, cache: true, params: { action: prefix + "_modules_list" } },
                        update: { method: 'POST', params: { action: prefix + "_modules_update" } },
                        uninstall: { method: 'POST', params: { action: prefix + "_modules_uninstall" } },
                        activate: { method: 'POST', params: { action: prefix + "_modules_activate" } },
                        deactivate: { method: 'POST', params: { action: prefix + "_modules_deactivate" } },
                        installFromStore: { method: 'POST', params: { action: prefix + "_modules_install_from_store" } },
                        installFromFile: {
                            method: 'POST',
                            params: { action: prefix + "_modules_install_from_file" },
                            uploadEventHandlers: {
                                progress: function (event) {
                                    var progress = Math.round(event.loaded / event.total * 100);
                                    if (progress) {
                                        RepositoryService_1.uploadProgress(progress);
                                    }
                                }
                            }
                        },
                    });
                }
                RepositoryService_1 = RepositoryService;
                RepositoryService.prototype.activate = function (id, type) {
                    return this.resource.activate({ id: id, type: type }).$promise;
                };
                RepositoryService.prototype.deactivate = function (id, type) {
                    return this.resource.deactivate({ id: id, type: type }).$promise;
                };
                RepositoryService.prototype.installFromFile = function (file) {
                    return this.progressivePromise(this.resource
                        .installFromFile({ module: file })
                        .$promise);
                };
                RepositoryService.prototype.installFromStore = function (id, type) {
                    return this.resource.installFromStore({ id: id, type: type }).$promise;
                };
                RepositoryService.prototype.list = function () {
                    var _this = this;
                    return this.resource
                        .list()
                        .$promise
                        .then(function (response) {
                        return response.map(function (module) {
                            module.description = _this.$sce.trustAsHtml(module.description);
                            return new TotalCore.Modules.Models.Module(module);
                        });
                    });
                };
                RepositoryService.prototype.uninstall = function (id, type) {
                    return this.resource.update({ id: id, type: type }).$promise;
                };
                RepositoryService.prototype.update = function (id, type) {
                    return this.resource.update({ id: id, type: type }).$promise;
                };
                RepositoryService.prototype.progressivePromise = function (promise) {
                    promise.progress = function (callback) {
                        if (angular.isFunction(callback)) {
                            RepositoryService_1.uploadProgress = callback;
                            RepositoryService_1.uploadProgress(1);
                        }
                        return this;
                    };
                    return promise;
                };
                RepositoryService.uploadProgress = angular.noop;
                RepositoryService = RepositoryService_1 = __decorate([
                    Service('services.modules')
                ], RepositoryService);
                return RepositoryService;
                var RepositoryService_1;
            }());
            Providers.RepositoryService = RepositoryService;
        })(Providers = Modules.Providers || (Modules.Providers = {}));
    })(Modules = TotalCore.Modules || (TotalCore.Modules = {}));
})(TotalCore || (TotalCore = {}));
