var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
///<reference path="../../common/decorators.ts"/>
///<reference path="../../common/providers/settings.ts"/>
var TotalCore;
(function (TotalCore) {
    var Modules;
    (function (Modules) {
        var Components;
        (function (Components) {
            var Component = TotalCore.Common.Component;
            var ModulesManagerComponent = /** @class */ (function () {
                function ModulesManagerComponent($location, $timeout, RepositoryService) {
                    this.$location = $location;
                    this.$timeout = $timeout;
                    this.RepositoryService = RepositoryService;
                    this.modules = null;
                    this.states = {};
                    this.type = 'templates';
                }
                ModulesManagerComponent.prototype.$onInit = function () {
                    var _this = this;
                    this.RepositoryService.list().then(function (modulesList) {
                        _this.modules = modulesList;
                    });
                };
                ModulesManagerComponent.prototype.activate = function (module) {
                    module.set('activated', true);
                };
                ModulesManagerComponent.prototype.applyAction = function (action, module) {
                    var _this = this;
                    if (!this.states[module.getId()]) {
                        this.states[module.getId()] = {};
                    }
                    this.states[module.getId()].processing = true;
                    this.states[module.getId()].success = false;
                    this.states[module.getId()].error = false;
                    this.RepositoryService[action](module.getId(), module.getType())
                        .then(function (response) {
                        if (response.success) {
                            _this.states[module.getId()].success = true;
                            _this[action](module);
                        }
                        else {
                            _this.states[module.getId()].error = response.data || response;
                        }
                    })
                        .catch(function () {
                        _this.states[module.getId()].error = 'Something went wrong! Please try again.';
                    })
                        .finally(function () {
                        _this.$timeout(function () {
                            _this.states[module.getId()].success = false;
                            _this.states[module.getId()].processing = false;
                        }, 750);
                    });
                };
                ModulesManagerComponent.prototype.deactivate = function (module) {
                    module.set('activated', false);
                };
                ModulesManagerComponent.prototype.dismissError = function (module) {
                    if (this.states[module.getId()]) {
                        this.states[module.getId()].error = false;
                    }
                };
                ModulesManagerComponent.prototype.findModuleIndexById = function (id) {
                    var index = 0;
                    for (index; index < this.modules.length; index++) {
                        if (this.modules[index].id == id) {
                            return index;
                        }
                    }
                    return null;
                };
                ModulesManagerComponent.prototype.getError = function (module) {
                    if (this.states[module.getId()]) {
                        return this.states[module.getId()].error;
                    }
                };
                ModulesManagerComponent.prototype.getModules = function () {
                    var _this = this;
                    return this.modules === null ? [] : this.modules.filter(function (module) {
                        return module.getType() === _this.getType();
                    });
                };
                ModulesManagerComponent.prototype.getType = function () {
                    return this.type === 'extensions' ? 'extension' : 'template';
                };
                ModulesManagerComponent.prototype.installFromStore = function (module) {
                    module.set('installed', true);
                };
                ModulesManagerComponent.prototype.isProcessing = function (module) {
                    if (this.states[module.getId()]) {
                        return Boolean(this.states[module.getId()].processing);
                    }
                };
                ModulesManagerComponent.prototype.isSuccessful = function (module) {
                    if (this.states[module.getId()]) {
                        return Boolean(this.states[module.getId()].success);
                    }
                };
                ModulesManagerComponent.prototype.uninstall = function (module) {
                    if (module.getSource() === 'store') {
                        module.set('installed', false);
                        module.set('activated', false);
                    }
                    else {
                        this.modules.splice(this.findModuleIndexById(module.getId()), 1);
                    }
                };
                ModulesManagerComponent.prototype.update = function (module) {
                    module.set('version', module.getLastVersion());
                    module.set('update', false);
                };
                ModulesManagerComponent = __decorate([
                    Component('components.modules', {
                        templateUrl: 'modules-manager-component-template',
                        bindings: {
                            'type': '<'
                        }
                    })
                ], ModulesManagerComponent);
                return ModulesManagerComponent;
            }());
        })(Components = Modules.Components || (Modules.Components = {}));
    })(Modules = TotalCore.Modules || (TotalCore.Modules = {}));
})(TotalCore || (TotalCore = {}));
