var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
///<reference path="../../common/decorators.ts"/>
///<reference path="../../common/helpers.ts"/>
///<reference path="../../common/providers/settings.ts"/>
var TotalCore;
(function (TotalCore) {
    var Modules;
    (function (Modules) {
        var Components;
        (function (Components) {
            var Component = TotalCore.Common.Component;
            var Progressive = TotalCore.Common.Progressive;
            var ModulesInstallerComponent = /** @class */ (function (_super) {
                __extends(ModulesInstallerComponent, _super);
                function ModulesInstallerComponent(RepositoryService) {
                    var _this = _super.call(this) || this;
                    _this.RepositoryService = RepositoryService;
                    _this.message = {
                        type: false,
                        content: false
                    };
                    return _this;
                }
                ModulesInstallerComponent.prototype.getUploadPercentage = function () {
                    var uploadPercentage = this.getProgress();
                    return uploadPercentage === false || uploadPercentage >= 100 ? 'N/A' : uploadPercentage + '%';
                };
                ModulesInstallerComponent.prototype.install = function () {
                    var _this = this;
                    this.startProcessing();
                    this.RepositoryService
                        .installFromFile(this.file)
                        .progress(function (percentage) { return _this.setProgress(percentage); })
                        .then(function (response) {
                        _this.setMessage(response.success ? 'success' : 'error', response.data);
                        _this.file = null;
                    })
                        .catch(function (response) {
                        _this.setMessage('error', "(" + response.status + ") " + response.statusText);
                    })
                        .finally(function () {
                        _this.stopProcessing();
                    });
                };
                ModulesInstallerComponent.prototype.setMessage = function (type, content) {
                    this.message.type = type;
                    this.message.content = content;
                };
                ModulesInstallerComponent = __decorate([
                    Component('components.modules', {
                        templateUrl: 'modules-installer-component-template',
                        bindings: {}
                    })
                ], ModulesInstallerComponent);
                return ModulesInstallerComponent;
            }(Progressive));
        })(Components = Modules.Components || (Modules.Components = {}));
    })(Modules = TotalCore.Modules || (TotalCore.Modules = {}));
})(TotalCore || (TotalCore = {}));
