<?php

namespace TotalPoll\Migrations\Polls\WPPolls;
! defined( 'ABSPATH' ) && exit();


use TotalPoll\Migrations\Polls\Load;

/**
 * WP-Polls Migrator.
 * @package TotalPoll\Migrations\Polls\WPPolls
 */
class Migrator extends \TotalPoll\Migrations\Polls\Migrator {
	/**
	 * Migrator constructor.
	 *
	 * @param array $env
	 */
	public function __construct( $env ) {
		parent::__construct( $env, new Extract(), new Transform(), new Load() );
	}

	/**
	 * @return array
	 */
	public function jsonSerialize() {
		return [
			'name'  => 'WP-Polls',
			'image' => $this->env['url'] . 'assets/dist/images/migration/wp-polls.png',
			'total' => $this->getCount(),
		];
	}
}