<?php

namespace TotalPoll\Admin\Ajax;
! defined( 'ABSPATH' ) && exit();


use TotalPollVendors\TotalCore\Contracts\Http\Request;
use TotalPollVendors\TotalCore\Contracts\Modules\Repository;

/**
 * Class Templates
 * @package TotalPoll\Admin\Ajax
 * @since   1.0.0
 */
class Templates {
	/**
	 * @var array $template
	 */
	protected $template;
	/**
	 * @var Request $request
	 */
	protected $request;
	/**
	 * @var Repository $request
	 */
	protected $repository;
	/**
	 * @var array
	 */
	protected $templates = [];

	/**
	 * Templates constructor.
	 *
	 * @param Request    $request
	 * @param Repository $repository
	 */
	public function __construct( Request $request, Repository $repository ) {
		$this->request    = $request;
		$this->repository = $repository;

		$this->template  = (string) $this->request->request( 'template' );
		$this->templates = $this->repository->getActiveWhere( [ 'type' => 'template' ] );

		if ( empty( $this->template ) || ! isset( $this->templates[ $this->template ] ) ):
			wp_send_json_error( new \WP_Error( 'unknown_template', 'Unknown template.' ) );
		endif;
	}

	/**
	 * Get template defaults
	 * @action-callback wp_ajax_totalpoll_templates_get_defaults
	 */
	public function getDefaults() {
		$template = $this->templates[ $this->template ];
		$path     = "{$template['dirName']}/{$template['defaults']}";

		$defaults = [];
		if ( ! empty( $template['defaults'] ) && file_exists( $path ) ):
			$defaults = ( include $path );

			if ( ! is_array( $defaults ) ):
				$defaults = [];
			endif;
		endif;

		wp_send_json( $defaults );
	}

	/**
	 * Get template settings
	 * @action-callback wp_ajax_totalpoll_templates_get_settings
	 */
	public function getSettings() {
		$template = $this->templates[ $this->template ];
		$path     = "{$template['dirName']}/{$template['settings']}";

		if ( ! empty( $template['settings'] ) && file_exists( $path ) ):
			include $path;
		endif;
		wp_die();
	}

	/**
	 * Get template preview
	 * @action-callback wp_ajax_totalpoll_templates_get_preview
	 */
	public function getPreview() {
		$template = $this->templates[ $this->template ];
		$path     = "{$template['dirName']}/{$template['preview']}";

		if ( ! empty( $template['preview'] ) && file_exists( $path ) ):
			include $path;
		endif;
		wp_die();
	}
}