<?php

namespace TotalPoll\Contracts\Log;
! defined( 'ABSPATH' ) && exit();


/**
 * Poll repository
 * @package TotalPoll\Log
 * @since   1.0.0
 */
interface Repository {
	/**
	 * Get log entries.
	 *
	 * @param $query
	 *
	 * @return mixed
	 * @since 1.0.0
	 */
	public function get( $query );

	/**
	 * Get log entry by id.
	 *
	 * @param $logId
	 *
	 * @return \TotalPoll\Contracts\Log\Model|null
	 * @since 1.0.0
	 */
	public function getById( $logId );

	/**
	 * Create log entry.
	 *
	 * @param $attributes
	 *
	 * @since 1.0.0
	 * @return Model|\WP_Error
	 */
	public function create( $attributes );

	/**
	 * Delete log entries.
	 *
	 * @param $query array
	 *
	 * @return bool|\WP_Error
	 * @since 1.0.0
	 */
	public function delete( $query );

	/**
	 * Count log entries.
	 *
	 * @param $query
	 *
	 * @return mixed
	 * @since 1.0.0
	 */
	public function count( $query );

	/**
	 * Anonymize log entries.
	 *
	 * @param $query
	 *
	 * @return mixed
	 * @since 1.0.0
	 */
	public function anonymize( $query );
}