<?php
/**
 * Plugin Name: Timeline Widget Pro For Elementor
 * Description: Best timeline widget for Elementor page builder to showcase your personal or business stories in beautiful vertical or horizontal timeline layouts with many preset styles. <strong>[Elementor Addon]</strong>
 * Plugin URI:  https://cooltimeline.com/?utm_source=twae_plugin&utm_medium=inside&utm_campaign=product_site&utm_content=plugins_list
 * Version:     2.4.0
 * Author:      Cool Plugins
 * Author URI:  https://coolplugins.net/?utm_source=twae_plugin&utm_medium=inside&utm_campaign=author_page&utm_content=plugins_list
 * Text Domain: twae
 * Elementor tested up to: 3.30.1
 * Elementor Pro tested up to: 3.30.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( defined( 'TWAE_PRO_VERSION' ) ) {
	return;
}

define( 'TWAE_PRO_VERSION', '2.4.0' );
define( 'TWAE_PRO_FILE', __FILE__ );
define('TWAE_PRO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'TWAE_PRO_PATH', plugin_dir_path( TWAE_PRO_FILE ) );
define( 'TWAE_PRO_URL', plugin_dir_url( TWAE_PRO_FILE ) );
define('TWAE_FEEDBACK_API_PRO','https://cooltimeline-pro.com/');

if ( ! defined( 'TWAE_DEMO_URL' ) ) {
	define( 'TWAE_PREFIX', 'twae' );
	define( 'TWAE_DEMO_URL', 'https://cooltimeline.com/demo/?utm_source=twae_plugin&utm_medium=inside&utm_campaign=demo&utm_content=dashboard_pro' );
}

register_activation_hook( TWAE_PRO_FILE, array( 'Timeline_Widget_Pro_Addon', 'twae_pro_activate' ) );
register_deactivation_hook( TWAE_PRO_FILE, array( 'Timeline_Widget_Pro_Addon', 'twae_pro_deactivate' ) );

/**
 * Class Timeline_Widget_Pro_Addon
 */
final class Timeline_Widget_Pro_Addon {


	/**
	 * Plugin instance.
	 *
	 * @var Timeline_Widget_Pro_Addon
	 * @access private
	 */
	private static $instance = null;

	/**
	 * Get plugin instance.
	 *
	 * @return Timeline_Widget_Pro_Addon
	 * @static
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor.
	 *
	 * @access private
	 */
	private function __construct() {
		// $this->twae_load_dependency();
		 // Load the plugin after Elementor (and other plugins) are loaded.
		add_action( 'activated_plugin', array( $this, 'twae_plugin_redirection' ) );
		add_action( 'plugins_loaded', array( $this, 'twae_pro_is_plugin_loaded' ) );

		add_action( 'init', array( $this, 'twae_load_textdomain' ) );
		
		add_action( 'plugins_loaded', array( $this, 'twae_load_addon' ) );

		add_action( 'plugins_loaded', array( $this, 'twae_pro_load_dependency' ) );
		if ( is_admin() ) {
			// Only one plugin must be active at a time
			add_action( 'admin_init', array( $this, 'twae_pro_is_free_version_active' ) );
			add_action( 'admin_init', array( $this, 'twae_show_upgrade_notice' ) );
			add_action('admin_init', array($this,'twae_form_plugin_notice'));
		}
		 $this->cpfm_load_file();
		 
		 // Check and create cron job if user has opted in
		 add_action( 'init', array( $this, 'twae_check_and_create_cron_job' ) );

	}	
	
    public function twae_plugin_redirection($plugin){
        if ( $plugin == TWAE_PRO_PLUGIN_BASENAME ) {
			exit( wp_safe_redirect( admin_url( 'admin.php?page=timeline-addons-license' ) ) );
		}
    }

	public function cpfm_load_file(){
		
		require_once TWAE_PRO_PATH . '/admin/license-helper/license-helper.php';
        if(!class_exists('CPFM_Feedback_Notice')){
                require_once __DIR__ . '/admin/cpfm-feedback-notice.php';
            }
        require_once __DIR__ . '/includes/cron/class-cron.php';

		add_action('cpfm_register_notice', function () {
            
			if (!class_exists('CPFM_Feedback_Notice') || !current_user_can('manage_options')) {
				return;
			}

			$notice = [

				'title' => __('Timeline Plugins by Cool Plugins', 'twae'),
				'message' => __('Help us make this plugin more compatible with your site by sharing non-sensitive site data.', 'cool-plugins-feedback'),
				'pages' => ['cool-plugins-timeline-addon'],
				'always_show_on' => ['cool-plugins-timeline-addon'], // This enables auto-show
				'plugin_name'=>'twae_pro'
			];

			CPFM_Feedback_Notice::cpfm_register_notice('cool-timeline', $notice);

				if (!isset($GLOBALS['cool_plugins_feedback'])) {
					$GLOBALS['cool_plugins_feedback'] = [];
				}
			
				$GLOBALS['cool_plugins_feedback']['cool-timeline'][] = $notice;
	   
		});
		add_action('cpfm_after_opt_in_twae_pro', function($category) {

			if ($category === 'cool-timeline') {
             
				TWAE_cronjob::twae_send_data();
				
				// Create cron job when user opts in
				if (!wp_next_scheduled('twae_extra_data_update')) {
					wp_schedule_event(time(), 'every_30_days', 'twae_extra_data_update');
				}
				
				// $options = get_option('openexchange-api-settings', []);
				// $options['ccpw_extra_info'] = true;
				// update_option('openexchange-api-settings', $options);
			}
		});
    }

	/**
	 * Load the addon.
	 */
	function twae_load_addon() {
		// Load plugin file
		require_once TWAE_PRO_PATH . '/includes/class-twae-pro-main.php';
		// Run the plugin
		TWAE_PRO_Main::instance();

	}

	/**
	 * Load essential file(s) required for the plugin in any/all cases.
	 */
	function twae_pro_load_dependency() {
		if ( is_admin() ) {
			require_once TWAE_PRO_PATH . 'admin/registration-settings.php';
			require_once TWAE_PRO_PATH . '/admin/init-api.php';
			require_once TWAE_PRO_PATH . '/admin/admin-notices.php';
			require_once TWAE_PRO_PATH . '/admin/timeline-addon-page/timeline-addon-page.php';
			cool_plugins_timeline_addons_settings_page( 'timeline', 'cool-plugins-timeline-addon', 'Timeline Addons', 'Timeline Addons', esc_url( TWAE_PRO_URL . 'assets/images/timeline-icon-222.png' ) ); // Escape URL
		}
	}

	/**
	 * Deactivate the free version if the pro version is activated.
	 *
	 * @access public
	 */
	public function twae_pro_is_free_version_active() {
		if ( is_plugin_active( 'timeline-widget-addon-for-elementor/timeline-widget-addon-for-elementor.php' ) ) {
			twae_pro_create_admin_notice(
				array(
					'id'      => 'twae-free-deactivate',
					'message' => __(
						'<strong>Timeline Widget</strong> free version has been <strong>deactivated</strong> as you are using <strong>Timeline Widget Pro for Elementor</strong>.',
						'twae'
					),
				)
			);
			deactivate_plugins( 'timeline-widget-addon-for-elementor/timeline-widget-addon-for-elementor.php' );
		}
	}


	/**
	 * Load the Elementor test addon.
	 *
	 * This function loads the Elementor test addon by requiring the plugin file and running the plugin.
	 */
	public function elementor_test_addon() {
		// Load plugin file
		require_once __DIR__ . '/includes/plugin.php';

		// Run the plugin
		\Timeline_Widget_Addon\Plugin::instance();

	}

	/**
	 * Run when all other plugins are loaded.
	 *
	 * This function checks if Elementor is active and displays a notice if it is not.
	 */
	public function twae_pro_is_plugin_loaded() {
		if ( is_admin() ) {

			// Display notice if Elementor is not active.
			if ( ! did_action( 'elementor/loaded' ) ) {
				add_action( 'admin_notices', array( $this, 'twae_fail_to_load' ) );
				return;
			}

			/*** Plugin review notice file */
			require_once TWAE_PRO_PATH . '/admin/admin-notices.php';
			twae_pro_create_admin_notice(
				array(
					'id'              => 'twae_pro_review_box',  // Unique identifier for the review notice.
					'slug'            => 'twae',      // Slug for the review notice.
					'review'          => true,     // Set to true to display the review notice.
					'review_url'      => 'https://wordpress.org/support/plugin/timeline-widget-addon-for-elementor/reviews/#new-post', // URL for the review notice.
					'plugin_name'     => 'Timeline Widget Pro For Elementor',    // Name of the plugin for the review notice.
					'review_interval' => 3,                    // Optional: Number of days before displaying the review notice after the installation_time (default is 3).
				)
			); // End of twae_pro_create_admin_notice;

		}

		// Require the main plugin file.
		require_once TWAE_PRO_PATH . '/includes/twae-functions.php';
		// require_once TWAE_PRO_PATH . '/admin/twae-copy-paste/ixporter.php'.
		require_once TWAE_PRO_PATH . '/includes/class-twae-load-more-handler.php';



			


	}   // end of ctla_loaded()

	/**
	 * Load the text domain for the plugin.
	 */
	public function twae_load_textdomain() {
		load_plugin_textdomain( 'twae', false, basename( dirname( __FILE__ ) ) . '/languages/' );
		if (!get_option( 'twae_pro_initial_save_version' ) ) {
                add_option( 'twae_pro_initial_save_version', TWAE_PRO_VERSION );
            }
            if(!get_option( 'twae-pro-install-date' ) ) {
                add_option( 'twae-pro-install-date', gmdate('Y-m-d h:i:s') );
            }
	}


	/**
	 * Display a notice if Elementor is not active.
	 */
	public function twae_fail_to_load() {
		// Check if Elementor plugin is active
		if ( ! is_plugin_active( 'elementor/elementor.php' ) ) : ?>
			<div class="notice notice-warning is-dismissible">
				<p><?php echo sprintf( __( 'You must install and activate <a href="%s" target="_blank" >Elementor Website Builder</a> to use "<strong>Timeline Widget Pro For Elementor</strong>".' ), esc_url( 'https://wordpress.org/plugins/elementor/' ) ); ?></p> <!-- Escape URL -->
			</div>
			<?php
			deactivate_plugins( 'timeline-widget-addon-for-elementor-pro/timeline-widget-addon-pro-for-elementor.php' );
		endif;
	}

	/**
	 * Display an upgrade notice if the 'twae-v' option is set.
	 */
	public function twae_show_upgrade_notice() {
		if ( get_option( 'twae-v' ) != false ) {
			twae_pro_create_admin_notice(
				array(
					'id'      => 'twae-upgrade-noticesdfdsf',
					'message' => '<strong>Major Update Notice!</strong> Please update your timeline widget settings if you face any style issue after an update of <strong>Timeline Widget Pro for Elementor</strong>.',
				)
			);
		}
	}

	public function twae_form_plugin_notice() {
		require_once TWAE_PRO_PATH . '/admin/form-plugin-notice.php';

		if(class_exists('twae_pro_form_plugin_notice')){
			twae_pro_form_plugin_notice::instance('cool-form-free','Using the <strong>Elementor Form widget</strong>? Make your forms smarter with <strong>Cool FormKit</strong>! Add advanced features like conditional fields, range sliders, calculator fields, country code selectors, and more.<br><a href="'.esc_url('https://coolplugins.net/cool-formkit-for-elementor-forms/?utm_source=twae_pro_plugin&utm_medium=inside&utm_campaign=plugins_list&utm_content=get-pro').'" class="button button-primary" style="margin-right: 10px; margin-top: 10px;" target="_blank">Get Plugin</a>',5);
		}
	}

	/**
	 * Run when the plugin is activated.
	 *
	 * Update plugin options on activation.
	 */
	public static function twae_pro_activate() {
		update_option( 'twae-type', 'PRO' );  // Set plugin type to 'PRO'.
		update_option( 'twae_activation_time', gmdate( 'Y-m-d h:i:s' ) );  // Set activation time to current UTC time.
		
	    update_option( 'twae-installDate', date( 'Y-m-d h:i:s' ) );
        update_option( 'twae-pro-v', TWAE_PRO_VERSION );  // Set plugin version option.
	
		if (!get_option( 'twae_pro_initial_save_version' ) ) {
			add_option( 'twae_pro_initial_save_version', TWAE_PRO_VERSION );
		}

		if(!get_option( 'twae-pro-install-date' ) ) {
			add_option( 'twae-pro-install-date', gmdate('Y-m-d h:i:s') );
		}
		$review_option = get_option( 'cpfm_opt_in_choice_cool-timeline' );
		if($review_option === 'yes'){

			if (!wp_next_scheduled('twae_extra_data_update')) {
	
				wp_schedule_event(time(), 'every_30_days', 'twae_extra_data_update');
	
			}
	}
	}

	/**
	 * Run when the plugin is deactivated.
	 */
	public static function twae_pro_deactivate() {
		if (wp_next_scheduled('twae_extra_data_update')) {
			wp_clear_scheduled_hook('twae_extra_data_update');
		}
	}

	/**
	 * Check and create cron job if user has opted in
	 */
	public function twae_check_and_create_cron_job() {
		$review_option = get_option( 'cpfm_opt_in_choice_cool-timeline' );
		if($review_option === 'yes'){
			if (!wp_next_scheduled('twae_extra_data_update')) {
				wp_schedule_event(time(), 'every_30_days', 'twae_extra_data_update');
			}
		}
	}

}
// function enqueue_twitter_widget_script() {
// 	wp_enqueue_script(
// 		'twitter-widgets',
// 		'https://platform.twitter.com/widgets.js',
// 		array(),
// 		null,
// 		true
// 	);
// }
// add_action('wp_enqueue_scripts', 'enqueue_twitter_widget_script');

/**
 * Get the instance of the Timeline Widget Pro Addon.
 *
 * @return Timeline_Widget_Pro_Addon The instance of the Timeline Widget Pro Addon.
 */
function timeline_widget_pro_addon() {
	return Timeline_Widget_Pro_Addon::get_instance();
}

$GLOBALS['Timeline_Widget_Pro_Addon'] = Timeline_Widget_Pro_Addon();



