<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


$widget_id = $this->get_id();
$data     = isset($settings['twae_list']) ? $settings['twae_list'] : [];
$count_item          = 1;
$multicolor          = 1; // set multicolor position.
$html                = '';


$twae_bg_type = 'twae-bg-simple'; // Default value
if (isset($settings['twae_cbox_background_type'])) {
    switch ($settings['twae_cbox_background_type']) {
        case 'multicolor':
            $twae_bg_type = 'twae-bg-multicolor';
            break;
        case 'gradient':
            $twae_bg_type = 'twae-bg-gradient';
            break;
    }
}
if (isset($settings['twae_cbox_background_type_hover']) && $settings['twae_cbox_background_type_hover'] == 'simple') {
    $twae_bg_hover = 'twae-bg-hover';
} else {
    $twae_bg_hover = '';
}


if ( isset( $settings['navigation_control_icon_modern_vertical'] ) ) {
	$control_icon    = sanitize_text_field( $settings['navigation_control_icon_modern_vertical'] );
	$navi_up_icon    = Twae_Functions::get_navi_control_icon( $control_icon );
	$navi_down_icon  = Twae_Functions::get_navi_control_icon( $control_icon, 'down' );
} else {
	$navi_up_icon    = Twae_Functions::get_navi_control_icon( 'fas fa-chevron-up' );
	$navi_down_icon  = Twae_Functions::get_navi_control_icon( 'fas fa-chevron-down' );
}
$line_filling        = isset( $settings['center_line_filling'] ) && 'yes' === $settings['center_line_filling'] ? 'on' : '';
$image_lightbox     = isset($settings['twae_lightbox_settings']) && 'yes' !== $settings['twae_content_in_popup'] ? sanitize_text_field($settings['twae_lightbox_settings']) : '';
$image_hover_effect = isset($settings['twae_image_hover_effect']) && 'yes' !== $settings['twae_content_in_popup'] ? sanitize_text_field($settings['twae_image_hover_effect']) : '';

$enable_navigation = isset($settings['twae_navigation_bar_modern_vertical']) && $settings['twae_navigation_bar_modern_vertical'] === 'yes';

$loop_scroll = isset($settings['enable_tab_loop']) && $settings['enable_tab_loop'] === 'yes' ? 'true' : 'false';
$this->add_render_attribute(
    'twae-wrapper',
    array(
        'id'    => 'twae-wrapper-' . esc_attr($widget_id),
        'class' => array(
            'twae-modern-vertical-timeline',
            'twae-wrapper',
            esc_attr($timeline_layout_wrapper),
            (isset($settings['twae_line_border']) && $settings['twae_line_border'] !== 'yes') ? 'twae-border-disabled' : '',
            esc_attr($twae_bg_hover),
            esc_attr($twae_bg_type),

        ),
        'data-line-fill' => esc_attr($line_filling),

    )
);




$twae_loop_obj = new Twae_Story_Loop($settings);


$html .= '<!-- ========= Timeline Widget Pro For Elementor ' . esc_html(TWAE_PRO_VERSION) . ' ========= -->';
$html .= '<div ' . $this->get_render_attribute_string('twae-wrapper') . '>';
$html .= '<div class="twae-modern-vertical-timeline-tab-container">';
$html .= '<div class="twae-modern-vertical-timeline-tab-menu" id="tab-menu-' . esc_attr($widget_id) . '">';
$html .= '<div class="twae-modern-year">';
if ($enable_navigation) {
    $html .= '<div class="twae-modern-yearSec"><span><select id="twaeyearSelect"></select></span></div>';
}
$html .= '<div class="twae-modern-vertical-timeline-story-scroll-btns">';
$html .= '<div id="twaescrollUp">';
$html .= $navi_up_icon;
$html .= '</div>';

$html .= '<div id="twaescrollDown">';
$html .= $navi_down_icon;
$html .= '</div>';


$html .= '</div>';
$html .= ' </div>';
$html .= '<div class="twae-modern-vertical-timeline-tab-btn-wrapper" 
	id="tabBtnWrapper-' . esc_attr($widget_id) . '" 
	data-loop-scroll="' . esc_attr($loop_scroll) . '">';
$html .= '<div class="twae-modern-vertical-timeline-line twae-line twae-timeline" id="timelineLine-' . esc_attr($widget_id) . '">';
if ( 'on' === $line_filling ) {
    $html .= '<div class="twae-inner-line"></div>';
}$html .= '</div>';

$btn_html = '';
$story_html = '';
$multicolor = 1;
foreach ($data as $index => $content) {

    $story_settings  = Twae_Functions::twae_story_content_variables($content);
    $title_key       = $this->get_repeater_setting_key('twae_story_title', 'twae_list', $index);
    $year_key        = $this->get_repeater_setting_key('twae_year', 'twae_list', $index);
    $date_label_key  = $this->get_repeater_setting_key('twae_date_label', 'twae_list', $index);
    $sub_label_key   = $this->get_repeater_setting_key('twae_extra_label', 'twae_list', $index);
    $description_key = $this->get_repeater_setting_key('twae_description', 'twae_list', $index);


    $article_key = 'twae-article-' . esc_attr($content['_id']);
    $article_key_btn = 'twae-article-button' . esc_attr($content['_id']);


    $this->add_render_attribute($title_key, array('class' => 'twae-title twae-inline-editable'));
    $this->add_render_attribute($year_key, array('class' => 'twae-year-label twae-year-text'));
    $this->add_render_attribute($date_label_key, array('class' => 'twae-label-big'));
    $this->add_render_attribute($sub_label_key, array('class' => 'twae-label-small'));
    $this->add_render_attribute($description_key, array('class' => 'twae-description twae-inline-editable'));
    $this->add_inline_editing_attributes( $title_key, 'none' );
         $this->add_inline_editing_attributes( $description_key, 'none' );

    $twae_repeater_attributes[$title_key]       = $this->get_render_attribute_string($title_key);
    $twae_repeater_attributes[$year_key]        = $this->get_render_attribute_string($year_key);
    $twae_repeater_attributes[$date_label_key]  = $this->get_render_attribute_string($date_label_key);
    $twae_repeater_attributes[$sub_label_key]   = $this->get_render_attribute_string($sub_label_key);
    $twae_repeater_attributes[$description_key] = $this->get_render_attribute_string($description_key);

    $repeater_key                   = array();
    $repeater_key['title_key']      = $title_key;
    $repeater_key['year_key']       = $year_key;
    $repeater_key['date_label_key'] = $date_label_key;
    $repeater_key['sublabel_key']   = $sub_label_key;
    $repeater_key['desc_key']       = $description_key;

    $repeator_item_key = 'elementor-repeater-item-' . esc_attr($content['_id']);


    $twae_loop_obj->twae_story_loop($content, $story_settings, $repeater_key, $twae_repeater_attributes, $enable_popup);
    $media = Twae_Functions::twae_get_story_media($content, $dir, $image_lightbox, $image_hover_effect);

    $icon_data = $twae_loop_obj->twae_story_icon();
    $icon_cls  = $icon_data['icon_cls'];
    $icon_html = $icon_data['icon_html'];

    $article_key_attr = array(
        'id'    => 'tab-' . esc_attr($index),
        'class' => array(
            'twae-modern-vertical-timeline-tab-content',
            'twae-content ',
            esc_attr($repeator_item_key),
            'twae-repeater-item',
        ),
         'data-tab-index' => $index, 
    );


    if ($index === 0) {
        $article_key_attr['class'][] = 'active';
    }
    $year = isset($content['twae_year']) ? esc_attr($content['twae_year']) : '';
    $article_key_attr_button = array(
        'id'    => 'tab-' . esc_attr($index),
        'class' => array(
            'twae-modern-vertical-timeline-tab-btn',
            'twae-story',
            esc_attr($repeator_item_key),
            'twae-repeater-item',
        ),
        'data-year' => $year,
        'data-tab' => esc_attr($index)
    );
    if ($index === 0) {
        $article_key_attr_button['class'][] = 'active';
    }


    ! empty($icon_cls) && array_push($article_key_attr['class'], esc_attr($icon_cls));

    if ('twae-bg-multicolor' === $twae_bg_type) {
        $article_key_attr['data-multicolor'] = esc_attr($multicolor);
    }

    $this->add_render_attribute(
        $article_key,
        $article_key_attr
    );
    // run code only for old users.
    if (false !== get_option('twae-v')) {
        $post_id = $post->ID;
        if (! get_post_meta($post_id, 'twae_style_migration', true)) {
            $story_styles .= $this->specific_story_style($post_id, $content, $repeator_item_key, $timeline_style);
        }
    }

    $title_html       = $twae_loop_obj->twae_story_title('');
    $description_html = $twae_loop_obj->twae_story_desc();
    $date_label = !empty($content['twae_date_label']) ? $content['twae_date_label'] : '';
    $sub_label = !empty($content['twae_extra_label']) ? $content['twae_extra_label'] : 'Sub Label';


    $this->add_render_attribute(
        $article_key_btn,
        $article_key_attr_button
    );


    $dot_classes = 'dot twae-icon';
    if ($index === 0) {
        $dot_classes .= ' active-dot';
    }

    $btn_html .= '<button ' . $this->get_render_attribute_string($article_key_btn) . '>';
    $btn_html .= '  <div class="' . $dot_classes . '">' . $icon_html . '</div>';

    $btn_html .= '<div class="twae-modern-labels">';
    $btn_html .= ' <div class="twae-modern-date twae-label-big">' . esc_html($date_label) . '</div>';
    $btn_html .= '<div class="twae-modern-subtitle twae-label-small">' . esc_html($sub_label) . '</div>';
    $btn_html .= '</div>';
    $btn_html .= '</button>';

    $btn_html .= '<div ' . $this->get_render_attribute_string($article_key) . '>';
    if (!empty($media)) {
        $btn_html .= $media;
    }

    $btn_html .= ($title_html);
    $btn_html .= $description_html;
    $btn_html .= '</div>';

    $story_styles .= $twae_loop_obj->twae_story_custom_color($widget_id, true, $multicolor);
    4 === $multicolor ? $multicolor = 1 : $multicolor++;

    $count_item++;
}
$story_styles .= $twae_loop_obj->twae_story_custom_color($widget_id, false);
$html .= $btn_html;
$html .= '</div>';
$html .= '</div>';



$story_html .= '<div class="twae-modern-vertical-timeline-tab-content-box "></div>';
$html .= $story_html;
$html  .= '</div>';
$html  .= '</div>';


echo $html;
