<?php

$data = $settings['cps_icon_list'];
$preset = ''; 
$pswfe_animation = ''; 
$has_arrow = ''; 
$has_gap = ''; 

echo '<!-- ========= Process Steps Widget For Elementor ' . esc_html( TWAE_PRO_VERSION ) . ' ========= -->';

if ( $settings['cps_process_layout'] == 'Horizontal' ) {
	$preset             = $settings['twae_preset_hr_style'];
	$pswfe_steps_layout = 'pswfe-steps';
} elseif( $settings['cps_process_layout'] == 'new_design' ){

	$pswfe_steps_layout = 'pswfe-steps-accoridion';
}

else {
	$preset             = $settings['twae_preset_vertical_style'];
	$pswfe_steps_layout = 'pswfe-vertical-steps';
}

if($settings['cps_process_layout'] == 'new_design' ){
    echo "<div class='cps-show-events'>
            <div class='cps-left'>";
}

echo '<ul class="' . esc_attr( $pswfe_steps_layout ) . ' pswfe-process ' . esc_attr($preset).'">';
if ( is_array( $data ) ) {
	if ( $layout == 'Horizontal' ) {
		$has_arrow  = ( $settings['cps_enable_connector'] == 'cps-connector-arrow' ) ? 'pswfe-has-arrow' : '';
		$has_gap    = ( $settings['cps_show_gap'] === 'yes' ) ? 'pswfe-has-gap' : '';
		$icon_badge = isset( $settings['cps_selected_badge'] ) ? $settings['cps_selected_badge'] : '1';

	} elseif($layout == 'new_design'){
		// $has_arrow  = ( $settings['cps_enable_connector'] == 'cps-connector-arrow' ) ? 'pswfe-accordion-has-arrow' : '';
		// $has_gap    = ( $settings['cps_show_gap'] === 'yes' ) ? 'pswfe-accordion-has-gap' : '';
		$icon_badge = isset( $settings['cps_selected_badge'] ) ? $settings['cps_selected_badge'] : '1';

	}
	else {
		$has_arrow  = ( $settings['cps_enable_connector'] == 'cps-connector-arrow' ) ? 'pswfe-vertical-has-arrow' : '';
		$has_gap    = ( $settings['cps_show_gap'] === 'yes' ) ? 'pswfe-vertical-has-gap' : '';
		$icon_badge = isset( $settings['cps_selected_badge'] ) ? $settings['cps_selected_badge'] : '1';
	}
}//close array if condition

foreach ( $data as $key => $item ) {
	$activecls = '';
	$cp_selected='';
	$open_new_tab = '_self';
	if ( ! empty( $item['cps_website_link']['url'] ) && $item['cps_website_link']['is_external'] == 'on' ) {
		$open_new_tab = '_blank';
	}

	$icon_type  = isset( $item['cps_selected_icon'] ) ? $item['cps_selected_icon'] : 'icon';
	$title_link = ( $item['cps_enable_link'] === 'yes' && ! empty( $item['cps_website_link']['url'] ) ) ? '<a href="' . esc_url( $item['cps_website_link']['url'] ) . '" target="' . esc_attr( $open_new_tab ) . '">' . wp_kses_post( $item['cps_title'] ) . '</a>' : wp_kses_post( $item['cps_title'] );

	$title_key       = $this->get_repeater_setting_key( 'cps_title', 'cps_icon_list', $key );
	$description_key = $this->get_repeater_setting_key( 'cps_description', 'cps_icon_list', $key );

	// inline attributes
	$this->add_inline_editing_attributes( $title_key, 'none' );
	$this->add_inline_editing_attributes( $description_key, 'advanced' );

	if ( $layout == 'Horizontal' ) {
		$psefe_title_var         = array( 'pswfe-title' );
		$pswfe_description_var   = array( 'pswfe-content-desc' );
		$pswfe_step_segment      = 'pswfe-steps-segment ';
		$pswfe_badge             = 'pswfe-badge ';
		$pswfe_step_marker       = 'pswfe-steps-marker ';
		$pswfe_step_marker_text  = 'pswfe-marker-text ';
		$pswfe_step_marker_image = 'pswfe-marker-image ';
		$pswfe_step_content      = 'pswfe-steps-content';
		$pswfe_animation         = ' pswfe-animation ';

	} else if( $layout == 'new_design') {
		$psefe_title_var         = array( 'pswfe-accordion-title ' );
		$pswfe_description_var   = array( 'pswfe-vertical-content-desc ' );
		$pswfe_step_segment      = 'cps-accordion ';
		$pswfe_badge             = 'pswfe-badge-tab-design ';
		$pswfe_step_marker       = 'cps-icon_div ';
		$pswfe_step_marker_text  = 'pswfe-accordion-marker-text ';
		$pswfe_step_marker_image = 'pswfe-accordion-image';
		$pswfe_step_content      = 'cps-process-details ' ;
		$activecls = 0 === $key ? ' active' : $activecls;
		$cp_selected = 0 === $key ? ' cps-selected' : $cp_selected;

	}else{
		$psefe_title_var         = array( 'pswfe-vertical-title' );
		$pswfe_description_var   = array( 'pswfe-vertical-content-desc' );
		$pswfe_step_segment      = 'pswfe-vertical-steps-segment';
		$pswfe_badge             = 'pswfe-vertical-badge';
		$pswfe_step_marker       = 'pswfe-vertical-steps-marker';
		$pswfe_step_marker_text  = 'pswfe-vertical-marker-text ';
		$pswfe_step_marker_image = 'pswfe-vertical-marker-image ';
		$pswfe_step_content      = 'pswfe-vertical-steps-content';
		$pswfe_animation         = ' pswfe-animation ';

	}
	

	// class for title and description
	$this->add_render_attribute( $title_key, array( 'class' => $psefe_title_var ) );
	$this->add_render_attribute( $description_key, array( 'class' => $pswfe_description_var ) );
	echo '<li class="' . esc_attr( $pswfe_step_segment ) .   $pswfe_animation .' elementor-repeater-item-' . esc_attr( $item['_id'] ) . ' ' . esc_attr( $has_arrow ) . ' ' . esc_attr( $has_gap) . esc_attr($activecls). esc_attr($cp_selected).' ">';

	echo '<div class="' . esc_attr( $pswfe_step_marker ) . '">';

	if ( $icon_type == 'icon' ) {
		echo '<span class="' . esc_attr( $pswfe_step_marker_text ) . '">';
		\Elementor\Icons_Manager::render_icon( $item['cps_story_icon'], array( 'aria-hidden' => 'true' ) );
		echo '</span>';
	} elseif ( $icon_type == 'image' ) {
		if ( ! empty( $item['cps_icon_image']['url'] ) ) {
			echo '<img src="' . esc_url( $item['cps_icon_image']['url'] ) . '" class="' . esc_attr( $pswfe_step_marker_image ) . '">';
		}
	} else {
		if ( $icon_type == 'customtext' ) {
			echo '<span class="' . esc_attr( $pswfe_step_marker_text ) . '">' . wp_kses_post( $item['cps_icon_text'] ) . '</span>';
		}
	}
if($layout !== 'new_design'){


	if ( $icon_badge == 'badge-customtext' ) {
		if ( isset( $item['cps_badge'] ) && ! empty( $item['cps_badge'] ) ) {
			$steps = ( strlen( $item['cps_badge'] ) > '2' ) ? 'steps' : '';
			echo '<span class="' . esc_attr( $pswfe_badge ) . ' ' . esc_attr( $steps ) . ' ' . esc_attr( $settings['cps_badge_position'] ) . '">' . wp_kses_post( $item['cps_badge'] ) . '</span>';
		}
	} else {
		echo '<span></span>';
	}
}

	echo '<div class="pswfe-hover-animation ' . esc_attr( $settings['cps_hover_animation'] ) . '"></div>';
	echo '</div>';

	if ( ! empty( $item['cps_title'] ) || ! empty( $item['cps_description'] ) ) {
		echo '<div class="' . esc_attr( $pswfe_step_content ) . '">';
		if($layout == 'new_design'){


			if ( $icon_badge == 'badge-customtext' ) {
				if ( isset( $item['cps_badge'] ) && ! empty( $item['cps_badge'] ) ) {
					$steps = ( strlen( $item['cps_badge'] ) > '2' ) ? 'steps' : '';
					echo '<div class="cps-badge"><span class="' . esc_attr( $pswfe_badge ) . ' ' . esc_attr( $steps ) . ' ' . esc_attr( $settings['cps_badge_position'] ) . '">' . wp_kses_post( $item['cps_badge'] ) . '</span></div>';
				}
			} else {
				echo '<span></span>';
			}
		}
		

		echo '<div ' . $this->get_render_attribute_string( $title_key ) . '>' . wp_kses_post( $title_link ) . '</div>';
		if($layout == 'new_design'){
           echo"<div class='cps-footer'>";
		}
		echo '<div ' . $this->get_render_attribute_string( $description_key ) . '>' . wp_kses_post( $item['cps_description'] ) . '</div>';
		if($layout == 'new_design'){
        echo"<div class='cps_mobile_image'>";

		if ( ! empty( $item['cps_accordion_image']['url'] ) ) {
									echo '<div class="cps-img"><img src="' . esc_url( $item['cps_accordion_image']['url'] ) . '" class="' . esc_attr( $pswfe_step_marker_image ) . '"></div>';
								}     
		echo"</div>
		
		
		
		</div>";
		 }

		echo '</div>';
	}
	if($layout == 'new_design'){
		echo" <svg xmlns='http://www.w3.org/2000/svg' class='cps-icon-arrow-up' aria-hidden='true' width='16' height='1' viewBox='0 0 320 512' fill='currentColor'>
  <path d='M143 352.3V32c0-17.7 14.3-32 32-32s32 14.3 32 32v320.3l119-119c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-176 176c-12.5 12.5-32.8 12.5-45.3 0l-176-176c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l119 119z'/>
</svg>"

;
	}
	echo '</li>';
}
echo '</ul>';
if($settings['cps_process_layout'] == 'new_design'){

	echo"</div>

	<div class='cps-right cps_desktop_img'>";
                    
					foreach($data as $key => $item){

						if ( ! empty( $item['cps_accordion_image']['url'] ) ) {
							echo '<div class="cps-img"><img src="' . esc_url( $item['cps_accordion_image']['url'] ) . '" class="' . esc_attr( $pswfe_step_marker_image ) . '"></div>';
						}     
					}
    echo"</div>


</div>";
}
