class ProcessStepsClass extends elementorModules.frontend.handlers.Base {


    bindEvents() {

        this.animationTimeoutId;
        this.updateImageVisibility()
        this.StepClickEvents();
        this.runAnimation();
        jQuery(window).on('resize', () => {
            this.updateImageVisibility();
        });
    }

    stopAnimation() {
        clearTimeout(this.animationTimeoutId);
    }

    updateImageVisibility() {
        var x = window.matchMedia("(max-width: 433px)");
        let imagesAll;

        if (x.matches) {

            let maindiv = this.$element.find('.cps-footer .cps-right.cps_mobile_image');
            imagesAll = maindiv.find('.cps-img');

        } else {

            let maindivdes = this.$element.find('.cps-show-events .cps-right.cps_desktop_img');
            imagesAll = maindivdes.find('.cps-img');
        }

        imagesAll.each((i, img) => {
            img.style.display = 'none';
        });
        let currentIndex = (typeof index !== 'undefined') ? index : 0;
        const currentImage = imagesAll[currentIndex];
        if (currentImage) {
            currentImage.style.display = 'block';
        }
    }

    runAnimation(index) {
        let footerAll = this.$element.find('.cps-footer');
        var x = window.matchMedia("(max-width: 433px)");
        let imagesAll;

        if (x.matches) {
            let maindiv = this.$element.find('.cps-footer .cps-right.cps_mobile_image');
            imagesAll = maindiv.find('.cps-img');
        } else {
            let maindivdes = this.$element.find('.cps-show-events .cps-right.cps_desktop_img');
            imagesAll = maindivdes.find('.cps-img');
        }

        let currentIndex = (typeof index !== 'undefined') ? index : 0;

        if (currentIndex < footerAll.length) {

            imagesAll.each((i, img) => {
                img.style.display = 'none';
            });

            const element = footerAll[currentIndex];
            const currentImage = imagesAll[currentIndex];
            if (currentImage) {
                currentImage.style.display = 'block';
            }

            element.classList.add('animate');
            footerAll.each((i, footer) => {
                if (i === currentIndex) {
                    this.showFooter(footer);
                    const date = footer.parentElement.previousElementSibling;
                    date.classList.add('cps-selected');
                } else {
                    this.hideFooter(footer); // Hide others
                    const date = footer.parentElement.previousElementSibling;
                    date.classList.remove('cps-selected');
                }
            });

            this.animationTimeoutId = setTimeout(() => {
                currentIndex++; // Move to the next footer
                if (currentIndex >= footerAll.length) {
                    currentIndex = 0; // Loop back to the first footer
                }
                this.runAnimation(currentIndex);
            }, 5000);
        }
    }


    showFooter(footer) {
        footer.closest('.cps-accordion').classList.add('cps-selected');
        jQuery(footer).slideDown(1000, () => {
            footer.closest('.cps-accordion').classList.add('active');
        });
    }

    hideFooter(footer) {
        footer.closest('.cps-accordion').classList.remove('cps-selected');
        jQuery(footer).slideUp(1000, () => {
            footer.closest('.cps-accordion').classList.remove('active');
        });
    }

    StepClickEvents() {
        const tittleAll = this.$element.find('.cps-process-details');

        for (let i = 0; i < tittleAll.length; i++) {
            tittleAll[i].addEventListener('click', () => {
                this.stopAnimation();
                this.runAnimation(i);
            });
        }
    }
}

jQuery(window).on('elementor/frontend/init', () => {

    const addHandler = ($element) => {
        elementorFrontend.elementsHandler.addHandler(ProcessStepsClass, {
            $element,
        });
    };

    elementorFrontend.hooks.addAction('frontend/element_ready/timeline-widget-addon.default', addHandler);
    elementorFrontend.hooks.addAction('frontend/element_ready/twae-post-timeline-widget.default', addHandler);
    elementorFrontend.hooks.addAction('frontend/element_ready/timeline-process-steps-widget.default', addHandler);
});