import { stringConvention } from '../components/functions';
import { TextField, NumberField, EmailField, ConfirmEmailField, TextareaField, LabelField, SelectField, CheckboxField, RadioField, HiddenField, ScriptFieldControl, ScriptField } from '../components/fields';

var pageLoaded = false;
import './style.scss';

/**
 * Woocommerce Integration Data
 */
import { getSetting } from '@woocommerce/settings';
const checkoutData = getSetting( 'tickera/checkout-fields_data' );

const render = ( prop, fieldType ) => {

	switch ( fieldType ) {

		case 'text':
			return <TextField {...prop}/>
			break;

		case 'number':
			return <NumberField {...prop}/>
			break;

		case 'email':
			return <EmailField {...prop}/>
			break;

		case 'confirm_email':
			return <ConfirmEmailField {...prop}/>
			break;

		case 'label':
			return <LabelField {...prop}/>
			break;

		case 'checkbox':
			return <CheckboxField {...prop}/>
			break;

		case 'select':
			return <SelectField {...prop}/>
			break;

		case 'textarea':
			return <TextareaField {...prop}/>
			break;

		case 'radio':
			return <RadioField {...prop}/>
			break;

		case 'script':
			return <ScriptField {...prop} />
			break;

		case 'hidden':
		case 'error':
			return <HiddenField {...prop}/>
			break;
	}
}

/**
 * checkoutExtensionData, extensions
 *
 * @param prop
 * @returns {*[]}
 * @constructor
 */
export const Block = ( prop ) => {

	let contents = [];

	if ( document.readyState == 'complete' ) {
		pageLoaded = true;
	}

	// Buyer Fields
	contents.push(
		<div className="wp-block-checkout-buyer-fields wc-block-components-checkout-step">
			{
				(() => {

					let fields = [];
					checkoutData.buyer_fields.map( ( field ) => {

						const thisProp = { data: { prop }, field, loaded: pageLoaded, category: 'buyer' };

						if ( typeof field.form_visibility === 'undefined' || ( typeof field.form_visibility !== 'undefined' && field.form_visibility ) ) {
							fields.push( render( thisProp, field.field_type ) );

						} else {
							fields.push( render( thisProp, 'hidden' ) );
						}
					})

					return fields;
				})()
			}
		</div>
	);

	// Owner Fields
	contents.push(
		<div className="wp-block-checkout-owner-fields wc-block-components-checkout-step">
			{
				checkoutData.cart_items.map( ( item, index ) => {

					if ( checkoutData.owner_fields[item.id].length > 0 ) {

						let visible_field = false;
						checkoutData.owner_fields[ item.id ].map( function( el ) {
							if ( typeof el.form_visibility !== 'undefined' && el.form_visibility ) {
								visible_field = true;
							}
						} );

						return (
							<div className={ ! visible_field ? 'tc-hidden' : '' }>
								<h4>{ item.name }</h4>
								<div>
									{
										( () => {

											let fields = [];
											for ( let i=0; i < item.quantity; i++ ) {

												fields.push(
													<h5>
														{i + 1}. { tc_woobridge_block.attendee_info }
													</h5>
												);

												checkoutData.owner_fields[item.id].map( ( field ) => {

													const thisProp = { data: { prop }, item, field, loaded: pageLoaded, category: 'owner', i: i };

													if ( typeof field.form_visibility === 'undefined' || ( typeof field.form_visibility !== 'undefined' && field.form_visibility ) ) {
														fields.push( render( thisProp, field.field_type ) );

													} else {
														fields.push( render( thisProp, 'hidden' ) );
													}
												})
											}

											return fields;
										})()
									}
								</div>
							</div>
						)
					}
				})
			}
		</div>
	);

	// Extras
	contents.push(
		<div className="wp-block-checkout-extras-fields">
			{
				( () => {
					let fields = [];
					checkoutData.extra_fields.map( ( field ) => {
						const thisProp = { data: { prop }, field, loaded: pageLoaded };
						fields.push( render( thisProp, field.field_type ) )
					})
					return fields;
				})()
			}
		</div>
	)

	return contents;
};
