/**
 * Convert String Convention (e.g. ucfirst, lcfirst)
 * Valid convention values:
 * - ucfirst (e.g. Hello world)
 *
 * @param prop
 */
const stringConvention = ( string, convention, nospace ) => {

    nospace = typeof nospace !== 'undefined' ? nospace : false;
    convention = ( typeof convention !== 'undefined' ) ? convention : 'ucfirst';

    switch( convention ) {

        case 'ucfirst':
            return string.charAt(0).toUpperCase() + string.toLowerCase().slice(1);
            break;

        case 'ucwords':
            let ucWords = string.toLowerCase().replace(/(?<= )[^\s]|^./g, a=>a.toUpperCase());
            return nospace ? ucWords.replace( ' ', '' ) : ucWords;
            break;
    }

    return string;
}

export { stringConvention };