import { useCallback, useEffect, useState } from '@wordpress/element';
import { debounce } from "lodash";

const blockNamespace = 'tickera/checkout-fields';

export const HiddenFieldControl = ( prop ) => {

    let field = prop.field,
        category = prop.category,
        item = prop.item,
        i = prop.i;

    prop = prop.data.prop;

    /*
     * setExtensionData will update the wc/store/checkout data store with the values supplied.
     * It can be used to pass data from the client to the server when submitting the checkout form.
     */
    const { setExtensionData } = prop.checkoutExtensionData;

    /*
     * Debounce the setExtensionData function to avoid
     * multiple calls to the API when rapidly changing options.
     */
    const debouncedSetExtensionData = useCallback(
        debounce((namespace, key, value) => {
            setExtensionData(namespace, key, value);
        }, 1000),
        [setExtensionData]
    );

    if ( 'error' == field.field_type ) {
        var key = field.field_name;

    } else {

        var key = ( 'owner' == category )
            ? item.id + '_' + i + '_' + field.field_name + '_post_meta'
            : 'buyer_data_' + field.field_name + '_post_meta';
    }

    /**
     * Handles changes in fields value.
     * Exclude Label field.
     */
    let defaultValue = ( typeof field.default_value != 'undefined' ) ? field.default_value[ i ] : '';
    const [ fieldValue ] = useState( defaultValue );

    useEffect(() => {

        // Update in tickera/checkout-fields extended data
        setExtensionData( blockNamespace, key, fieldValue );

        // Ensures setExtensionData is being called one at a time.
        debouncedSetExtensionData( blockNamespace, key, fieldValue );

    }, [ setExtensionData, fieldValue ] );
}
