<?php

/**
 * Plugin Name: Tickera - Events Listing
 * Plugin URI: https://tickera.com/
 * Description: Event Listing is a nicely crafted Gutenberg block and a shortcode for that matter which lets you display events with numerous filters.
 * Author: Tickera.com
 * Author URI: https://tickera.com/
 * Version: 1.2.0

 * Update URI: https://api.freemius.com
 * TextDomain: tclist
 * Domain Path: /languages/
 * Copyright 2016 Tickera (https://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
if ( !function_exists( 'tc_event_listing_fs' ) ) {
    // Create a helper function for easy SDK access.
    function tc_event_listing_fs() {
        global $tc_event_listing_fs;
        if ( !isset( $tc_event_listing_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_5269_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_5269_MULTISITE', true );
            }
            // Include Freemius SDK.
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } else {
                if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                    // Try to load SDK from premium parent plugin folder.
                    require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
                } else {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
            }
            $tc_event_listing_fs = fs_dynamic_init( array(
                'id'              => '5269',
                'slug'            => 'tickera-events-listing',
                'type'            => 'plugin',
                'public_key'      => 'pk_d009e946e2ec9f76157854611ea87',
                'is_premium'      => true,
                'is_premium_only' => true,
                'has_paid_plans'  => true,
                'parent'          => array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                ),
                'menu'            => array(
                    'support' => false,
                ),
                'is_live'         => true,
            ) );
        }
        return $tc_event_listing_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function tc_event_listing_fs_is_parent_active_and_loaded() {
    return function_exists( 'Tickera\\tets_fs' );
}

function tc_event_listing_fs_is_parent_active() {
    $active_plugins = get_option( 'active_plugins', array() );
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function tc_event_listing_fs_init() {
    if ( tc_event_listing_fs_is_parent_active_and_loaded() ) {
        /**
         * Parent is active, add your init code here.
         * Init Freemius.
         */
        tc_event_listing_fs();
        // Signal that the add-on's SDK was initiated.
        do_action( 'tc_event_listing_fs_loaded' );
        if ( !tc_event_listing_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        /* Parent is inactive, add your error handling here. */
    }
}

if ( tc_event_listing_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    tc_event_listing_fs_init();
} elseif ( tc_event_listing_fs_is_parent_active() ) {
    // Init add-on only after the parent is loaded.
    add_action( 'tets_fs_loaded', 'tc_event_listing_fs_init' );
} else {
    // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
    tc_event_listing_fs_init();
}
if ( !class_exists( 'TC_Tickera_Events_Filtering' ) ) {
    class TC_Tickera_Events_Filtering {
        var $version = '1.1.3';

        var $title = 'Tickera Events Listing';

        var $name = 'tclist';

        var $dir_name = 'tickera-events-listing';

        var $location = 'plugins';

        var $plugin_dir = '';

        var $plugin_url = '';

        var $language;

        function __construct() {
            global $pagenow;
            $this->init_vars();
            add_action( 'activated_plugin', array($this, 'plugin_dependencies'), 99 );
            add_filter( 'tc_shortcodes', array($this, 'tc_add_events_display_shortcode_list') );
            add_filter( 'tc_gutenberg_blocks', array($this, 'modify_gutenberg_blocks_list') );
            add_shortcode( 'tc_display_events', array($this, 'tc_display_events_shortcode') );
            add_action(
                'wp_enqueue_scripts',
                array($this, 'tc_event_filter_scripts'),
                10,
                1
            );
            add_action( "wp_ajax_tc_filter_events", array($this, 'tc_filter_events') );
            add_action( "wp_ajax_nopriv_tc_filter_events", array($this, 'tc_filter_events') );
            add_action( 'init', array($this, 'tc_add_event_image_size') );
            if ( function_exists( 'register_block_type' ) && 'widgets.php' != $pagenow ) {
                add_action( 'init', array($this, 'tc_register_events_filter_gutenberg_blocks') );
                add_action( 'enqueue_block_editor_assets', array($this, 'tc_events_filter_gutenberg_scripts') );
            }
            add_action( 'admin_enqueue_scripts', array($this, 'tc_event_filter_admin_scripts') );
            require_once $this->plugin_dir . 'functions.php';
            add_action( 'init', array(&$this, 'localization'), 10 );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {
            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );
            if ( $index !== false ) {
                unset($active_plugins[$index]);
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Plugin localization function
         */
        function localization() {
            /*
             * Load up the localization file if we're using WordPress in a different language
             * Place it in this plugin's "languages" folder and name it "tc-[value in wp-config].mo"
             */
            if ( 'mu-plugins' == $this->location ) {
                load_muplugin_textdomain( 'tclist', 'languages/' );
            } elseif ( 'subfolder-plugins' == $this->location ) {
                load_plugin_textdomain( 'tclist', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
            } elseif ( 'plugins' == $this->location ) {
                load_plugin_textdomain( 'tclist', false, 'languages/' );
            }
            $temp_locales = explode( '_', get_locale() );
            $this->language = ( $temp_locales[0] ? $temp_locales[0] : 'en' );
        }

        /**
         * Setup proper directories
         */
        function init_vars() {
            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;
            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tclist' ), $this->title ) );
            }
        }

        function tc_event_filter_scripts() {
            wp_enqueue_style( 'tc-events-filter-css', $this->plugin_url . 'includes/css/event-filtering-style.css' );
            wp_enqueue_style( 'tc-multiselect', $this->plugin_url . 'includes/js/multiselect/jquery.multiselect.css' );
            wp_enqueue_style( 'tc-datepicker', $this->plugin_url . 'includes/css/datepicker.css' );
            wp_enqueue_script(
                $this->name . '-common',
                $this->plugin_url . 'includes/js/common.js',
                array('jquery'),
                '1.0.0',
                true
            );
            wp_enqueue_script( 'jquery-ui-datepicker' );
            wp_localize_script( $this->name . '-common', 'tc_values', array(
                'ajaxurl'     => admin_url( 'admin-ajax.php' ),
                'date_format' => apply_filters( 'tc_ef_datepicker_format', get_option( 'date_format' ) ),
            ) );
            wp_enqueue_script(
                $this->name . '-multiselect',
                $this->plugin_url . 'includes/js/multiselect/jquery.multiselect.js',
                array('jquery'),
                '1.1.2',
                true
            );
            wp_localize_script( $this->name . '-multiselect', 'tclist__', array(
                'tclist_select_options' => __( 'Select options', 'tclist' ),
                'tclist_search'         => __( 'Search', 'tclist' ),
                'tclist_selected'       => __( ' selected', 'tclist' ),
                'tclist_select_all'     => __( 'Select all', 'tclist' ),
                'tclist_unselect_all'   => __( 'Unselect all', 'tclist' ),
                'tclist_none_selected'  => __( 'None Selected', 'tclist' ),
            ) );
        }

        /**
         * Gutenberg Section
         */
        function tc_events_filter_gutenberg_scripts() {
            global $wp_version;
            $tc_event_categories = get_terms( array(
                'taxonomy'   => 'event_category',
                'hide_empty' => false,
            ) );
            // Ticket add to cart block
            wp_register_script(
                'tc_event_filter_block_editor',
                plugins_url( 'includes/gutenberg/tc_event_filter_block_editor.js', __FILE__ ),
                array(
                    'wp-editor',
                    'wp-blocks',
                    'wp-i18n',
                    'wp-element',
                    'jquery'
                ),
                $this->version
            );
            wp_localize_script( 'tc_event_filter_block_editor', 'tc_event_filter_vals', array(
                'tc_event_categories' => json_encode( $tc_event_categories ),
                'allCategories'       => __( 'All Categories', 'tcef' ),
                'tc_event_categories' => json_encode( $tc_event_categories ),
                'since_611'           => ( version_compare( $wp_version, '6.1.1', '>=' ) ? true : false ),
            ) );
            wp_enqueue_script( 'tc_event_filter_block_editor' );
        }

        function tc_register_events_filter_gutenberg_blocks() {
            register_block_type( 'tickera/event-filters', array(
                'editor_style'    => 'tc_event_filter_block_editor',
                'render_callback' => array($this, 'render_event_filter_shortcode'),
                'attributes'      => array(
                    'tc_event_categories'            => array(
                        'type'    => 'string',
                        'default' => true,
                    ),
                    'tc_number_of_columns'           => array(
                        'type'    => 'string',
                        'default' => true,
                    ),
                    'tc_show_event_filters'          => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_categories'             => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_date_filtering'         => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_past_events'            => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_excerpt'                => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_default_featured_image' => array(
                        'type'    => 'boolean',
                        'default' => true,
                    ),
                    'tc_show_number_of_posts'        => array(
                        'type'    => 'number',
                        'default' => 10,
                    ),
                    'align'                          => array(
                        'type' => 'string',
                    ),
                    'tc_order_events_by'             => array(
                        'type'    => 'string',
                        'default' => 'asc',
                    ),
                ),
            ) );
        }

        function tc_event_filter_admin_scripts() {
            wp_enqueue_style( 'tc-events-filter-css', $this->plugin_url . 'includes/css/event-filtering-style.css' );
            wp_enqueue_style( 'tc-multiselect', $this->plugin_url . 'includes/js/multiselect/jquery.multiselect.css' );
            wp_enqueue_style( 'tc-datepicker', $this->plugin_url . 'includes/css/datepicker.css' );
            wp_enqueue_script( 'jquery-ui-datepicker' );
        }

        /**
         * Update Tickera's shortcode builder list
         *
         * @param array $shortcodes
         * @return array $shortcodes modified shortcode list
         */
        function tc_add_events_display_shortcode_list( $shortcodes ) {
            $shortcodes['tc_display_events'] = __( 'Events Listing', 'tclist' );
            return $shortcodes;
        }

        /**
         * Update Tickera's gutenberg blocks list
         *
         * @param $blocks
         * @return mixed
         *
         * @since 1.1.5
         */
        function modify_gutenberg_blocks_list( $blocks ) {
            $blocks['tc_display_events'] = 'tickera/event-filters';
            return $blocks;
        }

        function render_event_filter_shortcode( $atts ) {
            return tc_render_events_filter( $atts );
        }

        /**
         * @param type $atts
         * @return type
         */
        function tc_display_events_shortcode( $atts ) {
            ob_start();
            extract( shortcode_atts( array(
                'tc_event_categories'            => 'all_categories',
                'tc_number_of_columns'           => 1,
                'tc_show_event_filters'          => true,
                'tc_show_categories'             => true,
                'tc_show_date_filtering'         => true,
                'tc_show_venue_filtering'        => true,
                'tc_show_past_events'            => true,
                'tc_show_excerpt'                => true,
                'tc_show_number_of_posts'        => 10,
                'tc_show_default_featured_image' => true,
                'align'                          => '',
                'tc_order_events_by'             => 'asc',
            ), $atts ) );
            $tc_events_class = tc_class_switch( $tc_number_of_columns );
            $width_values = [
                'wide' => 'alignwide',
                'full' => 'alignfull',
            ];
            if ( 'all_events' == $tc_event_categories ) {
                $tc_event_categories_terms = get_terms( array(
                    'taxonomy'   => 'event_category',
                    'hide_empty' => false,
                ) );
            } else {
                $tc_include_categories = get_term_children( $tc_event_categories, 'event_category' );
                if ( empty( $tc_include_categories ) ) {
                    $tc_include_categories = $tc_event_categories;
                }
                $tc_event_categories_terms = get_terms( array(
                    'taxonomy'   => 'event_category',
                    'hide_empty' => false,
                    'include'    => $tc_include_categories,
                ) );
            }
            apply_filters( 'custom_log_file', $align );
            ?>
            <div class="tc-event-listing-container<?php 
            echo ( isset( $width_values[$align] ) ? ' ' . $width_values[$align] : '' );
            ?>">
            <input type="hidden" name="tc_event_categories" id="tc_event_categories" value="<?php 
            echo (int) $tc_event_categories;
            ?>"/>
            <input type="hidden" name="tc_number_of_columns" id="tc_number_of_columns" value="<?php 
            echo (int) $tc_number_of_columns;
            ?>"/>
            <input type="hidden" name="tc_show_past_events" id="tc_show_past_events" value="<?php 
            echo esc_attr( $tc_show_past_events );
            ?>"/>
            <input type="hidden" name="tc_show_excerpt" id="tc_show_excerpt" value="<?php 
            echo esc_attr( $tc_show_excerpt );
            ?>"/>
            <input type="hidden" name="tc_show_default_featured_image" id="tc_show_default_featured_image" value="<?php 
            echo esc_attr( $tc_show_default_featured_image );
            ?>"/>
            <input type="hidden" name="tc_show_number_of_posts" id="tc_show_number_of_posts" value="<?php 
            echo (int) $tc_show_number_of_posts;
            ?>"/>
            <input type="hidden" name="tc_order_events_by" id="tc_order_events_by" value="<?php 
            echo esc_attr( $tc_order_events_by );
            ?>"/>
            <input type="hidden" name="tc_pagination_number" id="tc_pagination_number" value="1"/>
            <div class="tc-events-wrap">
                <?php 
            include plugin_dir_path( __FILE__ ) . 'templates/filters.php';
            ?>
                <!-- ajax displays posts here -->
                <div class="tc-display-filter-events"></div>
            </div><!-- .tc-events-wrap -->
            </div><?php 
            // Restore original Post Data
            wp_reset_postdata();
            return ob_get_clean();
        }

        /**
         * Filter and Render event listings in the frontend.
         */
        function tc_filter_events() {
            global $content_width;
            $tc_categories = ( isset( $_POST['tc_categories'] ) ? $_POST['tc_categories'] : null );
            if ( null == $tc_categories || '1' == $tc_categories ) {
                $tc_categories = '';
            }
            $tc_start_date = ( isset( $_POST['tc_start_date'] ) ? $_POST['tc_start_date'] : '' );
            $tc_end_date = ( isset( $_POST['tc_end_date'] ) ? $_POST['tc_end_date'] : '' );
            $tc_show_passed_events = ( isset( $_POST['tc_show_past_events'] ) ? $_POST['tc_show_past_events'] : false );
            $tc_start_date = sanitize_text_field( $tc_start_date );
            $tc_end_date = sanitize_text_field( $tc_end_date );
            $tc_show_passed_events = sanitize_text_field( $tc_show_passed_events );
            $tc_start_date = ( $tc_start_date ? date_i18n( 'Y-m-d', strtotime( __( $tc_start_date, 'tclist' ) ) ) : '' );
            $tc_end_date = ( $tc_end_date ? date_i18n( 'Y-m-d', strtotime( __( $tc_end_date, 'tclist' ) ) ) : '' );
            $tc_show_passed_events = filter_var( $tc_show_passed_events, FILTER_VALIDATE_BOOLEAN );
            $tc_date_search = [];
            if ( $tc_show_passed_events ) {
                $tc_date_search['relation'] = 'AND';
                if ( $tc_start_date ) {
                    $tc_date_search[] = array(
                        'key'     => 'event_end_date_time',
                        'value'   => $tc_start_date,
                        'compare' => '>=',
                        'type'    => 'date',
                    );
                }
                if ( $tc_end_date ) {
                    $tc_date_search[] = array(
                        'key'     => 'event_end_date_time',
                        'value'   => $tc_end_date,
                        'compare' => '<=',
                        'type'    => 'date',
                    );
                }
            } else {
                if ( !$tc_start_date && !$tc_end_date ) {
                    $tc_date_search = [[
                        'key'     => 'event_end_date_time',
                        'value'   => date_i18n( 'Y-m-d H:i' ),
                        'compare' => '>=',
                    ]];
                } elseif ( $tc_start_date && !$tc_end_date ) {
                    $tc_date_search = [[
                        'key'     => 'event_end_date_time',
                        'value'   => ( $tc_start_date > date_i18n( 'Y-m-d H:i' ) ? $tc_start_date : date_i18n( 'Y-m-d H:i' ) ),
                        'compare' => '>=',
                    ]];
                } elseif ( !$tc_start_date && $tc_end_date ) {
                    $tc_date_search = [
                        'relation' => 'AND',
                        [
                            'key'     => 'event_end_date_time',
                            'value'   => date_i18n( 'Y-m-d H:i' ),
                            'compare' => '>=',
                        ],
                        [
                            'key'     => 'event_end_date_time',
                            'value'   => $tc_end_date,
                            'compare' => '<=',
                        ],
                    ];
                } else {
                    $tc_date_search = [
                        'relation' => 'AND',
                        [
                            'key'     => 'event_end_date_time',
                            'value'   => ( $tc_start_date > date_i18n( 'Y-m-d H:i' ) ? $tc_start_date : date_i18n( 'Y-m-d H:i' ) ),
                            'compare' => '>=',
                        ],
                        [
                            'key'     => 'event_end_date_time',
                            'value'   => $tc_end_date,
                            'compare' => '<=',
                        ],
                    ];
                }
            }
            $tc_show_excerpt = ( isset( $_POST['tc_show_excerpt'] ) ? $_POST['tc_show_excerpt'] : 'false' );
            $tc_column_number = ( isset( $_POST['tc_column_number'] ) ? (int) $_POST['tc_column_number'] : '' );
            $tc_post_number = ( isset( $_POST['tc_show_number_of_posts'] ) ? (int) $_POST['tc_show_number_of_posts'] : 10 );
            $tc_pagination_number = ( isset( $_POST['tc_pagination_number'] ) && $_POST['tc_pagination_number'] ? (int) $_POST['tc_pagination_number'] : 1 );
            $tc_show_default_featured_image = ( isset( $_POST['tc_show_default_featured_image'] ) ? $_POST['tc_show_default_featured_image'] : false );
            $tc_events_class = tc_class_switch( $tc_column_number );
            $tc_selected_category_values = ( isset( $_POST['tc_selected_category_values'] ) ? $_POST['tc_selected_category_values'] : '' );
            $tc_order_events_by = ( isset( $_POST['tc_order_events_by'] ) ? sanitize_text_field( $_POST['tc_order_events_by'] ) : 'asc' );
            if ( !empty( $tc_selected_category_values ) ) {
                $tc_categories = $tc_selected_category_values;
            }
            if ( !empty( $tc_categories ) && $tc_categories !== 'all_categories' ) {
                $tc_taxonomies = apply_filters( 'tc_ef_events_tax_query', array(array(
                    'taxonomy' => 'event_category',
                    'field'    => 'term_id',
                    'terms'    => $tc_categories,
                )) );
            } else {
                $tc_taxonomies = '';
            }
            $args = apply_filters( 'tc_ef_events_query_args', array(
                'post_type'      => 'tc_events',
                'posts_per_page' => $tc_post_number,
                'order'          => strtoupper( $tc_order_events_by ),
                'post_status'    => 'publish',
                'meta_key'       => 'event_date_time',
                'orderby'        => 'meta_value',
                'meta_query'     => $tc_date_search,
                'tax_query'      => $tc_taxonomies,
                'paged'          => $tc_pagination_number,
            ) );
            // The Query
            $the_query = new WP_Query($args);
            // The Loop
            if ( $the_query->have_posts() ) {
                while ( $the_query->have_posts() ) {
                    // Change this part if you need to make any changes the way events display
                    $the_query->the_post();
                    ?>
                    <div class="tc-single-event <?php 
                    echo $tc_events_class;
                    ?>">
                        <!-- include featured image -->
                        <?php 
                    include plugin_dir_path( __FILE__ ) . 'templates/featured-image.php';
                    ?>
                        <div class="tc-event-content-wrap">
                          <!-- include the title -->
                          <?php 
                    include plugin_dir_path( __FILE__ ) . 'templates/post-title.php';
                    ?>

                          <!-- dates and location -->
                          <?php 
                    include plugin_dir_path( __FILE__ ) . 'templates/event-dates-location.php';
                    ?>

                          <!-- event excerpt -->
                          <?php 
                    include plugin_dir_path( __FILE__ ) . 'templates/event-excerpt.php';
                    ?>
                        </div>
                    </div><!-- .tc-single-event -->
                <?php 
                    do_action( 'tc_ef_after_event', get_the_ID() );
                }
            } else {
                _e( 'Sorry, no posts matched your criteria', 'tclist' );
            }
            ?>

            <div class="pagination">
                <?php 
            echo paginate_links( apply_filters(
                'tc_ef_pagination_arguments',
                [
                    'format'    => '',
                    'current'   => $tc_pagination_number,
                    'total'     => $the_query->max_num_pages,
                    'mid_size'  => 2,
                    'end_size'  => 2,
                    'prev_text' => __( '&laquo; Prev Page', 'tclist' ),
                    'next_text' => __( 'Next Page &raquo;', 'tclist' ),
                    'show_all'  => true,
                    'type'      => 'list',
                ],
                $tc_pagination_number,
                $the_query->max_num_pages
            ) );
            ?>
            </div><!-- .pagination -->
            <?php 
            wp_die();
        }

        function tc_add_event_image_size() {
            add_image_size(
                'tc_all_events_image',
                1100,
                680,
                true
            );
            // Mobile
        }

    }

}
if ( !function_exists( 'is_plugin_active_for_network' ) ) {
    require_once ABSPATH . '/wp-admin/includes/plugin.php';
}
/*if( tc_event_listing_fs_is_parent_active_and_loaded() && tc_event_listing_fs()->can_use_premium_code() ){
  if ( is_multisite() && is_plugin_active_for_network( plugin_basename( __FILE__ ) ) ) {

      function tc_events_listing_load() {
          global $tc_tickera_events_filtering;
          $tc_tickera_events_filtering = new TC_Tickera_Events_Filtering();
      }

      add_action( 'tets_fs_loaded', 'tc_events_listing_load' );

  } else {*/
$tc_tickera_events_filtering = new TC_Tickera_Events_Filtering();
/*}
}*/