<?php

function show_tc_display_events_attributes() {
    global $post; ?>
    <table id="tc-display-events-shortcode" class="shortcode-table" style="display:none">
        <tr>
            <th scope="row"><?php _e('Choose Event Category:', 'tclist'); ?></th>
            <td>
                <?php
                $tc_event_categories = get_terms(array(
                    'taxonomy' => 'event_category',
                    'hide_empty' => false,
                ));
                ?>
                <select name="tc_event_categories">
                    <option value="all_categories"><?php _e('All Categories', 'tclist'); ?></option>
                    <?php foreach ($tc_event_categories as $tc_single_category) { ?>
                        <option value="<?php echo $tc_single_category->term_id; ?>"><?php echo $tc_single_category->name; ?></option>
                    <?php } ?>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Display Past Events:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_past_events">
                    <option value="false"><?php _e('No', 'tced'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Listing Width', 'ec' ); ?></th>
            <td>
                <select name="align">
                    <option value="default"><?php _e( 'Default', 'ec' ) ?></option>
                    <option value="wide"><?php _e( 'Wide', 'ec' ) ?></option>
                    <option value="full"><?php _e( 'Full', 'ec' ) ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Number Of Columns:', 'tced'); ?></th>
            <td>
                <select name="tc_number_of_columns">
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('Display Event Filters:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_event_filters" id="tc_show_event_filters">
                    <option value="false"><?php _e('No', 'tced'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr id="tc-show-category-filtering">
            <th scope="row"><?php _e('Display Categories:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_categories">
                    <option value="false"><?php _e('No', 'tced'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr id="tc-show-date-filtering">
            <th scope="row"><?php _e('Display Filtering By Date:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_date_filtering">
                    <option value="false"><?php _e('No', 'tclist'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr id="tc-hide-excerpt">
            <th scope="row"><?php _e('Display Excerpt:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_excerpt">
                    <option value="false"><?php _e('No', 'tclist'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr id="tc-hide-excerpt">
            <th scope="row"><?php _e('Display Default Featured Image:', 'tclist'); ?></th>
            <td>
                <select name="tc_show_default_featured_image">
                    <option value="false"><?php _e('No', 'tclist'); ?></option>
                    <option value="true" selected="selected"><?php _e('Yes', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <tr id="tc-hide-excerpt">
            <th scope="row"><?php _e('Display Number Of Posts:', 'tclist'); ?></th>
            <td>
                <input type="text" value="10" name="tc_show_number_of_posts" />
            </td>
        </tr>
        <tr id="tc-order-events-by">
            <th scope="row"><?php _e('Order Events By:', 'tclist'); ?></th>
            <td>
                <select name="tc_order_events_by">
                    <option value="asc" selected="selected"><?php _e('ASC', 'tclist'); ?></option>
                    <option value="desc"><?php _e('DESC', 'tclist'); ?></option>
                </select>
            </td>
        </tr>
        <?php do_action('tc_ef_add_shortcode_options'); ?>
    </table>
    <?php
}

function tc_class_switch($tc_column_number) {
    switch ($tc_column_number) {
        case 1:
            return 'tc-1-column';
            break;
        case 2:
            return 'tc-2-column';
            break;
        case 3:
            return 'tc-3-column';
            break;
        case 4:
            return 'tc-4-column';
            break;
    }
}

/**
 * Render Event Listing in frontend
 *
 * @param $atts
 * @return false|string
 */
function tc_render_events_filter( $atts ) {

    ob_start();

    global $content_width;

    extract( shortcode_atts( array (
            'tc_event_categories' => 'all_categories',
            'tc_number_of_columns' => 1,
            'tc_show_event_filters' => true,
            'tc_show_categories' => true,
            'tc_show_date_filtering' => true,
            'tc_show_venue_filtering' => true,
            'tc_show_past_events' => true,
            'tc_show_excerpt' => true,
            'tc_show_end_date' => true,
            'tc_show_number_of_posts' => 10,
            'tc_show_default_featured_image' => true,
            'align' => '',
            'tc_order_events_by' => 'asc',
            'className' => ''
        ),
            $atts
        )
    );

    $tc_show_excerpt = ( $tc_show_excerpt ) ? $tc_show_excerpt : 'false';
    $tc_column_number = $tc_number_of_columns; // Variable being used in event-excerpt.php file
    $tc_events_class = tc_class_switch( $tc_number_of_columns );
    $width_values = [ 'wide' => 'alignwide', 'full' => 'alignfull' ];

    if ( 'all_events' == $tc_event_categories ) {
        $tc_event_categories_terms = get_terms( array (
                'taxonomy' => 'event_category',
                'hide_empty' => false,
            )
        );

    } else {
        $tc_category_children = get_term_children( $tc_event_categories, 'event_category' );
        $tc_event_categories_terms = get_terms( array (
                'taxonomy' => 'event_category',
                'hide_empty' => false,
                'include' => $tc_category_children
            )
        );
    }
    ?>
    <div class="tc-event-listing-container<?php echo isset( $width_values[ $align ] ) ? ' ' . $width_values[ $align ] : ''; ?>">
        <input type="hidden" name="tc_event_categories" id="tc_event_categories" value="<?php echo esc_attr( $tc_event_categories ); ?>" />
        <input type="hidden" name="tc_number_of_columns" id="tc_number_of_columns" value="<?php echo esc_attr( $tc_number_of_columns ); ?>" />
        <input type="hidden" name="tc_show_past_events" id="tc_show_past_events" value="<?php echo esc_attr( $tc_show_past_events ); ?>" />
        <input type="hidden" name="tc_show_excerpt" id="tc_show_excerpt" value="<?php echo esc_attr( $tc_show_excerpt ); ?>" />
        <input type="hidden" name="tc_show_end_date" id="tc_show_end_date" value="<?php echo esc_attr( $tc_show_end_date ); ?>" />
        <input type="hidden" name="tc_show_number_of_posts" id="tc_show_number_of_posts" value="<?php echo esc_attr( $tc_show_number_of_posts ); ?>" />
        <input type="hidden" name="tc_pagination_number" id="tc_pagination_number" value="1" />
        <input type="hidden" name="tc_show_default_featured_image" id="tc_show_default_featured_image" value="<?php echo esc_attr( $tc_show_default_featured_image ); ?>" />
        <input type="hidden" name="tc_order_events_by" id="tc_order_events_by" value="<?php echo esc_attr( $tc_order_events_by ); ?>" />
        <?php
        $tc_low_content_width = ( $content_width < 700 ) ? 'tc-low-content-width' : '';
        $tc_class_name = ( $className ) ? ' ' . $className : '';
        ?>

        <div class="tc-events-wrap <?php echo esc_attr( $tc_low_content_width ) . esc_attr( $tc_class_name ); ?>">

            <?php if ( apply_filters( 'tc_ef_show_events_filters', $tc_show_event_filters ) == 'true' ) { ?>
                <?php include plugin_dir_path(__FILE__) . 'templates/filters.php'; ?>
            <?php } ?>

            <div class="tc-display-filter-events">

                <?php
                // Show only in Gutenberg
                if ( strpos( $_SERVER['REQUEST_URI'], 'block-renderer' ) !== false ) {

                    if ( ! empty( $tc_event_categories ) && $tc_event_categories !== 'all_categories' ) {
                        $tc_taxonomies = array( array (
                            'taxonomy' => 'event_category',
                            'field' => 'term_id',
                            'terms' => apply_filters( 'tc_ef_event_categories', $tc_event_categories )
                        ) );

                    } else {
                        $tc_taxonomies = '';
                    }

                    $tc_show_past_events_query = ( ! $tc_show_past_events ) ? [ 'key' => 'event_end_date_time', 'value' => date('Y-m-d'), 'compare' => '>=', 'type' => 'date' ] : [];

                    // The Query
                    $the_query = new WP_Query( array (
                            'post_type' => 'tc_events',
                            'posts_per_page' => apply_filters( 'tc_ef_show_number_of_posts', $tc_show_number_of_posts ),
                            'order' => strtoupper( $tc_order_events_by ),
                            'meta_key' => 'event_date_time',
                            'orderby' => 'meta_value',
                            'post_status' => 'publish',
                            'tax_query' => apply_filters( 'tc_ef_taxonomy_query', $tc_taxonomies ),
                            'meta_query' => [ $tc_show_past_events_query ],
                        )
                    );

                    // The Loop
                    if ( $the_query->have_posts() ) {

                        while ( $the_query->have_posts() ) {
                            $the_query->the_post();

                            // Change this part if you need to make any changes the way events display
                            ?>
                            <div class="tc-single-event <?php echo $tc_events_class; ?>">

                                <!-- include featured image -->
                                <?php include plugin_dir_path(__FILE__) . '/templates/featured-image.php'; ?>

                                <!-- include the title -->
                                <?php include plugin_dir_path(__FILE__) . '/templates/post-title.php'; ?>

                                <!-- dates and location -->
                                <?php include plugin_dir_path(__FILE__) . '/templates/event-dates-location.php'; ?>

                                <!-- event excerpt -->
                                <?php include plugin_dir_path(__FILE__) . '/templates/event-excerpt.php'; ?>

                            </div><!-- .tc-single-event -->
                            <?php
                        }
                    }
                    ?>
                    <!-- events are loaded here -->
                <?php } else { ?>
                    <!-- Loading square for squar.red network -->
                    <span class="tc-listing-loader"><span class="tc-loader-inner"></span></span>
                <?php } ?>
            </div><!-- tc-display-filter-events -->
        </div><!-- .tc-events-wrap -->
    </div><!-- tc-event-listing-container -->
    <?php

    // Restore original Post Data
    return ob_get_clean();
}

function tc_event_excerpt($limit) {
    global $post;

    $excerpt = explode(' ', $post->post_content, $limit);

    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt) . '...';
    } else {
        $excerpt = implode(" ", $excerpt);
    }

    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
    return apply_filters('tc_ef_excerpt', $excerpt);
}

function tc_get_event_categories($tc_event_categories) {
    if ($tc_event_categories == 'all_events') {
        $tc_event_categories_terms = get_terms(array(
            'taxonomy' => 'event_category',
            'hide_empty' => false,
        ));
    } else {
        $tc_category_children = get_term_children($tc_event_categories, 'event_category');
        $tc_event_categories_terms = get_terms(array(
            'taxonomy' => 'event_category',
            'hide_empty' => false,
            'include' => $tc_category_children
        ));
    }

    return apply_filters('tc_ef_event_categories', $tc_event_categories_terms);
}
