<?php
$menus = TC_Checkinera_Settings::get_frontend_menus();
$is_cookie_set = ( isset( $this->cookie[ 'tc_checkin_settings' ] ) ) ? true : false;
$option_values = ( isset( $this->cookie[ 'tc_checkin_settings' ] ) ) ? $this->cookie[ 'tc_checkin_settings' ] : [];
?>
<div id="tc-toolbar">
    <div class="menus-wrap">
        <div class="menus">
            <?php foreach ( $menus as $menu ) : ?>
                <div class="menu <?php echo esc_attr( $menu[ 'name' ] ); ?>">
                    <span class="label-icon"><?php echo esc_html( $menu[ 'title' ] ) ?></span>
                    <div class="content">
                        <div class="header">
                            <div class="close"></div>
                            <div class="title">
                                <span><?php echo esc_html( $menu[ 'title' ] ) ?></span>
                            </div>
                        </div>
                        <div class="sections">
                            <?php foreach ( $menu[ 'sections' ] as $section ) : ?>
                                <div class="section">
                                    <h2><?php echo esc_html( $section[ 'title' ], 'tc_ch' ) ?></h2>
                                    <hr/>
                                    <p class="description"><i><?php echo esc_html( $section[ 'description' ] ) ?></i></p>
                                    <div class="options">
                                        <?php foreach ( $section[ 'fields' ] as $option ) : ?>
                                            <div class="option">
                                                <span><?php echo esc_html( $option[ 'field_title' ] ) ?></span>
                                                <?php CHK_Fields::render_field( $option, 'tc_checkin_settings', $option_values ); ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>