<?php
if ( !class_exists( 'CHK_Fields' ) ) {

	class CHK_Fields {

		public static function render_field( $field, $key = false, $option = [] ) {

			switch ( $field[ 'field_type' ] ) {

				case 'function':
                    CHK_Fields::field_function( $field, $key, $option );
                    break;

				case 'text':
                    CHK_Fields::field_text( $field, $key, $option );
                    break;

				case 'option': // Depricated, same as text
                    CHK_Fields::field_text( $field, $key, $option );
                    break;

				case 'textarea':
                    CHK_Fields::field_textarea( $field, $key, $option );
                    break;

				case 'wp_editor':
                    CHK_Fields::field_wp_editor( $field, $key, $option );
                    break;

				case 'radio':
                    CHK_Fields::field_radio( $field, $key, $option );
                    break;

				case 'select':
                    CHK_Fields::field_select( $field, $key, $option );
                    break;

				case 'color_field':
                    CHK_Fields::color_field( $field, $key, $option );
                    break;

				case 'file':
                    CHK_Fields::field_file( $field, $key, $option );
                    break;

				case 'date':
                    CHK_Fields::field_date( $field, $key, $option );
                    break;

                case 'number':
                    CHK_Fields::field_number( $field, $key, $option );
                    break;

                case 'toggle':
                    CHK_Fields::field_toggle( $field, $key, $option );
                    break;

				default:
				    CHK_Fields::field_text( $field, $key, $option );
			}
		}

        public static function sanitize_array( $input ) {

            $new_input = [];
            foreach ( $input as $key => $val ) {

                if ( is_array( $val ) ) {

                    // 2nd level
                    $input_2 = CHK_Fields::rsc_sanitize_array( $val );
                    foreach ( $input_2 as $key_2 => $val_2 ) {

                        if ( is_array( $val_2 ) ) {

                            // 3rd level
                            $input_3 = CHK_Fields::rsc_sanitize_array( $val_2 );
                            foreach ( $input_3 as $key_3 => $val_3 ) {

                                if ( is_array( $val_3 ) ) {

                                    // 4th level
                                    $input_4 = CHK_Fields::rsc_sanitize_array( $val_3 );
                                    foreach ( $input_4 as $key_4 => $val_4 ) {

                                        if ( is_array( $val_4 ) ) {

                                            // 5th level
                                            $input_5 = CHK_Fields::rsc_sanitize_array( $val_4 );
                                            foreach ( $input_5 as $key_5 => $val_5 ) {
                                                $new_input[$key][$key_2][$key_3][$key_4][$key_5] = ( $val_5 );
                                            }

                                        } else {
                                            $new_input[$key][$key_2][$key_3][$key_4] = ( $val_4 );
                                        }
                                    }

                                } else {
                                    $new_input[$key][$key_2][$key_3] = ( $val_3 );
                                }
                            }

                        } else {
                            $new_input[$key][$key_2] = ( $val_2 );
                        }
                    }

                } else {
                    $new_input[$key] = ( $val );
                }
            }

            return $new_input;
        }

        public static function tooltip( $content, $echo = true ) {

            if ( !empty( $content ) ) {

                $tooltip = '<a title="' . htmlentities($content) . '" class="chk_tooltip"><span class="dashicons dashicons-editor-help"></span></a>';

                if ( $echo ) {
                    echo $tooltip;

                } else {
                    return $tooltip;
                }
            }
        }

        /**
         * Render fields by type (function, text, textarea, etc)
         *
         * @param $obj_class
         * @param $field
         * @param $post_id
         * @param bool $show_title
         */
        public static function render_post_type_field( $obj_class, $field, $post_id, $show_title = true ) {

            // Backward Compatibility
            $obj_class = ( $obj_class ) ? $obj_class : false;

            if ( !$obj_class ) {
                echo '<strong>Class cannot be empty - called from render_post_type_field method</strong>';
                return;
            }

            if ( !class_exists( $obj_class ) ) {
                echo '<strong>Class ' . $obj_class . ' doesn\'t exists called from render_post_type_field method</strong>';
                return;
            }

            $obj = new $obj_class( $post_id );

            if ( $show_title ) { ?>
                <label><?php echo $field[ 'field_title' ]; ?><?php
            }

            // Function
            if ( 'function' == $field[ 'field_type' ] ) {
                eval( $field[ 'function' ] . '("' . $field[ 'field_name' ] . '"' . (isset( $post_id ) ? ',' . $post_id : '') . ');' );
                if ( isset( $field[ 'field_description' ] ) ) { ?>
                    <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
                <?php }
            }

            // Text
            if ( 'text' == $field[ 'field_type' ] ) { ?>
                <input type="text" class="regular-<?php echo esc_attr( $field[ 'field_type' ] ); ?>" value="<?php
                if ( isset( $obj ) ) {
                    if ( 'post_meta' == $field[ 'post_field_type' ] ) {
                        echo esc_attr( isset( $obj->details->{$field[ 'field_name' ]} ) ? $obj->details->{$field[ 'field_name' ]} : ''  );
                    } else {
                        echo esc_attr( $obj->details->{$field[ 'post_field_type' ]} );
                    }
                } ?>" id="<?php echo esc_attr( isset( $field[ 'field_name' ] ) ? $field[ 'field_name' ] : ''  ); ?>" name="<?php echo esc_attr( $field[ 'field_name' ] . '_' . $field[ 'post_field_type' ] ); ?>" placeholder="<?php echo esc_attr( isset( $field[ 'placeholder' ] ) ? $field[ 'placeholder' ] : ''  ); ?>"  <?php echo isset( $field[ 'required' ] ) ? 'required' : ''; ?> <?php echo isset( $field[ 'number' ] ) ? 'number="true"' : ''; ?>>
                <?php if ( isset( $field[ 'field_description' ] ) ) { ?>
                    <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
                <?php }
            }

            // Textare
            if ( 'textarea' == $field[ 'field_type' ] ) { ?>
                <textarea class="regular-<?php echo esc_attr( $field[ 'field_type' ] ); ?>" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" name="<?php echo esc_attr( $field[ 'field_name' ] . '_' . $field[ 'post_field_type' ] ); ?>"><?php
                if ( isset( $obj ) ) {
                    if ( 'post_meta' == $field[ 'post_field_type' ] ) {
                        echo esc_textarea( isset( $obj->details->{$field[ 'field_name' ]} ) ? $obj->details->{$field[ 'field_name' ]} : ''  );
                    } else {
                        echo esc_textarea( $obj->details->{$field[ 'post_field_type' ]} );
                    }
                } ?></textarea>
                <?php if ( isset( $field[ 'field_description' ] ) ) { ?>
                    <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
                <?php }
            }

            // Editor
            if ( 'textarea_editor' == $field[ 'field_type' ] ) { ?>
                <?php if ( isset( $obj ) ) {
                    if ( 'post_meta' == $field[ 'post_field_type' ] ) {
                        $editor_content = ( isset( $obj->details->{$field[ 'field_name' ]} ) ? $obj->details->{$field[ 'field_name' ]} : '' );
                    } else {
                        $editor_content = ( $obj->details->{$field[ 'post_field_type' ]} );
                    }
                } else {
                    $editor_content = '';
                }
                wp_editor( html_entity_decode( stripcslashes( $editor_content ) ), $field[ 'field_name' ], array( 'textarea_name' => $field[ 'field_name' ] . '_' . $field[ 'post_field_type' ], 'textarea_rows' => 5 ) );
                if ( isset( $field[ 'field_description' ] ) ) { ?>
                    <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
                <?php }
            }

            // Image
            if ( 'image' == $field[ 'field_type' ] ) { ?>
                <div class="file_url_holder">
                    <label>
                        <input class="file_url" type="text" size="36" name="<?php echo esc_attr( $field[ 'field_name' ] . '_file_url_' . $field[ 'post_field_type' ] ); ?>" value="<?php
                        if ( isset( $obj ) ) {
                            echo esc_attr( isset( $obj->details->{$field[ 'field_name' ] . '_file_url'} ) ? $obj->details->{$field[ 'field_name' ] . '_file_url'} : ''  );
                        } ?>"/>
                        <input class="file_url_button button-secondary" type="button" value="<?php _e( 'Browse', 'tc_ch'); ?>" />
                        <?php if ( isset( $field[ 'field_description' ] ) ) { ?>
                            <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
                        <?php } ?>
                    </label>
                </div>
            <?php }
            if ( $show_title ) { ?>
                </label>
            <?php }
        }

        public static function conditionals( $field, $echo = true, $additional_classes = '' ) {

            $conditional_atts = '';

            if ( isset( $field[ 'conditional' ] ) ) {
                $conditional_atts .= ' class="chk_conditional ' . esc_attr( $additional_classes ) . '" ';
                $conditional_atts .= ' data-condition-field_name="' . esc_attr( $field[ 'conditional' ][ 'field_name' ] ) . '" ';
                $conditional_atts .= ' data-condition-field_type="' . esc_attr( $field[ 'conditional' ][ 'field_type' ] ) . '" ';
                $conditional_atts .= ' data-condition-value="' . esc_attr( $field[ 'conditional' ][ 'value' ] ) . '" ';
                $conditional_atts .= ' data-condition-action="' . esc_attr( $field[ 'conditional' ][ 'action' ] ) . '" ';
            } else {
                $conditional_atts .= ' class="' . esc_attr( $additional_classes ) . '" ';
            }

            if ( $echo ) {
                echo $conditional_atts;
            } else {
                return $conditional_atts;
            }
        }

        /**
         * Render toggle field
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_toggle( $field, $key, $option = [] ) {
            $option = $option ? $option : get_option( $key );
            $default_value = $field[ 'default_value' ] ? 1 : 0;
            $value = isset( $option[ $field[ 'field_name' ] ] ) ? $option[ $field[ 'field_name' ] ] : $default_value;
            $field_name = sanitize_key( $field[ 'field_name' ] ); ?>
            <label class="switch"><input type="checkbox" id="<?php echo esc_attr( $field_name ); ?>" name="<?php echo esc_attr( $key . '[' . $field[ 'field_name' ] . ']' ); ?>" class="<?php echo esc_attr( $field[ 'field_name' ] ) . ( isset( $field[ 'additional_classes' ] ) ? ' ' . esc_attr( $field[ 'additional_classes' ] ) : '' ); ?>" value="<?php echo esc_attr( $default_value ); ?>" <?php checked( $value, $default_value, true ); ?>><span class="slider"></span></label>
        <?php }

        /**
         * Render function fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_function( $field, $key, $option = [] ) {
            if ( isset( $field[ 'default_value' ] ) ) {
                eval( $field[ 'function' ] . '("' . $field[ 'field_name' ] . '", "' . $field[ 'default_value' ] . '");' );
            } else {
                eval( $field[ 'function' ] . '("' . $field[ 'field_name' ] . '");' );
            } ?>
            <span class="description"><?php echo isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''; ?></span>
        <?php }

        /**
         * Render input text fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_text( $field, $key, $option = [] ) {
            $chk_settings = get_option( $key, false ); ?>
            <input type="text" class="<?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" name="<?php echo esc_attr($key); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" value="<?php echo (isset( $chk_settings[ $field[ 'field_name' ] ] ) ? stripslashes( esc_attr( $chk_settings[ $field[ 'field_name' ] ] ) ) : (isset( $field[ 'default_value' ] ) ? stripslashes( esc_attr( $field[ 'default_value' ] ) ) : '') ) ?>" <?php echo isset( $field[ 'required' ] ) ? 'required' : ''; ?> <?php echo isset( $field[ 'number' ] ) ? 'number="true"' : ''; ?> <?php echo isset( $field[ 'minlength' ] ) ? 'minlength="' . (int) $field[ 'minlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'maxlength' ] ) ? 'maxlength="' . (int) $field[ 'maxlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'rangelength' ] ) ? 'rangelength="' . (int) $field[ 'rangelength' ] . '"' : ''; ?> <?php echo isset( $field[ 'min' ] ) ? 'min="' . (int) $field[ 'min' ] . '"' : ''; ?> <?php echo isset( $field[ 'max' ] ) ? 'max="' . (int) $field[ 'max' ] . '"' : ''; ?> <?php echo isset( $field[ 'range' ] ) ? 'range="' . $field[ 'range' ] . '"' : ''; ?>>
            <span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render input text fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function color_field( $field, $key, $option = [] ) {
            $chk_settings = get_option( $key, false ); ?>
            <input type="hidden" name="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" value="<?php echo $field[ 'default_value' ] ?>" class="tc-default-color"/>
            <input type="text" class="chk_color_field <?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" name="<?php echo esc_attr($key); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" value="<?php echo (isset( $chk_settings[ $field[ 'field_name' ] ] ) ? stripslashes( esc_attr( $chk_settings[ $field[ 'field_name' ] ] ) ) : (isset( $field[ 'default_value' ] ) ? stripslashes( esc_attr( $field[ 'default_value' ] ) ) : '') ) ?>" <?php echo isset( $field[ 'required' ] ) ? 'required' : ''; ?> <?php echo isset( $field[ 'number' ] ) ? 'number="true"' : ''; ?> <?php echo isset( $field[ 'minlength' ] ) ? 'minlength="' . (int) $field[ 'minlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'maxlength' ] ) ? 'maxlength="' . (int) $field[ 'maxlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'rangelength' ] ) ? 'rangelength="' . (int) $field[ 'rangelength' ] . '"' : ''; ?> <?php echo isset( $field[ 'min' ] ) ? 'min="' . (int) $field[ 'min' ] . '"' : ''; ?> <?php echo isset( $field[ 'max' ] ) ? 'max="' . (int) $field[ 'max' ] . '"' : ''; ?> <?php echo isset( $field[ 'range' ] ) ? 'range="' . $field[ 'range' ] . '"' : ''; ?>>
            <span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render file text fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_file( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false ); ?>
            <input class="file_url <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" type="text" name="<?php echo esc_attr( $key ); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" value="<?php echo (isset( $chk_settings[ $field[ 'field_name' ] ] ) ? stripslashes( $chk_settings[ $field[ 'field_name' ] ] ) : (isset( $field[ 'default_value' ] ) ? stripslashes( $field[ 'default_value' ] ) : '') ); ?>" />
            <input class="file_url_button button-secondary" type="button" value="<?php _e( 'Browse', 'tc_ch' ); ?>" />
            <span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render Text field with number type
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_number( $field, $key, $option = [] ) {
            $chk_settings = get_option( $key, false ); ?>
            <input type="number" class="<?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" name="<?php echo esc_attr($key); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" value="<?php echo (isset( $chk_settings[ $field[ 'field_name' ] ] ) ? stripslashes( esc_attr( $chk_settings[ $field[ 'field_name' ] ] ) ) : (isset( $field[ 'default_value' ] ) ? stripslashes( esc_attr( $field[ 'default_value' ] ) ) : '') ) ?>" <?php echo isset( $field[ 'required' ] ) ? 'required' : ''; ?> <?php echo isset( $field[ 'number' ] ) ? 'number="true"' : ''; ?> <?php echo isset( $field[ 'minlength' ] ) ? 'minlength="' . (int) $field[ 'minlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'maxlength' ] ) ? 'maxlength="' . (int) $field[ 'maxlength' ] . '"' : ''; ?> <?php echo isset( $field[ 'rangelength' ] ) ? 'rangelength="' . (int) $field[ 'rangelength' ] . '"' : ''; ?> <?php echo isset( $field[ 'min' ] ) ? 'min="' . (int) $field[ 'min' ] . '"' : ''; ?> <?php echo isset( $field[ 'max' ] ) ? 'max="' . (int) $field[ 'max' ] . '"' : ''; ?> <?php echo isset( $field[ 'range' ] ) ? 'range="' . $field[ 'range' ] . '"' : ''; ?>>
            <span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render date text fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        function field_date( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false );
            wp_enqueue_script( 'jquery-ui-datepicker' );
            wp_enqueue_style( 'jquery-style', '//ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css' ); ?>
            <input type="text" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" name="<?php echo esc_attr( $field[ 'field_name' ] ); ?>" value="" />
            <input type="hidden" name="<?php echo esc_attr( $field[ 'field_name' ] ); ?>_raw" id="<?php echo esc_attr( $field[ 'field_name' ] ); ?>_raw" value="" />
            <span class="description"><?php echo ( $field[ 'field_description' ] ); ?></span>
            <script>
            jQuery( document ).ready( function ( $ ) {
            jQuery( '#<?php echo esc_attr( $field[ 'field_name' ] ); ?>' ).datepicker( {
            dateFormat: '<?php echo isset( $field[ 'date_format' ] ) ? $field[ 'date_format' ] : 'dd-mm-yy'; ?>',
            onSelect: function ( dateText, inst ) { jQuery( '#<?php echo esc_attr( $field[ 'field_name' ] ); ?>_raw' ).val( inst.selectedYear + '-' + inv_leading_zeros( inst.selectedMonth ) + '-' + inv_leading_zeros( inst.selectedDay ) ); }
            });
            var current_value = jQuery( "#<?php echo esc_attr( $field[ 'field_name' ] ); ?>" ).val();
            if ( !current_value ) { jQuery( '#<?php echo esc_attr( $field[ 'field_name' ] ); ?>' ).datepicker( "setDate", 15 ); }
            });
            </script>
        <?php }

        /**
         * Render textarea fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_textarea( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false ); ?>
            <textarea class="<?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" name="<?php echo esc_attr( $key ); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]"><?php echo (isset( $chk_settings[ $field[ 'field_name' ] ] ) ? stripslashes( $chk_settings[ $field[ 'field_name' ] ] ) : (isset( $field[ 'default_value' ] ) ? stripslashes( $field[ 'default_value' ] ) : '') ) ?></textarea>
            <span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render wp_editor fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_wp_editor( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false );
            $saved_value = isset( $chk_settings[ $field[ 'field_name' ] ] ) ? $chk_settings[ $field[ 'field_name' ] ] : '';

            if ( $saved_value == '' && $field[ 'default_value' ] !== '' ) {
                $saved_value = $field[ 'default_value' ];
            } ?>
            <?php wp_editor( html_entity_decode( stripcslashes( esc_textarea( $saved_value ) ) ), 'inv_wp_editor_' . $field[ 'field_name' ], array( 'textarea_name' => esc_attr( $key . '[' . $field[ 'field_name' ] . ']' ), 'textarea_rows' => 2 ) ); ?>
            <br /><span class="description"><?php echo ( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : '' ); ?></span>
        <?php }

        /**
         * Render radio fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_radio( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false );
            $saved_value = isset( $chk_settings[ $field[ 'field_name' ] ] ) ? $chk_settings[ $field[ 'field_name' ] ] : '';

            if ( $saved_value == '' && $field[ 'default_value' ] !== '' ) {
                $saved_value = $field[ 'default_value' ];
            }

            foreach ( $field[ 'values' ] as $key => $value ) { ?>
                <input type="radio" class="<?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>" name="<?php echo esc_attr( $key ); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" value="<?php echo stripslashes( esc_attr( $key ) ); ?>" <?php checked( $key, $saved_value, true ); ?> /> <?php echo $value; ?>
            <?php } ?>
            <br /><span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  ); ?></span>
        <?php }

        /**
         * Render checkbox fields
         *
         * @param $field
         * @param $key
         * @param array $option
         */
        public static function field_select( $field, $key, $option = [] ) {
            $chk_settings = get_option( esc_attr( $key ), false );
            $saved_value = isset( $chk_settings[ $field[ 'field_name' ] ] ) ? $chk_settings[ $field[ 'field_name' ] ] : '';

            if ( $saved_value == '' && $field[ 'default_value' ] !== '' ) {
                $saved_value = $field[ 'default_value' ];
            } ?>
            <select name="<?php echo esc_attr( $key ); ?>[<?php echo esc_attr( $field[ 'field_name' ] ); ?>]" class="<?php echo esc_attr( $field[ 'field_name' ] ); ?> <?php echo esc_attr( isset( $field[ 'field_class' ] ) ? $field[ 'field_class' ] : ''  ); ?>">
            <?php foreach ( $field[ 'values' ] as $key => $value ) { ?>
                <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $saved_value, true ); ?>><?php echo $value; ?></option>
            <?php } ?>
            </select>
            <br /><span class="description"><?php echo stripslashes( isset( $field[ 'field_description' ] ) ? $field[ 'field_description' ] : ''  );
            ?></span>
        <?php }
    }
}
?>
