/**
 * Initialize tcchreIntervalEnabled.
 * Use to filter multiple calls in Woocommerce checkout blocks.
 *
 * @type {boolean}
 */
var tcchreIntervalEnabled = true;

/**
 * Initialize Google Recaptcha.
 * Inline Callback Function
 */
var onChreCallback = function() {

    var $ = jQuery;

    if ( tcchreIntervalEnabled == true ) {

        /**
         * Set interval to consistently check rendered recaptcha container in Woocommerce checkout blocks
         *
         * @type {number}
         */
        var tcchreInterval = setInterval( function() {

            if ( $( '#tcchre-g-recaptcha' ).length > 0 ) {

                grecaptcha.render( 'tcchre-g-recaptcha', {
                    sitekey : chreDecode( tcchre.key ),
                    callback: onChreResponseCallback,
                    'expired-callback': onChreResponseCallback,
                    'error-callback': onChreResponseCallback,
                });

                let container = $( '.wp-block-checkout-recaptcha' ),
                    parentContainer = $( '.wp-block-checkout-recaptcha' ).parent(),
                    placeOrderContainer = parentContainer.find( '.wc-block-checkout__actions' );

                placeOrderContainer.prepend( container );

                tcchreIntervalEnabled = false;
                clearInterval( tcchreInterval );
            }

        }, 1000);
    }
};

/**
 * Verification
 * Expired Captcha
 * @param user_response
 */
var onChreResponseCallback = function( response ) {

    response = ( typeof response !== 'undefined' ) ? response : '';

    var chreResponse = document.getElementById( 'chre_response' );
    // chreResponse.value = response; // React ≤ 15.6.0

    const nativeInputValueSetter = Object.getOwnPropertyDescriptor( window.HTMLInputElement.prototype, 'value').set;
    nativeInputValueSetter.call( chreResponse, response );
    const event = new Event('input', { bubbles: true });
    // event.simulated = true; // React ≤ 15.6.0

    chreResponse.dispatchEvent( event );
};

/**
 * Decode key to get the correct value.
 * @param str
 * @returns {*}
 */
var chreDecode = function( str ) {
    let pos =  Math.round( ( str.length - 1 ) / 3 );
    str = str.slice(0, pos ) + str.slice( ( pos + 1 ) );
    return str;
};

