<?php

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( ! class_exists( 'TC_Export_Bridge' ) ) {

    class TC_Export_Bridge
    {
        protected $is_bridge_active;
        protected $order_post_types;
        protected $event_meta_key;
        protected $ticket_post_types = [ 'tc_tickets' ];

        /**
         * Initializes the bridge functionality for WooCommerce integration.
         *
         * This method checks if the bridge is active using a filter and sets
         * related properties accordingly. If the bridge is active, it configures
         * ticket post types, order post types, and the event meta key by applying
         * respective filters.
         *
         * @return void
         */
        public function init() {

            $this->is_bridge_active = apply_filters( 'tc_bridge_for_woocommerce_is_active', false );

            if ( $this->is_bridge_active ) {
                $this->ticket_post_types = [ 'product', 'product_variation' ];
                $this->order_post_types = apply_filters( 'tc_order_types', [ 'tc_orders' ] );
                $this->event_meta_key = apply_filters( 'tc_event_name_field_name', 'event_name' );
            }
        }
    }
}