<?php

/**
 * Plugin Name: Tickera Check-in Notifications
 * Plugin URI: http://tickera.com/
 * Description: Send notification e-mail when user has checked in the event
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.2.0
 * Update URI: https://api.freemius.com
 * Text Domain: chin
 * Domain Path: /languages/
 * Copyright 2019 Tickera (http://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
if ( !function_exists( 'tcchin_fs' ) ) {
    // Create a helper function for easy SDK access.
    function tcchin_fs() {
        global $tcchin_fs;
        if ( !isset( $tcchin_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_3182_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_3182_MULTISITE', true );
            }
            // Include Freemius SDK.
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } else {
                if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                    // Try to load SDK from premium parent plugin folder.
                    require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
                } else {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
            }
            $tcchin_fs = fs_dynamic_init( array(
                'id'               => '3182',
                'slug'             => 'check-in-notifications',
                'premium_slug'     => 'check-in-notifications',
                'type'             => 'plugin',
                'public_key'       => 'pk_9a3d0abd6c056523178b5c2b7701d',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'parent'           => array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                ),
                'menu'             => array(
                    'first-path' => 'plugins.php',
                    'support'    => false,
                ),
                'is_live'          => true,
            ) );
        }
        return $tcchin_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function tcchin_fs_is_parent_active_and_loaded() {
    return function_exists( 'Tickera\\tets_fs' );
}

function tcchin_fs_is_parent_active() {
    $active_plugins = get_option( 'active_plugins', array() );
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

/**
 * Parent is active, add your init code here.
 * Init Freemius.
 */
function tcchin_fs_init() {
    if ( tcchin_fs_is_parent_active_and_loaded() ) {
        tcchin_fs();
        if ( !tcchin_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        /* Parent is inactive, add your error handling here. */
    }
}

if ( tcchin_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    tcchin_fs_init();
} else {
    if ( tcchin_fs_is_parent_active() ) {
        // Init add-on only after the parent is loaded.
        add_action( 'tets_fs_loaded', 'tcchin_fs_init' );
    } else {
        // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
        tcchin_fs_init();
    }
}
if ( !class_exists( 'TC_Checkin_Notifications' ) ) {
    class TC_Checkin_Notifications {
        var $version = '1.1.6';

        var $title = 'Check-in Notifications';

        var $name = 'chin';

        var $dir_name = 'check-in-notifications';

        var $location = 'plugins';

        var $plugin_dir = '';

        var $plugin_url = '';

        var $language = '';

        function __construct() {
            add_action( 'activated_plugin', array($this, 'plugin_dependencies'), 99 );
            add_action( 'tc_check_in_notification', array(&$this, 'tc_check_in_notification_email') );
            add_filter( 'tc_settings_email_sections', array(&$this, 'tc_email_notifications_section') );
            add_filter( 'tc_settings_email_fields', array(&$this, 'tc_email_notifications_fields') );
            add_action( 'init', array(&$this, 'localization'), 10 );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {
            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );
            if ( $index !== false ) {
                unset($active_plugins[$index]);
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Plugin localization function.
         * Load up the localization file if we're using WordPress in a different language.
         * Place it in this plugin's "languages" folder and name it "tc-[value in wp-config].mo"
         */
        function localization() {
            if ( $this->location == 'mu-plugins' ) {
                load_muplugin_textdomain( 'chin', 'languages/' );
            } else {
                if ( $this->location == 'subfolder-plugins' ) {
                    load_plugin_textdomain( 'chin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
                } else {
                    if ( $this->location == 'plugins' ) {
                        load_plugin_textdomain( 'chin', false, 'languages/' );
                    }
                }
            }
            $temp_locales = explode( '_', get_locale() );
            $this->language = ( $temp_locales[0] ? $temp_locales[0] : 'en' );
        }

        /**
         * Adding section in the e-mail tab
         *
         * @param $sections
         * @return array
         */
        function tc_email_notifications_section( $sections ) {
            $sections[] = array(
                'name'        => 'email_notifications',
                'title'       => __( 'Check-in Notifications', 'chin' ),
                'description' => '',
            );
            return $sections;
        }

        /**
         * Adding fields in the e-mail notifications section.
         *
         * @param $fields
         * @return array
         */
        function tc_email_notifications_fields( $fields ) {
            $fields[] = array(
                'field_name'        => 'subject',
                'field_title'       => __( 'Set the mail subject', 'chin' ),
                'field_type'        => 'option',
                'default_value'     => __( 'Ticket Check-in', 'chin' ),
                'field_description' => __( 'Set the mail subject', 'chin' ),
                'section'           => 'email_notifications',
            );
            $fields[] = array(
                'field_name'        => 'from_name',
                'field_title'       => __( 'From Name', 'chin' ),
                'field_type'        => 'option',
                'default_value'     => get_option( 'blogname' ),
                'field_description' => __( 'This name will appear as sent from name in the e-mail.', 'chin' ),
                'section'           => 'email_notifications',
            );
            $fields[] = array(
                'field_name'        => 'from_email',
                'field_title'       => __( 'From E-Mail Address', 'chin' ),
                'field_type'        => 'option',
                'default_value'     => get_option( 'admin_email' ),
                'field_description' => __( 'This e-mail will appear as sender address.', 'chin' ),
                'section'           => 'email_notifications',
            );
            $fields[] = array(
                'field_name'        => 'checkin_notifications_text',
                'field_title'       => __( 'Check-in Notifications Text', 'chin' ),
                'field_type'        => 'function',
                'function'          => 'tc_get_notification_message',
                'default_value'     => __( 'Hello (OWNER_NAME), your ticket has been checked at (EVENT)', 'chin' ),
                'field_description' => __( 'Set the text that will be sent to ticket owner e-mail like information about the event, map, program etc...' . 'You can use following placeholders (OWNER_NAME), (EVENT), (TICKET TYPE)', 'chin' ),
                'section'           => 'email_notifications',
            );
            $fields[] = array(
                'field_name'        => 'checkin_notifications',
                'field_title'       => __( 'Send Check-in Notification To Owner', 'chin' ),
                'field_type'        => 'function',
                'function'          => 'tc_yes_no_checkins',
                'default_value'     => 'yes',
                'field_description' => __( 'Check the field to send notifications to owner e-mail when they are checked-in.', 'chin' ),
                'section'           => 'email_notifications',
            );
            $fields[] = array(
                'field_name'        => 'checkin_notifications_buyer',
                'field_title'       => __( 'Send Check-in Notification To Buyer', 'chin' ),
                'field_type'        => 'function',
                'function'          => 'tc_yes_no_checkins',
                'default_value'     => 'no',
                'field_description' => __( 'Check the field to send notifications to buyer e-mail when they are checked-in.', 'chin' ),
                'section'           => 'email_notifications',
            );
            return $fields;
        }

        /**
         * Function responsible for sending e-mails
         *
         * @param $ticket_id
         */
        function tc_check_in_notification_email( $ticket_id ) {
            add_filter( 'wp_mail_content_type', function () {
                return 'text/html';
            } );
            $tc_checkin_mail = [];
            $order_id = wp_get_post_parent_id( $ticket_id );
            $order = new Tickera\TC_Order($order_id);
            $tc_email_settings = get_option( 'tickera_email_setting', false );
            $tc_get_owner_mail = get_post_meta( $ticket_id, 'owner_email', true );
            $tc_general_settngs = get_option( 'tickera_general_setting' );
            $tc_owner_fields = $tc_general_settngs['show_owner_fields'];
            $tc_get_buyer_mail = ( isset( $order->details->tc_cart_info['buyer_data']['email_post_meta'] ) ? $order->details->tc_cart_info['buyer_data']['email_post_meta'] : '' );
            $tc_get_buyer_mail = apply_filters( 'tc_ticket_checkin_buyer_email', $tc_get_buyer_mail, $order->details->ID );
            $checkin_notification_owner = ( isset( $tc_email_settings['checkin_notifications'] ) ? $tc_email_settings['checkin_notifications'] : 'yes' );
            $checkin_notification_buyer = ( isset( $tc_email_settings['checkin_notifications_buyer'] ) ? $tc_email_settings['checkin_notifications_buyer'] : 'no' );
            // Exit if notifications are off.
            if ( 'no' == $checkin_notification_owner && 'no' == $checkin_notification_buyer ) {
                return;
            }
            $tc_get_owner_mail = ( 'no' == $checkin_notification_owner ? '' : $tc_get_owner_mail );
            $tc_get_buyer_mail = ( 'no' == $checkin_notification_buyer ? '' : $tc_get_buyer_mail );
            if ( $tc_get_owner_mail ) {
                $tc_checkin_mail[] = $tc_get_owner_mail;
            }
            if ( $tc_get_buyer_mail ) {
                $tc_checkin_mail[] = $tc_get_buyer_mail;
            }
            // Exit if no email reference found.
            if ( !$tc_checkin_mail ) {
                return;
            }
            if ( 'no' == $tc_owner_fields ) {
                $tc_get_owner_first_name = get_post_meta( $order_id, '_billing_first_name', true );
                $tc_get_owner_last_name = get_post_meta( $order_id, '_billing_last_name', true );
                if ( empty( $tc_get_owner_first_name ) && empty( $tc_get_owner_last_name ) ) {
                    $tc_get_owner_first_name = $order->details->tc_cart_info['buyer_data']['first_name_post_meta'];
                    $tc_get_owner_last_name = $order->details->tc_cart_info['buyer_data']['last_name_post_meta'];
                }
            } else {
                $tc_get_owner_first_name = get_post_meta( $ticket_id, 'first_name', true );
                $tc_get_owner_last_name = get_post_meta( $ticket_id, 'last_name', true );
            }
            $tc_get_event_name = get_post_meta( $ticket_id, 'event_id', true );
            $tc_get_event_name = get_the_title( $tc_get_event_name );
            $check_text = $tc_email_settings['checkin_notifications_text'];
            $ticket_type_id = get_post_meta( $ticket_id, apply_filters( 'tc_ticket_type_id', 'ticket_type_id' ), true );
            $ticket_type_name = apply_filters( 'tc_checkout_owner_info_ticket_title', get_the_title( $ticket_type_id ), $ticket_type_id );
            $tc_placeholders = apply_filters( 'tc_checkin_notification_email_placeholders', ['OWNER_NAME', 'EVENT', 'TICKET_TYPE'] );
            $tc_placeholder_values = apply_filters(
                'tc_checkin_notification_email_placeholder_values',
                [$tc_get_owner_first_name . ' ' . $tc_get_owner_last_name, $tc_get_event_name, $ticket_type_name],
                $ticket_id,
                $order_id
            );
            $tc_message = str_replace( $tc_placeholders, $tc_placeholder_values, $tc_email_settings['checkin_notifications_text'] );
            $tc_headers = 'From: ' . $tc_email_settings['from_name'] . ' <' . $tc_email_settings['from_email'] . '>' . "\r\n";
            wp_mail(
                $tc_checkin_mail,
                $tc_email_settings['subject'],
                stripcslashes( apply_filters( 'tc_checkin_notification', wpautop( $tc_message ) ) ),
                $tc_headers
            );
        }

    }

}
/**
 * Checking notification function for yes and no
 */
if ( !function_exists( 'is_plugin_active_for_network' ) ) {
    require_once ABSPATH . '/wp-admin/includes/plugin.php';
}
if ( is_multisite() && is_plugin_active_for_network( plugin_basename( __FILE__ ) ) ) {
    function tc_checkin_notifications_load() {
        global $tc_checkin_notifications;
        $tc_checkin_notifications = new TC_Checkin_Notifications();
    }

    add_action( 'tets_fs_loaded', 'tc_checkin_notifications_load' );
} else {
    $tc_checkin_notifications = new TC_Checkin_Notifications();
}
function tc_yes_no_checkins(  $field_name, $default_value = ''  ) {
    $tc_email_settings = get_option( 'tickera_email_setting', false );
    if ( isset( $tc_email_settings[$field_name] ) ) {
        $checked = $tc_email_settings[$field_name];
    } else {
        $checked = ( $default_value !== '' ? $default_value : 'no' );
    }
    ?>
    <label>
        <input type="radio" name="tickera_email_setting[<?php 
    echo esc_attr( $field_name );
    ?>]" value="yes" <?php 
    checked( $checked, 'yes', true );
    ?> /><?php 
    _e( 'Yes', 'chin' );
    ?>
    </label>
    <label>
        <input type="radio" name="tickera_email_setting[<?php 
    echo esc_attr( $field_name );
    ?>]" value="no" <?php 
    checked( $checked, 'no', true );
    ?> /><?php 
    _e( 'No', 'chin' );
    ?>
    </label>
    <?php 
}

/**
 * wp editor for notification message
 *
 * @param $field_name
 * @param string $default_value
 */
function tc_get_notification_message(  $field_name, $default_value = ''  ) {
    global $tc_email_settings;
    if ( isset( $tc_email_settings[$field_name] ) ) {
        $value = $tc_email_settings[$field_name];
    } else {
        $value = ( $default_value !== '' ? $default_value : '' );
    }
    wp_editor( html_entity_decode( stripcslashes( $value ) ), $field_name, array(
        'textarea_name' => 'tickera_email_setting[' . $field_name . ']',
        'textarea_rows' => 2,
    ) );
}
