/**
 * TO DO (for future releases)
 */

( function( $ ) {

    $( document ).ready( function() {

        var config = {
            apiKey: tc_firebase_vars.apiKey,
            authDomain: tc_firebase_vars.authDomain,
            databaseURL: tc_firebase_vars.databaseURL,
        };

        firebase.initializeApp( config );

        function tc_get_checkedin_seats_results( chart_id ) {

            var ref = firebase.database().ref( '/check-ins/' + chart_id );

            ref.on( "child_added", function( data ) {
                tc_mark_checked_in_seat( chart_id, data.key );
            } );

            ref.on( "child_changed", function( data ) {
                tc_mark_checked_in_seat( chart_id, data.key );
            } );

            ref.on( 'child_removed', function( data ) {
                tc_mark_checked_in_seat_unchecked( chart_id, data.key );
            } );
        }

        tc_get_checkedin_seats_results( tc_firebase_vars.chart_id );

        function tc_mark_checked_in_seat( chart_id, seat_id ) {
            $( '#' + seat_id + '' ).css( { 'background-color': tc_firebase_vars.checkedin_seat_color, 'color': tc_firebase_vars.checkedin_seat_color } );
            $( '#' + seat_id ).addClass( 'tc_seat_checked_in' );
        }

        function tc_mark_checked_in_seat_unchecked( chart_id, seat_id ) {

            let seat = $( '.selectable_row #' + seat_id ),
                ticket_type_id = seat.data( 'tt-id' ),
                seat_color = tc_seat_default_colors[ ticket_type_id ];

            if ( typeof seat_color == "undefined" || '' == seat_color ) {
                seat_color = '#0085BA';
            }

            seat.removeClass( 'tc_seat_checked_in' ).css( { 'background-color': seat_color, 'color': seat_color } );
            tc_controls.tc_mark_reserved_seats( seat_id );
        }
    } );

} )( jQuery );
