<?php

use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

if ( ! class_exists( 'TC_SC_Woo_Blocks_Integration' ) ) {

    class TC_SC_Woo_Blocks_Integration implements IntegrationInterface {

        /**
         * Plugin's name
         * @var string
         */
        private $name;

        /**
         * Plugin's base directory name
         * @var string
         */
        private $dir_name;

        /**
         * Plugin's version
         * @var string
         */
        private $version;

        /**
         * The name of the integration.
         * @return string
         */
        public function get_name() {
            return 'sc-woo-filters';
        }

        /**
         * When called invokes any initialization/setup for the integration.
         */
        public function initialize() {
            $this->name = 'tc-seat-charts';
            $this->dir_name = 'seating-charts';
            $this->version = 1.0;
            $this->register_scripts_styles();
        }

        function register_scripts_styles() {

            $frontend_asset_path = trailingslashit( WP_PLUGIN_DIR ) . $this->dir_name . '/assets/blocks/build/frontend.asset.php';
            $frontend_asset = file_exists( $frontend_asset_path ) ? require $frontend_asset_path : [ 'dependencies' => [], 'version' => $this->get_file_version( $frontend_asset_path ) ];

            // Frontend Styles
            wp_enqueue_style( $this->name . '-block-frontend', plugins_url( '../../assets/blocks/build/style-frontend.css', __FILE__ ), [], $frontend_asset[ 'version' ] );

            // Frontend Scripts
            wp_register_script( $this->name . '-block-frontend', plugins_url( '../../assets/blocks/build/frontend.js', __FILE__ ), $frontend_asset[ 'dependencies' ], $frontend_asset[ 'version' ], true );
            wp_localize_script( $this->name . '-block-frontend', 'tc_seat_charts_block', self::get_translations() );

            // Register main integration
            $script_asset_path = trailingslashit( WP_PLUGIN_DIR ) . $this->dir_name . '/assets/blocks/build/index.asset.php';
            $script_asset = file_exists( $script_asset_path ) ? require $script_asset_path : [ 'dependencies' => [], 'version' => $this->get_file_version( $script_asset_path ) ];
            wp_register_script( $this->name . '-blocks-integration', plugins_url( '../../assets/blocks/build/index.js', __FILE__ ), $script_asset[ 'dependencies' ], $script_asset[ 'version' ], true );
            wp_set_script_translations( $this->name . '-blocks-integration', 'tcsc', dirname( __FILE__ ) . '../../languages' );

            // Extra Script
            wp_register_script( $this->name . '-block-extras', plugins_url( '../../assets/blocks/src/extras.js', __FILE__ ), [ 'jquery' ], $script_asset[ 'version' ], true );
        }

        /**
         * Returns an array of script handles to enqueue in the frontend context.
         */
        public function get_script_handles() {
            return [ $this->name . '-blocks-integration', $this->name . '-block-frontend', $this->name . '-block-extras' ];
        }

        /**
         * Returns an array of script handles to enqueue in the editor context.
         */
        public function get_editor_script_handles() {
            return [];
        }

        /**
         * Get the file modified time as a cache buster if we're in dev mode.
         *
         * @param string $file Local path to the file.
         * @return string The cache buster value to use for the given file.
         */
        protected function get_file_version( $file ) {

            if ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG && file_exists( $file ) ) {
                return filemtime( $file );
            }

            return $this->version;
        }

        /**
         * An array of key, value pairs of data made available to the block on the client side.
         */
        public function get_script_data() {

            // Seats
            $seat_cookie = TC_Seat_Chart::get_cart_seats_cookie();
            $seat_labels = [];
            foreach ( $seat_cookie as $ticket_type_id => $seats ) {
                foreach ( $seats as $seat ) {
                    $seat_labels[ $ticket_type_id ][] = [
                        'chart_id' => $seat[ 2 ],
                        'seat_id' => $seat[ 0 ],
                        'seat_label' => stripslashes( $seat[ 1 ] ),
                        'quantity' => isset( $seat[ 3 ] ) ? (int) $seat[ 3 ] : ''
                    ];
                }
            }

            // Cart Items
            $seat_cart_items = [];
            $wc_cart_items = isset( WC()->cart ) ? WC()->cart->get_cart() : [];

            foreach ( $wc_cart_items as $item_key => $cart_item ) {

                /**
                 * Use this hook to skip cart item loop.
                 * @since 1.1.5
                 */
                if ( ! apply_filters( 'tc_skip_cart_item_loop', false, $cart_item ) ) {

                    $product_id = $cart_item['product_id'];
                    $variation_id = $cart_item['variation_id'];
                    $ticket_type_id = ( $variation_id ) ? wp_get_post_parent_id( $variation_id ) : $product_id;

                    $is_seat = get_post_meta( $ticket_type_id, '_tc_used_for_seatings', true );
                    $is_seat = ( 'yes' == $is_seat ) ? true : false;

                    if ( $is_seat ) {
                        $ticket_type_id = ( $variation_id ) ? $variation_id : $product_id;
                        $seat_cart_items[ $ticket_type_id ] = [
                            'title' => html_entity_decode( get_the_title( $ticket_type_id ) )
                        ];
                    }
                }
            }

            return [ 'seatCartItems' => $seat_cart_items, 'seats' => $seat_labels ];
        }

        protected function get_translations() {

            return [
                'standee_qty' => __( 'Standee qty', 'tcsc' )
            ];
        }
    }
}
