<div class="tc-settings-wrap tc-tables-settings" id="tc-settings">
    <div class="tc-title-wrap">
        <h4><?php esc_html_e( 'Settings', 'tcsc' ); ?></h4>
    </div><!-- .tc-title-wrap -->
    <div class="tc-options-wrap">
        <div class="tc-input-wrap">
            <label>
                <?php esc_html_e( 'Chart Title', 'tcsc' ); ?>
            </label>
            <?php $chart_title = get_the_title( $post->ID ); ?>
            <input type="text" id="tc_chart_title" name="tc_chart_title" value="<?php echo esc_attr( $chart_title ); ?>"/>
        </div><!-- .tc-input-wrap -->
        <div class="tc-input-wrap tc-seat-select">
            <div class="tc-event-wrap">
                <?php
                $events_search = new Tickera\TC_Events_Search( '', '', '-1' );
                $currently_selected = get_post_meta( $post->ID, 'event_name', true );
                $events = $events_search->get_results();

                $event_name = get_post_meta( $post->ID, 'event_name', true );
                $event_name = ( $event_name ) ? $event_name : reset( $events )->ID;

                $event_ids = wp_list_pluck( $events, 'ID' );
                $event_id_exists = in_array( $event_name, $event_ids ) ? true : false;
                ?>
                <input type="hidden" name="event_name_post_meta" id="tc_init_event_id" value="<?php echo esc_attr( $event_name ); ?>"/>
                <select class="tc-event-name">
                    <?php if ( ! $event_id_exists ) : ?>
                        <option value=""><?php esc_html_e( 'Please select an event', 'tcsc' ); ?></option>
                    <?php endif; ?>
                    <?php foreach ( $events as $event ) :
                        $event_obj = new Tickera\TC_Event( (int) $event->ID );
                        $event_object = $event_obj->details;
                        ?>
                        <option value="<?php echo esc_attr( $event->ID ); ?>" <?php selected( $currently_selected, $event_object->ID, true ); ?>><?php echo esc_html( apply_filters( 'tc_event_select_name', $event_object->post_title, $event_object->ID ) ); ?></option>
                    <?php endforeach; ?>
                </select>
            </div><!-- .tc-event-wrap -->
        </div><!-- .tc-seat-select -->
        <div class="tc-clear"></div>
        <button class="tc-change-button" type="submit"><?php _e( 'Change', 'tcsc' ); ?></button>
        <div class="tc-clear"></div>
    </div> <!-- .tc-options-wrap -->
    <?php
    TC_Seat_Chart::get_reserved_seats( $post->ID );
    TC_Seat_Chart::set_event_ticket_types_colors( $post->ID );
    ?>
</div><!-- .tc-settings-wrap -->
