( function( $ ) {

    $( document ).ready( function() {

        window.tc_controls = {

            /**
             * Position dialog at the center of the screen
             *
             * @param element
             * @param arguments
             *
             * @since 0.85
             */
            initModal: function( element, arguments ) {

                let defaults = {
                    width: 100 + '%',
                    innerWidth: 490,
                    resizable: false,
                    draggable: false,
                    height: "auto",
                    modal: true,
                    close: function ( event, ui ) {
                        $( '.tc-group-wrap *' ).removeClass( 'ui-selected' );
                    }
                }

                if ( typeof arguments !== 'undefined' ) {
                    defaults = {
                        ...defaults,
                        ...arguments
                    }
                }

                let dialog = element.dialog( defaults ),
                    modalContainer = dialog.closest( '.ui-dialog' ),
                    controlsContainer = $( '.tc-bottom-controls' );

                // Modal Container
                modalContainer.css( {
                    'top': 0 - controlsContainer.outerHeight() + 'px',
                    'bottom': 0,
                    'left': 0,
                    'right': 0,
                    'display': 'flex',
                    'justify-content': 'center',
                    'align-items': 'center'
                });

                // Dialog container
                dialog.css( {
                    'width': defaults.innerWidth
                });
            },

            centerPoint: function() {

                if ( ! tc_controls_vars.disable_auto_center ) {

                    let pan = $( '.tc-pan-wrapper' ),
                        controlsHeight = $( '.tc-bottom-controls' ).outerHeight();

                    // Calculate horizontal center point
                    let screenWidth = window.innerWidth,
                        panWidth = pan.outerWidth(),
                        centerX = ( screenWidth / 2 ) - ( panWidth / 2 );

                    // Calculate vertical center point
                    let screenHeight = window.innerHeight,
                        panHeight = pan.outerHeight(),
                        centerY = ( ( screenHeight - controlsHeight ) / 2 ) - ( panHeight / 2 );

                    pan.css( { top: centerY + 'px',left: centerX + 'px' } );
                    tc_controls.position_background();
                }
            },

            /**
             * Initialize Legend Widget position
             */
            tc_legend_set: function() {

                let data_blocked_seats = [];

                // Show "Blocked" legend if a blocked seat exists
                $( '.tc_seating_map .tc_blocked_seat' ).each( function() {
                    if ( $( '.tc_blocked_seat_color_status' ).hasClass( 'tc-hidden' ) ) {
                        $( '.tc_blocked_seat_color_status' ).removeClass( 'tc-hidden' );
                    }
                    data_blocked_seats.push( $( this ).attr( 'id' ) );
                } );

                // Initialize a global variable with a list of blocked seats ids.
                window.data_blocked_seats = data_blocked_seats;

                if ( $( '.tc-legend-arrow' ).hasClass( 'tc-legend-open' ) ) {
                    var tc_seating_legend = $( '.tc-seating-legend-wrap' ).outerWidth();
                    $( '.tc-seating-legend-wrap' ).css( 'left', -Math.abs( tc_seating_legend ) );
                }

                var get_window_width = $( window ).width();

                if ( get_window_width < 780 ) {

                    var tc_seating_legend = $( '.tc-seating-legend-wrap' ).outerWidth();

                    $( '.tc-seating-legend-wrap' ).animate( {
                        left: -Math.abs( tc_seating_legend ),
                    }, 0, function() { /* Animation complete. */
                    } );

                    $( '.tc-legend-arrow' ).removeClass( 'tc-legend-close' );
                    $( '.tc-legend-arrow' ).addClass( 'tc-legend-open' );
                }
            },

            /**
             * @since  0.73 and below
             */
            /* centerPointLegacy: function() {

                min_x = false;
                max_x = false;
                min_y = false;
                max_y = false;
                width = 0;
                height = 0;

                $.each( $( '.tc-group-wrap' ), function() {

                    if ( ( $( this ).position().top < min_y ) || min_y == false ) {
                        min_y = $( this ).position().top;
                    }

                    if ( ( ( $( this ).position().top + $( this ).height() ) > max_y ) || max_y == false ) {
                        max_y = ( $( this ).position().top + $( this ).height() );
                    }

                    height = max_y - min_y;

                    if ( ( $( this ).position().left < min_x ) || min_x == false ) {
                        min_x = $( this ).position().left;
                    }

                    if ( ( ( $( this ).position().left + $( this ).width() ) > max_x ) || max_x == false ) {
                        max_x = ( $( this ).position().left + $( this ).width() );
                    }

                    width = max_x - min_x;

                } );

                if ( min_x == false ) {
                    min_x = 0;
                }

                if ( max_x == false ) {
                    max_x = 0;
                }

                if ( min_y == false ) {
                    min_y = 0;
                }

                if ( max_y == false ) {
                    max_y = 0;
                }

                mid_point_x = ( width / 2 );
                mid_point_y = ( height / 2 );
                wrapper_mid_point_x = $( '.tc-wrapper' ).width() / 2;
                wrapper_mid_point_y = $( '.tc-wrapper' ).height() / 2;

                $( '.tc-pan-wrapper' ).css( { left: ( 0 - min_x ) + 'px' } );
                $( '.tc-pan-wrapper' ).css( { left: ( ( wrapper_mid_point_x - min_x ) - mid_point_x ) + 'px' } );
                $( '.tc-pan-wrapper' ).css( { top: ( 0 - min_y ) + 'px' } );
                $( '.tc-pan-wrapper' ).css( { top: ( ( wrapper_mid_point_y - min_y ) - mid_point_y ) + 'px' } );
            },*/

            zoom: function() {

                if ( window.tc_seat_zoom_level <= 1 && window.tc_seat_zoom_level >= 0.30 ) {

                    var prev_value = $( ".tc-zoom-slider" ).slider( "option", "value" );

                    window.tc_seat_zoom_level_prev = prev_value;

                    if ( window.tc_seat_zoom_level_prev < window.tc_seat_zoom_level ) {
                        zoom_level = ( ( window.tc_seat_zoom_level - window.tc_seat_zoom_level_prev ) ) + 1;

                    } else {
                        zoom_level = ( ( window.tc_seat_zoom_level_prev - window.tc_seat_zoom_level ) ) + 1;
                    }

                    if ( ! tc_controls_vars.disable_auto_center ) {
                        $( '.tc-pan-wrapper' ).css( {
                            'webkit-transform-origin': 'center center',
                            'moz-transform-origin': 'center center',
                            'o-transform-origin': 'center center',
                            'transform-origin': 'center center',
                        } );
                    }

                    if ( ! tc_controls_vars.disable_zoom ) {

                        $( '.tc-pan-wrapper' ).css( {
                            'transform': 'scale(' + window.tc_seat_zoom_level + ')',
                            'transition': 'transform 0.3s linear'
                        } );

                        $( ".tc-zoom-slider" ).slider( 'value', window.tc_seat_zoom_level );
                        $( ".tc-wrapper" ).css( {
                            'background-size': ( 80 * window.tc_seat_zoom_level ),
                            'transition': 'transform 0.3s linear',
                        } );
                    }

                    tc_controls.position_background();
                }
            },

            zoom_plus: function() {
                if ( window.tc_seat_zoom_level < 1 ) {
                    window.tc_seat_zoom_level = window.tc_seat_zoom_level + 0.10;
                    tc_controls.zoom();
                }
            },

            zoom_minus: function() {
                if ( window.tc_seat_zoom_level > 0.3 ) {
                    window.tc_seat_zoom_level = window.tc_seat_zoom_level - 0.10;
                    tc_controls.zoom();
                }
            },

            position_zoom_controls: function() {
                var admin_menu_width = $( '#adminmenuwrap' ).width();
                $( '.tc-zoom-wrap' ).css( 'left', admin_menu_width + 15 )
            },

            set_wrapper_height: function() {
                $( '.tc-wrapper' ).height( $( window ).height() );
            },

            position_pan_wrapper: function( position ) {

                let move_val = 50,
                    top = parseFloat( $( '.tc-pan-wrapper' ).css( 'top' ) ),
                    left = parseFloat( $( '.tc-pan-wrapper' ).css( 'left' ) );

                switch ( position ) {

                    case 'up':
                        $( '.tc-pan-wrapper' ).css( 'top', ( top - move_val ) );
                        tc_controls.position_background();
                        break;

                    case 'right':
                        $( '.tc-pan-wrapper' ).css( 'left', ( left + move_val ) );
                        tc_controls.position_background();
                        break;

                    case 'down':
                        $( '.tc-pan-wrapper' ).css( 'top', ( top + move_val ) );
                        tc_controls.position_background();
                        break;

                    case 'left':
                        $( '.tc-pan-wrapper' ).css( 'left', ( left - move_val ) );
                        tc_controls.position_background();
                        break;
                }
            },

            position_background: function() {
                $( ".tc-wrapper" ).css( 'background-position-x', $( '.tc-pan-wrapper' ).css( 'left' ) );
                $( ".tc-wrapper" ).css( 'background-position-y', $( '.tc-pan-wrapper' ).css( 'top' ) );
            },

            init: function() {

                window.tc_seat_zoom_level = parseFloat( tc_controls_vars.front_zoom_level );

                tc_controls.zoom();
                tc_controls.centerPoint();

                $( '.tc-wrapper' ).fadeTo( 600, 1, function() { /* Animation completed. */ } );
            },

            set_default_colors: function() {

                $.each( $( ".tc_set_seat, .tc-object-selectable" ), function() {

                    var ticket_type_id = $( this ).data( 'tt-id' ),
                        tc_seat_color = tc_seat_default_colors[ ticket_type_id ];

                    if ( typeof tc_seat_color == typeof undefined || tc_seat_color == '' ) {
                        tc_seat_color = '#0085BA ';
                    }

                    $( this ).css( { 'background-color': tc_seat_color } );
                    $( this ).css( { 'color': tc_seat_color } );
                } );
            }
        }
    } );

} )( jQuery );
