jQuery( document ).ready( function( $ ) {

    window.tc_background = {

        init: function() {

            if ( tc_background_data.url ) {

                $( '#sc-background-url' ).val( tc_background_data.url );

                $( '.tc-seat-background-slider .tc-number-slider.sc-background-width' ).slider( { value: tc_background_data.width } );
                $( '#sc-background-width' ).val( tc_background_data.width );

                $( '.tc-seat-background-slider .tc-number-slider.sc-background-height' ).slider( { value: tc_background_data.height } );
                $( '#sc-background-height' ).val( tc_background_data.height );

                $( '.tc-pan-wrapper' ).css( {
                    'background-image': 'url(' + tc_background_data.url + ')',
                    'background-repeat': 'no-repeat',
                    'background-size': 'cover',
                    'width': tc_background_data.width + 'px',
                    'height': tc_background_data.height + 'px',
                }).addClass( 'tc-pan-background' );
            }
        },

        apply: function() {

            // Apply only if a background image is set.
            if ( $( '#sc-background-url' ).val() == '' ) {
                return;
            }

            let panWrapper = $( '.tc-pan-wrapper' ),
                panWidth = panWrapper.width(),
                panHeight = panWrapper.height(),
                url = $( '#sc-background-url' ).val(),
                width = $( '#sc-background-width' ).val(),
                height = $( '#sc-background-height' ).val();

            if ( tc_controls.has_background() ) {

                // Background container exists. Update it
                panWrapper.css( {
                    'background-image': 'url(' + url + ')',
                    'background-repeat': 'no-repeat',
                    'background-size': 'cover',
                    'width': width + 'px',
                    'height': height + 'px',
                });

            } else {

                // Background container doesn't exists. Create one
                panWrapper.css( {
                    'background-image': 'url(' + url + ')',
                    'background-repeat': 'no-repeat',
                    'background-size': 'cover',
                    'width': panWidth + 'px',
                    'height': panHeight + 'px'
                }).addClass( 'tc-pan-background' );

                $( '.tc-seat-background-slider .tc-number-slider.sc-background-width' ).slider( { value: panWidth } );
                $( '#sc-background-width' ).val( panWidth );

                $( '.tc-seat-background-slider .tc-number-slider.sc-background-height' ).slider( { value: panHeight } );
                $( '#sc-background-height' ).val( panHeight );
            }
        },

        /**
         * Removes the element with the class `tc-pan-background` from the DOM.
         */
        remove: function() {
            $( '#sc-background-url' ).val( '' );
            $( '.tc-seat-background-slider .tc-number-slider' ).slider( { value: 0 } );
            $( '.tc-seat-background-slider .sc-background-field' ).val( 0 )

            $( '.tc-pan-wrapper' ).css( {
                'background-image': '',
                'background-repeat': '',
                'background-size': ''
            }).removeClass( 'tc-pan-background' );

            tc_controls.set_pan_wrapper_dimension();
        }
    }
} );
