## Submitting issues

### Reduced test case required

All bug reports and problem issues require a [**reduced test case**](http://css-tricks.com/reduced-test-cases/). Create one by forking any one of the [CodePen examples](http://codepen.io/desandro/tag/isotope-docs) from [the docs](http://isotope.metafizzy.co).

**CodePens**

+ [Filtering](http://codepen.io/desandro/pen/Ehgij)
+ [Sorting](http://codepen.io/desandro/pen/lzCqe)
+ [Filtering and sorting](http://codepen.io/desandro/pen/nFrte)
+ [Masonry layout](http://codepen.io/desandro/pen/mEinp)
+ [Fluid Masonry layout](http://codepen.io/desandro/pen/mIkhq)

**Test cases**

+ A reduced test case clearly demonstrates the bug or issue.
+ It contains the bare minimum HTML, CSS, and JavaScript required to demonstrate the bug.
+ A link to your production site is **not** a reduced test case.

Providing a reduced test case is the best way to get your issue addressed. Without a reduced test case, your issue may be closed.

## Support

+ Having trouble setting up Isotope?
+ Running into a time-consuming problem?

[CodersClan has a dedicated support forum for Isotope](https://www.codersclan.net/?repo_id=1), where you can get personal support from experienced developers.

#### [Get support on CodersClan](https://www.codersclan.net/?repo_id=1)

## Pull requests

Contributions are welcome!

Your code may be used as part of a commercial product if merged. Be clear about what license applies to your patch. [The MIT license](http://choosealicense.com/licenses/mit/) or [public domain unlicense](http://choosealicense.com/licenses/unlicense/) are permissive, and allow integration of your patch into Isotope as part of a commercial product.

Do not edit `dist/` files. I'll update these after your PR has been merged.

### Development setup / Sandbox

After a fresh git clone, to run the examples in sandbox, you will first need to run (from the root directory):

```shell
$ npm install bower
$ bower install
```
