<?php

/**
 * Identify a ticket type's `Used for Seatings` option whether it is set or not.
 * @param $ticket_type_id
 * @return mixed|void
 *
 * @since 1.1.6
 */
function tcsc_ticket_type_is_used_for_seatings( $ticket_type_id ) {
    $is_seat = get_post_meta( $ticket_type_id, '_tc_used_for_seatings', true );
    $is_seat = ( 'yes' == $is_seat ) ? true : false;
    return apply_filters( 'tcsc_ticket_type_is_used_for_seatings', $is_seat, $ticket_type_id );
}

/**
 * Shortcode option for the shortcode builder
 */
function show_tc_seat_chart_attributes() { ?>
    <table id="tc-seat-chart-shortcode" class="shortcode-table" style="display:none">
        <tr>
            <th scope="row"><?php _e( 'Select a Seating Chart', 'tcsc' ); ?></th>
            <td>
                <?php
                $seat_charts = get_posts( [
                    'post_type' => 'tc_seat_charts',
                    'post_status' => 'publish',
                    'posts_per_page' => -1,
                    'no_found_rows' => true
                ] );
                ?>
                <select name="id">
                    <?php foreach ( $seat_charts as $seat_chart ) { ?>
                        <option value="<?php echo esc_attr( $seat_chart->ID ); ?>"><?php echo $seat_chart->post_title; ?></option>
                    <?php } ?>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Show Legend', 'tcsc' ); ?></th>
            <td>
                <select name="show_legend">
                    <option value="true"><?php _e( 'Yes', 'tcsc' ); ?></option>
                    <option value="false"><?php _e( 'No', 'tcsc' ); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Button Title', 'tcsc' ); ?></th>
            <td>
                <input type="text" name="button_title" value="<?php _e( 'Pick your seat(s)', 'tcsc' ); ?>">
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Subtotal Title', 'tcsc' ); ?></th>
            <td>
                <input type="text" name="subtotal_title" value="<?php _e( 'Subtotal', 'tcsc' ); ?>">
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e( 'Cart Title', 'tcsc' ); ?></th>
            <td>
                <input type="text" name="cart_title" value="<?php _e( 'Go to Cart', 'tcsc' ); ?>">
            </td>
        </tr>
    </table>
    <?php
}

/**
 * Render option yes or no
 *
 * @param string $field_name
 * @param string $post_id
 */
function tcsc_yes_no( $field_name = '', $post_id = '' ) {
    $currently_selected = ( $post_id ) ? get_post_meta( $post_id, $field_name, true ) : 'no';
    $currently_selected = ( $currently_selected ) ? $currently_selected : 'no'; ?>
    <label for="<?php echo esc_attr( $field_name ); ?>">
        <input type="radio" id="<?php echo esc_attr( $field_name ); ?>" name="<?php echo esc_attr( $field_name ); ?>_post_meta" value="yes" <?php checked( $currently_selected, 'yes', true ); ?>/><?php _e( 'Yes', 'tc' ) ?>
    </label>
    <label for="<?php echo esc_attr( $field_name ); ?>">
        <input type="radio" id="<?php echo esc_attr( $field_name ); ?>" name="<?php echo esc_attr( $field_name ); ?>_post_meta" value="no" <?php checked( $currently_selected, 'no', true ); ?>/><?php _e( 'No', 'tc' ) ?>
    </label><?php
}

/**
 * Render Chart ID hidden input in Checkout page
 *
 * @param string $field_name
 * @param string $post_id
 * @param string $ticket_type_id
 * @param string $quantity
 * @param string $owner_index
 * @since 0.81
 */
function tcsc_render_checkout_chart_id_field( $field_name = '', $post_id = '', $ticket_type_id = '', $quantity = '', $owner_index = '' ) {
    $cart_seats = TC_Seat_Chart::get_cart_seats_cookie();
    if ( isset( $cart_seats[ $ticket_type_id ][ $owner_index ] ) ) {
        $seat = $cart_seats[ $ticket_type_id ][ $owner_index ];
        $chart_id = isset( $seat[ 2 ] ) ? $seat[ 2 ] : '';
        $quantity = ( isset( $seat[ 3 ] ) && $seat[ 3 ] ) ? $seat[ 3 ] : 1;
        for ( $i = 1; $i <= $quantity; $i++ ) : ?>
        <input type="hidden" name="<?php echo esc_attr('owner_data_chart_id_post_meta[' . $ticket_type_id . '][]'); ?>" value="<?php echo (int) $chart_id; ?>" />
        <?php
        endfor;
    }
}

/**
 * Render Seat ID hidden input in Checkout page
 *
 * @param string $field_name
 * @param string $post_id
 * @param string $ticket_type_id
 * @param string $quantity
 * @param string $owner_index
 * @since 0.81
 */
function tcsc_render_checkout_seat_id_field( $field_name = '', $post_id = '', $ticket_type_id = '', $quantity = '', $owner_index = '' ) {
    $cart_seats = TC_Seat_Chart::get_cart_seats_cookie();
    if ( isset( $cart_seats[ $ticket_type_id ][ $owner_index ] ) ) {
        $seat = $cart_seats[ $ticket_type_id ][ $owner_index ];
        $seat_id = isset( $seat[ 0 ] ) ? $seat[ 0 ] : '';
        $quantity = ( isset( $seat[ 3 ] ) && $seat[ 3 ] ) ? $seat[ 3 ] : 1;
        for ( $i = 1; $i <= $quantity; $i++ ) : ?>
        <input type="hidden" name="<?php echo esc_attr('owner_data_seat_id_post_meta[' . $ticket_type_id . '][]'); ?>" value="<?php echo esc_attr( $seat_id ); ?>" />
        <?php
        endfor;
    }
}

/**
 * Render Seat Label hidden input in Checkout page
 *
 * @param string $field_name
 * @param string $post_id
 * @param string $ticket_type_id
 * @param string $quantity
 * @param string $owner_index
 * @since 0.81
 */
function tcsc_render_checkout_seat_label_field( $field_name = '', $post_id = '', $ticket_type_id = '', $quantity = '', $owner_index = '' ) {
    $cart_seats = TC_Seat_Chart::get_cart_seats_cookie();
    if ( isset( $cart_seats[ $ticket_type_id ][ $owner_index ] ) ) {
        $seat = $cart_seats[ $ticket_type_id ][ $owner_index ];
        $seat_label = isset( $seat[ 1 ] ) ? $seat[ 1 ] : '';
        $quantity = ( isset( $seat[ 3 ] ) && $seat[ 3 ] ) ? $seat[ 3 ] : 1;
        for ( $i = 1; $i <= $quantity; $i++ ) : ?>
        <input type="hidden" name="<?php echo esc_attr('owner_data_seat_label_post_meta[' . $ticket_type_id . '][]'); ?>" value="<?php echo esc_attr( $seat_label ); ?>" />
        <?php
        endfor;
    }
}
