jQuery( document ).ready( function ( $ ) {

    $('body').on( 'click', '#tc-table .tc_seat_table_type_square', function ( e ) {
        var init_seat_num = parseInt( $('#tc_table_seats_num').val() ),
            init_max_end_seats = Math.floor( init_seat_num / 2 ),
            init_end_seats = parseInt( $('#tc_table_end_seats').val() );

        if ( init_end_seats > init_max_end_seats ) {
            $( '#tc_table_end_seats' ).val( '0' );
            $( '#tc-table .tc-number-slider.tc_table_end_seats' ).slider( 'value', '0' );
        }
        $( '#tc-table .tc-number-slider.tc_table_end_seats' ).slider( 'option', { max: init_max_end_seats } );
    });

    $( 'body' ).on( 'click', '#tc-table #tc_add_table_button', function ( e ) {

        e.preventDefault();

        if ( 'circle' == $( 'input:radio[name=tc_seat_table_type]:checked' ).val() ) {
            tc_table.create_rounded_table( false );

        } else {
            tc_table.create_square_table( false );
        }
    });

    $( 'body' ).on( 'click', '.tc-table-wrap .tc-group-controls .tc-icon-edit', function ( e ) {
        e.preventDefault();
        tc_table.edit_mode( $(this) );
    });

    $( 'body' ).on( 'click', '#tc_edit_table_button', function ( e ) {
        e.preventDefault();
        tc_table.edit();
    });

    $( 'body' ).on( 'click', '#tc_cancel_table_button', function ( e ) {
        e.preventDefault();
        tc_table.cancel_edit();
    });

    window.tc_table = {

        edit: function () {

            if ( 'circle' == $('input:radio[name=tc_seat_table_type]:checked').val() ) {
                tc_table.create_rounded_table( true );

            } else {
                tc_table.create_square_table( true );
            }
        },

        cancel_edit: function () {
            $( '#tc-seat-labels-settings' ).hide();
            $( '.tc-sidebar' ).tabs( { collapsible: true, active: false } );
            tc_controls.hide_ticket_type_box();
            tc_controls.unselect_all();
        },

        /**
         * Creates new text element
         *
         * @returns {undefined}
         */
        create_square_table: function ( edit ) {

            var empty_class = 'tc-empty-header',
                rotation = 0;

            if ( true == edit ) {

                var holder = $( '.tc-table-wrap.tc-edit-mode' ),
                    holder_top = holder.css( 'top' ),
                    holder_left = holder.css( 'left' );

                rotation = tc_table.getRotationDegrees( holder.find( '.tc-table-group' ) );
            }

            var grid_size = 5,
                title = $( '#tc-table .tc_table_title' ).val(),
                table_html = '',
                numNodes = parseInt( $( '#tc_table_seats_num' ).val() ),
                nodeSize = 24,
                seat_margin = 3,
                end_seats_count = parseInt( $( '.tc_table_end_seats_value' ).val() ),
                left_seats_count = Math.floor( ( numNodes - end_seats_count * 2 ) / 2 ),
                right_seats_count = numNodes - ( ( end_seats_count * 2 ) + left_seats_count ),
                tc_table_color = $( '.tc-table-color-picker .tc-color-picker' ).val();

            var side_seats_count = ( right_seats_count >= left_seats_count ) ? right_seats_count : left_seats_count,
                table_width = ( end_seats_count * 30 ) - 6,
                table_height = ( side_seats_count * 30 ) - 6;

            table_width = ( table_width <= 24 ) ? 24 : table_width;
            table_height = ( table_height <= 24 ) ? 24 : table_height;

            if ( '' == title ) {
                title = '&nbsp;';

            } else {
                empty_class = '';
            }

            var seat_size = 24,
                style_sizes = 'style="width: ' + ( table_width + 34 ) + 'px; height: ' + ( table_height + 45 ) + 'px;"',
                rotation_style = '-moz-transform:rotate(' + rotation + 'deg);-webkit-transform:rotate(' + rotation + 'deg);-o-transform:rotate(' + rotation + 'deg);-ms-transform:rotate(' + rotation + 'deg);',
                group_style = 'width: ' + ( table_width + 34 ) + 'px; height: ' + ( table_height + 45 ) + 'px;',
                tc_table_style_sizes = 'style="width: ' + ( table_width + 34 ) + 'px; height: ' + ( table_height + 50 ) + 'px;"',
                tc_table_group_sizes = 'style="width: ' + ( table_width + 34 ) + 'px; height: ' + ( table_height + 130 ) + 'px;"',
                table_seats = tc_table.draw_square_table_seats( end_seats_count, left_seats_count, right_seats_count, nodeSize, seat_margin, table_width, table_height, edit );

            table_html += '<div class="tc-group-wrap tc-group-tables-square tc-table-wrap" ' + style_sizes + ' data-end-seats="' + end_seats_count + '">';
            table_html += '<div class="tc-table-group tc-group-background" style="' + group_style + ' ' + rotation_style + '">';
            table_html += '<div class="tc-heading ' + empty_class + '">';
            table_html += '<h3>' + title + '</h3>';
            table_html += '</div>';
            table_html += '<div class="tc-table-wrap"><div class="tc-table" ' + tc_table_style_sizes + '>';
            table_html += '<div class="tc-table-square-element" style="width: ' + table_width + 'px; height: ' + table_height + 'px; background-color:' + tc_table_color + ';">' + table_seats + '</div>';
            table_html += '</div><!-- .tc-object --></div>';
            table_html += '<div class="tc-group-controls"><span class="tc-icon-edit"></span><span class="tc-icon-trash"></span><span class="tc-icon-copy"></span><span class="tc-icon-bring-to-front"></span></div></div>';
            table_html += '</div>';
            table_html += '</div>';

            var table = table_html,
                new_element = tc_table.add_to_canvas( table, new Array(1, 1), true );

            // Recalculate sizes based on the input data
            var title_height = new_element.find( '.tc-heading' ).height(),
                table_height = new_element.find( '.tc-table-wrap' ).height();

            if ( new_element.find( '.tc-heading' ).hasClass( 'tc-empty-header' ) ) {
                new_element.find( '.tc-heading.tc-empty-header' ).css( { 'position': 'absolute', 'top': 0, 'left': 0 } );
                $( new_element ).find( '.tc-group-tables-square' ).height( table_height );
                $( new_element ).find( '.tc-table-group' ).height( table_height );

            } else {
                $( new_element ).find( '.tc-group-tables-square' ).height( title_height + table_height );
                $( new_element ).find( '.tc-table-group' ).height( title_height + table_height );
            }

            if ( true == edit ) {
                holder.remove();
                new_element.css({
                    'top': holder_top,
                    'left': holder_left,
                    'position': 'absolute',
                    'z-index': 0
                });
                new_element.addClass( 'tc-edit-mode' );

            } else {
                tc_controls.center( $( new_element ) );
            }

            try {

                $( new_element ).find( '.tc-table-group' ).rotatable({
                    start: function( event, ui ) {
                        $( this ).parent().addClass( 'tc-rotated' ).css({ 'height': 0 });
                    }
                });

                $( new_element ).find( '.tc-table' ).selectable({
                    filter: '.tc-table-chair',
                    cancel: '.tc_seat_reserved',
                    stop: function ( event, ui ) {
                        tc_controls.show_ticket_type_box( event, ui );
                        $( '#tc-block-seat-wrap' ).show();
                    }
                });

                $( new_element ).draggable({
                    grid: [grid_size, grid_size],
                    handle: $(new_element).find('.tc-heading'),
                    start: function (event, ui) {
                        ui.position.left = 0;
                        ui.position.top = 0;
                    },
                    drag: function ( event, ui ) {

                        var changeLeft = ui.position.left - ui.originalPosition.left, // Find change in left
                            newLeft = ( ui.originalPosition.left + changeLeft ) / window.tc_seat_zoom_level, // Adjust new left by our zoomScale
                            changeTop = ui.position.top - ui.originalPosition.top, // Find change in top
                            newTop = (ui.originalPosition.top + changeTop) / window.tc_seat_zoom_level; // Adjust new top by our zoomScale

                        ui.position.left = newLeft;
                        ui.position.top = newTop;
                    }
                });

            } catch ( e ) {
                return null;
            }
        },

        create_rounded_table: function ( edit ) {

            let rotation = 0,
                empty_class = 'tc-empty-header';

            if ( true == edit ) {

                var holder = $( '.tc-table-wrap.tc-edit-mode' ),
                    holder_top = holder.css( 'top' ),
                    holder_left = holder.css( 'left' );

                rotation = tc_table.getRotationDegrees( holder.find( '.tc-table-group' ) );
            }

            var grid_size = 5,
                title = $( '#tc-table .tc_table_title' ).val(),
                title_height = $( '#tc-table .tc_table_title' ),
                table_html = '',
                numNodes = $( '#tc_table_seats_num' ).val(),
                radius = ( numNodes * 24 ) / 5;

            radius = ( radius < 40 ) ? 40 : radius;

            if ( '' == title ) {
                title = '&nbsp;';

            } else {
                empty_class = '';
            }

            var seat_size = 24,
                style_sizes = 'style="width: ' + ( ( radius * 2 ) + 34 ) + 'px; height: ' + ( ( radius * 2 ) + 45 ) + 'px;"',
                group_style = 'width: ' + ( ( radius * 2 ) + 34 ) + 'px; height: ' + ( ( radius * 2 ) + 45 ) + 'px;',
                rotation_style = '-moz-transform:rotate(' + rotation + 'deg);-webkit-transform:rotate(' + rotation + 'deg);-o-transform:rotate(' + rotation + 'deg);-ms-transform:rotate(' + rotation + 'deg);',
                tc_table_style_sizes = 'style="width: ' + ( ( radius * 2 ) + 34 ) + 'px; height: ' + ( ( ( radius * 2 ) + 30 ) ) + 'px;"',
                tc_table_color = $( '.tc-table-color-picker .tc-color-picker' ).val(),
                table_seats = tc_table.draw_rounded_table_seats( numNodes, radius, edit ),
                table_element_size = ( radius * 2 ) - seat_size - 4;

            table_html += '<div class="tc-group-wrap tc-group-tables-rounded tc-table-wrap" ' + style_sizes + '>';
            table_html += '<div class="tc-table-group tc-rounded-table-group tc-group-background" style="' + group_style + ' ' + rotation_style + '">';
            table_html += '<div class="tc-heading ' + empty_class + '">';
            table_html += '<h3>' + title + '</h3>';
            table_html += '</div>';
            table_html += '<div class="tc-table-wrap"><div class="tc-table" ' + tc_table_style_sizes + '>';
            table_html += table_seats;
            table_html += '<div class="tc-table-element" style="width: ' + table_element_size + 'px; height: ' + table_element_size + 'px; background-color: ' + tc_table_color + ';">';
            table_html += '</div><!--tc-table-element-->';
            table_html += '</div><!-- .tc-table --></div>';
            table_html += '<div class="tc-group-controls"><span class="tc-icon-edit"></span><span class="tc-icon-trash"></span><span class="tc-icon-copy"></span><span class="tc-icon-bring-to-front"></span></div></div>';
            table_html += '</div>';
            table_html += '</div>';

            var table = table_html,
                new_element = tc_table.add_to_canvas( table, new Array( 1, 1 ), true );

            // Recalculate sizes based on the input data
            let header_height = new_element.find( '.tc-heading' ).height(),
                table_height = new_element.find( '.tc-table-wrap' ).height();

            if ( new_element.find( '.tc-heading' ).hasClass( 'tc-empty-header' ) ) {
                new_element.find( '.tc-heading.tc-empty-header' ).css( { 'position': 'absolute', 'top': 0, 'left': 0 } );
                $( new_element ).find( '.tc-group-tables-rounded' ).height( table_height );
                $( new_element ).find( '.tc-rounded-table-group' ).height( table_height );

            } else {
                new_element.find( '.tc-group-tables-rounded' ).height( header_height + table_height );
                new_element.find( '.tc-rounded-table-group' ).height( header_height + table_height );
            }

            if ( true == edit ) {

                holder.remove();
                new_element.css({
                    'top': holder_top,
                    'left': holder_left,
                    'position': 'absolute',
                    'z-index': 0
                });
                new_element.addClass( 'tc-edit-mode' );

            } else {
                tc_controls.center( $( new_element ) );
            }

            try {

                $( new_element ).find( '.tc-table-group' ).rotatable({
                    start: function( event, ui ) {
                        $( this ).parent().addClass( 'tc-rotated' ).css({ 'height': 0 });
                    }
                });

                $( new_element ).find( '.tc-table' ).selectable({
                        filter: '.tc-table-chair',
                        cancel: '.tc_seat_reserved',
                        stop: function ( event, ui ) {
                            tc_controls.show_ticket_type_box( event, ui );
                            $( '#tc-block-seat-wrap' ).show();
                        }
                    }
                );

                $( new_element ).draggable( {

                    grid: [grid_size, grid_size],
                    handle: $( new_element ).find( '.tc-heading' ),
                    start: function ( event, ui ) {
                        ui.position.left = 0;
                        ui.position.top = 0;
                    },
                    drag: function ( event, ui ) {

                        var changeLeft = ui.position.left - ui.originalPosition.left, // Find change in left
                            newLeft = ( ui.originalPosition.left + changeLeft ) / window.tc_seat_zoom_level, // Adjust new left by our zoomScale
                            changeTop = ui.position.top - ui.originalPosition.top, // Find change in top
                            newTop = ( ui.originalPosition.top + changeTop ) / window.tc_seat_zoom_level; // Adjust new top by our zoomScale

                        ui.position.left = newLeft;
                        ui.position.top = newTop;
                    }
                });

            } catch (e) {
                return null;
            }
        },

        /**
         * Delete an element
         *
         * @param {type} element_obj
         * @returns {undefined}
         */
        delete: function ( element_obj ) {
            tc_controls.delete_confirmation( element_obj.parent().parent().parent() );
        },

        /**
         * Bring element to front
         *
         * @param {type} element_obj
         * @returns {undefined}
         */
        bringToFront: function ( element_obj ) {

            let groupWrap = element_obj.closest( '.tc-group-wrap' ),
                zIndex = 1;

            if ( typeof groupWrap.attr( 'data-zindex' ) !== 'undefined' ) {
                zIndex = parseInt( groupWrap.attr( 'data-zindex' ) ) + 1;
            }

            groupWrap.attr( 'data-zindex', zIndex );
        },

        /**
         * Make a copy of an element
         *
         * @param {type} element_obj
         * @returns {undefined}
         */
        copy: function ( element_obj ) {
            // To do
        },

        /**
         * Appends HTML to the wrapper / adds new element on the canvas
         *
         * @param {type} html
         * @param {type} position
         * @param {type} draggable
         * @returns {Window.tc_text.add_to_canvas.element|window.tc_text.add_to_canvas.element|window.$|$}
         */
        add_to_canvas: function ( html, position, draggable ) {
            var element = $( html );
            element.appendTo( '.tc-wrapper .tc-pan-wrapper' );
            return element;
        },

        draw_rounded_table_seats: function (numNodes, radius, edit) {

            if ( true == edit ) {

                var holder = $('.tc-table-wrap.tc-edit-mode'),
                    old_items = new Array(),
                    current_old_item = 1;

                holder.find( '.tc-table-chair' ).each( function () {

                    old_items[ current_old_item ] = new Array();
                    let item_classes = $(this).attr( 'class' ),
                        background_color = $(this).css( 'background-color' ),
                        ticket_type = $(this).attr('data-tt-id');

                    item_classes = item_classes.replace( 'tc-table-chair', '' );
                    item_classes = item_classes.replace( 'ui-selectee', '' );

                    if ( ticket_type == null || 'undefined' == ticket_type ) {
                        background_color = false;
                        ticket_type = false;
                    }

                    old_items[current_old_item].push(item_classes + '|' + background_color + '|' + ticket_type);
                    current_old_item++;
                });
            }

            var nodes = tc_table.create_rounded_table_nodes( numNodes, radius ),
                html = '',
                node_style = '',
                next_part_no = tc_controls.next_part_number(),
                no = 1;

            for ( var key in nodes ) {

                var obj = nodes[key];

                node_style = '';

                if ( !nodes.hasOwnProperty( key ) )
                    continue;

                if ( true == edit ) {

                    let last_id = holder.find( '.tc-table-chair' ).attr( 'id' );
                    next_part_no = ( typeof last_id !== 'undefined' ) ? parseInt( last_id.split('_')[2] ) : next_part_no;

                    if ( typeof old_items[no] === 'undefined' ) {
                        node_style = 'style="top: ' + (obj['y']).toFixed(2) + 'px; left: ' + (obj['x']).toFixed(2) + 'px;"';
                        html += '<div class="tc-table-chair" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '"></div>';

                    } else {

                        // Old item exists
                        var old_items_values = old_items[no].toString();
                        old_items_values = old_items_values.split('|');

                        let item_classes = old_items_values[0],
                            background_color = old_items_values[1],
                            ticket_type = old_items_values[2];

                        background_color = ( background_color != 'false' ) ? 'background-color:' + background_color + ';' : '';
                        ticket_type = ( ticket_type !== 'false' ) ? 'data-tt-id="' + ticket_type + '"' : '';

                        node_style = 'style="top: ' + (obj['y']).toFixed(2) + 'px; left: ' + (obj['x']).toFixed(2) + 'px;' + background_color + '"';
                        html += '<div class="tc-table-chair ' + item_classes + '" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '" ' + ticket_type + '></div>';
                    }

                } else {
                    node_style = 'style="top: ' + (obj['y']).toFixed(2) + 'px; left: ' + (obj['x']).toFixed(2) + 'px;"';
                    html += '<div class="tc-table-chair" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '"></div>';
                }
                no++;
            }

            return html;
        },

        create_rounded_table_nodes: function ( numNodes, radius ) {

            var nodes = [],
                width = (radius * 2),
                height = (radius * 2),
                angle,
                x,
                y,
                i;

            for ( i = 0; i < numNodes; i++ ) {
                angle = (i / (numNodes / 2)) * Math.PI; // Calculate the angle at which the element will be placed.
                x = (radius * Math.cos(angle)) + (width / 2); // Calculate the x position of the element.
                y = (radius * Math.sin(angle)) + (width / 2); // Calculate the y position of the element.
                nodes.push({'id': i, 'x': x + 5, 'y': (y + 3), 'angle': angle, 'radius': radius});
            }

            return nodes;
        },

        draw_square_table_seats: function ( end_seats_count, left_seats_count, right_seats_count, nodeSize, seat_margin, table_width, table_height, edit ) {

            var rotation = 0;

            if ( true == edit ) {

                var holder = $( '.tc-table-wrap.tc-edit-mode' ),
                    old_items = new Array(),
                    current_old_item = 1;

                holder.find( '.tc-table-chair' ).each( function () {

                    old_items[current_old_item] = new Array();

                    let item_classes = $(this).attr( 'class' );

                    item_classes = item_classes.replace("tc-table-chair", "");
                    item_classes = item_classes.replace("ui-selectee", "");

                    let background_color = $(this).css('background-color'),
                        ticket_type = $(this).attr('data-tt-id');

                    if ( ticket_type == null || ticket_type == 'undefined' ) {
                        background_color = false;
                        ticket_type = false;
                    }

                    old_items[current_old_item].push( item_classes + '|' + background_color + '|' + ticket_type );
                    current_old_item++;
                });
            }

            var nodes = tc_table.create_square_table_nodes( end_seats_count, left_seats_count, right_seats_count, nodeSize, seat_margin, table_width, table_height ),
                html = '',
                node_style = '',
                next_part_no = tc_controls.next_part_number(),
                no = 1;

            for ( var key in nodes ) {

                var obj = nodes[key];
                node_style = '';

                if ( !nodes.hasOwnProperty( key ) )
                    continue;

                if ( true == edit ) {

                    var last_id = holder.find( '.tc-table-chair' ).attr('id');
                    next_part_no = ( typeof last_id !== 'undefined' ) ? parseInt( last_id.split('_')[2] ) : next_part_no;

                    if ( typeof old_items[no] === 'undefined' ) {
                        node_style = 'style="top: ' + ( obj['y'] ).toFixed(2) + 'px; left: ' + ( obj['x'] ).toFixed(2) + 'px;"';
                        html += '<div class="tc-table-chair" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '"></div>';

                    } else {

                        // Old item exists
                        var old_items_values = old_items[no].toString();
                        old_items_values = old_items_values.split('|');

                        let item_classes = old_items_values[0],
                            background_color = old_items_values[1],
                            ticket_type = old_items_values[2];

                        background_color = ( background_color != 'false' ) ? 'background-color:' + background_color + ';' : '';
                        ticket_type = ( ticket_type !== 'false' ) ? 'data-tt-id="' + ticket_type + '"' : '';

                        node_style = 'style="top: ' + (obj['y']).toFixed(2) + 'px; left: ' + (obj['x']).toFixed(2) + 'px;' + background_color + '"';
                        html += '<div class="tc-table-chair ' + item_classes + '" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '" ' + ticket_type + '></div>';
                    }

                } else {
                    node_style = 'style="top: ' + (obj['y']).toFixed(2) + 'px; left: ' + (obj['x']).toFixed(2) + 'px;"';
                    html += '<div class="tc-table-chair" ' + node_style + ' id="tc_seat_' + next_part_no + '_' + no + '"></div>';
                }

                no++;
            }

            return html;
        },

        create_square_table_nodes: function ( end_seats_count, left_seats_count, right_seats_count, nodeSize, seat_margin, table_width, table_height ) {

            var nodes = [],
                x,
                y,
                t,
                b,
                l,
                r;

            // Top chairs
            var t_x = 0;
            for ( t = 0; t < end_seats_count; t++ ) {
                nodes.push( { 'id': t, 'x': t_x, 'y': -30 } );
                t_x = t_x + 30;
            }

            // Bottom chairs
            var b_x = 0;
            for ( b = 0; b < end_seats_count; b++ ) {
                nodes.push( { 'id': b, 'x': b_x, 'y': table_height + 5 } );
                b_x = b_x + 30;
            }

            // Left chairs
            var l_y = 0;
            for ( l = 0; l < left_seats_count; l++) {
                nodes.push( { 'id': l, 'x': -30, 'y': l_y } );
                l_y = l_y + 30;
            }

            // Right chairs
            var r_y = 0;
            for ( r = 0; r < right_seats_count; r++ ) {
                nodes.push( { 'id': r, 'x': table_width + 5, 'y': r_y } );
                r_y = r_y + 30;
            }

            return nodes;
        },

        getRotationDegrees: function ( obj ) {
            var matrix = obj.css( "-webkit-transform" ) ||
                obj.css("-moz-transform") ||
                obj.css("-ms-transform") ||
                obj.css("-o-transform") ||
                obj.css("transform");

            if ( matrix !== 'none' ) {
                var values = matrix.split('(')[1].split(')')[0].split(','),
                    a = values[0],
                    b = values[1],
                    angle = Math.round(Math.atan2(b, a) * (180 / Math.PI));

            } else {
                var angle = 0;
            }

            return angle;
        },

        edit_mode: function ( obj ) {

            // Remove all previous "edit mode" classes
            $('.tc-group-wrap').removeClass('tc-edit-mode');

            // Mark that object is in the edit mode
            var holder = obj.parent().parent().parent(),
                title = holder.find('.tc-heading h3').html();

            if ( '&nbsp;' == title ) {
                title = '';
            }

            // Check if there are some reserved seats
            if ( holder.find('.tc_seat_reserved').length ) {
                $('#tc-table .tc-input-slider').hide();

            } else {
                $('#tc-table .tc-input-slider').show();
            }

            var seats = holder.find('.tc-table-chair').length,
                end_seats = holder.attr('data-end-seats'),
                background_color = holder.find('.tc-table-element').css('background-color');

            if ( background_color == null || 'undefined' == background_color ) {
                background_color = holder.find('.tc-table-square-element').css('background-color');
            }

            $('#tc-table .wp-picker-input-wrap .tc-color-picker').val( background_color );
            $('#tc-table .wp-color-result').css( { 'background-color': background_color } );

            if ( isNaN( end_seats ) ) {
                tc_seat_table_type = 'circle';
                $('.tc-select-shape-round').click();

            } else {
                tc_seat_table_type = 'square';
                $('.tc-select-shape-box').click();
                $("#tc-table .tc-slider-value.tc_table_end_seats_value").val(end_seats);

                var max_end_seats = Math.floor(seats / 2);

                $("#tc-table .tc-number-slider.tc_table_end_seats").slider('option', {max: max_end_seats});
                $("#tc-table .tc-number-slider.tc_table_end_seats").slider('value', end_seats);
            }

            $("#tc-table .tc-slider-value.tc_table_seats_num_value").val(seats);
            $("#tc-table .tc-number-slider.tc_table_seats_num").slider('value', seats);

            holder.addClass('tc-edit-mode');

            $('#tc-table .tc_table_title').val( title );
            $(".tc-sidebar").tabs( { collapsible: true, active: 3 } );
            $('#tc-table .tc_table_edit_controls').show();
            $('#tc-table .tc_table_add_controls').hide();
            tc_controls.hide_ticket_type_box();
        },

        init: function () {

            var grid_size = 5;

            // Init square table
            $( '.tc-group-wrap.tc-group-tables-square' ).each( function () {

                $( this ).find( '.tc-icon-rotate' ).remove();

                $( this ).find( '.tc-table-group' ).rotatable({
                    start: function( event, ui ) {
                        $( this ).parent().addClass( 'tc-rotated' ).css({ 'height': 0 });
                    }
                });

                $( this ).find( '.tc-table' ).selectable({
                    filter: '.tc-table-chair',
                    cancel: '.tc_seat_reserved',
                    stop: function ( event, ui ) {
                        tc_controls.show_ticket_type_box( event, ui );
                        $( '#tc-block-seat-wrap' ).show();
                    }
                });

                $( this ).draggable({
                    grid: [grid_size, grid_size],
                    handle: $( this ).find( '.tc-heading' ),
                    start: function ( event, ui ) {
                        ui.position.left = 0;
                        ui.position.top = 0;
                    },
                    drag: function ( event, ui ) {

                        var changeLeft = ui.position.left - ui.originalPosition.left, // Find change in left
                            newLeft = (ui.originalPosition.left + changeLeft) / window.tc_seat_zoom_level, // Adjust new left by our zoomScale
                            changeTop = ui.position.top - ui.originalPosition.top, // Find change in top
                            newTop = (ui.originalPosition.top + changeTop) / window.tc_seat_zoom_level; // Adjust new top by our zoomScale

                        ui.position.left = newLeft;
                        ui.position.top = newTop;
                    }
                });
            });

            // Init rounded table
            $( '.tc-group-wrap.tc-group-tables-rounded' ).each( function () {

                $( this ).find( '.tc-icon-rotate' ).remove();

                $( this ).find( '.tc-table-group' ).rotatable({
                    start: function( event, ui ) {
                        $( this ).parent().addClass( 'tc-rotated' ).css({ 'height': 0 });
                    }
                });

                $( this ).find( '.tc-table' ).selectable({
                    filter: '.tc-table-chair',
                    cancel: '.tc_seat_reserved',
                    stop: function ( event, ui ) {
                        tc_controls.show_ticket_type_box( event, ui );
                        $( '#tc-block-seat-wrap' ).show();
                    }
                });

                $( this ).draggable({
                    grid: [grid_size, grid_size],
                    handle: $( this ).find( '.tc-heading' ),
                    start: function ( event, ui ) {
                        ui.position.left = 0;
                        ui.position.top = 0;
                    },
                    drag: function ( event, ui ) {

                        var changeLeft = ui.position.left - ui.originalPosition.left, // Find change in left
                            newLeft = ( ui.originalPosition.left + changeLeft ) / window.tc_seat_zoom_level, // Adjust new left by our zoomScale
                            changeTop = ui.position.top - ui.originalPosition.top, // Find change in top
                            newTop = ( ui.originalPosition.top + changeTop ) / window.tc_seat_zoom_level; // adjust new top by our zoomScale

                        ui.position.left = newLeft;
                        ui.position.top = newTop;
                    }
                });
            });
        }
    }
});
