<?php

/**
 * Sanitize array values
 *
 * @param array $array
 * @return array
 */
function tcch_sanitize_array( $array ) {

    if ( ! is_array( $array ) ) {
        return $array;
    }

    $sanitized_array = [];

    foreach ( $array as $key => $value ) {

        // Sanitize Key without affecting case sensitivity
        $key = preg_replace( '/[^a-zA-Z0-9_\-]/', '', $key );

        if ( is_array( $value ) ) {
            $sanitized_array[ $key ] = tcch_sanitize_array( $value );

        } else {
            $value = sanitize_text_field( $value );
            $sanitized_array[ $key ] = $value;
        }
    }

    return $sanitized_array;
}