<?php
global $wp_rewrite;

wp_reset_vars( array( 'action', 'page' ) );
$page = $_GET['page'];
$tab = ( isset( $_GET['tab'] ) && ! empty( $_GET['tab'] ) ) ? $_GET['tab'] : 'general';

if ( isset( $_POST[ 'save_tc_checkinera_settings' ] ) ) {

    if ( check_admin_referer( 'save_settings' ) ) {

        if ( current_user_can( 'manage_options' ) || current_user_can( 'save_settings_cap' ) ) {

            update_option( 'tc_checkinera_settings', CHK_Fields::sanitize_array( $_POST[ 'tc_checkinera_settings' ] ) );
            do_action( 'tc_save_tc_general_settings' );

            $wp_rewrite->flush_rules();
            $message = __( 'Settings data has been successfully saved.', 'tc_ch');

        } else {
            $message = __( 'You do not have required permissions for this action.', 'tc_ch' );
        }
    }
} ?>
<div class="wrap tc_wrap tc_outside_wrap nosubsub">
    <?php if ( isset( $message ) ) : ?>
        <div id="message" class="updated fade"><p><?php echo $message; ?></p></div>
    <?php endif;

    $sections	= TC_Checkinera_Settings::get_settings_sections();
    $fields = TC_Checkinera_Settings::get_checkinera_fields();

    $checkinera_setting_url = add_query_arg( array(
        'post_type'	 => 'tc_events',
        'page'		 => $_GET[ 'page' ],
        'tab'		 => isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : '',
    ), admin_url( 'edit.php' )
    ); ?>
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tc-general-settingsss" method="post" action="<?php echo $checkinera_setting_url; ?>">
            <?php if ( ! chk_fs()->can_use_premium_code() ) : ?>
                <p style="text-align: center; font-size: 20px; color: #000;"><?php _e( 'Please activate the valid license.', 'tc_ch' ); ?></p>
            <?php else : ?>
                <?php foreach ( $sections as $section ) : ?>
                    <div id="checkinera_colors" class="postbox">
                        <h3><span><?php echo $section['title']; ?></span></h3>
                        <div class="inside">
                            <?php wp_nonce_field( 'save_settings' ); ?>
                            <table class="form-table"><?php

                                $tc_array_borders = array( 'highlights_color_checkinera', 'menu_active_color_checkinera', 'background_color_checkinera', 'checkin_button_color_checkinera' );

                                foreach ( $fields as $field ) {

                                    if ( isset( $field[ 'section' ] ) && $field[ 'section' ] == $section[ 'name' ] ) {

                                        $tc_bottom_border = '';

                                        if ( in_array( $field['field_name'], $tc_array_borders ) ) {
                                            $tc_bottom_border = 'tc_bottom_border';
                                        } ?>
                                        <tr valign="top" id="<?php echo esc_attr( $field['field_name'] . '_holder' ); ?>" <?php CHK_Fields::conditionals( $field ); ?>>
                                            <th scope="row"><label for="<?php echo esc_attr( $field['field_name'] ); ?>"><?php echo $field['field_title']; ?><?php ( isset( $field['tooltip'] ) ? CHK_Fields::tooltip( $field['tooltip'] ) : '' ); ?></label></th>
                                            <td>
                                                <?php do_action( 'tc_before_settings_general_field_type_check', $field ); ?>
                                                <?php CHK_Fields::render_field( $field, 'tc_checkinera_settings' ); ?>
                                                <?php do_action( 'tc_after_settings_general_field_type_check', $field ); ?>
                                            </td>
                                        </tr>
                                    <?php }
                                } ?>
                            </table>
                        </div><!-- .tc-inside -->
                    </div>
                <?php endforeach; ?>
                <?php submit_button( __( 'Save Settings' ), 'primary', 'save_tc_checkinera_settings' ); ?>
                <div class="clear"></div>
            <?php endif; ?>
        </form>
    </div>
</div>
