( function ( $ ) {

    window.tc_csv_export = {

        filteredEvents: [],
        filteredTicketTypes: [],

        /**
         * Retrieve recently filtered/selected event id
         *
         * @param arr1
         * @param arr2
         * @returns {boolean}
         */
        array_diff: function( arr1, arr2 ) {

            if ( typeof arr1 === 'undefined' || typeof arr2 === 'undefined' ) {
                return false;
            }

            return arr1.filter( x => !arr2.includes( x ) );
        },

        /**
         * @param needle
         * @param haystack
         * @returns indexOf
         */
        in_array: function( needle, haystack ) {

            if ( typeof needle === 'undefined' || typeof haystack === 'undefined' || ! Array.isArray( haystack ) ) {
                return false;
            }

            for ( let i = 0; i < haystack.length; i++ ) {

                let value = haystack[ i ];

                if ( needle == value ) {
                    return i;
                }
            }

            return false;
        },

        get_ticket_types_collection: function() {

            $.post( tc_csv_vars.ajaxUrl, { action: 'tc_get_ticket_type', ids: $('#tc_export_csv_event_data').val() }, function( response ) {

                if ( typeof response !== 'undefined' && !response.error ) {

                    let ticket_ids = [],
                        i = 0;

                    $('#tc_export_csv_ticket_type_data').next().show();
                    $('#tc_export_csv_ticket_type_data').attr( 'disabled', false );
                    $('#no_ticket_type').hide();

                    // Empty select field on load
                    $('#tc_export_csv_ticket_type_data').empty();

                    // Initialize and option with 'All'
                    $('#tc_export_csv_ticket_type_data').append( '<option value="all" selected>' + tc_csv_vars.select_all + '</option>' );

                    // Propagate Ticket Options
                    $.each( response.ticket_types, function ( key, value ) {

                        // Capturing the mark from the server end. This will avoid auto sorting of json response
                        let replaced_key = key.replace( 'TC', '' );
                        ticket_ids[i] = replaced_key;
                        $('#tc_export_csv_ticket_type_data').append( '<option value="'+ replaced_key +'">'+ value +'</option>' );
                        i++;
                    });

                    // Update Chosen Select Field
                    $('#tc_export_csv_ticket_type_data').trigger('chosen:updated');

                } else {
                    $('#tc_export_csv_ticket_type_data').next().hide();
                    $('#tc_export_csv_ticket_type_data').attr( 'disabled', true );

                    if ( !$('#no_ticket_type').length ) {
                        $('#tc_export_csv_ticket_type_data').parent().append("<div id='no_ticket_type'><p>"+tc_csv_vars.ticket_type_message+"</p></div>");

                    } else {
                        $('#no_ticket_type').show();
                    }
                }

                $( '#tc_form_attendees_csv_export' ).removeClass( 'tccsv-loading' );
            });
        },

        export_csv_attendees_post: function () {

            var progressLabel = $( ".progress-label" );

            $( "#csv_export_progressbar" ).show();

            $.post( tc_csv_vars.ajaxUrl, $( "#tc_form_attendees_csv_export" ).serialize() )
                .done( function( response ) {

                    if ( typeof response.page !== 'undefined' ) {

                        $( '#page_num' ).val( response.page );

                        if ( false === response.done ) {

                            $( "#csv_export_progressbar" ).progressbar( {
                                value: response.exported,
                                change: function() {
                                    progressLabel.text( $( "#csv_export_progressbar" ).progressbar( "value" ) + "%" );
                                }
                            } );

                            tc_csv_export.export_csv_attendees_post();

                        } else {

                            $( "#csv_export_progressbar" ).progressbar( {
                                value: 100,
                                change: function() {
                                    $( "#csv_export_progressbar" ).text( '' );
                                }
                            } );

                            $( "#csv_export_progressbar" ).hide();
                            $( '#page_num' ).val( 1 );

                            if( response.found_posts > 0 ){

                                $('.export_error').remove();
                                window.location = tc_csv_vars.ajaxUrl + '?action=tc_export_csv&document_title=' + encodeURIComponent( $( '#document_title' ).val() );

                            } else {
                                $('.export_error').remove();
                                $('#tc_form_attendees_csv_export .inside').after('<div class="export_error"><p>'+tc_csv_vars.attendee_list_error+'</p></div>');
                            }
                        }
                    }
                } );
        }
    }

    /**
     * Propagate Ticket Types field on page load
     */
    $( document ).on( 'ready', function() {

        tc_csv_export.filteredEvents = $( '#tc_export_csv_event_data' ).val();
        tc_csv_export.filteredTicketTypes = $( '#tc_export_csv_ticket_type_data' ).val();

        $('#tc_export_csv_ticket_type_data').next().show();
    });

    /**
     * Events filter
     * Propagate Ticket Types field on event field change.
     * If "all" value selected, remove other pre-selected values.
     */
    $( document ).on( 'change', '#tc_export_csv_event_data', function() {

        $( '#tc_form_attendees_csv_export' ).addClass( 'tccsv-loading' );

        let recently_filtered_event_id = tc_csv_export.array_diff( $( this ).val(), tc_csv_export.filteredEvents );

        if ( recently_filtered_event_id.length ) {

            if ( 'all' == recently_filtered_event_id[ 0 ] ) {
                $( this ).find( 'option' ).prop( 'selected', false );
                $( this ).find( 'option[value="all"]' ).prop( 'selected', true );

            } else {
                $( this ).find( 'option[value="all"]' ).prop( 'selected', false );
            }
        }


        $( this ).trigger( 'chosen:updated' );

        tc_csv_export.filteredEvents = $( this ).val();
        tc_csv_export.filteredTicketTypes = [ 'all' ];

        tc_csv_export.get_ticket_types_collection();
    });

    /**
     * Ticket types filter
     * If "all" value selected, remove other pre-selected values.
     */
    $( document ).on( 'change', '#tc_export_csv_ticket_type_data', function() {

        let recently_filtered_ticket_type_id = tc_csv_export.array_diff( $( this ).val(), tc_csv_export.filteredTicketTypes );

        if ( recently_filtered_ticket_type_id.length ) {

            if ( 'all' == recently_filtered_ticket_type_id[ 0 ] ) {
                $( this ).find( 'option' ).prop( 'selected', false );
                $( this ).find( 'option[value="all"]' ).prop( 'selected', true );

            } else {
                $( this ).find( 'option[value="all"]' ).prop( 'selected', false );
            }
        }

        $( this ).trigger( 'chosen:updated' );
        tc_csv_export.filteredTicketTypes = $( this ).val();
    } );

    $( document ).on( 'click', '#tc_select_all_csv', function() {
        var tc_select_all = $(this).prop('checked');
        $("#tc_form_attendees_csv_export input[type=checkbox]").each(function() {
            $(this).prop("checked", tc_select_all);
        });
    });

    $( document ).on( 'click', '#export_csv_event_data', function( e ) {
        e.preventDefault( );
        tc_csv_export.export_csv_attendees_post();
    });

})( jQuery );