( function( $ ) {

    $( window ).ready( function() {

        // Responsive thickbox
        var tc_maxwidth = 600,
            tc_maxheight = 400;

        $( window ).on( 'resize', function() {

            let tc_width = window.innerWidth - 40;
            if ( tc_width > tc_maxwidth ) {
                tc_width = tc_maxwidth;
            }

            let tc_height = window.innerHeight - 50;
            if ( tc_height > tc_maxheight ) {
                tc_height = tc_maxheight;
            }

            $( '.thickbox' ).each( function() {
                let type = $( this ).hasClass( 'tc-privacy-policy' ) ? 'tc_privacy_content' : 'tc_terms_content',
                    href = "#TB_inline?width=" + tc_width + "&height=" + tc_height + "&inlineId=" + type;
                $( this ).attr( 'href', href );
            });
        } );

        $( document ).ready( function() {
            $( window ).trigger( 'resize' );
        } );
    } );

    /**
     * Bridge for Woocommerce
     */
    $( document ).on( 'change', '.tc-terms-conditions-policy', function() {

        if ( $( this ).is( ':checked' ) ) {
            $( this ).closest( 'label' ).find( '.tc_term_error' ).removeClass( 'has-error' );

        } else {
            $( this ).closest( 'label' ).find( '.tc_term_error' ).addClass( 'has-error' );
        }
    } );

    /**
     * Validate Terms and Conditions and Privacy Policy on Place Order
     * Bridge for Woocommerce
     */
    $( 'form.checkout' ).on( 'checkout_place_order', function( event ) {
        let hasError = false;
        $( '.tc-terms-conditions-policy' ).each( function() {
            let container =  $( this );
            if ( container.is( ':checked' ) ) {
                container.closest( 'label' ).find( '.tc_term_error' ).removeClass( 'has-error' );
            } else {
                hasError = true;
                container.closest( 'label' ).find( '.tc_term_error' ).addClass( 'has-error' );
                $( 'html, body' ).stop().animate( { 'scrollTop': ( container.offset().top ) - 200 }, 350, 'swing', function() { window.location.hash = container.attr( 'id' ); });
            }
        });

        if ( hasError ) {
            event.preventDefault();
            return false;
        }
    } );


    /**
     * Tickera Standalone
     */
    $( document ).ready( function( event ) {

        /**
         * Validate Terms and conditions on proceed to checkout action.
         * Validate Privacy Policy on proceed to checkotu action.
         */
        $( "#proceed_to_checkout" ).click( function( event ) {

            $( '.tc-terms-conditions-policy' ).each( function() {

                if ( $( this ).is( ':checked' ) ) {
                    $( this ).closest( 'label' ).find( '.tc_term_error' ).removeClass( 'has-error' );

                } else {
                    event.preventDefault();
                    $( this ).closest( 'label' ).find( '.tc_term_error' ).addClass( 'has-error' );
                }
            });
        } );

        /**
         * Show Error message if either of the terms and conditions and privacy policy is unchecked
         */
        $( '.tc-terms-conditions-policy' ).on( 'click', function() {

            if ( $( this ).is( ':checked' ) ) {
                $( this ).closest( 'label' ).find( '.tc_term_error' ).removeClass( 'has-error' );

            } else {
                $( this ).closest( 'label' ).find( '.tc_term_error' ).addClass( 'has-error' );
            }
        });
    })
} )( jQuery );
