<?php

namespace Tickera\Gateway;
use Tickera\TC_Gateway_API;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'Tickera\Gateway\TC_Gateway_Beanstream' ) ) {

    class TC_Gateway_Beanstream extends TC_Gateway_API {

        var $plugin_name = 'beanstream';
        var $admin_name = '';
        var $public_name = '';
        var $force_ssl;
        var $ipn_url;
        var $skip_form = false;
        var $currency;
        var $skip_payment_screen = false;
        var $permanently_active = false;
        var $mode;
        var $merchant_id;
        var $api_access;
        var $currencies;

        /**
         * Support for older payment gateway API
         */
        function on_creation() {
            $this->init();
        }

        function init() {
            global $tc;

            $this->method_img_url = apply_filters( 'tc_gateway_method_img_url', $tc->plugin_url . 'images/gateways/beanstream.png', $this->plugin_name );
            $this->admin_img_url = apply_filters( 'tc_gateway_admin_img_url', $tc->plugin_url . 'images/gateways/small-beanstream.png', $this->plugin_name );

            $this->admin_name = __( 'Beanstream ', 'tickera-event-ticketing-system' );
            $this->public_name = __( 'Beanstream ', 'tickera-event-ticketing-system' );

            $this->mode = $this->get_option( 'mode ', 'sandbox' );
            $this->merchant_id = $this->get_option( 'merchant_id' );
            $this->api_access = $this->get_option( 'api_access' );
            $this->force_ssl = $this->mode == 'sandbox' ? false : true;

            $this->currency = $this->get_option( 'currency', 'USD' );

            $this->currencies = array(
                "CAD" => __( 'CAD - Canadian Dollar', 'tickera-event-ticketing-system' ),
                "EUR" => __( 'EUR - Euro', 'tickera-event-ticketing-system' ),
                "GBP" => __( 'GBP - British Pound', 'tickera-event-ticketing-system' ),
                "USD" => __( 'USD - United States Dollar', 'tickera-event-ticketing-system' ),
            );
        }

        function payment_form( $cart ) {

            $name = $this->buyer_info( 'full_name' );

            $content = '<table class = "cart_billing">';
            $content .= '<thead><tr>';
            $content .= '<th colspan = "2">' . esc_html__( 'Enter Your Credit Card Information: ', 'tickera-event-ticketing-system' ) . '</th>';
            $content .= '</tr></thead>';
            $content .= '<tbody>';
            $content .= '<tr>';
            $content .= '<td align = "right">' . esc_html__( 'Cardholder Name: ', 'tickera-event-ticketing-system' ) . '</td><td>';
            $content .= '<input id = "tcbs_cc_name" name = "' . esc_attr( $this->plugin_name ) . '_cc_name" type = "text" value = "' . esc_attr( $name ) . '" /> </td>';
            $content .= '</tr>';
            $content .= '<tr>';
            $content .= '<td align = "right">';
            $content .= esc_html__( 'Card Number', 'tickera-event-ticketing-system' );
            $content .= '</td>';
            $content .= '<td>';
            $content .= '<input type = "text" autocomplete = "off" name = "' . esc_attr( $this->plugin_name ) . '_cc_number" id = "' . esc_attr( $this->plugin_name ) . '_cc_number"/>';
            $content .= '</td>';
            $content .= '</tr>';
            $content .= '<tr>';
            $content .= '<td align = "right">';
            $content .= esc_html__( 'Expiration: ', 'tickera-event-ticketing-system' );
            $content .= '</td>';
            $content .= '<td>';
            $content .= '<select id = "' . esc_attr( $this->plugin_name ) . '_cc_month" name = "' . esc_attr( $this->plugin_name ) . '_cc_month">';
            $content .= tickera_months_dropdown();
            $content .= '</select>';
            $content .= '<span> / </span>';
            $content .= '<select id = "' . esc_attr( $this->plugin_name ) . '_cc_year" name = "' . esc_attr( $this->plugin_name ) . '_cc_year">';
            $content .= tickera_years_dropdown( '', false );
            $content .= '</select>';
            $content .= '</td>';
            $content .= '</tr>';
            $content .= '<tr>';
            $content .= '<td align = "right">';
            $content .= esc_html__( 'CVC: ', 'tickera-event-ticketing-system' );
            $content .= '</td>';
            $content .= '<td>';
            $content .= '<input id = "' . esc_attr( $this->plugin_name ) . '_cc_cvc" name = "' . esc_attr( $this->plugin_name ) . '_cc_cvc" type = "text" maxlength = "4" autocomplete = "off" value = ""/>';
            $content .= '</td>';
            $content .= '</tr>';
            $content .= '</table>';
            return $content;
        }

        function process_payment( $cart ) {
            global $tc;
            tickera_final_cart_check( $cart );
            $this->save_cart_info();

            include_once( 'beanstream/Gateway.php' );
            include_once( 'beanstream/Exception.php' );

            $order_id = $tc->generate_order_id();
            $total = $this->total();

            $beanstream = new \Beanstream\Gateway( $this->merchant_id, $this->api_access, 'www', 'v1' );

            $payment_data = array(
                'order_number' => $order_id,
                'amount' => $total,
                'payment_method' => 'card',
                'card' => array(
                    'name' => $this->buyer_info( 'full_name' ),
                    'number' => sanitize_text_field( $_POST[ $this->plugin_name . '_cc_number' ] ),
                    'expiry_month' => sanitize_text_field( $_POST[ $this->plugin_name . '_cc_month' ] ),
                    'expiry_year' => sanitize_text_field( $_POST[ $this->plugin_name . '_cc_year' ] ),
                    'cvd' => sanitize_text_field( $_POST[ $this->plugin_name . '_cc_cvc' ] )
                )
            );

            try {

                $result = $beanstream->payments()->makeCardPayment( $payment_data, TRUE ); //set to FALSE for Pre-Auth

                if ( $result[ 'approved' ] ) {

                    $payment_info = $this->save_payment_info();

                    $paid = true;
                    $tc->create_order( $order_id, $this->cart_contents(), $this->cart_info(), $payment_info, $paid );
                    tickera_redirect( $tc->get_confirmation_slug( true, $order_id ), true );

                } else {
                    $this->add_error( 'We\'re very sorry but the card you entered was not approved.' );
                    return false;
                }
            } catch ( \Beanstream\Exception $e ) {
                $this->add_error( sprintf(
                /* translators: %s: Beanstream exception error message. */
                    __( '<li>There was an error processing your card: "%s".</li>', 'tickera-event-ticketing-system' ),
                    esc_html( $e->getMessage() )
                ) );
                return false;
            }
        }

        function gateway_admin_settings( $settings, $visible ) {
            global $tc;
            ?>
            <div id="<?php echo esc_attr( $this->plugin_name ); ?>" class="postbox" <?php echo wp_kses_post( ! $visible ? 'style="display:none;"' : '' ); ?>>
                <h3>
                    <span><?php echo esc_html( sprintf( /* translators: %s: BeanStream Payment Gateway admin name */ __( '%s Settings', 'tickera-event-ticketing-system' ), esc_html( $this->admin_name ) ) ); ?></span>
                    <span class="description"><?php esc_html_e( 'Sell your tickets via Beanstream', 'tickera-event-ticketing-system' ); ?></span>
                </h3>
                <div class="inside">

                    <?php
                    $fields = array
                    (
                        'mode' => array(
                            'title' => __( 'Mode', 'tickera-event-ticketing-system' ),
                            'type' => 'select',
                            'description' => '',
                            'default' => 'sandbox',
                            'options' => array(
                                'sandbox' => __( 'Sandbox / Test' ),
                                'live' => __( 'Live' )
                            ),
                        ),
                        'merchant_id' => array(
                            'title' => __( 'Merchant ID', 'tickera-event-ticketing-system' ),
                            'type' => 'text',
                            'description' => '',
                            'default' => '',
                        ),
                        'api_access' => array(
                            'title' => __( 'API access passcode', 'tickera-event-ticketing-system' ),
                            'type' => 'text',
                            'description' => '',
                            'default' => '',
                        ),
                        'currency' => array(
                            'title' => __( 'Currency', 'tickera-event-ticketing-system' ),
                            'type' => 'select',
                            'description' => __( 'Selecting a currency other than that used for your store may cause problems at checkout.', 'tickera-event-ticketing-system' ),
                            'default' => 'USD',
                            'options' => $this->currencies
                        ), );

                    $form = new \Tickera\TC_Form_Fields_API( $fields, 'tc', 'gateways', $this->plugin_name );
                    ?>
                    <table class="form-table">
                        <?php $form->admin_options(); ?>
                    </table>
                </div>
            </div>
            <?php
        }
    }

    \Tickera\tickera_register_gateway_plugin( 'Tickera\Gateway\TC_Gateway_Beanstream', 'beanstream', __( 'Beanstream', 'tickera-event-ticketing-system' ) );
}