<?php

if ( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

Tickera\tets_fs()->add_filter( 'show_deactivation_feedback_form', '__return_false' );

/**
 * Deprecated function "tc_get_license_key".
 * @since 3.5.3.0
 */
if ( ! function_exists( 'tickera_get_license_key' ) ) {

    function tickera_get_license_key() {

        @$fr_license_key = \Tickera\tets_fs()->_get_license()->secret_key;

        if ( !empty( $fr_license_key ) ) {
            return $fr_license_key;

        } else {
            $tc_general_settings = get_option( 'tickera_general_setting', false );
            $license_key = ( defined( 'TC_LCK' ) && TC_LCK !== '' ) ? TC_LCK : ( isset( $tc_general_settings[ 'license_key' ] ) && $tc_general_settings[ 'license_key' ] !== '' ? $tc_general_settings[ 'license_key' ] : '' );
            return $license_key;
        }
    }
}

/**
 * Deprecated function "tc_get_license_email".
 * @since 3.5.3.0
 */
if ( ! function_exists( 'tickera_get_license_email' ) ) {

    function tickera_get_license_email() {

        @$fr_user = \Tickera\tets_fs()->get_user()->email;

        if ( !empty( $fr_user ) ) {
            return $fr_user;

        } else {
            return get_option( 'admin_email' );
        }
    }
}

Tickera\tets_fs()->add_action( 'addons/after_title', 'tickera_add_fs_templates_addons_poststuff_before_bundle_message_and_link' );

/**
 * Deprecated function "tc_add_fs_templates_addons_poststuff_before_bundle_message_and_link".
 * @since 3.5.3.0
 */
if ( ! function_exists( 'tickera_add_fs_templates_addons_poststuff_before_bundle_message_and_link' ) ) {

    function tickera_add_fs_templates_addons_poststuff_before_bundle_message_and_link() {

        if ( tickera_iw_is_wl() == false ) : ?>
            <div class="updated"><p><?php echo wp_kses_post( __( 'NOTE: All add-ons are included for FREE with the <a href="https://tickera.com/pricing/?utm_source=plugin&utm_medium=upsell&utm_campaign=addons" target="_blank">Bundle Package</a>', 'tickera-event-ticketing-system' ) ); ?></p></div>
        <?php endif;
    }
}

/**
 * Deprecated function "tc_members_account_url".
 * @since 3.5.3.0
 */
if ( ! function_exists( 'tickera_members_account_url' ) ) {

    function tickera_members_account_url() {
        return 'https://tickera.com/members';
    }
}

Tickera\tets_fs()->add_filter( 'pricing_url', 'tickera_members_account_url' );

/**
 * Deprecated function "tc_is_pr_only".
 * @since 3.5.3.0
 */
if ( ! function_exists( 'tickera_is_pr_only' ) ) {

    function tickera_is_pr_only () {
        if ( Tickera\tets_fs()->is__premium_only() ) {
            return true;
        }
        return false;
    }
}

if ( Tickera\tets_fs()->is__premium_only() ) {

    add_action( 'admin_init', 'tickera_check_fs_license_key' );

    /**
     * Deprecated function "tc_fr_opt_in".
     * @since 3.5.3.0
     */
    if ( ! function_exists( 'tickera_fr_opt_in' ) ) {

        function tickera_fr_opt_in( $license_key ) {

            if ( !empty( $license_key ) ) {
                $license_key = mb_substr( $license_key, 0, 32, 'utf-8' ); //get first 32 characters

                //$opt_in_response = \Tickera\tets_fs()->opt_in(false, false, false, $license_key);
                //$opt_in_response = \Tickera\tets_fs()->opt_in( false, false, false, $license_key, false, false, false, null, fs_is_network_admin() ? \Tickera\tets_fs()->get_sites_for_network_level_optin() : array() );
                try {
                    $opt_in_response = \Tickera\tets_fs()->activate_migrated_license( $license_key );

                    if ( !tets_fs()->can_use_premium_code() ) {
                        //license key is wrong, will consider that migration is done anyway so we don't hit the server multiple times
                        update_option( 'tickera_migrated2fs', 3 );
                        return false;
                    } else {
                        //license key is valid so we'll redirect user to the event page
                        update_option( 'tickera_migrated2fs', 2 );
                        return true;
                    }
                } catch ( Exception $e ) {
                    //in case of Exception, we'll consider that license key isn't valid (it could be added manually in this case)
                    update_option( 'tickera_migrated2fs', 4 );//we'll save it as 4 to know that there was an error / exception
                    return false;
                }
            }
        }
    }

    /**
     * Deprecated function "tc_check_fs_license_key".
     * @since 3.5.3.0
     */
    if ( ! function_exists( 'tickera_check_fs_license_key' ) ) {

        function tickera_check_fs_license_key() {

            if ( 1 == get_option( 'tc_migrated2fs', 1 ) ) {
                if ( Tickera\tets_fs()->has_api_connectivity() && ! Tickera\tets_fs()->is_registered() ) {
                    $license_key = tickera_get_license_key();

                    if ( !empty( $license_key ) ) {
                        if ( tickera_fr_opt_in( $license_key ) ) {
                            if ( fs_is_network_admin() ) {
                                wp_redirect( network_admin_url( 'plugins.php' ) );
                            } else {
                                wp_redirect( admin_url( 'edit.php?post_type=tc_events' ) );
                            }
                            exit;
                        }
                    }
                }
            }
        }
    }
}
