( function ( $ ) {

    const tclist = {

        get_formatted_date: function( dateFormat ) {

            let formattedDate = 'mm/dd/yy';

            switch( dateFormat ) {

                case 'Y-m-d':
                    formattedDate = 'yy-mm-dd';
                    break;

                case 'm/d/Y':
                    formattedDate = 'mm/dd/yy';
                    break;

                case 'd/m/Y':
                    formattedDate = 'dd/mm/yy';
                    break;

                case 'jS F Y':
                    formattedDate = 'd MM yy';
                    break;

                case 'F j, Y':
                    formattedDate = 'MM d, yy'
                    break;
            }

            return formattedDate;
        }
    };

    $( document ).ready( function () {

        $( '.tc-multiple-select' ).multiselect();

        var tc_show_past_events = $( '#tc_show_past_events' ).val(),
            dateToday = ( 'true' == tc_show_past_events || 1 == tc_show_past_events ) ? '' : new Date(); // Check to see if to show past dates in the calendar

        $( '.tc-event-datepicker' ).datepicker({
            dateFormat: tclist.get_formatted_date( tc_values.date_format ),
            minDate: dateToday,
            beforeShow: function (input, inst) {
                $( '#ui-datepicker-div' ).addClass( 'tc-tickera-calendar' );
            }
        });

        /**
         * Get events depending on the values passed
         */
        function tc_filter_events() {

            $( '.tc-event-listing-container' ).each( function() {

                var event_container = $( this ),
                    display_filter_events = event_container.find( '.tc-display-filter-events' ),
                    pagination_number = event_container.find( '#tc_pagination_number' );

                display_filter_events.removeClass( 'tc-remove-spinner' );
                display_filter_events.html( '<span class="tc-listing-loader"><span class="tc-loader-inner"></span></span>' );

                var tc_selected_category_value = event_container.find( '#tc_category_ids' ).val(),
                    tc_categories = [],
                    tc_categories = event_container.find( '#tc_event_categories' ).val(),
                    tc_start_date = event_container.find( '#tc_start_date' ).val(),
                    tc_end_date = event_container.find( '#tc_end_date' ).val(),
                    tc_column_number = event_container.find( '#tc_number_of_columns' ).val(),
                    tc_show_excerpt = event_container.find( '#tc_show_excerpt' ).val(),
                    tc_show_number_of_posts = event_container.find( '#tc_show_number_of_posts' ).val(),
                    tc_pagination_number = pagination_number.val(),
                    tc_show_default_featured_image = event_container.find( '#tc_show_default_featured_image' ).val(),
                    tc_show_past_events = event_container.find( '#tc_show_past_events' ).val(),
                    tc_order_events_by = event_container.find( '#tc_order_events_by' ).val();

                $.ajax({
                    type: 'post',
                    dataType: 'text',
                    url: tc_values.ajaxurl,
                    data: {
                        action: 'tc_filter_events',
                        tc_categories: tc_categories,
                        tc_start_date: tc_start_date,
                        tc_end_date: tc_end_date,
                        tc_column_number: tc_column_number,
                        tc_show_excerpt: tc_show_excerpt,
                        tc_show_number_of_posts: tc_show_number_of_posts,
                        tc_pagination_number: tc_pagination_number,
                        tc_show_default_featured_image: tc_show_default_featured_image,
                        tc_selected_category_values: tc_selected_category_value,
                        tc_show_past_events: tc_show_past_events,
                        tc_order_events_by: tc_order_events_by
                    },

                    success: function ( response ) {

                        display_filter_events.empty();
                        display_filter_events.addClass( 'tc-remove-spinner' );
                        display_filter_events.html( response );

                        event_container.find( '.tc-events-wrap .pagination a' ).click( function ( e ) {

                            e.preventDefault();

                            if ( $( this ).hasClass( 'prev' ) ) {
                                var get_page_num = $( this ).closest( 'ul.page-numbers' ).find( '.page-numbers.current' ).parent().prev().text();

                            } else if ( $( this ).hasClass( 'next' ) ) {
                                var get_page_num = $( this ).closest( 'ul.page-numbers' ).find( '.page-numbers.current' ).parent().next().text();

                            } else {
                                var get_page_num = $( this ).text();
                            }

                            pagination_number.val( get_page_num );
                            tc_filter_events();
                        });
                    }
                });
            });
        }

        tc_filter_events();

        /**
         * Filter the Events
         */
        $( '#filter_events' ).click( function ( e ) {
            e.preventDefault();
            var tc_pagination_number = $( '#tc_pagination_number' ).val( 1 );
            tc_filter_events();
        });
    });
})( jQuery );
