<?php

/**
 * Plugin Name: Tickera Mailchimp
 * Plugin URI: http://tickera.com/
 * Description: Tickera MailChimp Newsletter add-on allows you to send marketing emails, automated messages, and targeted campaigns to your customers.
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.4.8

 * Update URI: https://api.freemius.com
 * Text Domain: tc-mailchimp
 * Domain Path: /languages/
 * Copyright 2019 Tickera (http://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
if ( !function_exists( 'tcmn_fs' ) ) {
    // Create a helper function for easy SDK access.
    function tcmn_fs() {
        global $tcmn_fs;
        if ( !isset( $tcmn_fs ) ) {
            // Activate multisite network integration.
            if ( !defined( 'WP_FS__PRODUCT_3175_MULTISITE' ) ) {
                define( 'WP_FS__PRODUCT_3175_MULTISITE', true );
            }
            // Include Freemius SDK.
            if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php' ) ) {
                // Try to load SDK from parent plugin folder.
                require_once dirname( dirname( __FILE__ ) ) . '/tickera-event-ticketing-system/freemius/start.php';
            } else {
                if ( file_exists( dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php' ) ) {
                    // Try to load SDK from premium parent plugin folder.
                    require_once dirname( dirname( __FILE__ ) ) . '/tickera/freemius/start.php';
                } else {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
            }
            $tcmn_fs = fs_dynamic_init( array(
                'id'               => '3175',
                'slug'             => 'mailchimp-newsletter',
                'premium_slug'     => 'mailchimp-newsletter',
                'type'             => 'plugin',
                'public_key'       => 'pk_eff989814cc25fcd6cafabe8c455b',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'parent'           => array(
                    'id'         => '3102',
                    'slug'       => 'tickera-event-ticketing-system',
                    'public_key' => 'pk_7a38a2a075ec34d6221fe925bdc65',
                    'name'       => 'Tickera',
                ),
                'menu'             => array(
                    'first-path' => 'plugins.php',
                    'support'    => false,
                ),
                'is_live'          => true,
            ) );
        }
        return $tcmn_fs;
    }

}
/**
 * Check if the parent's init SDK method exists.
 *
 * @return bool
 */
function tcmn_fs_is_parent_active_and_loaded() {
    return function_exists( 'Tickera\\tets_fs' );
}

function tcmn_fs_is_parent_active() {
    $active_plugins = get_option( 'active_plugins', array() );
    if ( is_multisite() ) {
        $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() );
        $active_plugins = array_merge( $active_plugins, array_keys( $network_active_plugins ) );
    }
    foreach ( $active_plugins as $basename ) {
        if ( 0 === strpos( $basename, 'tickera-event-ticketing-system/' ) || 0 === strpos( $basename, 'tickera/' ) ) {
            return true;
        }
    }
    return false;
}

function tcmn_fs_init() {
    if ( tcmn_fs_is_parent_active_and_loaded() ) {
        /*
         * Parent is active, add your init code here.
         * Init Freemius.
         */
        tcmn_fs();
        if ( !tcmn_fs()->can_use_premium_code() ) {
            return;
        }
    } else {
        // Parent is inactive, add your error handling here.
    }
}

if ( tcmn_fs_is_parent_active_and_loaded() ) {
    // If parent already included, init add-on.
    tcmn_fs_init();
} else {
    if ( tcmn_fs_is_parent_active() ) {
        // Init add-on only after the parent is loaded.
        add_action( 'tets_fs_loaded', 'tcmn_fs_init' );
    } else {
        // Even though the parent is not activated, execute add-on for activation / uninstall hooks.
        tcmn_fs_init();
    }
}
if ( !class_exists( 'TC_Mailchimp' ) ) {
    class TC_Mailchimp {
        var $plugin_name = 'mailchimp';

        var $admin_name = 'Mailchimp';

        var $public_name = 'Mailchimp';

        var $version = '1.3';

        var $title = 'Tickera Mailchimp';

        var $name = 'tc';

        var $dir_name = 'tickera-mailchimp';

        var $location = 'plugins';

        var $plugin_dir = '';

        var $plugin_url = '';

        var $language = '';

        var $general_settings = '';

        var $mc_settings = '';

        var $mc_newsletter_enabled = '';

        var $mc_confirmation_enabled = '';

        var $mc_confirmation_label = '';

        var $mc_api_key = '';

        var $mc_server_prefix = '';

        var $mc_list_id = '';

        var $mc_double_optin = '';

        var $mc_welcome_email = '';

        var $mc_emails_to_collect = '';

        var $mc_tag = '';

        var $mailchimp = '';

        function __construct() {
            self::init();
            add_action( 'init', array($this, 'localization'), 10 );
            add_action( 'activated_plugin', array($this, 'plugin_dependencies'), 99 );
            add_filter( 'tc_settings_new_menus', array($this, 'tc_settings_new_menus_additional') );
            add_action( 'tc_settings_menu_tickera_mailchimp', array($this, 'tc_settings_menu_tickera_mailchimp_show_page') );
            // Render confirmation checkbox field in cart page.
            if ( $this->mc_newsletter_enabled && $this->mc_confirmation_enabled ) {
                add_action( 'tc_before_cart_submit', array($this, 'add_mailchimp_field') );
            }
            if ( $this->mc_confirmation_enabled ) {
                add_action( 'tc_cart_passed_successfully', array($this, 'check_confirmation'), 0 );
                add_action( 'woocommerce_checkout_process', array($this, 'check_confirmation') );
            }
            // Tickera Standalone
            add_action( 'tc_order_created', array($this, 'subscribe_to_mailchimp') );
            // Tickera running alongside Bridge for Woocommerce + Woocommerce
            add_action( 'woocommerce_new_order', array($this, 'subscribe_to_mailchimp'), 20 );
            add_action( 'woocommerce_resume_order', array($this, 'subscribe_to_mailchimp'), 20 );
            add_action( 'woocommerce_api_create_order', array($this, 'subscribe_to_mailchimp'), 20 );
            // Woocommerce Blocks Integration
            add_filter( 'tcwb_checkout_blocks_cart_data', array($this, 'woocommerce_blocks_integration') );
            add_action(
                'woocommerce_store_api_checkout_update_order_from_request',
                array($this, 'woocommerce_store_api_checkout'),
                10,
                2
            );
            add_filter( 'tc_delete_info_plugins_list', array($this, 'tc_delete_info_plugins_list') );
            add_action( 'tc_delete_plugins_data', array($this, 'tc_delete_plugins_data') );
        }

        function init() {
            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/mailchimp-newsletter/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/mailchimp-newsletter/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );
            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;
            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
            require_once 'includes/mailchimp/Mailchimp.php';
            $this->admin_name = __( 'Mailchimp', 'tc-mailchimp' );
            $this->public_name = __( 'Mailchimp', 'tc-mailchimp' );
            $this->general_settings = get_option( 'tickera_general_setting' );
            $this->mc_settings = get_option( 'tc_mailchimp_settings' );
            $this->mc_newsletter_enabled = ( isset( $this->mc_settings['enable_mailchimp_newsletter'] ) && 'yes' == $this->mc_settings['enable_mailchimp_newsletter'] ? true : false );
            $this->mc_confirmation_enabled = ( isset( $this->mc_settings['enable_confirmation'] ) && $this->mc_settings['enable_confirmation'] ? true : false );
            $this->mc_confirmation_label = ( isset( $this->mc_settings['confirmation_label'] ) ? sprintf( 
                /* translators: %s: Confirmation Label. */
                __( '%s', 'tc-mailchimp' ),
                esc_html( $this->mc_settings['confirmation_label'] )
             ) : __( 'Sign-up to our newsletter.', 'tc-mailchimp' ) );
            $this->mc_api_key = ( isset( $this->mc_settings['api_key'] ) ? $this->mc_settings['api_key'] : '' );
            $this->mc_server_prefix = ( isset( $this->mc_settings['server_prefix'] ) ? $this->mc_settings['server_prefix'] : '' );
            $this->mc_list_id = ( isset( $this->mc_settings['list_id'] ) ? $this->mc_settings['list_id'] : '' );
            $this->mc_double_optin = ( isset( $this->mc_settings['double_optin'] ) ? $this->mc_settings['double_optin'] : false );
            $this->mc_welcome_email = ( isset( $this->mc_settings['send_welcome'] ) ? $this->mc_settings['send_welcome'] : false );
            $this->mc_emails_to_collect = ( isset( $this->mc_settings['tc_emails_to_collect'] ) ? $this->mc_settings['tc_emails_to_collect'] : false );
            $this->mc_tag = ( isset( $this->mc_settings['tag'] ) ? $this->mc_settings['tag'] : 'event' );
        }

        /**
         * Plugin localization function
         * Load up the localization file if we're using WordPress in a different language
         * Place it in this plugin's "languages" folder and name it "tc-[value in wp-config].mo"
         */
        function localization() {
            if ( 'mu-plugins' == $this->location ) {
                load_muplugin_textdomain( 'tc-mailchimp', 'languages/' );
            } elseif ( 'subfolder-plugins' == $this->location ) {
                load_plugin_textdomain( 'tc-mailchimp', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
            } elseif ( 'plugins' == $this->location ) {
                load_plugin_textdomain( 'tc-mailchimp', false, 'languages/' );
            }
            $temp_locales = explode( '_', get_locale() );
            $this->language = ( $temp_locales[0] ? $temp_locales[0] : 'en' );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {
            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );
            if ( $index !== false ) {
                unset($active_plugins[$index]);
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Woocommerce Block Integrtion
         *
         * @param $data
         * @return array
         */
        function woocommerce_blocks_integration( $data ) {
            if ( $this->mc_confirmation_enabled && $this->mc_newsletter_enabled ) {
                $data['extra_fields'][] = [
                    'field_name'   => 'tc_mailchimp_subscribe',
                    'field_type'   => 'checkbox',
                    'field_values' => [[
                        'value' => 'yes',
                        'label' => $this->mc_confirmation_label,
                    ]],
                    'required'     => false,
                ];
            }
            return $data;
        }

        /**
         * @param WC_Order $order
         * @param WP_REST_Request $request
         * @return void
         */
        function woocommerce_store_api_checkout( \WC_Order $order, \WP_REST_Request $request ) {
            $extension_checkout_fields = ( isset( $request['extensions']['tickera/checkout-fields'] ) ? $request['extensions']['tickera/checkout-fields'] : [] );
            if ( isset( $extension_checkout_fields['tc_mailchimp_subscribe_post_meta'] ) && 'yes' == $extension_checkout_fields['tc_mailchimp_subscribe_post_meta'] ) {
                self::subscribe_to_mailchimp( $order->get_id(), true );
            }
        }

        /**
         * Render Mailchimp Admin Configuration Page
         */
        function tc_settings_menu_tickera_mailchimp_show_page() {
            require_once 'includes/admin-pages/settings-tickera_mailchimp.php';
        }

        function tc_delete_info_plugins_list( $plugins ) {
            $plugins[$this->name] = $this->title;
            return $plugins;
        }

        /**
         * Remove all related options.
         *
         * @param $submitted_data
         */
        function tc_delete_plugins_data( $submitted_data ) {
            if ( array_key_exists( $this->name, $submitted_data ) ) {
                $options = ['tc_mailchimp_settings'];
                foreach ( $options as $option ) {
                    delete_option( $option );
                }
            }
        }

        /**
         * Check if confirmation is needed get_option etc.
         * Require Confirmation
         */
        function check_confirmation() {
            global $tc;
            $tc->session->set( 'tc_mailchimp_confirmed_subscription', ( isset( $_POST['tc-mailchimp-subscribe'] ) ? true : false ) );
        }

        /**
         * Additional Mailchimp Menu in Tickera > Settings
         *
         * @param $settings_tabs
         * @return mixed
         */
        function tc_settings_new_menus_additional( $settings_tabs ) {
            $settings_tabs['tickera_mailchimp'] = __( 'Mailchimp', 'tc' );
            return $settings_tabs;
        }

        /**
         * Render checkbox field in checkout page.
         */
        function add_mailchimp_field() {
            $tc_mailchimp_settings = get_option( 'tc_mailchimp_settings' );
            ?>
            <label><input type="checkbox" name="tc-mailchimp-subscribe" value="1" <?php 
            echo apply_filters( 'tc_mailchimp_checked', '' );
            ?> /> <?php 
            echo esc_html( ( isset( $tc_mailchimp_settings['confirmation_label'] ) ? sprintf( 
                /* translators: %s: Confirmation Label */
                __( '%s', 'tc-mailchimp' ),
                esc_html( $tc_mailchimp_settings['confirmation_label'] )
             ) : __( 'Sign-up to our newsletter.', 'tc-mailchimp' ) ) );
            ?></label>
        <?php 
        }

        function subscribe_to_mailchimp( $order_id, $confirmed = false ) {
            global $tc;
            if ( !$confirmed ) {
                $confirmed = $tc->session->get( 'tc_mailchimp_confirmed_subscription' );
                $confirmed = ( $confirmed ? $confirmed : false );
            }
            if ( $this->mc_confirmation_enabled && !$confirmed ) {
                return false;
            }
            $post = tickera_get_order_id_by_name( $order_id );
            $post_id = ( isset( $post->ID ) ? $post->ID : false );
            $order_id = ( $post_id ? $post_id : $order_id );
            $this->process_subscription( $order_id );
        }

        /**
         * Subscribe buyer/owner to Mailchimp list
         *
         * @param $order_id
         */
        private function process_subscription( $order_id ) {
            if ( $this->mc_api_key && $this->mc_newsletter_enabled ) {
                $mailchimp = new TC_Mailchimp_API();
                if ( $mailchimp->verify_connection() && $this->mc_list_id ) {
                    $buyer_ticket_ids = [];
                    $cart_info = self::cart_info( $order_id );
                    $tickets = self::get_data( $order_id, 'ticket_type_id', 'owner' );
                    $tickets = ( is_array( $tickets ) ? $tickets : [] );
                    foreach ( $tickets as $ticket_type_id => $ticket_type_ids ) {
                        $event_id = get_post_meta( $ticket_type_id, apply_filters( 'tc_event_name_field_name', 'event_name' ), true );
                        $event = new Tickera\TC_Event($event_id);
                        $ticket = new Tickera\TC_Ticket($ticket_type_id);
                        foreach ( $ticket_type_ids as $key => $id ) {
                            $buyer_ticket_ids[] = (int) $ticket_type_id;
                            if ( isset( $this->general_settings['show_owner_email_field'] ) && 'yes' == $this->general_settings['show_owner_email_field'] ) {
                                if ( !$this->mc_emails_to_collect || 'owner_emails' == $this->mc_emails_to_collect || 'both_emails' == $this->mc_emails_to_collect ) {
                                    $owner_first_name = self::get_data( $order_id, 'first_name', 'owner' )[$ticket_type_id][$key];
                                    $owner_last_name = self::get_data( $order_id, 'last_name', 'owner' )[$ticket_type_id][$key];
                                    $owner_email = self::get_data( $order_id, 'owner_email', 'owner' )[$ticket_type_id][$key];
                                    if ( filter_var( $owner_email, FILTER_VALIDATE_EMAIL ) ) {
                                        $merge_fields = apply_filters(
                                            'tc_owner_merge_fields',
                                            [
                                                'FNAME'  => $owner_first_name,
                                                'LNAME'  => $owner_last_name,
                                                'TICKET' => $event->details->post_title . ' - ' . $ticket->details->post_title,
                                            ],
                                            @$cart_info,
                                            $ticket,
                                            $event
                                        );
                                        $member_data = [
                                            'email_type'    => 'html',
                                            'status'        => 'subscribed',
                                            'email_address' => $owner_email,
                                            'merge_fields'  => $merge_fields,
                                        ];
                                        if ( $this->mc_double_optin ) {
                                            $member_data['status'] = 'pending';
                                        }
                                        $mailchimp->subscribe( $this->mc_list_id, $member_data );
                                        // Update member's tags
                                        $mailchimp->update_members_tags( $this->mc_list_id, $owner_email, self::get_member_tags( $order_id, [$ticket_type_id] ) );
                                    }
                                }
                            }
                        }
                    }
                    if ( !$this->mc_emails_to_collect || 'buyer_emails' == $this->mc_emails_to_collect || 'both_emails' == $this->mc_emails_to_collect ) {
                        $buyer_first_name = self::get_data( $order_id, 'first_name' );
                        $buyer_last_name = self::get_data( $order_id, 'last_name' );
                        $buyer_email = self::get_data( $order_id, 'email' );
                        if ( filter_var( $buyer_email, FILTER_VALIDATE_EMAIL ) ) {
                            $merge_fields = apply_filters( 'tc_buyer_merge_fields', [
                                'FNAME' => $buyer_first_name,
                                'LNAME' => $buyer_last_name,
                            ], @$cart_info );
                            $member_data = [
                                'email_type'    => 'html',
                                'status'        => 'subscribed',
                                'email_address' => $buyer_email,
                                'merge_fields'  => $merge_fields,
                            ];
                            if ( $this->mc_double_optin ) {
                                $member_data['status'] = 'pending';
                            }
                            $mailchimp->subscribe( $this->mc_list_id, $member_data );
                            // Update member's tags
                            $mailchimp->update_members_tags( $this->mc_list_id, $buyer_email, self::get_member_tags( $order_id, $buyer_ticket_ids ) );
                        }
                    }
                }
            }
        }

        /**
         * Retrieve Tickera Cart Info Field Values
         *
         * @param $order_id
         * @param $field
         * @param string $type buyer or owner
         * @return bool|string
         */
        private function get_data( $order_id, $field, $type = 'buyer' ) {
            $cart_info = self::cart_info( $order_id );
            if ( self::is_bridge_for_woocommerce_active() ) {
                if ( 'buyer' == $type ) {
                    if ( isset( $cart_info['billing_' . $field] ) ) {
                        return $cart_info['billing_' . $field];
                    } else {
                        $order = wc_get_order( $order_id );
                        return ( method_exists( $order, 'get_billing_' . $field ) ? $order->{'get_billing_' . $field}() : '' );
                    }
                } elseif ( 'owner' == $type && isset( $cart_info['owner_data_' . $field . '_post_meta'] ) ) {
                    return $cart_info['owner_data_' . $field . '_post_meta'];
                } elseif ( 'owner' == $type && isset( $cart_info['owner_data']['owner_data_' . $field . '_post_meta'] ) ) {
                    return $cart_info['owner_data']['owner_data_' . $field . '_post_meta'];
                } else {
                    return false;
                }
            } else {
                if ( 'buyer' == $type && isset( $cart_info['buyer_data'] ) ) {
                    return ( isset( $cart_info['buyer_data'][$field . '_post_meta'] ) ? $cart_info['buyer_data'][$field . '_post_meta'] : '' );
                } elseif ( 'owner' == $type && isset( $cart_info['owner_data'] ) ) {
                    return ( isset( $cart_info['owner_data'][$field . '_post_meta'] ) ? $cart_info['owner_data'][$field . '_post_meta'] : '' );
                } else {
                    return false;
                }
            }
        }

        /**
         * Collect subscriber's tags from cart_info data
         *
         * @param $order_id
         * @param $ticket_type_ids array
         * @return array
         *
         * @since 1.4.4
         */
        private function get_member_tags( $order_id, $ticket_type_ids ) {
            $tags = [];
            foreach ( $ticket_type_ids as $ticket_type_id ) {
                // Check for a Woocommerce variable ID
                if ( 'product_variation' == get_post_type( $ticket_type_id ) ) {
                    $ticket_type_id = wp_get_post_parent_id( $ticket_type_id );
                }
                $event_id = get_post_meta( $ticket_type_id, apply_filters( 'tc_event_name_field_name', 'event_name' ), true );
                $event = new Tickera\TC_Event($event_id);
                $title = $event->details->post_title;
                $date = $event->get_event_date();
                $ticket = new Tickera\TC_Ticket($ticket_type_id);
                if ( 'event' == $this->mc_tag ) {
                    $tags[] = [
                        'name'   => $title . ' – ' . $date,
                        'status' => 'active',
                    ];
                } else {
                    $tags[] = [
                        'name'   => $ticket->details->post_title . ' (' . $title . ' – ' . $date . ')',
                        'status' => 'active',
                    ];
                }
            }
            return apply_filters(
                'tc_mc_subscriber_tags',
                $tags,
                $ticket_type_ids,
                self::cart_info( $order_id )
            );
        }

        /**
         * Collection of Cart Info
         *
         * @return array|mixed
         */
        private function cart_info( $order_id ) {
            global $tc;
            $cart_info = $tc->session->get( 'cart_info' );
            $cart_info = ( $cart_info ? $cart_info : [] );
            if ( isset( $_POST['woocommerce-process-checkout-nonce'] ) ) {
                $cart_info = $_POST;
            }
            if ( !$cart_info ) {
                $cart_info = get_post_meta( $order_id, 'tc_cart_info', true );
            }
            return $cart_info;
        }

        /**
         * Check for Bridge for Woocommerce and Woocommerce dependencies
         *
         * @return bool
         */
        private function is_bridge_for_woocommerce_active() {
            return ( true == apply_filters( 'tc_bridge_for_woocommerce_is_active', false ) || class_exists( 'TC_WooCommerce_Bridge' ) ? true : false );
        }

    }

}
if ( !function_exists( 'is_plugin_active_for_network' ) ) {
    require_once ABSPATH . '/wp-admin/includes/plugin.php';
}
/*if( tcmn_fs_is_parent_active_and_loaded() && tcmn_fs()->can_use_premium_code() ){
  if ( is_multisite() && is_plugin_active_for_network( plugin_basename(__FILE__) ) ) {

      function tc_mailchimp_load() {
          global $tc_mailchimp;
          $tc_mailchimp = new TC_Mailchimp();
      }
      add_action( 'tets_fs_loaded', 'tc_mailchimp_load' );

  } else {*/
$tc_mailchimp = new TC_Mailchimp();
/*}
}*/